package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Inspector;
import com.ejie.y41a.model.Tipodoc;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Acta;

/**
 * * ActaDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class ActaDaoImpl implements ActaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Acta> rwMap = new RowMapper<Acta>() {
		public Acta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Acta(
					resultSet.getString("ACCODIGO"),
					resultSet.getString("ACCOOR"),
					resultSet.getString("ACNROR"),
					resultSet.getBigDecimal("ACNRAN"),
					resultSet.getDate("ACFELE"),
					resultSet.getDate("ACFERE"),
					resultSet.getString("ACCOAV"),
					resultSet.getString("ACCOSE"),
					resultSet.getDate("ACFEEX"),
					resultSet.getString("ACINRE"),
					resultSet.getString("ACNOCO"),
					resultSet.getString("ACAPE1CO"),
					resultSet.getString("ACAPE2CO"),
					resultSet.getString("ACDNICO"),
					resultSet.getString("ACCOCO"),
					resultSet.getString("ACDIRCO"),
					resultSet.getString("ACCOLOCO"),
					resultSet.getString("ACNRCPCO"),
					resultSet.getString("ACNRTFCO"),
					resultSet.getString("ACNORAPAISID"),
					resultSet.getString("ACNORAPAISNOMBRE"),
					resultSet.getString("ACNORAPROVINCIAID"),
					resultSet.getString("ACNOMBREPROVINCIA"),
					resultSet.getString("ACNORAMUNICIPIOID"),
					resultSet.getString("ACNOMBREMUNICIPIO"),
					resultSet.getString("ACNORALOCALIDADID"),
					resultSet.getString("ACNOMBRELOCALIDAD"),
					resultSet.getString("ACNORACALLEID"),
					resultSet.getString("ACNOMBRECALLE"),
					resultSet.getString("ACNORACPID"),
					resultSet.getString("ACNOMBRECP"),
					resultSet.getString("ACNORAPORTALID"),
					resultSet.getString("ACNOMBREPORTAL"),
					resultSet.getString("ACNOMBREPISO"),
					resultSet.getString("ACDIRECCIONNOCAPV"),
					new Inspector(resultSet.getString("InspectorINCODIGO"),
							resultSet.getString("InspectorINNOMBRE"), resultSet
									.getString("InspectorINCOOR")),
					new Inspector(resultSet.getString("InspectorINCODIGO"),
							resultSet.getString("InspectorINNOMBRE"), resultSet
									.getString("InspectorINCOOR")),
					new Tipodoc(resultSet.getString("TipodocTDCODIGO"),
							resultSet.getString("TipodocTDNOMBRE")),
					new Establecimiento(
							resultSet.getString("EstablecimientoESCODIGO"),
							resultSet.getString("EstablecimientoESNOMBRE"),
							resultSet.getString("EstablecimientoESNIF"),
							resultSet.getString("EstablecimientoESNOAN"),
							resultSet.getString("EstablecimientoESNOCO"),
							resultSet.getString("EstablecimientoESNODIR"),
							resultSet.getString("EstablecimientoESCOLO"),
							resultSet.getString("EstablecimientoESNRCOPO"),
							resultSet.getString("EstablecimientoESNRTEL"),
							resultSet.getString("EstablecimientoESNRFAX"),
							resultSet.getString("EstablecimientoESCOPA"),
							resultSet.getString("EstablecimientoESINCAPR"),
							resultSet.getString("EstablecimientoESINDEMP"),
							resultSet.getString("EstablecimientoESTECO"),
							resultSet.getString("EstablecimientoESINADAR"),
							resultSet.getDate("EstablecimientoESFEADAR"),
							resultSet.getString("EstablecimientoESCOEM"),
							resultSet.getString("EstablecimientoESINEMPR"),
							resultSet.getString("EstablecimientoESNRTEL2"),
							resultSet.getDate("EstablecimientoESFEBA"),
							resultSet.getString("EstablecimientoESNOAP1"),
							resultSet.getString("EstablecimientoESNOAP2"),
							resultSet.getString("EstablecimientoESNOLO"),
							resultSet.getString("EstablecimientoESCOMAPV"),
							resultSet.getString("EstablecimientoESCOCA"),
							resultSet.getString("EstablecimientoESNOPECO"),
							resultSet.getString("EstablecimientoESCOIDCO"),
							resultSet.getString("EstablecimientoESINRECO"),
							resultSet.getString("EstablecimientoESFEMOD"),
							resultSet.getString("EstablecimientoESINESCO"),
							resultSet.getString("EstablecimientoESNOMU"),
							resultSet.getString("EstablecimientoESNOREP"),
							resultSet.getString("EstablecimientoESNIFREP"),
							resultSet.getString("EstablecimientoDTTEEMR"),
							resultSet.getString("EstablecimientoESCAREP"),
							resultSet.getString("EstablecimientoESTEURL"),
							resultSet.getString("EstablecimientoESCOOE"),
							resultSet.getString("EstablecimientoESNODECO"),
							resultSet.getString("EstablecimientoESINTIAR"),
							resultSet.getDate("EstablecimientoESFEPLAD"),
							resultSet.getString("EstablecimientoESINDEME"),
							resultSet.getString("EstablecimientoESNORAPAISID"),
							resultSet.getString("ESTABLEESNORAPAISNOMBRE"),
							resultSet.getString("ESTABLEESNORAPROVINCIAID"),
							resultSet.getString("ESTABLEESNOMBREPROVINCIA"),
							resultSet.getString("ESTABLEESNORAMUNICIPIOID"),
							resultSet.getString("ESTABLEESNOMBREMUNICIPIO"),
							resultSet.getString("ESTABLEESNORALOCALIDADID"),
							resultSet.getString("ESTABLEESNOMBRELOCALIDAD"),
							resultSet.getString("EstablecimientoESNORACALLEID"),
							resultSet.getString("EstablecimientoESNOMBRECALLE"),
							resultSet.getString("EstablecimientoESNORACPID"),
							resultSet.getString("EstablecimientoESNOMBRECP"),
							resultSet
									.getString("EstablecimientoESNORAPORTALID"),
							resultSet
									.getString("EstablecimientoESNOMBREPORTAL"),
							resultSet.getString("EstablecimientoESNOMBREPISO"),
							resultSet.getString("EstableESDIRECCION_NOCAPV"),
							resultSet.getString("EstableESEXTRANJERO"), null,
							new CensoMonitor(resultSet
									.getString("EstablecimientoESCOZS"), null,
									null, null, null, null, null, null, null,
									null, null, null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	public Acta add(Acta acta) {

		String query = "INSERT INTO ACTA( ACCODIGO,ACCOINDO,ACCOINUN,ACCOTD,ACCOES,ACCOOR,ACNROR,ACNRAN,ACFELE,ACFERE,ACCOAV,ACCOSE,ACFEEX,ACINRE,ACNOCO,ACAPE1CO,ACAPE2CO,ACDNICO,ACCOCO,ACDIRCO,ACCOLOCO,ACNRCPCO,ACNRTFCO,ACNORA_PAIS_ID,ACNORA_PAIS_NOMBRE,ACNORA_PROVINCIA_ID,ACNOMBRE_PROVINCIA,ACNORA_MUNICIPIO_ID,ACNOMBRE_MUNICIPIO,ACNORA_LOCALIDAD_ID,ACNOMBRE_LOCALIDAD,ACNORA_CALLE_ID,ACNOMBRE_CALLE,ACNORA_CP_ID,ACNOMBRE_CP,ACNORA_PORTAL_ID,ACNOMBRE_PORTAL,ACNOMBRE_PISO,ACDIRECCION_NOCAPV)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getInspectorByAccoindoIncodigoAux = null;
		if (acta.getInspectorByAccoindo() != null
				&& acta.getInspectorByAccoindo().getIncodigo() != null) {
			getInspectorByAccoindoIncodigoAux = acta.getInspectorByAccoindo()
					.getIncodigo();
		}
		Object getInspectorByAccoinunIncodigoAux = null;
		if (acta.getInspectorByAccoinun() != null
				&& acta.getInspectorByAccoinun().getIncodigo() != null) {
			getInspectorByAccoinunIncodigoAux = acta.getInspectorByAccoinun()
					.getIncodigo();
		}
		Object getTipodocTdcodigoAux = null;
		if (acta.getTipodoc() != null
				&& acta.getTipodoc().getTdcodigo() != null) {
			getTipodocTdcodigoAux = acta.getTipodoc().getTdcodigo();
		}
		Object getEstablecimientoEscodigoAux = null;
		if (acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = acta.getEstablecimiento()
					.getEscodigo();
		}
		this.jdbcTemplate.update(query, acta.getAccodigo(),
				getInspectorByAccoindoIncodigoAux,
				getInspectorByAccoinunIncodigoAux, getTipodocTdcodigoAux,
				getEstablecimientoEscodigoAux, acta.getAccoor(),
				acta.getAcnror(), acta.getAcnran(), acta.getAcfele(),
				acta.getAcfere(), acta.getAccoav(), acta.getAccose(),
				acta.getAcfeex(), acta.getAcinre(), acta.getAcnoco(),
				acta.getAcape1co(), acta.getAcape2co(), acta.getAcdnico(),
				acta.getAccoco(), acta.getAcdirco(), acta.getAccoloco(),
				acta.getAcnrcpco(), acta.getAcnrtfco(), acta.getAcnoraPaisId(),
				acta.getAcnoraPaisNombre(), acta.getAcnoraProvinciaId(),
				acta.getAcnombreProvincia(), acta.getAcnoraMunicipioId(),
				acta.getAcnombreMunicipio(), acta.getAcnoraLocalidadId(),
				acta.getAcnombreLocalidad(), acta.getAcnoraCalleId(),
				acta.getAcnombreCalle(), acta.getAcnoraCpId(),
				acta.getAcnombreCp(), acta.getAcnoraPortalId(),
				acta.getAcnombrePortal(), acta.getAcnombrePiso(),
				acta.getAcdireccion_nocapv());
		return acta;
	}

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	public Acta update(Acta acta) {
		String query = "UPDATE ACTA SET ACCOINDO=?,ACCOINUN=?,ACCOTD=?,ACCOES=?,ACCOOR=?,ACNROR=?,ACNRAN=?,ACFELE=?,ACFERE=?,ACCOAV=?,ACCOSE=?,ACFEEX=?,ACINRE=?,ACNOCO=?,ACAPE1CO=?,ACAPE2CO=?,ACDNICO=?,ACCOCO=?,ACNRTFCO=?,ACNORA_PAIS_ID=?,ACNORA_PAIS_NOMBRE=?,ACNORA_PROVINCIA_ID=?,ACNOMBRE_PROVINCIA=?,ACNORA_MUNICIPIO_ID=?,ACNOMBRE_MUNICIPIO=?,ACNORA_LOCALIDAD_ID=?,ACNOMBRE_LOCALIDAD=?,ACNORA_CALLE_ID=?,ACNOMBRE_CALLE=?,ACNORA_CP_ID=?,ACNOMBRE_CP=?,ACNORA_PORTAL_ID=?,ACNOMBRE_PORTAL=?,ACNOMBRE_PISO=?,ACDIRECCION_NOCAPV=? WHERE ACCODIGO=?";
		Object getInspectorByAccoindoIncodigoAux = null;
		if (acta.getInspectorByAccoindo() != null
				&& acta.getInspectorByAccoindo().getIncodigo() != null) {
			getInspectorByAccoindoIncodigoAux = acta.getInspectorByAccoindo()
					.getIncodigo();
		}
		Object getInspectorByAccoinunIncodigoAux = null;
		if (acta.getInspectorByAccoinun() != null
				&& acta.getInspectorByAccoinun().getIncodigo() != null) {
			getInspectorByAccoinunIncodigoAux = acta.getInspectorByAccoinun()
					.getIncodigo();
		}
		Object getTipodocTdcodigoAux = null;
		if (acta.getTipodoc() != null
				&& acta.getTipodoc().getTdcodigo() != null) {
			getTipodocTdcodigoAux = acta.getTipodoc().getTdcodigo();
		}
		Object getEstablecimientoEscodigoAux = null;
		if (acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = acta.getEstablecimiento()
					.getEscodigo();
		}
		this.jdbcTemplate.update(query, getInspectorByAccoindoIncodigoAux,
				getInspectorByAccoinunIncodigoAux, getTipodocTdcodigoAux,
				getEstablecimientoEscodigoAux, acta.getAccoor(),
				acta.getAcnror(), acta.getAcnran(), acta.getAcfele(),
				acta.getAcfere(), acta.getAccoav(), acta.getAccose(),
				acta.getAcfeex(), acta.getAcinre(), acta.getAcnoco(),
				acta.getAcape1co(), acta.getAcape2co(), acta.getAcdnico(),
				acta.getAccoco(), acta.getAcnrtfco(), acta.getAcnoraPaisId(),
				acta.getAcnoraPaisNombre(), acta.getAcnoraProvinciaId(),
				acta.getAcnombreProvincia(), acta.getAcnoraMunicipioId(),
				acta.getAcnombreMunicipio(), acta.getAcnoraLocalidadId(),
				acta.getAcnombreLocalidad(), acta.getAcnoraCalleId(),
				acta.getAcnombreCalle(), acta.getAcnoraCpId(),
				acta.getAcnombreCp(), acta.getAcnoraPortalId(),
				acta.getAcnombrePortal(), acta.getAcnombrePiso(),
				acta.getAcdireccion_nocapv(), acta.getAccodigo());
		return acta;
	}

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	public Acta updateEstablecimiento(Acta acta) {
		String query = "UPDATE ACTA SET ACCOES=? WHERE ACCODIGO=?";

		Object getEstablecimientoEscodigoAux = null;
		if (acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = acta.getEstablecimiento()
					.getEscodigo();
		}
		this.jdbcTemplate.update(query, getEstablecimientoEscodigoAux,
				acta.getAccodigo());
		return acta;
	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return Acta
	 */
	@Transactional(readOnly = true)
	public Acta find(Acta acta) {
		String query = "SELECT t1.ACCODIGO ACCODIGO, t1.ACCOOR ACCOOR, t1.ACNROR ACNROR, t1.ACNRAN ACNRAN, t1.ACFELE ACFELE, t1.ACFERE ACFERE, t1.ACCOAV ACCOAV, t1.ACCOSE ACCOSE, t1.ACFEEX ACFEEX, t1.ACINRE ACINRE, t1.ACNOCO ACNOCO,t1.ACAPE1CO ACAPE1CO,t1.ACAPE2CO ACAPE2CO, t1.ACDNICO ACDNICO, t1.ACCOCO ACCOCO, t1.ACDIRCO ACDIRCO, t1.ACCOLOCO ACCOLOCO, t1.ACNRCPCO ACNRCPCO, t1.ACNRTFCO ACNRTFCO, t1.ACNORA_PAIS_ID ACNORAPAISID, t1.ACNORA_PAIS_NOMBRE ACNORAPAISNOMBRE, t1.ACNORA_PROVINCIA_ID ACNORAPROVINCIAID, t1.ACNOMBRE_PROVINCIA ACNOMBREPROVINCIA, t1.ACNORA_MUNICIPIO_ID ACNORAMUNICIPIOID, t1.ACNOMBRE_MUNICIPIO ACNOMBREMUNICIPIO, t1.ACNORA_LOCALIDAD_ID ACNORALOCALIDADID, t1.ACNOMBRE_LOCALIDAD ACNOMBRELOCALIDAD, t1.ACNORA_CALLE_ID ACNORACALLEID, t1.ACNOMBRE_CALLE ACNOMBRECALLE, t1.ACNORA_CP_ID ACNORACPID, t1.ACNOMBRE_CP ACNOMBRECP, t1.ACNORA_PORTAL_ID ACNORAPORTALID, t1.ACNOMBRE_PORTAL ACNOMBREPORTAL, t1.ACNOMBRE_PISO ACNOMBREPISO, t1.ACDIRECCION_NOCAPV ACDIRECCIONNOCAPV, t2.INCODIGO INSPECTORINCODIGO, t2.INNOMBRE INSPECTORINNOMBRE, t2.INCOOR INSPECTORINCOOR, t3.INCODIGO INSPECTORINCODIGO, t3.INNOMBRE INSPECTORINNOMBRE, t3.INCOOR INSPECTORINCOOR, t4.TDCODIGO TIPODOCTDCODIGO, t4.TDNOMBRE TIPODOCTDNOMBRE, t5.ESCODIGO ESTABLECIMIENTOESCODIGO, t5.ESNOMBRE ESTABLECIMIENTOESNOMBRE, t5.ESNIF ESTABLECIMIENTOESNIF, t5.ESNOAN ESTABLECIMIENTOESNOAN, t5.ESNOCO ESTABLECIMIENTOESNOCO, t5.ESNODIR ESTABLECIMIENTOESNODIR, t5.ESCOLO ESTABLECIMIENTOESCOLO, t5.ESNRCOPO ESTABLECIMIENTOESNRCOPO, t5.ESNRTEL ESTABLECIMIENTOESNRTEL, t5.ESNRFAX ESTABLECIMIENTOESNRFAX, t5.ESCOPA ESTABLECIMIENTOESCOPA, t5.ESINCAPR ESTABLECIMIENTOESINCAPR, t5.ESINDEMP ESTABLECIMIENTOESINDEMP, t5.ESTECO ESTABLECIMIENTOESTECO, t5.ESINADAR ESTABLECIMIENTOESINADAR, t5.ESFEADAR ESTABLECIMIENTOESFEADAR, t5.ESCOEM ESTABLECIMIENTOESCOEM, t5.ESINEMPR ESTABLECIMIENTOESINEMPR, t5.ESNRTEL2 ESTABLECIMIENTOESNRTEL2, t5.ESFEBA ESTABLECIMIENTOESFEBA, t5.ESNOAP1 ESTABLECIMIENTOESNOAP1, t5.ESNOAP2 ESTABLECIMIENTOESNOAP2, t5.ESNOLO ESTABLECIMIENTOESNOLO, t5.ESCOMAPV ESTABLECIMIENTOESCOMAPV, t5.ESCOCA ESTABLECIMIENTOESCOCA, t5.ESNOPECO ESTABLECIMIENTOESNOPECO, t5.ESCOIDCO ESTABLECIMIENTOESCOIDCO, t5.ESINRECO ESTABLECIMIENTOESINRECO, t5.ESFEMOD ESTABLECIMIENTOESFEMOD, t5.ESINESCO ESTABLECIMIENTOESINESCO, t5.ESNOMU ESTABLECIMIENTOESNOMU, t5.ESNOREP ESTABLECIMIENTOESNOREP, t5.ESNIFREP ESTABLECIMIENTOESNIFREP, t5.DTTEEMR ESTABLECIMIENTODTTEEMR, t5.ESCAREP ESTABLECIMIENTOESCAREP, t5.ESTEURL ESTABLECIMIENTOESTEURL, t5.ESCOOE ESTABLECIMIENTOESCOOE, t5.ESNODECO ESTABLECIMIENTOESNODECO, t5.ESINTIAR ESTABLECIMIENTOESINTIAR, t5.ESFEPLAD ESTABLECIMIENTOESFEPLAD, t5.ESINDEME ESTABLECIMIENTOESINDEME, t5.ESNORA_PAIS_ID ESTABLECIMIENTOESNORAPAISID, t5.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE, t5.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID, t5.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA, t5.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID, t5.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO, t5.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID, t5.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD, t5.ESNORA_CALLE_ID ESTABLECIMIENTOESNORACALLEID, t5.ESNOMBRE_CALLE ESTABLECIMIENTOESNOMBRECALLE, t5.ESNORA_CP_ID ESTABLECIMIENTOESNORACPID, t5.ESNOMBRE_CP ESTABLECIMIENTOESNOMBRECP, t5.ESNORA_PORTAL_ID ESTABLECIMIENTOESNORAPORTALID, t5.ESNOMBRE_PORTAL ESTABLECIMIENTOESNOMBREPORTAL, t5.ESNOMBRE_PISO ESTABLECIMIENTOESNOMBREPISO, t5.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV, t5.ESEXTRANJERO EstableESEXTRANJERO,t5.ESCOZS ESTABLECIMIENTOESCOZS "
				+ "FROM ACTA t1 , INSPECTOR t2 , INSPECTOR t3 , TIPODOC t4 , ESTABLECIMIENTO t5  "
				+ "WHERE t1.ACCODIGO = ?   AND t1.ACCOINDO= t2.INCODIGO(+) AND t1.ACCOINUN= t3.INCODIGO(+) AND t1.ACCOTD= t4.TDCODIGO(+) AND t1.ACCOES= t5.ESCODIGO(+)  ";
		return (Acta) this.jdbcTemplate.queryForObject(query, rwMap,
				acta.getAccodigo());
	}

	/**
	 * Removes a single row in the Acta table.
	 * 
	 * @param acta
	 *            Pagination
	 * @return
	 */
	public void remove(Acta acta) {
		String query = "DELETE  FROM ACTA WHERE ACCODIGO=?";
		this.jdbcTemplate.update(query, acta.getAccodigo());
	}

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Acta> findAllActaEstablecimiento(Acta acta,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ACCOES= t2.ESCODIGO(+) 	");

		StringBuffer query = new StringBuffer("SELECT  t1.ACCODIGO ACCODIGO "
				+ "FROM ACTA t1,ESTABLECIMIENTO t2 ");

		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ESCODIGO = ?");
			params.add(acta.getEstablecimiento().getEscodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Acta>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<Acta>() {
					public Acta mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Acta(resultSet.getString("ACCODIGO"), null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, new Establecimiento());
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Acta> findAll(Acta acta, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ACCOINDO= t2.INCODIGO(+) AND t1.ACCOINUN= t3.INCODIGO(+) AND t1.ACCOTD= t4.TDCODIGO(+) AND t1.ACCOES= t5.ESCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ACCODIGO ACCODIGO,t1.ACCOOR ACCOOR,t1.ACNROR ACNROR,t1.ACNRAN ACNRAN,t1.ACFELE ACFELE,t1.ACFERE ACFERE,t1.ACCOAV ACCOAV,t1.ACCOSE ACCOSE,t1.ACFEEX ACFEEX,t1.ACINRE ACINRE,t1.ACNOCO ACNOCO,t1.ACAPE1CO ACAPE1CO,t1.ACAPE2CO ACAPE2CO,t1.ACDNICO ACDNICO,t1.ACCOCO ACCOCO,t1.ACDIRCO ACDIRCO,t1.ACCOLOCO ACCOLOCO,t1.ACNRCPCO ACNRCPCO,t1.ACNRTFCO ACNRTFCO,t1.ACNORA_PAIS_ID ACNORAPAISID,t1.ACNORA_PAIS_NOMBRE ACNORAPAISNOMBRE,t1.ACNORA_PROVINCIA_ID ACNORAPROVINCIAID,t1.ACNOMBRE_PROVINCIA ACNOMBREPROVINCIA,t1.ACNORA_MUNICIPIO_ID ACNORAMUNICIPIOID,t1.ACNOMBRE_MUNICIPIO ACNOMBREMUNICIPIO,t1.ACNORA_LOCALIDAD_ID ACNORALOCALIDADID,t1.ACNOMBRE_LOCALIDAD ACNOMBRELOCALIDAD,t1.ACNORA_CALLE_ID ACNORACALLEID,t1.ACNOMBRE_CALLE ACNOMBRECALLE,t1.ACNORA_CP_ID ACNORACPID,t1.ACNOMBRE_CP ACNOMBRECP,t1.ACNORA_PORTAL_ID ACNORAPORTALID,t1.ACNOMBRE_PORTAL ACNOMBREPORTAL,t1.ACNOMBRE_PISO ACNOMBREPISO, t1.ACDIRECCION_NOCAPV ACDIRECCIONNOCAPV,t2.INCODIGO INSPECTORINCODIGO,t2.INNOMBRE INSPECTORINNOMBRE,t2.INCOOR INSPECTORINCOOR,t3.INCODIGO INSPECTORINCODIGO,t3.INNOMBRE INSPECTORINNOMBRE,t3.INCOOR INSPECTORINCOOR,t4.TDCODIGO TIPODOCTDCODIGO,t4.TDNOMBRE TIPODOCTDNOMBRE,t5.ESCODIGO ESTABLECIMIENTOESCODIGO,t5.ESNOMBRE ESTABLECIMIENTOESNOMBRE,t5.ESNIF ESTABLECIMIENTOESNIF,t5.ESNOAN ESTABLECIMIENTOESNOAN,t5.ESNOCO ESTABLECIMIENTOESNOCO,t5.ESNODIR ESTABLECIMIENTOESNODIR,t5.ESCOLO ESTABLECIMIENTOESCOLO,t5.ESNRCOPO ESTABLECIMIENTOESNRCOPO,t5.ESNRTEL ESTABLECIMIENTOESNRTEL,t5.ESNRFAX ESTABLECIMIENTOESNRFAX,t5.ESCOPA ESTABLECIMIENTOESCOPA,t5.ESINCAPR ESTABLECIMIENTOESINCAPR,t5.ESINDEMP ESTABLECIMIENTOESINDEMP,t5.ESTECO ESTABLECIMIENTOESTECO,t5.ESINADAR ESTABLECIMIENTOESINADAR,t5.ESFEADAR ESTABLECIMIENTOESFEADAR,t5.ESCOEM ESTABLECIMIENTOESCOEM,t5.ESINEMPR ESTABLECIMIENTOESINEMPR,t5.ESNRTEL2 ESTABLECIMIENTOESNRTEL2,t5.ESFEBA ESTABLECIMIENTOESFEBA,t5.ESNOAP1 ESTABLECIMIENTOESNOAP1,t5.ESNOAP2 ESTABLECIMIENTOESNOAP2,t5.ESNOLO ESTABLECIMIENTOESNOLO,t5.ESCOMAPV ESTABLECIMIENTOESCOMAPV,t5.ESCOCA ESTABLECIMIENTOESCOCA,t5.ESNOPECO ESTABLECIMIENTOESNOPECO,t5.ESCOIDCO ESTABLECIMIENTOESCOIDCO,t5.ESINRECO ESTABLECIMIENTOESINRECO,t5.ESFEMOD ESTABLECIMIENTOESFEMOD,t5.ESINESCO ESTABLECIMIENTOESINESCO,t5.ESNOMU ESTABLECIMIENTOESNOMU,t5.ESNOREP ESTABLECIMIENTOESNOREP,t5.ESNIFREP ESTABLECIMIENTOESNIFREP,t5.DTTEEMR ESTABLECIMIENTODTTEEMR,t5.ESCAREP ESTABLECIMIENTOESCAREP,t5.ESTEURL ESTABLECIMIENTOESTEURL,t5.ESCOOE ESTABLECIMIENTOESCOOE,t5.ESNODECO ESTABLECIMIENTOESNODECO,t5.ESINTIAR ESTABLECIMIENTOESINTIAR,t5.ESFEPLAD ESTABLECIMIENTOESFEPLAD,t5.ESINDEME ESTABLECIMIENTOESINDEME,t5.ESNORA_PAIS_ID ESTABLECIMIENTOESNORAPAISID,t5.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE,t5.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID,t5.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA,t5.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID,t5.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO,t5.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID,t5.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD,t5.ESNORA_CALLE_ID ESTABLECIMIENTOESNORACALLEID,t5.ESNOMBRE_CALLE ESTABLECIMIENTOESNOMBRECALLE,t5.ESNORA_CP_ID ESTABLECIMIENTOESNORACPID,t5.ESNOMBRE_CP ESTABLECIMIENTOESNOMBRECP,t5.ESNORA_PORTAL_ID ESTABLECIMIENTOESNORAPORTALID,t5.ESNOMBRE_PORTAL ESTABLECIMIENTOESNOMBREPORTAL,t5.ESNOMBRE_PISO ESTABLECIMIENTOESNOMBREPISO, t5.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV,t5.ESEXTRANJERO EstableESEXTRANJERO,t5.ESCOZS ESTABLECIMIENTOESCOZS "
						+ "FROM ACTA t1 ,INSPECTOR t2 ,INSPECTOR t3 ,TIPODOC t4 ,ESTABLECIMIENTO t5 ");

		if (acta != null && acta.getAccodigo() != null) {
			where.append(" AND t1.ACCODIGO = ?");
			params.add(acta.getAccodigo());
		}
		if (acta != null && acta.getInspectorByAccoindo() != null
				&& acta.getInspectorByAccoindo().getIncodigo() != null) {
			where.append(" AND t2.INCODIGO = ?");
			params.add(acta.getInspectorByAccoindo().getIncodigo());
		}
		if (acta != null && acta.getInspectorByAccoindo() != null
				&& acta.getInspectorByAccoindo().getInnombre() != null) {
			where.append(" AND t2.INNOMBRE = ?");
			params.add(acta.getInspectorByAccoindo().getInnombre());
		}
		if (acta != null && acta.getInspectorByAccoindo() != null
				&& acta.getInspectorByAccoindo().getIncoor() != null) {
			where.append(" AND t2.INCOOR = ?");
			params.add(acta.getInspectorByAccoindo().getIncoor());
		}
		if (acta != null && acta.getInspectorByAccoinun() != null
				&& acta.getInspectorByAccoinun().getIncodigo() != null) {
			where.append(" AND t3.INCODIGO = ?");
			params.add(acta.getInspectorByAccoinun().getIncodigo());
		}
		if (acta != null && acta.getInspectorByAccoinun() != null
				&& acta.getInspectorByAccoinun().getInnombre() != null) {
			where.append(" AND t3.INNOMBRE = ?");
			params.add(acta.getInspectorByAccoinun().getInnombre());
		}
		if (acta != null && acta.getInspectorByAccoinun() != null
				&& acta.getInspectorByAccoinun().getIncoor() != null) {
			where.append(" AND t3.INCOOR = ?");
			params.add(acta.getInspectorByAccoinun().getIncoor());
		}
		if (acta != null && acta.getTipodoc() != null
				&& acta.getTipodoc().getTdcodigo() != null) {
			where.append(" AND t4.TDCODIGO = ?");
			params.add(acta.getTipodoc().getTdcodigo());
		}
		if (acta != null && acta.getTipodoc() != null
				&& acta.getTipodoc().getTdnombre() != null) {
			where.append(" AND t4.TDNOMBRE = ?");
			params.add(acta.getTipodoc().getTdnombre());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t5.ESCODIGO = ?");
			params.add(acta.getEstablecimiento().getEscodigo());
		}
		if (acta != null
				&& acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getCensoMonitor() != null
				&& acta.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t5.ESCOZS = ?");
			params.add(acta.getEstablecimiento().getCensoMonitor()
					.getMocodigo());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND t5.ESNOMBRE = ?");
			params.add(acta.getEstablecimiento().getEsnombre());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnif() != null) {
			where.append(" AND t5.ESNIF = ?");
			params.add(acta.getEstablecimiento().getEsnif());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND t5.ESNOAN = ?");
			params.add(acta.getEstablecimiento().getEsnoan());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND t5.ESNOCO = ?");
			params.add(acta.getEstablecimiento().getEsnoco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND t5.ESNODIR = ?");
			params.add(acta.getEstablecimiento().getEsnodir());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscolo() != null) {
			where.append(" AND t5.ESCOLO = ?");
			params.add(acta.getEstablecimiento().getEscolo());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND t5.ESNRCOPO = ?");
			params.add(acta.getEstablecimiento().getEsnrcopo());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND t5.ESNRTEL = ?");
			params.add(acta.getEstablecimiento().getEsnrtel());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND t5.ESNRFAX = ?");
			params.add(acta.getEstablecimiento().getEsnrfax());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscopa() != null) {
			where.append(" AND t5.ESCOPA = ?");
			params.add(acta.getEstablecimiento().getEscopa());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND t5.ESINCAPR = ?");
			params.add(acta.getEstablecimiento().getEsincapr());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND t5.ESINDEMP = ?");
			params.add(acta.getEstablecimiento().getEsindemp());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsteco() != null) {
			where.append(" AND t5.ESTECO = ?");
			params.add(acta.getEstablecimiento().getEsteco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND t5.ESINADAR = ?");
			params.add(acta.getEstablecimiento().getEsinadar());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t5.ESFEADAR = ?");
			params.add(acta.getEstablecimiento().getEsfeadar());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscoem() != null) {
			where.append(" AND t5.ESCOEM = ?");
			params.add(acta.getEstablecimiento().getEscoem());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND t5.ESINEMPR = ?");
			params.add(acta.getEstablecimiento().getEsinempr());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND t5.ESNRTEL2 = ?");
			params.add(acta.getEstablecimiento().getEsnrtel2());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t5.ESFEBA = ?");
			params.add(acta.getEstablecimiento().getEsfeba());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND t5.ESNOAP1 = ?");
			params.add(acta.getEstablecimiento().getEsnoap1());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND t5.ESNOAP2 = ?");
			params.add(acta.getEstablecimiento().getEsnoap2());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND t5.ESNOLO = ?");
			params.add(acta.getEstablecimiento().getEsnolo());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND t5.ESCOMAPV = ?");
			params.add(acta.getEstablecimiento().getEscomapv());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscoca() != null) {
			where.append(" AND t5.ESCOCA = ?");
			params.add(acta.getEstablecimiento().getEscoca());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND t5.ESNOPECO = ?");
			params.add(acta.getEstablecimiento().getEsnopeco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND t5.ESCOIDCO = ?");
			params.add(acta.getEstablecimiento().getEscoidco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND t5.ESINRECO = ?");
			params.add(acta.getEstablecimiento().getEsinreco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND t5.ESFEMOD = ?");
			params.add(acta.getEstablecimiento().getEsfemod());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND t5.ESINESCO = ?");
			params.add(acta.getEstablecimiento().getEsinesco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND t5.ESNOMU = ?");
			params.add(acta.getEstablecimiento().getEsnomu());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND t5.ESNOREP = ?");
			params.add(acta.getEstablecimiento().getEsnorep());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND t5.ESNIFREP = ?");
			params.add(acta.getEstablecimiento().getEsnifrep());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND t5.DTTEEMR = ?");
			params.add(acta.getEstablecimiento().getDtteemr());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscarep() != null) {
			where.append(" AND t5.ESCAREP = ?");
			params.add(acta.getEstablecimiento().getEscarep());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND t5.ESTEURL = ?");
			params.add(acta.getEstablecimiento().getEsteurl());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscooe() != null) {
			where.append(" AND t5.ESCOOE = ?");
			params.add(acta.getEstablecimiento().getEscooe());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND t5.ESNODECO = ?");
			params.add(acta.getEstablecimiento().getEsnodeco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND t5.ESINTIAR = ?");
			params.add(acta.getEstablecimiento().getEsintiar());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t5.ESFEPLAD = ?");
			params.add(acta.getEstablecimiento().getEsfeplad());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND t5.ESINDEME = ?");
			params.add(acta.getEstablecimiento().getEsindeme());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t5.ESNORA_PAIS_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraPaisId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND t5.ESNORA_PAIS_NOMBRE = ?");
			params.add(acta.getEstablecimiento().getEsnoraPaisNombre());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t5.ESNORA_PROVINCIA_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND t5.ESNOMBRE_PROVINCIA = ?");
			params.add(acta.getEstablecimiento().getEsnombreProvincia());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t5.ESNORA_MUNICIPIO_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND t5.ESNOMBRE_MUNICIPIO = ?");
			params.add(acta.getEstablecimiento().getEsnombreMunicipio());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t5.ESNORA_LOCALIDAD_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND t5.ESNOMBRE_LOCALIDAD = ?");
			params.add(acta.getEstablecimiento().getEsnombreLocalidad());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND t5.ESNORA_CALLE_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraCalleId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND t5.ESNOMBRE_CALLE = ?");
			params.add(acta.getEstablecimiento().getEsnombreCalle());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND t5.ESNORA_CP_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraCpId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND t5.ESNOMBRE_CP = ?");
			params.add(acta.getEstablecimiento().getEsnombreCp());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND t5.ESNORA_PORTAL_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraPortalId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND t5.ESNOMBRE_PORTAL = ?");
			params.add(acta.getEstablecimiento().getEsnombrePortal());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND t5.ESNOMBRE_PISO = ?");
			params.add(acta.getEstablecimiento().getEsnombrePiso());
		}
		if (acta != null && acta.getAccoor() != null) {
			where.append(" AND t1.ACCOOR = ?");
			params.add(acta.getAccoor());
		}
		if (acta != null && acta.getAcnror() != null) {
			where.append(" AND t1.ACNROR = ?");
			params.add(acta.getAcnror());
		}
		if (acta != null && acta.getAcnran() != null) {
			where.append(" AND t1.ACNRAN = ?");
			params.add(acta.getAcnran());
		}
		if (acta != null && acta.getAcfele() != null) {
			where.append(" AND t1.ACFELE = ?");
			params.add(acta.getAcfele());
		}
		if (acta != null && acta.getAcfere() != null) {
			where.append(" AND t1.ACFERE = ?");
			params.add(acta.getAcfere());
		}
		if (acta != null && acta.getAccoav() != null) {
			where.append(" AND t1.ACCOAV = ?");
			params.add(acta.getAccoav());
		}
		if (acta != null && acta.getAccose() != null) {
			where.append(" AND t1.ACCOSE = ?");
			params.add(acta.getAccose());
		}
		if (acta != null && acta.getAcfeex() != null) {
			where.append(" AND t1.ACFEEX = ?");
			params.add(acta.getAcfeex());
		}
		if (acta != null && acta.getAcinre() != null) {
			where.append(" AND t1.ACINRE = ?");
			params.add(acta.getAcinre());
		}
		if (acta != null && acta.getAcnoco() != null) {
			where.append(" AND t1.ACNOCO = ?");
			params.add(acta.getAcnoco());
		}
		if (acta != null && acta.getAcape1co() != null) {
			where.append(" AND t1.ACAPE1CO = ?");
			params.add(acta.getAcape1co());
		}
		if (acta != null && acta.getAcape2co() != null) {
			where.append(" AND t1.ACAPE2CO = ?");
			params.add(acta.getAcape2co());
		}
		if (acta != null && acta.getAcdnico() != null) {
			where.append(" AND t1.ACDNICO = ?");
			params.add(acta.getAcdnico());
		}
		if (acta != null && acta.getAccoco() != null) {
			where.append(" AND t1.ACCOCO = ?");
			params.add(acta.getAccoco());
		}
		if (acta != null && acta.getAcdirco() != null) {
			where.append(" AND t1.ACDIRCO = ?");
			params.add(acta.getAcdirco());
		}
		if (acta != null && acta.getAccoloco() != null) {
			where.append(" AND t1.ACCOLOCO = ?");
			params.add(acta.getAccoloco());
		}
		if (acta != null && acta.getAcnrcpco() != null) {
			where.append(" AND t1.ACNRCPCO = ?");
			params.add(acta.getAcnrcpco());
		}
		if (acta != null && acta.getAcnrtfco() != null) {
			where.append(" AND t1.ACNRTFCO = ?");
			params.add(acta.getAcnrtfco());
		}
		if (acta != null && acta.getAcnoraPaisId() != null) {
			where.append(" AND t1.ACNORA_PAIS_ID = ?");
			params.add(acta.getAcnoraPaisId());
		}
		if (acta != null && acta.getAcnoraPaisNombre() != null) {
			where.append(" AND t1.ACNORA_PAIS_NOMBRE = ?");
			params.add(acta.getAcnoraPaisNombre());
		}
		if (acta != null && acta.getAcnoraProvinciaId() != null) {
			where.append(" AND t1.ACNORA_PROVINCIA_ID = ?");
			params.add(acta.getAcnoraProvinciaId());
		}
		if (acta != null && acta.getAcnombreProvincia() != null) {
			where.append(" AND t1.ACNOMBRE_PROVINCIA = ?");
			params.add(acta.getAcnombreProvincia());
		}
		if (acta != null && acta.getAcnoraMunicipioId() != null) {
			where.append(" AND t1.ACNORA_MUNICIPIO_ID = ?");
			params.add(acta.getAcnoraMunicipioId());
		}
		if (acta != null && acta.getAcnombreMunicipio() != null) {
			where.append(" AND t1.ACNOMBRE_MUNICIPIO = ?");
			params.add(acta.getAcnombreMunicipio());
		}
		if (acta != null && acta.getAcnoraLocalidadId() != null) {
			where.append(" AND t1.ACNORA_LOCALIDAD_ID = ?");
			params.add(acta.getAcnoraLocalidadId());
		}
		if (acta != null && acta.getAcnombreLocalidad() != null) {
			where.append(" AND t1.ACNOMBRE_LOCALIDAD = ?");
			params.add(acta.getAcnombreLocalidad());
		}
		if (acta != null && acta.getAcnoraCalleId() != null) {
			where.append(" AND t1.ACNORA_CALLE_ID = ?");
			params.add(acta.getAcnoraCalleId());
		}
		if (acta != null && acta.getAcnombreCalle() != null) {
			where.append(" AND t1.ACNOMBRE_CALLE = ?");
			params.add(acta.getAcnombreCalle());
		}
		if (acta != null && acta.getAcnoraCpId() != null) {
			where.append(" AND t1.ACNORA_CP_ID = ?");
			params.add(acta.getAcnoraCpId());
		}
		if (acta != null && acta.getAcnombreCp() != null) {
			where.append(" AND t1.ACNOMBRE_CP = ?");
			params.add(acta.getAcnombreCp());
		}
		if (acta != null && acta.getAcnoraPortalId() != null) {
			where.append(" AND t1.ACNORA_PORTAL_ID = ?");
			params.add(acta.getAcnoraPortalId());
		}
		if (acta != null && acta.getAcnombrePortal() != null) {
			where.append(" AND t1.ACNOMBRE_PORTAL = ?");
			params.add(acta.getAcnombrePortal());
		}
		if (acta != null && acta.getAcnombrePiso() != null) {
			where.append(" AND t1.ACNOMBRE_PISO = ?");
			params.add(acta.getAcnombrePiso());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Acta>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Counts rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Acta acta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.ACCOINDO= t2.INCODIGO(+) and t1.ACCOINUN= t3.INCODIGO(+) and t1.ACCOTD= t4.TDCODIGO(+) and t1.ACCOES= t5.ESCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ACTA t1   ,  INSPECTOR t2   ,  INSPECTOR t3   ,  TIPODOC t4   ,  ESTABLECIMIENTO t5  ");
		if (acta != null && acta.getAccodigo() != null) {
			where.append(" AND t1.ACCODIGO = ?");
			params.add(acta.getAccodigo());
		}
		if (acta != null && acta.getInspectorByAccoindo() != null
				&& acta.getInspectorByAccoindo().getIncodigo() != null) {
			where.append(" AND t2.INCODIGO = ?");
			params.add(acta.getInspectorByAccoindo().getIncodigo());
		}
		if (acta != null && acta.getInspectorByAccoindo() != null
				&& acta.getInspectorByAccoindo().getInnombre() != null) {
			where.append(" AND t2.INNOMBRE = ?");
			params.add(acta.getInspectorByAccoindo().getInnombre());
		}
		if (acta != null && acta.getInspectorByAccoindo() != null
				&& acta.getInspectorByAccoindo().getIncoor() != null) {
			where.append(" AND t2.INCOOR = ?");
			params.add(acta.getInspectorByAccoindo().getIncoor());
		}
		if (acta != null && acta.getInspectorByAccoinun() != null
				&& acta.getInspectorByAccoinun().getIncodigo() != null) {
			where.append(" AND t3.INCODIGO = ?");
			params.add(acta.getInspectorByAccoinun().getIncodigo());
		}
		if (acta != null && acta.getInspectorByAccoinun() != null
				&& acta.getInspectorByAccoinun().getInnombre() != null) {
			where.append(" AND t3.INNOMBRE = ?");
			params.add(acta.getInspectorByAccoinun().getInnombre());
		}
		if (acta != null && acta.getInspectorByAccoinun() != null
				&& acta.getInspectorByAccoinun().getIncoor() != null) {
			where.append(" AND t3.INCOOR = ?");
			params.add(acta.getInspectorByAccoinun().getIncoor());
		}
		if (acta != null && acta.getTipodoc() != null
				&& acta.getTipodoc().getTdcodigo() != null) {
			where.append(" AND t4.TDCODIGO = ?");
			params.add(acta.getTipodoc().getTdcodigo());
		}
		if (acta != null && acta.getTipodoc() != null
				&& acta.getTipodoc().getTdnombre() != null) {
			where.append(" AND t4.TDNOMBRE = ?");
			params.add(acta.getTipodoc().getTdnombre());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t5.ESCODIGO = ?");
			params.add(acta.getEstablecimiento().getEscodigo());
		}
		if (acta != null
				&& acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getCensoMonitor() != null
				&& acta.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t5.ESCOZS = ?");
			params.add(acta.getEstablecimiento().getCensoMonitor()
					.getMocodigo());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND t5.ESNOMBRE = ?");
			params.add(acta.getEstablecimiento().getEsnombre());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnif() != null) {
			where.append(" AND t5.ESNIF = ?");
			params.add(acta.getEstablecimiento().getEsnif());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND t5.ESNOAN = ?");
			params.add(acta.getEstablecimiento().getEsnoan());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND t5.ESNOCO = ?");
			params.add(acta.getEstablecimiento().getEsnoco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND t5.ESNODIR = ?");
			params.add(acta.getEstablecimiento().getEsnodir());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscolo() != null) {
			where.append(" AND t5.ESCOLO = ?");
			params.add(acta.getEstablecimiento().getEscolo());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND t5.ESNRCOPO = ?");
			params.add(acta.getEstablecimiento().getEsnrcopo());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND t5.ESNRTEL = ?");
			params.add(acta.getEstablecimiento().getEsnrtel());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND t5.ESNRFAX = ?");
			params.add(acta.getEstablecimiento().getEsnrfax());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscopa() != null) {
			where.append(" AND t5.ESCOPA = ?");
			params.add(acta.getEstablecimiento().getEscopa());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND t5.ESINCAPR = ?");
			params.add(acta.getEstablecimiento().getEsincapr());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND t5.ESINDEMP = ?");
			params.add(acta.getEstablecimiento().getEsindemp());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsteco() != null) {
			where.append(" AND t5.ESTECO = ?");
			params.add(acta.getEstablecimiento().getEsteco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND t5.ESINADAR = ?");
			params.add(acta.getEstablecimiento().getEsinadar());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t5.ESFEADAR = ?");
			params.add(acta.getEstablecimiento().getEsfeadar());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscoem() != null) {
			where.append(" AND t5.ESCOEM = ?");
			params.add(acta.getEstablecimiento().getEscoem());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND t5.ESINEMPR = ?");
			params.add(acta.getEstablecimiento().getEsinempr());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND t5.ESNRTEL2 = ?");
			params.add(acta.getEstablecimiento().getEsnrtel2());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t5.ESFEBA = ?");
			params.add(acta.getEstablecimiento().getEsfeba());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND t5.ESNOAP1 = ?");
			params.add(acta.getEstablecimiento().getEsnoap1());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND t5.ESNOAP2 = ?");
			params.add(acta.getEstablecimiento().getEsnoap2());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND t5.ESNOLO = ?");
			params.add(acta.getEstablecimiento().getEsnolo());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND t5.ESCOMAPV = ?");
			params.add(acta.getEstablecimiento().getEscomapv());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscoca() != null) {
			where.append(" AND t5.ESCOCA = ?");
			params.add(acta.getEstablecimiento().getEscoca());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND t5.ESNOPECO = ?");
			params.add(acta.getEstablecimiento().getEsnopeco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND t5.ESCOIDCO = ?");
			params.add(acta.getEstablecimiento().getEscoidco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND t5.ESINRECO = ?");
			params.add(acta.getEstablecimiento().getEsinreco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND t5.ESFEMOD = ?");
			params.add(acta.getEstablecimiento().getEsfemod());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND t5.ESINESCO = ?");
			params.add(acta.getEstablecimiento().getEsinesco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND t5.ESNOMU = ?");
			params.add(acta.getEstablecimiento().getEsnomu());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND t5.ESNOREP = ?");
			params.add(acta.getEstablecimiento().getEsnorep());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND t5.ESNIFREP = ?");
			params.add(acta.getEstablecimiento().getEsnifrep());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND t5.DTTEEMR = ?");
			params.add(acta.getEstablecimiento().getDtteemr());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscarep() != null) {
			where.append(" AND t5.ESCAREP = ?");
			params.add(acta.getEstablecimiento().getEscarep());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND t5.ESTEURL = ?");
			params.add(acta.getEstablecimiento().getEsteurl());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscooe() != null) {
			where.append(" AND t5.ESCOOE = ?");
			params.add(acta.getEstablecimiento().getEscooe());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND t5.ESNODECO = ?");
			params.add(acta.getEstablecimiento().getEsnodeco());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND t5.ESINTIAR = ?");
			params.add(acta.getEstablecimiento().getEsintiar());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t5.ESFEPLAD = ?");
			params.add(acta.getEstablecimiento().getEsfeplad());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND t5.ESINDEME = ?");
			params.add(acta.getEstablecimiento().getEsindeme());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t5.ESNORA_PAIS_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraPaisId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND t5.ESNORA_PAIS_NOMBRE = ?");
			params.add(acta.getEstablecimiento().getEsnoraPaisNombre());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t5.ESNORA_PROVINCIA_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND t5.ESNOMBRE_PROVINCIA = ?");
			params.add(acta.getEstablecimiento().getEsnombreProvincia());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t5.ESNORA_MUNICIPIO_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND t5.ESNOMBRE_MUNICIPIO = ?");
			params.add(acta.getEstablecimiento().getEsnombreMunicipio());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t5.ESNORA_LOCALIDAD_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND t5.ESNOMBRE_LOCALIDAD = ?");
			params.add(acta.getEstablecimiento().getEsnombreLocalidad());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND t5.ESNORA_CALLE_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraCalleId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND t5.ESNOMBRE_CALLE = ?");
			params.add(acta.getEstablecimiento().getEsnombreCalle());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND t5.ESNORA_CP_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraCpId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND t5.ESNOMBRE_CP = ?");
			params.add(acta.getEstablecimiento().getEsnombreCp());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND t5.ESNORA_PORTAL_ID = ?");
			params.add(acta.getEstablecimiento().getEsnoraPortalId());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND t5.ESNOMBRE_PORTAL = ?");
			params.add(acta.getEstablecimiento().getEsnombrePortal());
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND t5.ESNOMBRE_PISO = ?");
			params.add(acta.getEstablecimiento().getEsnombrePiso());
		}
		if (acta != null && acta.getAccoor() != null) {
			where.append(" AND t1.ACCOOR = ?");
			params.add(acta.getAccoor());
		}
		if (acta != null && acta.getAcnror() != null) {
			where.append(" AND t1.ACNROR = ?");
			params.add(acta.getAcnror());
		}
		if (acta != null && acta.getAcnran() != null) {
			where.append(" AND t1.ACNRAN = ?");
			params.add(acta.getAcnran());
		}
		if (acta != null && acta.getAcfele() != null) {
			where.append(" AND t1.ACFELE = ?");
			params.add(acta.getAcfele());
		}
		if (acta != null && acta.getAcfere() != null) {
			where.append(" AND t1.ACFERE = ?");
			params.add(acta.getAcfere());
		}
		if (acta != null && acta.getAccoav() != null) {
			where.append(" AND t1.ACCOAV = ?");
			params.add(acta.getAccoav());
		}
		if (acta != null && acta.getAccose() != null) {
			where.append(" AND t1.ACCOSE = ?");
			params.add(acta.getAccose());
		}
		if (acta != null && acta.getAcfeex() != null) {
			where.append(" AND t1.ACFEEX = ?");
			params.add(acta.getAcfeex());
		}
		if (acta != null && acta.getAcinre() != null) {
			where.append(" AND t1.ACINRE = ?");
			params.add(acta.getAcinre());
		}
		if (acta != null && acta.getAcnoco() != null) {
			where.append(" AND t1.ACNOCO = ?");
			params.add(acta.getAcnoco());
		}
		if (acta != null && acta.getAcape1co() != null) {
			where.append(" AND t1.ACAPE1CO = ?");
			params.add(acta.getAcape1co());
		}
		if (acta != null && acta.getAcape2co() != null) {
			where.append(" AND t1.ACAPE2CO = ?");
			params.add(acta.getAcape2co());
		}
		if (acta != null && acta.getAcdnico() != null) {
			where.append(" AND t1.ACDNICO = ?");
			params.add(acta.getAcdnico());
		}
		if (acta != null && acta.getAccoco() != null) {
			where.append(" AND t1.ACCOCO = ?");
			params.add(acta.getAccoco());
		}
		if (acta != null && acta.getAcdirco() != null) {
			where.append(" AND t1.ACDIRCO = ?");
			params.add(acta.getAcdirco());
		}
		if (acta != null && acta.getAccoloco() != null) {
			where.append(" AND t1.ACCOLOCO = ?");
			params.add(acta.getAccoloco());
		}
		if (acta != null && acta.getAcnrcpco() != null) {
			where.append(" AND t1.ACNRCPCO = ?");
			params.add(acta.getAcnrcpco());
		}
		if (acta != null && acta.getAcnrtfco() != null) {
			where.append(" AND t1.ACNRTFCO = ?");
			params.add(acta.getAcnrtfco());
		}
		if (acta != null && acta.getAcnoraPaisId() != null) {
			where.append(" AND t1.ACNORA_PAIS_ID = ?");
			params.add(acta.getAcnoraPaisId());
		}
		if (acta != null && acta.getAcnoraPaisNombre() != null) {
			where.append(" AND t1.ACNORA_PAIS_NOMBRE = ?");
			params.add(acta.getAcnoraPaisNombre());
		}
		if (acta != null && acta.getAcnoraProvinciaId() != null) {
			where.append(" AND t1.ACNORA_PROVINCIA_ID = ?");
			params.add(acta.getAcnoraProvinciaId());
		}
		if (acta != null && acta.getAcnombreProvincia() != null) {
			where.append(" AND t1.ACNOMBRE_PROVINCIA = ?");
			params.add(acta.getAcnombreProvincia());
		}
		if (acta != null && acta.getAcnoraMunicipioId() != null) {
			where.append(" AND t1.ACNORA_MUNICIPIO_ID = ?");
			params.add(acta.getAcnoraMunicipioId());
		}
		if (acta != null && acta.getAcnombreMunicipio() != null) {
			where.append(" AND t1.ACNOMBRE_MUNICIPIO = ?");
			params.add(acta.getAcnombreMunicipio());
		}
		if (acta != null && acta.getAcnoraLocalidadId() != null) {
			where.append(" AND t1.ACNORA_LOCALIDAD_ID = ?");
			params.add(acta.getAcnoraLocalidadId());
		}
		if (acta != null && acta.getAcnombreLocalidad() != null) {
			where.append(" AND t1.ACNOMBRE_LOCALIDAD = ?");
			params.add(acta.getAcnombreLocalidad());
		}
		if (acta != null && acta.getAcnoraCalleId() != null) {
			where.append(" AND t1.ACNORA_CALLE_ID = ?");
			params.add(acta.getAcnoraCalleId());
		}
		if (acta != null && acta.getAcnombreCalle() != null) {
			where.append(" AND t1.ACNOMBRE_CALLE = ?");
			params.add(acta.getAcnombreCalle());
		}
		if (acta != null && acta.getAcnoraCpId() != null) {
			where.append(" AND t1.ACNORA_CP_ID = ?");
			params.add(acta.getAcnoraCpId());
		}
		if (acta != null && acta.getAcnombreCp() != null) {
			where.append(" AND t1.ACNOMBRE_CP = ?");
			params.add(acta.getAcnombreCp());
		}
		if (acta != null && acta.getAcnoraPortalId() != null) {
			where.append(" AND t1.ACNORA_PORTAL_ID = ?");
			params.add(acta.getAcnoraPortalId());
		}
		if (acta != null && acta.getAcnombrePortal() != null) {
			where.append(" AND t1.ACNOMBRE_PORTAL = ?");
			params.add(acta.getAcnombrePortal());
		}
		if (acta != null && acta.getAcnombrePiso() != null) {
			where.append(" AND t1.ACNOMBRE_PISO = ?");
			params.add(acta.getAcnombrePiso());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Acta table using like.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Acta> findAllLike(Acta acta, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ACCOINDO= t2.INCODIGO(+) AND t1.ACCOINUN= t3.INCODIGO(+) AND t1.ACCOTD= t4.TDCODIGO(+) AND t1.ACCOES= t5.ESCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ACCODIGO ACCODIGO,t1.ACCOOR ACCOOR,t1.ACNROR ACNROR,t1.ACNRAN ACNRAN,t1.ACFELE ACFELE,t1.ACFERE ACFERE,t1.ACCOAV ACCOAV,t1.ACCOSE ACCOSE,t1.ACFEEX ACFEEX,t1.ACINRE ACINRE,t1.ACNOCO ACNOCO,t1.ACAPE1CO ACAPE1CO,t1.ACAPE2CO ACAPE2CO,t1.ACDNICO ACDNICO,t1.ACCOCO ACCOCO,t1.ACDIRCO ACDIRCO,t1.ACCOLOCO ACCOLOCO,t1.ACNRCPCO ACNRCPCO,t1.ACNRTFCO ACNRTFCO,t1.ACNORA_PAIS_ID ACNORAPAISID,t1.ACNORA_PAIS_NOMBRE ACNORAPAISNOMBRE,t1.ACNORA_PROVINCIA_ID ACNORAPROVINCIAID,t1.ACNOMBRE_PROVINCIA ACNOMBREPROVINCIA,t1.ACNORA_MUNICIPIO_ID ACNORAMUNICIPIOID,t1.ACNOMBRE_MUNICIPIO ACNOMBREMUNICIPIO,t1.ACNORA_LOCALIDAD_ID ACNORALOCALIDADID,t1.ACNOMBRE_LOCALIDAD ACNOMBRELOCALIDAD,t1.ACNORA_CALLE_ID ACNORACALLEID,t1.ACNOMBRE_CALLE ACNOMBRECALLE,t1.ACNORA_CP_ID ACNORACPID,t1.ACNOMBRE_CP ACNOMBRECP,t1.ACNORA_PORTAL_ID ACNORAPORTALID,t1.ACNOMBRE_PORTAL ACNOMBREPORTAL,t1.ACNOMBRE_PISO ACNOMBREPISO, t1.ACDIRECCION_NOCAPV ACDIRECCIONNOCAPV,t2.INCODIGO INSPECTORINCODIGO,t2.INNOMBRE INSPECTORINNOMBRE,t2.INCOOR INSPECTORINCOOR,t3.INCODIGO INSPECTORINCODIGO,t3.INNOMBRE INSPECTORINNOMBRE,t3.INCOOR INSPECTORINCOOR,t4.TDCODIGO TIPODOCTDCODIGO,t4.TDNOMBRE TIPODOCTDNOMBRE,t5.ESCODIGO ESTABLECIMIENTOESCODIGO,t5.ESNOMBRE ESTABLECIMIENTOESNOMBRE,t5.ESNIF ESTABLECIMIENTOESNIF,t5.ESNOAN ESTABLECIMIENTOESNOAN,t5.ESNOCO ESTABLECIMIENTOESNOCO,t5.ESNODIR ESTABLECIMIENTOESNODIR,t5.ESCOLO ESTABLECIMIENTOESCOLO,t5.ESNRCOPO ESTABLECIMIENTOESNRCOPO,t5.ESNRTEL ESTABLECIMIENTOESNRTEL,t5.ESNRFAX ESTABLECIMIENTOESNRFAX,t5.ESCOPA ESTABLECIMIENTOESCOPA,t5.ESINCAPR ESTABLECIMIENTOESINCAPR,t5.ESINDEMP ESTABLECIMIENTOESINDEMP,t5.ESTECO ESTABLECIMIENTOESTECO,t5.ESINADAR ESTABLECIMIENTOESINADAR,t5.ESFEADAR ESTABLECIMIENTOESFEADAR,t5.ESCOEM ESTABLECIMIENTOESCOEM,t5.ESINEMPR ESTABLECIMIENTOESINEMPR,t5.ESNRTEL2 ESTABLECIMIENTOESNRTEL2,t5.ESFEBA ESTABLECIMIENTOESFEBA,t5.ESNOAP1 ESTABLECIMIENTOESNOAP1,t5.ESNOAP2 ESTABLECIMIENTOESNOAP2,t5.ESNOLO ESTABLECIMIENTOESNOLO,t5.ESCOMAPV ESTABLECIMIENTOESCOMAPV,t5.ESCOCA ESTABLECIMIENTOESCOCA,t5.ESNOPECO ESTABLECIMIENTOESNOPECO,t5.ESCOIDCO ESTABLECIMIENTOESCOIDCO,t5.ESINRECO ESTABLECIMIENTOESINRECO,t5.ESFEMOD ESTABLECIMIENTOESFEMOD,t5.ESINESCO ESTABLECIMIENTOESINESCO,t5.ESNOMU ESTABLECIMIENTOESNOMU,t5.ESNOREP ESTABLECIMIENTOESNOREP,t5.ESNIFREP ESTABLECIMIENTOESNIFREP,t5.DTTEEMR ESTABLECIMIENTODTTEEMR,t5.ESCAREP ESTABLECIMIENTOESCAREP,t5.ESTEURL ESTABLECIMIENTOESTEURL,t5.ESCOOE ESTABLECIMIENTOESCOOE,t5.ESNODECO ESTABLECIMIENTOESNODECO,t5.ESINTIAR ESTABLECIMIENTOESINTIAR,t5.ESFEPLAD ESTABLECIMIENTOESFEPLAD,t5.ESINDEME ESTABLECIMIENTOESINDEME,t5.ESNORA_PAIS_ID ESTABLECIMIENTOESNORAPAISID,t5.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE,t5.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID,t5.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA,t5.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID,t5.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO,t5.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID,t5.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD,t5.ESNORA_CALLE_ID ESTABLECIMIENTOESNORACALLEID,t5.ESNOMBRE_CALLE ESTABLECIMIENTOESNOMBRECALLE,t5.ESNORA_CP_ID ESTABLECIMIENTOESNORACPID,t5.ESNOMBRE_CP ESTABLECIMIENTOESNOMBRECP,t5.ESNORA_PORTAL_ID ESTABLECIMIENTOESNORAPORTALID,t5.ESNOMBRE_PORTAL ESTABLECIMIENTOESNOMBREPORTAL,t5.ESNOMBRE_PISO ESTABLECIMIENTOESNOMBREPISO, t5.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV,t5.ESEXTRANJERO EstableESEXTRANJERO,t5.ESCOZS ESTABLECIMIENTOESCOZS "
						+ "FROM ACTA t1 ,INSPECTOR t2 ,INSPECTOR t3 ,TIPODOC t4 ,ESTABLECIMIENTO t5 ");

		if (acta != null && acta.getAccodigo() != null) {
			where.append(" AND UPPER(t1.ACCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccodigo().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCODIGO IS NOT NULL");
		}
		if (acta != null && acta.getInspectorByAccoindo() != null
				&& acta.getInspectorByAccoindo().getIncodigo() != null) {
			where.append(" AND t2.INCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getInspectorByAccoindo().getIncodigo() + "%");
			} else {
				params.add("%" + acta.getInspectorByAccoindo().getIncodigo()
						+ "%");
			}
			where.append(" AND t2.INCODIGO IS NOT NULL");
		}
		if (acta != null && acta.getInspectorByAccoindo() != null
				&& acta.getInspectorByAccoindo().getInnombre() != null) {
			where.append(" AND UPPER(t2.INNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getInspectorByAccoindo().getInnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getInspectorByAccoindo().getInnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.INNOMBRE IS NOT NULL");
		}
		if (acta != null && acta.getInspectorByAccoindo() != null
				&& acta.getInspectorByAccoindo().getIncoor() != null) {
			where.append(" AND UPPER(t2.INCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getInspectorByAccoindo().getIncoor()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getInspectorByAccoindo().getIncoor()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.INCOOR IS NOT NULL");
		}
		if (acta != null && acta.getInspectorByAccoinun() != null
				&& acta.getInspectorByAccoinun().getIncodigo() != null) {
			where.append(" AND t3.INCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getInspectorByAccoinun().getIncodigo() + "%");
			} else {
				params.add("%" + acta.getInspectorByAccoinun().getIncodigo()
						+ "%");
			}
			where.append(" AND t3.INCODIGO IS NOT NULL");
		}
		if (acta != null && acta.getInspectorByAccoinun() != null
				&& acta.getInspectorByAccoinun().getInnombre() != null) {
			where.append(" AND UPPER(t3.INNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getInspectorByAccoinun().getInnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getInspectorByAccoinun().getInnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.INNOMBRE IS NOT NULL");
		}
		if (acta != null && acta.getInspectorByAccoinun() != null
				&& acta.getInspectorByAccoinun().getIncoor() != null) {
			where.append(" AND UPPER(t3.INCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getInspectorByAccoinun().getIncoor()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getInspectorByAccoinun().getIncoor()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.INCOOR IS NOT NULL");
		}
		if (acta != null && acta.getTipodoc() != null
				&& acta.getTipodoc().getTdcodigo() != null) {
			where.append(" AND t4.TDCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getTipodoc().getTdcodigo() + "%");
			} else {
				params.add("%" + acta.getTipodoc().getTdcodigo() + "%");
			}
			where.append(" AND t4.TDCODIGO IS NOT NULL");
		}
		if (acta != null && acta.getTipodoc() != null
				&& acta.getTipodoc().getTdnombre() != null) {
			where.append(" AND UPPER(t4.TDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getTipodoc().getTdnombre().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getTipodoc().getTdnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.TDNOMBRE IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t5.ESCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEscodigo() + "%");
			} else {
				params.add("%" + acta.getEstablecimiento().getEscodigo() + "%");
			}
			where.append(" AND t5.ESCODIGO IS NOT NULL");
		}
		if (acta != null
				&& acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getCensoMonitor() != null
				&& acta.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t5.ESCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getCensoMonitor()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getCensoMonitor()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t5.ESCOZS IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNOMBRE IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnif() != null) {
			where.append(" AND UPPER(t5.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnif().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNIF IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND UPPER(t5.ESNOAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoan().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoan().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNOAN IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND UPPER(t5.ESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNOCO IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND UPPER(t5.ESNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnodir().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnodir().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNODIR IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscolo() != null) {
			where.append(" AND UPPER(t5.ESCOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEscolo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEscolo().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESCOLO IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND UPPER(t5.ESNRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnrcopo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnrcopo().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNRCOPO IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND UPPER(t5.ESNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnrtel().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnrtel().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNRTEL IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND UPPER(t5.ESNRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnrfax().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnrfax().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNRFAX IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscopa() != null) {
			where.append(" AND UPPER(t5.ESCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEscopa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEscopa().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESCOPA IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND UPPER(t5.ESINCAPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsincapr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsincapr().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESINCAPR IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND UPPER(t5.ESINDEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsindemp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsindemp().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESINDEMP IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsteco() != null) {
			where.append(" AND UPPER(t5.ESTECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsteco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsteco().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESTECO IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND UPPER(t5.ESINADAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsinadar()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsinadar().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESINADAR IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t5.ESFEADAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsfeadar() + "%");
			} else {
				params.add("%" + acta.getEstablecimiento().getEsfeadar() + "%");
			}
			where.append(" AND t5.ESFEADAR IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscoem() != null) {
			where.append(" AND UPPER(t5.ESCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEscoem().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEscoem().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESCOEM IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND UPPER(t5.ESINEMPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsinempr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsinempr().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESINEMPR IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND UPPER(t5.ESNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnrtel2()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnrtel2().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNRTEL2 IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t5.ESFEBA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsfeba() + "%");
			} else {
				params.add("%" + acta.getEstablecimiento().getEsfeba() + "%");
			}
			where.append(" AND t5.ESFEBA IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND UPPER(t5.ESNOAP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoap1().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoap1().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNOAP1 IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND UPPER(t5.ESNOAP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoap2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoap2().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNOAP2 IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND UPPER(t5.ESNOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnolo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnolo().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNOLO IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND UPPER(t5.ESCOMAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEscomapv()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEscomapv().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESCOMAPV IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscoca() != null) {
			where.append(" AND UPPER(t5.ESCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEscoca().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEscoca().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESCOCA IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND UPPER(t5.ESNOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnopeco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnopeco().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNOPECO IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND UPPER(t5.ESCOIDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEscoidco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEscoidco().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESCOIDCO IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND UPPER(t5.ESINRECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsinreco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsinreco().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESINRECO IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND UPPER(t5.ESFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsfemod().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsfemod().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESFEMOD IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND UPPER(t5.ESINESCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsinesco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsinesco().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESINESCO IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND UPPER(t5.ESNOMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnomu().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnomu().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNOMU IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND UPPER(t5.ESNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnorep().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnorep().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNOREP IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND UPPER(t5.ESNIFREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnifrep()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnifrep().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNIFREP IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND UPPER(t5.DTTEEMR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getDtteemr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getDtteemr().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.DTTEEMR IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscarep() != null) {
			where.append(" AND UPPER(t5.ESCAREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEscarep().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEscarep().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESCAREP IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND UPPER(t5.ESTEURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsteurl().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsteurl().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESTEURL IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEscooe() != null) {
			where.append(" AND UPPER(t5.ESCOOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEscooe().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEscooe().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESCOOE IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND UPPER(t5.ESNODECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnodeco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnodeco().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESNODECO IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND UPPER(t5.ESINTIAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsintiar()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsintiar().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESINTIAR IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t5.ESFEPLAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsfeplad() + "%");
			} else {
				params.add("%" + acta.getEstablecimiento().getEsfeplad() + "%");
			}
			where.append(" AND t5.ESFEPLAD IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND UPPER(t5.ESINDEME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsindeme()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsindeme().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.ESINDEME IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND UPPER(t5.ESNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoraPaisId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoraPaisId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_PAIS_ID IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND UPPER(t5.ESNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoraPaisNombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoraPaisNombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND UPPER(t5.ESNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoraProvinciaId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnombreProvincia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND UPPER(t5.ESNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoraMunicipioId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnombreMunicipio()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND UPPER(t5.ESNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoraLocalidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnombreLocalidad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND UPPER(t5.ESNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoraCalleId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoraCalleId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_CALLE_ID IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnombreCalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnombreCalle()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_CALLE IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND UPPER(t5.ESNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoraCpId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoraCpId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_CP_ID IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnombreCp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnombreCp()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_CP IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND UPPER(t5.ESNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnoraPortalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnoraPortalId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_PORTAL_ID IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnombrePortal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnombrePortal()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_PORTAL IS NOT NULL");
		}
		if (acta != null && acta.getEstablecimiento() != null
				&& acta.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getEstablecimiento().getEsnombrePiso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ acta.getEstablecimiento().getEsnombrePiso()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_PISO IS NOT NULL");
		}
		if (acta != null && acta.getAccoor() != null) {
			where.append(" AND UPPER(t1.ACCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoor().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoor().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOOR IS NOT NULL");
		}
		if (acta != null && acta.getAcnror() != null) {
			where.append(" AND UPPER(t1.ACNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnror().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnror().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNROR IS NOT NULL");
		}
		if (acta != null && acta.getAcnran() != null) {
			where.append(" AND t1.ACNRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnran() + "%");
			} else {
				params.add("%" + acta.getAcnran() + "%");
			}
			where.append(" AND t1.ACNRAN IS NOT NULL");
		}
		if (acta != null && acta.getAcfele() != null) {
			where.append(" AND t1.ACFELE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcfele() + "%");
			} else {
				params.add("%" + acta.getAcfele() + "%");
			}
			where.append(" AND t1.ACFELE IS NOT NULL");
		}
		if (acta != null && acta.getAcfere() != null) {
			where.append(" AND t1.ACFERE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcfere() + "%");
			} else {
				params.add("%" + acta.getAcfere() + "%");
			}
			where.append(" AND t1.ACFERE IS NOT NULL");
		}
		if (acta != null && acta.getAccoav() != null) {
			where.append(" AND UPPER(t1.ACCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoav().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoav().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOAV IS NOT NULL");
		}
		if (acta != null && acta.getAccose() != null) {
			where.append(" AND UPPER(t1.ACCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccose().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccose().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOSE IS NOT NULL");
		}
		if (acta != null && acta.getAcfeex() != null) {
			where.append(" AND t1.ACFEEX like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcfeex() + "%");
			} else {
				params.add("%" + acta.getAcfeex() + "%");
			}
			where.append(" AND t1.ACFEEX IS NOT NULL");
		}
		if (acta != null && acta.getAcinre() != null) {
			where.append(" AND UPPER(t1.ACINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcinre().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcinre().toUpperCase() + "%");
			}
			where.append(" AND t1.ACINRE IS NOT NULL");
		}
		if (acta != null && acta.getAcnoco() != null) {
			where.append(" AND UPPER(t1.ACNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOCO IS NOT NULL");
		}
		if (acta != null && acta.getAcape1co() != null) {
			where.append(" AND UPPER(t1.ACAPE1CO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcape1co().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcape1co().toUpperCase() + "%");
			}
			where.append(" AND t1.ACAPE1CO IS NOT NULL");
		}
		if (acta != null && acta.getAcape2co() != null) {
			where.append(" AND UPPER(t1.ACAPE2CO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcape2co().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcape2co().toUpperCase() + "%");
			}
			where.append(" AND t1.ACAPE2CO IS NOT NULL");
		}
		if (acta != null && acta.getAcdnico() != null) {
			where.append(" AND UPPER(t1.ACDNICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcdnico().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcdnico().toUpperCase() + "%");
			}
			where.append(" AND t1.ACDNICO IS NOT NULL");
		}
		if (acta != null && acta.getAccoco() != null) {
			where.append(" AND UPPER(t1.ACCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOCO IS NOT NULL");
		}
		if (acta != null && acta.getAcdirco() != null) {
			where.append(" AND UPPER(t1.ACDIRCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcdirco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcdirco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACDIRCO IS NOT NULL");
		}
		if (acta != null && acta.getAccoloco() != null) {
			where.append(" AND UPPER(t1.ACCOLOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAccoloco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAccoloco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOLOCO IS NOT NULL");
		}
		if (acta != null && acta.getAcnrcpco() != null) {
			where.append(" AND UPPER(t1.ACNRCPCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnrcpco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnrcpco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNRCPCO IS NOT NULL");
		}
		if (acta != null && acta.getAcnrtfco() != null) {
			where.append(" AND UPPER(t1.ACNRTFCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnrtfco().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnrtfco().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNRTFCO IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraPaisId() != null) {
			where.append(" AND UPPER(t1.ACNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_PAIS_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraPaisNombre() != null) {
			where.append(" AND UPPER(t1.ACNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraPaisNombre().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraPaisNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.ACNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ACNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreProvincia() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombreProvincia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ACNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.ACNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ACNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreMunicipio() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombreMunicipio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ACNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.ACNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraLocalidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ACNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreLocalidad() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombreLocalidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ACNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraCalleId() != null) {
			where.append(" AND UPPER(t1.ACNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_CALLE_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreCalle() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOMBRE_CALLE IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraCpId() != null) {
			where.append(" AND UPPER(t1.ACNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_CP_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombreCp() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOMBRE_CP IS NOT NULL");
		}
		if (acta != null && acta.getAcnoraPortalId() != null) {
			where.append(" AND UPPER(t1.ACNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNORA_PORTAL_ID IS NOT NULL");
		}
		if (acta != null && acta.getAcnombrePortal() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOMBRE_PORTAL IS NOT NULL");
		}
		if (acta != null && acta.getAcnombrePiso() != null) {
			where.append(" AND UPPER(t1.ACNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(acta.getAcnombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + acta.getAcnombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t1.ACNOMBRE_PISO IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Acta>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}
}
