package com.ejie.y41a.control.exception;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
import com.ejie.y41a.utils.exception.Y41aUDAException;

public class Y41aFileExceedsFileSizeLimitHandler implements
		HandlerExceptionResolver {
	@Autowired
	private Y41aUDAErrorManager errorManager;

	public ModelAndView resolveException(HttpServletRequest request,
			HttpServletResponse response, Object handler, Exception ex) {
		if (ex instanceof MaxUploadSizeExceededException) {
			try {
				Y41aUDAException e = new Y41aUDAException(
						"error.maxFileSizeError", true, new Exception());

				response.setStatus(422);

				Writer w = null;
				w = response.getWriter();
				w.write(errorManager.process(e, request));
				w.flush();
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else if (ex instanceof Y41aUDAException) {
			try {
				response.setStatus(HttpServletResponse.SC_CONFLICT);

				Writer w = null;
				w = response.getWriter();
				w.write(errorManager.process((Y41aUDAException) ex, request));
				w.flush();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return null;
	}
}
