package com.ejie.y41a.constantes;

import java.math.BigDecimal;

public class Y41aConstantes {

	public static final String CONFIG_PATH = "/y41a/y41a.properties";
	public static final String SESSIONCENSOMONITORCONNECTED = "SESSIONCENSOMONITORCONNECTED";

	// Numeros mágicos
	public static final int NUM_0x7F = 0x7F;
	public static final int NUM_0 = 0;
	public static final int NUM_1 = 1;
	public static final int NUM_2 = 2;
	public static final int NUM_3 = 3;
	public static final int NUM_4 = 4;
	public static final int NUM_5 = 5;
	public static final int NUM_6 = 6;
	public static final int NUM_7 = 7;
	public static final int NUM_8 = 8;
	public static final int NUM_10 = 10;
	public static final int NUM_12 = 12;
	public static final int NUM_16 = 16;
	public static final int NUM_40 = 40;
	public static final int NUM_128 = 128;
	public static final int NUM_200 = 200;
	public static final int NUM_255 = 255;
	public static final int NUM_300 = 300;
	public static final int NUM_1024 = 1024;
	public static final int NUM_3000 = 3000;
	public static final int NUM_4000 = 4000;

	/**
	 * Exportación a excel
	 */
	public static final int EXCEL_NUMERO_MAXIMO_RESULTADOS = 2000;

	/**
	 * Constantes ordenacion consulta.
	 */
	public static final String ORDENACION_ASC = "ASC";
	public static final String ORDENACION_DESC = "DESC";

	/**
	 * Código de idioma castellano.
	 */
	public static final String CASTELLANO = "es";
	/**
	 * Código de idioma euskera.
	 */
	public static final String EUSKERA = "eu";

	public static final String SI = "S";
	public static final String NO = "N";
	public static final String SI_COMPLETO = "Si";
	public static final String NO_COMPLETO = "No";
	public static final String CERO = "0";
	public static final String VACIO = "";

	/**
	 * Constante para controlar si es la primera vez que el usuario entra en la
	 * aplicación.
	 */
	public static final String PRIMERA_VEZ = "S";

	/**
	 * Tamaño de las PK de las tablas de BBDD
	 */
	public static final int PK_SIZE = 20;

	/**
	 * Tamaño de campos de texto
	 */
	public static final int MINLENGTH_OBJECT_NAME = 0;
	public static final int MAXLENGTH_OBJECT_NAME = 255;

	public static final int BUFFER_50 = 50;
	public static final int BUFFER_100 = 100;
	public static final int BUFFER_200 = 200;
	public static final int BUFFER_250 = 250;
	public static final int BUFFER_300 = 300;
	public static final int BUFFER_3000 = 3000;

	/* NODO RAIZ */
	public static final String NODO_RAIZ = "G_ROOT";

	/* GRUPO NEUTRO - ORGANISMOS SIN GRUPO FIJO */
	public static final String GRUPO_RAIZ_ID = "ROOT";

	/**
	 * Sector de establecimiento Primario
	 */
	public static final String SECTOR_ESTABLECIMIENTO_PRIMARIO = "P";

	/**
	 * Elemento seleccionable
	 */
	public static final String ELEMENTO_SELECCIONABLE = "E";

	/**
	 * RADIOS
	 */
	public static final String SITUACION_TODAS = "";
	public static final String SITUACION_PENDIENTES = "P";
	public static final String SITUACION_RESUELTAS = "R";

	public static final String SEXO_HOMBRE = "H";
	public static final String SEXO_MUJER = "M";

	public static final String VALOR_SI = "S";
	public static final String VALOR_NO = "N";

	public static final String NULL = "null";
	public static final String HABITUALES = "S";
	public static final String ESTABLECIMIENTOS = "S";

	public static final String ACTIVIDAD_SECTOR_INDICADOR = "P";

	/**
	 * Codigo Organismo LAKUA
	 */
	public static final String CODIGO_ORGANISMO_LAKUA = "01A106";

	/**
	 * Tipos de forma presentacion consultas
	 */
	public static final String FORMA_PRESENTACION_WEB = "W";
	public static final String FORMA_PRESENTACION_FAX = "F";

	/**
	 * FORMATO FECHAS CON HORA
	 */
	public static final String FORMATO_FECHAHORA_ES = "dd/MM/yyyy HH:mm";
	public static final String FORMATO_FECHAHORA_EU = "yyyy/MM/dd HH:mm";
	public static final String FORMATO_HORA = "HH:mm:ss";
	public static final String FORMATO_ANYO = "yyyy";
	public static final String FORMATO_FULL_FECHA_ES = "EEEE, dd 'de' MMMM 'de' yyyy";
	public static final String FORMATO_FULL_FECHA_EU = "EEEE, yyyy'ko' MMMM'ren' d'a'";
	public static final String FORMATO_FECHA_ES = "dd/MM/yyyy";
	public static final String FORMATO_FECHA_EU = "yyyy/MM/dd";

	public static final int NUM_CARACTERES_FECHA = 11;

	/**
	 * Tipo de origen de documentos Consulta
	 */
	public static final String ORIGEN_APORTADO_CIUDADANO = "CO";
	public static final String ORIGEN_APORTADO_ADMINISTRACION = "A";

	/**
	 * Tipo de documento Consulta
	 */
	public static final String TIPO_DOCUMENTO_CONSULTA_CONSULTA = "C";
	public static final String TIPO_DOCUMENTO_CONSULTA_RESPUESTA = "R";

	public static final BigDecimal NUM_CERO = new BigDecimal(0);

	/**
	 * Tipo de respuesta de consulta EMAIL
	 */
	public static final String TIPO_RESPUESTA_CONSULTA_EMAIL = "EML";

	/**
	 * Comunicacion
	 */
	public static final String COMUNICACION_LEIDA = "CL";
	public static final String COMUNICACION_NO_LEIDA = "CN";

	/**
	 * Solicitudes - Indicador de gestion
	 */
	public static final String SOLICITUDES_MIGESTION = "M";
	public static final String SOLICITUDES_TODAS = "T";
	public static final String SOLICITUDES_RECIBIDAS = "R";
	public static final String SOLICITUDES_TRASLADADAS = "E";
	public static final String SOLICITUDES_ARBITRAJE = "A";

	/**
	 * Solicitudes - Estado de la solicitud
	 */
	public static final String SOLICITUD_ESTADO_ARBITRAJE = "A";
	public static final String SOLICITUD_ESTADO_TRASLADADO = "T";
	public static final String SOLICITUD_ESTADO_COMUNICADO = "C";
	public static final String SOLICITUD_ESTADO_MIGESTION = "PR";

	/**
	 * Mediacion Solicitud
	 */
	public static final String SOLICITUD_MEDIACION = "M";
	public static final String SOLICITUD_ARBITRAJE = "A";

	/**
	 * Codigos de tramites de solicitudes
	 */
	public static final String TRAMITE_SOLICITUD_REGISTRO_SOLICITUD = "1";
	public static final String TRAMITE_SOLICITUD_REQUERIR_SUBSANACION = "3";
	public static final String TRAMITE_SOLICITUD_SOLICITUD_ALEGACION = "4";
	public static final String TRAMITE_SOLICITUD_COMUNICACION_ALEGACIONES = "7";
	public static final String TRAMITE_SOLICITUD_RECEPCION_ALEGACIONES = "6";
	public static final String TRAMITE_SOLICITUD_REGISTRO_DECISION = "13";
	public static final String TRAMITE_SOLICITUD_EMAIL = "15";
	public static final String TRAMITE_SOLICITUD_TRASLADO_SOLICITUD = "16";
	public static final String TRAMITE_SOLICITUD_INSPECCION_PRESENCIAL = "11";

	/**
	 * Fese tramites de solicitudes de Konbide
	 */
	public static final String FASE_TRASLADO = "07";

	/**
	 * Codigos de tramites de solicitudes de Konbide
	 */
	public static final String TRAMITE_COMUNICACION = "K20";
	public static final String TRAMITE_TRASLADO_RED_CIAC = "K12";
	public static final String TRAMITE_SOLICITUD_RECEPCION_TRASLADO_KONBIDE = "K13";
	public static final String TRAMITE_GENERICO_KONBIDE = "K25";

	/**
	 * Estado tramite de solicitudes de Konbide
	 */
	public static final String ESTADO_TRAMITE_ENTRAMITACION = "E";

	/**
	 * Tipos de intervinientes de Konbide
	 */
	public static final String TIPO_INTERVINIENTESOL_INTERESADO = "I";
	public static final String TIPO_INTERVINIENTESOL_DEMANDADO = "D";
	public static final String TIPO_INTERVINIENTESOL_ADMINISTRACION = "A";
	public static final String TIPO_INTERVINIENTESOL_OTROS = "O";

	/**
	 * Codigos de decisiones de solicitudes
	 */
	public static final String DECISION_ARBITRAJE = "ARPA";
	public static final String DECISION_TRASLADO_ORGANISMOS_FUERA_CIAC = "TR";
	public static final String DECISION_TRASLADO_ORGAMISMOS_CONSUMO = "TR";
	public static final String DECISION_INHIBICION_ORGAMISMOS_NO_CONSUMO = "IH";

	/**
	 * Tipo de origen de documentos Solicitud
	 */
	public static final String ORIGEN_SOL_APORTADO_RECLAMANTE = "CO";
	public static final String ORIGEN_SOL_APORTADO_RECLAMADO = "ES";
	public static final String ORIGEN_SOL_APORTADO_ADMINISTRACION = "A";

	/**
	 * Tipo de origen de documentos Inspecciones
	 */
	public static final String ORIGEN_INS_APORTADO_VISITADO = "V";
	public static final String ORIGEN_INS_APORTADO_RESPONSABLE = "R";
	public static final String ORIGEN_INS_APORTADO_ADMINISTRACION = "A";

	/**
	 * Nombre Plantilla Tramite Hecho
	 */
	public static final String NOMBRE_PLANTILLA_XML_TRAMITE_CASTELLANO = "tramitehecho.xml";

	/**
	 * Nombre Plantilla Decision Hecho
	 */
	public static final String NOMBRE_PLANTILLA_XML_DECISION_CASTELLANO = "tramitedecision.xml";

	/**
	 * Nombre Plantilla Inspecciones
	 */
	public static final String NOMBRE_PLANTILLA_XML_INSPECCIONES_CASTELLANO = "cartasinspecciones.xml";

	/**
	 * Tipo de transmision
	 */
	public static final String TIPO_TRANSMISION_TRASLADO = "T";
	public static final String TIPO_TRANSMISION_COMUNICACION = "C";
	public static final String TIPO_TRANSMISION_INHIBICION = "I";

	/**
	 * Consumidores
	 */
	public static final String NIF = "1";
	public static final String NIE = "2";
	public static final String IDENEXTRANJERA = "3";

	/**
	 * Codigos de grupos de organismos para KontsumoNet
	 */
	public static final String COD_GRUPO_ADMINISTRACION_AUTONOMICA = "G_A";
	public static final String COD_GRUPO_ASOCIACION_CONSUMIDORES = "G_C";
	public static final String COD_GRUPO_JUNTAS_ARBITRALES = "G_J";
	public static final String COD_GRUPO_ADMINISTRACION_LOCAL = "G_L";

	/**
	 * Inspecciones Campañas/Alertas/Denuncias
	 */
	public static final String TIPO_CAMPAHNA = "C";
	public static final String TIPO_ALERTA = "A";
	public static final String TIPO_DENUNCIA = "D";

	/**
	 * Situacion Inspecciones Campañas/Alertas/Denuncias
	 */
	public static final String CAMPAHNA_SIN_ACTUACION = "S";
	public static final String CAMPAHNA_CON_ACTUACION = "C";
	public static final String CAMPAHNA_FINALIZADA = "F";

	/**
	 * Plantillas Word Ficha Consultas
	 */
	public static final String NOMBRE_PLANTILLA_CONSULTAS_FICHA_RTF = "consulta-2012.rtf";
	public static final String NOMBRE_PLANTILLA_CONSULTAS_FICHA_XML = "consulta-2012.xml";

	/**
	 * Plantillas Word Ficha Solicitudes
	 */
	public static final String NOMBRE_PLANTILLA_SOLICITUDES_FICHA_XML = "solicitud-2012.xml";
	public static final String NOMBRE_PLANTILLA_SOLICITUDES_FICHA_REDUCIDA_XML = "solicitud-reducida-2012.xml";

	/**
	 * Origen Documentos Acta - Estado de la solicitud
	 */
	public static final String ESTABLECIMIENTO_VISITADO = "V";
	public static final String GENERADO_ADMINISTRACION = "A";
	public static final String ESTABLECIMIENTO_RESPONSABLE = "R";

	/**
	 * Estadisticas de kontsumonet
	 */
	public static final String ESTADISTICAS_KONTSUMONET_CONSULTAS = "C";
	public static final String ESTADISTICAS_KONTSUMONET_SOLICITUDES = "S";
	public static final String ESTADISTICAS_KONTSUMONET_COMUNICACIONES = "M";
	public static final String EXCEL_ESTADISTICASKONTMUNET = "Estadisticas Kontsumonet";

	/**
	 * Búsqueda de consultas
	 */
	public static final String EXCEL_BUSQUEDA_CONSULTAS = "consultas";

	/**
	 * Estadisticas de consultas
	 */
	public static final String ESTADISTICAS_CONSULTAS_FORMA_PRESENTACION = "COE01";
	public static final String ESTADISTICAS_CONSULTAS_MOTIVOS_PRODUCTOS = "COE03";
	public static final String ESTADISTICAS_CONSULTAS_PRODUCTOS = "COE04";
	public static final String ESTADISTICAS_CONSULTAS_SEXO_EDAD = "COE05";
	public static final String ESTADISTICAS_CONSULTAS_PROMEDIO_TIEMPO_RESPONDER_CONSULTA = "COE06";
	public static final String ESTADISTICAS_CONSULTAS_TIEMPO_ATENCION_CONSULTAS_PRESENCIALES = "COE07";
	public static final String ESTADISTICAS_CONSULTAS_TIEMPO_RESPUESTA_CONSULTAS_WEB_FAX = "COE08";

	/**
	 * Listados de consultas
	 */
	public static final String LISTADOS_CONSULTAS_RELACION_CONSULTAS = "COR01";
	public static final String LISTADOS_CONSULTAS_RELACION_CONSULTAS_ABREVIADA = "COR02";
	public static final String LISTADOS_CONSULTAS_GENERAL = "COR99";

	/**
	 * Búsqueda de solicitudes
	 */
	public static final String EXCEL_BUSQUEDA_SOLICITUDES = "solicitudes";

	/**
	 * Estadisticas de solicitudes
	 */
	public static final String ESTADISTICAS_SOLICITUDES_DECISIONES_LOCALIDAD_ESTABLECIMIENTO = "DEE01";
	public static final String ESTADISTICAS_SOLICITUDES_DECISIONES_LOCALIDAD_CONSUMIDOR = "DEE01b";
	public static final String ESTADISTICAS_SOLICITUDES_SECTORES_LOCALIDAD_ESTABLECIMIENTO = "DEE02";
	public static final String ESTADISTICAS_SOLICITUDES_MOTIVOS = "DEE03";
	public static final String ESTADISTICAS_SOLICITUDES_DECISIONES = "DEE04";
	public static final String ESTADISTICAS_SOLICITUDES_FORMA_PRESENTACION_LOCALIDAD_CONSUMIDOR = "DEE05";
	public static final String ESTADISTICAS_SOLICITUDES_SECTORES_LOCALIDAD_CONSUMIDOR = "DEE06";
	public static final String ESTADISTICAS_SOLICITUDES_SEXO_EDAD = "DEE07";
	public static final String ESTADISTICAS_SOLICITUDES_PROMEDIO_TIEMPO_RESOLVER_SOLICITUD = "DEE09";
	public static final String ESTADISTICAS_SOLICITUDES_PRODUCTOS_LOCALIDAD_ESTABLECIMIENTO = "DEEP1";
	public static final String ESTADISTICAS_SOLICITUDES_PRODUCTOS_LOCALIDAD_CONSUMIDOR = "DEEP1b";

	// new 0132627
	public static final String ESTADISTICAS_SOLICITUDES_FORMA_VENTA_MUNICIPIO_CONSUMIDOR = "DEE13";

	/**
	 * Listados de solicitudes
	 */
	public static final String LISTADOS_SOLICITUDES_RELACION_SOLICITUDES_PRODUCTO_MOTIVO = "DER01";
	public static final String LISTADOS_SOLICITUDES_RELACION_ESTABLECIMIENTOS = "DER03";
	public static final String LISTADOS_SOLICITUDES_RELACION_PRODUCTOS = "DER04";
	public static final String LISTADOS_SOLICITUDES_RELACION_SOLICITUDES_SIN_DECISION = "DER05";
	public static final String LISTADOS_SOLICITUDES_RELACION_SOLICITUDES_CON_DECISION = "DER08";
	public static final String LISTADOS_SOLICITUDES_RELACION_ESTADO_EXPEDIENTES_CURSO = "DER09";
	public static final String LISTADOS_SOLICITUDES_RELACION_TIEMPO_TRAMITACION = "DER11";
	public static final String LISTADOS_SOLICITUDES_RELACION_TIEMPO_REALIZACION_PRIMER_TRAMITE = "DER12";
	public static final String LISTADOS_SOLICITUDES_GENERAL = "DER99";

	// Tipo solicitud
	public static final String TIPO_SOLICITUD_DENUNCIA = "D";
	public static final String TIPO_SOLICITUD_QUEJA = "Q";
	public static final String TIPO_SOLICITUD_RECLAMACION = "R";

	/* Tipo identificacion */
	public static final String TIPO_IDENTIFICACION_NIF = "1";
	public static final String TIPO_IDENTIFICACION_NIE = "2";
	public static final String TIPO_IDENTIFICACION_IDEXTR = "3";

	/**
	 * Código de idioma castellano.
	 */
	public static final String VC_CASTELLANO = "C";
	/**
	 * Código de idioma euskera.
	 */
	public static final String VC_EUSKERA = "V";

	/* CAPV */
	public static final String CAPV = "16";

	/* SINDECISION */
	public static final String SIND = "SIND";

	// Incidencia 69147 Nora
	/*
	 * LOCALIZACION
	 */
	public static final String NORA_LOCALIZACION_TODOS = "T";

	public static final String NORA_LOCALIZACION_ESTADO = "E";

	public static final String NORA_LOCALIZACION_EXTRANJERO = "X";

	public static final String CONTROL_LOCALIZACION_DOCUMENTOS = "CONTROL_LOCALIZACION_DOCUMENTOS";

	public static final String PDF = "pdf";

	/* ARBITRAJES */
	public static final String ACTIVAR_ARBITRAJE = "ACTIVAR_ARBITRAJE";
	public static final String TIPO_SAN_EXPREL_ORIGEN = "S";
	public static final String TIPO_PROC_SOLICITUDES = "SOL";
	public static final String TIPO_PROC_SANCIONES = "SAN";
	public static final String TIPO_PROC_ARBITRAJE = "ARB";

	/**
	 * Estado tramite
	 */
	public enum EstadoTramite {
		PENDIENTE_FIRMA("P"), PENDIENTE_LOCALIZACION("I"), LOCALIZADO("L"), ERRORLOCALIZACION(
				"R"), ENTRAMITACION("E"), FIRMADO("F"), TRAMITADO("T"), FIRMADENEGADA(
				"D");

		private String codigo;

		/**
		 * @return the codigo
		 */
		public String getCodigo() {
			return codigo;
		}

		/**
		 * @param codigo
		 *            the codigo to set
		 */
		public void setCodigo(String codigo) {
			this.codigo = codigo;
		}

		private EstadoTramite(String codigo) {
			this.codigo = codigo;
		}
	}

	public static String RESPUESTA_TRASPASO_ACEPTADA = "A";

	/**
	 * Perfiles
	 */
	public static final String PERFIL_COORDINADOR = "Y41B-GU-0003";

	// Content Type
	public static final String CONTENT_TYPE_MSWORDX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";

	public static final String ARABA = "01";
	public static final String GIPUZKOA = "20";
	public static final String BIZKAIA = "48";

	public static final String MODO_POPUP_SELECCION = "POPUP_SELECCION";

	public static final String CODIGO_USUARIO_MIGRACION = "MI2";
}
