package com.ejie.y41a.aop;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
//import java.sql.ResultSet;
import java.sql.SQLException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Proxy de metodos de la clase Connection. Se controla la llamada de cierre de
 * conexion para limpiar la informacion de usuario de la conexion
 * 
 *  
 * 
 */
public class ConnectionMethodProxy implements InvocationHandler {

	/**
	 * Logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(ConnectionMethodProxy.class);

	private Connection connection;

	/**
	 * Nueva instancia.
	 * 
	 * @param connection
	 *            conexion
	 * @return conexion
	 */
	public static Connection newInstance(Connection connection) {
		return (Connection) Proxy.newProxyInstance(connection.getClass()
				.getClassLoader(), new Class[] { Connection.class },
				new ConnectionMethodProxy(connection));
	}

	/**
	 * Constructor.
	 * 
	 * @param connection
	 *            conexion
	 */
	private ConnectionMethodProxy(Connection connection) {
		this.connection = connection;
	}

	@Override()
	public Object invoke(Object proxy, Method method, Object[] args)
			throws Throwable {

		String methodName = method.getName();
		// String targetName = this.connection.getClass().getName();
		// Class<?>[] types = method.getParameterTypes();
		// String returnTypeName = method.getReturnType().getName();

		if ("close".equals(methodName)) {
			this.terminaUsuario(this.connection);
		}
		// (System.out).println("=============================");
		// (System.out).println(" Connection method call detected:");
		// (System.out).println("  - Target     : " + targetName);
		// (System.out).println("  - Method     : " + methodName);
		// (System.out).println("  - Arguments  : " +
		// ArrayUtils.toString(args));
		// (System.out).println("  - Arg Types  : " +
		// ArrayUtils.toString(types));
		// (System.out).println("  - Return type: " + returnTypeName);
		// (System.out).println("=============================");

		return method.invoke(this.connection, args);
	}

	/**
	 * Limpieza del usuario en la conexion de base de datos
	 * 
	 * @param conn
	 *            conexion
	 */
	private void terminaUsuario(Connection conn) {
		// PreparedStatement pstmt = null;
		PreparedStatement pstmt2 = null;
		// ResultSet rset = null;
		try {
			// pstmt =
			// conn.prepareStatement("CALL SYSAUDITOR.TERMINA_USUARIO()");
			// pstmt.execute();
			// pstmt2 =
			// conn.prepareStatement("CALL L21.SESSION_VAR.CLEAR_USER()");
			// if (ConnectionMethodProxy.logger.isInfoEnabled()) {
			// ConnectionMethodProxy.logger
			// .info("TerminaUsuario: Llamada a obtencion de valor de sesion");
			// pstmt2 = conn
			// .prepareStatement("SELECT sys_context('USERENV','SESSIONID') FROM DUAL");
			// rset = pstmt2.executeQuery();
			//
			// if (rset.next()) {
			// ConnectionMethodProxy.logger
			// .info("Valor sesion recuperado "
			// + rset.getString(1));
			// } else {
			// ConnectionMethodProxy.logger
			// .info("No se ha recuperado valor de sesion");
			// }
			// pstmt2.close();
			// }

			// pstmt2 = conn.prepareStatement("CALL L21.SET_USERNAME('')");
			// pstmt2.execute();
			//
			// pstmt2.close();
			pstmt2 = conn
					.prepareStatement("CALL DBMS_SESSION.CLEAR_IDENTIFIER()");
			pstmt2.execute();

			if (ConnectionMethodProxy.logger.isInfoEnabled()) {
				ConnectionMethodProxy.logger
						.info("Llamada a DBMS_SESSION.CLEAR_IDENTIFIER");
				// pstmt2.close();
				// pstmt2 = conn
				// .prepareStatement("SELECT L21.GET_USERNAME() FROM DUAL");
				// rset = pstmt2.executeQuery();
				// if (rset.next()) {
				// ConnectionMethodProxy.logger.info("Valor recuperado "
				// + rset.getString(1));
				// } else {
				// ConnectionMethodProxy.logger
				// .info("No se ha recuperado valor");
				// }
				// rset.close();
				// pstmt2.close();
				// pstmt2 = conn
				// .prepareStatement("SELECT SYS_CONTEXT('userenv', 'client_identifier') FROM dual");
				// rset = pstmt2.executeQuery();
				// if (rset.next()) {
				// ConnectionMethodProxy.logger
				// .info("Valor recuperado identifier"
				// + rset.getString(1));
				// } else {
				// ConnectionMethodProxy.logger
				// .info("No se ha recuperado valor de identifier");
				// }
			}
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			try {
				// if (pstmt != null) {
				// pstmt.close();
				// }
				// if (rset != null) {
				// rset.close();
				// }
				if (pstmt2 != null) {
					pstmt2.close();
				}
			} catch (SQLException ex) {
				ex.printStackTrace();
			}
		}
	}

}
