package com.ejie.y41a.aop;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Clase interceptora de llamadas de la clase Connection
 * 
 *  
 * 
 */
public class ConnectionCallInterceptor implements MethodInterceptor {

	/**
	 * Logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(ConnectionCallInterceptor.class);

	@Override()
	public Object invoke(MethodInvocation methodInvocation) throws Throwable {

		String methodName = methodInvocation.getMethod().getName();
		if ("getConnection".equals(methodName)) {
			// return proxied connection
			Connection connection = (Connection) methodInvocation.proceed();
			this.inicializaUsuario(connection);
			return ConnectionMethodProxy.newInstance(connection);
		} else {
			// simply return methodcall result
			return methodInvocation.proceed();
		}
	}

	/**
	 * Inicializacion del usuario en la conexion de base de datos
	 * 
	 * @param conn
	 *            conexion
	 */
	private void inicializaUsuario(Connection conn) {
		String usuario = "y41a";
		// PreparedStatement pstmt = null;
		PreparedStatement pstmt2 = null;
		// ResultSet rset = null;
		try {
			// pstmt = conn
			// .prepareStatement("CALL SYSAUDITOR.IDENTIFICA_USUARIO(?)");
			// pstmt.setString(1, usuario);
			// pstmt.execute();
			// pstmt2 =
			// conn.prepareStatement("CALL L21.SESSION_VAR.SET_USER(?)");
			// if (ConnectionCallInterceptor.logger.isInfoEnabled()) {
			// ConnectionCallInterceptor.logger
			// .info("InicializaUsuario: Llamada a obtencion de valor de sesion");
			// pstmt2 = conn
			// .prepareStatement("SELECT sys_context('USERENV','SESSIONID') FROM DUAL");
			// rset = pstmt2.executeQuery();
			//
			// if (rset.next()) {
			// ConnectionCallInterceptor.logger
			// .info("Valor sesion recuperado "
			// + rset.getString(1));
			// } else {
			// ConnectionCallInterceptor.logger
			// .info("No se ha recuperado valor de sesion");
			// }
			// rset.close();
			// pstmt2.close();
			// }

			// pstmt2 = conn.prepareStatement("CALL L21.SET_USERNAME(?)");
			// pstmt2.setString(1, usuario);
			// pstmt2.execute();
			//
			// pstmt2.close();
			pstmt2 = conn
					.prepareStatement("CALL DBMS_SESSION.SET_IDENTIFIER(?)");
			pstmt2.setString(1, usuario);
			pstmt2.execute();

			if (ConnectionCallInterceptor.logger.isInfoEnabled()) {
				ConnectionCallInterceptor.logger
						.info("Llamada a DBMS_SESSION.SET_IDENTIFIER con usuario "
								+ usuario);
				// pstmt2.close();
				// pstmt2 = conn
				// .prepareStatement("SELECT L21.GET_USERNAME() FROM DUAL");
				// rset = pstmt2.executeQuery();
				//
				// if (rset.next()) {
				// ConnectionCallInterceptor.logger.info("Valor recuperado "
				// + rset.getString(1));
				// } else {
				// ConnectionCallInterceptor.logger
				// .info("No se ha recuperado valor");
				// }
				//
				// rset.close();
				// pstmt2.close();
				// pstmt2 = conn
				// .prepareStatement("SELECT SYS_CONTEXT('userenv', 'client_identifier') FROM dual");
				// rset = pstmt2.executeQuery();
				// if (rset.next()) {
				// ConnectionCallInterceptor.logger
				// .info("Valor recuperado identifier"
				// + rset.getString(1));
				// } else {
				// ConnectionCallInterceptor.logger
				// .info("No se ha recuperado valor de identifier");
				// }
			}

		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			try {
				// if (pstmt != null) {
				// pstmt.close();
				// }
				// if (rset != null) {
				// rset.close();
				// }
				if (pstmt2 != null) {
					pstmt2.close();
				}
			} catch (SQLException ex) {
				ex.printStackTrace();
			}
		}
	}
}
