/* ************************************************************************************************************************************************************
 * INICIALIZACION
 * ************************************************************************************************************************************************************
 */
jQuery(function($) {	
		
	var seleccionado = "";
	var y41aVarSolicitudTramitacionFechaDecisionCargada = "";

	//Feedback
	$("#y41aSolicitudTramitacionDivFeedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	// Fecha decision 
	$("#y41aSolicitudTramitacionFechaDecision").rup_date ({duration : "fast"});	
	// numSolicitud
	$("#y41aSolicitudTramitacionCodOrganismo").val($("#y41aSolicitudDetalleCodOrganismo").val());
	$("#y41aSolicitudTramitacionNumSolicitud").val($("#y41aSolicitudDetalleNumSolicitud").val());
	$("#y41aSolicitudTramitacionAnyo").val($("#y41aSolicitudDetalleAnyo").val());
	$("#y41aSolicitudTramitacionNumHecho").val($("#y41aSolicitudDetalleNumHecho").val());
	//acciones
	y41aFunctionSolicitudTramitacionPintarTabla();
	y41aSolicitudTramitacionFunctionPintarComboDecision();
	y41aFunctionSolicitudTramitacionCargarDecision();
	ocultarCapaCargando();
});
/* ****************************************************************************************************************************************************************
 * FIN INICIALIZACION
 * ****************************************************************************************************************************************************************
 */

/* **************************
 * Pintar tabla tramitacion * 
 * **************************
 */
function y41aFunctionSolicitudTramitacionPintarTabla(){	
	
	
		$('#y41aSolicitudTramitacionTabla').jqGrid('GridUnload');
	
	
	
	var y41aVarSolicitudTramitacionGridWidthTabla = $("#y41aTabsDetalleSolicitud").width()-22;
	
	$("#y41aSolicitudTramitacionTabla").rup_grid({
		url:"/y41aVistaWar/denuncia/tramitacion/"+y41aVarSolicitudesCodigoHecho+"?R01HNoPortal=true",
		loadOnStartUp: true,
		width: y41aVarSolicitudTramitacionGridWidthTabla,
		pagerName:"y41aSolicitudTramitacionTablaPager",
		rowNum: "10",
		colNames:[
			$.rup.i18n.app.y41aSolicitudTramitacionTabla.ehcodigo,
		    $.rup.i18n.app.y41aSolicitudTramitacionTabla.trnombre, 
		    $.rup.i18n.app.y41aSolicitudTramitacionTabla.q5nofile,
		    $.rup.i18n.app.y41aSolicitudTramitacionTabla.q5nofile,
		    $.rup.i18n.app.y41aSolicitudTramitacionTabla.ehfecha,
		    $.rup.i18n.app.y41aSolicitudTramitacionTabla.ehhora,
		    $.rup.i18n.app.y41aSolicitudTramitacionTabla.monombre,
		    $.rup.i18n.app.y41aSolicitudTramitacionTabla.ehacuse
		],
		colModel: [	    
		    { 	name: "ehcodigo", 
		    	index: "ehcodigo",
		    	hidden: true
		    },
		    { 	name: "trnombre" + recuperarLetraIdioma(),
		    	index: "trnombre"+ recuperarLetraIdioma(),
		    	width: funcPercentage(25,y41aVarSolicitudTramitacionGridWidthTabla)
		    },
		    { 	name: "multiDocumento",
				index: "multiDocumento",
				formatter: mostrarEnlace,
				sortable: false,
				width: funcPercentage(30,y41aVarSolicitudTramitacionGridWidthTabla)
			},
		    { 	name: "q5nofile",
		    	index: "q5nofile",
		    	hidden:true
		    },
		    { 	name: "ehfecha", 
		    	index: "ehfecha" ,
		    	align: "center",
		    	width: funcPercentage(12,y41aVarSolicitudTramitacionGridWidthTabla)
		    },
		    { 	name: "ehhora", 
		    	index: "ehhora" ,
		    	align: "center",
		    	width: funcPercentage(12,y41aVarSolicitudTramitacionGridWidthTabla)
		    },		    
		    { 	name: "monombre", 
	    		index: "monombre",
	    		width: funcPercentage(20,y41aVarSolicitudTramitacionGridWidthTabla)
	    	},
	    	{ 	name: "ehacuse", 
		    	index: "ehacuse",
		    	formatter: y41aDeFechaAcuseAImagen,
		    	align: "center",
		    	width: funcPercentage(6,y41aVarSolicitudTramitacionGridWidthTabla)
			}			

		]
	});
}


/**
 * Abre la ventana modal que muestra la lista de documentos de un trámite para su visualización
 * @param idTramite	ehcodigo
 */
function abreModalDocTramite (idTramite){
	y41aVarModalDocsIdTramite = idTramite; 
	$("#y41aModalDocTramiteDiv").rup_dialog("destroy");
	$("#y41aModalDocTramiteDiv").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "500",
		height: "auto",
		title: $.rup.i18n.app.y41aTitlesModalesSolicitudes.documentosTramite,
		url: "/y41aVistaWar/denuncia/y41aSolicitudTramitacionModal?R01HNoPortal=true",
		type:$.rup.dialog.AJAX
	});	
}

/**
 * Formatea el enlace de los documentos del trámite, mostrando un enlace para abrir el documento si solo hay uno, 
 * o un enlace para abrir la ventana modal si hay mas de uno
 * @param cellvalue	datos de la celda
 * @param options	opciones
 * @param rowObject	objeto fila
 * @returns {String} enlace para descargar un documento o abrir una modal o vacío si no hay documentos
 */
function mostrarEnlace(cellvalue, options, rowObject) {
	if (cellvalue!=undefined && cellvalue!=null && cellvalue=="S"){
		return "<a href='#' onclick='javascript:abreModalDocTramite(\""+rowObject.ehcodigo+"\");'>" + $.rup.i18n.app.y41aSolicitudTramitacionTabla.documentos + "</a>";
	}else if (cellvalue!=undefined && cellvalue!=null && cellvalue=="N"){
		return "<a href='/y41aVistaWar/denuncia/documentacion/link/"+ rowObject.q5codocumento+"?R01HNoPortal=true'>" + rowObject.q5tedesfile + "</a>";
	}else{
		return "";
	}
}

function y41aDeFechaAcuseAImagen(cellvalue, options, rowObject) {
	if (cellvalue=="" || cellvalue=="null" || cellvalue==null){
		return "";
	}else{
		return '<img src="'+$.rup.APP_STATICS+'/images/y41a-acuserecibo.png"  width="16" height="16">';	
	}
}


//boton ver (detalle )
$("#y41aSolicitudTramitacionBotonVer").click(function () {
	var selectedRow = $("#y41aSolicitudTramitacionTabla").rup_grid("getSelectedRows")[0];
	row = $("#y41aSolicitudTramitacionTabla").rup_grid("getRowData", selectedRow);
	var codigo = row.ehcodigo;
	if(codigo == "" || codigo == null)
		{
			$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("option", "delay", 800);
			$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
	else
		{
			seleccionado = codigo;
			title=  $.rup.i18n.app.y41aTitlesModalesSolicitudes.detalleTramite;
			y41aFunctionSolicitudTramitacionMostrarModalDetalle(title);
		}
	
});	

//boton añadir (detalle alta)
$("#y41aSolicitudTramitacionBotonAniadir").click(function () {
	seleccionado ="";
	title=  $.rup.i18n.app.y41aTitlesModalesSolicitudes.altaTramite;
	y41aFunctionSolicitudTramitacionMostrarModalDetalle(title);
});	

//apertura modal detalle
function y41aFunctionSolicitudTramitacionMostrarModalDetalle(title){
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalle").rup_dialog("destroy");
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalle").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "780",
		height: "auto",
		title: title,
		url: "/y41aVistaWar/denuncia/y41aSolicitudTramitacionDetalle?R01HNoPortal=true",
		type:$.rup.dialog.AJAX
	});		
}

//boton cancelar
$("#y41aSolicitudTramitacionDetalleBotonCancelar").click(function () {
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalle").rup_dialog("close");
});	

//refresco de la tabla una vez cerrada la modal de tramite detalle
function y41aSolicitudTramitacionActualizarTabla(){
	$("#y41aSolicitudTramitacionTabla").rup_grid("clearGridData");
	$("#y41aSolicitudTramitacionTabla").rup_grid("setGridParam", {url : "/y41aVistaWar/denuncia/tramitacion/"+y41aVarSolicitudesCodigoHecho+"?R01HNoPortal=true"});
	$("#y41aSolicitudTramitacionTabla").rup_grid("reloadGrid");
}

/* ****************************************************************************************************
 * Boton de eliminar
 * ****************************************************************************************************
 */	
// Eliminar - onclick del boton
$("#y41aSolicitudTramitacionBotonEliminar").click(function () {
	var selectedRow = $("#y41aSolicitudTramitacionTabla").rup_grid("getSelectedRows")[0];
	row = $("#y41aSolicitudTramitacionTabla").rup_grid("getRowData", selectedRow);
	var codigo = row.ehcodigo;

	if(codigo == "" || codigo == null)
		{
			$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("option", "delay", 800);
			$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
	else
		{
		   $.rup_messages("msgConfirm",{
			   title:$.rup.i18n.app.msg.confirmacion,
			   message: $.rup.i18n.app.msg.confiramacioneliminar,
			   OKFunction : function () {
				   y41aSolicitudTramitacionEliminarRegistro(codigo);
				}
		   });
		}
});

//Eliminar - llamada
function y41aSolicitudTramitacionEliminarRegistro(codigo){
	var jqxhr = $.ajax({
		type : 'DELETE',
		url : "/y41aVistaWar/denuncia/removetramite/" + codigo+"?R01HNoPortal=true",
		error: function (jqXHR, textStatus, errorThrown){
			switch(jqXHR.status){		
				case 406:
					$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("option", "delay",null);
					$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("set",jqXHR.responseText, "error");
					break;
				case 409:
					controlY41aUDAException(jqXHR, "y41aSolicitudTramitacionDivFeedback");
					break;						
				//case 500:	
				default:
					$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("option", "delay",null);
					$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
					break;
			}
		},
		success : function(data) {
					$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("option", "delay",800);
					$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("set", "ok", "ok");
					y41aSolicitudTramitacionActualizarTabla();					
		}
	});
}

/* ****************************************************************************************************
 * cargar decision
 * ****************************************************************************************************
 */	
function y41aFunctionSolicitudTramitacionCargarDecision(){
	$("#y41aSolicitudTramitacionCodHecho").val($("#y41aSolicitudDetalleCodHecho").val());
	
	var hdcodigo = $("#y41aSolicitudTramitacionCodHecho").val();
	
	$.ajax({
		type : "GET",
		url : "/y41aVistaWar/denuncia/tramitacion/getdecision/" + hdcodigo + "?R01HNoPortal=true",
		dataType : "json",
		error : function(jqXHR, textStatus, errorThrown) {
			$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("option", "delay", 800);
			$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("set",$.rup.i18n.app.msg.errorRecuperarDatos, "error");
		},
		success : function(data, textStatus, jqXHR) {	
	
			 $("#y41aSolicitudTramitacionCodHecho").val(data.hdcodigo);
			 $("#y41aSolicitudTramitacionCodDecision").val(data.hccodigo);
			 
			 if (data.decodigo!=null && data.decodigo!=""){
				 $("#y41aSolicitudTramitacionInputDecisionDiv").show();
				 $("#y41aSolicitudDetalleCodDecision").val(data.decodigo);
				 
				 if ("es"==$.rup_utils.get("language")){
					$("#y41aSolicitudTramitacionInputDecision").val(data.denombre);
				 }else if("eu"==$.rup_utils.get("language")){
					$("#y41aSolicitudTramitacionInputDecision").val(data.denombree);
				 }
				 
				 if (data.decodigo==TRASLADO || data.decodigo==INHIBICION){
					if (data.decodigo==TRASLADO){
						y41aVarOrganismosTraslado="y41aSolicitudTramitacionTraslado";
					}else if (data.decodigo==INHIBICION){
						y41aVarOrganismosTraslado="y41aSolicitudTramitacionInhibicion";
					}					
					$("#y41aSolicitudTramitacionOrganismoTrasladoId").val(data.hccoortrasinhibi);
					if ("es"==$.rup_utils.get("language")){
						$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val(data.orgtrasinhibi_nombre);
					}else if("eu"==$.rup_utils.get("language")){
						$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val(data.orgtrasinhibi_nombree);
					}
					
					$("#y41aSolicitudTramitacionULOrganismoTraslado").show();
					
					y41aSolicitudTramitacionOrganismoDecisionSoloConsulta();
					
					
					
				 }
			 }else{
				y41aVarOrganismosTraslado="";
				$("#y41aSolicitudTramitacionULOrganismoTraslado").hide();
				$("#y41aSolicitudTramitacionOrganismoTrasladoId").val("");
				$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val("");
				$("#y41aSolicitudTramitacionComboDecisionDiv").show();
				y41aSolicitudTramitacionFunctionCargarComboDecision(data.decodigo);
			 }
			 if (data.hcfede!=null && data.hcfede!=""){
				 $("#y41aSolicitudTramitacionFechaDecision").rup_date("setDate", data.hcfede);	 
			 }else{
				 $("#y41aSolicitudTramitacionFechaDecision").rup_date("setDate", fechaActual()); 
			 }
			 y41aVarSolicitudTramitacionFechaDecisionCargada = data.hcfede;
			 
			 
			 if (y41aSolicitudModoConsultaDesdeExternos == true){
				 y41aFunctionSolicitudTramitacionAConsulta();
			 }else{
				 if (y41aSolicitudModoConsulta == true){
					 y41aFunctionSolicitudTramitacionAConsulta();
					 y41aSolicitudTramitacionFunctionCasosEspecificosConsulta(data.decodigo);
				 }
			 }					 
			 
		}
	});
}

/* ****************
 * combo decision *
 * ****************
 */

function y41aSolicitudTramitacionFunctionPintarComboDecision(){
	$("#y41aSolicitudTramitacionComboDecision").rup_combo({
		blank : "",
		width : "500",
		maxHeight: "93",
		source : "/y41aVistaWar/plantilladecision/getAllDecision?R01HNoPortal=true",
		sourceParam : {
			label : "denombre"  + recuperarLetraIdioma(),
			value : "decodigo"
		},
		select: function(){
			var seleccion= $("#y41aSolicitudTramitacionComboDecision").rup_combo("getRupValue");
			if ( seleccion== ""){
				y41aVarOrganismosTraslado="";
				$("#y41aSolicitudTramitacionULOrganismoTraslado").hide();
				$("#y41aSolicitudTramitacionFechaDecision").val("");
				$("#y41aSolicitudTramitacionOrganismoTrasladoId").val("");
				$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val("");
				
			}
			else if (seleccion==TRASLADO){
				y41aVarOrganismosTraslado="y41aSolicitudTramitacionTraslado";
				$("#y41aSolicitudTramitacionULOrganismoTraslado").show();
				$("#y41aSolicitudTramitacionOrganismoTrasladoId").val("");
				$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val("");
			}
			else if (seleccion==INHIBICION){
				y41aVarOrganismosTraslado="y41aSolicitudTramitacionInhibicion";
				$("#y41aSolicitudTramitacionULOrganismoTraslado").show();
				$("#y41aSolicitudTramitacionOrganismoTrasladoId").val("");
				$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val("");
			}
			else{
				y41aVarOrganismosTraslado="";
				$("#y41aSolicitudTramitacionULOrganismoTraslado").hide();
				$("#y41aSolicitudTramitacionOrganismoTrasladoId").val("");
				$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val("");
			}
		}
	});
}


/*
 * Combo decisión
 */

function y41aSolicitudTramitacionFunctionCargarComboDecision(decodigo){
	if (decodigo!=null && decodigo!=""){
		$("#y41aSolicitudTramitacionComboDecision").rup_combo("setRupValue",decodigo);	
	}else{
		$("#y41aSolicitudTramitacionComboDecision").rup_combo("select","");
	}
}

function y41aSolicitudTramitacionFunctionEliminarComboDecision(){
	$("#y41aSolicitudTramitacionComboDecision-button").remove();
	$("#y41aSolicitudTramitacionComboDecision-menu").remove();
	$('<select id="y41aSolicitudTramitacionComboDecision" name="decodigo"></select>').replaceAll("#y41aSolicitudTramitacionComboDecision");
}

/*
 * Organismo para traslados e inhibiciones
 */

/**
 * Evento blur del campo código de organismo
 */
$("#y41aSolicitudTramitacionOrganismoTrasladoId").blur(	function () {
		var seleccion= $("#y41aSolicitudTramitacionComboDecision").rup_combo("getRupValue");
		if (seleccion==TRASLADO){
			y41aVarOrganismosTraslado="y41aSolicitudTramitacionTraslado";
		}
		else if (seleccion==INHIBICION){
			y41aVarOrganismosTraslado="y41aSolicitudTramitacionInhibicion";
		}
		
		
		var organismoId = $("#y41aSolicitudTramitacionOrganismoTrasladoId").val();
	
		if (organismoId != ""){
			y41aFunctionBuscarOrganismo(organismoId);
		}else{
			$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val("");
		}
});

/**
 * Recupera la informacion del Organismo asociada al id 
 * @param organismoId Identificador del organismo del que se quiere obtener su descripcion
 * 
 */
function y41aFunctionBuscarOrganismo(organismoId) {
	
	
	var url="";
	
	if(y41aVarOrganismosTraslado=="y41aSolicitudTramitacionTraslado"){
		url="/y41aVistaWar/organismo/liketrasladoOrgTraslado?codOrg=" + organismoId + "&R01HNoPortal=true";
	}else if (y41aVarOrganismosTraslado=="y41aSolicitudTramitacionInhibicion"){
		url="/y41aVistaWar/organismo/liketrasladoOrgInhibicion?codOrg=" + organismoId + "&R01HNoPortal=true";
	}
	$.ajax({
		type : "GET",
		url :url,
		dataType : "json",
		error : function(jqXHR, textStatus, errorThrown) {
			$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val("");
		},
		success : function(data, textStatus, jqXHR) {	
			var nombre = "";
			//console.log(data.length);
			if (data.length>0){
				if ("es"==$.rup_utils.get("language")){
					nombre = data[0].nombreEs;
				}else if("eu"==$.rup_utils.get("language")){
					nombre = data[0].nombreEu;
				}
			}
			$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val(nombre);
		}
	});
}

/**
 * Evento click sobre el botón lupa de organismos Traslado/Inhibicion
 */
$("#y41aSolicitudTramitacionOrganismoTrasladoLupa").click(function () {
	var seleccion= $("#y41aSolicitudTramitacionComboDecision").rup_combo("getRupValue");
	
	if (seleccion==TRASLADO){
		y41aVarOrganismosTraslado="y41aSolicitudTramitacionTraslado";
	}
	else if (seleccion==INHIBICION){
		y41aVarOrganismosTraslado="y41aSolicitudTramitacionInhibicion";
	}
	else{
		y41aVarOrganismosTraslado="";
	}
	
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalleOrganismos").rup_dialog("destroy");
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalleOrganismos").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "850",
		height: "auto",
		title: $.rup.i18n.app.y41aTitlesModalesSolicitudes.organismosTraslado,
		url: "/y41aVistaWar/organismo/maintOrganismosTraslado?R01HNoPortal=true",    
		type:$.rup.dialog.AJAX,
		close: function(event, ui) {
			
			y41aFunctionSolicitudTramitacionPintarTabla();
		}
	});		
});

/**
 * Funcion que recoge la informacion de la modal de organismos y la pasa a la pantalla llamante
 * 
 */	
function y41aOrganismosTrasladoAPadreSolicitudTramitacion(codigo, descripcion) {
	$("#y41aSolicitudTramitacionOrganismoTrasladoId").val(codigo);
	$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val(descripcion);
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalleOrganismos").rup_dialog("close");
}

/* ****************************************************************************************************
 * Boton de grabar
 * ****************************************************************************************************
 */	
$("#y41aSolicitudTramitacionBotonGrabar").click(function () {
	if (validarCamposSolicitudTramitacion()){
		if ($("#y41aSolicitudTramitacionComboDecision").rup_combo("getRupValue")=="ARPA"){
		   $.rup_messages("msgConfirm",{
			   title:$.rup.i18n.app.msg.confirmacion,
			   message: $.rup.i18n.app.msg.confirmacionDecisionARPA,
			   OKFunction : function () {
				   y41aSolicitudTramitacionGrabar();
				}
		   });
		}else{
		   y41aSolicitudTramitacionGrabar();
		}
	}
});

/**
 * Valida los datos y actualiza los registros
 * Decisión es obligatoria. Si decisión es traslado o inhibición se debe rellenar el organismo con un código válido
 */
function y41aSolicitudTramitacionGrabar(){
	var resultado = false;
	var arrMensajes = new Array();
	var contador = 0;
	$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("hide");
	mostrarCapaCargando();
	if (($("#y41aSolicitudTramitacionComboDecision").rup_combo("getRupValue") == "" && $("#y41aSolicitudTramitacionFechaDecision").val() != "" )
		|| ($("#y41aSolicitudTramitacionComboDecision").rup_combo("getRupValue") != "" && $("#y41aSolicitudTramitacionFechaDecision").val() == "" )){
				arrMensajes[contador] = $.rup.i18n.app.msg.decisionobligatoria;
				contador = contador +1;
	}
	if (($("#y41aSolicitudTramitacionComboDecision").rup_combo("getRupValue") == TRASLADO ||
		$("#y41aSolicitudTramitacionComboDecision").rup_combo("getRupValue") == INHIBICION )
		&& ($("#y41aSolicitudTramitacionOrganismoTrasladoId").val()=="" || 
		$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").val()=="")){
		arrMensajes[contador] = $.rup.i18n.app.msg.organismo;
		contador = contador +1;
	}
	
	$("#y41aSolicitudTramitacionCodHecho").val($("#y41aSolicitudDetalleCodHecho").val());
	var decisionHechoDetalle = form2object("y41aSolicitudTramitacionDecisionForm", ".", false); //false significa que incluye los valores vacios
	var bValidarDatos=validateBean("DecisionHechoDetalle", decisionHechoDetalle, "", "y41aSolicitudTramitacionDivFeedback",arrMensajes);
	//lo ponemos a true para que recoja solo los campos que tienen datos y no nos de problemas como con la fecha
	decisionHechoDetalle = form2object("y41aSolicitudTramitacionDecisionForm", ".", true);
	

	
	if (bValidarDatos){
		//edicion
	 		var jqxhr = $.ajax({
				type : 'PUT',
				url : "/y41aVistaWar/denuncia/tramitacion/decisiongrabar?R01HNoPortal=true",
				dataType : "json",
				data : $.toJSON(decisionHechoDetalle),
				contentType : 'application/json',
				error: function (jqXHR, textStatus, errorThrown){

					switch(jqXHR.status){	
						case 406:
							ocultarCapaCargando();
							$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("option", "delay",1000);
							$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("set",jqXHR.responseText, "error");
							break;
						case 409:

							ocultarCapaCargando();
							controlY41aUDAException(jqXHR, "y41aSolicitudTramitacionDivFeedback");
							break;								
						//case 500:	
						default:
							ocultarCapaCargando();
							$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("option", "delay", 1000);
							$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
							break;
					}
				},
				success : function(data) {
							$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("option", "delay",1000);
							$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("set", "ok", "ok");
							//
							y41aSolicitudTramitacionActualizarTabla();
							y41aSolicitudTramitacionActualizarEstado();
							
							//ver si la decision es ARPA y mostrar icono
							if ($("#y41aSolicitudTramitacionComboDecision").rup_combo("getRupValue")=="ARPA"){
								$("#y41aSolicitudTramitacionDivBalanza").show();
							}else{
								$("#y41aSolicitudTramitacionDivBalanza").hide();
							}
							
							
				}
			});
	}else{
		ocultarCapaCargando();
	}
	
	
}

/* ****************************************************************************************************
 * Sobre de email
 * ****************************************************************************************************
 */	
$("#y41aSolicitudTramitacionEnviarEmail").click(function () {
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionEmail").rup_dialog("destroy");
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionEmail").rup_dialog({
		modal: true,
		autoOpen: true,
		width: 810,
		height: "auto",
		position: "top",
		title: $.rup.i18n.app.y41aTitlesModalesSolicitudes.tramitacionEmail,
		url: "/y41aVistaWar/denuncia/y41aSolicitudTramitacionEmail?R01HNoPortal=true",    
		type:$.rup.dialog.AJAX
	});		


});


/* ************************************************************************************************************
 * Ver Arbitraje
 * *************************************************************************************************************/


$("#y41aSolicitudTramitacionVerArbitraje").click(function () {
	$("#y41aTabsBusquedaResultadoSolicitudesDivSolicitudTramitacionArbitraje").rup_dialog("destroy");
	$("#y41aTabsBusquedaResultadoSolicitudesDivSolicitudTramitacionArbitraje").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "980",
		height: "auto",
		title: $.rup.i18n.app.y41aTitlesModalesSolicitudes.arbitraje,
		url: "/y41aVistaWar/denuncia/y41aSolicitudTramitacionArbitraje?R01HNoPortal=true", 
		type:$.rup.dialog.AJAX
	});		
});


/* ****************************************************************************************************
 * Borrado fechas al pulsar boton
 * ****************************************************************************************************
 */	
$("#y41aSolicitudTramitacionBorrarFechaDecision").click(function () {
	$("#y41aSolicitudTramitacionFechaDecision").val("");
});


/* ***********************************************************************************
 * Funcion que transforma los elementos de la solapa 2 en solo CONSULTA
 * ***********************************************************************************/
function y41aFunctionSolicitudTramitacionAConsulta(){
	$("#y41aSolicitudTramitacionEnviarEmail").hide();
	$("#y41aSolicitudTramitacionBotonAniadir").hide();
	$("#y41aSolicitudTramitacionBotonEliminar").hide();
	$("#y41aSolicitudTramitacionFechaDecision").rup_date("disable");
	$("#y41aSolicitudTramitacionBorrarFechaDecision").css("display","none"); //none o inline

	$("#y41aSolicitudTramitacionComboDecision-menu").remove();
	$("#y41aSolicitudTramitacionBotonGrabar").hide();
	$("#y41aSolicitudTramitacionDivBalanza").hide();
	$("#y41aSolicitudTramitacionDecisionEditar").hide();
}

/* *******************************************************************************************************
 * Funcion que trata los casos especificos de consulta para la solapa dependiendo del valor de la decision
 * *******************************************************************************************************/
function y41aSolicitudTramitacionFunctionCasosEspecificosConsulta(decodigo){

	if (y41aVarSolicitudTramitacionFechaDecisionCargada !="" && y41aSolicitudDetalleEstado=="PR"){
			$("#y41aSolicitudTramitacionFechaDecision").rup_date("enable");
			$("#y41aSolicitudTramitacionBorrarFechaDecision").css("display","inline");
			y41aSolicitudTramitacionFunctionEliminarComboDecision(decodigo);
			y41aSolicitudTramitacionFunctionPintarComboDecision();
			y41aSolicitudTramitacionFunctionCargarComboDecision(decodigo);
			$("#y41aSolicitudTramitacionBotonGrabar").show();
			$("#y41aSolicitudTramitacionDecisionEditar").show();
	}
		
	if (decodigo =="ARPA"){		//cuando es arbitraje
		$("#y41aSolicitudTramitacionDivBalanza").show();
	}
}


/* ****************************************************************************
 * Funcion que actualiza el estado de la variable tras grabar un tramite (caso que sea de traslado etc)
 * ****************************************************************************
 */
function y41aSolicitudTramitacionActualizarEstado() {
	$.ajax({
		type : "GET",
		url : "/y41aVistaWar/denuncia/getbyid/" + y41aVarSolicitudesCodigoHecho + "?R01HNoPortal=true",
		dataType : "json",
		error : function(jqXHR, textStatus, errorThrown) {
			$("#y41aSolicitudDetalleDivFeedback").rup_feedback("option", "delay", 800);
			$("#y41aSolicitudDetalleDivFeedback").rup_feedback("set",/*$.rup.i18n.app.msg.prodServNoSeleccionable */ "Carga de hecho erronea", "warning");
		},
		success : function(data, textStatus, jqXHR) {	

			 
				y41aSolicitudDetalleEstado = data.estado;

				 if ( (y41aSolicitudModoConsultaDesdeExternos == true) || ( data.estado == "A" ||data.estado == "T" ||data.estado == "C"  ) 
					 || (( data.hcfede != null && data.hcfede != "") && data.estado == "PR")){

					 y41aSolicitudModoConsulta = true;
					 
				 }else{

					 
					 y41aSolicitudModoConsulta = false;
				 }

				 $("#y41aTabsDetalleSolicitud").rup_tabs("loadTab",{
						idTab: "y41aTabsDetalleSolicitud",
						position: 1
						});
				 
		}
	});
}

function mostrarCapaCargando(){
	$('#y41aTabsBusquedaResultadoSolicitudesDivModalDetalleSolicitud').append('<div id="cargando"><div class="imagen"></div></div>');
}
function ocultarCapaCargando(){
	$("#cargando").remove();
}

//boton editar decision
$("#y41aSolicitudTramitacionDecisionEditar").click(function () {
	$("#y41aSolicitudTramitacionInputDecisionDiv").css("display","none");
	$("#y41aSolicitudTramitacionComboDecisionDiv").show();
	$("#y41aSolicitudTramitacionDecisionEditarCancelar").show();
	var decision=$("#y41aSolicitudTramitacionComboDecision").rup_combo("getRupValue");
	if (decision==TRASLADO || decision==INHIBICION){
		y41aSolicitudTramitacionOrganismoDecisionHabilitar();	 
	}
    y41aSolicitudTramitacionFunctionCargarComboDecision($("#y41aSolicitudDetalleCodDecision").val());
    
    
    
});

//boton cancelar editar decision
$("#y41aSolicitudTramitacionDecisionEditarCancelar").click(function () {
	$("#y41aSolicitudTramitacionComboDecisionDiv").css("display","none");
	$("#y41aSolicitudTramitacionInputDecisionDiv").show();
	y41aFunctionSolicitudTramitacionCargarDecision();
	var decision=$("#y41aSolicitudTramitacionComboDecision").rup_combo("getRupValue");
	if (decision==TRASLADO || decision==INHIBICION){
		y41aSolicitudTramitacionOrganismoDecisionSoloConsulta();
	}
});



function validarCamposSolicitudTramitacion(){
	var txtFeedback = "";
	var validoCampo1 = false;

	if ($("#y41aSolicitudTramitacionFechaDecision").val()!="" 
		&& !isDate($("#y41aSolicitudTramitacionFechaDecision").val())){
		txtFeedback += "<li>"+ $.rup.i18n.app.y41aSolicitudTramitacion.fechadecisionformato +"</li>\n";
		validoCampo1 = false;
	}else{
		validoCampo1 = true;
	}
	
	if (validoCampo1){
		return true;
	}else{
		$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("option", "delay",null);
		$("#y41aSolicitudTramitacionDivFeedback").rup_feedback("set","<ul>" + txtFeedback + "</ul>", "error");
		return false;
	}
}


function y41aSolicitudTramitacionOrganismoDecisionSoloConsulta(){
	$("#y41aSolicitudTramitacionOrganismoTrasladoId").attr("readonly", "readonly");
	$("#y41aSolicitudTramitacionOrganismoTrasladoId").css({'background-color':'#EBE8E9','border-color':'#EBE8E9','border-style':'solid'});
	$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").attr("readonly", "readonly");
	$("#y41aSolicitudTramitacionOrganismoTrasladoDesc").css({'background-color':'#EBE8E9','border-color':'#EBE8E9','border-style':'solid'});
	$("#y41aSolicitudTramitacionOrganismoTrasladoLupa").hide();
	$("#y41aSolicitudTramitacionOrganismoTrasladoBorrar").hide();
}


function y41aSolicitudTramitacionOrganismoDecisionHabilitar(){
	$("#y41aSolicitudTramitacionOrganismoTrasladoId").removeAttr("readonly");
	$("#y41aSolicitudTramitacionOrganismoTrasladoId").css({'background-color':'white','border-color':'black','border-style':'initial','border': '2px inset'});
	
	$("#y41aSolicitudTramitacionOrganismoTrasladoLupa").show();
	$("#y41aSolicitudTramitacionOrganismoTrasladoBorrar").show();
	
}


 

