/* ************************************************************************************************************************************************************
 * INICIALIZACION
 * ************************************************************************************************************************************************************
 */
jQuery(function($) {	

	
    //Feedback
	$("#y41aSolicitudDocumentacionFeedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	//numero hecho
	$("#y41aSolicitudDocumentacionCodOrganismo").val($("#y41aSolicitudDetalleCodOrganismo").val());
	$("#y41aSolicitudDocumentacionNumSolicitud").val($("#y41aSolicitudDetalleNumSolicitud").val());
	$("#y41aSolicitudDocumentacionAnyo").val($("#y41aSolicitudDetalleAnyo").val());
	$("#y41aSolicitudDocumentacionNumHecho").val($("#y41aSolicitudDetalleNumHecho").val());
	 
	//pintar tabla

	$("#y41aSolicitudDocumentacionCodigoHecho").val(y41aVarSolicitudesCodigoHecho);
	
	y41aFunctionSolicitudDocumentacionPintarTabla();

	y41aFunctionSolicitudDocumentacionRecargarUpload();
	y41aFunctionSolicitudDocumentacionRecargarAjaxForm();
	
	y41aFunctionSolicitudDocumentacionPintarComboTipoDocumento();
	
	
	$("#y41aSolicitudDocumentacionAportadoReclamante").attr('checked', true);
	
	 if (y41aSolicitudModoConsulta == true){
		 Y41aFunctionSolicitudDocumentacionAConsulta();
	 }
	
});
/* ****************************************************************************************************************************************************************
 * FIN INICIALIZACION
 * ****************************************************************************************************************************************************************
 */

/* *****************************
 * Combo tipo documento  *
 * *****************************
 */
function y41aFunctionSolicitudDocumentacionPintarComboTipoDocumento(){
	$("#y41aSolicitudDocumentacionComboTipoDocumento").rup_combo({
		blank : "",
		width:"300",
		source : "/y41aVistaWar/tipodocumento/findAllTipoDocumento?R01HNoPortal=true",
		sourceParam : {
			label : "tdnombre"  + recuperarLetraIdioma(),
			value : "idTipodoc"
		}
	});		
}

/* ****************************
 * Pintar tabla documentacion * 
 * ****************************
 */
function y41aFunctionSolicitudDocumentacionPintarTabla(){
	
	var y41aVarSolicitudDocumentacionWidthTabla = $("#y41aTabsDetalleSolicitud").width()-22;
	//alert($("#y41aSolicitudDocumentacionCodigoHecho").val());
	$("#y41aSolicitudDocumentacionTabla").rup_grid({
		url:"/y41aVistaWar/denuncia/documentacion/"+$("#y41aSolicitudDocumentacionCodigoHecho").val()+"?R01HNoPortal=true",
		loadOnStartUp: true,
		width: y41aVarSolicitudDocumentacionWidthTabla,
		pagerName:"y41aSolicitudDocumentacionTablaPager",
		rowNum: "10",
		sortorder: "asc",
		sortname: "q5codocumento",
		colNames:[
     		$.rup.i18n.app.y41aSolicitudDocumentacionTabla.codocumento,
			$.rup.i18n.app.y41aSolicitudDocumentacionTabla.documento,
		    $.rup.i18n.app.y41aSolicitudDocumentacionTabla.fecha,      
		    $.rup.i18n.app.y41aSolicitudDocumentacionTabla.origen,
		    $.rup.i18n.app.y41aSolicitudDocumentacionTabla.nombre,
		    $.rup.i18n.app.y41aSolicitudDocumentacionTabla.tipo,
		    $.rup.i18n.app.y41aSolicitudDocumentacionTabla.tramite,
		    $.rup.i18n.app.y41aSolicitudDocumentacionTabla.xemail
		],
		colModel: [	    
		    { 	name: "q5codocumento", 
		    	index: "q5codocumento",
		    	hidden: true
		    },	    
		    { 	name: "q5nofile" ,
		    	index: "q5nofile",
		    	width: funcPercentage(25,y41aVarSolicitudDocumentacionWidthTabla),
		    	formatter: y41aSolicitudDocumentacionFormateadorLink
		    },
		    { 	name: "q5fecha",
		    	index: "q5fecha",
		    	align: "center",
		    	width: funcPercentage(10,y41aVarSolicitudDocumentacionWidthTabla)
		    },
		    { 	name: "q5origen", 
		    	index: "q5origen",
		    	editoptions: {
					value:{	"CO":$.rup.i18n.app.y41aSolicitudDocumentacionTablaOrigen.reclamante,
							"ES":$.rup.i18n.app.y41aSolicitudDocumentacionTablaOrigen.reclamado,
							"A":$.rup.i18n.app.y41aSolicitudDocumentacionTablaOrigen.administracion
						}
				},
				width: funcPercentage(10,y41aVarSolicitudDocumentacionWidthTabla),
				formatter:"select" 
		    },
		    { 	name: "q5tedesfile", //+ recuperarLetraIdioma()
		    	index: "q5tedesfile",
		    	width: funcPercentage(25,y41aVarSolicitudDocumentacionWidthTabla)
		    },		    
		    { 	name: "tdnombre"+ recuperarLetraIdioma(), 
	    		index: "tdnombre",
	    		sortable: false,
	    		width: funcPercentage(20,y41aVarSolicitudDocumentacionWidthTabla)
	    	},		    
		    { 	name: "trnombre"+ recuperarLetraIdioma(), 
	    		index: "trnombre",
	    		sortable: false,
	    		width: funcPercentage(20,y41aVarSolicitudDocumentacionWidthTabla)
	    	},
	    	{ 	name: "q5indmail",
		    	index: "q5indmail" ,
				editoptions: {
					defaultValue:"N",
					value:{"N":"","S":'<img src="'+$.rup.APP_STATICS+'/images/sobre.JPG"  width="16" height="16">'}
					},
				width: funcPercentage(10,y41aVarSolicitudDocumentacionWidthTabla),
				formatter:"select",
				align: "center"
			}
		]
	});
}





//Funcion Onclick Grabar
$("#y41aSolicitudDocumentacionBotonGrabar").click(function () {

	if (y41aFunctionSolicitudDocumentacionValidarCampos()){
		//alert("SUBMIT");
		$("#y41aSolicitudDocumentacionForm").submit();
	}
});

function y41aFunctionSolicitudDocumentacionValidarCampos(){
	//alert(" validando campos");
	
	var txtFeedback = "";
	
	var bCampo1 = false;
	var bCampo2 = false;
	var bCampo21 = false;
	var bCampo3 = false;
	
	if ($("#y41aSolicitudDocumentacion_file_form").val()==""){
		txtFeedback += "<li>"+ $.rup.i18n.app.y41aDocumentacion.documento +"</li>\n";
		bCampo1 = false;
	}else{
		bCampo1 = true;
	}
	
	if ($("#y41aSolicitudDocumentacionAportadoReclamante").attr('checked')
			||$("#y41aSolicitudDocumentacionReclamado").attr('checked')
			||$("#y41aSolicitudDocumentacionGeneradoAdmin").attr('checked')
		){
		bCampo2 = true;
	}else{
		txtFeedback += "<li>"+ $.rup.i18n.app.y41aDocumentacion.origen +"</li>\n";
		bCampo2 = false;
	}
	
	if ($("#y41aSolicitudDocumentacionComboTipoDocumento").val()==""){
		txtFeedback += "<li>"+ $.rup.i18n.app.y41aDocumentacion.tipo +"</li>\n";
		bCampo21 = false;
	}else{
		bCampo21 = true;
	}
	
	if ($("#y41aSolicitudDocumentacionDescripcion").val()==""){
		txtFeedback += "<li>"+ $.rup.i18n.app.y41aDocumentacion.descripcion +"</li>\n";
		bCampo3=false;
	}else{
		bCampo3=true;
	}
	
	if (bCampo1 && bCampo2 && bCampo21 && bCampo3){
		return true;
	}else{
		$("#y41aSolicitudDocumentacionFeedback").rup_feedback("option", "delay",null);
		$("#y41aSolicitudDocumentacionFeedback").rup_feedback("set","<ul>" + txtFeedback + "</ul>", "error");

		return false;
	}
 }

// Upload integrado en formulario
function y41aFunctionSolicitudDocumentacionRecargarUpload(){
	$('#y41aSolicitudDocumentacion_fileupload_form').rup_upload({
		fileInput: $("#y41aSolicitudDocumentacion_file_form"),
		submitFormButton: $("#y41aSolicitudDocumentacionBotonGrabar"),
		maxFileSize: 5000000,
		singleFileUploads:true,
		submitInForm:true
	});	
}



/* ***************
 * Boton Limpiar * 
 * ***************
 */
$("#y41aSolicitudDocumentacionBotonLimpiar").click(function(){
	y41aFunctionSolicitudDocumentacionLimpiarForm();
	y41aFunctionSolicitudDocumentacionReloadTabla();
});

// Funcion que limpia/inicializa los valores del formulario *
function y41aFunctionSolicitudDocumentacionLimpiarForm(){
	
	$("#y41aSolicitudDocumentacion_kk").html('<table class="files"></table>');
	$("#y41aSolicitudDocumentacion_file_form").val("");
	y41aFunctionSolicitudDocumentacionRecargarUpload();
	
	$("#y41aSolicitudDocumentacionAportadoReclamante").attr('checked', false);
	$("#y41aSolicitudDocumentacionReclamado").attr('checked', false);
	$("#y41aSolicitudDocumentacionGeneradoAdmin").attr('checked', false);
	$("#y41aSolicitudDocumentacionComboTipoDocumento").rup_combo("setRupValue","");
	$("#y41aSolicitudDocumentacionDescripcion").val("");
}
//reload tabla
function y41aFunctionSolicitudDocumentacionReloadTabla()
{
	$("#y41aSolicitudDocumentacionTabla").rup_grid("clearGridData");
	$("#y41aSolicitudDocumentacionTabla").rup_grid("setGridParam", {url : "/y41aVistaWar/denuncia/documentacion/"+$("#y41aSolicitudDocumentacionCodigoHecho").val()+"?R01HNoPortal=true"});
	$("#y41aSolicitudDocumentacionTabla").rup_grid("reloadGrid");
}

//recargar ajaxform
function y41aFunctionSolicitudDocumentacionRecargarAjaxForm(){
	// Se utiliza jquery.form para realizar el submit de los formularios por AJAX
//	$("#y41aSolicitudDocumentacionForm").ajaxForm(function(){
//		//alert("Ajax");
//		y41aFunctionSolicitudDocumentacionLimpiarForm();
//		y41aFunctionSolicitudDocumentacionReloadTabla();
//		$("#y41aSolicitudDocumentacionFeedback").rup_feedback("option", "delay", 800);
//		$("#y41aSolicitudDocumentacionFeedback").rup_feedback("set",$.rup.i18n.app.comun.datosEnviados,"warning");
//	}); 

	// Se utiliza jquery.form para realizar el submit de los formularios por AJAX
	var options = {
			success:       y41aFunctionShowSuccess_doc,  // post-submit callback
			error:    	   y41aFunctionShowError
    };
	
	$("#y41aSolicitudDocumentacionForm").ajaxForm(options);
}
function y41aFunctionShowSuccess_doc(responseText) {
	var navegador = navigator.userAgent;
	if (navigator.userAgent.indexOf('MSIE') != -1) {
		
		// Hay algun error?
		if (responseText.indexOf("[") == 0) {
			var errors = $.parseJSON(responseText);
			for (name in errors) {
				error = errors[name];
				$("#y41aSolicitudDocumentacionFeedback").rup_feedback("option", "delay", null);
				$("#y41aSolicitudDocumentacionFeedback").rup_feedback("set", char_convert(error), "error");
			}
		} else {
			y41aFunctionSolicitudDocumentacionLimpiarForm();
			y41aFunctionSolicitudDocumentacionReloadTabla();
			
			$("#y41aSolicitudDocumentacionFeedback").rup_feedback("option", "delay", null);
			$("#y41aSolicitudDocumentacionFeedback").rup_feedback("set", $.rup.i18n.app.comun.datosEnviados, "ok");
		}
	} else {
		y41aFunctionSolicitudDocumentacionLimpiarForm();
		y41aFunctionSolicitudDocumentacionReloadTabla();
		
	}
}

function y41aFunctionShowError(response, status, err) {
	switch (response.status) {		
		case 406:
			$("#y41aSolicitudDocumentacionFeedback").rup_feedback("option", "delay", null);
			$("#y41aSolicitudDocumentacionFeedback").rup_feedback("set", jqXHR.responseText, "error");
			break;
		case 409:
			controlY41aUDAException(response, "y41aSolicitudDocumentacionFeedback");
			break;
		case 422:
            controlY41aUDAException(response, "y41aSolicitudDocumentacionFeedback");
            break;
		default:
			$("#y41aSolicitudDocumentacionFeedback").rup_feedback("option", "delay", null);
			$("#y41aSolicitudDocumentacionFeedback").rup_feedback("set", $.rup.i18n.app.msg.errorModifDatos, "error");
			break;
	}
}

function y41aSolicitudDocumentacionFormateadorLink(cellvalue, options, rowObject) {
	//alert(rowObject.q5codocumento);
    return "<a href='/y41aVistaWar/denuncia/documentacion/link/"+ rowObject.q5codocumento +"?R01HNoPortal=true'>" + cellvalue + "</a>";
}


/* **********
 * ELIMINAR *
 ************
 */

// Eliminar - onclick del boton

$("#y41aSolicitudDocumentacionBotonEliminar").click(function () {
	var selectedRow = $("#y41aSolicitudDocumentacionTabla").rup_grid("getSelectedRows")[0];
	row = $("#y41aSolicitudDocumentacionTabla").rup_grid("getRowData", selectedRow);
	var codigo = row.q5codocumento;
	if(codigo == "" || codigo == null)
		{
			$("#y41aSolicitudDocumentacionFeedback").rup_feedback("option", "delay", 800);
			$("#y41aSolicitudDocumentacionFeedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
	else
		{
		   $.rup_messages("msgConfirm",{
			   title:$.rup.i18n.app.msg.confirmacion,
			   message: $.rup.i18n.app.msg.confiramacioneliminar,
			   OKFunction : function () {
				   y41aSolicitudDocumentacionEliminarFilaTablaDocs(codigo);
				}
		   });
		}
});


//Eliminar - llamada
function y41aSolicitudDocumentacionEliminarFilaTablaDocs(codigo){
	var jqxhr = $.ajax({
		type : 'DELETE',
		url : "/y41aVistaWar/denuncia/documentacion/" + codigo+"?R01HNoPortal=true",
		error: function (jqXHR, textStatus, errorThrown){
			switch(jqXHR.status){		
				case 406:
					$("#y41aSolicitudDocumentacionFeedback").rup_feedback("option", "delay",null);
					$("#y41aSolicitudDocumentacionFeedback").rup_feedback("set",jqXHR.responseText, "error");
					break;
				//case 500:	
				default:
					$("#y41aSolicitudDocumentacionFeedback").rup_feedback("option", "delay",null);
					$("#y41aSolicitudDocumentacionFeedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
					break;
			}
		},
		success : function(data) {
					$("#y41aSolicitudDocumentacionFeedback").rup_feedback("option", "delay",800);
					$("#y41aSolicitudDocumentacionFeedback").rup_feedback("set", "ok", "ok");
					
					y41aFunctionSolicitudDocumentacionReloadTabla();
		}
	});
}

/* ***********************************************************************************
 * Funcion que transforma los elementos de la solapa 3 documentos en solo CONSULTA
 * ***********************************************************************************/
function Y41aFunctionSolicitudDocumentacionAConsulta(){
	$("#y41aSolicitudDocumentacionBotonEliminar").hide();

	$("#y41aSolicitudDocumentacion_fileupload_form").hide();
	
	
	//	//$('#fileupload-buttonbar').css("display","none");
//	
//	$("#y41aSolicitudDocumentacion_file_form").remove();
//	
//	$("#y41aSolicitudDocumentacionAportadoReclamante").attr("disabled", "disabled");
//	$("#y41aSolicitudDocumentacionReclamado").attr("disabled", "disabled");
//	$("#y41aSolicitudDocumentacionGeneradoAdmin").attr("disabled", "disabled");
//	
//	$("#y41aSolicitudDocumentacionDescripcion").attr("readonly", "readonly");
//	
//	$("#y41aSolicitudDocumentacionBotonLimpiar").hide();
//	$("#y41aSolicitudDocumentacionBotonGrabar").hide();
	
}



