/* *********************************************************************************************************************************************************
 * INICIALIZACIONES
 * *********************************************************************************************************************************************************
 */
jQuery(function($) {	

	
	//Feedback
	$("#y41aSolicitudTramitacionDetalleDivFeedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});

	//hecho
	$("#y41aSolicitudTramitacionDetalleCodOrganismo").val($("#y41aSolicitudDetalleCodOrganismo").val());
	$("#y41aSolicitudTramitacionDetalleNumSolicitud").val($("#y41aSolicitudDetalleNumSolicitud").val());
	$("#y41aSolicitudTramitacionDetalleAnyo").val($("#y41aSolicitudDetalleAnyo").val());
	$("#y41aSolicitudTramitacionDetalleNumHecho").val($("#y41aSolicitudDetalleNumHecho").val());
	
	// Fecha tramite
	$("#y41aSolicitudTramitacionDetalleFechaTramite").rup_date ({duration:"fast"});
	
	// Hora tramite	
	$("#y41aSolicitudTramitacionDetalleHoraTramite").rup_time ({
		timeFormat: 'hh:mm:ss',
		showSecond: false
	});
	
	
	
	// Fecha acuse 
	$("#y41aSolicitudTramitacionDetalleFechaAcuseRecibo").rup_date ({duration:"fast"});
	
	
	
	//Carga
	//alert("seleccionado"+ seleccionado);
	if (seleccionado!=null && seleccionado!="" ){
		//Tramite
		$("#y41aSolicitudTramitacionDetalleComboTramites").rup_combo({
			blank : "",
			source : "/y41aVistaWar/tramite/alltramites?R01HNoPortal=true",
			sourceParam : {
				label : "trnombre"+ recuperarLetraIdioma(),
				value : "trcodigo"
			},
			width:"440"
		});	
		
		//Monitor
		$("#y41aSolicitudTramitacionDetalleComboMonitor").rup_combo({
			blank : "",
			source : "/y41aVistaWar/censomonitor?R01HNoPortal=true",
			sourceParam : {
				label : "monombre" + recuperarLetraIdioma(),
				value : "mocodigo"
			}
		});
		
		//entro en modo EDICION
		y41aFunctionSolicitudTramitacionDetalleObtenerTramite(seleccionado);
		
		//alert("EDICION "+y41aSolicitudModoConsulta);
		
		
		 if (y41aSolicitudModoConsulta){
			 Y41aFunctionSolicitudTramitacionDetalleAConsulta();
		 }else{
			 Y41aFunctionSolicitudTramitacionDetalleAConsultaParcial();
		 }
		 
		 
	}else{
		//alert("ALTA");
		//Tramite
		$("#y41aSolicitudTramitacionDetalleComboTramites").rup_combo({
			blank : "",
			source : "/y41aVistaWar/tramite/allTramitesAlta?R01HNoPortal=true",
			sourceParam : {
				label : "trnombre"+ recuperarLetraIdioma(),
				value : "trcodigo"
			},
			width:"440"
		});	
		
		//Monitor
		$("#y41aSolicitudTramitacionDetalleComboMonitor").rup_combo({
			blank : "",
			source : "/y41aVistaWar/censomonitor/filterAltas?R01HNoPortal=true&organismoCodOrg="+ $("#y41aSolicitudTramitacionDetalleConnectedCodOrg").val(),
			sourceParam : {
				label : "monombre" + recuperarLetraIdioma(),
				value : "mocodigo"
			},
			selected: $("#y41aSolicitudTramitacionDetalleConnectedMonitor").val()
		});
		
		//entro en modo ALTA
		y41aFunctionSolicitudTramitacionDetalleInicializarElementos();
	}
	
	
	$(document).ready(function(){
		//asignamos el valor id del campo que queremos que se mayÃºscula
		aMayusculas("input#y41aSolicitudTramitacionDetalleOrganismoDestinoId"); 
		
	});
	

});	
/* *********************************************************************************************************************************************************
 * FIN INICIALIZACIONES
 * *********************************************************************************************************************************************************
 */

/*
 * Recupera la informacion del tramite asociado al id 
 */
function y41aFunctionSolicitudTramitacionDetalleObtenerTramite(seleccionado) {
	
	$.ajax({
		type : "GET",
		url : "/y41aVistaWar/denuncia/tramitacion/detalle/" + seleccionado + "?R01HNoPortal=true",
		dataType : "json",
		error : function(jqXHR, textStatus, errorThrown) {
			$("#y41aSolicitudTramitacionDetalleDivFeedback").rup_feedback("option", "delay", 800);
			$("#y41aSolicitudTramitacionDetalleDivFeedback").rup_feedback("set",$.rup.i18n.app.msg.errorRecuperarDatos, "error");
		},
		success : function(data, textStatus, jqXHR) {	
			
			//inicializa la pantalla con los valores recuperados
			//alert(data.ehcodigo);
			$("#y41aSolicitudTramitacionDetalleCodTramite").val(data.ehcodigo);
			//alert(data.ehfecha);
			$("#y41aSolicitudTramitacionDetalleFechaTramite").rup_date("disable");
			$("#y41aSolicitudTramitacionDetalleFechaTramite").rup_date("setDate",data.ehfecha);
			
			$("#y41aSolicitudTramitacionDetalleHoraTramite").rup_time("disable");
			$("#y41aSolicitudTramitacionDetalleHoraTramite").val(data.ehhora);
			
			//alert(data.ehhora);
			if (data.trcodigo!=null && data.trcodigo!=""){
				$("#y41aSolicitudTramitacionDetalleComboTramites").rup_combo("setRupValue",data.trcodigo);	
			}else{
				$("#y41aSolicitudTramitacionDetalleComboTramites").rup_combo("select","");
			}
			if ( data.trcodigo==16 ) {			//traslado = codigo 16
				$("#y41aSolicitudTramitacionDetalleULOrganismo").show();
				$("#y41aSolicitudTramitacionDetalleOrganismoDestinoId").val(data.codOrgTraslado);
				var nombre = "";
				if ("es"==$.rup_utils.get("language")){
					nombre = data.nombreOrgTrasladoEs;
				}else if("eu"==$.rup_utils.get("language")){
					nombre = data.nombreOrgTrasladoEu;
				}
			}
			$("#y41aSolicitudTramitacionDetalleOrganismoDestinoDesc").val(nombre);

			if (data.ehtexto !=null){
				$("#y41aSolicitudTramitacionDetalleResumen").val(stripHTML(data.ehtexto));
			}else{
				$("#y41aSolicitudTramitacionDetalleResumen").val("");
			}
			
			if (data.mocodigo!=null && data.mocodigo!=""){
				$("#y41aSolicitudTramitacionDetalleComboMonitor").rup_combo("setRupValue",data.mocodigo);	
			}else{
				$("#y41aSolicitudTramitacionDetalleComboMonitor").rup_combo("select","");
			}
			$("#y41aSolicitudTramitacionDetalleFechaAcuseRecibo").val(data.ehacuse);
		}
	});
}

//inicializa la pantalla con los valores de inicio
function y41aFunctionSolicitudTramitacionDetalleInicializarElementos(){
	
	$("#y41aSolicitudTramitacionDetalleULOrganismo").hide();
	$("#y41aSolicitudTramitacionDetalleCodHecho").val($("#y41aSolicitudDetalleCodHecho").val());
	$("#y41aSolicitudTramitacionDetalleCodTramite").val("");

	$("#y41aSolicitudTramitacionDetalleFechaTramite").rup_date("setDate", fechaActual());
	$("#y41aSolicitudTramitacionDetalleFechaTramite").rup_date("close");
	
	$("#y41aSolicitudTramitacionDetalleHoraTramite").rup_time("setTime", fechaActual());
	$("#y41aSolicitudTramitacionDetalleComboTramites").rup_combo("select", "");
	$("#y41aSolicitudTramitacionDetalleOrganismoDestinoId").val("");
	$("#y41aSolicitudTramitacionDetalleOrganismoDestinoDesc").val("");
	$("#y41aSolicitudTramitacionDetalleResumen").val("");
	$("#y41aSolicitudTramitacionDetalleComboMonitor").rup_combo("select", "");
	$("#y41aSolicitudTramitacionDetalleFechaAcuseRecibo").val("");
}

//boton cancelar
$("#y41aSolicitudTramitacionDetalleBotonCancelar").click(function () {
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalle").rup_dialog("close");
});	


/* **************************************************************************************************
 * Boton Buscar organismos - abre modal
 * *************************************************************************************************
 */
$("#y41aSolicitudTramitacionDetalleOrganismoDestinoLupa").click(function () {
	y41aVarOrganismosTraslado ="y41aSolicitudTramitacionDetalle";
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalleOrganismos").rup_dialog("destroy");
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalleOrganismos").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "850",
		height: "auto",
		title: $.rup.i18n.app.y41aTitlesModalesSolicitudes.organismosTraslado,
		url: "/y41aVistaWar/organismo/maintOrganismosTraslado?R01HNoPortal=true",    
		type:$.rup.dialog.AJAX
	});		
});


/* ****************************************************************************************************
 * Funcion que recoge la informacion de la modal de organismos y la pasa a la pantalla llamante
 * ****************************************************************************************************
 */	
function y41aOrganismosTrasladoAPadreSolicitudTramitacionDetalle(codigo, descripcion) {
	$("#y41aSolicitudTramitacionDetalleOrganismoDestinoId").val(codigo);
	$("#y41aSolicitudTramitacionDetalleOrganismoDestinoDesc").val(descripcion);
	$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalleOrganismos").rup_dialog("close");
}


/* ****************************************************************************************************
 * Boton de grabar
 * ****************************************************************************************************
 */	
var botonGrabarPulsado = false;
$("#y41aSolicitudTramitacionDetalleBotonGrabar").click(function () {

//	alert("fecha registro: "+ $("#y41aSolicitudDetalleFechaRegistro").val());
//	alert("fecha tramite: "+ $("#y41aSolicitudTramitacionDetalleFechaTramite").val());
	

	if (!botonGrabarPulsado){
		botonGrabarPulsado = true;
		//Añadimos la imagen de carga en el contenedor
        $('#y41aSolicitudTramitacionDetalleDivContent').html('<div><img src="'+$.rup.APP_STATICS+'/images/loading.gif"/></div>');
        
		$("#y41aSolicitudTramitacionDetalleHiddenHoraTramite").val($("#y41aSolicitudTramitacionDetalleHoraTramite").rup_time("getTime"));
	
		var resultado = false;
		var arrMensajes = new Array();
		var contador = 0;
	
		////
		if ($("#y41aSolicitudTramitacionDetalleFechaTramite").val()!="" 
			&& !isDate($("#y41aSolicitudTramitacionDetalleFechaTramite").val())){
			arrMensajes[contador] = $.rup.i18n.app.y41aSolicitudTramitacionDetalle.fechatramite;
			contador = contador +1;
		}
		if ($("#y41aSolicitudTramitacionDetalleHoraTramite").val()!="" 
			&& !isTimeWithSeconds($("#y41aSolicitudTramitacionDetalleHoraTramite").val())){
			arrMensajes[contador] = $.rup.i18n.app.y41aSolicitudTramitacionDetalle.horatramitewithsecs;
			contador = contador +1;
		}
		
		if ($("#y41aSolicitudTramitacionDetalleFechaAcuseRecibo").val()!="" 
			&& !isDate($("#y41aSolicitudTramitacionDetalleFechaAcuseRecibo").val())){
			arrMensajes[contador] = $.rup.i18n.app.y41aSolicitudTramitacionDetalle.fechaacuserecibo;
			contador = contador +1;
		}
		////
		
		//si se rellena la fecha de tramite condicion de fecha tramite >= fecha registro*/ 
		if ( $("#y41aSolicitudTramitacionDetalleFechaTramite").val() !=""){
			resultado = comparaFechas( $("#y41aSolicitudDetalleFechaPresentacion").val(), $("#y41aSolicitudTramitacionDetalleFechaTramite").val());
			if(!resultado){
				arrMensajes[contador] = $.rup.i18n.app.msg.fechaTramite+" "+ $("#y41aSolicitudDetalleFechaPresentacion").val() ;
				contador = contador +1;
			}
		}
		
		if ( $("#y41aSolicitudTramitacionDetalleComboTramites").rup_combo("getRupValue")==16 && $("#y41aSolicitudTramitacionDetalleOrganismoDestinoId").val()=="") {
			arrMensajes[contador] = $.rup.i18n.app.msg.organismo ;
			contador = contador +1;
		}
	
		
		//si se rellena el codigo de organismo comprobar que se ha rellenado la descripcion  
		if ( $("#y41aSolicitudTramitacionDetalleOrganismoDestinoId").val() !=""){
			if($("#y41aSolicitudTramitacionDetalleOrganismoDestinoDesc").val() ==""){
				arrMensajes[contador] = $.rup.i18n.app.msg.organismodesc ;
				contador = contador +1;
			}
		}
	
		var tramiteHechoDetalle = form2object("y41aSolicitudTramitacionDetalleForm", ".", false); //false significa que incluye los valores vacios
		var bValidarDatos=validateBean("TramiteHechoDetalle", tramiteHechoDetalle, "", "y41aSolicitudTramitacionDetalleDivFeedback",arrMensajes);
		//lo ponemos a true para que recoja solo los campos que tienen datos y no nos de problemas como con la fecha
		tramiteHechoDetalle = form2object("y41aSolicitudTramitacionDetalleForm", ".", true);
	
		
		//alert("/y41aVistaWar/denuncia/tramitacion/detalle/grabar?R01HNoPortal=true&"+ $.toJSON(tramiteHechoDetalle));
		if (bValidarDatos){
				
			
			var tipo = "";
			if (seleccionado==""){
				tipo = 'POST'; //add	
			}else{
				tipo = 'PUT'; //edit	
			}
			
			//alta o edicion
		 		var jqxhr = $.ajax({
					type : tipo,
					url : "/y41aVistaWar/denuncia/tramitacion/detallegrabar?R01HNoPortal=true",
					dataType : "json",
					data : $.toJSON(tramiteHechoDetalle),
					contentType : 'application/json',
					error: function (jqXHR, textStatus, errorThrown){
						//alert(jqXHR.status);
						switch(jqXHR.status){	
							case 406:
								$("#y41aSolicitudTramitacionDetalleDivFeedback").rup_feedback("option", "delay",1000);
								$("#y41aSolicitudTramitacionDetalleDivFeedback").rup_feedback("set",jqXHR.responseText, "error");
								botonGrabarPulsado = false;
								$('#y41aSolicitudTramitacionDetalleDivContent').html('');
								
								break;
							case 409:
								controlY41aUDAException(jqXHR, "y41aSolicitudTramitacionDetalleDivFeedback");
								botonGrabarPulsado = false;
								$('#y41aSolicitudTramitacionDetalleDivContent').html('');
								
								break;								
							//case 500:	
							default:
								$("#y41aSolicitudTramitacionDetalleDivFeedback").rup_feedback("option", "delay", 1000);
								$("#y41aSolicitudTramitacionDetalleDivFeedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
								botonGrabarPulsado = false;
								$('#y41aSolicitudTramitacionDetalleDivContent').html('');
								
								break;
						}
					},
					success : function(data) {
								$("#y41aSolicitudTramitacionDetalleDivFeedback").rup_feedback("option", "delay",1000);
								$("#y41aSolicitudTramitacionDetalleDivFeedback").rup_feedback("set", "ok", "ok");
								//alert("DATA QUE DEVUELVE AL GRABAR TRAMITE: "+$.toJSON(data));
								botonGrabarPulsado = false;
								$('#y41aSolicitudTramitacionDetalleDivContent').html('');
								
								$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalle").rup_dialog("close");
								y41aSolicitudTramitacionActualizarTabla();	
								y41aSolicitudTramitacionFunctionEliminarComboDecision();
								y41aSolicitudTramitacionFunctionPintarComboDecision();
								y41aFunctionSolicitudTramitacionCargarDecision();
								y41aSolicitudTramitacionActualizarEstado();
					}
				});
		 }else{
			 botonGrabarPulsado = false;
			 $('#y41aSolicitudTramitacionDetalleDivContent').html('');
		 }
	}
});



//mostrar o no el organismo cuando se modifica el combo tramite
$("#y41aSolicitudTramitacionDetalleComboTramites").change(function() {
	
	var seleccion = $("#y41aSolicitudTramitacionDetalleComboTramites").rup_combo("getRupValue");
	if ( seleccion =="16" ) {
		 $("#y41aSolicitudTramitacionDetalleULOrganismo").show();	
	}else{
		 $("#y41aSolicitudTramitacionDetalleULOrganismo").hide();
	}
});


/* ****************************************************************************************************
 * Borrado fechas al pulsar boton
 * ****************************************************************************************************
 */	
$("#y41aSolicitudTramitacionDetalleFechaTramiteBorrar").click(function () {
	$("#y41aSolicitudTramitacionDetalleFechaTramite").val("");
});
$("#y41aSolicitudTramitacionDetalleHoraTramiteBorrar").click(function () {
	$("#y41aSolicitudTramitacionDetalleHoraTramite").val("");
});

$("#y41aSolicitudTramitacionDetalleFechaAcuseReciboBorrar").click(function () {
	$("#y41aSolicitudTramitacionDetalleFechaAcuseRecibo").val("");
});




/* ***********************************************************************************
 * Funcion que transforma los elementos del detalle de tramite
 * ***********************************************************************************/
function Y41aFunctionSolicitudTramitacionDetalleAConsulta(){
	//alert("Y41aFunctionSolicitudTramitacionDetalleAConsulta");
	$("#y41aSolicitudTramitacionDetalleFechaTramiteBorrar").hide();
	$("#y41aSolicitudTramitacionDetalleHoraTramiteBorrar").hide();
	$("#y41aSolicitudTramitacionDetalleComboTramites-menu").remove();
	$("#y41aSolicitudTramitacionDetalleOrganismoDestinoId").attr("disabled", "disabled");
	$("#y41aSolicitudTramitacionDetalleOrganismoDestinoDesc").attr("disabled", "disabled");
	$("#y41aSolicitudTramitacionDetalleOrganismoDestinoLupa").hide();
	$("#y41aSolicitudTramitacionDetalleResumen").attr("disabled", "disabled");
	$("#y41aSolicitudTramitacionDetalleComboMonitor-menu").remove();
	$("#y41aSolicitudTramitacionDetalleFechaAcuseRecibo").rup_date("disable");
	$("#y41aSolicitudTramitacionDetalleFechaAcuseReciboBorrar").hide();
	$("#y41aSolicitudTramitacionDetalleBotonGrabar").hide();
	$("#y41aSolicitudTramitacionDetalleBotonCancelar").hide();
}

function Y41aFunctionSolicitudTramitacionDetalleAConsultaParcial(){
	//alert("Y41aFunctionSolicitudTramitacionDetalleAConsultaParcial");
	$("#y41aSolicitudTramitacionDetalleFechaTramiteBorrar").hide();
	$("#y41aSolicitudTramitacionDetalleHoraTramiteBorrar").hide();
	$("#y41aSolicitudTramitacionDetalleComboTramites-menu").remove();
	$("#y41aSolicitudTramitacionDetalleOrganismoDestinoId").attr("disabled", "disabled");
	$("#y41aSolicitudTramitacionDetalleOrganismoDestinoDesc").attr("disabled", "disabled");
	$("#y41aSolicitudTramitacionDetalleOrganismoDestinoLupa").hide();
	//$("#y41aSolicitudTramitacionDetalleResumen").attr("disabled", "disabled");
	$("#y41aSolicitudTramitacionDetalleComboMonitor-menu").remove();
	//$("#y41aSolicitudTramitacionDetalleFechaAcuseRecibo").rup_date("disable");
	//$("#y41aSolicitudTramitacionDetalleFechaAcuseReciboBorrar").hide();
	//	$("#y41aSolicitudTramitacionDetalleBotonGrabar").hide();
	//	$("#y41aSolicitudTramitacionDetalleBotonCancelar").hide();
}



/* *************************************
 * Buscar Organismo metiendo el codigo *
 * *************************************
 */
$("#y41aSolicitudTramitacionDetalleOrganismoDestinoId").blur(
	function () {
		var organismoId = $("#y41aSolicitudTramitacionDetalleOrganismoDestinoId").val();
		if (organismoId != ""){
			y41aFunctionSolicitudTramitacionDetalleBuscarOrganismo(organismoId);
		}else{
			$("#y41aSolicitudTramitacionDetalleOrganismoDestinoDesc").val("");
		}
		
	}
);
/*
 * Recupera la informacion del Organismo asociada al id 
 * @param organismoId Identificador del organismo del que se quiere obtener su descripcion
 * 
 */
function y41aFunctionSolicitudTramitacionDetalleBuscarOrganismo(organismoId) {
	$.ajax({
		type : "GET",
		url : "/y41aVistaWar/organismo/liketrasladoOrgSolicitudes?codOrg=" + organismoId + "&R01HNoPortal=true",
		dataType : "json",
		error : function(jqXHR, textStatus, errorThrown) {
			$("#y41aSolicitudTramitacionDetalleOrganismoDestinoDesc").val("");
		},
		success : function(data, textStatus, jqXHR) {	
			var nombre = "";
			if (data.length>0){
				if ("es"==$.rup_utils.get("language")){
					nombre = data[0].nombreEs;
				}else if("eu"==$.rup_utils.get("language")){
					nombre = data[0].nombreEu;
				}
			}
			$("#y41aSolicitudTramitacionDetalleOrganismoDestinoDesc").val(nombre);
		}
	});
}



