jQuery(function($) {

	
	
	/* **********************
	 * Combo provincia NORA *
	 * **********************
	 */
	$("#y41aOrganismosTrasladoComboProvincia").rup_combo({
		blank : "",
		source : "/y41aVistaWar/nora/provincias?R01HNoPortal=true",
		sourceParam : {	label : "dsO", value : "id"	}
	});	
	/* **********************
	 * Combo municipio NORA *
	 * **********************
	 */
	$("#y41aOrganismosTrasladoComboMunicipio").rup_combo({
		blank : "",
		parent: [ "y41aOrganismosTrasladoComboProvincia" ],
		source : "/y41aVistaWar/nora/municipios?R01HNoPortal=true",
		sourceParam : {	label : "dsO",	value : "id"}
	});	
	/* **********************
	 * Combo localidad NORA *
	 * **********************
	 */
	$("#y41aOrganismosTrasladoComboLocalidad").rup_combo({
		blank : "",
		parent: [ "y41aOrganismosTrasladoComboProvincia", "y41aOrganismosTrasladoComboMunicipio" ],
		source : "/y41aVistaWar/nora/localidades?R01HNoPortal=true",
		sourceParam : {	label : "dsO", value : "id"	}
	});	
	
	$("#y41aOrganismosTrasladoOrganismoNoActivos").attr('checked', false);	
	
	var y41aVarOrganismosTrasladoTablaWidth = 840;
	var urlTabla = "";

	if (y41aVarOrganismosTraslado=="y41aTrasladosEnvios" 
		|| y41aVarOrganismosTraslado=="y41aTrasladosRecepciones"
		|| y41aVarOrganismosTraslado=="y41aSolicitudTramitacionDetalle"){
		urlTabla = "/y41aVistaWar/organismo/liketrasladoOrgSolicitudes?R01HNoPortal=true";
	}else if (y41aVarOrganismosTraslado=="y41aSolicitudTramitacionTraslado"){
		urlTabla = "/y41aVistaWar/organismo/liketrasladoOrgTraslado?R01HNoPortal=true";
	}else if (y41aVarOrganismosTraslado=="y41aSolicitudTramitacionInhibicion" ){
		urlTabla = "/y41aVistaWar/organismo/liketrasladoOrgInhibicion?R01HNoPortal=true";
	}
	else{
		urlTabla="/y41aVistaWar/organismo/liketraslado?R01HNoPortal=true";
	}
	
	$("#y41aOrganismosTrasladoTabla").rup_grid({
		url:urlTabla,
		loadOnStartUp: false,
		width: y41aVarOrganismosTrasladoTablaWidth,
		pagerName:"y41aOrganismosTrasladoTablaPager",
		rowNum: "10",
		sortorder: "asc",
		sortname: "codOrg",
		colNames:[
		    $.rup.i18n.app.y41aOrganismosTrasladoTabla.codigo,
		    $.rup.i18n.app.y41aOrganismosTrasladoTabla.organismo,
		    $.rup.i18n.app.y41aOrganismosTrasladoTabla.localidad,
		    $.rup.i18n.app.y41aOrganismosTrasladoTabla.activa
		],
		colModel: [		    
		    { 	name: "codOrg", 
		    	index: "codOrg",
		    	width: funcPercentage(20,y41aVarOrganismosTrasladoTablaWidth)
		    },
		    { 	name: "nombre" + recuperarLetraIdiomaOrganismos(),
		    	index: "nombre" + recuperarLetraIdiomaOrganismos() ,
		    	width: funcPercentage(50,y41aVarOrganismosTrasladoTablaWidth)
		    },
		    { 	name: "nombreLocalidad",
		    	index: "nombreLocalidad",
		    	width: funcPercentage(20,y41aVarOrganismosTrasladoTablaWidth)
		    },
		    { 	name: "activa",
		    	index: "activa",
		    	align: "center",
		    	editoptions: {
					value:{"N":'<img src="'+$.rup.APP_STATICS+'/images/y41a-false.png"  width="12" height="12">',
					"S":'<img src="'+$.rup.APP_STATICS+'/images/y41a-true.png"  width="12" height="12">'}
					},
					formatter:"select",
					width: funcPercentage(10,y41aVarOrganismosTrasladoTablaWidth)
		    }
		    
		],
		onSelectRow : function(id, selectR) {
			var datosFila = $("#y41aOrganismosTrasladoTabla").rup_grid("getRowData", id);
			var codigo = datosFila.codOrg;
			var descripcion = datosFila.nombreEs;
			if ("eu"==$.rup_utils.get("language")){
				descripcion=datosFila.nombreEu;
			}
			
			if(y41aVarOrganismosTraslado == "y41aCensoMonitor"){
				y41aOrganismosTrasladoAPadreCensoMonitor(codigo,descripcion);	
			}else if (y41aVarOrganismosTraslado == "y41aSolicitudTramitacionTraslado" || 
					y41aVarOrganismosTraslado == "y41aSolicitudTramitacionInhibicion"){
				y41aOrganismosTrasladoAPadreSolicitudTramitacion(codigo,descripcion);	
			} else if (y41aVarOrganismosTraslado=="y41aSolicitudTramitacionDetalle" ){
				y41aOrganismosTrasladoAPadreSolicitudTramitacionDetalle(codigo,descripcion);	
			}
			else {
				y41aOrganismosTrasladoAPadre(codigo,descripcion);
			}
		}
	});
	
	$(document).ready(function(){
		//asignamos el valor id del campo que queremos que se mayÃºscula
		aMayusculas("input#y41aOrganismosTrasladoOrganismoCodigo"); 
	});
	
	y41aOrganismosTrasladoFiltrar(urlTabla);
	
});


/* ****************************************************************************************************
 * Boton Limpiar Filtro Modal Organismos traslado
 * ***************************************************************************************************
 */ 
$("#y41aOrganismosTrasladoBotonLimpiar").click(function () {
	y41aOrganismosTrasladoLimpiar();
});


/*
 * Limpiamos todos los datos del formulario.
 */
function y41aOrganismosTrasladoLimpiar() {
	$("#y41aOrganismosTrasladoOrganismoNoActivos").attr('checked', false);
	$("#y41aOrganismosTrasladoOrganismoCodigo").val("");
	$("#y41aOrganismosTrasladoOrganismoNombre").val("");
	$("#y41aOrganismosTrasladoComboProvincia").rup_combo("select", "");
	$("#y41aOrganismosTrasladoComboMunicipio").rup_combo("select", "");
	$("#y41aOrganismosTrasladoComboLocalidad").rup_combo("select", "");
	$("#y41aOrganismosTrasladoTabla").rup_grid("clearGridData");
}

/* ***************************************************************************************************
 * Boton Filtrar Modal Organismos traslado
 * ***************************************************************************************************
 */ 
$("#y41aOrganismosTrasladoBotonFiltrar").click(function () {
	var urlTabla = "";
	if (y41aVarOrganismosTraslado=="y41aTrasladosEnvios" 
		|| y41aVarOrganismosTraslado=="y41aTrasladosRecepciones"
		|| y41aVarOrganismosTraslado=="y41aSolicitudTramitacionDetalle"){
		urlTabla = "/y41aVistaWar/organismo/liketrasladoOrgSolicitudes?R01HNoPortal=true";
	}
	else{
		urlTabla="/y41aVistaWar/organismo/liketraslado?R01HNoPortal=true";
	}
	y41aOrganismosTrasladoFiltrar(urlTabla);
});

/*
 * Filtramos por los datos del formulario.
 */
function y41aOrganismosTrasladoFiltrar(url) {
	$("#y41aOrganismosTrasladoTabla").rup_grid("clearGridData");
	var query = $("#y41aOrganismosTrasladoForm").serialize();
	$("#y41aOrganismosTrasladoTabla").rup_grid("setGridParam", {url : url+"&" + query});
	$("#y41aOrganismosTrasladoTabla").rup_grid("reloadGrid");
}




