jQuery(function($) {
	// posicionamos el menu
	$("#accordion").accordion('activate', 6 );
	
	$("#y41a-busquedaCampanias_feedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
		
	
	var fila;
	/* *********************
	 * Fecha desde - hasta *
	 * *********************
	 */
	y41aFunBusquedaCampaniasPintarRangoFechas();
	
	
	
	/* ********************
	 * Combo idioma
	 * ********************
	 */
	var list = new Array();				
	list[0]= {i18nCaption: "campania", value:"C"};
	list[1]= {i18nCaption: "reddealerta", value:"A"};
	list[2]= {i18nCaption: "reclamacion", value:"D"};
	//Transformo en JSON la lista
	$.toJSON(list);	
	
	$("#y41aBusquedaCampaniasComboTipoexpediente").rup_combo({
		source : list,
		width:"250",
		blank : ""
	});
			
	
	
	
	
	
	pintarTabla();
	
	
	  document.location.href = "#y41a-busquedaCampanias_feedback";
});



function pintarTabla(){
	
	var y41aVarWidthTablaBusquedaCampanias = $("#contentMV").width();
	
	var query = $("#y41aBusquedaCampaniasform").serialize();
	
	$("#y41aBusquedaCampaniasGrid").rup_grid({
		hasMaint: false,
		width: y41aVarWidthTablaBusquedaCampanias,
		url : "/y41aVistaWar/campahnarecib/buscarCampania?" + query + "&R01HNoPortal=true",
		loadOnStartUp: true,
		pagerName: "pagerBusquedaCampanias",
		page: 5,
		rowNum: "10",
		sortorder: "desc",
		hoverrows: true,
		sortname: "fecrecepcion",
		fluidBaseLayer:"capaPadre",
		colNames: [
		            $.rup.i18n.app.y41aVistaWar_busquedacampanias.tipoexpediente,
					$.rup.i18n.app.y41aVistaWar_busquedacampanias.codigo,
					$.rup.i18n.app.y41aVistaWar_busquedacampanias.descripcion,
					$.rup.i18n.app.y41aVistaWar_busquedacampanias.ninspecciones,
					$.rup.i18n.app.y41aVistaWar_busquedacampanias.frecepcion,
					$.rup.i18n.app.y41aVistaWar_busquedacampanias.ffinalizacion,
					'',
					'',
					'',
					''
				],
				colModel: [
						{ 
							name: "tipo",
							label: "tipo",
							index: "tipo",
							editable:false,
							width: funcPercentage(16,y41aVarWidthTablaBusquedaCampanias),
							edittype: "text",
					    	formatter:function(cellvalue, el, opts){
			                	var litaral = "";
			                	if(cellvalue == $.rup.i18n.app.y41aVistaWar_busquedacampanias.icampania)
			                	{
			                		litaral = $.rup.i18n.app.y41aVistaWar_busquedacampanias.campania;
			                	}
			                	else if(cellvalue == $.rup.i18n.app.y41aVistaWar_busquedacampanias.ireddealerta)
			                	{
			                		litaral = '<img src="'+$.rup.APP_STATICS+'/images/y41a-campana2.png" class="y41a-campana" >' + "  "  + $.rup.i18n.app.y41aVistaWar_busquedacampanias.reddealerta;
			                	}
			                	else if(cellvalue == $.rup.i18n.app.y41aVistaWar_busquedacampanias.ireclamacion)
			                	{
			                		litaral = $.rup.i18n.app.y41aVistaWar_busquedacampanias.reclamacion;
			                	}
								return litaral;
							}
						},
						{ 
							name: "codigo",
							label: "codigo",
							index: "codigo",
							editable:false,
							width: funcPercentage(14,y41aVarWidthTablaBusquedaCampanias),
							edittype: "text"
						},
						{ 
							name: "descripcion",
							label: "descripcion",
							index: "descripcion",
							editable:false,
							width: funcPercentage(24,y41aVarWidthTablaBusquedaCampanias),
							edittype: "text",
							formatter: function(cellvalue, el, opts){
		                		var link;
		        				if(opts.tipo == $.rup.i18n.app.y41aVistaWar_busquedacampanias.icampania)
		        	            {	
		        					link = "<a href='#' value='" + cellvalue + "' onClick='abrirDetalleCampania(" + el.rowId + ");'>" + cellvalue + "</a>";
		        	            }
		        	            else if(opts.tipo == $.rup.i18n.app.y41aVistaWar_busquedacampanias.ireddealerta)
		        	            {
		        	            	link = "<a href='#' value='" + cellvalue + "' onClick='abrirDetalleAlerta("+ el.rowId +");'>" + cellvalue + "</a>";
		        	            }
		        	            else if(opts.tipo == $.rup.i18n.app.y41aVistaWar_busquedacampanias.ireclamacion)
		        	            {
		        	            	link =  "<a href='#' value='" + cellvalue + "' onClick='abrirDetalleReclamacion("+ el.rowId +");'>" + cellvalue + "</a>";
		        	            }
								return link;
							}
						},
						{ name: "numInspecciones",
							label: "numInspecciones",
							index: "numInspecciones",
							editable:false,
							width: funcPercentage(14,y41aVarWidthTablaBusquedaCampanias),
							align: "center",
							edittype: "text"
						},
						{ 
							name: "fecrecepcion",
							label: "fecrecepcion",
							index: "fecrecepcion",
							editable:false,
							width: funcPercentage(12,y41aVarWidthTablaBusquedaCampanias),
							align: "center",
							edittype: "text"
						},
						{ 
							name: "fecfinalizacion",
							label: "fecfinalizacion",
							index: "fecfinalizacion",
							editable:false,
							width: funcPercentage(12,y41aVarWidthTablaBusquedaCampanias),
							align: "center",
							edittype: "text"
						},
						{ name: "codOrganismo",
							label: "codOrganismo",
							index: "codOrganismo",
							editable:false,
							hidden: true,
							width: funcPercentage(1,y41aVarWidthTablaBusquedaCampanias),
							edittype: "hidden"
						},
						{ name: "codigoRecibida",
							label: "codigoRecibida",
							index: "codigoRecibida",
							editable:false,
							hidden: true,
							width: funcPercentage(1,y41aVarWidthTablaBusquedaCampanias),
							edittype: "hidden"
						},
						{ name: "codigoDetalle",
							label: "codigoDetalle",
							index: "codigoDetalle",
							editable:false,
							hidden: true,
							width: funcPercentage(1,y41aVarWidthTablaBusquedaCampanias),
							edittype: "hidden"
						},
						{ name: "situacion",
							label: "situacion",
							index: "situacion",
							editable:false,
							hidden: true,
							width: funcPercentage(1,y41aVarWidthTablaBusquedaCampanias),
							edittype: "hidden"
						}
					],
					afterInsertRow : function(rowid, rowdata)
					{
					    if (rowdata.situacion == $.rup.i18n.app.y41aVistaWar_busquedacampanias.campahna_sin_actuacion)
					    {
					        $(this).jqGrid('setRowData', rowid, false, {background:'#FACFDE'});
					    }
					    else if (rowdata.situacion == $.rup.i18n.app.y41aVistaWar_busquedacampanias.campahna_con_actuacion)
					    {
					        $(this).jqGrid('setRowData', rowid, false, {background:'#C3FACE'});
					    }
					    else if (rowdata.situacion == $.rup.i18n.app.y41aVistaWar_busquedacampanias.campahna_finalizada)
					    {
					        $(this).jqGrid('setRowData', rowid, false, {background:'#D4D9D5'});
					    }
					}
	});
}


		$("#y41aBusquedaCampaniasBtFiltrar").click(function () 
		{	
				filtraCampanias();	
		});
		
		function filtraCampanias()
		{
			if (validarCamposBusquedaCampanias()){
				$("#y41aBusquedaCampaniasGrid").rup_grid("clearGridData");
				var query = $("#y41aBusquedaCampaniasform").serialize();
				$("#y41aBusquedaCampaniasGrid").rup_grid("setGridParam", {url : "/y41aVistaWar/campahnarecib/buscarCampania?" + query + "&R01HNoPortal=true"});
				$("#y41aBusquedaCampaniasGrid").rup_grid("reloadGrid");
			}
		}
				
			function abrirDetalleCampania(fila)
			{
				fila = $("#y41aBusquedaCampaniasGrid").rup_grid("getRowData", fila);
				
				$("#y41aBusquedaCampaniasCodigo").val(fila.codigoDetalle);
				
				$("#y41aDetalleCampaniaModal").rup_dialog({
					modal: true,
					autoOpen: true,
					width: "800",
					height: "auto",
					position: "top",
					title: $.rup.i18n.app.y41aVistaWar_busquedacampanias.detalle_campahna,
					url: "/y41aVistaWar/campahnarecib/detalleCampania?R01HNoPortal=true",  
					type:$.rup.dialog.AJAX
				});		
			}
			
			function abrirDetalleAlerta(fila)
			{
				fila = $("#y41aBusquedaCampaniasGrid").rup_grid("getRowData", fila);
				
				$("#y41aBusquedaCampaniasCodigo").val(fila.codigoDetalle);
				
				$("#y41aDetalleAlertaModal").rup_dialog({
					modal: true,
					autoOpen: true,
					width: "800",
					height: "auto",
					position: "top",
					title: $.rup.i18n.app.y41aVistaWar_busquedacampanias.detalle_alerta,
					url: "/y41aVistaWar/campahnarecib/detalleAlerta?R01HNoPortal=true",  
					type:$.rup.dialog.AJAX
				});
			}
			function abrirDetalleReclamacion(fila)
			{
				//alert(codigo);
				fila = $("#y41aBusquedaCampaniasGrid").rup_grid("getRowData", fila);
				var hdcodigo = fila.codigoDetalle;
				//alert("hdcodigo: "+hdcodigo);
				
				y41aSolicitudModoConsultaDesdeExternos = true;
			 	y41aVarSolicitudesCodigoHecho = hdcodigo; //X el ESCRITORIO
			 	$("#y41aTabsBusquedaResultadoSolicitudesDivModalDetalleSolicitud").rup_dialog({
			 		modal: true,
			 		autoOpen: true,
			 		width: "980",
			 		height: "auto",
			 		position: "top" ,
			 		title: $.rup.i18n.app.y41aTitlesModalesSolicitudes.detalleHecho,
			 		url: "/y41aVistaWar/denuncia/y41aTabsDetalleSolicitudModal?R01HNoPortal=true", 
			 		type:$.rup.dialog.AJAX,
			 		close: function(event,ui){
						//$('#y41aOrganismosTrasladoTabla').jqGrid('GridUnload');
						$('#y41aBusquedaCampaniasGrid').jqGrid('GridUnload');
						pintarTabla();
						//actualizarTabla();
					}
			 	});	
				
				
			}

			
			
			$("#y41aBusquedaCampaniasBtFinalizar").click(function () 
			{
				
				var selectedRow = $("#y41aBusquedaCampaniasGrid").rup_grid("getSelectedRows")[0];
				row = $("#y41aBusquedaCampaniasGrid").rup_grid("getRowData", selectedRow);
				var strTipo = "";
            
				if(row.codigo == "" || row.codigo == null)
					{
						$("#y41a-busquedaCampanias_feedback").rup_feedback("option", "delay", 800);
						$("#y41a-busquedaCampanias_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
					}
				else if(row.fecfinalizacion != "")
				{
					$("#y41a-busquedaCampanias_feedback").rup_feedback("option", "delay", 800);
					$("#y41a-busquedaCampanias_feedback").rup_feedback("set",$.rup.i18n.app.y41aVistaWar_busquedacampanias.finalizada, "alert");
				}
				else
					{
						if(row.tipo == $.rup.i18n.app.y41aVistaWar_busquedacampanias.campania)
		            	{
		            		strTipo = $.rup.i18n.app.y41aVistaWar_busquedacampanias.icampania;
		            	}
		            	//else if(row.tipo == '<img src="'+$.rup.APP_STATICS+'/images/y41a-campana2.png" width="15" height="15">' + "  "  + $.rup.i18n.app.y41aVistaWar_busquedacampanias.reddealerta)
						else if(row.tipo.indexOf($.rup.i18n.app.y41aVistaWar_busquedacampanias.reddealerta) >= 0)
		            	{
		            		strTipo = $.rup.i18n.app.y41aVistaWar_busquedacampanias.ireddealerta;
		            	}
		            	else if(row.tipo == $.rup.i18n.app.y41aVistaWar_busquedacampanias.reclamacion)
		            	{
		            		strTipo = $.rup.i18n.app.y41aVistaWar_busquedacampanias.ireclamacion;
		            	}

						fnFinalizarCampanias(row.codigoRecibida,strTipo);	
					}
				
			});
			
			function fnFinalizarCampanias(codigo, tipo)
			{
				var jqxhr = $.ajax({
					type : 'PUT',
					url : "/y41aVistaWar/campahnarecib/finalizarCampahna?codigo=" + codigo + "&tipo=" + tipo + "&R01HNoPortal=true",
					dataType : "json",
					contentType : 'application/json',
					error: function (jqXHR, textStatus, errorThrown){
						switch(jqXHR.status){		
							case 406:
								$("#y41a-busquedaCampanias_feedback").rup_feedback("option", "delay",null);
								$("#y41a-busquedaCampanias_feedback").rup_feedback("set",jqXHR.responseText, "error");
								break;
							//case 500:	
							default:
								$("#y41a-busquedaCampanias_feedback").rup_feedback("option", "delay",null);
								$("#y41a-busquedaCampanias_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
								break;
						}
					},
					success : function(data) {
				
								$("#y41a-busquedaCampanias_feedback").rup_feedback("option", "delay",800);
								$("#y41a-busquedaCampanias_feedback").rup_feedback("set", "ok", "ok");
								filtraCampanias();
					}
				});
			}
			
			
			
			$("#y41aBusquedaCampaniasBtActuaciones").click(function () {
				
				var selectedRow = $("#y41aBusquedaCampaniasGrid").rup_grid("getSelectedRows")[0];
				row = $("#y41aBusquedaCampaniasGrid").rup_grid("getRowData", selectedRow);
				var strTipo = "";
            
				if(row.codigo == "" || row.codigo == null)
					{
						$("#y41a-busquedaCampanias_feedback").rup_feedback("option", "delay", 800);
						$("#y41a-busquedaCampanias_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
					}
				//quitamos esta validación 8-5-12
			/*	else if(row.fecfinalizacion != "")
				{
					$("#y41a-busquedaCampanias_feedback").rup_feedback("option", "delay", 800);
					$("#y41a-busquedaCampanias_feedback").rup_feedback("set",$.rup.i18n.app.y41aVistaWar_busquedacampanias.finalizada, "alert");
				}*/
				else
					{
					
						if(row.tipo == $.rup.i18n.app.y41aVistaWar_busquedacampanias.campania)
		            	{
							
		            		strTipo = $.rup.i18n.app.y41aVistaWar_busquedacampanias.icampania;
		            	}
		            	else if(row.tipo.indexOf($.rup.i18n.app.y41aVistaWar_busquedacampanias.reddealerta) > 0)	
		            	{
		            	
		            		strTipo = $.rup.i18n.app.y41aVistaWar_busquedacampanias.ireddealerta;
		            	}
		            	else if(row.tipo == $.rup.i18n.app.y41aVistaWar_busquedacampanias.reclamacion)
		            	{
		            		strTipo = $.rup.i18n.app.y41aVistaWar_busquedacampanias.ireclamacion;
		            	}
					
						fnBuscarCampania(row.codigo,row.descripcion,row.codigoRecibida,strTipo,row.fecfinalizacion);	
					}
				
				
			});
			
			function fnBuscarCampania(codigo,descripcion ,codigoRecibida,tipo,fecfinalicion)
			{
				var strDescripcion = $(descripcion);
				
		
				
				$("#y41aBusquedaCampaniasCodigo").attr("value" ,codigo);
				$("#y41aBusquedaCampaniasDescripcionCodigo").attr("value" ,strDescripcion.attr("value"));
				$("#y41aBusquedaCampaniasCodigoRecivido").attr("value" ,codigoRecibida);
				$("#y41aBusquedaCampaniasTipo").attr("value" ,tipo);
				$("#y41aBusquedaCampaniasFecfinalizacion").attr("value" ,fecfinalicion);
				
				$("#y41aBusquedaCampaniasform_Actuaciones").submit();

			}
			$("#y41aBusquedaCampaniasBtLimpiar").click(function () {
				$("#y41aBusquedaCampaniasComboTipoexpediente").rup_combo("select", "");
				$("#y41aBusquedaCampaniasFechaDesde").val("");
				$("#y41aBusquedaCampaniasFechaHasta").val("");
				$("#y41aBusquedaCampaniasFechaDesde").rup_date("destroy");
				$("#y41aBusquedaCampaniasFechaHasta").rup_date("destroy");
				y41aFunBusquedaCampaniasPintarRangoFechas();
				$("#y41aBusquedaCampaniasFechaHasta").click();
				$("#y41aBusquedaCampaniasDescripcion").val("");
				$("#y41aBusquedaCampaniasFinalizadas").removeAttr('checked');
				
				//vaciamos la tabla
				$("#y41aBusquedaCampaniasGrid").rup_grid("clearGridData");
			});
			
//RANGO FECHAS
function y41aFunBusquedaCampaniasPintarRangoFechas(){
	$.rup_date({
		from : "y41aBusquedaCampaniasFechaDesde",
		to : "y41aBusquedaCampaniasFechaHasta",
		duration : "fast"
	});
}			

$("#y41aBusquedaCampaniasBorrarFechaDesde").click(function () {
	$("#y41aBusquedaCampaniasFechaDesde").val("");
	$("#y41aBusquedaCampaniasFechaHasta").rup_date("destroy");
	y41aFunBusquedaCampaniasPintarRangoFechas();
});

$("#y41aBusquedaCampaniasaBorrarFechaHasta").click(function () {
	$("#y41aBusquedaCampaniasFechaHasta").val("");
	$("#y41aBusquedaCampaniasFechaDesde").rup_date("destroy");
	y41aFunBusquedaCampaniasPintarRangoFechas();	
});

function validarCamposBusquedaCampanias(){
	var txtFeedback = "";
	var validoCampo1 = false;
	var validoCampo2 = false;

	if ($("#y41aBusquedaCampaniasFechaDesde").val()!="" 
		&& !isDate($("#y41aBusquedaCampaniasFechaDesde").val())){
		txtFeedback += "<li>"+ $.rup.i18n.app.y41aBusquedaCampanias.fechaDesdeFormato +"</li>\n";
		validoCampo1 = false;
	}else{
		validoCampo1 = true;
	}
	if ($("#y41aBusquedaCampaniasFechaHasta").val()!="" 
		&& !isDate($("#y41aBusquedaCampaniasFechaHasta").val())){
		txtFeedback += "<li>"+ $.rup.i18n.app.y41aBusquedaCampanias.fechaHastaFormato +"</li>\n";
		validoCampo2 = false;
	}else{
		validoCampo2 = true;
	}		
	if($("#y41aBusquedaCampaniasFechaDesde").val()!="" && isDate($("#y41aBusquedaCampaniasFechaDesde").val())
			&& $("#y41aBusquedaCampaniasFechaHasta").val()!="" && isDate($("#y41aBusquedaCampaniasFechaHasta").val())){
		resultado = comparaFechas( $("#y41aBusquedaCampaniasFechaDesde").val(), $("#y41aBusquedaCampaniasFechaHasta").val());
		if(!resultado){
			txtFeedback += "<li>"+ $.rup.i18n.app.y41aBusquedaCampanias.fechaDesdeHastaCompara +"</li>\n";
			validoCampo2 = false;
		}
	}
			
	if (validoCampo1 && validoCampo2){
		return true;
	}else{
		$("#y41a-busquedaCampanias_feedback").rup_feedback("option", "delay",null);
		$("#y41a-busquedaCampanias_feedback").rup_feedback("set","<ul>" + txtFeedback + "</ul>", "error");
		return false;
	}
}
