jQuery(function($) {
	

	
	$("#impresionCartasActuacion_feedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	
	var y41aVarWidthImpresionCartasActuacionesGrid = 770;
	
	$("#y41aImpresionCartasActuacionesGrid").rup_grid({
		hasMaint: false,
		url : "/y41aVistaWar/plantillains/getAllInspeccion?R01HNoPortal=true",
		loadOnStartUp: true,
		pagerName: "pagerImpresionCartasActuaciones",
		page: 5,
		rowNum: "10",
		sortorder: "asc",
		hoverrows: true,
		sortname: "plinscodigo",
		width:y41aVarWidthImpresionCartasActuacionesGrid,
		colNames: [
		            '',
		            '',
					$.rup.i18n.app.y41aVistaWar_inspecciones.inspeccion,
					$.rup.i18n.app.y41aVistaWar_inspecciones.fechaUltimaModificacion,
					$.rup.i18n.app.y41aVistaWar_inspecciones.plantilla,
					'',
				],
				colModel: [
					{ 
						name: "plinscodigo",
						label: "plinscodigo",
						index: "plinscodigo",
						editable:false,
						hidden: true,
						edittype: "hidden"
					},
					{ 
						name: "inscodcarta",
						label: "inscodcarta",
						index: "inscodcarta",
						editable:false,
						hidden: true,
						edittype: "hidden"
					},
					{ 
						name: "insnombre" + recuperarLetraIdioma(),
						label: "insnombre" + recuperarLetraIdioma(),
						index: "insnombre" + recuperarLetraIdioma(),
						editable:false,
						width: funcPercentage(30,y41aVarWidthImpresionCartasActuacionesGrid),
						edittype: "text"
					},
					{ 
						name: "plinsultmodificacion",
						label: "plinsultmodificacion",
						index: "plinsultmodificacion",
						editable:false,
						width: funcPercentage(30,y41aVarWidthImpresionCartasActuacionesGrid),
						edittype: "text",
						align:'center'
					},
					{ 
						name: "plinsnombre" ,
						label: "plinsnombre" ,
						index: "plinsnombre" ,
						editable:false,
						width: funcPercentage(40,y41aVarWidthImpresionCartasActuacionesGrid),
						edittype: "text"
				/*			,
						formatter: formateadorLink*/
					},		
					{ 
						name: "plinscontenttypefile",
						label: "plinscontenttypefile",
						index: "plinscontenttypefile",
						editable:false,
						width: "100",
						hidden: true,
						edittype: "hidden"
					}
				]
	
	});
	
});

//********************************************************************************
//**********************FIN INICIALIZAR*******************************************
//********************************************************************************
$("#y41aImpresionCartasActuacionesBtGenerarCarta").click(function () {
	
	var filaSeleccionada = $("#y41aImpresionCartasActuacionesGrid").rup_grid("getSelectedRows")[0];
	var fila = $("#y41aImpresionCartasActuacionesGrid").rup_grid("getRowData", filaSeleccionada);
	
	if(fila.inscodcarta == "" || fila.inscodcarta == null)
	{
		$("#impresionCartasActuacion_feedback").rup_feedback("option", "delay", 800);
		$("#impresionCartasActuacion_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
	}
	else{
		
		funcGenerarCartas(fila.inscodcarta);
	}
});

function funcGenerarCartas(inscodcarta)
{
	
	var atcodigo = $("#y41aTabsAtcodigo").val(); //código de actuacion
	var  accodigo = $("#y41aTabsActuacionesCodigoActa").val();//código de acta
	
	var jqxhr = $.ajax({
		type : 'PUT',
		url : "/y41aVistaWar/actafile/generarCartaInspecciones?atcodigo=" + atcodigo + "&accodigo=" + accodigo + "&inscodcarta=" + inscodcarta + "&R01HNoPortal=true",
		dataType : "json",
		contentType : 'application/json',
		error: function (jqXHR, textStatus, errorThrown){
			switch(jqXHR.status){		
				case 406:
					$("#impresionCartasActuacion_feedback").rup_feedback("option", "delay",null);
					$("#impresionCartasActuacion_feedback").rup_feedback("set",jqXHR.responseText, "error");
					break;
				case 409:
					controlY41aUDAException(jqXHR, "impresionCartasActuacion_feedback");
					break;
				//case 500:	
				default:
					$("#impresionCartasActuacion_feedback").rup_feedback("option", "delay",null);
					$("#impresionCartasActuacion_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
					break;
			}
		},
		success : function() {
					$("#y41aImpresionCartasModal").rup_dialog("close");
					$("#impresionCartasActuacion_feedback").rup_feedback("option", "delay",800);
					$("#impresionCartasActuacion_feedback").rup_feedback("set", "ok", "ok");
					var selected = $("#y41aTabsActuaciones").tabs('option', 'selected'); 
					if(selected == 5)
					{
						reloadTablaDocs();
					}
		}
	});
	
}

