jQuery(function($) {
	
	$("#y41aDocumentosActa_feedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	var y41aVarWidthActuacionesTablaDocumentos = $("#y41a-BorderDocumento").width()-18;
	$("#y41aDocumetosActaGrid").rup_grid({
		hasMaint: false,
		width: y41aVarWidthActuacionesTablaDocumentos,
		url : "/y41aVistaWar/actafile?R01HNoPortal=true&actaAccodigo=" + $("#y41aTabsActuacionesCodigoActa").val(),
		loadOnStartUp: true,
		pagerName: "pagerDocumetosActa",
		page: 5,
		rowNum: "10",
		sortorder: "asc",
		hoverrows: true,
		sortname: "s3codocumento",
		colNames: [
		            $.rup.i18n.app.y41aVistaWar_documentoActa.codigo,
					$.rup.i18n.app.y41aVistaWar_documentoActa.nombreDocu,
					$.rup.i18n.app.y41aVistaWar_documentoActa.fechaAlmacena,
					$.rup.i18n.app.y41aVistaWar_documentoActa.descripcion,
					$.rup.i18n.app.y41aVistaWar_documentoActa.origen,
				],
				colModel: [
					{ 
						name: "s3codocumento",
						label: "s3codocumento",
						index: "s3codocumento",
						editable:false,
						width: funcPercentage(1,y41aVarWidthActuacionesTablaDocumentos),
						hidden: true,
						edittype: "hidden"
					},
					{ 
						name: "s3nomfile",
						label: "s3nomfile",
						index: "s3nomfile",
						editable:false,
						width: funcPercentage(25,y41aVarWidthActuacionesTablaDocumentos),
						edittype: "text",
						formatter: formateadorLink
					},
					{ 
						name: "s3fecha",
						label: "s3fecha",
						index: "s3fecha",
						editable:false,
						width: funcPercentage(19,y41aVarWidthActuacionesTablaDocumentos),
						edittype: "text",
						align:'center'
					},
					{ 
						name: "s3desfile",
						label: "s3desfile",
						index: "s3desfile",
						editable:false,
						width: funcPercentage(33,y41aVarWidthActuacionesTablaDocumentos),
						edittype: "text"
					},
					{ 
						name: "s3origen" ,
						label: "s3origen" ,
						index: "s3origen" ,
						formatter: function(cellvalue, el, opts){
							
							if(cellvalue == "V")
							{
								return $.rup.i18n.app.y41aVistaWar_documentoActa.origenEstablecimiento; 
							}
							else if(cellvalue == "A")
							{
								return $.rup.i18n.app.y41aVistaWar_documentoActa.origenAdministracion; 
							}
							else if(cellvalue == "R")
							{
								return $.rup.i18n.app.y41aVistaWar_documentoActa.origenResponsable; 
							}
							
						},
						editable:false,
						width: funcPercentage(20,y41aVarWidthActuacionesTablaDocumentos),
						edittype: "text"
							//,
						//formatter: formateadorLink
					}
				]
	
	});

	$("#y41aDocumetosActaCodigo").attr("value", $("#y41aTabsActuacionesCodigoActa").val());
	
	recargarUpload();
	recargarAjaxForm();
	
	
});
//****************************************************************
//*****************FIN INICIALIZAR********************************
//****************************************************************

/*function y41aBuscarDocumetos() 
{
	$("#y41aDocumetosActaGrid").rup_grid("clearGridData");
	$("#y41aDocumetosActaGrid").rup_grid("setGridParam", {url : "/y41aVistaWar/actafile?R01HNoPortal=true&actaAccodigo=" + $("#y41aTabsActuacionesCodigoActa").val()});
	$("#y41aDocumetosActaGrid").rup_grid("reloadGrid");
}	*/

	function formateadorLink(cellvalue, options, rowObject) {
		
		if(cellvalue != null)
		{
			return "<a href=/y41aVistaWar/actafile/documentofile/"+ rowObject.s3codocumento + "?R01HNoPortal=true>" + cellvalue + "</a>";
		}
		else{
			return "";
		}
	}

	function recargarUpload(){
		$('#fileupload_file_form_plantilla').rup_upload({
			fileInput: $("#y41aDocumetoActaPlantilla"),
			maxFileSize: 5000000,
			singleFileUploads:true,
			submitInForm:true
		});	
	}
	function recargarAjaxForm(){
		// Se utiliza jquery.form para realizar el submit de los formularios por AJAX
		$("#y41aDocumentoActaForm").ajaxForm({
			success : function(json) {
				documentosActaLimpiarDocumento();
				reloadTablaDocs();
				$("#y41aDocumentosActa_feedback").rup_feedback("option", "delay", 800);
				$("#y41aDocumentosActa_feedback").rup_feedback("set",$.rup.i18n.app.comun.datosEnviados,"ok");
			},
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){		
					case 406:
						$("#y41aDocumentosActa_feedback").rup_feedback("option", "delay",null);
						$("#y41aDocumentosActa_feedback").rup_feedback("set",jqXHR.responseText, "error");
						break;
					case 409:
						controlY41aUDAException(jqXHR, "y41aDocumentosActa_feedback");
						break;
					//case 500:	
					default:
						$("#y41aDocumentosActa_feedback").rup_feedback("option", "delay",null);
						$("#y41aDocumentosActa_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
						break;
				}
			}}
		); 
	}
		
	/* **********************************************************
	 * Funcion que limpia/inicializa los valores del formulario *
	 * **********************************************************
	 */
	function documentosActaLimpiarDocumento(){
		
		$("#y41aDocumetoActaPlantilla").val("");
		$("#y41aDocumetoActaFileupload").html('<table class="files"></table>');
		recargarUpload();
		$("#y41aDocumetosActaDescripcion").val("");	
	}
	//limpiar tabla
	function reloadTablaDocs()
	{
		$("#y41aDocumetosActaGrid").rup_grid("clearGridData");
																	
		$("#y41aDocumetosActaGrid").rup_grid("setGridParam", {url : "/y41aVistaWar/actafile?R01HNoPortal=true&actaAccodigo=" + $("#y41aTabsActuacionesCodigoActa").val()});
		$("#y41aDocumetosActaGrid").rup_grid("reloadGrid");
		
	}
	
	function funcGrabarDocumentos(selected)
	{
		if(selected == 5)
		{
			SubirDocumentoActa();
		}
	}
		
	function SubirDocumentoActa()
	{
		if (validarCampos()){
			if ($("#y41aDocumetoActaPlantilla").val()==""){
				$.rup_messages("msgConfirm",{
					   title:$.rup.i18n.app.msg.confirmacion,
					   message: $.rup.i18n.app.msg.confiramacionPlantillaeliminar,
					   OKFunction : function () {
						   $("#y41aDocumentoActaForm").submit();
						}
				});
			}else{
				$("#y41aDocumentoActaForm").submit();
			}
		}
	}
	
	function validarCampos(){
		
		var txtFeedback = "";
		var bCampo1 = false;
		var bCampo2 = false;
		
		
		if ($("#y41aDocumetoActaPlantilla").val()==""){
			txtFeedback +=  $.rup.i18n.app.y41aVistaWar_documentoActa.documento + "\n";
			bCampo1 = false;
		}else{
			bCampo1 = true;
		}
		

		
		if (bCampo1){
			return true;
		}else{
			
			$("#y41aDocumentosActa_feedback").rup_feedback("option", "delay",null);
			$("#y41aDocumentosActa_feedback").rup_feedback("set","<ul>" + txtFeedback + "</ul>", "error");
			return false;
		}
	}
	
	$("#y41aDocumetosActaBtEliminar").click(function(){
			
		var selectedRow = $("#y41aDocumetosActaGrid").rup_grid("getSelectedRows")[0];
		var row = $("#y41aDocumetosActaGrid").rup_grid("getRowData", selectedRow);
		
		if(row.s3codocumento == "" || row.s3codocumento == null)
		{
			$("#y41aDocumentosActa_feedback").rup_feedback("option", "delay", 800);
			$("#y41aDocumentosActa_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
		else
		{
		   $.rup_messages("msgConfirm",{
			   title:$.rup.i18n.app.msg.confirmacion,
			   message: $.rup.i18n.app.msg.confiramacioneliminar,
			   OKFunction : function () {
				   eliminarDocumentoActa(row);
				}
		   });
			
		}	
		
		
	});
	
	function eliminarDocumentoActa(row)
	{
		var jqxhr = $.ajax({
			type : 'DELETE',
			url : "/y41aVistaWar/actafile/removeDocumentoActa/" + row.s3codocumento + "/" + $("#y41aTabsActuacionesCodigoActa").val() + "?R01HNoPortal=true",
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){		
					case 406:
						$("#censodecisiones_feedback").rup_feedback("option", "delay",null);
						$("#censodecisiones_feedback").rup_feedback("set",jqXHR.responseText, "error");
						break;
					case 409:
						controlY41aUDAException(jqXHR, "censodecisiones_feedback");
						break;
					default:
						$("#censodecisiones_feedback").rup_feedback("option", "delay",null);
						$("#censodecisiones_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
						break;
				}
			},
			success : function(data) {

						$("#censodecisiones_feedback").rup_feedback("option", "delay",800);
						$("#censodecisiones_feedback").rup_feedback("set", "ok", "ok");
						reloadTablaDocs();
			}
		});
	}
	
	
	
