/* ************************************************************************************************************************************************************
 * INICIALIZACION
 * ************************************************************************************************************************************************************
 */
jQuery(function($) {

	//feedback
	$("#y41aResultadoTablaConsultasFeedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	//alert($.rup_utils.get("language"));
	
//	//variable para recoger los datos de la fila
	var row;
	
	//inicializacion de la variable que abre la pantalla de consulta en edicion
	$('#y41aResultadoEditando').val("");
	
	
	y41aFunResultadoReloadTablaConsultas();
	

});
/* ****************************************************************************************************************************************************************
 * FIN INICIALIZACION
 * ****************************************************************************************************************************************************************
 */
//TABLA

//Reload
function y41aFunResultadoReloadTablaConsultas()
{
	//alert("entra en el reload");
	$('#y41aResultadoTablaConsultas').jqGrid('GridUnload');
	y41aFunResultadoPintarTablaConsultas();
}

//Pintar
function y41aFunResultadoPintarTablaConsultas(){	
	
	//alert("tamaño tabla :"+ $("#rup-tabs-2").width());
	
	var y41aVarTamanyoTablaResultadoConsultas = $("#y41aBusquedaResultadoTabs").width()-20;
	var query = $("#y41aBusquedaForm").serialize();
	
	//alert("/y41aVistaWar/consulta/busqueda?R01HNoPortal=true&" + query);
	$("#y41aResultadoTablaConsultas").rup_grid({
		url:"/y41aVistaWar/consulta/busqueda?R01HNoPortal=true&" + query,
		loadOnStartUp: true,
		width: y41aVarTamanyoTablaResultadoConsultas,
		pagerName:"y41aResultadoTablaConsultasPager",
		rowNum: "10",
		sortorder: "asc",
		sortname: "numeroConsulta",
		colNames:[
		    $.rup.i18n.app.y41aResultadoTablaConsultas.cocodigo,
		    $.rup.i18n.app.y41aResultadoTablaConsultas.numeroConsulta,
		    $.rup.i18n.app.y41aResultadoTablaConsultas.cofecha,
		    $.rup.i18n.app.y41aResultadoTablaConsultas.monombre,
		    $.rup.i18n.app.y41aResultadoTablaConsultas.nombreMunicipio,
			$.rup.i18n.app.y41aResultadoTablaConsultas.psnombre,
			$.rup.i18n.app.y41aResultadoTablaConsultas.coinl37,
			$.rup.i18n.app.y41aResultadoTablaConsultas.cosituacion
		],
		colModel: [		    
		    { 	name: "cocodigo", 
		    	index: "cocodigo",
		    	hidden: true
		    },
		    { 	name: "numeroConsulta",
		    	index: "numeroConsulta",
		    	align: "left",
				editable:false,
				edittype: "text",
		    	width: funcPercentage(16,y41aVarTamanyoTablaResultadoConsultas),
				formatter: y41aResultadosFormateadorLink
		    },
		    { 	name: "cofecha", 
		    	index: "cofecha",
		    	align: "center",
				editable:false,
				edittype: "text",
		    	width: funcPercentage(10,y41aVarTamanyoTablaResultadoConsultas)
		    },
		    { 	name:  "monombre", 
		    	index: "monombre",
		    	align: "left",
				editable:false,
				edittype: "text",
		    	width: funcPercentage(18,y41aVarTamanyoTablaResultadoConsultas)
		    },		    
		    { 	name: "nombreMunicipio", 
	    		index: "nombreMunicipio",
				editable:false,
				edittype: "text",
		    	width: funcPercentage(16,y41aVarTamanyoTablaResultadoConsultas)
	    	},	
		    { 	name: "psnombre" + recuperarLetraIdioma(),
		    	index: "psnombre" + recuperarLetraIdioma(),
				editable:false,
				edittype: "text",
		    	width: funcPercentage(24,y41aVarTamanyoTablaResultadoConsultas)
		    },
	    	{ name: "coinl37", index: "coinl37" ,
				editoptions: {
					//defaultValue:"S",
					value:{	"N":$.rup.i18n.app.y41aResultadoOrigen.oficina,
							"null":$.rup.i18n.app.y41aResultadoOrigen.oficina,
							"":$.rup.i18n.app.y41aResultadoOrigen.oficina,
							"S":$.rup.i18n.app.y41aResultadoOrigen.web}
					},
				formatter:"select",
				align: "left",
				editable:false,
				edittype: "text",
		    	width: funcPercentage(8,y41aVarTamanyoTablaResultadoConsultas)
			},
	    	{ name: "cosituacion", index: "cosituacion" ,
				editoptions: {
					//defaultValue:"P",
					value:{"R":"",
						   "null":'<img src="'+$.rup.APP_STATICS+'/images/y41a-bandera-roja-icono.png"  width="16" height="16">',
						   "":'<img src="'+$.rup.APP_STATICS+'/images/y41a-bandera-roja-icono.png"  width="16" height="16">',
						   "P":'<img src="'+$.rup.APP_STATICS+'/images/y41a-bandera-roja-icono.png"  width="16" height="16">'}
					},
				formatter:"select",
		    	align: "center",
				editable:false,
				edittype: "text"
			}
		],
		afterInsertRow : function(rowid, rowdata)
		{
			
		    if ((rowdata.cosituacion == "P") || (rowdata.cosituacion == "") || (rowdata.cosituacion == null))
		    {
		        $(this).jqGrid('setRowData', rowid, false, 'destacadoRojo');
		    }
		}
	});
}


function y41aResultadosFormateadorLink(cellvalue, options, rowObject) {
	
	return "<a href='#' onClick='y41aFunResultadoModalDetalle("+ options.rowId  +");'>" + cellvalue + "</a>";
	
}




/* ****************************************************************************************************************************************************************
 * EVENTOS SOBRE BOTONES
 * ****************************************************************************************************************************************************************
 */

/* *************************************************************************************************************************************************************
 * Respuesta consulta *
 *  * comprobar que hay uno seleccionado
 * - error en el feedback
 * - o abrir la modal con la informacion recuperada
 * *************************************************************************************************************************************************************
 */
$("#y41aResultadoModalBotonRespuesta").click(function () {
	var selectedRow = $("#y41aResultadoTablaConsultas").rup_grid("getSelectedRows")[0];
	row = $("#y41aResultadoTablaConsultas").rup_grid("getRowData", selectedRow);
	var codigo = row.cocodigo;
	//alert("numeroConsulta:" +row.cocodigo);
	if(codigo == "" || codigo == null){
			$("#y41aResultadoTablaConsultasFeedback").rup_feedback("option", "delay", 800);
			$("#y41aResultadoTablaConsultasFeedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
	}else{
		//$("#y41aRespuestaConsultaAnyo").val(row.conranrg);
		y41aFunResultadoShowModalRespuestaConsulta();
	}
});
function y41aFunResultadoShowModalRespuestaConsulta(){
	$("#y41aBusquedaResultadoDivModal3").rup_dialog({
		modal: true,
		autoOpen: true,
		width: 810,
		height: "auto",
		position: "top",
		title: $.rup.i18n.app.y41aTitlesModalesConsultas.respuestaConsulta,
		close: function(event, ui) {
						
			y41aFunResultadoReloadTablaConsultas();
		},
		url: "/y41aVistaWar/respuesta/maintModalRespuestaConsulta?R01HNoPortal=true",    
		type:$.rup.dialog.AJAX
	});
}

/* *************************************************************************************************************************************************************
 * Email 
 * *************************************************************************************************************************************************************
 */ 
$("#y41aResultadoModalBotonEmail").click(function () {
	var selectedRow = $("#y41aResultadoTablaConsultas").rup_grid("getSelectedRows")[0];
	row = $("#y41aResultadoTablaConsultas").rup_grid("getRowData", selectedRow);
	var codigo = row.cocodigo;
	
	//alert("numeroConsulta" +row.cocodigo);
	if(codigo == "" || codigo == null){
			$("#y41aResultadoTablaConsultasFeedback").rup_feedback("option", "delay", 800);
			$("#y41aResultadoTablaConsultasFeedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
	}else{
		showModalEmailConsulta();
	}
});

function showModalEmailConsulta(){
	$("#y41aBusquedaResultadoDivModal4").rup_dialog({
		modal: true,
		autoOpen: true,
		width: 840,
		height: "auto",
		position: "top",
		title: $.rup.i18n.app.y41aTitlesModalesConsultas.respuestaEmail,
		close: function(event, ui) {
			y41aFunResultadoReloadTablaConsultas();
		},
		url: "/y41aVistaWar/respuesta/maintModalRespuestaEmail?R01HNoPortal=true",    
		type:$.rup.dialog.AJAX
	});		
}

/* *************************************************************************************************************************************************************
 * Editar
 * ************************************************************************************************************************************************************* 
 */
$("#y41aResultadoModalBotonEditar").click(function () {
	//alert("editando");
	var selectedRow = $("#y41aResultadoTablaConsultas").rup_grid("getSelectedRows")[0];
	row = $("#y41aResultadoTablaConsultas").rup_grid("getRowData", selectedRow);
	y41aVarConsultasCodigoConsulta = row.cocodigo; //X el ESCRITORIO
	var codigo = row.cocodigo;
	//alert("codigo ooooo"+codigo);
	if(codigo == "" || codigo == null)
		{
			$("#y41aResultadoTablaConsultasFeedback").rup_feedback("option", "delay", 800);
			$("#y41aResultadoTablaConsultasFeedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
	else
		{
			$("#y41aConsultaModoEdicion").val(true);
			showModalModificarConsulta();
			
		}
});

function showModalModificarConsulta(){

	
	$("#y41aBusquedaResultadoDivModal5").rup_dialog({
		modal: true,
		autoOpen: true,
		width: 950,
		height: "auto",
		position: "top",
		title: $.rup.i18n.app.y41aTitlesModalesConsultas.edicionConsulta,
		close: function(event, ui) {
			y41aFunResultadoReloadTablaConsultas();
		},
		url: "/y41aVistaWar/consulta/maintTabsDetalleDocs?R01HNoPortal=true",    
		type:$.rup.dialog.AJAX
	});		
}




/* **************************************************************************************************************************************************************/
 

function cerrarModal(){
	$("#y41aBusquedaResultadoDivModal").rup_dialog("close");
}


//************************************************************
//Modal detalle
//************************************************************
function y41aFunResultadoModalDetalle(rowid){
	
	var fila = $("#y41aResultadoTablaConsultas").rup_grid("getRowData", rowid);
	var id = fila.cocodigo;
	
	y41aVarConsultasCodigoConsulta = id; //X el ESCRITORIO
	$("#y41aConsultaModoEdicion").val(true);
	showModalModificarConsulta();
}

/**
 * Exportar a tabla excel
 */
function y41aResultadoTablaConsultasGenerarExcel(){
	var query = $("#y41aBusquedaForm").serialize();
	var urlBusqueda = "/y41aVistaWar/consulta/excel?R01HNoPortal=true&" + query;
	window.open(urlBusqueda);
}