jQuery(function($) {

	var y41aVarWidthTablaMotivos = $("#y41aDivTablaMotivos").width();
	
	
	$("#y41aMotivosTabla").rup_grid({
		url:"/y41aVistaWar/motivo/like?R01HNoPortal=true",
		loadOnStartUp: false,
		width: y41aVarWidthTablaMotivos,
		pagerName:"y41aMotivosTablaPager",
		rowNum: "10",
		sortorder: "asc",
		sortname: "tircodigo",
		colNames:[
		    $.rup.i18n.app.y41aMotivosTabla.tircodigo,
		    $.rup.i18n.app.y41aMotivosTabla.tirnombre,
		],
		colModel: [		    
		    { 	name: "tircodigo", 
		    	index: "tircodigo",
		    	width: funcPercentage(20,y41aVarWidthTablaMotivos)
		    },
		    { 	name: "tirnombre" + recuperarLetraIdioma(),
		    	index: "tirnombre"+ recuperarLetraIdioma(),
		    	width: funcPercentage(80,y41aVarWidthTablaMotivos)
		    }
		],
		
	
		onSelectRow : function(id, selectR) {
			var datosFila = $("#y41aMotivosTabla").rup_grid("getRowData", id);
			var codigo = datosFila.tircodigo;
			var descripcion = "";
			
			
			if ("eu"==$.rup_utils.get("language")){
				descripcion = datosFila.tirnombree;
			}else{
				descripcion = datosFila.tirnombre;
			}	
			
			
			if (y41aVarConsultasModalMotivos == "y41aEstadisticasSolicitudes"){
				y41aFunctionModalMotivosAPadreEstadisticasSolicitudes(codigo,descripcion);	
			}else{
				modalMotivosAPadre(codigo,descripcion);
			}
		}		
	
	});

	y41aMotivosFiltrar();
	
	
});



/* ****************************************************************************************************
 * Boton Limpiar Filtro Modal Motivos
 * ***************************************************************************************************
 */
$("#y41aMotivosBotonLimpiar").click(function () {
	y41aMotivosLimpiar();
});

/*
 * Limpiamos todos los datos del formulario.
 */
function y41aMotivosLimpiar() {
	$("#y41aMotivosId").val("");
	$("#y41aMotivosDesc").val("");
	$("#y41aMotivosTabla").rup_grid("clearGridData");
}

/* ****************************************************************************************************
 * Boton Filtrar Modal Motivos
 * ***************************************************************************************************
 */
$("#y41aMotivosBotonFiltrar").click(function () {
	y41aMotivosFiltrar();
});

/*
 * Filtramos por los datos del formulario.
 */
function y41aMotivosFiltrar() {
	$("#y41aMotivosTabla").rup_grid("clearGridData");
	var query = $("#y41aMotivosForm").serialize();
	$("#y41aMotivosTabla").rup_grid("setGridParam", {url : "/y41aVistaWar/motivo/like?R01HNoPortal=true&" + query});
	$("#y41aMotivosTabla").rup_grid("reloadGrid");
}
