jQuery(function($) {

//    // cache content for the current tab
//    var currentTabIndex = $("#y41aTabsDetalleDocs").tabs('option', 'selected');
//    var currentTabAnchor = $("#y41aTabsDetalleDocs").data('tabs').anchors[currentTabIndex];
//    $(currentTabAnchor).data('cache.tabs', false);

    //Feedback
	$("#y41aDocumentosConsultaFeedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	//Datos precargados de la pantalla anterior
	$("#y41aDocumentosConsultaCodigoConsulta").val($("#y41aConsultaEdicionCodigoConsulta").val());
	$("#y41aDocumentosConsultaCodOrganismo").val($("#y41aConsultaEdicionCodOrganismo").val());
	$("#y41aDocumentosConsultaNumConsulta").val($("#y41aConsultaEdicionNumConsulta").val());
	$("#y41aDocumentosConsultaAnyo").val($("#y41aConsultaEdicionAnyo").val());

	var y41aVarWidthTablaDocumentosConsulta = $("#y41aTabsDetalleDocs").width()-25;
	
    //tabla
	$("#y41aTablaDocumentosConsulta").rup_grid({
		url:"/y41aVistaWar/consultafile/allFiles/"+ $("#y41aDocumentosConsultaCodigoConsulta").val() + "?R01HNoPortal=true",
		loadOnStartUp: true,
		width: y41aVarWidthTablaDocumentosConsulta,
		pagerName:"y41aTablaDocumentosConsultaPager",
		rowNum: "10",
		sortorder: "asc",
		sortname: "cofile",
		colNames:[
		    $.rup.i18n.app.y41aTablaDocumentosConsulta.fecha,
		    $.rup.i18n.app.y41aTablaDocumentosConsulta.cofile,
		    $.rup.i18n.app.y41aTablaDocumentosConsulta.nofile,
		    $.rup.i18n.app.y41aTablaDocumentosConsulta.tedesfile,
		    $.rup.i18n.app.y41aTablaDocumentosConsulta.tipofile,
		    $.rup.i18n.app.y41aTablaDocumentosConsulta.origen,
			$.rup.i18n.app.y41aTablaDocumentosConsulta.inemlusu
		],
		colModel: [	
		    { 	name: "fecha", 
		    	index: "fecha",
		    	align: "center",
		    	width: funcPercentage(10,y41aVarWidthTablaDocumentosConsulta)
		    },		           
		    { 	name: "cofile", 
		    	index: "cofile",
		    	hidden: true,
		    	width:1
		    },
		    { 	name: "nofile",
		    	index: "nofile",
		    	formatter: formateadorLink,
		    	width: funcPercentage(20,y41aVarWidthTablaDocumentosConsulta)
		    },
		    { 	name: "tedesfile",
		    	index: "tedesfile",
		    	width: funcPercentage(20,y41aVarWidthTablaDocumentosConsulta) 
		    },
		    { 	name: "tipofile",
		    	index: "tipofile",
		    	editoptions: {	
					//defaultValue:"S",
					value:{"C":$.rup.i18n.app.y41aTablaDocumentosConsultaTipoDoc.consulta,"R":$.rup.i18n.app.y41aTablaDocumentosConsultaTipoDoc.respuesta}
					},
				formatter:"select",
		    	width: funcPercentage(14,y41aVarWidthTablaDocumentosConsulta)
		    	
		    },
		    { 	name: "origen", 
		    	index: "origen",
		    	editoptions: {
					//defaultValue:"S",
					value:{"CO":$.rup.i18n.app.y41aTablaDocumentosConsultaOrigen.consumidor,"A":$.rup.i18n.app.y41aTablaDocumentosConsultaOrigen.administracion}
					},
				formatter:"select",
			    width: funcPercentage(22,y41aVarWidthTablaDocumentosConsulta)
		    },
	    	{ 	name: "inemlusu",
		    	index: "inemlusu" ,
				editoptions: {
					defaultValue:"N",
					value:{"N":"","S":'<img src="'+$.rup.APP_STATICS+'/images/sobre.JPG"  width="16" height="16">'}
					},
				formatter:"select",
				align: "center",
		    	width: funcPercentage(14,y41aVarWidthTablaDocumentosConsulta)
			}
		    
		]
	});
	recargarUpload();
	recargarAjaxForm();
	
	//check by default
	$("#y41aDocumentosConsultaAportadoCiudadano").attr('checked', true);
});


/* **********************************************************
 * Funcion que limpia/inicializa los valores del formulario *
 * **********************************************************
 */
function documentosConsultaLimpiarDocumento(){
	
	$("#kk").html('<table class="files"></table>');
	$("#file_form").val("");
	recargarUpload();
	//recargarAjaxForm();
	$("#y41aDocumentosConsultaAportadoCiudadano").attr('checked', false);
	$("#y41aDocumentosConsultaGenerado").attr('checked', false);
	$("#y41aDocumentosConsultaDescripcion").val("");

}

//limpiar tabla
function reloadTablaDocs()
{
	$("#y41aTablaDocumentosConsulta").rup_grid("clearGridData");
	$("#y41aTablaDocumentosConsulta").rup_grid("setGridParam", {url : "/y41aVistaWar/consultafile/allFiles/"+ $("#y41aDocumentosConsultaCodigoConsulta").val()+"?R01HNoPortal=true"});
	$("#y41aTablaDocumentosConsulta").rup_grid("reloadGrid");
}


$("#y41aDocumentosConsultaBotonLimpiar").click(function(){
	documentosConsultaLimpiarDocumento();
	reloadTablaDocs();
});

function recargarUpload(){
	// Upload integrado en formulario
	$('#fileupload_form').rup_upload({
		fileInput: $("#file_form"),
		submitFormButton: $("#y41aDocumentosConsultaBotonGrabar"),
		maxFileSize: 5000000,
		singleFileUploads:true,
		submitInForm:true

		
	});	
}

function recargarAjaxForm(){
	// Se utiliza jquery.form para realizar el submit de los formularios por AJAX
	$("#y41aDocumentosConsultasForm").ajaxForm(function(){
		//alert("Ajax");
		documentosConsultaLimpiarDocumento();
		reloadTablaDocs();
		$("#y41aDocumentosConsultaFeedback").rup_feedback("option", "delay", 800);
		$("#y41aDocumentosConsultaFeedback").rup_feedback("set",$.rup.i18n.app.comun.datosEnviados,"warning");
	}); 
}

/* ****************************
 * ELIMINAR *
 ****************************** */

// Eliminar - onclick del boton

$("#y41aDocumentosConsultaBotonEliminar").click(function () {
	var selectedRow = $("#y41aTablaDocumentosConsulta").rup_grid("getSelectedRows")[0];
	row = $("#y41aTablaDocumentosConsulta").rup_grid("getRowData", selectedRow);
	var codigo = row.cofile;
	if(codigo == "" || codigo == null)
		{
			$("#y41aDocumentosConsultaFeedback").rup_feedback("option", "delay", 800);
			$("#y41aDocumentosConsultaFeedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
	else
		{
		   $.rup_messages("msgConfirm",{
			   title:$.rup.i18n.app.msg.confirmacion,
			   message: $.rup.i18n.app.msg.confiramacioneliminar,
			   OKFunction : function () {
				   eliminarFilaTablaDocs(codigo);
				}
		   });
		}
});


//Eliminar - llamada
function eliminarFilaTablaDocs(codigo){
	var jqxhr = $.ajax({
		type : 'DELETE',
		url : "/y41aVistaWar/consultafile/" + codigo+"?R01HNoPortal=true",
		error: function (jqXHR, textStatus, errorThrown){
			switch(jqXHR.status){		
				case 406:
					$("#y41aDocumentosConsultaFeedback").rup_feedback("option", "delay",null);
					$("#y41aDocumentosConsultaFeedback").rup_feedback("set",jqXHR.responseText, "error");
					break;
				//case 500:	
				default:
					$("#y41aDocumentosConsultaFeedback").rup_feedback("option", "delay",null);
					$("#y41aDocumentosConsultaFeedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
					break;
			}
		},
		success : function(data) {
					$("#y41aDocumentosConsultaFeedback").rup_feedback("option", "delay",800);
					$("#y41aDocumentosConsultaFeedback").rup_feedback("set", "ok", "ok");
					reloadTablaDocs();
		}
	});
}

function validarCampos(){
	//alert(" validando campos");
	
	var txtFeedback = "";
	
	var bCampo1 = false;
	var bCampo2 = false;
	var bCampo3 = false;
	
	if ($("#file_form").val()==""){
		txtFeedback += "<li>"+ $.rup.i18n.app.y41aDocumentacion.documento +"</li>\n";
		bCampo1 = false;
	}else{
		bCampo1 = true;
	}
	
	if ($("#y41aDocumentosConsultaAportadoCiudadano").attr('checked')||$("#y41aDocumentosConsultaGenerado").attr('checked')){
		bCampo2 = true;
	}else{
		txtFeedback += "<li>"+ $.rup.i18n.app.y41aDocumentacion.origen +"</li>\n";
		bCampo2 = false;
	}
	
	if ($("#y41aDocumentosConsultaDescripcion").val()==""){
		txtFeedback += "<li>"+ $.rup.i18n.app.y41aDocumentacion.descripcion +"</li>\n";
		bCampo3=false;
	}else{
		bCampo3=true;
	}
	
	if (bCampo1 && bCampo2 && bCampo3){
		return true;
	}else{
		$("#y41aDocumentosConsultaFeedback").rup_feedback("option", "delay",null);
		$("#y41aDocumentosConsultaFeedback").rup_feedback("set","<ul>" + txtFeedback + "</ul>", "error");

		return false;
	}
}

$("#y41aDocumentosConsultaBotonGrabar").click(function () {
	if (validarCampos()){
		//alert("SUBMIT");
		$("#y41aDocumentosConsultasForm").submit();
	}
});



function formateadorLink(cellvalue, options, rowObject) {
    return "<a href=/y41aVistaWar/consultafile/"+ rowObject.cofile +"/"+ rowObject.tipofile+"?R01HNoPortal=true>" + cellvalue + "</a>";
}



