jQuery(function($) {
	
	var y41aVarBusquedaOrganismoTabla = 820;
	
	$("#y41aBusquedaOrganismoTabla").rup_grid({
		url:"/y41aVistaWar/organismo/like?R01HNoPortal=true",
		loadOnStartUp: true,
		width: y41aVarBusquedaOrganismoTabla,
		pagerName:"y41aBusquedaOrganismoTablaPager",
		rowNum: "10",
		sortorder: "asc",
		sortname: "CODORG",
		colNames:[
		    $.rup.i18n.app.y41aOrganismosTabla.pscodigo,
		    $.rup.i18n.app.y41aOrganismosTabla.psnombre,
		    $.rup.i18n.app.y41aOrganismosTabla.pslocalidad,
		    $.rup.i18n.app.y41aOrganismosTabla.psactiva,
		],
		colModel: [		    
		    { 	name: "codOrg", 
		    	index: "codOrg",
		    	width: funcPercentage(20,y41aVarBusquedaOrganismoTabla)
		    },
		    { 	name: "nombre" + recuperarLetraIdiomaOrganismos(),
		    	index: "nombre" + recuperarLetraIdiomaOrganismos(),
		    	width: funcPercentage(50,y41aVarBusquedaOrganismoTabla)
		    },
		    { 	name: "nombreLocalidad",
		    	index: "nombreLocalidad",
		    	width: funcPercentage(20,y41aVarBusquedaOrganismoTabla)
		    },
		    { 	name: "activa",
		    	index: "activa",
		    	align: "center",
		    	editoptions: {
					value:{"N":'<img src="'+$.rup.APP_STATICS+'/images/y41a-false.png"  width="12" height="12">',
					"S":'<img src="'+$.rup.APP_STATICS+'/images/y41a-true.png"  width="12" height="12">'}
					},
					formatter:"select",
					width: funcPercentage(10,y41aVarBusquedaOrganismoTabla)
		    }
		],
		onCellSelect : function (rowid,iCol, cellcontent, e){
			var datosFila = $("#y41aBusquedaOrganismoTabla").rup_grid("getRowData", rowid);
			var codigo = datosFila.codOrg;
			var descripcion = datosFila.nombreEs;
			if ("eu"==$.rup_utils.get("language")){
				descripcion=datosFila.nombreEu;
			}	
			modalOrganismosAPadre(codigo,descripcion);
		}
		
	
	});

	/* **********************
	 * Combo provincia NORA *
	 * **********************
	 */
	$("#y41aBusquedaComboProvincia").rup_combo({
		source : "/y41aVistaWar/nora/provincias?R01HNoPortal=true",
		blank : "",
		sourceParam : {	label : "dsO", value : "id"	}		
	});	
	/* **********************
	 * Combo municipio NORA *
	 * **********************
	 */
	$("#y41aBusquedaComboMunicipio").rup_combo({
		parent: [ "y41aBusquedaComboProvincia" ],
		source : "/y41aVistaWar/nora/municipios?R01HNoPortal=true",
		blank : "",
		sourceParam : {	label : "dsO",	value : "id"}
	});	
	/* **********************
	 * Combo localidad NORA *
	 * **********************
	 */
	$("#y41aBusquedaComboLocalidad").rup_combo({
		parent: [ "y41aBusquedaComboProvincia", "y41aBusquedaComboMunicipio" ],
		source : "/y41aVistaWar/nora/localidades?R01HNoPortal=true",
		blank : "",
		sourceParam : {	label : "dsO", value : "id"	}
	});	

	/* ****************************************************************************************************
	 * Boton Limpiar Filtro Modal Organismos
	 * ***************************************************************************************************
	 */ 
	$("#y41aBusquedaOrganismoBotonLimpiar").click(function () {
		y41aBusquedaOrganismoBotonLimpiar();
	});

	
	/*
	 * Limpiamos todos los datos del formulario.
	 */
	function y41aBusquedaOrganismoBotonLimpiar() {
		$("#y41aBusquedaOrganismoNombre").val("");
		$("#y41aBusquedaOrganismoCodigoOrganismoId").val("");
		$("#y41aBusquedaComboProvincia").rup_combo("select", "");
		$("#y41aBusquedaOrganismoMuestrarNoActivas").attr('checked', false);
		$("#y41aBusquedaOrganismoTabla").rup_grid("clearGridData");
	}
	
	/* ****************************************************************************************************
	 * Boton Filtrar Modal Productos Servicios
	 * ***************************************************************************************************
	 */ 
	$("#y41aBusquedaOrganismoBotonFiltrar").click(function () {
		y41aBusquedaOrganismoFiltrar();
	});
	
	/*
	 * Filtramos por los datos del formulario.
	 */
	function y41aBusquedaOrganismoFiltrar() {
		//$("y41aBusquedaOrganismoTabla").rup_grid("clearGridData");
		var query = $("#y41aBusquedaOrganismoForm").serialize();
		$("#y41aBusquedaOrganismoTabla").rup_grid("setGridParam", {url : "/y41aVistaWar/organismo/like?R01HNoPortal=true&" + query});
		$("#y41aBusquedaOrganismoTabla").rup_grid("reloadGrid");
	}
});






