jQuery(function($) {
	var rowDestinatarios=0;

	$("#comunicacionOrgSelecModal_feedback").rup_feedback({
		gotoTop : false,
		block : false,
		closeLink : true
	});
	
	
	
	/* ****************************************************************************************************
	 * Funcion para listar en una tabla los organismos seleccionados
	 * ****************************************************************************************************
	 */
	
	var y41aVarWidthOrgSelecGrid = 635;

		$("#y41aOrgSelecGrid").rup_grid({
			hasMaint: false,
			width: y41aVarWidthOrgSelecGrid,
			loadOnStartUp: false,
			multiselect: true,
			sortorder: "asc",
			scroll: true,
			//hoverrows: true,
			//sortname: "M4FEENV",
			colNames: [
			    "id",
			    $.rup.i18n.app.y41aTablaCommDestinatarios.destinatarios,
			    ""
			],
			colModel: [
				{   name: "id",
					label: "id",
					index: "id",
					width: "1",
					editable: false,
					hidden:true,
					edittype: "text"
				},	
				{  name: "nombre",
			       index: "nombre",
			       //width: funcPercentage(80,y41aVarWidthOrgSelecGrid),
			       width: y41aVarWidthOrgSelecGrid,
				   editable: false,
				   sortable: false,
				   cellEdit: false,
				   formatter: formateadorLink
				}
				,	
				{  name: "nombreOrg",
			       index: "nombreOrg",
				   editable: false,
				   sortable: false,
				   cellEdit: false,
				   hidden:true
				}
		    ],
		    beforeRequest:function(){
		    	$("#jqgh_y41aOrgSelecGrid_cb").html("");
		    }	
			
		});

	
		/* ****************************************************************************************************
		 * Funcion para crear y gestinar el arbol de organismos
		 * ****************************************************************************************************
		 */	
		$("#y41aComunicacionesAlta_arbol_organismos").dynatree({
			initAjax: {
				url: "/y41aVistaWar/organismo/arbolSeleccionOrganismos?R01HNoPortal=true",
				data: {} // Optional arguments to append to the url

			},
			activeVisible: true, // Make sure, active nodes are visible (expanded).
			//checkbox: true, // Show checkboxes.
			selectMode: 1, // 1:single, 2:multi, 3:multi-hier
			onClick: function(node, event) {
				// We should not toggle, if target was "checkbox", because this
				// would result in double-toggle (i.e. no toggle)
				if( node.getEventTargetType(event) == "title" ) {
				
				
				var myKey = node.data.key;
				var label = node.data.title;
				var data = [];
				
					if (node.hasChildren()){
						var cont=0;
						var children=node.getChildren();
						for (k=0;k<children.length;k++){
							var nodeC=children[k];
							myKey = nodeC.data.key;
							if (myKey.indexOf("E_")>-1){
								data[cont]={"id": nodeC.data.key,	"nombre":nodeC.data.title, "nombreOrg":nodeC.data.title};
								cont++;
							
							}
							
						}
						
					}else{
						if (myKey.indexOf("E_")>-1){
							data[0]={"id": node.data.key,	"nombre":node.data.title, "nombreOrg":node.data.title};
						}	
					}
					
					for (k=0;k<data.length;k++){
						if (!filtrarDuplicados(data[k].id)){
							var rows=$("#y41aOrgSelecGrid").jqGrid('getGridParam','records');
							$("#y41aOrgSelecGrid").rup_grid("addRowData",rows,data[k]);
							$("#y41aOrgSelecGrid").jqGrid('setSelection',rows);
							rowDestinatarios++;
						}
						
					}
				}
			    }
			
			
		});
		
		//cargaInicialGrid();
		PasarDestinatariosOrigenAEdicion();
		
});

//Detalle de organismos
function showDetalleOrganismo(id) {
	$("#y41aComunicacionOrgDetalleModal").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "650",
		height: "auto",
		url: "/y41aVistaWar/organismo/maintDetalleOrganismos?R01HNoPortal=true&codOrg=" + id, 
		title: $.rup.i18n.app.y41aTitlesModalesComunicacion.detalleOrganismo,
		type:$.rup.dialog.AJAX
	});
}	


$("#y41aOrgSelBtAceptarDestinatarios").click(function () {
	var rows=$("#y41aOrgSelecGrid").jqGrid('getGridParam','records');
	
	if (rows==0){
		$("#comunicacionOrgSelecModal_feedback").rup_feedback("option", "delay", 1500);
		$("#comunicacionOrgSelecModal_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		return false;
	}else{		
		//console.log("Start y41aOrgSelBtAceptarDestinatarios");
		PasarDestinatariosSeleccionados();
		//console.log("---- y41aOrgSelBtAceptarDestinatarios - Paso 2");
		CerrarModalComunicacionAlta();
		//console.log("Salir y41aOrgSelBtAceptarDestinatarios");
	}	
});	


$("#y41aOrgSelBtCerrar").click(function () {
	CerrarModalComunicacionAlta();
});

	
	function filtrarDuplicados(nuevaKey){
		
		//console.log("Nueva key: " + nuevaKey);
		var rows=$("#y41aOrgSelecGrid").jqGrid('getGridParam','records');
		var existe=false;
		for(var i=0; i<rows; i++) {
			var data=$("#y41aOrgSelecGrid").rup_grid("getRowData", i);
			
			var codOrganismoNuevo=nuevaKey.substring(nuevaKey.lastIndexOf("_")+1, nuevaKey.length);
			var codOrganismo=data.id.substring(data.id.lastIndexOf("_")+1, data.id.length);
			
			//console.log("D: " + data.id);
			if (codOrganismo == codOrganismoNuevo){
				existe=true;
				break;
			}	
		}	
		
		return existe;
	}
	
	
	function CerrarModalComunicacionAlta()
	{
		$("#y41aComunicacionOrgSelecModal").rup_dialog("close");
	}
	
	
	function PasarDestinatariosSeleccionados(){
		//console.log("Start PasarDestinatariosSeleccionados");
		var selRows= $("#y41aOrgSelecGrid").rup_grid("getGridParam","selarrrow");
		$("#y41aOrgSeleccionGrid").rup_grid("clearGridData");
		for(var i=0; i<selRows.length; i++) {
			var organismoId = $("#y41aOrgSelecGrid").rup_grid('getCol', $("#y41aOrgSelecGrid").jqGrid("getDataIDs")[selRows[i]], "id");
			var organismo = $("#y41aOrgSelecGrid").rup_grid('getCol', $("#y41aOrgSelecGrid").jqGrid("getDataIDs")[selRows[i]], "nombreOrg"); 
			var data={"id": organismoId,	"nombre":organismo};
			$("#y41aOrgSeleccionGrid").rup_grid("addRowData",i,data);
			//console.log("PasarDestinatariosSeleccionados: key: " + data.id);
			//console.log("PasarDestinatariosSeleccionados: nombre: " + data.nombre);
			
		}
		
	}
	
	function formateadorLink(cellvalue, options, rowObject) {
	  var codOrg=id;
		var id=rowObject.id;
		if (id.lastIndexOf("E_")>-1){
			codOrg=id.substring(id.lastIndexOf("E_")+2);
		}
		
	    return "<a href=\"javascript:showDetalleOrganismo('" + codOrg + "');\">" + cellvalue + "</a>";
	}
	
	//Recoge valores desde alta
	function PasarDestinatariosOrigenAEdicion(){
		var rows= jQuery("#y41aOrgSeleccionGrid").getGridParam("records");
		$("#y41aOrgSelecGrid").rup_grid("clearGridData");
		for(var i=0; i<rows; i++) {
			var fila = $("#y41aOrgSeleccionGrid").rup_grid("getRowData", i);
			if (fila!=undefined){
				var organismoId = fila.id;
				var organismo = fila.nombre; 
				var data={"id": organismoId,	"nombre":organismo, "nombreOrg": organismo};
				$("#y41aOrgSelecGrid").rup_grid("addRowData",i,data);
				$("#y41aOrgSelecGrid").jqGrid('setSelection',i);
				//rowDestinatarios++;
				
				//console.log("PasarDestinatariosOrigenAEdicion: key: " + data.id);
				//console.log("PasarDestinatariosOrigenAEdicion: nombre: " + data.nombre);
				//console.log("PasarDestinatariosOrigenAEdicion: nombreOrg: " + data.nombreOrg);
			}	
		}
		
	}
