jQuery(function($) {
	
	var row; //variable para recoger los datos de la fila
	// posicionamos el menu
	$("#accordion").accordion('activate', 3 );
	
	$("#censotramites_feedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	$("#y41aCensoTramitesComboTramite").rup_combo({
		blank : "",
		source : "/y41aVistaWar/plantillatramite/getAllTramite?R01HNoPortal=true",
		sourceParam : {
			label : "trnombre"+recuperarLetraIdioma(),
			value : "trcodigo" 
		},
		width:"450"
	});
	
	
	
	var y41aVarCensoTramitesGridWidthTabla = $("#capaPadre").width()-10;
	
	$("#y41aCensoTramitesGrid").rup_grid({
		hasMaint: false,
		width: y41aVarCensoTramitesGridWidthTabla,
		url : "/y41aVistaWar/plantillatramite/getAllTramite?R01HNoPortal=true",
		loadOnStartUp: true,
		pagerName: "pagerCensoTramites",
		page: 5,
		rowNum: "20",
		sortorder: "asc",
		hoverrows: true,
		sortname: "trnombre" + recuperarLetraIdioma(),
		//fluidBaseLayer:"capaPadre",
		colNames: [
		            '',
		            '',
					$.rup.i18n.app.y41aVistaWar_tramites.tramite,
					$.rup.i18n.app.y41aVistaWar_tramites.fechaUltimaModificacion,
					$.rup.i18n.app.y41aVistaWar_tramites.plantilla,
					'',
				],
				colModel: [
					{ 
						name: "ptcodigo",
						label: "ptcodigo",
						index: "ptcodigo",
						editable:false,
						width: "",
						hidden: true,
						edittype: "hidden"
					},
					{ 
						name: "trcodigo",
						label: "trcodigo",
						index: "trcodigo",
						editable:false,
						width: "",
						hidden: true,
						edittype: "hidden"
					},
					{ 
						name: "trnombre" + recuperarLetraIdioma(),
						label: "trnombre" + recuperarLetraIdioma(),
						index: "trnombre" + recuperarLetraIdioma(),
						editable:false,
						width: funcPercentage(30,y41aVarCensoTramitesGridWidthTabla),
						edittype: "text"
					},
					{ 
						name: "ptultmodificacion",
						label: "ptultmodificacion",
						index: "ptultmodificacion",
						editable:false,
						width: funcPercentage(20,y41aVarCensoTramitesGridWidthTabla),
						edittype: "text",
						align:'center'
					},
					{ 
						name: "ptnombre" ,
						label: "ptnombre" ,
						index: "ptnombre" ,
						editable:false,
						width: funcPercentage(35,y41aVarCensoTramitesGridWidthTabla),
						edittype: "text",
						formatter: formateadorLink
					},		
					{ 
						name: "ptcontenttypefile",
						label: "ptcontenttypefile",
						index: "ptcontenttypefile",
						editable:false,
						hidden: true,
						edittype: "hidden"
					}
				],
				
				
				onSelectRow : function(id, selectR) {
					var datosFila = $("#y41aCensoTramitesGrid").rup_grid("getRowData", id);
					var codigo = datosFila.trcodigo;
					
					$("#y41aCensoTramitesComboTramite").rup_combo("select", codigo);
				}
	
	});
		
	recargarUpload();
	recargarAjaxForm();
	
});


$("#y41aCensoTramitesBtAniadir").click(function (){
	showModalCensoTramites();			
});
		
function showModalCensoTramites(){
	$("#y41aCensoTramitesModal").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "500",
		height: "auto",
		title: $.rup.i18n.app.y41aVistaWar_tramites.altaTramite,
		url: "/y41aVistaWar/tramite/altaTramite?R01HNoPortal=true", 
		type:$.rup.dialog.AJAX
	});	
}
    
function recargarUpload(){
	// Upload integrado en formulario
	$('#fileupload_file_form_plantilla').rup_upload({
		fileInput: $("#y41aCensoTramitesPlantilla"),
		maxFileSize: 5000000,
		singleFileUploads:true,
		submitInForm:true
	});	
}

function recargarAjaxForm(){
	// Se utiliza jquery.form para realizar el submit de los formularios por AJAX
	$("#y41aCensoTramitesForm").ajaxForm(function(){
		documentosTramitesLimpiarDocumento();
		reloadTablaTramite();
		$("#censotramites_feedback").rup_feedback("option", "delay", 800);
		$("#censotramites_feedback").rup_feedback("set",$.rup.i18n.app.comun.tramiteEnviado,"ok");
	}); 
}
	
	$("#y41aCensoTramitesBtGraba").click(function () {
		if (validarCampos()){
			if ($("#y41aCensoTramitesPlantilla").val()==""){
				$.rup_messages("msgConfirm",{
					   title:$.rup.i18n.app.msg.confirmacion,
					   message: $.rup.i18n.app.msg.confiramacionPlantillaeliminar,
					   OKFunction : function () {
						   var form_url = "/y41aVistaWar/plantillatramite/subidaTramite?R01HNoPortal=true";
						   $("#y41aCensoTramitesForm").attr("action", form_url);
						   $("#y41aCensoTramitesForm").submit();
						}
				});
			}else{
			
				if($("#y41aCensoTramitesBtAniadir").size() > 0)
				{
					funcGrabarTramite();
				}
				else
				{
					var form_url = "/y41aVistaWar/plantillatramite/subidaTramite?R01HNoPortal=true";
					$("#y41aCensoTramitesForm").attr("action", form_url);
					$("#y41aCensoTramitesForm").submit();
				}
			}
		}
	});
	
	function funcGrabarTramite()
	{
		var form_url = "";
		
		$("#y41aMensajeSiNo").rup_dialog({
			modal: true,
			autoOpen: true,
			width: "500",
			height: "auto",
			resizable: false, 
			message: $.rup.i18n.app.msg.grabarPlantillasOMIC,
			type:$.rup.dialog.TEXT,
			title: $.rup.i18n.app.msg.confirmacion,
			  buttons: [
			            {text: $.rup.i18n.base.rup_global.aceptar,
				  		 click: function(){
				  			 	$("#y41aMensajeSiNo").dialog("close");
			                  	form_url = "/y41aVistaWar/plantillatramite/subidaTramiteAllPlantilla?R01HNoPortal=true";
			                  	$("#y41aCensoTramitesForm").attr("action", form_url);
			                  	$("#y41aCensoTramitesForm").submit();
			              } 
			  			},
			            {text: $.rup.i18n.base.rup_global.cancelar,
					     btnType:$.rup.dialog.LINK ,
				  		 click: function(){
				  			 	$("#y41aMensajeSiNo").dialog("close");
				  			 	form_url = "/y41aVistaWar/plantillatramite/subidaTramite?R01HNoPortal=true";
								$("#y41aCensoTramitesForm").attr("action", form_url);
								$("#y41aCensoTramitesForm").submit();
				  		 		}
				  		}]
		});			
	}
	
	function validarCampos(){
		
		var txtFeedback = "";
		
		var bCampo2 = false;
	
		if ($("#y41aCensoTramitesComboTramite").rup_combo("getRupValue") != "" && $("#y41aCensoTramitesComboTramite").rup_combo("getRupValue") != null)
		{
			bCampo2 = true;
		}else{
			txtFeedback += "<li>" + $.rup.i18n.app.y41aVistaWar_tramites.seleccioneTramite + "</li>\n";
			bCampo2 = false;
		}
		
		
		if (bCampo2){
			return true;
		}else{
			$("#censotramites_feedback").rup_feedback("option", "delay",null);
			$("#censotramites_feedback").rup_feedback("set","<ul>" + txtFeedback + "</ul>", "error");
			return false;
		}
	}
	
	function formateadorLink(cellvalue, options, rowObject) {
		
		if(cellvalue != null)
		{
			return "<a href=/y41aVistaWar/plantillatramite/tramitefile/"+ rowObject.ptcodigo +"?R01HNoPortal=true>" + cellvalue + "</a>";
		}
		else{
			return "";
		}
	}
	
	//limpiar tabla
	function reloadTablaTramite()
	{
		
		$("#y41aCensoTramitesGrid").rup_grid("clearGridData");
		$("#y41aCensoTramitesGrid").rup_grid("setGridParam", {url : "/y41aVistaWar/plantillatramite/getAllTramite?R01HNoPortal=true"});
		$("#y41aCensoTramitesGrid").rup_grid("reloadGrid");
		
		$("#y41aCensoTramitesComboTramite-button").remove();
		$("#y41aCensoTramitesComboTramite-menu").remove();
		$('<select id="y41aCensoTramitesComboTramite" name="trcodigo"></select>').replaceAll("#y41aCensoTramitesComboTramite");
		
		$("#y41aCensoTramitesComboTramite").rup_combo({
			blank : "",
			source : "/y41aVistaWar/plantillatramite/getAllTramite?R01HNoPortal=true",
			sourceParam : {
				label : "trnombre",
				value : "trcodigo" 
			}	
		});
	}
	
	/* **********************************************************
	 * Funcion que limpia/inicializa los valores del formulario *
	 * **********************************************************
	 */
	function documentosTramitesLimpiarDocumento(){
		
		$("#y41aCensoTramitesPlantilla").val("");
		$("#y41aCensoTramitesFileupload").html('<table class="files"></table>');
		recargarUpload();
		$("#y41aCensoTramitesComboTramite").rup_combo("select", "");
		
	}
	
	$("#y41aCensoTramitesBtEliminar").click(function (){
		
		var selectedRow = $("#y41aCensoTramitesGrid").rup_grid("getSelectedRows")[0];
		row = $("#y41aCensoTramitesGrid").rup_grid("getRowData", selectedRow);
		
		if(row.trcodigo == "" || row.trcodigo == null)
		{
			$("#censotramites_feedback").rup_feedback("option", "delay", 800);
			$("#censotramites_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
		else
		{
		   $.rup_messages("msgConfirm",{
			   title:$.rup.i18n.app.msg.confirmacion,
			   message: $.rup.i18n.app.msg.confiramacioneliminar,
			   OKFunction : function () {
				   modificarTramite();
				}
		   });
			
		}	
	});
	
	function eliminarDocumento()
	{
		var jqxhr = $.ajax({
			type : 'DELETE',
			url : "../plantillatramite/removeTramite/" + row.ptcodigo + "?R01HNoPortal=true",
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){		
					case 406:
						$("#censotramites_feedback").rup_feedback("option", "delay",null);
						$("#censotramites_feedback").rup_feedback("set",jqXHR.responseText, "error");
						break;
					case 409:
						controlY41aUDAException(jqXHR, "censotramites_feedback");
						break;
					default:
						$("#censotramites_feedback").rup_feedback("option", "delay",null);
						$("#censotramites_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
						break;
				}
			},
			success : function(data) {

						$("#censotramites_feedback").rup_feedback("option", "delay",800);
						$("#censotramites_feedback").rup_feedback("set", "ok", "ok");
						reloadTablaTramite();
			}
		});
	}
	
	function modificarTramite(){
		
		
		var jqxhr = $.ajax({
			type : 'PUT',
			url : "/y41aVistaWar/tramite/?trcodigo=" + row.trcodigo + "&R01HNoPortal=true",
			dataType : "json",
			contentType : 'application/json',
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){		
					case 406:
						$("#censotramites_feedback").rup_feedback("option", "delay",null);
						$("#censotramites_feedback").rup_feedback("set",jqXHR.responseText, "error");
						break;
					//UDAEXCEPTION
					case 409:
						controlY41aUDAException(jqXHR, "censotramites_feedback");
						break;
					default:
						$("#censotramites_feedback").rup_feedback("option", "delay",null);
						$("#censotramites_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
						break;
				}
			},
			success : function(data) {
		
						$("#censotramites_feedback").rup_feedback("option", "delay",800);
						$("#censotramites_feedback").rup_feedback("set", "ok", "ok");
						reloadTablaTramite();
			}
		});
	}
	

	
	
	
	$("#y41aCensoTramitesBtCancelar").click(function (){
		documentosTramitesLimpiarDocumento();
	});
	