jQuery(function($){
	
	/* ***************************
	 * Inicializar feedback
	 * ***************************
	 */
	$("#y41aOoee_feedback").rup_feedback({
		gotoTop : false,
		block : false,
		closeLink : true
	});
	
	/* ********************
	 * Combos provincia, municipio, localidad NORA
	 * ********************
	 */
	$("#y41aOoeeComboProvincia_search").rup_combo({
		source : "/y41aVistaWar/nora/provincias",
		blank : "",
		sourceParam : {	label : "dsO", value : "id"	}
	});	
	$("#y41aOoeeComboMunicipio_search").rup_combo({
		parent: [ "y41aOoeeComboProvincia_search" ],
		source : "/y41aVistaWar/nora/municipios?R01HNoPortal=true",
		blank : "",
		sourceParam : {	label : "dsO",	value : "id"}
	});
	$("#y41aOoeeComboLocalidad_search").rup_combo({
		parent: [ "y41aOoeeComboProvincia_search", "y41aOoeeComboMunicipio_search" ],
		source : "/y41aVistaWar/nora/localidades?R01HNoPortal=true",
		blank : "",
		sourceParam : {	label : "dsO", value : "id"	}
	});
	
	$("#y41aOoeeBtSector").click(function (){	
		showModalSectorOOEE();
	});
	$("#y41aOoeeSectorBorrar").click(function(){
		$("#y41aOoeeSecodigo_search").val("");
		$("#y41aOoeeSenombre_search").val("");
	});
	$("#y41aOoeeSecodigo_search").blur( function () {
        var seCodigo = $("#y41aOoeeSecodigo_search").val();
        buscarSectorOoee(seCodigo);
	});	
	$("#y41aOoeeBtFiltrar").click(function (){	
		$('#y41aOoeeGrid').jqGrid('GridUnload');
		recargarOoeeGrid();

	});
	$("#y41aOoeeBtLimpiar").click(function (){	
		limpiarBusquedaOoee();
	});
	
	var y41aOoeeTablaWidth=875;
	
	if (modoBusquedaOoee == "POPUP_SELECCION"){		
		$("#y41aOoeeBtSeleccionar").show();
		$("#y41aOoeeBtCancelar").show();
		$("#y41aOoeeBtSeleccionar").click(function () {
			seleccionarOoee();
		});
		$("#y41aOoeeBtCancelar").click(function () {
			if(y41aVarPadreModalOoee == "y41aEstablecimiento"){
				$("#y41aEstablecimientoSeleccionOoee").rup_dialog("close");
			}
		});		
	}
	
	//Tabla
	var query = $("#y41aOoeeBusquedaForm").serialize();
	y41aVarCensoOoeeTabla=false;
	cargarTablaOoee(y41aOoeeTablaWidth, query);

	$(document).ready(function(){
		//asignamos el valor id del campo que queremos que se mayúscula
		aMayusculas("input#y41aOoeeSecodigo_search"); 
	});

});


//Abrimos la modal para seleccionar un sector
function showModalSectorOOEE(params){
	y41aVarPadreModalSector = "y41aOoeeBusqueda";
	$("#y41aEstablecimientosModalSector").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "auto",
		height: "auto",
		title: $.rup.i18n.app.y41aVistaWar_sectores.busquedaSectores,
		url: "/y41aVistaWar/establecimiento/sectores?R01HNoPortal=true",
		type:$.rup.dialog.AJAX
	});		
}

function y41aFunctionModalSectoresAPadreOoeeBusqueda(codigo,descripcion){
	$("#y41aOoeeSecodigo_search").val(codigo);
	$("#y41aOoeeSenombre_search").val(descripcion);
	$("#y41aEstablecimientosModalSector").rup_dialog("close");
}
function buscarSectorOoee(seCodigo){
    $.ajax({
        type : "GET",
        url : "/y41aVistaWar/sector/SectorSeleccionable/" + seCodigo + "?R01HNoPortal=true",
        dataType : "json",
        error : function(jqXHR, textStatus, errorThrown) {
        	 $("#y41aOoeeSenombre_search").val("");
        },
        success : function(data, textStatus, jqXHR) {    
            var nombre = "";
            if ("es"==$.rup_utils.get("language")){
                nombre = data.senombre;
            }else if("eu"==$.rup_utils.get("language")){
                nombre = data.senombree;
            }
            $("#y41aOoeeSecodigo_search").val(data.secodigo);
            $("#y41aOoeeSenombre_search").val(nombre);
        }
    });
}


function recargarOoeeGrid(){
	var query = $("#y41aOoeeBusquedaForm").serialize();
	var y41aOoeeTablaWidth=$("#RUP_GRID_Ooee").width()-2;;
	cargarTablaOoee(y41aOoeeTablaWidth,query);
}

function limpiarBusquedaOoee(){
	//reseteo campos del filtro
	$("#y41aOoeeNombre_search").val("");
	$("#y41aOoeeCodigo_search").val("");
	$("#y41aOoeeTesi_search").val("");
	$("#y41aOoeeSecodigo_search").val("");
	$("#y41aOoeeSenombre_search").val("");	
	$("#y41aOoeeComboProvincia_search").rup_combo("select", "");	
	$("#y41aOoeeThActAraba_search").attr("checked", false);
	$("#y41aOoeeThActBizkaia_search").attr("checked", false);
	$("#y41aOoeeThActGipuzkoa_search").attr("checked", false);

	//vaciamos la tabla
	$("#y41aOoeeGrid").rup_grid("clearGridData");
}

function cargarTablaOoee(y41aVarOoeeTablaWidth,query){
	$("#GRID_Ooee").jqGrid("GridUnload");
	$("#GRID_Ooee").rup_grid({		
		hasMaint: false,
		url : "/y41aVistaWar/ooee/busqueda?R01HNoPortal=true&"+query,
		loadOnStartUp: y41aVarCensoOoeeTabla,
		pagerName: "pagerOoee",
		rowNum: "10",
		sortorder: "asc",
		sortname: "oecodigo",
		width: y41aVarOoeeTablaWidth,
		fluidBaseLayer:"RUP_GRID_Ooee",	
		colNames: [
			$.rup.i18n.app.y41aVistaWar_arbitraje.censo.codigo,
			$.rup.i18n.app.y41aVistaWar_arbitraje.censo.nombre,
			$.rup.i18n.app.y41aVistaWar_arbitraje.censo.siglas,
			$.rup.i18n.app.y41aVistaWar_arbitraje.censo.municipio,
			$.rup.i18n.app.y41aVistaWar_arbitraje.censo.adherida+' / '+$.rup.i18n.app.y41aVistaWar_arbitraje.censo.adheridaNO,
			$.rup.i18n.app.y41aVistaWar_arbitraje.censo.fechabaja
		],
		colModel: [
			{ name: "oecodigo",
				label: "oecodigo",
				index: "oecodigo",
				width: funcPercentage(7,y41aVarOoeeTablaWidth),				
				editable: false,
				edittype: "text"
			},
			{ name: "organismo.nombre"+recuperarLetraIdiomaOrganismos(),
				label: "organismo.nombre"+recuperarLetraIdiomaOrganismos(),
				index: "organismo.nombre"+recuperarLetraIdiomaOrganismos(),
				width: funcPercentage(35,y41aVarOoeeTablaWidth),	
				editable: false,
				edittype: "text"
			},
			{ name: "oetesi",
				label: "oetesi",
				index: "oetesi",
				width: funcPercentage(10,y41aVarOoeeTablaWidth),	
				editable: true,
				edittype: "text"
			},
			{ name: "organismo.nombreMunicipio",
				label: "organismo.nombreMunicipio",
				index: "organismo.nombreMunicipio",
				width: funcPercentage(20,y41aVarOoeeTablaWidth),	
				editable: false,
				edittype: "text"
			},
			{ name: "oeadherido",
				label: "oeadherido",
				index: "oeadherido",
				width: funcPercentage(15,y41aVarOoeeTablaWidth),
				editable: false,
				align: "center",
				formatter:"select",
				editoptions:{
					defaultValue: "N",
					value: {"N":"",
						"A":'<img src="'+$.rup.APP_STATICS+'/images/y41a-adhesion.jpg" title="'+$.rup.i18n.app.y41aVistaWar_arbitraje.censo.adherida+'" width="20" height="20">',
						"B":'<img src="'+$.rup.APP_STATICS+'/images/y41a-adhesionNO.jpg" title="'+$.rup.i18n.app.y41aVistaWar_arbitraje.censo.adheridaBaja+'" width="20" height="20">'}
				}
			},
			{ name: "oefeadfin",
				label: "oefeadfin",
				index: "oefeadfin",
				width: funcPercentage(15,y41aVarOoeeTablaWidth),
				editable: true,
				align: "center",
				edittype: "text"
			}
        ]
		
	});
	y41aVarCensoOoeeTabla = true;
}



function seleccionarOoee(){
	
	var filaSeleccionada = $("#GRID_Ooee").rup_grid("getSelectedRows")[0];
	fila = $("#GRID_Ooee").rup_grid("getRowData", filaSeleccionada);

	if(fila.oecodigo == "" || fila.oecodigo == null){
		$("#y41aOoee_feedback").rup_feedback("option", "delay", 800);
		$("#y41aOoee_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
    }else{			
		if(y41aVarPadreModalOoee == "y41aEstablecimiento"){
			y41aFunctionModalOoeeAPadreEstablecimiento(fila.oecodigo,fila["organismo.nombre"+recuperarLetraIdiomaOrganismos()]);		
		}
    }
}
