jQuery(function($) {
	
	//variable para recoger los datos de la fila
	var row;

	
	
	// posicionamos el menu
	$("#accordion").accordion('activate', 3 );
	
	$("#censomonitor_feedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	$('#y41aCensoMonitorGrid').jqGrid('GridUnload');
	funcPintarCensoMonitorGrid();
	busquedaCensoMonitor();
    		
});
//FIN INICIALIZAR
	
	//Busquemos un monitor
	$("#y41aCensoMonitorBtBuscar").click(function () {
		$('#y41aCensoMonitorGrid').jqGrid('GridUnload');
		funcPintarCensoMonitorGrid();
		busquedaCensoMonitor();
	});
	
	
	//boton alta
	$("#y41aCensoMonitorBtAlta").click(function () 
	{
		$("#y41aCensoMonitorMocodigoModifciar").val("");
			showModalAlta();
	});
	
	//Abrimos la modal para dar de alta un monitor
	function showModalAlta(params){
		$("#y41aCensoMonitorAltaDiv").rup_dialog({
			modal: true,
			autoOpen: true,
			width: "500",
			height: "auto",
			title: $.rup.i18n.app.y41aVistaWar_censomonitor.altaMonitor,
			url: "/y41aVistaWar/censomonitor/alta?R01HNoPortal=true",  
			type:$.rup.dialog.AJAX
		});		
	}

	//Editamos un monitor
	$("#y41aCensoMonitorBtEditar").click(function () {
		
		var selectedRow = $("#y41aCensoMonitorGrid").rup_grid("getSelectedRows")[0];
		row = $("#y41aCensoMonitorGrid").rup_grid("getRowData", selectedRow);
	
		if(row.mocodigo == "" || row.mocodigo == null)
			{
				$("#censomonitor_feedback").rup_feedback("option", "delay", 800);
				$("#censomonitor_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
			}
		else
			{
	
				$("#y41aCensoMonitorMocodigoModifciar").val(row.mocodigo);
				$("#y41aCensoMonitorAltaDiv").rup_dialog({
					modal: true,
					autoOpen: true,
					width: "500",
					height: "auto",
					title: $.rup.i18n.app.y41aVistaWar_censomonitor.detalleMonitor,
					url: "/y41aVistaWar/censomonitor/alta?R01HNoPortal=true",  
					type:$.rup.dialog.AJAX
				});		
			}
		
	});
	
	function formateadorLink(cellvalue, el, opts){  
		return "<a href='#' onClick='modalDetalle("+ el.rowId +");'>" + cellvalue + "</a>";
	}
	
	//************************************************************
	//Modal detalle
	//************************************************************
	function modalDetalle(filaSeleccionada){
		row = $("#y41aCensoMonitorGrid").rup_grid("getRowData", filaSeleccionada);
		id = row.mocodigo;
		$("#y41aCensoMonitorMocodigoModifciar").val(id);
		$("#y41aCensoMonitorAltaDiv").rup_dialog({
			modal: true,
			autoOpen: true,
			width: "500",
			height: "auto",
			title: $.rup.i18n.app.y41aVistaWar_censomonitor.detalleMonitor,
			url: "/y41aVistaWar/censomonitor/alta?R01HNoPortal=true",  
			type:$.rup.dialog.AJAX
		});
		
	}
	
	//Limpiamos los campos codigo y nombre
	$("#y41aCensoMonitorBtLimpiar").click(function () {
			$("#y41aCensoMonitor_mocodigo").val("");
			$("#y41aCensoMonitor_monombre").val("");
			//limpiamos la tabla de resultados
			$("#y41aCensoMonitorGrid").rup_grid("clearGridData");
	});
	
	function busquedaCensoMonitor()
	{	
		var query = $("#busquedaCensoMonitorForm").serialize();
		$("#y41aCensoMonitorGrid").rup_grid("setGridParam", {url : "/y41aVistaWar/censomonitor/filter?" + query + "&R01HNoPortal=true"});
		$("#y41aCensoMonitorGrid").rup_grid("reloadGrid");
	}
		
	$("#y41aCensoMonitorBtEliminar").click(function () {
		
		var selectedRow = $("#y41aCensoMonitorGrid").rup_grid("getSelectedRows")[0];
		row = $("#y41aCensoMonitorGrid").rup_grid("getRowData", selectedRow);
		
		if(row.mocodigo == "" || row.mocodigo == null)
		{
			$("#censomonitor_feedback").rup_feedback("option", "delay", 800);
			$("#censomonitor_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
	else
		{
		   $.rup_messages("msgConfirm",{
			   title:$.rup.i18n.app.msg.confirmacion,
			   message: $.rup.i18n.app.msg.confiramacioneliminar,
			   OKFunction : function () {
				   eliminarMonitor();
				}
		   });
			
		}
		
	});
	
	function eliminarMonitor()
	{
		var jqxhr = $.ajax({
			type : 'DELETE',
			url : "/y41aVistaWar/censomonitor/" + row.mocodigo  + "?R01HNoPortal=true",
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){		
					case 406:
						$("#censomonitor_feedback").rup_feedback("option", "delay",null);
						$("#censomonitor_feedback").rup_feedback("set",jqXHR.responseText, "error");
						break;
					case 409:
						controlY41aUDAException(jqXHR, "censomonitor_feedback");
						break;	
					default:
						$("#censomonitor_feedback").rup_feedback("option", "delay",null);
						$("#censomonitor_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
						break;
				}
			},
			success : function(data) {

						$("#censomonitor_feedback").rup_feedback("option", "delay",800);
						$("#censomonitor_feedback").rup_feedback("set", "ok", "ok");
						busquedaCensoMonitor();
			}
		});
	}

	$("#y41aCensoMonitorBtOrganismos").click(function () {
		y41aVarOrganismosTraslado ="y41aCensoMonitor";
		$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalleOrganismos").rup_dialog("destroy");
		$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalleOrganismos").rup_dialog({
			modal: true,
			autoOpen: true,
			width: "870",
			height: "auto",
			position: "top",
			title:$.rup.i18n.app.y41aTitlesModalesTraslado.listaOrganismos,
			url: "/y41aVistaWar/organismo/maintModal?R01HNoPortal=true",    
			type:$.rup.dialog.AJAX,
			close: function(event,ui){
				$('#y41aOrganismosTrasladoTabla').jqGrid('GridUnload');
				$('#y41aCensoMonitorGrid').jqGrid('GridUnload');
				funcPintarCensoMonitorGrid();
			}
		});
		
	});
	
	function funcPintarCensoMonitorGrid()
	{
		var query = $("#busquedaCensoMonitorForm").serialize();
		
		$("#y41aCensoMonitorGrid").rup_grid({
		hasMaint: false,
		width: $("#contentMV").width(),
		url : "/y41aVistaWar/censomonitor/filter?" + query + "&R01HNoPortal=true",
		loadOnStartUp: false,
		pagerName: "pager",
		page: 5,
		rowNum: "10",
		sortorder: "asc",
		hoverrows: true,
		sortname: "mocodigo",
		colNames: [
		    "",
		  //$.rup.i18n.app.y41aVistaWar_censomonitor.codigo,
		    "",
			$.rup.i18n.app.y41aVistaWar_censomonitor.nombre,
			$.rup.i18n.app.y41aVistaWar_censomonitor.email,
			$.rup.i18n.app.y41aVistaWar_censomonitor.usuario,
			$.rup.i18n.app.y41aVistaWar_censomonitor.password,
			$.rup.i18n.app.y41aVistaWar_censomonitor.fechabaja
		],
		colModel: [
			{ name: "moadmin",
				label: "moadmin",
				index: "moadmin",
				editoptions: {
					defaultValue:$.rup.i18n.app.y41aVistaWar_censomonitor.administradorsi,
					value:{"N":"",
					"S":'<img src="'+$.rup.APP_STATICS+'/images/y41a-usuario.png"  class="y41a-usuario">'}
					},
					formatter:"select",
					width: funcPercentage(3,$("#contentMV").width()),
					align:'center'
			},
			{ name: "mocodigo",
				label: "mocodigo",
				index: "mocodigo",
				width: funcPercentage(10,$("#contentMV").width()),
				editable: true,
				hidden:true,
				edittype: "text"
			},
			{ name: "monombre",
				label: "monombre",
				index: "monombre",
				width: funcPercentage(20,$("#contentMV").width()),
				editable: true,
				edittype: "text",
				formatter: formateadorLink
			},
			{ name: "mocoem",
				label: "mocoem",
				index: "mocoem",
				width: funcPercentage(20,$("#contentMV").width()),
				editable: true,
				edittype: "text"
			},
			{ name: "mousu",
				label: "mousu",
				index: "mousu",
				width: funcPercentage(15,$("#contentMV").width()),
				editable: true,
				edittype: "text"
			},
			{ name: "moclave",
				label: "moclave",
				index: "moclave",
				width: funcPercentage(15,$("#contentMV").width()),
				editable: true,
				edittype: "password"
			},
			{ name: "mofecbaja",
				label: "mofecbaja",
				index: "mofecbaja",
				width: funcPercentage(10,$("#contentMV").width()),
				editable: true,
				edittype: "text",
				align:'center'
			}
	    ]
		});
	}
		
	/* ****************************************************************************************************
	 * Funcion que recoge la informacio de la modal de Organismos y la pasa a la pantalla llamante
	 * ****************************************************************************************************
	 */	
	function modalOrganismosAPadre(codigo, descripcion) {
		$("#y41acensomonitorOrganismoCodOrg").val(codigo);
		$("#y41aCensoMonitorNombre").val(descripcion);
		$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalleOrganismos").html("");
		$("#y41aTabsBusquedaResultadoSolicitudesDivModalTramitacionDetalleOrganismos").rup_dialog("close");
	}
	
	/* *******************************************************************************************************
	 * Buscar Organismo
	 * *******************************************************************************************************/
		
	$("#y41acensomonitorOrganismoCodOrg").blur(
			function () {
				var orgId = $("#y41acensomonitorOrganismoCodOrg").val();
				if (orgId != ""){
					buscarOrganismoDestino(orgId);
				}else{
					$("#y41aCensoMonitorNombre").val("");
				}
			}
		);
	/*
	 * Recupera la informacion del Organismo asociada al id 
	 * @param busquedaOrganismoId Identificador del Organismo del que se quiere obtener su descripcion
	 * 
	 */
	function buscarOrganismoDestino(busquedaOrganismoId){
		$.ajax({
			type : "GET",
			url : "/y41aVistaWar/organismo/knet/" + busquedaOrganismoId + "?R01HNoPortal=true",
			dataType : "json",
			error : function(jqXHR, textStatus, errorThrown) {
				$("#y41aCensoMonitorNombre").val("");
			},
			success : function(data, textStatus, jqXHR) {
				var nombre = "";
				if ("es"==$.rup_utils.get("language")){
					nombre = data.nombreEs;
				}else if("eu"==$.rup_utils.get("language")){
					nombre = data.nombreEu;
				}
				if(nombre != "")
				{
					$("#y41aCensoMonitorNombre").val(nombre);
				}
				else
				{
					$("#y41aCensoMonitorNombre").val("");
				}
				
			}		
		});
	}