jQuery(function($) {
	
	var row; //variable para recoger los datos de la fila
	// posicionamos el menu
	$("#accordion").accordion('activate', 3 );
	
	$("#censoinspeccion_feedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	$("#y41aCensoInspeccionComboInspeccion").rup_combo({
		blank : "",
		source : "/y41aVistaWar/plantillains/getAllInspeccion?R01HNoPortal=true",
		sourceParam : {
			label : "insnombre"+recuperarLetraIdioma(),
			value : "inscodcarta"  
		},
		width:"450"
		
	});
	
	var y41aVarCensoInspeccionGridWidthTabla = $("#capaPadre").width()-10;
	
	$("#y41aCensoInspeccionGrid").rup_grid({
		hasMaint: false,
		width: y41aVarCensoInspeccionGridWidthTabla,
		url : "/y41aVistaWar/plantillains/getAllInspeccion?R01HNoPortal=true",
		loadOnStartUp: true,
		pagerName: "pagerCensoInspeccion",
		page: 5,
		rowNum: "20",
		sortorder: "asc",
		hoverrows: true,
		sortname: "insnombre" + recuperarLetraIdioma(),
		colNames: [
		            '',
		            '',
					$.rup.i18n.app.y41aVistaWar_inspecciones.inspeccion,
					$.rup.i18n.app.y41aVistaWar_inspecciones.fechaUltimaModificacion,
					$.rup.i18n.app.y41aVistaWar_inspecciones.plantilla,
					'',
				],
				colModel: [
					{ 
						name: "plinscodigo",
						label: "plinscodigo",
						index: "plinscodigo",
						editable:false,
						width: "",
						hidden: true,
						edittype: "hidden"
					},
					{ 
						name: "inscodcarta",
						label: "inscodcarta",
						index: "inscodcarta",
						editable:false,
						hidden: true,
						edittype: "hidden"
					},
					{ 
						name: "insnombre" + recuperarLetraIdioma(),
						label: "insnombre" + recuperarLetraIdioma(),
						index: "insnombre" + recuperarLetraIdioma(),
						editable:false,
						width: funcPercentage(30,y41aVarCensoInspeccionGridWidthTabla),
						fixed:true,
						edittype: "text"
					},
					{ 
						name: "plinsultmodificacion",
						label: "plinsultmodificacion",
						index: "plinsultmodificacion",
						editable:false,
						width: funcPercentage(20,y41aVarCensoInspeccionGridWidthTabla),
						fixed:true,
						edittype: "text",
						align:'center'
					},
					{ 
						name: "plinsnombre" ,
						label: "plinsnombre" ,
						index: "plinsnombre" ,
						editable:false,
						width: funcPercentage(35,y41aVarCensoInspeccionGridWidthTabla),
						edittype: "text",
						formatter: formateadorLink
					},		
					{ 
						name: "plinscontenttypefile",
						label: "plinscontenttypefile",
						index: "plinscontenttypefile",
						editable:false,
						hidden: true,
						edittype: "hidden"
					}
				],
				
				
				onSelectRow : function(id, selectR) {
					var datosFila = $("#y41aCensoInspeccionGrid").rup_grid("getRowData", id);
					var codigo = datosFila.inscodcarta;
					
					$("#y41aCensoInspeccionComboInspeccion").rup_combo("select", codigo);
				}
	
	});
		
	recargarUpload();
	recargarAjaxForm();
	
});


$("#y41aCensoInspeccionBtAniadir").click(function (){
	showModalCensoInspeccion();			
});
		
function showModalCensoInspeccion(){
	$("#y41aCensoInspeccionModal").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "500",
		height: "auto",
		title: $.rup.i18n.app.y41aVistaWar_inspecciones.altaInspecciones,
		url: "/y41aVistaWar/inspecciones/altaInspeccion?R01HNoPortal=true", 
		type:$.rup.dialog.AJAX
	});	
}
    
function recargarUpload(){
	// Upload integrado en formulario
	$('#fileupload_file_form_plantilla').rup_upload({
		fileInput: $("#y41aCensoInspeccionPlantilla"),
		maxFileSize: 5000000,
		singleFileUploads:true,
		submitInForm:true
	});	
}

function recargarAjaxForm(){
	// Se utiliza jquery.form para realizar el submit de los formularios por AJAX
	
	$("#y41aCensoInspeccionForm").ajaxForm(function(){
		documentosInspeccionLimpiarDocumento();
		reloadTablaInspeccion();
		$("#censoinspeccion_feedback").rup_feedback("option", "delay", 800);
		$("#censoinspeccion_feedback").rup_feedback("set",$.rup.i18n.app.comun.tramiteEnviado,"ok");
	}); 
}
	
	$("#y41aCensoInspeccionBtGraba").click(function () {
		if (validarCampos()){
			if ($("#y41aCensoInspeccionPlantilla").val()==""){
				$.rup_messages("msgConfirm",{
					   title:$.rup.i18n.app.msg.confirmacion,
					   message: $.rup.i18n.app.msg.confiramacionPlantillaeliminar,
					   OKFunction : function () {
						   var form_url = "/y41aVistaWar/plantillains/subidaInspeccion?R01HNoPortal=true";
		                   $("#y41aCensoInspeccionForm").attr("action", form_url);
						   $("#y41aCensoInspeccionForm").submit();
						}
				});
			}else{
				
				if($("#y41aCensoInspeccionBtAniadir").size() > 0)
				{
					funcGrabarInspeccion();
				}
				else
				{
			       	var form_url = "/y41aVistaWar/plantillains/subidaInspeccion?R01HNoPortal=true";
                  	$("#y41aCensoInspeccionForm").attr("action", form_url);
					$("#y41aCensoInspeccionForm").submit();
				}
				
			}
			
		}
	});
	
	function funcGrabarInspeccion(){
		var form_url = "";
		
		$("#y41aMensajeSiNo").rup_dialog({
			modal: true,
			autoOpen: true,
			width: "500",
			height: "auto",
			resizable: false, 
			message: $.rup.i18n.app.msg.grabarPlantillasOMIC,
			type:$.rup.dialog.TEXT,
			title: $.rup.i18n.app.msg.confirmacion,
			  buttons: [
			            {text: $.rup.i18n.base.rup_global.aceptar,
				  		 click: function(){
				  			 	$("#y41aMensajeSiNo").dialog("close");
			                  	form_url = "/y41aVistaWar/plantillains/subidaInspeccionAll?R01HNoPortal=true";
			                  	$("#y41aCensoInspeccionForm").attr("action", form_url);
			                  	$("#y41aCensoInspeccionForm").submit();
				  		 } 
			  			},
			            {text: $.rup.i18n.base.rup_global.cancelar,
					  	 btnType:$.rup.dialog.LINK,
				  		 click: function(){
				  			 	$("#y41aMensajeSiNo").dialog("close");
				  			 	form_url = "/y41aVistaWar/plantillains/subidaInspeccion?R01HNoPortal=true";
								$("#y41aCensoInspeccionForm").attr("action", form_url);
								$("#y41aCensoInspeccionForm").submit();
				  		 		} 
				  		}]
		});		
	}
	
	
	function validarCampos(){
		
		var txtFeedback = "";
		
		var bCampo2 = false;
	
		if ($("#y41aCensoInspeccionComboInspeccion").rup_combo("getRupValue") != "" && $("#y41aCensoInspeccionComboInspeccion").rup_combo("getRupValue") != null)
		{
			bCampo2 = true;
		}else{
			txtFeedback += "<li>" + $.rup.i18n.app.y41aVistaWar_inspecciones.seleccioneInspeccion + "</li>\n";
			bCampo2 = false;
		}
				
		if (bCampo2){
			return true;
		}else{
			$("#censoinspeccion_feedback").rup_feedback("option", "delay",null);
			$("#censoinspeccion_feedback").rup_feedback("set","<ul>" + txtFeedback + "</ul>", "error");
			return false;
		}
	}
	
	function formateadorLink(cellvalue, options, rowObject) {
	    
		if(cellvalue != null)
			{
			return "<a href=/y41aVistaWar/plantillains/inspeccionfile/"+ rowObject.plinscodigo +"?R01HNoPortal=true>" + cellvalue + "</a>";
			}
		else{
			return "";
		}
		
	}
	
	//limpiar tabla
	function reloadTablaInspeccion()
	{
		
		$("#y41aCensoInspeccionGrid").rup_grid("clearGridData");
		$("#y41aCensoInspeccionGrid").rup_grid("setGridParam", {url : "/y41aVistaWar/plantillains/getAllInspeccion?R01HNoPortal=true"});
		$("#y41aCensoInspeccionGrid").rup_grid("reloadGrid");
		
		$("#y41aCensoInspeccionComboInspeccion-button").remove();
		$("#y41aCensoInspeccionComboInspeccion-menu").remove();
		$('<select id="y41aCensoInspeccionComboInspeccion" name="inscodcarta"></select>').replaceAll("#y41aCensoInspeccionComboInspeccion");
		
		$("#y41aCensoInspeccionComboInspeccion").rup_combo({
			blank : "",
			source : "/y41aVistaWar/plantillains/getAllInspeccion?R01HNoPortal=true",
			sourceParam : {
				label : "insnombre",
				value : "inscodcarta" 
			}	
		});
	}
	
	/* **********************************************************
	 * Funcion que limpia/inicializa los valores del formulario *
	 * **********************************************************
	 */
	function documentosInspeccionLimpiarDocumento(){
		
		$("#y41aCensoInspeccionPlantilla").val("");
		$("#y41aCensoInspeccionFileupload").html('<table class="files"></table>');
		recargarUpload();
		$("#y41aCensoInspeccionComboInspeccion").rup_combo("select", "");
		
	}
	
	$("#y41aCensoInspeccionBtEliminar").click(function (){
		
		var selectedRow = $("#y41aCensoInspeccionGrid").rup_grid("getSelectedRows")[0];
		row = $("#y41aCensoInspeccionGrid").rup_grid("getRowData", selectedRow);
		
		if(row.inscodcarta == "" || row.inscodcarta == null)
		{
			$("#censoinspeccion_feedback").rup_feedback("option", "delay", 800);
			$("#censoinspeccion_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
		else
		{
		   $.rup_messages("msgConfirm",{
			   title:$.rup.i18n.app.msg.confirmacion,
			   message: $.rup.i18n.app.msg.confiramacioneliminar,
			   OKFunction : function () {
				   modificarInspeccion();
				}
		   });
			
		}	
	});
	
	
	function modificarInspeccion(){
		var jqxhr = $.ajax({
			type : 'PUT',
			url : "/y41aVistaWar/inspecciones/?inscodcarta=" + row.inscodcarta + "&R01HNoPortal=true",
			dataType : "json",
			contentType : 'application/json',
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){		
					case 406:
						$("#censoinspeccion_feedback").rup_feedback("option", "delay",null);
						$("#censoinspeccion_feedback").rup_feedback("set",jqXHR.responseText, "error");
						break;
					//case 500:	
					default:
						$("#censoinspeccion_feedback").rup_feedback("option", "delay",null);
						$("#censoinspeccion_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
						break;
				}
			},
			success : function(data) {
		
						$("#censoinspeccion_feedback").rup_feedback("option", "delay",800);
						$("#censoinspeccion_feedback").rup_feedback("set", "ok", "ok");
						reloadTablaInspeccion();
			}
		});
	}
	
	
	$("#y41aCensoInspeccionBtCancelar").click(function (){
		documentosInspeccionLimpiarDocumento();
	});
	