
jQuery(function($) {
	
	var row; //variable para recoger los datos de la fila
	// posicionamos el menu
	$("#accordion").accordion('activate', 3 );
	
	$("#y41aCensoFichasFeedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	$("#y41aCensoFichasComboFicha").rup_combo({
		blank : "",
		source : "/y41aVistaWar/fichas/getAllFicha?R01HNoPortal=true",
		sourceParam : {
			label : "finombre",
			value : "ficodigo" 
		},
		width:"450"
	});
	
	
	
	var y41aVarCensoFichasGridWidthTabla = $("#capaPadre").width()-10;
	
	$("#y41aCensoFichasGrid").rup_grid({
		hasMaint: false,
		width: y41aVarCensoFichasGridWidthTabla,
		url : "/y41aVistaWar/fichas/getAll?pfcoor="+$("#y41aCensoFichasCodOrg").val()+"&R01HNoPortal=true",
		loadOnStartUp: true,
		pagerName: "y41aCensoFichasPager",
		page: 5,
		rowNum: "20",
		sortorder: "asc",
		hoverrows: true,
		sortname: "pfnombre", //no hay nombre de plantilla para euskera
		//fluidBaseLayer:"capaPadre",
		colNames: [
		            '',
		            '',
					$.rup.i18n.app.y41aVistaWar_fichas.ficha,
					$.rup.i18n.app.y41aVistaWar_fichas.fechaUltimaModificacion,
					$.rup.i18n.app.y41aVistaWar_fichas.plantilla,
					'',
				],
				colModel: [
					{ 
						name: "pfcodigo",
						label: "pfcodigo",
						index: "pfcodigo",
						editable:false,
						width: "",
						hidden: true,
						edittype: "hidden"
					},
					{ 
						name: "fichasSolicitudes.ficodigo",
						label: "fichasSolicitudes.ficodigo",
						index: "ficodigo",
						editable:false,
						width: "",
						hidden: true,
						edittype: "hidden"
					},
					{ 
						name: "fichasSolicitudes.finombre" + recuperarLetraIdioma(),
						label: "fichasSolicitudes.finombre" + recuperarLetraIdioma(),
						index: "finombre" + recuperarLetraIdioma(),
						editable:false,
						width: funcPercentage(30,y41aVarCensoFichasGridWidthTabla),
						edittype: "text"
					},
					{ 
						name: "pfultmodificacion",
						label: "pfultmodificacion",
						index: "pfultmodificacion",
						editable:false,
						width: funcPercentage(20,y41aVarCensoFichasGridWidthTabla),
						edittype: "text",
						align:'center'
					},
					{ 
						name: "pfnombre",
						label: "pfnombre",
						index: "pfnombre",
						editable:false,
						width: funcPercentage(35,y41aVarCensoFichasGridWidthTabla),
						edittype: "text",
						formatter: formateadorLink
					},		
					{ 
						name: "pfcontenttypefile",
						label: "pfcontenttypefile",
						index: "pfcontenttypefile",
						editable:false,
						hidden: true,
						edittype: "hidden"
					}
				],
				onSelectRow : function(id, selectR) {
					var datosFila = $("#y41aCensoFichasGrid").rup_grid("getRowData", id);
					$("#y41aCensoFichasComboFicha").rup_combo("select", datosFila["fichasSolicitudes.ficodigo"]);
				}
	
	});
		
	recargarUpload();
	recargarAjaxForm();
	
});


$("#y41aCensoFichasBtAniadir").click(function (){
	showModalCensoFichas();			
});
		
/*
 * Definicion de componente upload. Componente rup-upload integrado en formulario.
 */    
function recargarUpload(){
	$("#fileupload_file_form_plantilla").rup_upload({
		fileInput: $("#y41aCensoFichasPlantilla"),
		maxFileSize: 5000000,
		singleFileUploads:true,
		submitInForm:true
	});	
}

function recargarAjaxForm(){
	// Se utiliza jquery.form para realizar el submit de los formularios por AJAX
	$("#y41aCensoFichasForm").ajaxForm(function(){
		limpiarFormulario();
		recargarTabla();
		$("#y41aCensoFichasFeedback").rup_feedback("option", "delay", 800);
		$("#y41aCensoFichasFeedback").rup_feedback("set",$.rup.i18n.app.comun.tramiteEnviado,"ok");
	}); 
}
	
/*
 * Boton grabar
 */
$("#y41aCensoFichasBtGraba").click(function () {
	if (validarCampos()){
		//Eliminar documento plantilla
		if ($("#y41aCensoFichasPlantilla").val()==""){
			$.rup_messages("msgConfirm",{
				   title:$.rup.i18n.app.msg.confirmacion,
				   message: $.rup.i18n.app.msg.confiramacionPlantillaeliminar,
				   OKFunction : function () {
					   var form_url = "/y41aVistaWar/fichas/subePlantilla?R01HNoPortal=true";
					   $("#y41aCensoFichasForm").attr("action", form_url);
					   $("#y41aCensoFichasForm").submit();
					}
			});
		}else{
			var form_url = "/y41aVistaWar/fichas/subePlantilla?R01HNoPortal=true";
			$("#y41aCensoFichasForm").attr("action", form_url);
			$("#y41aCensoFichasForm").submit();
		}
	}
});
	/*
	 * Valida que se han introducido los campos obligatorios en el formulario de detalle
	 */
	function validarCampos(){
		var txtFeedback = "";
		var bCampo2 = false;
		if ($("#y41aCensoFichasComboFicha").rup_combo("getRupValue") != "" && $("#y41aCensoFichasComboFicha").rup_combo("getRupValue") != null)
		{
			bCampo2 = true;
		}else{
			txtFeedback += "<li>" + $.rup.i18n.app.y41aVistaWar_fichas.seleccioneFicha + "</li>\n";
			bCampo2 = false;
		}
		
		if (bCampo2){
			return true;
		}else{
			$("#y41aCensoFichasFeedback").rup_feedback("option", "delay",null);
			$("#y41aCensoFichasFeedback").rup_feedback("set","<ul>" + txtFeedback + "</ul>", "error");
			return false;
		}
	}
	
	function formateadorLink(cellvalue, options, rowObject) {
		
		if(cellvalue != null)
		{
			return "<a href=/y41aVistaWar/fichas/file/"+ rowObject.pfcodigo +"?R01HNoPortal=true>" + cellvalue + "</a>";
		}
		else{
			return "";
		}
	}
	
	/*
	 * Recargar tabla
	 */
	function recargarTabla()
	{
		$("#y41aCensoFichasGrid").rup_grid("clearGridData");
		$("#y41aCensoFichasGrid").rup_grid("setGridParam", {url : "/y41aVistaWar/fichas/getAll?pfcoor="+$("#y41aCensoFichasCodOrg").val()+"&R01HNoPortal=true"});
		$("#y41aCensoFichasGrid").rup_grid("reloadGrid");
		
		$("#y41aCensoFichasComboFicha-button").remove();
		$("#y41aCensoFichasComboFicha-menu").remove();
		$('<select id="y41aCensoFichasComboFicha" name="pfcodfi"></select>').replaceAll("#y41aCensoFichasComboFicha");
		
		$("#y41aCensoFichasComboFicha").rup_combo({
			blank : "",
			source : "/y41aVistaWar/fichas/getAllFicha?R01HNoPortal=true",
			sourceParam : {
				label : "finombre",
				value : "ficodigo" 
			}	
		});
	}
	
	/*
	 * Limpia/inicializa los valores del formulario *
	 * 
	 */
	function limpiarFormulario(){
		$("#y41aCensoFichasPlantilla").val("");
		$("#y41aCensoFichasFileupload").html('<table class="files"></table>');
		recargarUpload();
		$("#y41aCensoFichasComboFicha").rup_combo("select", "");
	}

	/*
	 * evento click sobre el boton de cancelar
	 */
	$("#y41aCensoFichasBtCancelar").click(function (){
		limpiarFormulario();
	});
	
