jQuery(function($) {
		
		var query = $("#busquedaSectoresForm").serialize();
		
		$("#y41aSectoresGrid").rup_grid({
			hasMaint: false,
			width: "600",
			url : "/y41aVistaWar/sector?" + query + "&R01HNoPortal=true",
			loadOnStartUp: true,
			pagerName: "pagerSector",
			page: 10,
			rowNum: "10",
			sortorder: "asc",
			hoverrows: true,
			sortname: "secodigo",
			colNames: [
				$.rup.i18n.app.y41aVistaWar_sectores.codigo,
				$.rup.i18n.app.y41aVistaWar_sectores.nombre,
				''
			],
			colModel: [
				{ name: "secodigo",
					label: "secodigo",
					index: "secodigo",
					width: "70",
					editable: true,
					edittype: "text"
				},
				{ name: "senombre" + recuperarLetraIdioma(),
					label: "senombre" + recuperarLetraIdioma(),
					index: "senombre" + recuperarLetraIdioma(),
					width: "530",
					editable: true,
					edittype: "text"
				}
				,
				{ name: "secose",
					label: "secose",
					index: "secose",
					hidden: true,
					edittype: "hidden"
				}
		    ],
			beforeSelectRow: function (rowid, e) {
				var datosFila = $("#y41aSectoresGrid").rup_grid("getRowData", rowid);
			    if (datosFila.secose == "E")
			    {
			        return true;
			    }else{
			    	return false;
			    }
			},
			afterInsertRow : function(rowid, rowdata)
			{
			    if (rowdata.secose != "E")
			    {
			        $(this).jqGrid('setRowData', rowid, false, 'nAllowed');
			    }
			}
		
		});
		
		
		$(document).ready(function(){
			//asignamos el valor id del campo que queremos que se mayÃºscula
			aMayusculas("input#y41aSectoresSecodigo"); 
		});	
		
		
});//FIN INICIALIZAR
	
	var blSeleccion = true;
	$("#y41aSectoresGrid").bind("click", function(e){
			//alert("ENTRA CLICK");
			var filaSeleccionada = $("#y41aSectoresGrid").rup_grid("getSelectedRows")[0];
			fila = $("#y41aSectoresGrid").rup_grid("getRowData", filaSeleccionada);
			var codigo = fila.secodigo;
			var descripcion = fila.senombre;
		
			if(fila.secose == "E")
			{
				if (y41aVarPadreModalSector == "y41aBusquedaActuacion"){
					//alert("desde actuaciones");
					y41aFunctionModalSectoresAPadreBusquedaActuaciones(codigo,descripcion);	
				}else if(y41aVarPadreModalSector == "y41aEstablecimientosBusqueda"){	//modalEstMantenimientoAbierta == false
					//alert("desde busqueda");
					y41aFunctionModalSectoresAPadreEstablecimientosBusqueda(codigo,descripcion);
					

//					modalSectoresAPadre(codigo,descripcion);
//					closeSector();
				}else if(y41aVarPadreModalSector == "y41aEstablecimientosDetalle"){
					//alert("desde detalle");
					y41aFunctionModalSectoresAPadreEstablecimientosDetalle(codigo,descripcion);
					
//					modalSectoresAHijo(codigo,descripcion);
//					closeSector();	
				}else if(y41aVarPadreModalSector == "y41aEstadisticasSolicitudes"){
					//alert("desde estadisticas solicitudes");
					y41aFunctionModalSectoresAPadreEstadisticasSolicitudes(codigo,descripcion);
				}else if(y41aVarPadreModalSector == "y41aOoeeBusqueda"){
					y41aFunctionModalSectoresAPadreOoeeBusqueda(codigo,descripcion);
				}
			}
	});
	
	

	function closeSector(){
			$("y41aSectoresGrid").unbind();
			$("#y41aEstablecimientosModalSector").rup_dialog("close");
			$("#y41aEstablecimientosModalSector").rup_dialog("destroy");
			$("y41aSectoresGrid").unbind("click");

	}


	$("#y41aSectoresBtFiltrar").click(function () {
		 busquedaSectores();
	});
	
	 function busquedaSectores()
	 {
			$("#y41aSectoresGrid").rup_grid("clearGridData");
			var query = $("#busquedaSectoresForm").serialize();
			$("#y41aSectoresGrid").rup_grid("setGridParam", {url : "/y41aVistaWar/sector?" + query + "&R01HNoPortal=true"});
			$("#y41aSectoresGrid").rup_grid("reloadGrid");
	 }
	 
	 $("#y41aSectoresBtLimpiar").click(function () {
			 limpiarSectores();
	 });
	 
	 function limpiarSectores(){
		 $("#y41aSectoresSecodigo").val("");
		 $("#y41aSectoresSenombre").val("");
		 $("#y41aSectoresTodos").attr("checked" ,false);
		 $("#y41aSectoresHabituales").attr("checked" ,true);
	 }
