jQuery(function($) {
	
	var row; //variable para recoger los datos de la fila
	// posicionamos el menu
	$("#accordion").accordion('activate', 3 );
	
	$("#censodecisiones_feedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	$("#y41aCensoDecisionesComboDecisiones").rup_combo({
		blank : "",
		source : "/y41aVistaWar/plantilladecision/getAllDecision?R01HNoPortal=true",
		sourceParam : {
			label : "denombre"+recuperarLetraIdioma(),
			value : "decodigo" 
		}	
		,
		width:"450"
	});
	var y41aVarCensoDecisionesGridWidthTabla = $("#capaPadre").width()-10;
		
	$("#y41aCensoDecisionesGrid").rup_grid({
		hasMaint: false,
		width: y41aVarCensoDecisionesGridWidthTabla,
		url : "/y41aVistaWar/plantilladecision/getAllDecision?R01HNoPortal=true",
		loadOnStartUp: true,
		pagerName: "pagerCensoDecisiones",
		page: 5,
		rowNum: "20",
		sortorder: "asc",
		hoverrows: true,
		sortname: "denombre" + recuperarLetraIdioma(),
		colNames: [
		            '',
		            '',
					$.rup.i18n.app.y41aVistaWar_decisiones.decision,
					$.rup.i18n.app.y41aVistaWar_decisiones.fechaUltimaModificacion,
					$.rup.i18n.app.y41aVistaWar_decisiones.plantilla,
					'',
				],
				colModel: [
					{ 
						name: "pdcodigo",
						label: "pdcodigo",
						index: "pdcodigo",
						editable:false,
						width: "",
						hidden: true,
						edittype: "hidden"
					},
					{ 
						name: "decodigo",
						label: "decodigo",
						index: "decodigo",
						editable:false,
						hidden: true,
						edittype: "hidden"
					},
					{ 
						name: "denombre" + recuperarLetraIdioma(),
						label: "denombre" + recuperarLetraIdioma(),
						index: "denombre" + recuperarLetraIdioma(),
						editable:false,
						width: funcPercentage(30,y41aVarCensoDecisionesGridWidthTabla),
						edittype: "text"
					},
					{ 
						name: "pdultmodificacion",
						label: "pdultmodificacion",
						index: "pdultmodificacion",
						editable:false,
						width: funcPercentage(20,y41aVarCensoDecisionesGridWidthTabla),
						edittype: "text",
						align:'center'
					},
					{ 
						name: "pdnombre" ,
						label: "pdnombre" ,
						index: "pdnombre" ,
						editable:false,
						width: funcPercentage(35,y41aVarCensoDecisionesGridWidthTabla),
						edittype: "text",
						formatter: formateadorLink
					},		
					{ 
						name: "pdcontenttypefile",
						label: "pdcontenttypefile",
						index: "pdcontenttypefile",
						editable:false,
						hidden: true,
						edittype: "hidden"
					}
				],
				
				
				onSelectRow : function(id, selectR) {
					var datosFila = $("#y41aCensoDecisionesGrid").rup_grid("getRowData", id);
					var codigo = datosFila.decodigo;
					
					$("#y41aCensoDecisionesComboDecisiones").rup_combo("select", codigo);
				}	
	
	});
	recargarUpload();
	recargarAjaxForm();
});


$("#y41aCensoDecisionesBtAniadir").click(function (){
	showModalCensoDecisiones();			
});
		
function showModalCensoDecisiones(){
	$("#y41aCensoDecisionesModal").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "500",
		height: "auto",
		title: $.rup.i18n.app.y41aVistaWar_decisiones.altaDecision,
		url: "/y41aVistaWar/decision/modalDecision?R01HNoPortal=true", 
		type:$.rup.dialog.AJAX
	});	
}
    
function recargarUpload(){
	$('#fileupload_file_form_plantilla').rup_upload({
		fileInput: $("#y41aCensoDecisionesPlantilla"),
		maxFileSize: 5000000,
		singleFileUploads:true,
		submitInForm:true
	});	
}

function recargarAjaxForm(){
	// Se utiliza jquery.form para realizar el submit de los formularios por AJAX
	$("#y41aCensoDecisionesForm").ajaxForm(function(){
		documentosDecisionesLimpiarDocumento();
		reloadTablaDocs();
		$("#censodecisiones_feedback").rup_feedback("option", "delay", 800);
		$("#censodecisiones_feedback").rup_feedback("set",$.rup.i18n.app.comun.tramiteEnviado,"ok");
	}); 
}
	
	$("#y41aCensoDecisionesBtGraba").click(function () {
		if (validarCampos()){
			if ($("#y41aCensoDecisionesPlantilla").val()==""){
				$.rup_messages("msgConfirm",{
					   title:$.rup.i18n.app.msg.confirmacion,
					   message: $.rup.i18n.app.msg.confiramacionPlantillaeliminar,
					   OKFunction : function () {
						   var form_url = "/y41aVistaWar/plantilladecision/subidaDecision?R01HNoPortal=true";
						   $("#y41aCensoDecisionesForm").attr("action", form_url);
						   $("#y41aCensoDecisionesForm").submit();
						}
				});
			}else{
			
				if($("#y41aCensoDecisionesBtAniadir").size() > 0)
				{
					funcGrabarDecision();
				}
				else
				{
				 	var form_url = "/y41aVistaWar/plantilladecision/subidaDecision?R01HNoPortal=true";
					$("#y41aCensoDecisionesForm").attr("action", form_url);
					$("#y41aCensoDecisionesForm").submit();
				}
				
				
			}
		}
	});
	
	function funcGrabarDecision()
	{
	
		var form_url = "";
		
		$("#y41aMensajeSiNo").rup_dialog({
			modal: true,
			autoOpen: true,
			width: "500",
			height: "auto",
			resizable: false, 
			message: $.rup.i18n.app.msg.grabarPlantillasOMIC,
			type:$.rup.dialog.TEXT,
			title: $.rup.i18n.app.msg.confirmacion,     
			  buttons: [       
			            {text: $.rup.i18n.base.rup_global.aceptar,
				  		 click: function(){
				  			 		$("#y41aMensajeSiNo").dialog("close");
				  			 		form_url = "/y41aVistaWar/plantilladecision/subidaDecisionAll?R01HNoPortal=true";
				  			 		$("#y41aCensoDecisionesForm").attr("action", form_url);
				  			 		$("#y41aCensoDecisionesForm").submit();
				  		 		} 
			  			},
			            {text: $.rup.i18n.base.rup_global.cancelar,
					  	 btnType:$.rup.dialog.LINK,
			  			 click: function(){
			  				 		$("#y41aMensajeSiNo").dialog("close");
			                	  	form_url = "/y41aVistaWar/plantilladecision/subidaDecision?R01HNoPortal=true";
									$("#y41aCensoDecisionesForm").attr("action", form_url);
									$("#y41aCensoDecisionesForm").submit();
				  		 		}
				  		}]
		});			
	}
	
	
	function validarCampos(){
		
		var txtFeedback = "";
		
		var bCampo2 = false;
		
		
		if ($("#y41aCensoDecisionesComboDecisiones").rup_combo("getRupValue") != "" && $("#y41aCensoDecisionesComboDecisiones").rup_combo("getRupValue") != null)
		{
			bCampo2 = true;
		}else{
			txtFeedback += "<li>" + $.rup.i18n.app.y41aVistaWar_decisiones.seleccioneDecision + "</li>\n";
			bCampo2 = false;
		}
		
		if (bCampo2){
			
			return true;
		}else{
			
			$("#censodecisiones_feedback").rup_feedback("option", "delay",null);
			$("#censodecisiones_feedback").rup_feedback("set","<ul>" + txtFeedback + "</ul>", "error");
			return false;
		}
	}
	
	function formateadorLink(cellvalue, options, rowObject) {
		
		if(cellvalue != null)
		{
			return "<a href=/y41aVistaWar/plantilladecision/decisionfile/"+ rowObject.pdcodigo + "?R01HNoPortal=true>" + cellvalue + "</a>";
		}
		else{
			return "";
		}
	}
	
	//limpiar tabla
	function reloadTablaDocs()
	{
		$("#y41aCensoDecisionesGrid").rup_grid("clearGridData");
		$("#y41aCensoDecisionesGrid").rup_grid("setGridParam", {url : "/y41aVistaWar/plantilladecision/getAllDecision?R01HNoPortal=true"});
		$("#y41aCensoDecisionesGrid").rup_grid("reloadGrid");
		
		$("#y41aCensoDecisionesComboDecisiones-button").remove();
		$("#y41aCensoDecisionesComboDecisiones-menu").remove();
		$('<select id="y41aCensoDecisionesComboDecisiones" name="decodigo"></select>').replaceAll("#y41aCensoDecisionesComboDecisiones");
		
		$("#y41aCensoDecisionesComboDecisiones").rup_combo({
			blank : "",
			source : "/y41aVistaWar/plantilladecision/getAllDecision?R01HNoPortal=true",
			sourceParam : {
				label : "denombre",
				value : "decodigo" 
			}	
		});
	}
	
	/* **********************************************************
	 * Funcion que limpia/inicializa los valores del formulario *
	 * **********************************************************
	 */
	function documentosDecisionesLimpiarDocumento(){
		
		$("#y41aCensoDecisionesPlantilla").val("");
		$("#y41aCensoDecisionesFileupload").html('<table class="files"></table>');
		recargarUpload();
		$("#y41aCensoDecisionesComboDecisiones").rup_combo("select", "");
		
	}
	
	
	$("#y41aCensoDecisionesBtEliminar").click(function (){
		
		var selectedRow = $("#y41aCensoDecisionesGrid").rup_grid("getSelectedRows")[0];
		row = $("#y41aCensoDecisionesGrid").rup_grid("getRowData", selectedRow);
		
		if(row.decodigo == "" || row.decodigo == null)
		{
			$("#censodecisiones_feedback").rup_feedback("option", "delay", 800);
			$("#censodecisiones_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
		else
		{
			
			y41aFunctionContarDecisiones(row.decodigo);
		}	
	
	});
	
	
	function modificarDecision(){
		
		var jqxhr = $.ajax({
			type : 'PUT',
			url : "/y41aVistaWar/decision/?decodigo=" + row.decodigo + "&R01HNoPortal=true",
			dataType : "json",
			contentType : 'application/json',
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){		
					case 406:
						$("#censodecisiones_feedback").rup_feedback("option", "delay",null);
						$("#censodecisiones_feedback").rup_feedback("set",jqXHR.responseText, "error");
						break;
					//UDAEXCEPTION
					//Method notAllowed
					case 409:
						controlY41aUDAException(jqXHR, "censodecisiones_feedback");
						break;
					default:
						$("#censodecisiones_feedback").rup_feedback("option", "delay",null);
						$("#censodecisiones_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
						break;
				}
			},
			success : function(data) {
		
						$("#censodecisiones_feedback").rup_feedback("option", "delay",800);
						$("#censodecisiones_feedback").rup_feedback("set", "ok", "ok");
						reloadTablaDocs();
			}
		});
	}
	
	function eliminarDocumento()
	{
		var jqxhr = $.ajax({
			type : 'DELETE',
			url : "/y41aVistaWar/plantilladecision/removeDecision/" + row.pdcodigo + "?R01HNoPortal=true",
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){		
					case 406:
						$("#censodecisiones_feedback").rup_feedback("option", "delay",null);
						$("#censodecisiones_feedback").rup_feedback("set",jqXHR.responseText, "error");
						break;
					case 409:
						controlY41aUDAException(jqXHR, "censodecisiones_feedback");
						break;
					default:
						$("#censodecisiones_feedback").rup_feedback("option", "delay",null);
						$("#censodecisiones_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
						break;
				}
			},
			success : function(data) {

						$("#censodecisiones_feedback").rup_feedback("option", "delay",800);
						$("#censodecisiones_feedback").rup_feedback("set", "ok", "ok");
						reloadTablaDocs();
			}
		});
	}
	
	$("#y41aCensoDecisionesBtCancelar").click(function (){
		documentosDecisionesLimpiarDocumento();
	});
	
	
	
	function y41aFunctionContarDecisiones(decodigo){
		
		
		
		var jqxhr = $.ajax({
			type : 'GET',
			url : "/y41aVistaWar/decisionhecho/countDecisiones/"+ decodigo+ "?R01HNoPortal=true",
			dataType : "json",
			contentType : 'application/json',
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){	
					case 406:
						$("#censodecisiones_feedback").rup_feedback("option", "delay",null);
						$("#censodecisiones_feedback").rup_feedback("set",jqXHR.responseText, "warning");
						break;	
					//UDAEXCEPTION
					//Method notAllowed
					case 409:
						controlY41aUDAException(jqXHR, "censodecisiones_feedback");
						break;
					default:
						$("#censodecisiones_feedback").rup_feedback("option", "delay",null);
						$("#censodecisiones_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "warning");
						break;
				}
			},
			success : function(data) {
				
				
				if (data!=null && data>0){
					   $.rup_messages("msgConfirm",{
						   title:$.rup.i18n.app.msg.confirmacion,
						   message: $.rup.i18n.app.msg.confiramacioneliminarconexpedientes,
						   OKFunction : function () {
							   modificarDecision();
							}
					   });
				}else{
				   $.rup_messages("msgConfirm",{
					   title:$.rup.i18n.app.msg.confirmacion,
					   message: $.rup.i18n.app.msg.confiramacioneliminar,
					   OKFunction : function () {
						   modificarDecision();
						}
				   });
				}
			}
		});
	}

	
	
