<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" encoding="ISO-8859-1"/>
 <xsl:variable name="vLower" select="'abcdefghijklmnopqrstuvwxyz %()/>\:-.'"/>
 <xsl:variable name="vUpper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ__________'"/>
 <xsl:param name="n38EscudoGobierno" select="'/images_n38/escudo_gobierno.gif'"/>
<xsl:template match="/">
        <html>
                <head>
                        <link rel="stylesheet" type="text/css" href="/xlnets/includes/portal.css"/>
                        <title>Portal de Aplicaciones</title>
                        <script languaje="Javascript" src="/xlnets/includes/portal.js"></script>
                </head>                 
        <body>
        <img src="{$n38EscudoGobierno}" class="cabecera" />
        <img src="/images_n38/titulo2.png" style="position:absolute;top:25;left:600;" />
        <span class="cabeceratexto">Servicio de Autenticacion</span>
        <div class="titulo"> Portal de Aplicaciones</div>
        <xsl:apply-templates/>
        <div id ="idaviso" class="aviso"><center>Se esta cargando la aplicacion<br/>Espere por favor.</center></div>
        </body>
        </html>
</xsl:template>
<xsl:template match="n38">
        <div class="menuRaiz">
            <xsl:apply-templates/>
        </div>
</xsl:template>
<xsl:template match="elementos">
         <div class="menuRama">  
            <div class="menuRama">
                <xsl:for-each select="elemento">
                        <div class="menuRama">
                             <img src="/images_n38/mas.png" onClick="Expand(this);"/>                           
                              <a class="menuNodo" onClick="Javascript:Expand(this);" onMouseOver="NodoOver(this);" onMouseOut="NodoOut(this);">                         
                                <img width="16" height="16">
                                    <xsl:attribute name="src">  
                                     <xsl:choose>
                                          <xsl:when test="string-length(parametro[@id='n38icono']/valor/text())>1">
                                               <xsl:choose>
                                                  <xsl:when test="contains(translate(parametro[@id='n38icono']/valor[text()],$vLower,$vUpper),translate('DEFECTO',$vLower,$vUpper))">/images_n38/DEFECTOweb.jpg</xsl:when>
                                                  <xsl:otherwise>/images_n38/<xsl:value-of select="parametro[@id='n38icono']/valor"/></xsl:otherwise>
                                               </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>/images_n38/DEFECTOweb.jpg</xsl:otherwise>
                                     </xsl:choose>
                                    </xsl:attribute>                             			
                                </img>
                                <xsl:value-of select="parametro[@id='n38cadescripcion']/valor"/> 
                              </a>
                                <div class="menuRama" style="display:none;">
                                    <xsl:apply-templates select="elemento">
                                      	<xsl:sort select="parametro[@id='n38uidobjseguridad']/valor" data-type="text" order="ascending"/>
                	                  </xsl:apply-templates>
                                </div>
                        </div>
                </xsl:for-each>
            </div>  
        </div>  
</xsl:template>

<xsl:template match="elemento/elemento">
        <div nowrap="" onClick="Javascript:NodoClick(this);">
            <xsl:if test="string-length(parametro[@id='url']/valor/text())>1">
               <xsl:attribute name="ruta">
                   <xsl:value-of select="parametro[@id='url']/valor"/>
               </xsl:attribute>
               <xsl:attribute name="target">
                   <xsl:value-of select="translate(parametro[@id='n38uidobjseguridad']/valor[text()],$vLower,$vUpper)"/>
               </xsl:attribute>
               <xsl:attribute name="tipo">web</xsl:attribute>
               <img src="/images_n38/web.png"/>                 
            </xsl:if>            
            <xsl:if test="string-length(parametro[@id='n38path-ejecutable']/valor/text())>1">
               <xsl:attribute name="ruta">
                   <xsl:value-of select="parametro[@id='n38path-ejecutable']/valor"/>
               </xsl:attribute>
               <xsl:attribute name="parametros">
                   <xsl:value-of select="parametro[@id='n38parametros']/valor"/>
               </xsl:attribute>
               <xsl:attribute name="tipo">cs</xsl:attribute>
               <img src="/images_n38/cs.png"/>
            </xsl:if>            
		<span  class="menuNodo" onMouseOver="NodoOver(this);" onMouseOut="NodoOut(this);">
			<xsl:value-of select="parametro[@id='n38cadescripcion']/valor"/>
		</span>
        </div>
</xsl:template>

</xsl:stylesheet>
