
jQuery(document).ready(function(){
	$("#accordionBandEntrTelem").rup_accordion({
		animated: "bounceslide",
		active: false,
		autoHeight: false,
		collapsible: true}
	);
	
	$("#table_bus").rup_table({
		url: "../telematicas/jgrid",
		hasMaint: false,
		model:"Aa83bBusqueda",
		colNames: [
		          $.rup.i18n.app.solicitudes.Solicitud,
		          $.rup.i18n.app.solicitudes.NumRegistro,
		          $.rup.i18n.app.solicitudes.Nombre,
		          $.rup.i18n.app.solicitudes.Fecha,
		          $.rup.i18n.app.solicitudes.TramiteActual,
		          $.rup.i18n.app.solicitudes.NumDocsAdjuntos,
		          $.rup.i18n.app.solicitudes.Ver,
		          $.rup.i18n.app.solicitudes.Procesar
		          ],
		colModel: [
		{
			width:60,
			name: "solConcat", label: $.rup.i18n.app.solicitudes.Solicitud, sortable:false
		},
		{
			width:80,
			name: "numReg", label: $.rup.i18n.app.solicitudes.NumRegistro, sortable:false},
		{
			width:160,
			name: "nombre_sol", label: $.rup.i18n.app.solicitudes.Nombre, sortable:false},
		{
			width:80,
			name: "fecha", label: $.rup.i18n.app.solicitudes.Fecha, sortable:false},
		{
			width:120,
			name: "estado", label: $.rup.i18n.app.solicitudes.TramiteActual, sortable:false},
		{
			width:60,
			name: "num_docs_adj", label: $.rup.i18n.app.solicitudes.NumDocsAdjuntos, sortable:false},
		{
			width:60,
			name: "num_docs_adj", label: $.rup.i18n.app.solicitudes.Ver, sortable:false,
			formatter:function (cellval, opts, rwd, act) {
				var idSol = rwd.solConcat;
				var itzuli ="<a href='javascript:ventanaSecundaria("+ "\"" + idSol+"\"" +")'><img src='"+$("#staticsUrl").val()+"/aa83b/images/lupa.png' width=20 height=20></a>";
			return itzuli;
		}
			
		},
		{
			width:60,
			name: "num_docs_adj", label: $.rup.i18n.app.solicitudes.Procesar, sortable:false,
			formatter:function (cellval, opts, rwd, act) {
				return ("<input type=\"button\" name=\"ver\" value="+$.rup.i18n.app.solicitudes.Procesar+" onclick=\"javascript:procesar('"+ rwd.solConcat +"','"+ rwd.faseEs +"')\" >");
			}
			}
		
		],
		loadOnStartUp: true,
		rowNum:20,
		usePlugins:["formEdit","filter","fluid"],
		primaryKey: "solConcat",
		sortname: "numReg",
		sortorder: "asc"
		});
	
	function fnc(){/*alert();*/};
	
//	$("#table_bus").on("rupTable_beforeEditRow", 
//			function(deleteOptions, selectedRow)
//			{
//				id_sol = ($("#table_bus").rup_table("getSelectedRows"));
//				id_tram=($("#table_bus").rup_table("getSelectedRows"));
//				valor = $("#table_bus").rup_table("getCol", id_sol, "solConcat");
//				valor = valor.replace(/\s/g, ':');
//				var res = valor.split(":");
//				ventanaSecundaria (valor);
//				return false;
//			}
//	);
	
	$("#accordionBusqueda").rup_accordion({
			animated: "bounceslide",
			active: 0,
			autoHeight: false,
			collapsible: true}
	);
			
	
	jQuery("#table_bus_feedback").rup_feedback({ 
		type: "ok",
		closeLink: true,
		delay: 1000,
		fadeSpeed: 999999,
		block:true
	});
	
	$('#comboTipoSol').rup_combo({
		source : "/aa83bInformesWar/aa83b03t00/comboSol?vivienda="+esViviendaSN,
		//sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"Id012", style:"css"},
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 200,
		rowStriping : true,
		inputText:true,
		blank:0,
		ordered:true,
		selected: '0'
	});
	
	$('#idfase').rup_combo({
		source : "/aa83bInformesWar/aa83b01t00/comboFase?comboLisCerradas=S",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 200,
		rowStriping:true,
		inputText:true,
		ordered:false,
		blank:0
	});
	
	$('#idtramite').rup_combo({
		source : "/aa83bInformesWar/aa83b02t00/comboTramite",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 350,
		rowStriping:true,
		inputText:true,
		ordered:false,
		parent:["idfase"],
		blank:0
	});
		
	$('#fecRegistro').rup_date({
		
	});
	
	
	function configureForm(){
		
		// Objeto de configuracion del componente.
		var configSettings = {};
		
		// Propiedades de configuracion por defecto comunes a todas las posibilidades de configuracion.
		var defaultConfigSettings = {
				feedback:$("#feedbackMensajes"),
				success:function(xhr){
					var obj = JSON.parse(xhr);
					var21long = obj.aa83b21t00s.length;
					var23long = obj.aa83b23t00s.length;
					var25long = obj.aa83b25t00s.length;
					total = var21long+var23long+var25long;
					console.log (total);
					if (total != 0)
						{
						$(accordionBusqueda).rup_accordion ("activate", false);
						$("#feedbackMensajes").rup_feedback("set","Se han encontrado "+total+" Solicitudes","ok");
						//Cargamos las solicitudes
						
						}
					else
						{$("#feedbackMensajes").rup_feedback("set","No se han encontrado Solicitantes, revise los criterios de búsqueda","ko");}
					
				}
		};
		
		// Creacion de la configuracion del componente de formulario
		var formConfigSettings = {
			ajaxForm:{
				url:$.rup.CTX_PATH+"/busqueda/solicitante/ajax",
				success:function(xhr){
					$("#feedbackMensajes").rup_feedback("set","El formulario se ha enviado correctamente mediante un submit AJAX", "ok");
				}
			}
		};
		
		configSettings = $.extend(true, configSettings, defaultConfigSettings,{},formConfigSettings);
		
		// Se realiza la creacion del componente formulario
		$("#formSolicitante").rup_form(configSettings);
				
	};
	
	/*
	 * INICIALIZACION DEL FORMULARIO
	 */
	configureForm();

	
	$.rup.i18n.base.rup_combo.blankNotDefined = $.rup.i18n.app.solicitudes.todas;//"--Todas--";
	
	$('#table_bus_filter_cleanLink').click(function() {
		$('#comboTipoSol').rup_combo('select', '0');
	});
});

function ventanaSecundaria (idSol){
	id= idSol; 
	if (id.indexOf("HAB") != -1 )
			url="/aa83bInformesWar/viewADE/verADE?id=" + id + "&PopUp=SI";
	else if (id.indexOf("ARR") != -1)
		url="/aa83bInformesWar/viewARR/verARR?id=" + id + "&PopUp=SI";
	else if (id.indexOf("ESF") != -1)
		url="/aa83bInformesWar/viewESF/verESF?id=" + id + "&PopUp=SI";
	
	 window.open(url,"popup","width=1200,height=600, left=200, top=200,scrollbars=YES"); 
	   
	} 

function procesar (idSol, idSolTelema)
{
	var urlCarga ="/aa83bInformesWar/telematicas/procesar";
	waitDialog();
	$.rup_ajax({
    	url: urlCarga,
    	dataType: 'json',
    	data:{
    		'idSol':idSol,
    		'idSolTelema':idSolTelema
    		},
    	cache: false,
    	type: "GET",
    	contentType: 'application/json',
    	async:false,
    	success: function (xhr, ajaxOptions) {
    		$.unblockUI(); 
    		sAcion = "E";
    		if (idSol.indexOf("HAB") != -1 )
				url="/aa83bInformesWar/viewADE/verADE?id=" + idSol;
    		else if (idSol.indexOf("ARR") != -1)
    			url="/aa83bInformesWar/viewARR/verARR?id=" + idSol;
    		else if (idSol.indexOf("ESF") != -1)
    			url="/aa83bInformesWar/viewESF/verESF?id=" + idSol;
    		
    		//window.location="/aa83bInformesWar/viewADE/verADE?id="+idSol;
    		window.location=url;
    	},
   		error: function (xhr, textStatus, errorThrown) {
   			$.unblockUI();
			var errorText = $.rup.rupAjaxDefaultError(xhr, textStatus, errorThrown);
			alert(errorText,"feedbackResolucion",true);
		}
    });
}

function waitDialog(mensaje){
	var mensajeMostrar = $.rup.i18n.app.rup_bloqueUI.cargando;
	if (mensaje){
		mensajeMostrar = mensaje;
	}
	
	$.blockUI({ message: "<div class='aa83b_modalWait'><img src='" + $.rup.APP_STATICS + "/images/ajax-loader.gif' /> "+mensajeMostrar+" </div>" });
	$(".blockUI.blockOverlay").css("z-index",9000);
	$(".blockUI.blockOverlay").css("opacity",0.5);
	$(".blockUI.blockMsg.blockPage").css("z-index",9001);
	$(".blockUI.blockMsg.blockPage").css("opacity",1);
}

