jQuery(document).ready(function(){
	
	options_table_report = {
			buttons:[
				{id:"reports", i18nCaption:$.rup.i18n.app.botones.Exportar, right:true,
					buttons:[
						{ i18nCaption:"CSV", css:"csv", 
							url: "../estadisticas/estcsvReport"
						},
						{ i18nCaption:"XLS", css:"xls", 
							url: "../estadisticas/estxlsReport"
						}/*,
						{ i18nCaption:"XLXS", css:"xls",
							url: "../estadisticas/estxlsxReport" 
						}*/
					 ]}
					 //$.rup.i18n.app.table_report.AltaESF,
					 
				]
			
		};
		
	$("#table").rup_table({
		url: "../estadisticas/buscarEstado",
		hasMaint: false,
		colNames: [ $.rup.i18n.app.solicitudes.Solicitud,
		            $.rup.i18n.app.solicitudes.Genero, 
		            $.rup.i18n.app.solicitudes.Provincia, 
		            $.rup.i18n.app.solicitudes.Nacionalidad, 
		            $.rup.i18n.app.solicitudes.Mes, 
		            $.rup.i18n.app.solicitudes.Fecha 
		           ],
		colModel: [
		{
			width:20,
			name: "solConcat", label: $.rup.i18n.app.solicitudes.Solicitud, sortable:false
		}, {
			width : 20,
			name : "generoStrEs",
			label : $.rup.i18n.app.solicitudes.Genero,
			sortable : false,
			formatter : function(cellval, opts, rwd, act) {
				return rwd.generoStrEs;
			}
		}, {
			width : 30,
			name : "provinciaStrEs",
			label : $.rup.i18n.app.solicitudes.Provincia,
			sortable : false,
			formatter : function(cellval, opts, rwd, act) {
				return rwd.provinciaStrEs;
			}
		},{
			width : 30,
			name : "nacionalidadStrEs",
			label : $.rup.i18n.app.solicitudes.Nacionalidad,
			sortable : false,
			formatter : function(cellval, opts, rwd, act) {
				return rwd.nacionalidadStrEs;
			}
		},
		{
			width : 30,
			name : "nombreMesES",
			label : $.rup.i18n.app.solicitudes.Mes,
			sortable : false,
			formatter : function(cellval, opts, rwd, act) {
				return rwd.nombreMesES;
			}
		},
		{
			width : 30,
			name : "fecha",
			label : $.rup.i18n.app.solicitudes.Fecha,
			sortable : false,
			formatter : function(cellval, opts, rwd, act) {
				return rwd.fecha;
			}
		}

		

		],
		loadOnStartUp: false,
		rowNum:20,
		usePlugins:["feedback","fluid","toolbar","report","filter"],
		primaryKey: "Solicitud",
        report: options_table_report,

        toolbar:{
        // Propiedades de configuración del plugin toolbar
        createDefaultToolButtons:false,
        buttons:[
                 /*	{i18nCaption:"Alta Solicitud HAB", css:"nuevo", click:handlerBotonADE, url:null},
                 	{i18nCaption:"Alta Solicitud ARR", css:"nuevo", url: "../altaADE/alta"},
                 	{i18nCaption:"Alta Solicitud ESF", css:"nuevo", url: "../altaADE/alta"},
                 	*/
                 ]
        },
		feedback:{
		// Propiedades de configuración del plugin feedback
		},
		validate:{
			//onsubmit:false,
			liveCheckingErrors:true,
			showFieldErrorAsDefault:true,
			showErrorsInFeedback:true,
			showErrorsDetailsInFeedback:true,
			feedback:$("#table_feedback"),
			rules:{
				"fDesde":{date:true},
				"fHasta":{date:true}
			}
		}
	});
	
	$('#table').on("rupTable_beforeFilter", function(e) {
		if ($("#table_filter_form").validate().checkForm()) {
			return true;
		} else {
			return false;
		}
	});
	
	$('#table_filter_form').rup_validate({
		feedback:$("#table_feedback"),
		liveCheckingErrors: true,
		rules: {
			'fDesde': { date: true},
			'fHasta': { date: true}
		}
	});

	jQuery("#table_feedback").rup_feedback({ 
		type: "ok",
		closeLink: true,
		delay: 1000,
		fadeSpeed: 999999,
		block:true
	});
	
	$('#comboTipoSol').rup_combo({
		source : "/aa83bInformesWar/aa83b03t00/comboSol",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 200,
		rowStriping : true,
		inputText:true,
		blank:0,
		selected: "0",
		ordered:true
	});
	
	
	$.rup.i18n.base.rup_combo.blankNotDefined = $.rup.i18n.app.solicitudes.todas;//"--Todas--";
	
	$.rup_date({
		from: "desde",
		to: "hasta",
		minDate: $.rup_utils.createDate(01, 01, 1900),
		maxDate: $.rup_utils.createDate(31, 12, 2020)
	});
		
	$("#formHttpSubmit_button_excel").bind("click",function(e){
		document.getElementById("tipoSol2").value = document.getElementById("comboTipoSol").value;
		document.getElementById("fDesde2").value = document.getElementById("desde").value;
		document.getElementById("fHasta2").value = document.getElementById("hasta").value;
	});
		
});

