var fecha = new Date();
var soloAbiertas ;

document.getElementById("ano_sol").value=ano;
	
jQuery(document).ready(function(){

	$("#accordionBusqueda").rup_accordion({
		collapsible: true,
		fillSpace: true
	});

	options_table_report = {
			buttons:[
				{id:"reports", i18nCaption:$.rup.i18n.app.botones.Exportar, right:true,
					buttons:[
						{ i18nCaption:"CSV", css:"csv", 
							url: "../busqueda/csvReport"
						},
						{ i18nCaption:"XLS", css:"xls", 
							url: "../busqueda/xlsReport"
						},
						{ i18nCaption:"PDF", css:"pdf",
							url: "../busqueda/pdfReport"
						}/*,
						{ i18nCaption:"XLXS", css:"xls",
							url: "../busqueda/xlsxReport" 
						}*/
					 ]}
				//$.rup.i18n.app.table_report.AltaESF,
					 
				],
			columns:[ {
				hidden:false
			}]
		};
	function handlerBotonADE ()
		{window.location="/aa83bInformesWar/altaADE/maint";}
		
	$('#comboLisCerradas').rup_combo({
		source : ["S","N"],
		width: 200
	});
	
	if ($("#listCerradas").prop("checked")){
		$('#comboLisCerradas').rup_combo("select","S");
	} else {
		$('#comboLisCerradas').rup_combo("select","N");
	}
	
	$.rup.i18n.base.rup_combo.blankNotDefined = $.rup.i18n.app.solicitudes.todas;//"--Todas--";	
	
	$('#idfase').rup_combo({
		source : "/aa83bInformesWar/aa83b01t00/comboFase",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 200,
		rowStriping:true,
		inputText:true,
		ordered:false,
		parent:["comboLisCerradas"],
		blank:0
	});
	
	$('#idtramite').rup_combo({
		source : "/aa83bInformesWar/aa83b02t00/comboTramite",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 350,
		rowStriping:true,
		inputText:true,
		ordered:false,
		parent:["idfase"],
		blank:0
	});
	
	$('#comboTipoDoc').rup_combo({
		source : "/aa83bInformesWar/aa83b12t00/comboTipoDoc",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		rowStriping:true,
		inputText:true,
		ordered:false,
		blank:0
	});
	
	$('#comboTipoSol').rup_combo({
		source : "/aa83bInformesWar/aa83b03t00/comboSol?vivienda="+esViviendaSN,
		//sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"Id012", style:"css"},
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 200,
		rowStriping : true,
		inputText:true,
		ordered:true,
		blank:0
	});
	
	if (esViviendaSN!='N')
	{
		$("#comboTipoSol").rup_combo("blank", null);
	}
	$.rup_date({
		width: 400,
		from: "fecDesde",
		to: "fecHasta",
		minDate: $.rup_utils.createDate(01, 01, 1900),
		maxDate: new Date()
		});
	
	$("#table_bus").rup_table({
		url: "../busqueda",
		hasMaint: false,
		colNames: [
		           "",
		           "",
		           "",
		          $.rup.i18n.app.solicitudes.Solicitud,
		          $.rup.i18n.app.solicitudes.Nombre,
		          $.rup.i18n.app.solicitudes.Apellidos,
		          "",
		          $.rup.i18n.app.solicitudes.Fecha,
		          $.rup.i18n.app.solicitudes.TramiteActual
		          ],
		colModel: [
		   		{
					width:60,
					name: "tipoSol",
					label: "", 
					hidden:true
				},		           
		   		{
					width:60,
					name: "idAno",
					label: "", 
					hidden:true
				},
		   		{
					width:60,
					name: "id",
					label: "", 
					hidden:true
				},				
		{
			width:60,
			name: "solconcat",
			label: "solconcat", 
			sortable:true,
			report:true
		},		
		{
			width:60,
			name: "nombre",
			label: "nombre",
			report:true
		},
		{
			width:160,
			name: "apellidos", 
			label: "Apellidos", 
			sortable:true,
			report:true
		},
		{
			width:120,
			name: "fecAlta" + $.rup_utils.capitalizedLang(), label: "Fecha", sortable:true,
			hidden:true
		}
		,
		{
			width:120,
			name: "fecAltaOrd", label: "FechaOrd", sortable:true,
			report:true
		},
		{
			width:160,
			name: "desc" + $.rup_utils.capitalizedLang() + "Tram", label: "Estado", sortable:true,
			report:true
		}
		],
		model:"Aa83bBusqueda",
		loadOnStartUp: false,
		rowNum:20,
		usePlugins:["formEdit","filter","feedback","fluid","toolbar","report"],
		primaryKey: "solconcat",
        report: options_table_report,
        toolbar:{
        // Propiedades de configuración del plugin toolbar
        createDefaultToolButtons:false,
        buttons:[]
        },
		feedback:{
		// Propiedades de configuracion del plugin feedback
		}
		}).ready(function(){
			recargaFiltro();
		});
	
	$("#table_bus").on("rupTable_beforeEditRow", 
			function(deleteOptions, selectedRow)
			{
				if ($("#table_bus_filter_form").validate().checkForm()) {
		
					fila = $("#table_bus").rup_grid('getGridParam', 'selrow');
					obj = $("#table_bus").rup_grid('getRowData', fila);
					valor =  obj.tipoSol + ":" +
					         obj.idAno + ":" +
					         obj.id;
			
					var url = "";
					//HAB:2016:181
					if (obj.tipoSol=="HAB")
						url = "/aa83bInformesWar/viewADE/verADE?id="+valor;
					else if (obj.tipoSol=="ESF")
						url = "/aa83bInformesWar/viewESF/verESF?id="+valor;
					else if (obj.tipoSol=="ARR")
						url = "/aa83bInformesWar/viewARR/verARR?id="+valor;
					else alert ("Error al identificar el tipo de Solicitud");
					
					if (url != ""){
						url = url + "&pos="+$("#table_bus").rup_table('getSelectedLines');
						window.location.href = url;
					}
					return false;
				} else {
					return false;
				}
			});
	
	$("#table_bus").on("rupTable_beforeFilter", 
			function()
			{
				if ($("#table_bus_filter_form").validate().checkForm()) {
					return true;
				} else {
					return false;
				}
			});	
	
	$("#accordionBusqueda").rup_accordion({
			animated: "bounceslide",
			active: 0,
			autoHeight: false,
			collapsible: true}
	);
			
	
	jQuery("#table_bus_feedback").rup_feedback({ 
		type: "ok",
		closeLink: true,
		delay: 1000,
		fadeSpeed: 999999,
		block:true
	});
	
	$("#table_bus_filter_form").rup_validate({
		feedback:$("#table_bus_feedback"),
		liveCheckingErrors: true,
		rules:{
			"ano_sol":{digits:true},
			"fecDesde":{date:true},
			"fecHasta":{date:true}
			}
	});

	//$.extend($.validator.messages, $.rup.i18n.app.rup_validate.messages);	
});

/*
 * Gestiona la recarga del filtro que se haya guardado en sesion 
 */
function recargaFiltro(){
	//Recupera los datos de filtrado de sesion:
	if(filtroBusquedaSesion!=null){
		$("#nombre_sol").val(filtroBusquedaSesion.nombre_sol).change();
		$("#apellido1_sol").val(filtroBusquedaSesion.apellido1_sol).change();
		$("#apellido2_sol").val(filtroBusquedaSesion.apellido2_sol).change();
		$("#numero_dni").val(filtroBusquedaSesion.numero_dni).change();
		$("#ano_sol").val(filtroBusquedaSesion.ano_sol).change();
		$("#id_sol").val(filtroBusquedaSesion.id_sol).change();
		$("#numReg").val(filtroBusquedaSesion.numReg).change();		
		$("#listCerradas").prop("checked", filtroBusquedaSesion.listCerradas != null ? true : false );
		$("#comboTipoDoc").rup_combo("setRupValue",filtroBusquedaSesion.tipoDoc);
		$("#comboTipoSol").rup_combo("setRupValue",filtroBusquedaSesion.tipoSol);
		$("#idfase").rup_combo("setRupValue",filtroBusquedaSesion.idfase);
		$("#fecDesde").rup_date("setRupValue",filtroBusquedaSesion.fecDesde);
		$("#fecHasta").rup_date("setRupValue",filtroBusquedaSesion.fecHasta);
		if (filtroBusquedaSesion.idfase!= null && filtroBusquedaSesion.idfase!= 0){
			$("#idtramite").rup_combo("setRupValue",filtroBusquedaSesion.idtramite);
		}
	}
	
	/*
	 * Se realiza una primera carga de la tabla para actualizar datos de paginaciÃ³n, etc.
	 * (Es necesario para despuÃ©s poder cargar la pagina en que estaba) 
	 */
	   
		setTimeout(function(){ $("#table_bus").rup_table("reloadGrid",true);

	$("#table_bus").jqGrid().trigger("reloadGrid",[gridRequestDtoSesion]).on("jqGridAfterLoadComplete",function(){

    	if(idBusquedaSeleccionadoSesion!=''){
			$("#table_bus").rup_table("setSelection",idBusquedaSeleccionadoSesion);
			idBusquedaSeleccionadoSesion='';
			if(gridRequestDtoSesion && gridRequestDtoSesion!=null){
				$("#table_bus").rup_table("setGridParam",{rowNum:gridRequestDtoSesion.rows});
			}
    	}
	});}, 100);


}


function limpiar(){
	//Se limpia el filtro pero hay campos del formulario que esta inicializados
	$('input,select,textarea', $("#table_bus_filter_form")).rup_form("clearFields");
	
	document.getElementById("ano_sol").value=ano;
	$("#listCerradas").prop("checked", true );
	$('#comboLisCerradas').rup_combo("select","S");
	
	//se borran los mensajes de errores que se muestran en el feedback
	$("#table_bus_filter_form").validate().submitted = {};
	//se cierra el feedback
	$("#table_bus_feedback").rup_feedback("close");
	// se quitan las imagenes que marcan el error
	$(".rup-maint_validateIcon", $("#table_bus_filter_form")).remove();
}


function deshabilitaSolicitante ()
{
	$("#comboTipoDoc").rup_combo("select",0);
	document.getElementById("numero_dni").value="";
	document.getElementById("nombre_sol").value="";
	document.getElementById("apellido1_sol").value="";
	document.getElementById("apellido2_sol").value="";
	document.getElementById("numReg").value = "";
}

function deshabilitaSolicitud ()
{
	document.getElementById("id_sol").value="";	
}


function recargaComboFase()
{
	if ($("#listCerradas").prop("checked")){
		$('#comboLisCerradas').rup_combo("select","S");
	} else {
		$('#comboLisCerradas').rup_combo("select","N");
	}
}



