
jQuery(document).ready(function(){
	
	options_table_report = {
			buttons:[
				{id:"reports", i18nCaption:$.rup.i18n.app.botones.Exportar, right:true,
					buttons:[
						{ i18nCaption:"CSV", css:"csv", 
							url: "../busquedaComunicaciones/csvReport"
						},
						{ i18nCaption:"XLS", css:"xls", 
							url: "../busquedaComunicaciones/xlsReport"
						}/*,
						{ i18nCaption:"XLXS", css:"xls",
							url: "../busquedaComunicaciones/xlsxReport" 
						}*/
					 ]}					
					 
				]			
		};
		
	$("#table").rup_table({
		url: "../busquedaComunicaciones/jgrid",		
		hasMaint: false,
		colNames: [
			$.rup.i18n.app.solicitudes.Solicitud,
			$.rup.i18n.app.solicitudes.Nombre,
			$.rup.i18n.app.solicitudes.Apellidos,
			$.rup.i18n.app.solicitudes.Fecha,
			$.rup.i18n.app.solicitudes.Estado
			],
		colModel: [
		{
			width:60,
			name: "solicitud", label: "Solicitud", sortable:false
		},
		{
			width:80,
			name: "nombre", label: "Nombre", sortable:false},
		{
			width:160,
			name: "apellidos", label: "Apellidos", sortable:false},		
		{
			width:120,
			name: "fecha", label: "Fecha", sortable:false},
		{
			width:160,
			name: "descTramiteEs", label: "Estado", sortable:false}
		
		],
		loadOnStartUp: false,
		rowNum:20,
		usePlugins:[
		            "formEdit",
		            "filter",
		            "feedback",
		            "fluid",
		            "toolbar",
		            "report",
		            "multiselection"
		],
		primaryKey: "solicitud",
        report: options_table_report,

        toolbar:{
	        // Propiedades de configuración del plugin toolbar
	        createDefaultToolButtons:false,
	        newButtons:[	
				{ 
              		obj : { i18nCaption: $.rup.i18n.app.botones.AdjuntoRemito, css: "doc", index: 5 }, 
              		click : function(){
		              			if ($("#table").rup_table("getSelectedIds").selectedIds == undefined)
									alert ("Tiene que seleccionar al menos una linea");
								else{
									$("#seleccionados").val($("#table").rup_table("getSelectedIds").selectedIds);
									//alert ("seleccionados="+$("#seleccionados").val());
									window.location.href = "../busquedaComunicaciones/adjuntoRemito?seleccionados="+$("#table").rup_table("getSelectedIds").selectedIds+"&tramite="+$("#idtramite").val()+"&fase="+$("#idfase").val();
								}
              				}
				}
	                 ]
        },
		feedback:{
			 //Propiedades de configuración del plugin feedback
		},
		multiselection:{
			// Propiedades de configuracin del plugin multiselection
		}
		});
	
	setTimeout(function() {
		$('#table').rup_table('filter');
	}, 3500);
	
	
	$("#table").on("rupTable_beforeEditRow", 
		function(deleteOptions, selectedRow)
		{
			return false ;
		}
	);
		
	$.rup.i18n.base.rup_combo.blankNotDefined = "--Todas--";	
	
	$('#idfase').rup_combo({
		source : "/aa83bInformesWar/aa83b01v00/comboFase",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 200,
		rowStriping:true,
		inputText:true,
		ordered:false,
		blank:0
	});
	
	$('#idtramite').rup_combo({
		source : "/aa83bInformesWar/aa83b02t00/comboTramiteComunic",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 350,
		rowStriping:true,
		inputText:true,
		ordered:false,
		parent:["idfase"]
	});
	
	$.rup.i18n.base.rup_combo.blankNotDefined = $.rup.i18n.app.solicitudes.todas;//"--Todas--";
	
	$("#accordionBusqueda").rup_accordion({
		animated: "bounceslide",
		active: 0,
		autoHeight: false,
		collapsible: true}
	);
	
	function configureForm(){
		
		// Objeto de configuracion del componente.
		var configSettings = {};
		
		// Propiedades de configuracion por defecto comunes a todas las posibilidades de configuracion.
		var defaultConfigSettings = {
				feedback:$("#feedbackMensajes"),
				success:function(xhr){
					var obj = JSON.parse(xhr);
					total =obj.length;
					console.log (total);
					if (total != 0){
						$(accordionBusqueda).rup_accordion ("activate", true);
						$("#feedbackMensajes").rup_feedback("set","Se han encontrado "+total+" comunicaciones","ok");
						//Cargamos las solicitudes
						
					}else
						{$("#feedbackMensajes").rup_feedback("set","No se han encontrado comunicaciones, revise los criterios de búsqueda","ko");}
					
					}
		};
		// Creacion de la configuracion del componente de formulario
		var formConfigSettings = {
			ajaxForm:{
				url:$.rup.CTX_PATH+"/busquedaComunicaciones/ajax",
				success:function(xhr){
					$("#feedbackMensajes").rup_feedback("set","El formulario se ha enviado correctamente mediante un submit AJAX", "ok");
				}
			}
		};
		
		configSettings = $.extend(true, configSettings, defaultConfigSettings,{},formConfigSettings);
		
		// Se realiza la creacion del componente formulario
		$("#table_filter_form").rup_form(configSettings);
				
	}
	
	/*
	 * INICIALIZACION DEL FORMULARIO
	 */
	configureForm();
});
//Tipos de feedback
var FEEDBACK_TIPO_OK = "ok",
FEEDBACK_TIPO_ALERT = "alert",
FEEDBACK_TIPO_ERROR = "error";
function openFeedback(id, tipo, msg) {

	var delay = null;
	
	if (tipo === FEEDBACK_TIPO_OK) {
		delay = 5000;
	}
	else if (tipo === FEEDBACK_TIPO_ALERT) {
		delay = 8000;
	}else if(tipo==FEEDBACK_TIPO_ERROR){
		delay=8000;
	}
	
	$(id).rup_feedback("option", "delay", delay);
	$(id).rup_feedback("option", "type", tipo);
	$(id).rup_feedback("set", msg);
	
}


$("#table_toolbar_Button").on("click", function(event){
	var selection= $("#table").rup_table("getSelectedIds").selectedIds;
	abrirModal(selection);
});
	function abrirModal(selection){
		$("#preparing-file-modal").dialog({
			modal: true,
			buttons:[{
				text: $.rup.i18n.app.btnAceptar.Aceptar,
				click: function(){
					if(selection=="undefined" || selection==null){	
						openFeedback("#table_feedback"
			   					   , FEEDBACK_TIPO_ERROR
			   					   , $.rup.i18n.app.notificacion_correos.Seleccion);
					}else{
						var tipoRemesa=$("#tipoRemesa").val();
						if(tipoRemesa=="M"){
							if(selection.length > 30){
								enviarCorrespondencia(selection, tipoRemesa);
							}else{
								 openFeedback("#table_feedback"
					   					   , FEEDBACK_TIPO_ERROR
					   					   , $.rup.i18n.app.notificacion_correos.RemesaMasivaError);

							}
						}else{
							enviarCorrespondencia(selection, tipoRemesa);

						}
					}
					$(this).rup_dialog("close");
				}
				
			}]
			});
		
		
	}
	function enviarCorrespondencia(selection, tipoRemesa){
		 $.ajax({
	           type: "GET",
	           url: "../notificacionCorreos/correspondencia/" + tipoRemesa+"/"+selection,
	           success: function(data)
	           {
	        	   var response = JSON.parse(data);
	        	   response = JSON.parse(response);
	        	   if (response.status == 'ok') {
		        	   openFeedback("#table_feedback"
		   					   , FEEDBACK_TIPO_OK
		   					   , $.rup.i18n.app.notificacion_correos.MensajeExito);
		        	   $("#table").rup_table("reloadGrid", true);
	        	   } else {
	        		   var mensaje = response.expediente + ':<br>&nbsp;&nbsp;&nbsp;&nbsp;' + response.mensaje;
		        	   openFeedback("#table_feedback"
		   					   , FEEDBACK_TIPO_ERROR
		   					   , mensaje);
	        	   }
	           },
	           error: function(data){
	        	   openFeedback("#table_feedback"
	   					   , FEEDBACK_TIPO_ERROR
	   					   , $.rup.i18n.app.notificacion_correos.MensajeError);
	           }
		 
	         });
	}
	
