package com.ejie.aa83b.ejb;

//PARA EL ALTA EN PAPEL0
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.interceptor.Interceptors;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.interceptor.Interceptors;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b23t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83b34t00Service;
import com.ejie.aa83b.service.Aa83b35t00Service;
import com.ejie.aa83b.service.Aa83bTramitacionExpedienteService;
import com.ejie.aa83b.threadmonitor.Aa83bThreadmonitor;

/**
 * Este MDB escucha la cola de papel cero, donde llegan los documentos que manda
 * el CDAR. Puede recibir una de los siguientes tipos de notificaciones: 1.-
 * Solicitudes 2.- Subsanaciones de Requerimiento 3.- Aportaciones voluntarias
 */

@MessageDriven(activationConfig = { @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue") }, mappedName = "aa83b.aa83bTelematicaJMSQueue")
@TransactionManagement(TransactionManagementType.CONTAINER)
@javax.ejb.TransactionAttribute(TransactionAttributeType.NOT_SUPPORTED)
@Interceptors(value = SpringBeanAutowiringInterceptor.class)
public class A83BMonitorizacionTelematica implements MessageListener {

	private static final Logger logger = LoggerFactory
			.getLogger(A83BMonitorizacionTelematica.class);

	private static final long serialVersionUID = 1L;

	// Nuevo
	@Autowired
	private Aa83bTramitacionExpedienteService aa83bTramitacionExpedienteService;

	// Fin nuevo

	/**
	 * Recibe y procesa los elementos encolados en aa83b.aa83bTelematicaJMSQueue
	 * 
	 * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
	 */
	public void onMessage(Message msg) {

		// NUEVO
		System.out.println("Entramos en la clase onMessage con cambios!");
		System.out.println("Mensaje " + msg.toString());
		logger.info("MSG TELEMATICO " + msg.toString());
		Aa83bThreadmonitor threadMonitor = new Aa83bThreadmonitor(
				"INDETERMINADO");
		threadMonitor.setTramiteId(1L);
		threadMonitor.setFaseId(1L);

		try {

			System.out.println("Antes del IF");
			if (msg instanceof TextMessage) {

				// TextMessage message = (TextMessage) msg;
				System.out.println("Dentro del IF");
				// Aa83bEventoTramitacion eventoTramitacion =
				// Aa83bTramitacionUtils
				// .unmarshalEventoTramitacion(message.getText());
				// System.out.println("Despues del unmarshalEventoTramitacion");
				// threadMonitor = new Aa83bThreadmonitor(eventoTramitacion
				// .getMonitor().getThreadId(), new Long(eventoTramitacion
				// .getMonitor().getTraceNumber()),
				// eventoTramitacion.getFolderId());
				// System.out.println("Despues del threadMonitor=");
				// threadMonitor.setTramiteId(new Long(eventoTramitacion
				// .getTramite()));
				// threadMonitor.setFaseId(new
				// Long(eventoTramitacion.getFase()));

			}
			System.out.println("setMonitorService -1");
			// threadMonitor.setMonitorService(this.aa83b34t00Service);

			this.aa83bTramitacionExpedienteService
					.capturarEventoTelematico(msg);
			System.out.println("setMonitorService -4");
			msg.acknowledge();
			// threadMonitor.markMethodEndPoint(this.getClass().getName(),
			// "onMessage");
			System.out.println("setMonitorService -5");

			// } catch (Aa83bServiceException e) {
			// A83BMonitorizacionJMS.logger.error(this.getClass().getName(),
			// "onMessage", e + ":::" + e.getMessage());
			// } catch (Aa83bUnmarshalException e) {
			// A83BMonitorizacionJMS.logger.error(this.getClass().getName(),
			// "onMessage", e + ":::" + e.getMessage());
			// } catch (JMSException e) {
			// A83BMonitorizacionJMS.logger.error(this.getClass().getName(),
			// "onMessage", e + ":::" + e.getMessage());
		} catch (Exception e) {
			A83BMonitorizacionTelematica.logger.error(
					this.getClass().getName(), "onMessage",
					e + ":::" + e.getMessage());
			;
		}

	}

}
