package com.ejie.aa83b.ejb;

//PARA EL ALTA EN PAPEL0
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.interceptor.Interceptors;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.interceptor.Interceptors;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b23t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83b34t00Service;
import com.ejie.aa83b.service.Aa83b35t00Service;
import com.ejie.aa83b.service.Aa83bNotificacionesService;
import com.ejie.aa83b.service.Aa83bTramitacionExpedienteService;
import com.ejie.aa83b.threadmonitor.Aa83bThreadmonitor;

/**
 * Este MDB escucha la cola de papel cero, donde llegan los documentos que manda
 * el CDAR. Puede recibir una de los siguientes tipos de notificaciones: 1.-
 * Solicitudes 2.- Subsanaciones de Requerimiento 3.- Aportaciones voluntarias
 */

@MessageDriven(activationConfig = { @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue") }, mappedName = "aa83b.aa83bAcusesTelemJMSQueue")
@TransactionManagement(TransactionManagementType.CONTAINER)
@javax.ejb.TransactionAttribute(TransactionAttributeType.NOT_SUPPORTED)
@Interceptors(value = SpringBeanAutowiringInterceptor.class)
public class A83BMonitorizacionNotificaciones implements MessageListener {

	private static final Logger logger = LoggerFactory
			.getLogger(A83BMonitorizacionNotificaciones.class);

	private static final long serialVersionUID = 1L;

	// Nuevo
	@Autowired
	private Aa83bNotificacionesService aa83bNotificacionesService;

	// Fin nuevo

	/**
	 * Recibe y procesa los elementos encolados en aa83b.aa83bTelematicaJMSQueue
	 * 
	 * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
	 */
	public void onMessage(Message msg) {

		// NUEVO
		System.out
				.println("Recibimos la notificacion de la lectura de la comunicacin");
		System.out.println("Mensaje notificacin::: " + msg.toString());
		logger.info("MSG NOTIFICACION" + msg.toString());
		Aa83bThreadmonitor threadMonitor = new Aa83bThreadmonitor(
				"INDETERMINADO");
		threadMonitor.setTramiteId(1L);
		threadMonitor.setFaseId(1L);

		try {
			System.out.println("Antes del IF NOTIF");
			if (msg instanceof TextMessage) {
				System.out.println("Dentro del IF");
			}
			System.out.println("setMonitorService -1");
			this.aa83bNotificacionesService.capturarEventoNotificacion(msg);
			System.out.println("setMonitorService -4");
			msg.acknowledge();
			System.out.println("setMonitorService -5");

		} catch (Exception e) {
			A83BMonitorizacionNotificaciones.logger.error(this.getClass()
					.getName(), "onMessage", e + ":::" + e.getMessage());
			;
		}

	}

}
