package com.ejie.aa83b.control;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa83b.model.A83bMunicipio;
import com.ejie.aa83b.model.A83bPais;
import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83b04t00;
import com.ejie.aa83b.model.Aa83b07t00;
import com.ejie.aa83b.model.Aa83b07v00;
import com.ejie.aa83b.model.Aa83b10t00;
import com.ejie.aa83b.model.Aa83b12t00;
import com.ejie.aa83b.model.Aa83b17t00;
import com.ejie.aa83b.model.Aa83b19t00;
import com.ejie.aa83b.model.Aa83b22t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b26t00;
import com.ejie.aa83b.model.Aa83b27t00;
import com.ejie.aa83b.model.Aa83b28t00;
import com.ejie.aa83b.model.Aa83b30t00;
import com.ejie.aa83b.model.Aa83b32t00;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.model.Aa83b35t00;
import com.ejie.aa83b.model.Aa83b39t00;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.service.Aa83b04t00Service;
import com.ejie.aa83b.service.Aa83b07t00Service;
import com.ejie.aa83b.service.Aa83b10t00Service;
import com.ejie.aa83b.service.Aa83b12t00Service;
import com.ejie.aa83b.service.Aa83b17t00Service;
import com.ejie.aa83b.service.Aa83b19t00Service;
import com.ejie.aa83b.service.Aa83b22t00Service;
import com.ejie.aa83b.service.Aa83b23t00Service;
import com.ejie.aa83b.service.Aa83b26t00Service;
import com.ejie.aa83b.service.Aa83b27t00Service;
import com.ejie.aa83b.service.Aa83b28t00Service;
import com.ejie.aa83b.service.Aa83b30t00Service;
import com.ejie.aa83b.service.Aa83b32t00Service;
import com.ejie.aa83b.service.Aa83b34t00Service;
import com.ejie.aa83b.service.Aa83b35t00Service;
import com.ejie.aa83b.service.Aa83b39t00Service;
import com.ejie.aa83b.service.Aa83bNoraService;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.json.MessageWriter;

/**
 * PatronesController
 * 
 * @author UDA
 */
@Controller()
@RequestMapping(value = "/viewESF")
public class Aa83bViewESFController {

	/** The service. */
	@Autowired()
	private Aa83b23t00Service aa83b23t00Service;

	/** The service. */
	@Autowired()
	private Aa83b07t00Service aa83b07t00Service;

	/** The service. */
	@Autowired()
	private Aa83b10t00Service aa83b10t00Service;

	/** The service. */
	// @Autowired()
	// private Aa83b01t00Service aa83b01t00Service;

	/** The service. */
	@Autowired()
	private Aa83b28t00Service aa83b28t00Service;

	/** The service. */
	@Autowired()
	private Aa83b32t00Service aa83b32t00Service;

	/** The service. */
	@Autowired()
	private Aa83b04t00Service aa83b04t00Service;

	/** The service. */
	@Autowired()
	private Aa83b30t00Service aa83b30t00Service;

	/** The service. */
	@Autowired()
	private Aa83b22t00Service aa83b22t00Service;

	/** The service. */
	@Autowired()
	private Aa83b19t00Service aa83b19t00Service;

	/** The service. */
	@Autowired()
	private Aa83bNoraService aa83bNoraService;
	
	@Autowired()
	private Aa83b12t00Service aa83b12t00Service;
	
	@Autowired()
	private Aa83b39t00Service aa83b39t00Service;
	
	@Autowired()
	private Aa83b17t00Service aa83b17t00Service;
	
	@Autowired()
	private Aa83b26t00Service aa83b26t00Service;
	
	@Autowired()
	private Aa83b27t00Service aa83b27t00Service;
	
	@Autowired()
	private Aa83b34t00Service aa83b34t00Service;
	
	@Autowired()
	private Aa83b35t00Service aa83b35t00Service;
	
	@Autowired()
	private Properties appConfiguration;
	
	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Aa83bViewARRController.class);

	/**
	 * @param model Model
	 * @param idSol String
	 * @param popUp String
	 * @param accion String
	 * @param pos String
	 * @param procesarId String
	 * @param response HttpServletResponse
	 * @param session HttpSession
	 * @return ModelAndView
	 * @throws IOException e
	 */
	@SuppressWarnings(value="unchecked")
	@RequestMapping(value = { "verESF" }, method = RequestMethod.GET)
	// @RequestMapping(value = "/verESF", method = RequestMethod.POST)//GET
	public ModelAndView editaSolicitud2(
			Model model,
			@RequestParam(value = "id", required = false) String idSol,
			@RequestParam(value = "PopUp", required = false) String popUp,
			@RequestParam(value = "accion", required = false) String accion,
			@RequestParam(value = "pos", required = false) String pos,
			@RequestParam(value = "procesarId", required = false) String procesarId,
			HttpServletResponse response, HttpSession session) throws IOException {

		// String idSol = "ESF:2016:48";
		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		
		if (Aa83BConstants.VALUE_STR_SI.equalsIgnoreCase(popUp)){
			session.removeAttribute("PAGINACION_BUSQUEDA");
		} 
		
		JQGridResponseDto<Aa83b07v00> gridResponseDto = (JQGridResponseDto<Aa83b07v00> ) session.getAttribute("PAGINACION_BUSQUEDA");

		if (gridResponseDto != null) {
			try {

				String posicion = (String)gridResponseDto.getAdditionalParam("pos");
				if ( posicion != null) {
					gridResponseDto.removeAdditionalParam("pos");
				}
				gridResponseDto.addAdditionalParam("pos", pos);				
				model.addAttribute("gridResponseDto",new ObjectMapper().writeValueAsString(gridResponseDto));
			} catch (IOException e) {
				Aa83bViewESFController.logger.warn("Se ha producido un error al parsear el filtro guardado en sesion",e);
			}
		}	
		
		String[] trozos = idSol.split(":");
		// HAB:2016:176
		String ano_Sol = trozos[1];
		String num_Sol = trozos[2];

		Aa83b23t00 solicitudESF = new Aa83b23t00();
		solicitudESF.setIdAno023(Long.parseLong(ano_Sol));
		solicitudESF.setId023(Integer.parseInt(num_Sol));

		solicitudESF = this.aa83b23t00Service.find(solicitudESF);
		
		// Si estamos procesando un requerimiento de subsanacin de papel0
		this.procesarPapel0(procesarId, solicitudESF);
		
		if(!StringUtils.isNumericSpace(solicitudESF.getCalleIdComunic023())){
			Aa83bCalle calle=new Aa83bCalle();
			calle.setDs_o(solicitudESF.getCalleIdComunic023());
			calle.setProvincia_id(solicitudESF.getProvinciaComunic023());
			calle.setMunicipio_id(solicitudESF.getMunicipComunic023());
			calle=this.aa83bNoraService.findCallePorString(calle);
			if(StringUtils.isNotEmpty(calle.getId())){
				solicitudESF.setCalleIdComunic023(calle.getId());
			}
		}
		// Calculo el Estado
		Aa83b10t00 aa83b10t00 = new Aa83b10t00();
		aa83b10t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));
		aa83b10t00.setId023NumSol(Long.parseLong(solicitudESF.getId023().toString()));
		aa83b10t00.setIdAno023(solicitudESF.getIdAno023());

		List<Aa83b10t00> aa83b10t00Lista = this.aa83b10t00Service.findAllLike(aa83b10t00, null, null);

		solicitudESF.setAa83b10t00s(aa83b10t00Lista);
		// solicitudADE.setEstado_desc_es(aa83b02t00.getDescEs002());
		solicitudESF.setEstado_desc_es(aa83b10t00Lista.get(0).getId002TramStrEs());
		solicitudESF.setEstado_desc_eu(aa83b10t00Lista.get(0).getId002TramStrEu());

		// Sacamos los vinculos familiares
		Aa83b28t00 aa83b28t00 = new Aa83b28t00();
		aa83b28t00.setId023NumSol(Integer.parseInt(num_Sol));
		aa83b28t00.setIdAno023(Long.parseLong(ano_Sol));

		List<Aa83b28t00> vincuFamList = this.aa83b28t00Service.findAllLike(aa83b28t00, null, false);

		solicitudESF.setAa83b28t00s(vincuFamList);

		// Sacamos la documentaciom aportada
		List<Aa83b32t00> aa83b32t00List = new ArrayList<Aa83b32t00>();
		Aa83b32t00 aa83b32t00 = new Aa83b32t00();
		aa83b32t00.setIdAno023(solicitudESF.getIdAno023());
		aa83b32t00.setId023NumSol(solicitudESF.getId023());

		// Para recuperar la fase/tramite del documento que se recupera
		aa83b32t00.setConFaseTramite(true);
		aa83b32t00List = this.aa83b32t00Service.findAllLike(aa83b32t00, null, false);

		solicitudESF.setAa83b32t00s(aa83b32t00List);

		// Historial de Accesos
		Aa83b07t00 HistoAccesos = new Aa83b07t00();
		HistoAccesos.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));
		HistoAccesos.setId023NumSol(Integer.parseInt(num_Sol));
		HistoAccesos.setIdAno023(Long.parseLong(ano_Sol));

		List<Aa83b07t00> HistoAccesosList = this.aa83b07t00Service.findAllLike(HistoAccesos, null, false);

		// Historial de Tramitacion
		Aa83b10t00 HistoTram = new Aa83b10t00();
		HistoTram.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));
		HistoTram.setId023NumSol(Long.parseLong(num_Sol));
		HistoTram.setIdAno023(Long.parseLong(ano_Sol));

		List<Aa83b10t00> HistoTramList = this.aa83b10t00Service.findAllLike(HistoTram, null, false);

		int i = 0;
		if (HistoAccesosList.size() != 0) {
			for (i = 0; i < HistoAccesosList.size(); i++) {

				Aa83b07t00 aa83b07t00 = new Aa83b07t00();
				aa83b07t00 = HistoAccesosList.get(i);

				if (aa83b07t00.getTipoModif038().equals(Aa83BConstants.ACCESOS_ALTA)) {
					aa83b07t00.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_ALTA_TXT_ES);
					aa83b07t00.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_ALTA_TXT_EU);
				} else if (aa83b07t00.getTipoModif038().equals(Aa83BConstants.ACCESOS_CONSULTA)) {

					aa83b07t00.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_CONSULTA_TXT_ES);
					aa83b07t00.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_CONSULTA_TXT_EU);

				} else if (aa83b07t00.getTipoModif038().equals(Aa83BConstants.ACCESOS_MODIF)) {

					aa83b07t00.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_MODIF_TXT_ES);
					aa83b07t00.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_MODIF_TXT_EU);
				}
			}
		}

		solicitudESF.setAa83b07t00s(HistoAccesosList);
		solicitudESF.setIdFaseAct(HistoTramList.get(HistoTramList.size() - 1).getId001Fase());
		solicitudESF.setIdTramAct(HistoTramList.get(HistoTramList.size() - 1).getId002Tram());
		solicitudESF.setAa83b10t00s(HistoTramList);

		// buscamos la documentacion de la 31
		aa83b32t00.setId023NumSol(Integer.parseInt(num_Sol));
		List<Aa83b32t00> documentosOIds = this.aa83b32t00Service.findAllLike(aa83b32t00, null, false);
		solicitudESF.setAa83b32t00s(documentosOIds);

		List<Aa83b30t00> listaTiposDoc = aa83bSolicitudesUtil.getDocumentosOrdenadosAlf(this.aa83b30t00Service, Aa83BConstants.COD_ESF, 
				Aa83BConstants.COD_FASE_1, Aa83BConstants.COD_TRAM_1);
		solicitudESF.setAa83b30t00s(listaTiposDoc);
		
		
		// Sacamos la documentacion generada
		Aa83b22t00 aa83b22t00 = new Aa83b22t00();
		Aa83b04t00 aa83b04t00 = new Aa83b04t00();
		List<Aa83b22t00> aa83b22t00List = new ArrayList<Aa83b22t00>();

		aa83b22t00.setId023SolEsf(Integer.parseInt(num_Sol));
		aa83b22t00.setIdAno023(Long.parseLong(ano_Sol));
		aa83b22t00List = this.aa83b22t00Service.findAllLike(aa83b22t00, null, false);

		if (aa83b22t00List.size() != 0) {
			for (i = 0; i < aa83b22t00List.size(); i++) {
				aa83b04t00.setId004(aa83b22t00List.get(0).getId004TipoDocG());
				aa83b04t00 = this.aa83b04t00Service.find(aa83b04t00);
				aa83b22t00List.get(0).setAa83b04t00(aa83b04t00);
			}
		}
		solicitudESF.setAa83b22t00s(aa83b22t00List);
		// ** START ACCESO
		// Registramos el actor:

		// Introduzco un nuevo registro de Acceso
		this.aa83b07t00Service.add(aa83bSolicitudesUtil.guardarAccesoESF(solicitudESF, Aa83BConstants.ACCESOS_CONSULTA, "N"));

		// ** FIN ACCESO

		Aa83b19t00 aa83b19t00 = new Aa83b19t00();
		aa83b19t00.setActivoSn019("S");
		aa83b19t00.setIdCargo005(Integer.parseInt(this.appConfiguration.getProperty("idFirmaTecnico")));
		List<Aa83b19t00> aa83b19t00ListTecnicos = this.aa83b19t00Service.findAll(aa83b19t00, null);

		aa83b19t00ListTecnicos.removeAll(aa83bSolicitudesUtil.getTecnicosCaducados(aa83b19t00ListTecnicos));
		solicitudESF.setAa83b19t00sTecnicos(aa83b19t00ListTecnicos);

		aa83b19t00.setIdCargo005(Integer.parseInt(this.appConfiguration.getProperty("idFirmaDirector")));
		List<Aa83b19t00> aa83b19t00ListDirector = this.aa83b19t00Service.findAll(aa83b19t00, null);
		aa83b19t00ListDirector.removeAll(aa83bSolicitudesUtil.getDirectoresCaducados(aa83b19t00ListDirector));
		solicitudESF.setAa83b19t00sDirectores(aa83b19t00ListDirector);
		
		// solicitudESF.setAccion(Aa83BConstants.ACC_SOL_VIEW);
		if (Aa83BConstants.ACC_SOL_ALTA.equals(accion)) {
			solicitudESF.setAccion(Aa83BConstants.ACC_SOL_TRASALTA);
		} else if (Aa83BConstants.ACC_SOL_EDIT.equals(accion)) {
			solicitudESF.setAccion(Aa83BConstants.ACC_SOL_TRASMODIFICAR);
		} else {
			solicitudESF.setAccion(Aa83BConstants.ACC_SOL_VIEW);
		}
		model.addAttribute(solicitudESF);

		String pagina = "altaSolESF";
		if (popUp != null){
			if (popUp.equals(Aa83BConstants.VALUE_STR_SI)) {
				pagina = "verESFPopUp";
				solicitudESF.setAccion(Aa83BConstants.ACC_SOL_POPUP);
			}
		}
		
		Locale locale = LocaleContextHolder.getLocale();
		String localeCapitalized = WordUtils.capitalize(locale.getLanguage());
		model.addAttribute("labelTipoDocumentos", "desc" + localeCapitalized + "012");
		List<Aa83b12t00> tipoDocumentos = this.aa83b12t00Service.findAllActive(null, null);
		model.addAttribute("tipoDocumentos", tipoDocumentos);
		
		model.addAttribute("labelTipoNotificacion", "desc" + localeCapitalized + "039");
		List<Aa83b39t00> tipoNotificaciones = this.aa83b39t00Service.findAll(null, null);
		model.addAttribute("tipoNotificaciones", tipoNotificaciones);
		
		model.addAttribute("labelGenero", "desc" + localeCapitalized + "017");
		List<Aa83b17t00> generos = this.aa83b17t00Service.findAll(null, null);
		model.addAttribute("generos", generos);
		
		model.addAttribute("labelMotivosSolicitud", "desc" + localeCapitalized + "026");
		List<Aa83b26t00> motivosSolicitud = this.aa83b26t00Service.findAll(null, null);
		model.addAttribute("motivosSolicitud", motivosSolicitud);
		
		model.addAttribute("labelEstadosEsfuerzo", "desc" + localeCapitalized + "027");
		List<Aa83b27t00> estadosEsfuerzo = this.aa83b27t00Service.findAll(null, null);
		model.addAttribute("estadosEsfuerzo", estadosEsfuerzo);		
				
		List<A83bPais> paises = this.aa83bNoraService.findPaises(null, null);
		model.addAttribute("paises", paises);
		
		A83bProvincia provincia = new A83bProvincia();
		provincia.setAutonomia_id(Aa83BConstants.COD_COM_EUS);
		List<A83bProvincia> provincias = this.aa83bNoraService.findProvincias(provincia, null);
		model.addAttribute("provincias", provincias);
				
		A83bMunicipio municipioComunic = new A83bMunicipio();
		municipioComunic.setDs_o("");
		municipioComunic.setId(solicitudESF.getMunicipComunic023());
		String provComunicSolicitud = solicitudESF.getProvinciaComunic023();
		if (provComunicSolicitud == null || provComunicSolicitud.equals("0")) {
			provComunicSolicitud = ((A83bProvincia)provincias.get(0)).getId();
		}
		municipioComunic.setProvincia_id(provComunicSolicitud);
		List<A83bMunicipio> municipiosComunic = this.aa83bNoraService.findMunicipios(municipioComunic, null);
		model.addAttribute("municipiosComunic", municipiosComunic);
		
		A83bMunicipio localidadEmpad = new A83bMunicipio();
		localidadEmpad.setDs_o("");
		localidadEmpad.setId(solicitudESF.getLocalidadEmp023());
		String provEmpSolicitud = solicitudESF.getProvEmp023();
		if (provEmpSolicitud == null || provEmpSolicitud.equals("0")) {
			provEmpSolicitud = ((A83bProvincia)provincias.get(0)).getId();
		}
		localidadEmpad.setProvincia_id(provEmpSolicitud);
		List<A83bMunicipio> localidadesEmpad = this.aa83bNoraService.findMunicipios(localidadEmpad, null);
		model.addAttribute("localidadesEmpad", localidadesEmpad);
				
		A83bMunicipio localidadExped = new A83bMunicipio();
		localidadExped.setDs_o("");
		localidadExped.setId(solicitudESF.getMunicipioEmpadron023());
		String provExpedSolicitud = solicitudESF.getProvinciaEmpadron023();
		if (provExpedSolicitud == null || provExpedSolicitud.equals("0")) {
			provExpedSolicitud = ((A83bProvincia)provincias.get(0)).getId();
		}
		localidadExped.setProvincia_id(provExpedSolicitud);
		List<A83bMunicipio> localidadesExped = this.aa83bNoraService.findMunicipios(localidadExped, null);
		model.addAttribute("localidadesExped", localidadesExped);

		return new ModelAndView(pagina, "Aa83b23t00", solicitudESF);

	}
	
	/**
	 * @param procesarId String
	 * @param solicitudESF Aa83b23t00
	 */
	private void procesarPapel0(String procesarId, Aa83b23t00 solicitudESF){
		if (procesarId != null) {
			Aa83b34t00 papel0 = new Aa83b34t00();
			papel0.setCodsolic034(new Long(procesarId));
			papel0 = this.aa83b34t00Service.find(papel0);
			Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
			Aa83b32t00 aa83b32t00 = new Aa83b32t00();
			aa83b32t00.setId023NumSol(solicitudESF.getId023());
			Aa83b35t00 documentos = new Aa83b35t00();
			documentos.setAa83b34t00(papel0);
			List<Aa83b35t00> listaDocs = this.aa83b35t00Service.findAll(documentos, null);
			List<Aa83b32t00> lista = solicitudESF.getAa83b32t00s();
			for (int i = 0; i < listaDocs.size(); i++) {
				Aa83b32t00 documento = new Aa83b32t00();
				documento.setOid032Papel0(listaDocs.get(i).getOid035());
				List<Aa83b32t00> docsConOid = this.aa83b32t00Service.findAllLike(documento, null, false);
				if (docsConOid.size() == 0) {
					documento.setId023NumSol(solicitudESF.getId023());
					documento.setIdAno023(solicitudESF.getIdAno023());
					documento.setOid032Papel0(((Aa83b35t00) listaDocs.get(i)).getOid035());
					Aa83b10t00 aa83b10t00 = this.aa83b10t00Service.add(aa83bSolicitudesUtil
							.guardarHistoESF(solicitudESF, Aa83BConstants.COD_FASE_1, Aa83BConstants.COD_TRAM_4, "N"));
					documento.setId010HistoTram(aa83b10t00.getId010());
					
					this.aa83b32t00Service.add(documento);
					lista.add(documento);
				}
			}
			
			papel0.setSituacion034("P");
			this.aa83b34t00Service.update(papel0);
		}
	}
}
