package com.ejie.aa83b.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa83b.model.A83bMunicipio;
import com.ejie.aa83b.model.A83bPais;
import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83b04t00;
import com.ejie.aa83b.model.Aa83b07v00;
import com.ejie.aa83b.model.Aa83b08t00;
import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.model.Aa83b12t00;
import com.ejie.aa83b.model.Aa83b17t00;
import com.ejie.aa83b.model.Aa83b19t00;
import com.ejie.aa83b.model.Aa83b24t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83b29t00;
import com.ejie.aa83b.model.Aa83b30t00;
import com.ejie.aa83b.model.Aa83b33t00;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.model.Aa83b35t00;
import com.ejie.aa83b.model.Aa83b39t00;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.service.Aa83b04t00Service;
import com.ejie.aa83b.service.Aa83b08t00Service;
import com.ejie.aa83b.service.Aa83b11t00Service;
import com.ejie.aa83b.service.Aa83b12t00Service;
import com.ejie.aa83b.service.Aa83b17t00Service;
import com.ejie.aa83b.service.Aa83b19t00Service;
import com.ejie.aa83b.service.Aa83b24t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83b29t00Service;
import com.ejie.aa83b.service.Aa83b30t00Service;
import com.ejie.aa83b.service.Aa83b33t00Service;
import com.ejie.aa83b.service.Aa83b34t00Service;
import com.ejie.aa83b.service.Aa83b35t00Service;
import com.ejie.aa83b.service.Aa83b39t00Service;
import com.ejie.aa83b.service.Aa83bNoraService;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * PatronesController
 * 
 * @author UDA
 */
@Controller()
@RequestMapping(value = "/viewARR")
public class Aa83bViewARRController {

	/** The service. */
	@Autowired()
	private Aa83b25t00Service aa83b25t00Service;

	/** The service. */
	@Autowired()
	private Aa83b29t00Service aa83b29t00Service;

	/** The service. */
	@Autowired()
	private Aa83b33t00Service aa83b33t00Service;
	
	@Autowired()
	private Aa83b34t00Service aa83b34t00Service;
	
	@Autowired()
	private Aa83b35t00Service aa83b35t00Service;

	/** The service. */
	@Autowired()
	private Aa83b08t00Service aa83b08t00Service;

	/** The service. */
	@Autowired()
	private Aa83b11t00Service aa83b11t00Service;
	/** The service. */
	@Autowired()
	private Aa83b04t00Service aa83b04t00Service;
	/** The service. */
	@Autowired()
	private Aa83b30t00Service aa83b30t00Service;

	/** The service. */
	@Autowired()
	private Aa83b19t00Service aa83b19t00Service;

	/** The service. */
	@Autowired()
	private Aa83b24t00Service aa83b24t00Service;

	/** The service. */
	@Autowired()
	private Aa83bNoraService aa83bNoraService;
	
	@Autowired()
	private Aa83b12t00Service aa83b12t00Service;
	
	@Autowired()
	private Aa83b39t00Service aa83b39t00Service;
	
	@Autowired()
	private Aa83b17t00Service aa83b17t00Service;
	
	@Autowired()
	private Properties appConfiguration;

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Aa83bViewARRController.class);	
	
	/**
	 * @param model Model
	 * @param idSol String
	 * @param popUp String
	 * @param accion String
	 * @param pos String
	 * @param procesarId String
	 * @param response HttpServletResponse
	 * @param session HttpSession
	 * @return ModelAndView
	 * @throws IOException e
	 */
	@RequestMapping(value = "/verARR", method = RequestMethod.GET)
	public ModelAndView editaSolicitud2(Model model,
			@RequestParam(value = "id", required = false) String idSol,
			@RequestParam(value = "PopUp", required = false) String popUp,
			@RequestParam(value = "accion", required = false) String accion,
			@RequestParam(value = "pos", required = false) String pos,
			@RequestParam(value = "procesarId", required = false) String procesarId,
			HttpServletResponse response, HttpSession session) throws IOException {

		if (Aa83BConstants.VALUE_STR_SI.equalsIgnoreCase(popUp)){
			session.removeAttribute("PAGINACION_BUSQUEDA");
		} 

		JQGridResponseDto<Aa83b07v00> gridResponseDto = (JQGridResponseDto<Aa83b07v00> ) session.getAttribute("PAGINACION_BUSQUEDA");
		
		if (gridResponseDto != null) {
			try {

				String posicion = (String)gridResponseDto.getAdditionalParam("pos");
				if ( posicion != null) {
					gridResponseDto.removeAdditionalParam("pos");
				}
				gridResponseDto.addAdditionalParam("pos", pos);				
				model.addAttribute("gridResponseDto",new ObjectMapper().writeValueAsString(gridResponseDto));
			} catch (IOException e) {
				Aa83bViewARRController.logger.warn("Se ha producido un error al parsear el filtro guardado en sesion",e);
			}
		}

		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		String[] trozos = idSol.split(":");

		String ano_Sol = trozos[1];
		String num_Sol = trozos[2];

		Aa83b25t00 solicitudARR = new Aa83b25t00();
		solicitudARR.setIdAno025(Long.parseLong(ano_Sol));
		solicitudARR.setId025(Integer.parseInt(num_Sol));

		solicitudARR = this.aa83b25t00Service.find(solicitudARR);
		
		this.procesarPapel0(procesarId, solicitudARR);
		
		if(!StringUtils.isNumericSpace(solicitudARR.getCalleIdComunic025())){
			Aa83bCalle calle=new Aa83bCalle();
			calle.setDs_o(solicitudARR.getCalleIdComunic025());
			calle.setProvincia_id(solicitudARR.getProvinciaComunic025());
			calle.setMunicipio_id(solicitudARR.getMunicipComunic025());
			calle=this.aa83bNoraService.findCallePorString(calle);
			if(StringUtils.isNotEmpty(calle.getId())){
				solicitudARR.setCalleIdComunic025(calle.getId());
			}
		}
		// Calculo el Estado
		Aa83b11t00 aa83b11t00 = new Aa83b11t00();
		aa83b11t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
		aa83b11t00.setId025NumSol(solicitudARR.getId025());
		aa83b11t00.setIdAnoSol025(solicitudARR.getIdAno025());

		List<Aa83b11t00> aa83b11t00Lista = this.aa83b11t00Service.findAllLike(aa83b11t00, null, null);

		solicitudARR.setAa83b11t00s(aa83b11t00Lista);
		// solicitudADE.setEstado_desc_es(aa83b02t00.getDescEs002());
		solicitudARR.setEstado_desc_es(aa83b11t00Lista.get(0).getId002TramStrEs());
		solicitudARR.setEstado_desc_eu(aa83b11t00Lista.get(0).getId002TramStrEu());

		// Sacamos los vinculos familiares
		Aa83b29t00 aa83b29t00 = new Aa83b29t00();
		aa83b29t00.setId025NumSol(Integer.parseInt(num_Sol));
		aa83b29t00.setIdAno025(Long.parseLong(ano_Sol));

		List<Aa83b29t00> vincuFamList = this.aa83b29t00Service.findAllLike(aa83b29t00, null, false);

		solicitudARR.setAa83b29t00s(vincuFamList);

		// Sacamos la documentaciom aportada
		List<Aa83b33t00> aa83b33t00List = new ArrayList<Aa83b33t00>();
		Aa83b33t00 aa83b33t00 = new Aa83b33t00();

		aa83b33t00.setIdAno025(solicitudARR.getIdAno025());
		aa83b33t00.setId025NumSol(solicitudARR.getId025());
		// Para recuperar la fase/tramite del documento que se recupera
		aa83b33t00.setConFaseTramite(true);
		aa83b33t00List = this.aa83b33t00Service.findAllLike(aa83b33t00, null, false);

		solicitudARR.setAa83b33t00s(aa83b33t00List);

		// Historial de Accesos
		Aa83b08t00 HistoAccesos = new Aa83b08t00();
		HistoAccesos.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
		HistoAccesos.setId025NumSol(Integer.parseInt(num_Sol));
		HistoAccesos.setIdAno025(Long.parseLong(ano_Sol));

		List<Aa83b08t00> HistoAccesosList = this.aa83b08t00Service.findAllLike(HistoAccesos, null, false);

		// Historial de Tramitacion
		Aa83b11t00 HistoTram = new Aa83b11t00();
		HistoTram.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
		HistoTram.setId025NumSol(Integer.parseInt(num_Sol));
		HistoTram.setIdAnoSol025(Long.parseLong(ano_Sol));

		List<Aa83b11t00> HistoTramList = this.aa83b11t00Service.findAllLike(HistoTram, null, false);

		int i = 0;
		if (HistoAccesosList.size() != 0) {
			for (i = 0; i < HistoAccesosList.size(); i++) {

				Aa83b08t00 aa83b08t00 = HistoAccesosList.get(i);

				if (aa83b08t00.getTipoModif038().equals(Aa83BConstants.ACCESOS_ALTA)) {
					aa83b08t00.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_ALTA_TXT_ES);
					aa83b08t00.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_ALTA_TXT_EU);
				} else if (aa83b08t00.getTipoModif038().equals(Aa83BConstants.ACCESOS_CONSULTA)) {

					aa83b08t00.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_CONSULTA_TXT_ES);
					aa83b08t00.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_CONSULTA_TXT_EU);

				} else if (aa83b08t00.getTipoModif038().equals(Aa83BConstants.ACCESOS_MODIF)) {

					aa83b08t00.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_MODIF_TXT_ES);
					aa83b08t00.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_MODIF_TXT_EU);
				}
			}
		}

		solicitudARR.setAa83b08t00s(HistoAccesosList);

		// if (HistoTramList.size() != 0) {
		// for (i = 0; i < HistoTramList.size(); i++) {
		//
		// Aa83b11t00 aa83b11t00 = new Aa83b11t00();
		// aa83b11t00 = HistoTramList.get(i);
		// Aa83b02t00 aa83b02t00 = new Aa83b02t00();
		// List<Aa83b02t00> aa83b02t00List = new ArrayList<Aa83b02t00>();
		//
		// aa83b02t00.setId001Fase(aa83b11t00.getId001Fase());
		// aa83b02t00.setId002(aa83b11t00.getId002Tram());
		// aa83b02t00.setId003TipoSol(Integer
		// .parseInt(Aa83BConstants.COD_ARR));
		//
		// aa83b02t00List = aa83b02t00Service.findAllLike(aa83b02t00,
		// null, false);
		//
		// if (aa83b02t00List.size() != 0) {
		// aa83b02t00 = aa83b02t00List.get(0);
		// HistoTramList.get(i).setId002TramStrEs(
		// aa83b02t00.getDescEs002());
		// HistoTramList.get(i).setId002TramStrEu(
		// aa83b02t00.getDescEu002());
		// Aa83b01t00 aa83b01t00 = new Aa83b01t00();
		// aa83b01t00.setId001(aa83b11t00.getId001Fase());
		// aa83b01t00.setIdTipoSol(Integer
		// .parseInt(Aa83BConstants.COD_ARR));
		//
		// aa83b01t00 = aa83b01t00Service.find(aa83b01t00);
		// HistoTramList.get(i).setId001FaseStrEs(
		// aa83b01t00.getDescEs001());
		// HistoTramList.get(i).setId001FaseStrEu(
		// aa83b01t00.getDescEu001());
		// }
		// }
		// }

		solicitudARR.setIdFaseAct(HistoTramList.get(HistoTramList.size() - 1).getId001Fase());
		solicitudARR.setIdTramAct(HistoTramList.get(HistoTramList.size() - 1).getId002Tram());

		solicitudARR.setAa83b11t00s(HistoTramList);
		// Documentacion
		// buscamos la documentacion de la 31
		aa83b33t00.setId025NumSol(Integer.parseInt(num_Sol));

		/*
		 * Aa83b33t00 documento = new Aa83b33t00(); for (int c = 0; c <
		 * aa83b33t00List.size(); c++) { documento = aa83b33t00List.get(c); //
		 * ahora guardamos los documentos como files // las creamos en el file
		 * // se recoge de la 04 pero no deberia if
		 * (!Aa83BConstants.OID_VACIO.equals(documento.getOid033Papel0())) {
		 * Aa83b04t00 objeto04 = new Aa83b04t00(); objeto04.setId004(new
		 * Integer(documento.getOid033Papel0())); objeto04 =
		 * aa83b04t00Service.find(objeto04); // vamos a insertar los ficheros en
		 * la carpeta temporal
		 * 
		 * Blob blob = objeto04.getTemplate004(); try { File blobFile = new
		 * File( this.appConfiguration .getProperty("tempFicherosGuardar.path")
		 * + "/" + objeto04.getId004() + ".pdf");// se // supone // que // va //
		 * el // oid objeto04.setNomTemplate004(this.appConfiguration
		 * .getProperty("tempFicheros.path") + "/" + objeto04.getId004() +
		 * ".pdf");
		 * 
		 * FileOutputStream outStream = new FileOutputStream(blobFile);
		 * InputStream inStream = blob.getBinaryStream();
		 * 
		 * int length = -1; int size = 10000; byte[] buffer = new byte[size];
		 * 
		 * while ((length = inStream.read(buffer)) != -1) {
		 * outStream.write(buffer, 0, length); outStream.flush(); }
		 * 
		 * inStream.close(); outStream.close(); } catch (Exception e) {
		 * e.printStackTrace(); System.out.printlns("ERROR GUARDAR!");//
		 * +filename); } }
		 * 
		 * }
		 */
		
		List<Aa83b30t00> listaTiposDoc = aa83bSolicitudesUtil.getDocumentosOrdenadosAlf(this.aa83b30t00Service, Aa83BConstants.COD_ARR, 
				Aa83BConstants.COD_FASE_1, Aa83BConstants.COD_TRAM_1);
		solicitudARR.setAa83b30t00s(listaTiposDoc);
		
		// Sacamos la documentacion generada
		Aa83b24t00 aa83b24t00 = new Aa83b24t00();
		Aa83b04t00 aa83b04t00 = new Aa83b04t00();
		List<Aa83b24t00> aa83b24t00List = new ArrayList<Aa83b24t00>();

		aa83b24t00.setIdNumSol025(Integer.parseInt(num_Sol));
		aa83b24t00.setIdAno025(Long.parseLong(ano_Sol));
		aa83b24t00List = this.aa83b24t00Service.findAllLike(aa83b24t00, null, false);

		if (aa83b24t00List.size() != 0) {
			for (i = 0; i < aa83b24t00List.size(); i++) {
				aa83b04t00.setId004(aa83b24t00List.get(0).getId004TipoDocG());
				aa83b04t00 = this.aa83b04t00Service.find(aa83b04t00);
				aa83b24t00List.get(0).setAa83b04t00(aa83b04t00);
			}
		}
		solicitudARR.setAa83b24t00s(aa83b24t00List);

		// public ModelAndView(String viewName, String modelName, Object
		// modelObject)
		// solicitudARR.setAccion(Aa83BConstants.ACC_SOL_VIEW);

		// ** START ACCESO
		// Registramos el actor:
		this.aa83b08t00Service.add(aa83bSolicitudesUtil.guardarAccesoARR(solicitudARR, Aa83BConstants.ACCESOS_CONSULTA, "N"));

		Aa83b19t00 aa83b19t00 = new Aa83b19t00();
		aa83b19t00.setActivoSn019("S");
		aa83b19t00.setIdCargo005(Integer.parseInt(this.appConfiguration.getProperty("idFirmaTecnico")));
		List<Aa83b19t00> aa83b19t00ListTecnicos = this.aa83b19t00Service.findAll(aa83b19t00, null);

		aa83b19t00ListTecnicos.removeAll(aa83bSolicitudesUtil.getTecnicosCaducados(aa83b19t00ListTecnicos));
		solicitudARR.setAa83b19t00sTecnicos(aa83b19t00ListTecnicos);

		aa83b19t00.setIdCargo005(Integer.parseInt(this.appConfiguration.getProperty("idFirmaDirector")));
		List<Aa83b19t00> aa83b19t00ListDirector = this.aa83b19t00Service.findAll(aa83b19t00, null);
		aa83b19t00ListDirector.removeAll(aa83bSolicitudesUtil.getDirectoresCaducados(aa83b19t00ListDirector));
		solicitudARR.setAa83b19t00sDirectores(aa83b19t00ListDirector);

		if (Aa83BConstants.ACC_SOL_ALTA.equals(accion)) {
			solicitudARR.setAccion(Aa83BConstants.ACC_SOL_TRASALTA);
		} else if (Aa83BConstants.ACC_SOL_EDIT.equals(accion)) {
			solicitudARR.setAccion(Aa83BConstants.ACC_SOL_TRASMODIFICAR);
		} else {
			solicitudARR.setAccion(Aa83BConstants.ACC_SOL_VIEW);
		}

		// ** FIN ACCESO
		String pagina = "altaSolARR";
		if (popUp != null){
			if (popUp.equals(Aa83BConstants.VALUE_STR_SI)) {
				pagina = "verARRPopUp";
				solicitudARR.setAccion(Aa83BConstants.ACC_SOL_POPUP);
			}
		}
		
		Locale locale = LocaleContextHolder.getLocale();
		String localeCapitalized = WordUtils.capitalize(locale.getLanguage());
		model.addAttribute("labelTipoDocumentos", "desc" + localeCapitalized + "012");
		List<Aa83b12t00> tipoDocumentos = this.aa83b12t00Service.findAllActive(null, null);
		model.addAttribute("tipoDocumentos", tipoDocumentos);
		
		model.addAttribute("labelTipoNotificacion", "desc" + localeCapitalized + "039");
		List<Aa83b39t00> tipoNotificaciones = this.aa83b39t00Service.findAll(null, null);
		model.addAttribute("tipoNotificaciones", tipoNotificaciones);
		
		model.addAttribute("labelGenero", "desc" + localeCapitalized + "017");
		List<Aa83b17t00> generos = this.aa83b17t00Service.findAll(null, null);
		model.addAttribute("generos", generos);
						
		List<A83bPais> paises = this.aa83bNoraService.findPaises(null, null);
		model.addAttribute("paises", paises);
		
		A83bProvincia provincia = new A83bProvincia();
		provincia.setAutonomia_id(Aa83BConstants.COD_COM_EUS);
		List<A83bProvincia> provincias = this.aa83bNoraService.findProvincias(provincia, null);
		model.addAttribute("provincias", provincias);
				
		A83bMunicipio municipioComunic = new A83bMunicipio();
		municipioComunic.setDs_o("");
		municipioComunic.setId(solicitudARR.getMunicipComunic025());
		String provComunicSolicitud = solicitudARR.getProvinciaComunic025();
		if (provComunicSolicitud == null || provComunicSolicitud.equals("0")) {
			provComunicSolicitud = ((A83bProvincia)provincias.get(0)).getId();
		}
		municipioComunic.setProvincia_id(provComunicSolicitud);
		List<A83bMunicipio> municipiosComunic = this.aa83bNoraService.findMunicipios(municipioComunic, null);
		model.addAttribute("municipiosComunic", municipiosComunic);
		
		A83bMunicipio localidadEmpad = new A83bMunicipio();
		localidadEmpad.setDs_o("");
		localidadEmpad.setId(solicitudARR.getLocalidadEmp025());
		String provEmpSolicitud = solicitudARR.getProvEmp025();
		if (provEmpSolicitud == null || provEmpSolicitud.equals("0")) {
			provEmpSolicitud = ((A83bProvincia)provincias.get(0)).getId();
		}
		localidadEmpad.setProvincia_id(provEmpSolicitud);
		List<A83bMunicipio> localidadesEmpad = this.aa83bNoraService.findMunicipios(localidadEmpad, null);
		model.addAttribute("localidadesEmpad", localidadesEmpad);
		
		A83bMunicipio localidadExped = new A83bMunicipio();
		localidadExped.setDs_o("");
		localidadExped.setId(solicitudARR.getMunicipioEmpadron025());
		String provExpedSolicitud = solicitudARR.getProvinciaEmpadron025();
		if (provExpedSolicitud == null || provExpedSolicitud.equals("0")) {
			provExpedSolicitud = ((A83bProvincia)provincias.get(0)).getId();
		}
		localidadExped.setProvincia_id(provExpedSolicitud);
		List<A83bMunicipio> localidadesExped = this.aa83bNoraService.findMunicipios(localidadExped, null);
		model.addAttribute("localidadesExped", localidadesExped);
		
		// System.out.println("aa83b08t00" + aa83b08t00);
		return new ModelAndView(pagina, "Aa83b25t00", solicitudARR);

	}
	
	/**
	 * @param procesarId String
	 * @param solicitudARR Aa83b25t00
	 */
	private void procesarPapel0 (String procesarId, Aa83b25t00 solicitudARR){
		// Si estamos procesando un requerimiento de subsanacin de papel0
		if (procesarId != null) {
			Aa83b34t00 papel0 = new Aa83b34t00();
			papel0.setCodsolic034(new Long(procesarId));
			papel0 = aa83b34t00Service.find(papel0);
			Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
			Aa83b33t00 aa83b33t00 = new Aa83b33t00();
			aa83b33t00.setId025NumSol(solicitudARR.getId025());
			Aa83b35t00 documentos = new Aa83b35t00();
			documentos.setAa83b34t00(papel0);
			List<Aa83b35t00> listaDocs = aa83b35t00Service.findAll(documentos, null);
			List<Aa83b33t00> lista = solicitudARR.getAa83b33t00s();
			for (int i = 0; i < listaDocs.size(); i++) {
				Aa83b33t00 documento = new Aa83b33t00();
				documento.setOid033Papel0(listaDocs.get(i).getOid035());
				List<Aa83b33t00> docsConOid = aa83b33t00Service.findAllLike(documento, null, false);
				if (docsConOid.size() == 0) {
					documento.setId025NumSol(solicitudARR.getId025());
					documento.setIdAno025(solicitudARR.getIdAno025());
					documento.setOid033Papel0(((Aa83b35t00) listaDocs.get(i)).getOid035());
					Aa83b11t00 aa83b11t00 = aa83b11t00Service.add(aa83bSolicitudesUtil
							.guardarHistoARR(solicitudARR, Aa83BConstants.COD_FASE_1, Aa83BConstants.COD_TRAM_4, "N"));
					documento.setId011HistoTram(aa83b11t00.getId011());
					
					aa83b33t00Service.add(documento);
					lista.add(documento);
				}
			}
			
			papel0.setSituacion034("P");
			aa83b34t00Service.update(papel0);
		}
	}
}
