package com.ejie.aa83b.control;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa83b.model.A83bMunicipio;
import com.ejie.aa83b.model.A83bPais;
import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83b04t00;
import com.ejie.aa83b.model.Aa83b06t00;
import com.ejie.aa83b.model.Aa83b07v00;
import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b12t00;
import com.ejie.aa83b.model.Aa83b13t00;
import com.ejie.aa83b.model.Aa83b14t00;
import com.ejie.aa83b.model.Aa83b15t00;
import com.ejie.aa83b.model.Aa83b16t00;
import com.ejie.aa83b.model.Aa83b17t00;
import com.ejie.aa83b.model.Aa83b18t00;
import com.ejie.aa83b.model.Aa83b19t00;
import com.ejie.aa83b.model.Aa83b20t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b30t00;
import com.ejie.aa83b.model.Aa83b31t00;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.model.Aa83b35t00;
import com.ejie.aa83b.model.Aa83b39t00;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.service.Aa83b04t00Service;
import com.ejie.aa83b.service.Aa83b06t00Service;
import com.ejie.aa83b.service.Aa83b09t00Service;
import com.ejie.aa83b.service.Aa83b12t00Service;
import com.ejie.aa83b.service.Aa83b13t00Service;
import com.ejie.aa83b.service.Aa83b14t00Service;
import com.ejie.aa83b.service.Aa83b15t00Service;
import com.ejie.aa83b.service.Aa83b16t00Service;
import com.ejie.aa83b.service.Aa83b17t00Service;
import com.ejie.aa83b.service.Aa83b18t00Service;
import com.ejie.aa83b.service.Aa83b19t00Service;
import com.ejie.aa83b.service.Aa83b20t00Service;
import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b30t00Service;
import com.ejie.aa83b.service.Aa83b31t00Service;
import com.ejie.aa83b.service.Aa83b34t00Service;
import com.ejie.aa83b.service.Aa83b35t00Service;
import com.ejie.aa83b.service.Aa83b39t00Service;
import com.ejie.aa83b.service.Aa83bNoraService;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.json.MessageWriter;

/**
 * PatronesController
 * 
 * @author UDA
 */
/**
 * @author blarreina
 *
 */
@Controller()
@RequestMapping(value = "/viewADE")
public class Aa83bViewADEController {

	/** The service. */
	@Autowired()
	private Aa83b19t00Service aa83b19t00Service;

	/** The service. */
	@Autowired()
	private Aa83b21t00Service aa83b21t00Service;

	/** The service. */
	@Autowired()
	private Aa83b06t00Service aa83b06t00Service;

	/** The service. */
	@Autowired()
	private Aa83b09t00Service aa83b09t00Service;

	/** The service. */
	@Autowired()
	private Aa83b04t00Service aa83b04t00Service;

	/** The service. */
	@Autowired()
	private Aa83b18t00Service aa83b18t00Service;

	/** The service. */
	@Autowired()
	private Aa83b13t00Service aa83b13t00Service;

	/** The service. */
	@Autowired()
	private Aa83b31t00Service aa83b31t00Service;
	/** The service. */
	@Autowired()
	private Aa83b30t00Service aa83b30t00Service;
	/** The service. */
	@Autowired()
	private Aa83b20t00Service aa83b20t00Service;

	/** The service. */
	@Autowired()
	private Aa83bNoraService aa83bNoraService;
	
	@Autowired()
	private Aa83b12t00Service aa83b12t00Service;
	
	@Autowired()
	private Aa83b39t00Service aa83b39t00Service;
	
	@Autowired()
	private Aa83b17t00Service aa83b17t00Service;
	
	@Autowired()
	private Aa83b15t00Service aa83b15t00Service;
	
	@Autowired()
	private Aa83b14t00Service aa83b14t00Service;
	
	@Autowired()
	private Aa83b16t00Service aa83b16t00Service;
	
	@Autowired()
	private Aa83b34t00Service aa83b34t00Service;
	
	@Autowired()
	private Aa83b35t00Service aa83b35t00Service;
	
	@Autowired()
	private Properties appConfiguration;

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Aa83bViewADEController.class);

	/**
	 * @param model Model
	 * @param idSol String
	 * @param response HttpServletResponse
	 * @return ModelAndView
	 * @throws IOException e
	 */
	@RequestMapping(value = "/GenerarInfResol", method = RequestMethod.GET)
	public ModelAndView generarInfResol(Model model,
			@RequestParam(value = "idSol", required = false) String idSol,
			HttpServletResponse response) throws IOException {

		String[] trozos = idSol.split(":");
		// HAB:2016:176
		String ano_Sol = trozos[1];
		String num_Sol = trozos[2];

		Aa83b21t00 solicitudADE = new Aa83b21t00();
		solicitudADE.setIdAno021(Long.parseLong(ano_Sol));
		solicitudADE.setId021(Integer.parseInt(num_Sol));

		solicitudADE = this.aa83b21t00Service.find(solicitudADE);
		if(!StringUtils.isNumericSpace(solicitudADE.getCalleIdComunic021())){
			Aa83bCalle calle=new Aa83bCalle();
			calle.setDs_o(solicitudADE.getCalleIdComunic021());
			calle.setProvincia_id(solicitudADE.getProvinciaComunic021());
			calle.setMunicipio_id(solicitudADE.getMunicipComunic021());
			calle=this.aa83bNoraService.findCallePorString(calle);
			if(StringUtils.isNotEmpty(calle.getId())){
				solicitudADE.setCalleIdComunic021(calle.getId());
			}
		}

		/*String xmlDatos = "<nombre>Inigo xml</nombre>";
		String plantilla = "/aa83bInformesWar/plantillasRTF/InfoADE.rtf";*/

		// String toPif = Aa83BConstants.RUTA_PIF + "InfoADE" + idSol + ".rtf";
		// String pif_plantilla = pifUtils.put(documentItemSesion, plantilla,
		// toPif);

		/*
		 * String pif_destino =
		 * this.appConfiguration.getProperty("RUTA_PIF_APP") + "documento.rtf";
		 * ruta = this.documentoWebServiceImpl.create(pif_xmlDatos,
		 * pif_plantilla, pif_destino);
		 * 
		 * return new ModelAndView("generarInforme", "Aa83b21t00",
		 * solicitudADE);
		 */
		return null;
	}


	/**
	 * @param model Model
	 * @param idSol String
	 * @param accion String
	 * @param popUp String
	 * @param pos String
	 * @param procesarId String
	 * @param response HttpServletResponse
	 * @param session HttpSession
	 * @return ModelAndView
	 * @throws IOException e
	 */
	@RequestMapping(value = "/verADE", method = RequestMethod.GET)
	public ModelAndView editaSolicitud2(Model model,
			@RequestParam(value = "id", required = false) String idSol,
			@RequestParam(value = "accion", required = false) String accion,
			@RequestParam(value = "PopUp", required = false) String popUp,
			@RequestParam(value = "pos", required = false) String pos,
			@RequestParam(value = "procesarId", required = false) String procesarId,
			HttpServletResponse response, HttpSession session) throws IOException {
			
		if (Aa83BConstants.VALUE_STR_SI.equalsIgnoreCase(popUp)){
			session.removeAttribute("PAGINACION_BUSQUEDA");
		} 
		
		JQGridResponseDto<Aa83b07v00> gridResponseDto = (JQGridResponseDto<Aa83b07v00> ) session.getAttribute("PAGINACION_BUSQUEDA");
		if (gridResponseDto != null) {
			try {

				String posicion = (String)gridResponseDto.getAdditionalParam("pos");
				if ( posicion != null) {
					gridResponseDto.removeAdditionalParam("pos");
				}
				gridResponseDto.addAdditionalParam("pos", pos);				
				model.addAttribute("gridResponseDto",new ObjectMapper().writeValueAsString(gridResponseDto));
			} catch (IOException e) {
				Aa83bViewADEController.logger.warn("Se ha producido un error al parsear el filtro guardado en sesion",e);
			}
		}		
		
		
		String[] trozos = idSol.split(":");
		String ano_Sol = trozos[1];
		String num_Sol = trozos[2];

		// NUEVO
		Aa83b21t00 solicitudADE = new Aa83b21t00();
		solicitudADE.setIdAno021(Long.parseLong(ano_Sol));
		solicitudADE.setId021(Integer.parseInt(num_Sol));
		solicitudADE = this.aa83b21t00Service.find(solicitudADE);
		
		this.procesarPapel0(procesarId, solicitudADE);
		
		// Calculo el Estado
		
		Aa83b09t00 aa83b09t00 = new Aa83b09t00();
		aa83b09t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
		aa83b09t00.setId021NumSol(solicitudADE.getId021());
		aa83b09t00.setIdAno021(solicitudADE.getIdAno021());

		List<Aa83b09t00> aa83b09t00Lista = this.aa83b09t00Service.findAllLike(aa83b09t00, null, false);
		solicitudADE.setAa83b09t00s(aa83b09t00Lista);
		// solicitudADE.setEstado_desc_es(aa83b02t00.getDescEs002());
		solicitudADE.setEstado_desc_es(aa83b09t00Lista.get(0).getId002TramStrEs());
		solicitudADE.setEstado_desc_eu(aa83b09t00Lista.get(0).getId002TramStrEu());
		// FIN NUEVO

		// Guardamos el registro de Acceso en modo "Consulta"
		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();

		this.aa83b06t00Service.add(aa83bSolicitudesUtil.guardarAccesoADE(solicitudADE, Aa83BConstants.ACCESOS_CONSULTA, "N"));

		// Sacamos las personas a reagrupar
		Aa83b18t00 aa83b18t00 = new Aa83b18t00();
		aa83b18t00.setId021NumSol(solicitudADE.getId021());
		aa83b18t00.setIdAno021(solicitudADE.getIdAno021());

		List<Aa83b18t00> aa83b18t00Lista = this.aa83b18t00Service.findAllLike(aa83b18t00, null, false);
		if (aa83b18t00Lista.size() != 0) {
			for (int r = 0; r < aa83b18t00Lista.size(); r++) {

				// Buscamos el Literal del Vinculo
				Aa83b13t00 aa83b13t00 = new Aa83b13t00();
				aa83b13t00.setId013(aa83b18t00Lista.get(r).getId013VinculosFam());
				// Añadimos a aa83b18t00s
				aa83b13t00 = this.aa83b13t00Service.find(aa83b13t00);

				aa83b18t00Lista.get(r).setId013VinculosFamStrEs(aa83b13t00.getDescEs013());
				aa83b18t00Lista.get(r).setId013VinculosFamStrEu(aa83b13t00.getDescEu013());
			}
			// Añadimos a aa83b18t00s
			solicitudADE.setAa83b18t00s(aa83b18t00Lista);
		}

		// Sacamos la documentacion aportada
		List<Aa83b31t00> aa83b31t00List = new ArrayList<Aa83b31t00>();
		Aa83b31t00 aa83b31t00 = new Aa83b31t00();
		aa83b31t00.setIdAno021(solicitudADE.getIdAno021());
		aa83b31t00.setId021NumSol(solicitudADE.getId021());
		// Para recuperar la fase/tramite del documento que se recupera
		aa83b31t00.setConFaseTramite(true);
		aa83b31t00List = this.aa83b31t00Service.findAllLike(aa83b31t00, null, false);
		solicitudADE.setAa83b31t00s(aa83b31t00List);

		// Historial de Accesos
		Aa83b06t00 HistoAccesos = new Aa83b06t00();
		HistoAccesos.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
		HistoAccesos.setId021NumSol(Integer.parseInt(num_Sol));
		HistoAccesos.setIdAno021(Long.parseLong(ano_Sol));

		List<Aa83b06t00> HistoAccesosList = this.aa83b06t00Service.findAllLike(HistoAccesos, null, false);

		// Historial de Tramitacion
		Aa83b09t00 HistoTram = new Aa83b09t00();
		HistoTram.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
		HistoTram.setId021NumSol(Integer.parseInt(num_Sol));
		HistoTram.setIdAno021(Long.parseLong(ano_Sol));

		List<Aa83b09t00> HistoTramList = this.aa83b09t00Service.findAllLike(
				HistoTram, null, false);

		int i = 0;
		if (HistoAccesosList.size() != 0) {
			for (i = 0; i < HistoAccesosList.size(); i++) {

				Aa83b06t00 aa83b06t00 = HistoAccesosList.get(i);

				if (aa83b06t00.getTipoModif038().equals(Aa83BConstants.ACCESOS_ALTA)) {
					aa83b06t00.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_ALTA_TXT_ES);
					aa83b06t00.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_ALTA_TXT_EU);
				} else if (aa83b06t00.getTipoModif038().equals(Aa83BConstants.ACCESOS_CONSULTA)) {

					aa83b06t00.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_CONSULTA_TXT_ES);
					aa83b06t00.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_CONSULTA_TXT_EU);

				} else if (aa83b06t00.getTipoModif038().equals(Aa83BConstants.ACCESOS_MODIF)) {

					aa83b06t00.setStrTipoActualizaEs(Aa83BConstants.ACCESOS_MODIF_TXT_ES);
					aa83b06t00.setStrTipoActualizaEu(Aa83BConstants.ACCESOS_MODIF_TXT_EU);
				}
			}
		}
		solicitudADE.setAa83b06t00s(HistoAccesosList);

		solicitudADE.setIdFaseAct(HistoTramList.get(HistoTramList.size() - 1).getId001Fase());
		solicitudADE.setIdTramAct(HistoTramList.get(HistoTramList.size() - 1).getId002Tram());

		solicitudADE.setAa83b09t00s(HistoTramList);
		// Documentacion
		// buscamos la documentacion de la 30 para el tramite de requerimiento de subsanacion
		List<Aa83b30t00> listaTiposDoc = aa83bSolicitudesUtil.getDocumentosOrdenadosAlf(this.aa83b30t00Service, Aa83BConstants.COD_ADE, 
				Aa83BConstants.COD_FASE_1, Aa83BConstants.COD_TRAM_1);
		solicitudADE.setAa83b30t00s(listaTiposDoc);
		
		// Sacamos la documentacion Generada
		Aa83b20t00 aa83b20t00 = new Aa83b20t00();
		Aa83b04t00 aa83b04t00 = new Aa83b04t00();
		List<Aa83b20t00> aa83b20t00List = new ArrayList<Aa83b20t00>();

		aa83b20t00.setId021SolAde(Integer.parseInt(num_Sol));
		aa83b20t00.setIdAno021(Long.parseLong(ano_Sol));
		aa83b20t00List = this.aa83b20t00Service.findAllLike(aa83b20t00, null, false);
		if (aa83b20t00List.size() != 0) {
			for (i = 0; i < aa83b20t00List.size(); i++) {
				aa83b04t00.setId004(aa83b20t00List.get(i).getId004TipoDocG());
				aa83b04t00 = this.aa83b04t00Service.find(aa83b04t00);
				aa83b20t00List.get(i).setAa83b04t00(aa83b04t00);

			}
		}
		solicitudADE.setAa83b20t00s(aa83b20t00List);

		// public ModelAndView(String viewName, String modelName, Object
		// modelObject)
		// return new ModelAndView("verADE", "Aa83b21t00", solicitudADE);*/
		if (Aa83BConstants.ACC_SOL_ALTA.equals(accion)) {
			solicitudADE.setAccion(Aa83BConstants.ACC_SOL_TRASALTA);
		} else if (Aa83BConstants.ACC_SOL_EDIT.equals(accion)) {
			solicitudADE.setAccion(Aa83BConstants.ACC_SOL_TRASMODIFICAR);
		} else {
			solicitudADE.setAccion(Aa83BConstants.ACC_SOL_VIEW);
		}
		
		
		solicitudADE.setRuta(this.appConfiguration.getProperty("tempFicheros.path") + "/");
		// Meto las firmas

		Aa83b19t00 aa83b19t00 = new Aa83b19t00();
		aa83b19t00.setActivoSn019("S");
		aa83b19t00.setIdCargo005(Integer.parseInt(this.appConfiguration.getProperty("idFirmaTecnico")));
		List<Aa83b19t00> aa83b19t00ListTecnicos = this.aa83b19t00Service.findAll(aa83b19t00, null);
		
		aa83b19t00ListTecnicos.removeAll(aa83bSolicitudesUtil.getTecnicosCaducados(aa83b19t00ListTecnicos));
		solicitudADE.setAa83b19t00sTecnicos(aa83b19t00ListTecnicos);

		aa83b19t00.setIdCargo005(Integer.parseInt(this.appConfiguration.getProperty("idFirmaDirector")));
		
		
		List<Aa83b19t00> aa83b19t00ListDirector = this.aa83b19t00Service.findAll(aa83b19t00, null);
		aa83b19t00ListDirector.removeAll(aa83bSolicitudesUtil.getDirectoresCaducados(aa83b19t00ListDirector));
		solicitudADE.setAa83b19t00sDirectores(aa83b19t00ListDirector);

		String pagina = "altaSolADE";
		if (popUp != null){
			if (popUp.equals(Aa83BConstants.VALUE_STR_SI)) {
				pagina = "verADEPopUp";
				solicitudADE.setAccion(Aa83BConstants.ACC_SOL_POPUP);
			}
		}
		
		Locale locale = LocaleContextHolder.getLocale();
		String localeCapitalized = WordUtils.capitalize(locale.getLanguage());
		
		Aa83bViewADEController.logger.info("********	LocaleContextHolder.getLocale()--> " + 	locale + "<-------localeCapitalized ----> "+ localeCapitalized);
		
		
		model.addAttribute("labelTipoDocumentos", "desc" + localeCapitalized + "012");
		List<Aa83b12t00> tipoDocumentos = this.aa83b12t00Service.findAllActive(null, null);
		model.addAttribute("tipoDocumentos", tipoDocumentos);
		
		model.addAttribute("labelTipoNotificacion", "desc" + localeCapitalized + "039");
		List<Aa83b39t00> tipoNotificaciones = this.aa83b39t00Service.findAll(null, null);
		model.addAttribute("tipoNotificaciones", tipoNotificaciones);
		
		model.addAttribute("labelGenero", "desc" + localeCapitalized + "017");
		List<Aa83b17t00> generos = this.aa83b17t00Service.findAll(null, null);
		model.addAttribute("generos", generos);
		
		model.addAttribute("labelMotivosSolicitud", "desc" + localeCapitalized + "015");
		List<Aa83b15t00> motivosSolicitud = this.aa83b15t00Service.findAll(null, null);
		model.addAttribute("motivosSolicitud", motivosSolicitud);
		
		model.addAttribute("labelTitularidades", "desc" + localeCapitalized + "014");
		List<Aa83b14t00> titularidades = this.aa83b14t00Service.findAll(null, null);
		model.addAttribute("titularidades", titularidades);
		
		model.addAttribute("labelDerechosOcupacion", "desc" + localeCapitalized + "016");
		List<Aa83b16t00> derechosOcupacion = this.aa83b16t00Service.findAll(null, null);
		model.addAttribute("derechosOcupacion", derechosOcupacion);
		
		model.addAttribute("labelVinculosFamiliares", "desc" + localeCapitalized + "013");
		List<Aa83b13t00> vinculosFamiliares = this.aa83b13t00Service.findAll(null, null);
		model.addAttribute("vinculosFamiliares", vinculosFamiliares);
		
		List<A83bPais> paises = this.aa83bNoraService.findPaises(null, null);
		model.addAttribute("paises", paises);
		
		A83bProvincia provincia = new A83bProvincia();
		provincia.setAutonomia_id(Aa83BConstants.COD_COM_EUS);
		List<A83bProvincia> provincias = this.aa83bNoraService.findProvincias(provincia, null);
		model.addAttribute("provincias", provincias);
				
		A83bMunicipio municipioComunic = new A83bMunicipio();
		municipioComunic.setDs_o("");
		municipioComunic.setId(solicitudADE.getMunicipComunic021());
		String provComunicSolicitud = solicitudADE.getProvinciaComunic021();
		if (provComunicSolicitud == null || provComunicSolicitud.equals("0")) {
			provComunicSolicitud = ((A83bProvincia)provincias.get(0)).getId();
		}
		municipioComunic.setProvincia_id(provComunicSolicitud);
		List<A83bMunicipio> municipiosComunic = this.aa83bNoraService.findMunicipios(municipioComunic, null);
		model.addAttribute("municipiosComunic", municipiosComunic);
		
		A83bMunicipio localidadEmpad = new A83bMunicipio();
		localidadEmpad.setDs_o("");
		localidadEmpad.setId(solicitudADE.getLocalidadEmp021());
		String provEmpSolicitud = solicitudADE.getProvEmp021();
		if (provEmpSolicitud == null || provEmpSolicitud.equals("0")) {
			provEmpSolicitud = ((A83bProvincia)provincias.get(0)).getId();
		}
		localidadEmpad.setProvincia_id(provEmpSolicitud);
		List<A83bMunicipio> localidadesEmpad = this.aa83bNoraService.findMunicipios(localidadEmpad, null);
		model.addAttribute("localidadesEmpad", localidadesEmpad);
				
		return new ModelAndView(pagina, "Aa83b21t00", solicitudADE);

	}


	
	/**
	 * @param procesarId String
	 * @param solicitudADE Aa83b21t00
	 */
	private void procesarPapel0 (String procesarId, Aa83b21t00 solicitudADE){
		// Si estamos procesando un requerimiento de subsanacin de papel0
		if (procesarId != null) {
			Aa83b34t00 papel0 = new Aa83b34t00();
			papel0.setCodsolic034(new Long(procesarId));
			papel0 = this.aa83b34t00Service.find(papel0);
			Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
			Aa83b31t00 aa83b31t00 = new Aa83b31t00();
			aa83b31t00.setId021NumSol(solicitudADE.getId021());
			Aa83b35t00 documentos = new Aa83b35t00();
			documentos.setAa83b34t00(papel0);
			List<Aa83b35t00> listaDocs = this.aa83b35t00Service.findAll(documentos, null);
			List<Aa83b31t00> lista = solicitudADE.getAa83b31t00s();
			for (int i = 0; i < listaDocs.size(); i++) {
				Aa83b31t00 documento = new Aa83b31t00();
				documento.setOid031Papel0(listaDocs.get(i).getOid035());
				List<Aa83b31t00> docsConOid = this.aa83b31t00Service.findAllLike(documento, null, false);
				if (docsConOid.size() == 0) {
					documento.setId021NumSol(solicitudADE.getId021());
					documento.setIdAno021(solicitudADE.getIdAno021());
					documento.setOid031Papel0(((Aa83b35t00) listaDocs.get(i)).getOid035());
					Aa83b09t00 aa83b09t00 = this.aa83b09t00Service.add(aa83bSolicitudesUtil
							.guardarHistoADE(solicitudADE, Aa83BConstants.COD_FASE_1, Aa83BConstants.COD_TRAM_4, "N"));
					documento.setId009HistoTram(aa83b09t00.getId009());
					
					this.aa83b31t00Service.add(documento);
					lista.add(documento);
				}
			}
			
			papel0.setSituacion034("P");
			this.aa83b34t00Service.update(papel0);
		}
	}
	
	
	/**
	 * @param filterBusqueda Aa83b21t00
	 * @param jqGridRequestDto JQGridRequestDto
	 * @return JQGridResponseDto<Aa83b06t00>
	 */
	@RequestMapping(value = "jgridHistoAcc/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<Aa83b06t00> search(
			@RequestJsonBody(param = "filter") Aa83b21t00 filterBusqueda,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {

		MessageWriter messageWriter = new MessageWriter();

		messageWriter.startMessageList();
		/*
		 * if ((aa83b21t00List.size() == 0) && (aa83b21t00List.size() == 0) &&
		 * (aa83b21t00List.size() == 0)) { messageWriter .addMessage(
		 * "No se han encontrado Solicitudes que coincidan con los criterios de búsqueda"
		 * ); } else { messageWriter.addMessage("Si que hay:" +
		 * aa83b21t00List.size() + "-" + aa83b21t00List.get(0).getApel1021() +
		 * "-" + aa83b21t00List.get(0).getApel2021()); }
		 */

		messageWriter.addMessage("No se han encontrado Solicitudes que coincidan con los criterios de búsqueda");
		messageWriter.endMessageList();

		// Historial de Accesos
		Aa83b06t00 HistoAccesos = new Aa83b06t00();
		HistoAccesos.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
		HistoAccesos.setId021NumSol(Integer.parseInt("176"));
		HistoAccesos.setIdAno021(Long.parseLong("2016"));

		List<Aa83b06t00> HistoAccesosList = this.aa83b06t00Service.findAllLike(HistoAccesos, null, false);
		List<Aa83b06t00> responseGrid = new ArrayList<Aa83b06t00>();

		responseGrid = HistoAccesosList;

		int total = 1;
		// int total = responseGrid.size();

		return new JQGridResponseDto<Aa83b06t00>(jqGridRequestDto,(long) (total), responseGrid);
		// resultB);
		// return null;
	}

	// pruebas webdav
	/**
	 * Recupera el fichero del acta y lo descarga 
	 * @param extension String
	 * @param path String
	 * @param model Model
	 * @param response HttpServletResponse
	 * @throws Exception e
	 */
	@RequestMapping(value = "/descargarDocu", method = RequestMethod.POST)
	public @ResponseBody()
	void descargarActa(@RequestParam(value = "extension") String extension,
			@RequestParam(value = "path") String path, Model model,
			HttpServletResponse response) throws Exception {
		try {
			// Generamos PATH acta Inicio
			StringBuffer filePath = new StringBuffer("");
			// filePath.append("/datos/aa83b/tmp/");
			filePath.append(path);
			// Generamos PATH acta Fin
			File docuFile = new File(filePath.toString());
			FileInputStream fin = new FileInputStream(docuFile);

			if (".doc".equals("." + extension)) {
				this.configureResponseAsDocxFile(docuFile.getName(), response);
			}

			Aa83bViewADEController.writeDocumentToResponse(fin, docuFile.getName(), response);
			fin.close();
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * @param fileName String
	 * @param response HttpServletResponse
	 */
	private void configureResponseAsDocxFile(String fileName,
			HttpServletResponse response) {
		response.setHeader("Content-Disposition", "attachment; filename=\""+ fileName + "\"");
		Cookie cookie = new Cookie("fileDownload", "true");
		cookie.setMaxAge(2);
		cookie.setPath("/");
		response.addCookie(cookie);
		response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
	}

	/**
	 * @param document byte[]
	 * @param filename String
	 * @param response HttpServletResponse
	 * @throws ServletException e
	 */
	public static void writeDocumentToResponse(byte[] document,
			String filename, HttpServletResponse response)
			throws ServletException {
		InputStream is = null;

		try {
			is = new ByteArrayInputStream(document);
			Aa83bViewADEController.writeDocumentToResponse(is, filename,response);
			is.close();
		} catch (IOException e) {
			throw new ServletException(e);
		}
	}

	/**
	 * @param inputStream InputStream
	 * @param filename String
	 * @param response HttpServletResponse
	 * @throws ServletException E
	 */
	public static void writeDocumentToResponse(InputStream inputStream,
			String filename, HttpServletResponse response)
			throws ServletException {
		Aa83bViewADEController.writeDocumentToResponseContentType(inputStream, filename, response,"application/msword");
	}

	/**
	 * @param inputStream InputStream
	 * @param filename String
	 * @param response HttpServletResponse
	 * @param contentType String
	 * @throws ServletException E
	 */
	public static void writeDocumentToResponseContentType(
			InputStream inputStream, String filename,
			HttpServletResponse response, String contentType)
			throws ServletException {
		ServletOutputStream out = null;

		try {
			out = response.getOutputStream();
			response.setStatus(HttpServletResponse.SC_OK);
			// response.setHeader("Content-type", "application/msword");
			response.setHeader("Content-Disposition", "attachment; filename=\""+ filename + "\"");
			Cookie cookie = new Cookie("fileDownload", "true");
			cookie.setMaxAge(2);
			cookie.setPath("/");
			response.addCookie(cookie);
			response.setContentType(contentType);

			BufferedInputStream bis = new BufferedInputStream(inputStream);
			BufferedOutputStream bos = new BufferedOutputStream(out);
			PrintStream ps = new PrintStream(bos, true);

			byte[] buffer = new byte[Aa83BConstants.DOSCIENTOSCINCUENTAYSEIS * Aa83BConstants.MILVEINTICUATRO]; // 256K
			long total = 0;
			for (int len = 0; (len = bis.read(buffer)) > 0;) {
				total += len;
				ps.write(buffer, 0, len);
			}
			bis.close();
			ps.close();
			response.flushBuffer();
		} catch (IOException e) {
			throw new ServletException(e);
		}
	}
	// fin pruebas webdav
}
