package com.ejie.aa83b.control;

import com.bea.xbean.util.Base64;

import com.ejie.aa83b.service.Aa83b34t00Service;
import com.ejie.aa83b.service.Aa83b35t00Service;
import com.ejie.aa83b.service.Aa83bDokusiService;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.util.Properties;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import javax.xml.parsers.ParserConfigurationException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import org.xml.sax.SAXException;

import weblogic.utils.encoders.BASE64Decoder;

import com.ejie.aa83b.model.Aa83bDocumentoDokusi;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilProperties;
import com.ejie.aa83b.util.Aa83bUtilSeguridad;
import com.ejie.aa83b.webservice.client.x97.X97DistributionWebServiceImpl;

import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;

//PARA EL ALTA EN PAPEL0
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.model.Aa83b35t00;

/**
 * Aa83b01t00Controller generated by UDA, 29-dic-2015 13:41:11.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/viewDOC")
public class Aa83bVerDocumentoController {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bVerDocumentoController.class);

	@Autowired()
	private Aa83bDokusiService aa83bDokusiService;

	@Autowired()
	private Aa83b34t00Service aa83b34t00Service;

	@Autowired()
	private Aa83b35t00Service aa83b35t00Service;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private X97DistributionWebServiceImpl x97DistributionWebServiceImpl;

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 * @throws IOException
	 * @throws SAXException
	 * @throws UnsupportedEncodingException
	 * @throws Y31JanoServiceAccesDeniedException
	 * @throws Y31JanoServiceOracleGenericException
	 * @throws Y31JanoServiceMongoDbGenericException
	 * @throws Y31JanoServiceFileNameFormatException
	 * @throws Y31JanoServiceFileNotFoundException
	 * @throws ParserConfigurationException
	 */
	@RequestMapping(value = "/verDOCDokusi", method = RequestMethod.GET)
	public void getFormEdit(Model model,
			@RequestParam(value = "oid", required = false) String oid,
			HttpServletResponse response) throws UnsupportedEncodingException,
			SAXException, IOException, Y31JanoServiceFileNotFoundException,
			Y31JanoServiceFileNameFormatException,
			Y31JanoServiceMongoDbGenericException,
			Y31JanoServiceOracleGenericException,
			Y31JanoServiceAccesDeniedException, ParserConfigurationException {
		Aa83bVerDocumentoController.logger.info("[GET - View] : verDOC");

		Aa83bDocumentoDokusi documentoDevuelto = null;

		Aa83bDocumentoDokusi documentoDescargar = new Aa83bDocumentoDokusi();
		documentoDescargar.setOid(oid);

		documentoDevuelto = this.aa83bDokusiService
				.retrieveDocument2PIF(documentoDescargar);

		response.setContentType(documentoDevuelto.getContentType());

		response.setContentLength(documentoDevuelto.getTamanyo());
		response.setHeader("Content-disposition", "attachment;filename=" + oid
				+ documentoDevuelto.getExtension());
		response.setCharacterEncoding("UTF-8");

		try {

			/*
			 * Comento la generacion del fichero segun Array de Bytes
			 * InputStream fichero = new ByteArrayInputStream(
			 * Base64.decode(documentoDevuelto.getContent().getBytes(
			 * "ISO-8859-1"))); byte[] decodedBytes = new byte[0]; BASE64Decoder
			 * decoder = new BASE64Decoder(); decodedBytes = decoder
			 * .decodeBuffer(documentoDescargar.getContent()); is = new
			 * ByteArrayInputStream(decodedBytes); verDocumentPIF(response, oid,
			 * documentoDevuelto.getContentType(), fichero);
			 */
			String rutaCompleta = this.appConfiguration
					.getProperty("RUTA_EDICION_PIF")
					+ documentoDevuelto.getRutaPif();

//			System.out.println("rutaCompleta:"
//					+ this.appConfiguration.getProperty("RUTA_EDICION_PIF")
//					+ documentoDevuelto.getRutaPif());

			/*
			 * rutaCompleta =
			 * "https://svc.integracion.jakina.ejiedes.net/y31ApiJSWAR/Y31JanoServiceGetServlet?hadoop_file_path=/aa83b/aa83b_adjuntos/09f424018074d66e1463134865179.pdf"
			 * ; String redirectUrl = rutaCompleta;
			 * response.sendRedirect(redirectUrl);
			 */

			final int _1024 = 1024;
			byte[] binaryBuffer = new byte[_1024];

			ServletOutputStream out = response.getOutputStream();
			response.setHeader("Set-Cookie", "fileDownload=true; path=/");
			response.setContentType(documentoDevuelto.getContentType());
			response.setHeader("Content-Disposition", "attachment; filename="
					+ documentoDevuelto.getRutaPif());
			int bytesReaded = 0;

			;

			Aa83bPifController pifC = new Aa83bPifController();
			InputStream inputStream = pifC.bajarPif(documentoDevuelto
					.getRutaPif());
			while ((bytesReaded = inputStream.read(binaryBuffer)) != -1) {
				out.write(binaryBuffer, 0, bytesReaded);
			}
			out.flush();
			out.close();

		} catch (IOException e) {
			// TODO Auto-generated catch block
			Aa83bVerDocumentoController.logger.error ("[Aa83bVerDocumentoController Exception]"+e.getMessage());
			
		} catch (Exception e) {
			Aa83bVerDocumentoController.logger.error ("[Aa83bVerDocumentoController Exception]"+e.getMessage());
		}

	}

	
	@RequestMapping(value = "/regVerDOCDokusi", method = RequestMethod.GET)
	public void verDOCDokusiReg(Model model,
			@RequestParam(value = "oid", required = false) String oid,
			HttpServletResponse response) throws UnsupportedEncodingException,
			SAXException, IOException, Y31JanoServiceFileNotFoundException,
			Y31JanoServiceFileNameFormatException,
			Y31JanoServiceMongoDbGenericException,
			Y31JanoServiceOracleGenericException,
			Y31JanoServiceAccesDeniedException, ParserConfigurationException {
		
		
		
		Aa83bVerDocumentoController.logger.info("[GET - View] : verDOCDokusiReg");

		InputStream is = null;
		Aa83bDocumentoDokusi documentoDevuelto = null;

		Aa83bDocumentoDokusi documentoDescargar = new Aa83bDocumentoDokusi();
		documentoDescargar.setOid(oid);

		String sesionToken = Aa83bUtilSeguridad.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);
		
		String auditUser = Aa83bUtilSeguridad.getAuditUser();
		
		String rutaPif  = this.appConfiguration
		.getProperty("RUTA_PIF_REG");
		
		StringBuffer listaDocs=new StringBuffer("<documentIDList><documentID><id>");
		listaDocs.append(oid);
		listaDocs.append("</id></documentID></documentIDList>");
		
		StringBuffer listaPif=new StringBuffer("<contentList><content><pifId>");
		listaPif.append(rutaPif);
		listaPif.append("</pifId></content></contentList>");
		String respuestaX ="";
		
		try {
			
			
			respuestaX = this.x97DistributionWebServiceImpl.retrieveRegistryDocuments (sesionToken, auditUser, listaDocs.toString(), "", listaPif.toString()); 
		}
		catch (Exception ex)
		{
			Aa83bVerDocumentoController.logger.error ("[Aa83bVerDocumentoController Exception]"+ex.getMessage());
		}

		logger.info  ("Responde x97DistributionWebServiceImpl:: " +respuestaX);
	

		
		//response.setContentType(documentoDevuelto.getContentType());
		response.setContentType(recogerEtiqueta(respuestaX,"mimeType"));

		//response.setContentLength(documentoDevuelto.getTamanyo());
		response.setContentLength(Integer.parseInt(recogerEtiqueta(respuestaX,"lenght")));
		
//		response.setHeader("Content-disposition", "attachment;filename=" + oid
//				+ documentoDevuelto.getExtension());
		
		response.setHeader("Content-disposition", "attachment;filename=" + oid
				+ recogerEtiqueta(respuestaX,"extension"));

		try {

			/*
			 * Comento la generacion del fichero segun Array de Bytes
			 * InputStream fichero = new ByteArrayInputStream(
			 * Base64.decode(documentoDevuelto.getContent().getBytes(
			 * "ISO-8859-1"))); byte[] decodedBytes = new byte[0]; BASE64Decoder
			 * decoder = new BASE64Decoder(); decodedBytes = decoder
			 * .decodeBuffer(documentoDescargar.getContent()); is = new
			 * ByteArrayInputStream(decodedBytes); verDocumentPIF(response, oid,
			 * documentoDevuelto.getContentType(), fichero);
			 */
			

//			System.out.println("rutaCompleta:"
//					+ this.appConfiguration.getProperty("RUTA_EDICION_PIF")
//					+ documentoDevuelto.getRutaPif());

			/*
			 * rutaCompleta =
			 * "https://svc.integracion.jakina.ejiedes.net/y31ApiJSWAR/Y31JanoServiceGetServlet?hadoop_file_path=/aa83b/aa83b_adjuntos/09f424018074d66e1463134865179.pdf"
			 * ; String redirectUrl = rutaCompleta;
			 * response.sendRedirect(redirectUrl);
			 */

			final int _1024 = 1024;
			byte[] binaryBuffer = new byte[_1024];

			ServletOutputStream out = response.getOutputStream();
			response.setHeader("Set-Cookie", "fileDownload=true; path=/");
			//response.setContentType(documentoDevuelto.getContentType());
//			response.setHeader("Content-Disposition", "attachment; filename="
//					+ documentoDevuelto.getRutaPif());
			
			response.setHeader("Content-Disposition", "attachment; filename="
					+ recogerEtiqueta(respuestaX,"pifId"));
			
			
			int bytesReaded = 0;

			;

			Aa83bPifController pifC = new Aa83bPifController();
			InputStream inputStream = pifC.bajarPif(recogerEtiqueta(respuestaX,"pifId"));
			while ((bytesReaded = inputStream.read(binaryBuffer)) != -1) {
				out.write(binaryBuffer, 0, bytesReaded);
			}
			out.flush();
			out.close();

		} catch (IOException e) {
			// TODO Auto-generated catch block
			Aa83bVerDocumentoController.logger.error ("[Aa83bVerDocumentoController Exception]"+e.getMessage());
		} catch (Exception es) {
			Aa83bVerDocumentoController.logger.info("EXCEPTTTT: "
					+ es.getMessage());
		}

	}
	
	@RequestMapping(value = "/verDOCDOC_OLD", method = RequestMethod.GET)
	public void getFormEditDoc(Model model,
			@RequestParam(value = "oid", required = false) String oid,
			HttpServletResponse response) throws UnsupportedEncodingException,
			SAXException, IOException, Y31JanoServiceFileNotFoundException,
			Y31JanoServiceFileNameFormatException,
			Y31JanoServiceMongoDbGenericException,
			Y31JanoServiceOracleGenericException,
			Y31JanoServiceAccesDeniedException, ParserConfigurationException {
		Aa83bVerDocumentoController.logger.info("[GET - View] : verDOC");

		Aa83bDocumentoDokusi documentoDevuelto = null;

		Aa83bDocumentoDokusi documentoDescargar = new Aa83bDocumentoDokusi();
		documentoDescargar.setOid(oid);
		//documentoDescargar.setExtension("DOC");
//		documentoDescargar
//				.setAuditUserDokusi("AA83BTRAAAX#AA83B-03, AA83B-03#AA83B-03#AA83B");
		documentoDevuelto = this.aa83bDokusiService
				.retrieveDocument2PIF(documentoDescargar);

		response.setContentType(documentoDevuelto.getContentType());

		response.setContentLength(documentoDevuelto.getTamanyo());
		response.setHeader("Content-disposition", "attachment;filename=" + oid
				+ documentoDevuelto.getExtension());

		try {

			InputStream fichero = new ByteArrayInputStream(
					Base64.decode(documentoDevuelto.getContent().getBytes(
							"ISO-8859-1")));

			byte[] decodedBytes = new byte[0];
			BASE64Decoder decoder = new BASE64Decoder();
			decodedBytes = decoder
					.decodeBuffer(documentoDescargar.getContent());

			downloadDocument(response, oid + documentoDevuelto.getExtension(),
					documentoDevuelto.getContentType(), fichero);

		} catch (Exception es) {
			Aa83bVerDocumentoController.logger.info("EXCEPTTTT: "
					+ es.getMessage());
		}

	}

	public static void verDocumentPIF(HttpServletResponse response,
			String documentName, String mimeType, InputStream inputStream) {
		String redirectUrl = "http://www.yahoo.com";
		try {
			response.sendRedirect(redirectUrl);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			Aa83bVerDocumentoController.logger.error ("[Aa83bVerDocumentoController Exception]"+e.getMessage());
		}
		// return "redirect:" + redirectUrl;
	}

	public static void downloadDocument(HttpServletResponse response,
			String documentName, String mimeType, InputStream inputStream)
			throws IOException {
		final int _1024 = 1024;
		byte[] binaryBuffer = new byte[_1024];
		ServletOutputStream out = response.getOutputStream();
		response.setHeader("Set-Cookie", "fileDownload=true; path=/");
		response.setContentType(mimeType);
		response.setHeader("Content-Disposition", "attachment; filename="
				+ documentName);
		int bytesReaded = 0;
		while ((bytesReaded = inputStream.read(binaryBuffer)) != -1) {
			out.write(binaryBuffer, 0, bytesReaded);
		}

		out.flush();
		out.close();

	}

	@RequestMapping(value = "/altaPapel0", method = RequestMethod.GET)
	public void getFormEdit() {
		Aa83b34t00 aa83b34t00 = new Aa83b34t00();
		Aa83b35t00 aa83b35t00 = new Aa83b35t00();

		String mensajeJMS = "<NotificationBody xmlns=\"com/ejie/notification/xml\">"
				+ "<Property>"
				+ "<Name>targetDestination</Name>"
				+ "<Value>AA83B</Value>"
				+ "</Property>"
				+ "<Property>"
				+ "<Name>registryNumber</Name>"
				+ "<Value>201600000000880</Value>"
				+ "</Property>"
				+ "<Property>"
				+ "<Name>procedure</Name>"
				+ "<Value>02183</Value>"
				+ "</Property>"
				+ "<xmlValue><![CDATA[<inputRegister><registryNumber>201600000000880</registryNumber><registryDate>20160225110001</registryDate><procedure>02183</procedure><QRCode>02183</QRCode><tipoLectura>M</tipoLectura><territorioHistorico>01</territorioHistorico><resumen>SOLICITUD DE ARRAIGO</resumen><persons><person><name>REMITENTE</name></person></persons><documents><documentOid><id>09f424018074a049</id></documentOid></documents></inputRegister>]]></xmlValue>"
				+ "</NotificationBody>";

		try {

			System.out.println("Estoy en altaPapel0 - 1");
			java.util.Date utilDate = new java.util.Date();
			Date date = new Date(utilDate.getTime());

			// Cargamos el objeto 34
			aa83b34t00.setBloqueo034(0);
			String coddel034 = "01";
			String jmsid034 = "DD";
			Long numano034 = (long) 2016;
			Integer numdel034 = 123456;
			String numreg034 = "66778899";
			String qrcode034 = "QR";
			String remitente034 = "El que lo pide";
			String situacion034 = Aa83BConstants.VOLCADA;
			String tipsub034 = "";

			String codPlatea_jms = Aa83BConstants.COD_ADE_PLATEA;
			String tipo034 = "";

			// miramos el procedicmiento que nos llega:
			if (codPlatea_jms.equals(Aa83BConstants.COD_ADE_PLATEA))
				tipsub034 = Aa83BConstants.COD_ADE;
			else if (codPlatea_jms.equals(Aa83BConstants.COD_ESF_PLATEA))
				tipsub034 = Aa83BConstants.COD_ESF;
			else if (codPlatea_jms.equals(Aa83BConstants.COD_ARR_PLATEA))
				tipsub034 = Aa83BConstants.COD_ARR;

			aa83b34t00.setCoddel034(coddel034);
			aa83b34t00.setFlectura034(date);
			aa83b34t00.setFregistro034(date);
			aa83b34t00.setJmsid034(jmsid034);
			aa83b34t00.setNumano034(numano034);
			aa83b34t00.setNumdel034(numdel034);
			aa83b34t00.setNumreg034(numreg034);
			aa83b34t00.setQrcode034(qrcode034);
			aa83b34t00.setRemitente034(remitente034);
			aa83b34t00.setSituacion034(situacion034);
			aa83b34t00.setTipsub034(tipsub034);
			aa83b34t00.setTipo034(tipo034);
			Integer tipoEntrada = 1;

			// aa83b34t00.setMensaje034(Aa83bUtilidades.stringToClob(mensajeJMS));
			// Si es requerimiento de subsanacion cargamos el ID de la solicitud
			if (tipoEntrada == 1) {
				// Ee nueva solictud
				aa83b34t00.setCodapl034("0");
				aa83b34t00.setCodfase034(Aa83BConstants.COD_FASE_1);
				aa83b34t00.setCodtra034(Aa83BConstants.COD_TRAM_1);
				aa83b34t00.setCortra034(Long
						.parseLong(Aa83BConstants.COD_TRAM_1));

			} else {
				// Requerimiento de Subsanacion
				aa83b34t00.setCodapl034("231");
				aa83b34t00.setCodfase034(Aa83BConstants.COD_FASE_1);
				aa83b34t00.setCodtra034(Aa83BConstants.COD_TRAM_3);
				aa83b34t00.setCortra034(Long
						.parseLong(Aa83BConstants.COD_TRAM_3));
			}

			// Message message = session.createTextMessage(mensajeJMS);
			
			aa83b34t00Service.add(aa83b34t00);
			
			// System.out.println("Estoy en altaPapel0"
			// + message.getPropertyNames().toString());
			// Inserto los OIS de Dokusi
			Integer numDocs = 3;
			for (int d = 1; d <= numDocs; d++) {
			
				aa83b35t00.setOid035("09f424018074d66e");
				aa83b35t00.setAa83b34t00(aa83b34t00);
				aa83b35t00Service.add(aa83b35t00);
			}

		} catch (Exception es) {
			Aa83bVerDocumentoController.logger.info("EXCEP  papel0: "
					+ es.getMessage());
		}
	}

	private String recogerEtiqueta(String xml, String etiqueta) {
		String valor = "";
		try {
			String inicio = "<" + etiqueta + ">";
			int inicioint = xml.indexOf(inicio) + inicio.length();
			String fin = "</" + etiqueta + ">";
			int finint = xml.indexOf(fin);
			valor = xml.substring(inicioint, finint);
			if (!etiqueta.equals("sourceBinary"))
				logger.info("la etiqueta==>" + etiqueta + " es==>" + valor);
		} catch (Exception e) {
			// No hacemos nada
			Aa83bVerDocumentoController.logger.error ("[Aa83bVerDocumentoController Exception]"+e.getMessage());
		}
		return valor;
	}
	
}
