package com.ejie.aa83b.control;

import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejie.aa83b.model.Aa83b03t00;

import com.ejie.aa83b.model.Aa83bContadorTerritorios;
import com.ejie.aa83b.model.Aa83bEstadGrid;
import com.ejie.aa83b.model.Aa83bEstadisticas;
import com.ejie.aa83b.model.Aa83bEstadisticasBusqueda;
import com.ejie.aa83b.model.Aa83bEstadisticasFechas;
import com.ejie.aa83b.service.Aa83b03t00Service;

import com.ejie.aa83b.service.Aa83bEstadisticasService;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83BUtilidadesExcel;
import com.ejie.x38.dto.JQGridRequestDto;

@Controller
@RequestMapping(value = "/territorioexcel")
public class Aa83bTerritorioExcelController {

	/** The service. */
	@Autowired()
	private Aa83b03t00Service aa83b03t00Service;

	@Autowired()
	private Aa83bEstadisticasService a83bEstadisticasService;

	private Integer totalGrid = 0;
	@Autowired
	private Properties langEsProperties;
	@Autowired
	private Properties appConfiguration;

	public List<Aa83bEstadGrid> busquedaStandard(
			Aa83bEstadisticas filterBusqueda,
			JQGridRequestDto jqGridRequestDto, Boolean excel)
			throws ParseException {

		Aa83bEstadisticasBusqueda solicitudADE = new Aa83bEstadisticasBusqueda();
		Aa83bEstadisticasBusqueda solicitudESF = new Aa83bEstadisticasBusqueda();
		Aa83bEstadisticasBusqueda solicitudARR = new Aa83bEstadisticasBusqueda();

		String tipoSol = filterBusqueda.getTipoSol();
		String fDesde = filterBusqueda.getfDesde();
		String fHasta = filterBusqueda.getfHasta();

		int conta21 = 0;
		int conta23 = 0;
		int conta25 = 0;

		List<Aa83bEstadisticasBusqueda> aa83bEstadisticasBusquedaADEList = new ArrayList<Aa83bEstadisticasBusqueda>();
		List<Aa83bEstadisticasBusqueda> aa83bEstadisticasBusquedaARRList = new ArrayList<Aa83bEstadisticasBusqueda>();
		List<Aa83bEstadisticasBusqueda> aa83bEstadisticasBusquedaESFList = new ArrayList<Aa83bEstadisticasBusqueda>();
		Aa83bEstadisticasBusqueda estadBusq = new Aa83bEstadisticasBusqueda();
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		Date fechaD2 = new Date();
		if (fDesde != null) {
			fechaD2 = formatoDelTexto.parse(fDesde);
			estadBusq.setfDesde(fechaD2);
		} else {
			fDesde = null;
		}

		Date fechaH2 = new Date();
		if (fHasta != null) {
			fechaH2 = formatoDelTexto.parse(fHasta);
			estadBusq.setfHasta(fechaH2);
		} else {
			fHasta = null;
		}

		if (tipoSol.equals("0")) {

			aa83bEstadisticasBusquedaADEList = this.a83bEstadisticasService
					.estadBusquedaADE(estadBusq, null, false);
			aa83bEstadisticasBusquedaARRList = this.a83bEstadisticasService
					.estadBusquedaARR(estadBusq, null, false);
			aa83bEstadisticasBusquedaESFList = this.a83bEstadisticasService
					.estadBusquedaESF(estadBusq, null, false);

			conta21 = aa83bEstadisticasBusquedaADEList.size();
			conta23 = aa83bEstadisticasBusquedaESFList.size();
			conta25 = aa83bEstadisticasBusquedaARRList.size();

		}

		if (tipoSol.equals(Aa83BConstants.COD_ADE)) {
			aa83bEstadisticasBusquedaADEList = this.a83bEstadisticasService
					.estadBusquedaADE(estadBusq, null, false);
			conta21 = aa83bEstadisticasBusquedaADEList.size();
		}
		if (tipoSol.equals(Aa83BConstants.COD_ESF)) {
			aa83bEstadisticasBusquedaESFList = this.a83bEstadisticasService
					.estadBusquedaESF(estadBusq, null, false);
			conta23 = aa83bEstadisticasBusquedaESFList.size();
		}
		if (tipoSol.equals(Aa83BConstants.COD_ARR)) {

			aa83bEstadisticasBusquedaARRList = this.a83bEstadisticasService
					.estadBusquedaARR(estadBusq, null, false);
			conta25 = aa83bEstadisticasBusquedaARRList.size();
		}

		List<Aa83bEstadisticas> response = new ArrayList<Aa83bEstadisticas>();
		List<Aa83bEstadGrid> responseGrid = new ArrayList<Aa83bEstadGrid>();
		List<Aa83bEstadGrid> responseGridPaginado = new ArrayList<Aa83bEstadGrid>();
		int i = 0;
		Aa83bEstadisticas resultB = new Aa83bEstadisticas();

		resultB.setTipoSol(tipoSol);
		resultB.setfDesde(fDesde);
		resultB.setfHasta(fHasta);

		Aa83b03t00 aa83b03t00 = new Aa83b03t00();

		for (i = 0; i < conta21; i++) {
			solicitudADE = aa83bEstadisticasBusquedaADEList.get(i);
			Aa83bEstadGrid estadMin = new Aa83bEstadGrid();
			estadMin.setId_solicitud(solicitudADE.getId());
			estadMin.setAnyo(solicitudADE.getAnyo());
			aa83b03t00.setId003(Integer.parseInt(tipoSol));
			estadMin.setMes(solicitudADE.getMes());
			estadMin.setGeneroStrEs(solicitudADE.getDesc_es());
			estadMin.setGeneroStrEu(solicitudADE.getDesc_eu());
			estadMin.setFecha(solicitudADE.getF_actu());
			estadMin.setProvinciaStrEs(solicitudADE.getDs_c());
			estadMin.setProvinciaStrEu(solicitudADE.getDs_e());
			estadMin.setNacionalidadStrEs(solicitudADE.getDs_c_nacionalidad());
			estadMin.setNacionalidadStrEu(solicitudADE.getDs_e_nacionalidad());
			estadMin.setTipoSolicitud_STR(solicitudADE.getTipo_Sol());
			estadMin.setSolConcat(solicitudADE.getTipo_Sol() + " "
					+ solicitudADE.getAnyo() + " " + solicitudADE.getId());

			int m = solicitudADE.getMes();

			if (m == 12) {
				m = 0;
			}

			estadMin.setNombreMesES(Aa83BConstants.mesesCastellano[m]
					.toString());

			responseGrid.add(estadMin);
			resultB.setEstadGrid(responseGrid);
			response.add(resultB);
		}
		for (i = 0; i < conta23; i++) {
			solicitudESF = aa83bEstadisticasBusquedaESFList.get(i);
			Aa83bEstadGrid estadMin = new Aa83bEstadGrid();
			estadMin.setId_solicitud(solicitudESF.getId());
			estadMin.setAnyo(solicitudESF.getAnyo());
			aa83b03t00.setId003(Integer.parseInt(tipoSol));
			estadMin.setMes(solicitudESF.getMes());
			estadMin.setGeneroStrEs(solicitudESF.getDesc_es());
			estadMin.setGeneroStrEu(solicitudESF.getDesc_eu());
			estadMin.setFecha(solicitudESF.getF_actu());
			estadMin.setNacionalidadStrEs(solicitudESF.getDs_c_nacionalidad());
			estadMin.setNacionalidadStrEu(solicitudESF.getDs_e_nacionalidad());
			estadMin.setProvinciaStrEs(solicitudESF.getDs_c());
			estadMin.setProvinciaStrEu(solicitudESF.getDs_e());
			estadMin.setTipoSolicitud_STR(solicitudESF.getTipo_Sol());
			estadMin.setSolConcat(solicitudESF.getTipo_Sol() + " "
					+ solicitudESF.getAnyo() + " " + solicitudESF.getId());

			int m = solicitudESF.getMes();

			if (m == 12) {
				m = 0;
			}

			estadMin.setNombreMesES(Aa83BConstants.mesesCastellano[m]
					.toString());

			responseGrid.add(estadMin);
			resultB.setEstadGrid(responseGrid);
			response.add(resultB);

		}
		for (i = 0; i < conta25; i++) {
			solicitudARR = aa83bEstadisticasBusquedaARRList.get(i);
			Aa83bEstadGrid estadMin = new Aa83bEstadGrid();
			estadMin.setId_solicitud(solicitudARR.getId());
			estadMin.setAnyo(solicitudARR.getAnyo());
			aa83b03t00.setId003(Integer.parseInt(tipoSol));
			estadMin.setMes(solicitudARR.getMes());
			estadMin.setGeneroStrEs(solicitudARR.getDesc_es());
			estadMin.setGeneroStrEu(solicitudARR.getDesc_eu());
			estadMin.setFecha(solicitudARR.getF_actu());
			estadMin.setNacionalidadStrEs(solicitudARR.getDs_c_nacionalidad());
			estadMin.setNacionalidadStrEu(solicitudARR.getDs_e_nacionalidad());
			estadMin.setProvinciaStrEs(solicitudARR.getDs_c());
			estadMin.setProvinciaStrEu(solicitudARR.getDs_e());
			estadMin.setTipoSolicitud_STR(solicitudARR.getTipo_Sol());
			estadMin.setSolConcat(solicitudARR.getTipo_Sol() + " "
					+ solicitudARR.getAnyo() + " " + solicitudARR.getId());

			int m = solicitudARR.getMes();

			if (m == 12) {
				m = 0;
			}

			estadMin.setNombreMesES(Aa83BConstants.mesesCastellano[m]
					.toString());

			responseGrid.add(estadMin);
			resultB.setEstadGrid(responseGrid);
			response.add(resultB);

		}

		// Paginamos:

		this.totalGrid = responseGrid.size();
		if (totalGrid == 0) {
			if (!excel) {
				if (jqGridRequestDto.getPage() != 1) {
					// Paginamos
					int p = (int) ((jqGridRequestDto.getPage() - 1) * jqGridRequestDto
							.getRows());

					for (int pag = p; (pag < responseGrid.size()); pag++) {
						responseGridPaginado.add(responseGrid.get(pag));
					}

					// Miro si es la ultima página:
					if ((responseGrid.size() - (jqGridRequestDto.getPage() * jqGridRequestDto
							.getRows())) <= 0) {

					} else {
						if (jqGridRequestDto.getPage() != 1) {
							for (int pant = 0; pant < p; pant++)
								responseGridPaginado
										.add(responseGrid.get(pant));
						}
					}

				} else {
					responseGridPaginado = responseGrid;
				}
			} else {
				responseGridPaginado = responseGrid;
			}

			return responseGridPaginado;
		}
		return responseGrid;

	}

	@RequestMapping(value = "/territorio", method = RequestMethod.POST)
	protected void processForward(
			Aa83bEstadisticas contexto,
			@RequestParam(value = "tipoSol2", required = false) String tipoSol2,
			@RequestParam(value = "fDesde2", required = false) String fDesde2,
			@RequestParam(value = "fHasta2", required = false) String fHasta2,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		Locale locale = LocaleContextHolder.getLocale();
		String lenguaje = locale.getLanguage();
		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		Aa83bEstadisticas filterBusqueda = new Aa83bEstadisticas();
		if (fDesde2.isEmpty())
			fDesde2 = null;
		if (fHasta2.isEmpty())
			fHasta2 = null;

		if (tipoSol2.equals("")) {
			tipoSol2 = "0";
		}
		filterBusqueda.setTipoSol(tipoSol2);
		filterBusqueda.setfDesde(fDesde2);
		filterBusqueda.setfHasta(fHasta2);

		if (fDesde2 == null || fHasta2 == null) {
			DateFormat fechaDesde2 = null;
			if (lenguaje == "es") {
				fechaDesde2 = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
			} else if (lenguaje == "eu") {
				fechaDesde2 = new SimpleDateFormat(Aa83BConstants.EU_PATTERN);
			}
			Aa83bEstadisticasFechas e = new Aa83bEstadisticasFechas();
			List<Aa83bEstadisticasFechas> eLista = a83bEstadisticasService
					.fMinMax(e, null);

			if (eLista.size() > 0) {
				e = eLista.get(0);
				if (fDesde2 == null)
					fDesde2 = fechaDesde2.format(e.getMINACC());
				if (fHasta2 == null)
					fHasta2 = fechaDesde2.format(e.getMAXACC());

			}
		}

		String anyoDesde = "";
		String anyoHasta = "";
		if (fDesde2 != null) {
			if (lenguaje == "es") {
				anyoDesde = fDesde2.substring(6);
			} else if (lenguaje == "eu") {
				anyoDesde = fDesde2.substring(0, 4);
			}
		}
		if (fHasta2 != null) {
			if (lenguaje == "es") {
				anyoHasta = fHasta2.substring(6);
			} else if (lenguaje == "eu") {
				anyoHasta = fHasta2.substring(0, 4);
			}
		}

		int contHoja = 0;
		String strRutaExcel = this.appConfiguration
				.getProperty("tempPlantillasEstad.path")
				+ "PlantillaNacionalidadTerritoriosMeses.xls";

		String fDesde3 = fDesde2;
		String fHasta3 = fHasta2;

		InputStream inputStream = new FileInputStream(strRutaExcel);

		HSSFWorkbook wb = new HSSFWorkbook(inputStream);// Creacion del libro de
		// trabajo
		HSSFSheet sheet;

		HSSFFont hSSFFont = wb.createFont();
		hSSFFont.setFontHeightInPoints((short) 6);

		CellStyle cellStyle2 = wb.createCellStyle();
		cellStyle2.setWrapText(true);
		cellStyle2.setFont(hSSFFont);
		// cellStyle2.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
		CellStyle cellStyle = wb.createCellStyle();
		cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
		cellStyle.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
		cellStyle.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
		CellStyle cellStyle3 = wb.createCellStyle();
		cellStyle3.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
		cellStyle3.setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index);
		cellStyle3.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		cellStyle3.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		cellStyle3.setBorderTop(HSSFCellStyle.BORDER_THIN);
		cellStyle3.setBorderRight(HSSFCellStyle.BORDER_THIN);

		CellStyle cellStyle5 = wb.createCellStyle();
		cellStyle5.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
		cellStyle5.setBorderRight(HSSFCellStyle.BORDER_THIN);

		CellStyle cellStyle6 = wb.createCellStyle();
		cellStyle6.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
		// cellStyle5.setBorderRight(HSSFCellStyle.BORDER_THIN);

		HSSFFont hSSFFont2 = wb.createFont();
		hSSFFont2.setFontHeightInPoints((short) 10);
		CellStyle cellStyle4 = wb.createCellStyle();
		cellStyle4.setFont(hSSFFont2);
		if (false == anyoDesde.equals(anyoHasta)) {
			int anyoD = Integer.parseInt(anyoDesde);
			int anyoH = Integer.parseInt(anyoHasta);
			while (anyoD < anyoH) {
				wb.cloneSheet(0);
				anyoD++;
			}
			anyoD = Integer.parseInt(anyoDesde);
			while (anyoD <= anyoH) {
				if (anyoD < anyoH)
					fHasta3 = "31/12/" + anyoD;
				else {
					fDesde3 = "01/01/" + anyoD;
					fHasta3 = fHasta2;
				}

				// if (0 == contHoja) {
				wb.setSheetName(contHoja, String.valueOf(anyoD)); // Creacin de
				sheet = wb.getSheetAt(contHoja); // Creacin de la hoja

				// } else {
				// sheet = wb.createSheet(String.valueOf(anyoD));
				// }
				// la // hoja

				//

				// Escribir departamento
				HSSFRow rowDep = sheet.getRow((short) 4);
				HSSFCell cellDep = rowDep.createCell(12);
				cellDep.setCellValue(this.langEsProperties
						.getProperty("DEPT_ES_1")
						+ "\n "
						+ this.langEsProperties.getProperty("DEPT_ES_2")
						+ "\n "
						+ this.langEsProperties.getProperty("DEPT_ES_3")
						+ "\n "
						+ this.langEsProperties.getProperty("DEPT_ES_4")
						+ "\n "
						+ this.langEsProperties.getProperty("DEPT_ES_5"));
				rowDep.getCell(12).setCellStyle(cellStyle2);
				HSSFCell cellDep2 = rowDep.createCell(20);
				cellDep2.setCellValue(this.langEsProperties
						.getProperty("DEPT_EU_1")
						+ "\n "
						+ this.langEsProperties.getProperty("DEPT_EU_2")
						+ "\n "
						+ this.langEsProperties.getProperty("DEPT_EU_3")
						+ "\n "
						+ this.langEsProperties.getProperty("DEPT_EU_4")
						+ "\n "
						+ this.langEsProperties.getProperty("DEPT_EU_5"));
				rowDep.getCell(20).setCellStyle(cellStyle2);
				// Colocar tipo de solicitud y fechas

				HSSFRow row = sheet.getRow((short) 11);// obtener fila

				Aa83b03t00 aa83b03t00 = new Aa83b03t00();
				HSSFCell cell7 = row.createCell(7);
				aa83b03t00.setId003(Integer.parseInt(tipoSol2));
				List<Aa83b03t00> aa83b03t00Lista = aa83b03t00Service
						.findAllLike(aa83b03t00, null, false);
				if (aa83b03t00Lista.size() > 0) {
					aa83b03t00 = aa83b03t00Lista.get(0);
					cell7.setCellValue(aa83b03t00.getDescEs003());

				}
				HSSFCell cell18 = row.createCell(18);
				cell18.setCellValue(fDesde2);
				HSSFCell cell26 = row.createCell(26);
				cell26.setCellValue(fHasta2);
				row.getCell(7).setCellStyle(cellStyle4);
				row.getCell(18).setCellStyle(cellStyle4);
				row.getCell(26).setCellStyle(cellStyle4);

				String fechaD[] = fDesde2.split("/");
				String fechaH[] = fHasta3.split("/");

				int contTotalV = 0; // contador del total vertical
				int contTotalHorA = 0; // contador del total horizontal alava;
				int contTotalHorV = 0; // contador del total horizontal vizcaya;
				int contTotalHorG = 0; // contador del total horizontal
										// gipuzkoa;
				int contTotalM = 0;// contador mujeres
				int contTotalHo = 0;// contador hombres
				int celdaAlava = 3;
				int celdaBiz = 3;
				int celdaGip = 3;
				int celdaTotal = 3;
				int fila = 0;

				// Obtener datos
				Aa83bContadorTerritorios c = new Aa83bContadorTerritorios();
				SimpleDateFormat formatoDelTexto = null;
				if (lenguaje == "es") {
					formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
				} else if (lenguaje == "eu") {
					formatoDelTexto = new SimpleDateFormat(Aa83BConstants.EU_PATTERN);
				}
				Date fechaD2 = new Date();
				if (fDesde2 != null) {
					fechaD2 = formatoDelTexto.parse(fDesde3);
					
					c.setfDesde(fechaD2);

				}
				Date fechaH2 = new Date();
				if (fHasta3 != null) {
					fechaH2 = formatoDelTexto.parse(fHasta3);
					
					c.setfHasta(fechaH2);

				}
				List<Aa83bContadorTerritorios> c2 = new ArrayList<Aa83bContadorTerritorios>();
				int cont = 0;
				while (cont != 3) {
					celdaAlava = 3;
					celdaGip = 3;
					celdaBiz = 3;
					celdaTotal = 3;
					if (Integer.parseInt(tipoSol2) == 3) {// HAB
						fila = 20;
						c2 = a83bEstadisticasService.contTerritoriosHab(c,
								jqGridRequestDto, false);
						cont = 3;

					} else if (Integer.parseInt(tipoSol2) == 1) {// ARR
						fila = 16;
						c2 = a83bEstadisticasService.contTerritoriosArr(c,
								jqGridRequestDto, false);
						cont = 3;
					} else if (Integer.parseInt(tipoSol2) == 2) {// ESF
						fila = 24;
						c2 = a83bEstadisticasService.contTerritoriosEsf(c,
								jqGridRequestDto, false);
						cont = 3;
					} else {// Todas
						if (cont == 0) {
							fila = 16;
							c2 = a83bEstadisticasService.contTerritoriosArr(c,
									jqGridRequestDto, false);
							cont++;
						} else if (cont == 1) {
							fila = 20;
							c2 = a83bEstadisticasService.contTerritoriosHab(c,
									jqGridRequestDto, false);
							cont++;

						} else if (cont == 2) {
							fila = 24;
							c2 = a83bEstadisticasService.contTerritoriosEsf(c,
									jqGridRequestDto, false);
							cont++;
						}

					}
					HSSFRow rowAlavaHab = sheet.getRow((fila));
					HSSFRow rowBizHab = sheet.getRow(fila + 1);
					HSSFRow rowGipHab = sheet.getRow(fila + 2);
					HSSFRow rowTotalHab = sheet.getRow((fila + 3));
					// cogemos los meses de las fechas seleccionadas
					int fD = Integer.parseInt(fechaD[1]);
					int fH = Integer.parseInt(fechaH[1]);
					for (int i = 1; i < 13; i++) {// Para cada mes
						if (i == 13) {
							i = 12;
						}
						contTotalHorA = 0;
						contTotalHorV = 0;
						contTotalHorG = 0;
						contTotalM = 0;
						contTotalHo = 0;
						contTotalV = 0;
						for (int j = 0; j < c2.size(); j++) {

							// Si los aos son distintos cogemos todos los meses
							if (Integer.parseInt(fechaD[2]) != Integer
									.parseInt(fechaH[2])) {
								fD = 1;
								fH = 12;
							}
							if (fD <= i && i <= fH) {
								if (i == c2.get(j).getMes()) {
									if (c2.get(j).getProvincia() == 1) { // Alava
										if (c2.get(j).getDesc_es()
												.equals("Mujer")) {
											contTotalHorA = contTotalHorA
													+ c2.get(j).getTotal();
											rowAlavaHab
													.createCell(celdaAlava)
													.setCellValue(
															c2.get(j)
																	.getTotal());
											rowAlavaHab.getCell(celdaAlava)
													.setCellStyle(cellStyle4);
											contTotalM = contTotalM
													+ c2.get(j).getTotal();

										} else {
											if (rowAlavaHab.getCell(celdaAlava) == null
													|| rowAlavaHab.getCell(
															celdaAlava)
															.getCellType() == Cell.CELL_TYPE_BLANK) {
												rowAlavaHab.createCell(
														celdaAlava)
														.setCellValue(0);
												rowAlavaHab.getCell(celdaAlava)
														.setCellStyle(
																cellStyle4);
											}

										}
										if (c2.get(j).getDesc_es()
												.equals("Varon")) {
											contTotalHorA = contTotalHorA
													+ c2.get(j).getTotal();
											rowAlavaHab
													.createCell(celdaAlava + 1)
													.setCellValue(
															c2.get(j)
																	.getTotal());
											rowAlavaHab.getCell(celdaAlava + 1)
													.setCellStyle(cellStyle4);
											contTotalHo = contTotalHo
													+ c2.get(j).getTotal();
										} else {
											if (rowAlavaHab
													.getCell(celdaAlava + 1) == null
													|| rowAlavaHab.getCell(
															celdaAlava + 1)
															.getCellType() == Cell.CELL_TYPE_BLANK) {
												rowAlavaHab.createCell(
														celdaAlava + 1)
														.setCellValue(0);
												rowAlavaHab.getCell(
														celdaAlava + 1)
														.setCellStyle(
																cellStyle4);
											}
										}
										rowAlavaHab.createCell(celdaAlava + 2)
												.setCellValue(contTotalHorA);
										rowAlavaHab.getCell(celdaAlava + 2)
												.setCellStyle(cellStyle5);

									} else if (c2.get(j).getProvincia() == 48) {// Bizkaia
										if (c2.get(j).getDesc_es()
												.equals("Mujer")) {
											contTotalHorV = contTotalHorV
													+ c2.get(j).getTotal();
											rowBizHab
													.createCell(celdaBiz)
													.setCellValue(
															c2.get(j)
																	.getTotal());
											rowBizHab.getCell(celdaBiz)
													.setCellStyle(cellStyle4);
											contTotalM = contTotalM
													+ c2.get(j).getTotal();

										} else {
											if (rowBizHab.getCell(celdaBiz) == null
													|| rowBizHab.getCell(
															celdaBiz)
															.getCellType() == Cell.CELL_TYPE_BLANK) {
												rowBizHab.createCell(celdaBiz)
														.setCellValue(0);
												rowBizHab.getCell(celdaBiz)
														.setCellStyle(
																cellStyle4);
											}

										}
										if (c2.get(j).getDesc_es()
												.equals("Varon")) {
											contTotalHorV = contTotalHorV
													+ c2.get(j).getTotal();
											rowBizHab
													.createCell(celdaBiz + 1)
													.setCellValue(
															c2.get(j)
																	.getTotal());
											rowBizHab.getCell(celdaBiz + 1)
													.setCellStyle(cellStyle4);
											contTotalHo = contTotalHo
													+ c2.get(j).getTotal();
										} else {
											if (rowBizHab.getCell(celdaBiz + 1) == null
													|| rowBizHab.getCell(
															celdaBiz + 1)
															.getCellType() == Cell.CELL_TYPE_BLANK) {
												rowBizHab.createCell(
														celdaBiz + 1)
														.setCellValue(0);
												rowBizHab.getCell(celdaBiz + 1)
														.setCellStyle(
																cellStyle4);
											}

										}
										rowBizHab.createCell(celdaBiz + 2)
												.setCellValue(contTotalHorV);
										rowBizHab.getCell(celdaBiz + 2)
												.setCellStyle(cellStyle5);

									} else if (c2.get(j).getProvincia() == 20) {// Gipuzkoa
										if (c2.get(j).getDesc_es()
												.equals("Mujer")) {
											contTotalHorG = contTotalHorG
													+ c2.get(j).getTotal();
											rowGipHab
													.createCell(celdaGip)
													.setCellValue(
															c2.get(j)
																	.getTotal());
											rowGipHab.getCell(celdaGip)
													.setCellStyle(cellStyle4);
											contTotalM = contTotalM
													+ c2.get(j).getTotal();

										} else {
											if (rowGipHab.getCell(celdaGip) == null
													|| rowGipHab.getCell(
															celdaGip)
															.getCellType() == Cell.CELL_TYPE_BLANK) {
												rowGipHab.createCell(celdaGip)
														.setCellValue(0);
											}

										}

										if (c2.get(j).getDesc_es()
												.equals("Varon")) {
											contTotalHorG = contTotalHorG
													+ c2.get(j).getTotal();
											rowGipHab
													.createCell(celdaGip + 1)
													.setCellValue(
															c2.get(j)
																	.getTotal());
											rowGipHab.getCell(celdaGip + 1)
													.setCellStyle(cellStyle4);
											contTotalHo = contTotalHo
													+ c2.get(j).getTotal();
										} else {
											if (rowGipHab.getCell(celdaGip + 1) == null
													|| rowGipHab.getCell(
															celdaGip + 1)
															.getCellType() == Cell.CELL_TYPE_BLANK) {
												rowGipHab.createCell(
														celdaGip + 1)
														.setCellValue(0);
												rowGipHab.getCell(celdaGip + 1)
														.setCellStyle(
																cellStyle4);
											}
										}
										rowGipHab.createCell(celdaGip + 2)
												.setCellValue(contTotalHorG);
										rowGipHab.getCell(celdaGip + 2)
												.setCellStyle(cellStyle5);

									}
									if (c2.get(j).getProvincia() != 1) {
										if (rowAlavaHab.getCell(celdaAlava) == null
												|| rowAlavaHab.getCell(
														celdaAlava)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowAlavaHab.createCell(celdaAlava)
													.setCellValue(0);
											rowAlavaHab.getCell(celdaAlava)
													.setCellStyle(cellStyle4);
										}
										if (rowAlavaHab.getCell(celdaAlava + 1) == null
												|| rowAlavaHab.getCell(
														celdaAlava + 1)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowAlavaHab.createCell(
													celdaAlava + 1)
													.setCellValue(0);
											rowAlavaHab.getCell(celdaAlava + 1)
													.setCellStyle(cellStyle4);
										}
										if (rowAlavaHab.getCell(celdaAlava + 2) == null
												|| rowAlavaHab.getCell(
														celdaAlava + 2)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowAlavaHab.createCell(
													celdaAlava + 2)
													.setCellValue(0);
											rowAlavaHab.getCell(celdaAlava + 2)
													.setCellStyle(cellStyle5);
										}
									}
									if (c2.get(j).getProvincia() != 48) {
										if (rowBizHab.getCell(celdaBiz) == null
												|| rowBizHab.getCell(celdaBiz)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowBizHab.createCell(celdaBiz)
													.setCellValue(0);
											rowBizHab.getCell(celdaBiz)
													.setCellStyle(cellStyle4);
										}
										if (rowBizHab.getCell(celdaBiz + 1) == null
												|| rowBizHab.getCell(
														celdaBiz + 1)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowBizHab.createCell(celdaBiz + 1)
													.setCellValue(0);
											rowBizHab.getCell(celdaBiz + 1)
													.setCellStyle(cellStyle4);
										}
										if (rowBizHab.getCell(celdaBiz + 2) == null
												|| rowBizHab.getCell(
														celdaBiz + 2)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowBizHab.createCell(celdaBiz + 2)
													.setCellValue(0);

											rowBizHab.getCell(celdaBiz + 2)
													.setCellStyle(cellStyle5);
										}

									}
									if (c2.get(j).getProvincia() != 20) {
										if (rowGipHab.getCell(celdaGip) == null
												|| rowGipHab.getCell(celdaGip)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowGipHab.createCell(celdaGip)
													.setCellValue(0);
											rowGipHab.getCell(celdaGip)
													.setCellStyle(cellStyle4);
										}
										if (rowGipHab.getCell(celdaGip + 1) == null
												|| rowGipHab.getCell(
														celdaGip + 1)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowGipHab.createCell(celdaGip + 1)
													.setCellValue(0);
											rowGipHab.getCell(celdaGip + 1)
													.setCellStyle(cellStyle4);
										}
										if (rowGipHab.getCell(celdaGip + 2) == null
												|| rowGipHab.getCell(
														celdaGip + 2)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowGipHab.createCell(celdaGip + 2)
													.setCellValue(0);
											rowGipHab.getCell(celdaGip + 2)
													.setCellStyle(cellStyle5);
										}

									}

								}
								contTotalV = contTotalHorA + contTotalHorV + contTotalHorG;
								if (contTotalM != 0 || contTotalHo != 0 || contTotalV != 0) {
									rowTotalHab.createCell(celdaTotal).setCellValue(contTotalM);
									rowTotalHab.createCell(celdaTotal + 1).setCellValue(contTotalHo);
									rowTotalHab.createCell(celdaTotal + 2).setCellValue(contTotalV);
								}
								rowTotalHab.getCell(celdaTotal).setCellStyle(cellStyle3);
								rowTotalHab.getCell(celdaTotal + 1).setCellStyle(cellStyle3);
								rowTotalHab.getCell(celdaTotal + 2).setCellStyle(cellStyle3);
								// rowTotalHab.getCell(celdaTotal).setCellStyle(
								// cellStyle);
								// rowTotalHab.getCell(celdaTotal +
								// 1).setCellStyle(cellStyle);
								// rowTotalHab.getCell(celdaTotal +
								// 2).setCellStyle(cellStyle3);
							}

						}

						celdaAlava = celdaAlava + 3;
						celdaGip = celdaGip + 3;
						celdaBiz = celdaBiz + 3;
						celdaTotal = celdaTotal + 3;

					}
				}

				anyoD++;
				contHoja++;
				fDesde3 = "01/01/" + String.valueOf(anyoD);
			}

		} else {
			// if (0 == contHoja) {
			wb.setSheetName(contHoja, anyoDesde); // Creacin de
			sheet = wb.getSheetAt(contHoja); // Creacin de la hoja
			// } else {
			// sheet = wb.createSheet(String.valueOf(anyoD));
			// }
			// la // hoja

			//

			// Escribir departamento
			HSSFRow rowDep = sheet.getRow((short) 4);
			HSSFCell cellDep = rowDep.createCell(12);
			cellDep.setCellValue(this.langEsProperties.getProperty("DEPT_ES_1")
					+ "\n " + this.langEsProperties.getProperty("DEPT_ES_2")
					+ "\n " + this.langEsProperties.getProperty("DEPT_ES_3")
					+ "\n " + this.langEsProperties.getProperty("DEPT_ES_4")
					+ "\n " + this.langEsProperties.getProperty("DEPT_ES_5"));
			rowDep.getCell(12).setCellStyle(cellStyle2);
			HSSFCell cellDep2 = rowDep.createCell(20);
			cellDep2.setCellValue(this.langEsProperties
					.getProperty("DEPT_EU_1")
					+ "\n "
					+ this.langEsProperties.getProperty("DEPT_EU_2")
					+ "\n "
					+ this.langEsProperties.getProperty("DEPT_EU_3")
					+ "\n "
					+ this.langEsProperties.getProperty("DEPT_EU_4")
					+ "\n "
					+ this.langEsProperties.getProperty("DEPT_EU_5"));
			rowDep.getCell(20).setCellStyle(cellStyle2);
			// Colocar tipo de solicitud y fechas

			HSSFRow row = sheet.getRow((short) 11);// obtener fila

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();
			HSSFCell cell7 = row.createCell(7);
			aa83b03t00.setId003(Integer.parseInt(tipoSol2));
			List<Aa83b03t00> aa83b03t00Lista = aa83b03t00Service.findAllLike(
					aa83b03t00, null, false);
			if (aa83b03t00Lista.size() > 0) {
				aa83b03t00 = aa83b03t00Lista.get(0);
				cell7.setCellValue(aa83b03t00.getDescEs003());

			}
			HSSFCell cell18 = row.createCell(18);
			cell18.setCellValue(fDesde2);
			HSSFCell cell26 = row.createCell(26);
			cell26.setCellValue(fHasta2);
			row.getCell(7).setCellStyle(cellStyle4);
			row.getCell(18).setCellStyle(cellStyle4);
			row.getCell(26).setCellStyle(cellStyle4);

			if (fDesde2 == null || fHasta2 == null) {

				DateFormat fechaDesde2 = null;
				if (lenguaje == "es") {
					fechaDesde2 = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
				} else if (lenguaje == "eu") {
					fechaDesde2 = new SimpleDateFormat(Aa83BConstants.EU_PATTERN);
				}
				Aa83bEstadisticasFechas e = new Aa83bEstadisticasFechas();
				List<Aa83bEstadisticasFechas> eLista = a83bEstadisticasService.fMinMax(e, null);

				if (eLista.size() > 0) {
					e = eLista.get(0);
					if (fDesde2 == null)
						fDesde2 = fechaDesde2.format(e.getMINACC());
					if (fHasta2 == null)
						fHasta2 = fechaDesde2.format(e.getMAXACC());
				}
			}
			String fechaD[] = fDesde2.split("/");
			String fechaH[] = fHasta3.split("/");

			int contTotalV = 0; // contador del total vertical
			int contTotalHorA = 0; // contador del total horizontal alava;
			int contTotalHorV = 0; // contador del total horizontal vizcaya;
			int contTotalHorG = 0; // contador del total horizontal
									// gipuzkoa;
			int contTotalM = 0;// contador mujeres
			int contTotalHo = 0;// contador hombres
			int celdaAlava = 3;
			int celdaBiz = 3;
			int celdaGip = 3;
			int celdaTotal = 3;
			int fila = 0;

			// Obtener datos
			Aa83bContadorTerritorios c = new Aa83bContadorTerritorios();
			SimpleDateFormat formatoDelTexto = null;
			if (lenguaje == "es") {
				formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
			} else if (lenguaje == "eu") {
				formatoDelTexto = new SimpleDateFormat(Aa83BConstants.EU_PATTERN);
			}
			Date fechaD2 = new Date();
			if (fDesde2 != null) {
				fechaD2 = formatoDelTexto.parse(fDesde2);
				
				c.setfDesde(fechaD2);

			}
			Date fechaH2 = new Date();
			if (fHasta3 != null) {
				fechaH2 = formatoDelTexto.parse(fHasta3);
				
				c.setfHasta(fechaH2);

			}
			List<Aa83bContadorTerritorios> c2 = new ArrayList<Aa83bContadorTerritorios>();
			int cont = 0;
			while (cont != 3) {
				celdaAlava = 3;
				celdaGip = 3;
				celdaBiz = 3;
				celdaTotal = 3;
				if (Integer.parseInt(tipoSol2) == 3) {// HAB
					fila = 20;
					c2 = a83bEstadisticasService.contTerritoriosHab(c,
							jqGridRequestDto, false);
					cont = 3;

				} else if (Integer.parseInt(tipoSol2) == 1) {// ARR
					fila = 16;
					c2 = a83bEstadisticasService.contTerritoriosArr(c,
							jqGridRequestDto, false);
					cont = 3;
				} else if (Integer.parseInt(tipoSol2) == 2) {// ESF
					fila = 24;
					c2 = a83bEstadisticasService.contTerritoriosEsf(c,
							jqGridRequestDto, false);
					cont = 3;
				} else {// Todas
					if (cont == 0) {
						fila = 16;
						c2 = a83bEstadisticasService.contTerritoriosArr(c,
								jqGridRequestDto, false);
						cont++;
					} else if (cont == 1) {
						fila = 20;
						c2 = a83bEstadisticasService.contTerritoriosHab(c,
								jqGridRequestDto, false);
						cont++;

					} else if (cont == 2) {
						fila = 24;
						c2 = a83bEstadisticasService.contTerritoriosEsf(c,
								jqGridRequestDto, false);
						cont++;
					}

				}
				HSSFRow rowAlavaHab = sheet.getRow((fila));
				HSSFRow rowBizHab = sheet.getRow(fila + 1);
				HSSFRow rowGipHab = sheet.getRow(fila + 2);
				HSSFRow rowTotalHab = sheet.getRow((fila + 3));
				// cogemos los meses de las fechas seleccionadas
				int fD = Integer.parseInt(fechaD[1]);
				int fH = Integer.parseInt(fechaH[1]);
				for (int i = 1; i < 13; i++) {// Para cada mes
					if (i == 13) {
						i = 12;
					}
					contTotalHorA = 0;
					contTotalHorV = 0;
					contTotalHorG = 0;
					contTotalM = 0;
					contTotalHo = 0;
					contTotalV = 0;
					for (int j = 0; j < c2.size(); j++) {

						// Si los aos son distintos cogemos todos los meses
						if (Integer.parseInt(fechaD[2]) != Integer
								.parseInt(fechaH[2])) {
							fD = 1;
							fH = 12;
						}
						if (fD <= i && i <= fH) {
							if (i == c2.get(j).getMes()) {
								if (c2.get(j).getProvincia() == 1) { // Alava
									if (c2.get(j).getDesc_es().equals("Mujer")) {
										contTotalHorA = contTotalHorA
												+ c2.get(j).getTotal();
										rowAlavaHab.createCell(celdaAlava)
												.setCellValue(
														c2.get(j).getTotal());
										rowAlavaHab.getCell(celdaAlava)
												.setCellStyle(cellStyle4);
										contTotalM = contTotalM
												+ c2.get(j).getTotal();

									} else {
										if (rowAlavaHab.getCell(celdaAlava) == null
												|| rowAlavaHab.getCell(
														celdaAlava)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowAlavaHab.createCell(celdaAlava)
													.setCellValue(0);
											rowAlavaHab.getCell(celdaAlava)
													.setCellStyle(cellStyle4);
										}

									}
									if (c2.get(j).getDesc_es().equals("Varon")) {
										contTotalHorA = contTotalHorA
												+ c2.get(j).getTotal();
										rowAlavaHab.createCell(celdaAlava + 1)
												.setCellValue(
														c2.get(j).getTotal());
										rowAlavaHab.getCell(celdaAlava + 1)
												.setCellStyle(cellStyle4);
										contTotalHo = contTotalHo
												+ c2.get(j).getTotal();
									} else {
										if (rowAlavaHab.getCell(celdaAlava + 1) == null
												|| rowAlavaHab.getCell(
														celdaAlava + 1)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowAlavaHab.createCell(
													celdaAlava + 1)
													.setCellValue(0);
											rowAlavaHab.getCell(celdaAlava + 1)
													.setCellStyle(cellStyle4);
										}
									}
									rowAlavaHab.createCell(celdaAlava + 2)
											.setCellValue(contTotalHorA);
									rowAlavaHab.getCell(celdaAlava + 2)
											.setCellStyle(cellStyle5);

								} else if (c2.get(j).getProvincia() == 48) {// Bizkaia
									if (c2.get(j).getDesc_es().equals("Mujer")) {
										contTotalHorV = contTotalHorV
												+ c2.get(j).getTotal();
										rowBizHab.createCell(celdaBiz)
												.setCellValue(
														c2.get(j).getTotal());
										rowBizHab.getCell(celdaBiz)
												.setCellStyle(cellStyle4);
										contTotalM = contTotalM
												+ c2.get(j).getTotal();

									} else {
										if (rowBizHab.getCell(celdaBiz) == null
												|| rowBizHab.getCell(celdaBiz)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowBizHab.createCell(celdaBiz)
													.setCellValue(0);
											rowBizHab.getCell(celdaBiz)
													.setCellStyle(cellStyle4);
										}

									}
									if (c2.get(j).getDesc_es().equals("Varon")) {
										contTotalHorV = contTotalHorV
												+ c2.get(j).getTotal();
										rowBizHab.createCell(celdaBiz + 1)
												.setCellValue(
														c2.get(j).getTotal());
										contTotalHo = contTotalHo
												+ c2.get(j).getTotal();
										rowBizHab.getCell(celdaBiz + 1)
												.setCellStyle(cellStyle4);
									} else {
										if (rowBizHab.getCell(celdaBiz + 1) == null
												|| rowBizHab.getCell(
														celdaBiz + 1)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowBizHab.createCell(celdaBiz + 1)
													.setCellValue(0);
											rowBizHab.getCell(celdaBiz + 1)
													.setCellStyle(cellStyle4);
										}

									}
									rowBizHab.createCell(celdaBiz + 2)
											.setCellValue(contTotalHorV);
									rowBizHab.getCell(celdaBiz + 2)
											.setCellStyle(cellStyle5);

								} else if (c2.get(j).getProvincia() == 20) {// Gipuzkoa
									if (c2.get(j).getDesc_es().equals("Mujer")) {
										contTotalHorG = contTotalHorG
												+ c2.get(j).getTotal();
										rowGipHab.createCell(celdaGip)
												.setCellValue(
														c2.get(j).getTotal());
										rowGipHab.getCell(celdaGip)
												.setCellStyle(cellStyle4);
										contTotalM = contTotalM
												+ c2.get(j).getTotal();

									} else {
										if (rowGipHab.getCell(celdaGip) == null
												|| rowGipHab.getCell(celdaGip)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowGipHab.createCell(celdaGip)
													.setCellValue(0);
											rowGipHab.getCell(celdaGip)
													.setCellStyle(cellStyle4);
										}

									}

									if (c2.get(j).getDesc_es().equals("Varon")) {
										contTotalHorG = contTotalHorG
												+ c2.get(j).getTotal();
										rowGipHab.createCell(celdaGip + 1)
												.setCellValue(
														c2.get(j).getTotal());
										rowGipHab.getCell(celdaGip + 1)
												.setCellStyle(cellStyle4);
										contTotalHo = contTotalHo
												+ c2.get(j).getTotal();
									} else {
										if (rowGipHab.getCell(celdaGip + 1) == null
												|| rowGipHab.getCell(
														celdaGip + 1)
														.getCellType() == Cell.CELL_TYPE_BLANK) {
											rowGipHab.createCell(celdaGip + 1)
													.setCellValue(0);
											rowGipHab.getCell(celdaGip + 1)
													.setCellStyle(cellStyle4);
										}
									}
									rowGipHab.createCell(celdaGip + 2)
											.setCellValue(contTotalHorG);
									rowGipHab.getCell(celdaGip + 2)
											.setCellStyle(cellStyle5);

								}
								if (c2.get(j).getProvincia() != 1) {
									if (rowAlavaHab.getCell(celdaAlava) == null
											|| rowAlavaHab.getCell(celdaAlava)
													.getCellType() == Cell.CELL_TYPE_BLANK) {
										rowAlavaHab.createCell(celdaAlava)
												.setCellValue(0);
										rowAlavaHab.getCell(celdaAlava)
												.setCellStyle(cellStyle4);
									}
									if (rowAlavaHab.getCell(celdaAlava + 1) == null
											|| rowAlavaHab.getCell(
													celdaAlava + 1)
													.getCellType() == Cell.CELL_TYPE_BLANK) {
										rowAlavaHab.createCell(celdaAlava + 1)
												.setCellValue(0);
										rowAlavaHab.getCell(celdaAlava + 1)
												.setCellStyle(cellStyle4);
									}
									if (rowAlavaHab.getCell(celdaAlava + 2) == null
											|| rowAlavaHab.getCell(
													celdaAlava + 2)
													.getCellType() == Cell.CELL_TYPE_BLANK) {
										rowAlavaHab.createCell(celdaAlava + 2)
												.setCellValue(0);
										rowAlavaHab.getCell(celdaAlava + 2)
												.setCellStyle(cellStyle5);
									}
								}
								if (c2.get(j).getProvincia() != 48) {
									if (rowBizHab.getCell(celdaBiz) == null
											|| rowBizHab.getCell(celdaBiz)
													.getCellType() == Cell.CELL_TYPE_BLANK) {
										rowBizHab.createCell(celdaBiz)
												.setCellValue(0);
										rowBizHab.getCell(celdaBiz)
												.setCellStyle(cellStyle4);
									}
									if (rowBizHab.getCell(celdaBiz + 1) == null
											|| rowBizHab.getCell(celdaBiz + 1)
													.getCellType() == Cell.CELL_TYPE_BLANK) {
										rowBizHab.createCell(celdaBiz + 1)
												.setCellValue(0);
										rowBizHab.getCell(celdaBiz + 1)
												.setCellStyle(cellStyle4);
									}
									if (rowBizHab.getCell(celdaBiz + 2) == null
											|| rowBizHab.getCell(celdaBiz + 2)
													.getCellType() == Cell.CELL_TYPE_BLANK) {
										rowBizHab.createCell(celdaBiz + 2)
												.setCellValue(0);
										rowBizHab.getCell(celdaBiz + 2)
												.setCellStyle(cellStyle5);
									}

								}
								if (c2.get(j).getProvincia() != 20) {
									if (rowGipHab.getCell(celdaGip) == null
											|| rowGipHab.getCell(celdaGip)
													.getCellType() == Cell.CELL_TYPE_BLANK) {
										rowGipHab.createCell(celdaGip)
												.setCellValue(0);
										rowGipHab.getCell(celdaGip)
												.setCellStyle(cellStyle4);
									}
									if (rowGipHab.getCell(celdaGip + 1) == null
											|| rowGipHab.getCell(celdaGip + 1)
													.getCellType() == Cell.CELL_TYPE_BLANK) {
										rowGipHab.createCell(celdaGip + 1)
												.setCellValue(0);
										rowGipHab.getCell(celdaGip + 1)
												.setCellStyle(cellStyle4);
									}
									if (rowGipHab.getCell(celdaGip + 2) == null
											|| rowGipHab.getCell(celdaGip + 2)
													.getCellType() == Cell.CELL_TYPE_BLANK) {
										rowGipHab.createCell(celdaGip + 2)
												.setCellValue(0);
										rowGipHab.getCell(celdaGip + 2)
												.setCellStyle(cellStyle5);
									}

								}

							}
							contTotalV = contTotalHorA + contTotalHorV
									+ contTotalHorG;

							if (contTotalM != 0 || contTotalHo != 0 || contTotalV != 0) {
								rowTotalHab.createCell(celdaTotal).setCellValue(contTotalM);
								rowTotalHab.createCell(celdaTotal + 1).setCellValue(contTotalHo);
								rowTotalHab.createCell(celdaTotal + 2).setCellValue(contTotalV);
							}
							rowTotalHab.getCell(celdaTotal).setCellStyle(cellStyle3);
							rowTotalHab.getCell(celdaTotal + 1).setCellStyle(cellStyle3);
							rowTotalHab.getCell(celdaTotal + 2).setCellStyle(cellStyle3);
						}

					}

					celdaAlava = celdaAlava + 3;
					celdaGip = celdaGip + 3;
					celdaBiz = celdaBiz + 3;
					celdaTotal = celdaTotal + 3;

				}
			}

		}

		byte[] bytesExcel = Aa83BUtilidadesExcel.fncExcelToBytes(wb);
		response.setContentType("application/vnd.ms-excel");
		response.setContentLength(bytesExcel.length);
		response.setHeader("Content-disposition",
				"attachment;filename=EstadisticasTerritorios.xls");
		response.getOutputStream().write(bytesExcel);
		response.getOutputStream().flush();

	}
}
