package com.ejie.aa83b.control;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa83b.model.Aa83b02t00;
import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b10t00;
import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83b30t00;
import com.ejie.aa83b.model.Aa83b31t00;
import com.ejie.aa83b.model.Aa83b32t00;
import com.ejie.aa83b.model.Aa83b33t00;
import com.ejie.aa83b.model.Aa83b36t00;
import com.ejie.aa83b.model.Aa83b37t00;
import com.ejie.aa83b.model.Aa83b41t00;
import com.ejie.aa83b.model.Aa83bBusqueda;
import com.ejie.aa83b.service.Aa83b02t00Service;
import com.ejie.aa83b.service.Aa83b06t00Service;
import com.ejie.aa83b.service.Aa83b07t00Service;
import com.ejie.aa83b.service.Aa83b08t00Service;
import com.ejie.aa83b.service.Aa83b09t00Service;
import com.ejie.aa83b.service.Aa83b10t00Service;
import com.ejie.aa83b.service.Aa83b11t00Service;
import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b23t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83b30t00Service;
import com.ejie.aa83b.service.Aa83b31t00Service;
import com.ejie.aa83b.service.Aa83b32t00Service;
import com.ejie.aa83b.service.Aa83b33t00Service;
import com.ejie.aa83b.service.Aa83b36t00Service;
import com.ejie.aa83b.service.Aa83b37t00Service;
import com.ejie.aa83b.service.Aa83b41t00Service;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.aa83b.util.Aa83bUtilProperties;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.json.MessageWriter;

/**
 * @author Deusto Sistemas
 *
 */
@Controller()
@RequestMapping(value = "/telematicas")
public class Aa83bTelematicaController {

	/** The service.*/
	@Autowired()
	private Aa83b21t00Service aa83b21t00Service;
	/** The service. */
	@Autowired()
	private Aa83b23t00Service aa83b23t00Service;
	/** The service. */
	@Autowired()
	private Aa83b25t00Service aa83b25t00Service;

	/** The service. */
	@Autowired()
	private Aa83b09t00Service aa83b09t00Service;
	/** The service. */
	@Autowired()
	private Aa83b10t00Service aa83b10t00Service;
	/** The service. */
	@Autowired()
	private Aa83b11t00Service aa83b11t00Service;
	/** The service. */
	@Autowired()
	private Aa83b31t00Service aa83b31t00Service;
	/** The service. */
	@Autowired()
	private Aa83b32t00Service aa83b32t00Service;
	/** The service. */
	@Autowired()
	private Aa83b33t00Service aa83b33t00Service;	
	/** The service. */
	@Autowired()
	private Aa83b37t00Service aa83b37t00Service;

	/** The service. */
	@Autowired()
	private Aa83b41t00Service aa83b41t00Service;

	/** The service. */
	@Autowired()
	private Aa83b02t00Service aa83b02t00Service;

	/** The service. */
	@Autowired()
	private Aa83b06t00Service aa83b06t00Service;

	/** The service. */
	@Autowired()
	private Aa83b07t00Service aa83b07t00Service;

	/** The service. */
	@Autowired()
	private Aa83b08t00Service aa83b08t00Service;
	/** The service. */
	@Autowired()
	private Aa83b30t00Service aa83b30t00Service;
	/** The service. */
	@Autowired()
	private Aa83b36t00Service aa83b36t00Service;

	/**
	 *
	 */
	private Integer totalGrid;

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Aa83bTelematicaController.class);

	/**
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83bTelematicaController.logger.info("[GET - View] : BusquedaControler");
		return "telematicas";
	}

	/**
	 * @param idSol String
	 * @param idSolTelema String
	 * @param request HttpServletRequest
	 * @param response HttpServletResponse
	 * @param session HttpSession 
	 * @return HashMap<String, String>
	 * @throws Exception e
	 */
	@RequestMapping(value = "/procesar", method = RequestMethod.GET)
	public @ResponseBody()
	HashMap<String, String> editarPif(
			@RequestParam(value = "idSol", required = true) String idSol,
			@RequestParam(value = "idSolTelema", required = true) String idSolTelema,
			HttpServletRequest request, HttpServletResponse response, HttpSession session)
			throws Exception {
		
		//Se borra el objeto de sesion para que no se pinte la paginacin
		session.removeAttribute("PAGINACION_BUSQUEDA");
		
		Aa83bTelematicaController.logger.info("Entro a procesar Telematica: " + idSol);
		HashMap<String, String> retorno = new HashMap<String, String>();
		// Identifico la Solicitud: (ADE/ESF/ARR)
		String[] datosSolicitud = idSol.split(":");
		String tipoSol = datosSolicitud[0];
		String anoSol = datosSolicitud[1];
		String numSol = datosSolicitud[2];
		String idTramite = "";
		String tipoAcceso = "";
		int idHistTramite = 0;

		// Se busca en la 37 el registro seleccionado en pantalla para recuperar la fase y el tramite
		Aa83b37t00 aa83b37t00 = new Aa83b37t00();
		aa83b37t00.setId037(Integer.parseInt(idSolTelema));
		Aa83bTelematicaController.logger.info("ID SOL TELEMATICA!!!!!!!!!!!: " + idSolTelema);
		List<Aa83b37t00> aa83b37t00List = this.aa83b37t00Service.findAllLike(aa83b37t00, null, false);
		aa83b37t00 = aa83b37t00List.get(0);
		
		if (Aa83BConstants.COD_FASE_1.equals(aa83b37t00.getCodfase037()) && Aa83BConstants.COD_TRAM_4.equals(aa83b37t00.getCodtra037())){
			idTramite = Aa83BConstants.COD_TRAM_4;
			tipoAcceso = Aa83BConstants.ACCESOS_MODIF;
		} else {
			idTramite = Aa83BConstants.COD_TRAM_1;
			//tipoAcceso = Aa83BConstants.ACCESOS_ALTA;
			tipoAcceso = Aa83BConstants.ACCESOS_MODIF;
		}

		Aa83bSolicitudesUtil aa83bSolicitudesUtil =
			new Aa83bSolicitudesUtil();
		if (tipoSol.equals(Aa83BConstants.COD_ADE_STR)) {
			Aa83b21t00 aa83b21t00 = new Aa83b21t00();
			aa83b21t00.setId021(Integer.parseInt(numSol));
			aa83b21t00.setIdAno021(Long.parseLong(anoSol));
			aa83b21t00 = this.aa83b21t00Service.find(aa83b21t00);

			Aa83b09t00 aa83b09t00 = this.aa83b09t00Service.add(aa83bSolicitudesUtil.guardarHistoADE(aa83b21t00,Aa83BConstants.COD_FASE_1,idTramite, "N"));
			idHistTramite = aa83b09t00.getId009();
			Aa83b31t00 aa83b31t00 = new Aa83b31t00();

			Aa83bTelematicaController.logger.info("Guardado el Histo TRAM:");
			// Introduzco un nuevo registro de Acceso
			this.aa83b06t00Service.add(aa83bSolicitudesUtil.guardarAccesoADE(aa83b21t00, tipoAcceso, "N"));
			aa83b31t00.setId021NumSol(Integer.parseInt(numSol));
			aa83b31t00.setIdAno021(Long.parseLong(anoSol));
			aa83b31t00.setIdTramite(0);
			aa83b31t00.setConFaseTramite(true);
			List<Aa83b31t00> listAa83b31t00 = this.aa83b31t00Service.findAllLike(aa83b31t00, null, false);
			int i;
			for (i=0; i< listAa83b31t00.size();i++)
			{
				aa83b31t00 = listAa83b31t00.get(i);
				aa83b31t00.setId009HistoTram(idHistTramite);
				this.aa83b31t00Service.update(aa83b31t00);	
			}
			
			
		} else if (tipoSol.equals(Aa83BConstants.COD_ESF_STR)) {
			Aa83b23t00 aa83b23t00 = new Aa83b23t00();
			aa83b23t00.setId023(Integer.parseInt(numSol));
			aa83b23t00.setIdAno023(Long.parseLong(anoSol));
			aa83b23t00 = this.aa83b23t00Service.find(aa83b23t00);

			Aa83b10t00 aa83b10t00 = this.aa83b10t00Service.add(aa83bSolicitudesUtil.guardarHistoESF(aa83b23t00, Aa83BConstants.COD_FASE_1, idTramite, "N"));
			idHistTramite = aa83b10t00.getId010();

			Aa83b32t00 aa83b32t00 = new Aa83b32t00();
			aa83b32t00.setId023NumSol(Integer.parseInt(numSol));
			aa83b32t00.setIdAno023(Long.parseLong(anoSol));
			aa83b32t00.setIdTramite(0);
			aa83b32t00.setConFaseTramite(true);
			List<Aa83b32t00> listAa83b32t00 = this.aa83b32t00Service.findAllLike(aa83b32t00, null, false);
			int i;
			for (i=0; i< listAa83b32t00.size();i++)
			{
				aa83b32t00 = listAa83b32t00.get(i);
				aa83b32t00.setId010HistoTram(idHistTramite);
				this.aa83b32t00Service.update(aa83b32t00);	
			}
			
			// Introduzco un nuevo registro de Acceso
			this.aa83b07t00Service.add(aa83bSolicitudesUtil.guardarAccesoESF(aa83b23t00, tipoAcceso, "N"));
		} else if (tipoSol.equals(Aa83BConstants.COD_ARR_STR)) {
			Aa83b25t00 aa83b25t00 = new Aa83b25t00();
			aa83b25t00.setId025(Integer.parseInt(numSol));
			aa83b25t00.setIdAno025(Long.parseLong(anoSol));
			aa83b25t00 = this.aa83b25t00Service.find(aa83b25t00);

			Aa83b11t00 aa83b11t00 = this.aa83b11t00Service.add(aa83bSolicitudesUtil.guardarHistoARR(aa83b25t00, Aa83BConstants.COD_FASE_1, idTramite, "N"));
			idHistTramite = aa83b11t00.getId011();

			Aa83b33t00 aa83b33t00 = new Aa83b33t00();
			aa83b33t00.setId025NumSol(Integer.parseInt(numSol));
			aa83b33t00.setIdAno025(Long.parseLong(anoSol));
			aa83b33t00.setIdTramite(0);
			aa83b33t00.setConFaseTramite(true);
			List<Aa83b33t00> listAa83b33t00 = this.aa83b33t00Service.findAllLike(aa83b33t00, null, false);
			int i;
			for (i=0; i< listAa83b33t00.size();i++)
			{
				Aa83bTelematicaController.logger.info("Entro a actualizar los documentos");
				aa83b33t00 = listAa83b33t00.get(i);
				aa83b33t00.setId011HistoTram(idHistTramite);
				this.aa83b33t00Service.update(aa83b33t00);	
			}
			// Introduzco un nuevo registro de Acceso
			this.aa83b08t00Service.add(aa83bSolicitudesUtil.guardarAccesoARR(aa83b25t00, tipoAcceso, "N"));
		}

		// Modifico el estado de la solicitu en a T37
		aa83b37t00.setSituacion037(Aa83BConstants.ACEPTADA);
		aa83b37t00.setFregistro037(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(aa83b37t00.getFregistro037Str()));
		this.aa83b37t00Service.update(aa83b37t00);

		//Si es una subsanacion, hay que procesar los nuevos documentos adjuntados
		if (Aa83BConstants.COD_FASE_1.equals(aa83b37t00.getCodfase037()) && Aa83BConstants.COD_TRAM_4.equals(aa83b37t00.getCodtra037())){
			this.procesarSubsanacion (aa83b37t00, tipoSol, anoSol, numSol, idHistTramite);
		}
		
		// Genero URL de transicion al procesamietno
		return retorno;
	}

	/**
	 * @param filterBusqueda Aa83bBusqueda
	 * @param jqGridRequestDto JQGridRequestDto
	 * @return JQGridResponseDto<Aa83bBusqueda>
	 */
	@RequestMapping(value = "/jgrid/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<Aa83bBusqueda> search(
			@RequestJsonBody(param = "filter") Aa83bBusqueda filterBusqueda,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {

		MessageWriter messageWriter = new MessageWriter();

		messageWriter.startMessageList();

		messageWriter
				.addMessage("No se han encontrado Solicitudes que coincidan con los criterios de b�squeda");
		messageWriter.endMessageList();

		List<Aa83bBusqueda> responseGrid = new ArrayList<Aa83bBusqueda>();

		responseGrid = this.busquedaStandard(filterBusqueda, jqGridRequestDto,
				false);

		int total = this.totalGrid;

		return new JQGridResponseDto<Aa83bBusqueda>(jqGridRequestDto,
				(long) (total), responseGrid);
		// resultB);
		// return null;
	}

	/**
	 * @param filterBusqueda Aa83bBusqueda
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param b boolean
	 * @return List<Aa83bBusqueda>
	 */
	private List<Aa83bBusqueda> busquedaStandard(Aa83bBusqueda filterBusqueda,
			JQGridRequestDto jqGridRequestDto, boolean b) {
		Aa83b37t00 solTelematica = new Aa83b37t00();
		Aa83b41t00 solTelematicaDocs = new Aa83b41t00();
		List<Aa83bBusqueda> responseGrid = new ArrayList<Aa83bBusqueda>();
		List<Aa83bBusqueda> responseGridPaginado = new ArrayList<Aa83bBusqueda>();
		Locale locale = LocaleContextHolder.getLocale();
		List<Aa83b37t00> aa83b37t00List = new ArrayList<Aa83b37t00>();
		List<Aa83b41t00> aa83b41t00List = new ArrayList<Aa83b41t00>();
		solTelematica.setSituacion037(Aa83BConstants.VOLCADA);
		solTelematica.setTipoSol037(filterBusqueda.getTipoSol());
		solTelematica.setCodfase037(filterBusqueda.getIdfase());
		solTelematica.setCodtra037(filterBusqueda.getIdtramite());
		solTelematica.setFregistro037Str(filterBusqueda.getFecha());
		aa83b37t00List = this.aa83b37t00Service.findAllLike(solTelematica, null,
				false);

		int contaSolisT = aa83b37t00List.size();
		for (int i = 0; i < contaSolisT; i++) {
			Aa83bBusqueda resultB = new Aa83bBusqueda();
			solTelematica = aa83b37t00List.get(i);
			resultB.setSolConcat(solTelematica.getSolRelac());
			solTelematicaDocs.setIdCod037(solTelematica.getId037());
			aa83b41t00List = this.aa83b41t00Service.findAllLike(solTelematicaDocs,null, false);
			resultB.setNum_docs_adj(aa83b41t00List.size());
			// resultB.setFecha(solTelematica.getFregistro037().toString());
			resultB.setFecha(solTelematica.getFregistro037Str());
			resultB.setNumReg(solTelematica.getNumreg037());
			resultB.setNombre_sol(solTelematica.getRemitenteNom037());
			resultB.setFaseEs(solTelematica.getId037().toString());

			// Calculo el Estado
			Aa83b02t00 descTramita = new Aa83b02t00();
			if (Aa83BConstants.COD_FASE_1.equals(solTelematica.getCodfase037()) && Aa83BConstants.COD_TRAM_4.equals(solTelematica.getCodtra037())){
				descTramita.setId001Fase(Integer.parseInt(solTelematica.getCodfase037()));
				descTramita.setId002(Integer.parseInt(solTelematica.getCodtra037()));
				descTramita.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
				descTramita = this.aa83b02t00Service.find (descTramita);
			} else {
				List<Aa83b02t00> descTramitaList = this.aa83b02t00Service.findAllLike(descTramita, null, false);
				descTramita = descTramitaList.get(0);
				descTramita.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_1));
				descTramita.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_0));
				descTramita.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
			}
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase().equals(locale.getLanguage().toUpperCase())) {
				resultB.setEstado(descTramita.getDescEs002());
			} else {
				resultB.setEstado(descTramita.getDescEu002());
			}

			responseGrid.add(resultB);
		}
		// Paginamos:
		this.totalGrid = responseGrid.size();

		if (jqGridRequestDto.getPage() != 1) {
			// Paginamos
			int p = (int) ((jqGridRequestDto.getPage() - 1) * jqGridRequestDto
					.getRows());

			for (int pag = p; (pag < responseGrid.size()); pag++) {
				responseGridPaginado.add(responseGrid.get(pag));
			}

			// Miro si es la ultima página:
			if ((responseGrid.size() - (jqGridRequestDto.getPage() * jqGridRequestDto
					.getRows())) <= 0) {

			} else {
				if (jqGridRequestDto.getPage() != 1) {
					for (int pant = 0; pant < p; pant++) {
						responseGridPaginado.add(responseGrid.get(pant));
					}
				}
			}

		} else {
			responseGridPaginado = responseGrid;
		}

		return responseGridPaginado;
	}
	
	
	/**
	 * @param aa83b37t00 Aa83b37t00
	 * @param tipoSol String
	 * @param anoSol String
	 * @param numSol String
	 * @param idHistTramite int
	 */
	private void procesarSubsanacion (Aa83b37t00 aa83b37t00, String tipoSol, String anoSol, String numSol, int idHistTramite) {
		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();

		//Recuperar los documentos que se han adjuntado en la subsanacion 
		List<Aa83b41t00> aa83b41t00List = this.getListaDocumentosAdjuntos(aa83b37t00.getId037());

		Aa83b41t00 aa83b41t00 = new Aa83b41t00();
		Aa83bTelematicaController.logger.info("Tenemos estos adjuntos en ESF:: " + aa83b41t00List.size());
		int listaSize =  aa83b41t00List.size();
		for (int i = 0; i < listaSize; i++) {
			aa83b41t00 = aa83b41t00List.get(i);

			List<Aa83b36t00> aa83b36t00List = this.getListaTiposDocumentos(aa83b41t00);
			
			Aa83bTelematicaController.logger.info("Docs aa83b36t00List"+ aa83b36t00List.size());
			StringBuffer descripOtros = new StringBuffer();
			if (aa83b41t00.getDescEs041() != null)  {
				descripOtros.append(aa83b41t00.getDescEs041());
			}

			if (aa83b41t00.getDescEu041() != null) {
				descripOtros.append("/").append(aa83b41t00.getDescEu041());
			}
		
			if (tipoSol.equals(Aa83BConstants.COD_ADE_STR)) {
				Aa83b31t00 aa83b31t00 = new Aa83b31t00();
				aa83b31t00.setIdAno021(Long.parseLong(anoSol));
				aa83b31t00.setId021NumSol(Integer.parseInt(numSol));
				aa83b31t00.setId009HistoTram(idHistTramite);
				aa83b31t00.setOid031Papel0(aa83b41t00.getIdCodOid041());
				aa83b31t00.setTipoAportacion031("A");
				aa83b31t00.setDescOtros031(descripOtros.toString());

				//Se graba en el objeto el tipo de documento de la aplicacion
				if (aa83b36t00List.size() == 0) {
					// Asimilamos a archivo generico
					aa83b31t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ADE")));
				} else {
					Aa83b36t00 aa83b36t00 = aa83b36t00List.get(0);
					// Guardo en la tabla 32
					// Busco el tipoDOC de la tabla 30
					List<Aa83b30t00> aa83b30t00List = this.getTipoDocSolicitudes(Integer.parseInt(Aa83BConstants.COD_ADE), 
							Integer.parseInt(Aa83BConstants.COD_FASE_1), Integer.parseInt(Aa83BConstants.COD_TRAM_4), aa83b36t00.getIdCodigo036());
					
					Aa83bTelematicaController.logger.info("aa83b30t00List:" + aa83b30t00List.size());
				
					if (aa83b30t00List.size() != 0) {
						aa83b31t00.setId030TipDocSol(aa83b30t00List.get(0).getId030());
					}
					else {
						Aa83bTelematicaController.logger.info("ES de OTROS :: " + aa83b30t00List.size());
						aa83b31t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ADE")));
					}
				}
				this.aa83b31t00Service.add(aa83b31t00);

			} else {
				if (tipoSol.equals(Aa83BConstants.COD_ESF_STR)) {
					Aa83b32t00 aa83b32t00 = new Aa83b32t00();
					aa83b32t00.setIdAno023(Long.parseLong(anoSol));
					aa83b32t00.setId023NumSol(Integer.parseInt(numSol));
					aa83b32t00.setId010HistoTram(idHistTramite);
					aa83b32t00.setOid032Papel0(aa83b41t00.getIdCodOid041());
					aa83b32t00.setTipoAportacion032("A");
					aa83b32t00.setDescOtros032(descripOtros.toString());

					//Se graba en el objeto el tipo de documento de la aplicacion
					if (aa83b36t00List.size() == 0) {
						// Asimilamos a archivo generico
						aa83b32t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ESF")));
					} else {
						Aa83b36t00 aa83b36t00 = aa83b36t00List.get(0);
						// Guardo en la tabla 32
						// Busco el tipoDOC de la tabla 30
						List<Aa83b30t00> aa83b30t00List = this.getTipoDocSolicitudes(Integer.parseInt(Aa83BConstants.COD_ESF), 
								Integer.parseInt(Aa83BConstants.COD_FASE_1), Integer.parseInt(Aa83BConstants.COD_TRAM_4), aa83b36t00.getIdCodigo036());
						
						Aa83bTelematicaController.logger.info("aa83b30t00List:" + aa83b30t00List.size());
					
						if (aa83b30t00List.size() != 0) {
							aa83b32t00.setId030TipDocSol(aa83b30t00List.get(0).getId030());
						}
						else {
							Aa83bTelematicaController.logger.info("ES de OTROS :: " + aa83b30t00List.size());
							aa83b32t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ESF")));
						}
					}
					this.aa83b32t00Service.add(aa83b32t00);
				} else {
					if (tipoSol.equals(Aa83BConstants.COD_ARR_STR)) {
						Aa83b33t00 aa83b33t00 = new Aa83b33t00();
						aa83b33t00.setIdAno025(Long.parseLong(anoSol));
						aa83b33t00.setId025NumSol(Integer.parseInt(numSol));
						aa83b33t00.setId011HistoTram(idHistTramite);
						aa83b33t00.setOid033Papel0(aa83b41t00.getIdCodOid041());
						aa83b33t00.setTipoAportacion033("A");
						aa83b33t00.setDescOtros033(descripOtros.toString());

						//Se graba en el objeto el tipo de documento de la aplicacion
						if (aa83b36t00List.size() == 0) {
							// Asimilamos a archivo generico
							aa83b33t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ARR")));
						} else {
							Aa83b36t00 aa83b36t00 = aa83b36t00List.get(0);
							// Guardo en la tabla 32
							// Busco el tipoDOC de la tabla 30
							List<Aa83b30t00> aa83b30t00List = this.getTipoDocSolicitudes(Integer.parseInt(Aa83BConstants.COD_ARR), 
									Integer.parseInt(Aa83BConstants.COD_FASE_1), Integer.parseInt(Aa83BConstants.COD_TRAM_4), aa83b36t00.getIdCodigo036());
							
							Aa83bTelematicaController.logger.info("aa83b30t00List:" + aa83b30t00List.size());
						
							if (aa83b30t00List.size() != 0) {
								aa83b33t00.setId030TipDocSol(aa83b30t00List.get(0).getId030());
							}
							else {
								Aa83bTelematicaController.logger.info("ES de OTROS :: " + aa83b30t00List.size());
								aa83b33t00.setId030TipDocSol(Integer.parseInt(Aa83bUtilProperties.getProperty("TIPO_DOKUSI_ARCHIVO_GEN_ARR")));
							}
						}
						this.aa83b33t00Service.add(aa83b33t00);
					}
				}
			}
		}
	}

	/**
	 * @param id037 int
	 * @return List<Aa83b41t00>
	 */
	private List<Aa83b41t00> getListaDocumentosAdjuntos(int id037) {

		Aa83b41t00 aa83b41t00 = new Aa83b41t00();
		aa83b41t00.setIdCod037(id037);
		return this.aa83b41t00Service.findAllLike(aa83b41t00, null, false);
	}	
	
	/**
	 * @param aa83b41t00 Aa83b41t00
	 * @return List<Aa83b36t00>
	 */
	private List<Aa83b36t00> getListaTiposDocumentos(Aa83b41t00 aa83b41t00 ) {

		String tipoDocusi = aa83b41t00.getMetaInf041().replace(".0", "");
		Aa83bTelematicaController.logger.info("Despues del Replace::" + tipoDocusi);
		String td_padre = null;
		String td_hijo = null;
		tipoDocusi = tipoDocusi.replace(".", ":");
		if (tipoDocusi.indexOf(":") != -1) {
			String[] trozos = tipoDocusi.split(":");
			td_padre = trozos[1];
			td_hijo = trozos[0];
		} else {
			td_padre = tipoDocusi;
		}
		Aa83b36t00 aa83b36t00 = new Aa83b36t00();
		aa83b36t00.setDescEs036(td_padre);
		aa83b36t00.setIdCodPadre(td_hijo);

		return this.aa83b36t00Service.findAllLike(aa83b36t00, null, false);
	}
	
	/**
	 * @param tipoSol int
	 * @param idFase int
	 * @param idTramite int
	 * @param idCod036 String
	 * @return List<Aa83b30t00>
	 */
	private List<Aa83b30t00> getTipoDocSolicitudes(int tipoSol, int idFase, int idTramite, String idCod036) {

		Aa83b30t00 aa83b30t00 = new Aa83b30t00();
		aa83b30t00.setId003TipoSol(tipoSol);
		aa83b30t00.setTdDokusi030(idCod036);
		aa83b30t00.setId001Fase(idFase);
		aa83b30t00.setId002Tram(idTramite);

		Aa83bTelematicaController.logger.info("Busco en la 30:" + aa83b30t00);

		List<Aa83b30t00> aa83b30t00List = this.aa83b30t00Service.findAllLike(aa83b30t00, null, false);

		Aa83bTelematicaController.logger.info("aa83b30t00List:" + aa83b30t00List.size());

		return aa83b30t00List;
		
	}	

}
