package com.ejie.aa83b.control;

import javax.servlet.http.HttpServletRequest;

import n38c.exe.N38API;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa83b.util.Aa83bSesionUtils;
import com.ejie.aa83b.util.Aa83bUtilSeguridad;
import com.ejie.x38.security.XlnetCore;

/**
 * PatronesController
 * 
 * @author UDA
 */
@Controller
@RequestMapping(value = "/")
public class Aa83bStartController {	

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bStartController.class);

	@RequestMapping(value = "/start", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {

		System.out.println("Estoy en el StartController ::: ");
		
		Aa83bStartController.logger.info("[GET - View] : getCreateForm INICIO");

		N38API n38Api;
		try {
			if (!Aa83bUtilSeguridad.enOficina()) {
				n38Api = XlnetCore.getN38API(request);

				if (!Aa83bUtilSeguridad.esPerfValido(request)) {
					return new ModelAndView("accessDenied", "model", model);
				} else {
					if (n38Api != null) {
						model.addAttribute("user_name",
								Aa83bSesionUtils.getUserName());
						model.addAttribute("userName",
								Aa83bSesionUtils.getUserName());
						model.addAttribute("userFullName",
								Aa83bSesionUtils.getUserFullName());

						Aa83bStartController.logger
								.info("[GET - View] : getCreateForm n38Api getSecurityProfiles="
										+ Aa83bSesionUtils.getSecurityProfiles());

						model.addAttribute("userProfiles",Aa83bSesionUtils.getProfiles(request));
						model.addAttribute("userUid",Aa83bSesionUtils.getUidSession());

					} else {

						model.addAttribute("userName", "");

						Aa83bStartController.logger.info("[GET - View] : getCreateForm n38Api != null else ******** user_name=");
					}
				}
			}

		} catch (Exception e) {
			Aa83bStartController.logger.error("[Aa83bStartController Exception]" + e.getMessage());
			// Ponemos la sesion a mano:
			model.addAttribute("userName", "Usuario LOCAL");
			model.addAttribute("user_name", "Usuario LOCAL");
			model.addAttribute("userFullName", "Inigo BLA BLA");
			model.addAttribute("userProfiles", "AA83B-PF-0009");
			model.addAttribute("userUid", "UID");
			// n38Api.
		}
		return new ModelAndView("welcome", "model", model);
	}
}
