package com.ejie.aa83b.control;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ejie.aa83b.model.A83bPais;
import com.ejie.aa83b.model.Aa83b04t00;
import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b10t00;
import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.model.Aa83b12t00;
import com.ejie.aa83b.model.Aa83b18t00;
import com.ejie.aa83b.model.Aa83b19t00;
import com.ejie.aa83b.model.Aa83b20t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b21v00;
import com.ejie.aa83b.model.Aa83b22t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b24t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83b26t00;
import com.ejie.aa83b.model.Aa83b27t00;
import com.ejie.aa83b.model.Aa83b30t00;
import com.ejie.aa83b.model.Aa83b31v01;
import com.ejie.aa83b.model.Aa83bBusquedaComunicaciones;
import com.ejie.aa83b.model.Aa83bDocumentoDokusi;
import com.ejie.aa83b.model.Aa83bTipoDocumento;
import com.ejie.aa83b.service.Aa83b04t00Service;
import com.ejie.aa83b.service.Aa83b09t00Service;
import com.ejie.aa83b.service.Aa83b10t00Service;
import com.ejie.aa83b.service.Aa83b11t00Service;
import com.ejie.aa83b.service.Aa83b12t00Service;
import com.ejie.aa83b.service.Aa83b18t00Service;
import com.ejie.aa83b.service.Aa83b19t00Service;
import com.ejie.aa83b.service.Aa83b20t00Service;
import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b22t00Service;
import com.ejie.aa83b.service.Aa83b23t00Service;
import com.ejie.aa83b.service.Aa83b24t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83b26t00Service;
import com.ejie.aa83b.service.Aa83b27t00Service;
import com.ejie.aa83b.service.Aa83b30t00Service;
import com.ejie.aa83b.service.Aa83b31t00Service;
import com.ejie.aa83b.service.Aa83bNoraService;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bMessageParser;
import com.ejie.aa83b.util.Aa83bSesionUtils;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.aa83b.util.Aa83bUtilProperties;
import com.ejie.aa83b.util.Aa83bUtilSeguridad;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContext;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContextParser;
import com.ejie.aa83b.util.tramita.Aa83bUtilNotificacion;
import com.ejie.aa83b.util.xml.Aa83bXMLGenerator;
import com.ejie.aa83b.webservice.client.aa19b.DocumentoWebServiceImpl;
import com.ejie.aa83b.webservice.client.dokusi.T65BFSDWSClasePort;
import com.ejie.aa83b.webservice.client.r02.Q99DSRTFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.Q99RCPFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.tramitacion.Q99MServiceIfzFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.vdc.Q99USendMessageSCPFacadeWSSoap;
import com.ejie.aa83b.webservice.client.x43.nshf.EjgvDocumentType;
import com.ejie.aa83b.webservice.client.x43.nshf.X43FNSHF;
import com.ejie.aa83b.webservice.client.y13b.Y13BQRWebServiceImpl;
import com.ejie.schemas.t65b.T65BDocumentIDType;
import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;
/**
 * @author blarreina
 *
 */
/**
 * @author blarreina
 *
 */
@Controller
@RequestMapping(value = "/pifController")
public class Aa83bPifController {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bPifController.class);

	/** The service. */
	@Autowired()
	private Aa83b31t00Service aa83b31t00Service;	
	
	/** The service. */
	@Autowired()
	private Aa83b18t00Service aa83b18t00Service;
	
	/** The service. */
	@Autowired()
	private Aa83b19t00Service aa83b19t00Service;

	/** The service. */
	@Autowired()
	private Aa83b04t00Service aa83b04t00Service;

	/** The service. */
	@Autowired()
	private Aa83b30t00Service aa83b30t00Service;

	/** The service. */
	@Autowired()
	private Aa83b21t00Service aa83b21t00Service;

	/** The service. */
	@Autowired()
	private Aa83b23t00Service aa83b23t00Service;

	/** The service. */
	@Autowired()
	private Aa83b25t00Service aa83b25t00Service;

	/** The service. */
	@Autowired()
	private Aa83b20t00Service aa83b20t00Service;

	/** The service. */
	@Autowired()
	private Aa83b22t00Service aa83b22t00Service;

	/** The service. */
	@Autowired()
	private Aa83b24t00Service aa83b24t00Service;

	/** The service. */
	@Autowired()
	private Aa83b09t00Service aa83b09t00Service;

	/** The service. */
	@Autowired()
	private Aa83b10t00Service aa83b10t00Service;

	/** The service. */
	@Autowired()
	private Aa83b11t00Service aa83b11t00Service;

	/** The service. */
	@Autowired()
	private Aa83b12t00Service aa83b12t00Service;

	/** The a83b nora service. */
	@Autowired()
	private Aa83bNoraService a83bNoraService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private DocumentoWebServiceImpl documentoWebServiceImpl;

	@Autowired()
	private T65BFSDWSClasePort t65bService;

	@Autowired()
	private Y13BQRWebServiceImpl qrWebService;
	
	@Autowired()
	private Aa83b26t00Service aa83b26t00Service;
	
	@Autowired()
	private Aa83b27t00Service aa83b27t00Service;
	
	@Autowired()
	private Q99MServiceIfzFacadeWSSoap q99mServiceIfzFacadeWS;
	
	@Autowired()
	private Q99RCPFacadeWSSoap q99RCPFacadeWSSoap;
	
	@Autowired()
	private Q99DSRTFacadeWSSoap q99DSRTFacadeWSSoap;
	
	@Autowired()
	private Q99USendMessageSCPFacadeWSSoap q99uSendMessageSCPFacadeWSSoap;
	
	@Autowired()
	private X43FNSHF x43fnshf;
	

	@RequestMapping(value = "/firmarDoc", method = RequestMethod.GET)
	public @ResponseBody()
	HashMap<String, String> firmarDoc(
			@RequestParam(value = "idDoc", required = true) String idDoc,
			@RequestParam(value = "tipo", required = true) String tipoSolicitud,
			@RequestParam(value = "resolSubsana", required = true) String resolSubsana,
			
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		HashMap<String, String> retorno = new HashMap<String, String>();

		
		
		Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		String integrationToken = Aa83bUtilSeguridad.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);
		int idSol=0;
		Document xmlSesionDocument = builder.parse(new ByteArrayInputStream(integrationToken.getBytes("UTF-8")));// NOPMD

		
		Aa83b20t00 aa83b20t00 = new Aa83b20t00();
		Aa83b22t00 aa83b22t00 = new Aa83b22t00();
		Aa83b24t00 aa83b24t00 = new Aa83b24t00();
		String idPif="";
		int tipoDocumentoGenerado=0;
		String anyoSol="";
		
		String procedure="";
		
		String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
		String idProcAdecuacion = this.appConfiguration.getProperty("procedure.adecuacion.id");
		String idProcEsfuerzo = this.appConfiguration.getProperty("procedure.esfuerzo.id");
		String idProcArraigo = this.appConfiguration.getProperty("procedure.arraigo.id");
	
		
		Aa83bConsultationContextParser resParser = new Aa83bConsultationContextParser();
		Aa83bConsultationContext res;
		if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
			aa83b20t00.setId020(Integer.parseInt(idDoc));
			// Sacamos la info del Doc idDoc
			aa83b20t00 = this.aa83b20t00Service.find(aa83b20t00);
			idPif=aa83b20t00.getIdPif020();
			tipoDocumentoGenerado=aa83b20t00.getId004TipoDocG();
			Aa83bPifController.logger.info("Encontrado firmar Doc ADE : " + aa83b20t00.toString());
			idSol=aa83b20t00.getId021SolAde();
			anyoSol=aa83b20t00.getIdAno021().toString();
			Aa83bPifController.logger.info("anyoSol : " + anyoSol);
			procedure = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcAdecuacion);
			resParser = new Aa83bConsultationContextParser(procedure);
			
			
			// Primero, pasamos el DOC de PIF a Dokusi
		}else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
			aa83b22t00.setId022(Integer.parseInt(idDoc));
			// Sacamos la info del Doc idDoc
			aa83b22t00 = this.aa83b22t00Service.find(aa83b22t00);
			idPif=aa83b22t00.getIdPif022();
			tipoDocumentoGenerado=aa83b22t00.getId004TipoDocG();
			Aa83bPifController.logger.info("Encontrado firmar Doc ESF: " + aa83b22t00.toString());
			idSol=aa83b22t00.getId023SolEsf();
			anyoSol=aa83b22t00.getIdAno023().toString();
			Aa83bPifController.logger.info("anyoSol : " + anyoSol);
			procedure = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcEsfuerzo);
			resParser = new Aa83bConsultationContextParser(procedure);
			
			
			// Primero, pasamos el DOC de PIF a Dokusi
		}else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
			aa83b24t00.setId024(Integer.parseInt(idDoc));
			// Sacamos la info del Doc idDoc
			aa83b24t00 = this.aa83b24t00Service.find(aa83b24t00);
			idPif=aa83b24t00.getIdPif024();
			tipoDocumentoGenerado=aa83b24t00.getId004TipoDocG();
			Aa83bPifController.logger.info("Encontrado firmar Doc ARR: " + aa83b24t00.toString());
			idSol=aa83b24t00.getIdNumSol025();
			anyoSol=aa83b24t00.getIdAno025().toString();
			Aa83bPifController.logger.info("anyoSol : " + anyoSol);
			procedure = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcArraigo);
			resParser = new Aa83bConsultationContextParser(procedure);
			
			
			// Primero, pasamos el DOC de PIF a Dokusi
		}
		res = resParser.getProcedureDataAll();
		
		// Si no está informado auditUserDokusi, se coge el de seguridad
		String auditUser = this.getAuditUser();

		// InputStream fichSalida = null;
		// try {
		// // Llamada a PIF
		// fichSalida = service.get(xmlSesionDocument,
		// aa83b20t00.getIdPif020());
		// } catch (Exception e) {
		//
		// System.out.println("Exception  service.get: " + e.getMessage());
		// }

		// System.out.println("fichSalida : " + fichSalida.toString().length());

		// Copiamos el fichero en la ruta /t65e/aa83b/ para que Dokusi pueda
		// tratarlo:

		String rutaT65e = "/t65e/aa83b/";
		Aa83bDocumentoDokusi documentoGuardar = new Aa83bDocumentoDokusi();
		documentoGuardar.setExtension("doc");
		documentoGuardar.setAuditUserDokusi(auditUser);
		documentoGuardar.setContentType("application/msword");
		
		Aa83bTipoDocumento tipoDocumento = new Aa83bTipoDocumento();
		tipoDocumento.setTipoDocumental("doc");
		documentoGuardar.setTipoDocumento(tipoDocumento);
		
		
		//Y31AttachmentBean ficheroNuevoPifT65e = service.copy(xmlSesionDocument,this.appConfiguration.getProperty("RUTA_PIF_APP").concat(idPif), rutaT65e, true);// NOPMD
		Y31AttachmentBean ficheroNuevoPifT65e = service.copy(xmlSesionDocument,	this.appConfiguration.getProperty("RUTA_PIF_APP").concat(idPif), rutaT65e.concat(idPif), true);// NOPMD
		// Llamada a Dokusi
		String t65bContentType = "application/msword";
		String tipoDocumental = null;
		String t65bAttributeList="";
		
		if ((tipoDocumentoGenerado == new Integer(Aa83BConstants.DOC_REQ_SUB_ADE)) || 
			(tipoDocumentoGenerado == new Integer(Aa83BConstants.DOC_REQ_SUB_ESF)) || 
			(tipoDocumentoGenerado == new Integer(Aa83BConstants.DOC_REQ_SUB_ARR)))
		{
			tipoDocumental = "ejgv_d_requsubs";
			t65bAttributeList = "<attributeList><attribute><key>ejgv_origen</key><value>ORGANISMO_EXTERNO</value></attribute>"
			+ "<attribute><key>acl_name</key><value>ejgv_acl_d_AA83B_001</value></attribute><attribute><key>ejgv_serie</key><value>"+res.getDocumentalSeriesId()+"</value></attribute>"
			+ "<attribute><key>title</key><value>Requerimiento de Subsanacin</value></attribute>"
			+ "<attribute><key>object_name</key><value>ejgv_d_requsubs</value></attribute></attributeList>";
			tipoDocumento.setNombreEs("Requerimiento de Subsanacin");
			tipoDocumento.setNombreEu("Zuzentzeko Errekerimendua");
		}else
		{
			tipoDocumental = "ejgv_d_resolucion";
			t65bAttributeList = "<attributeList><attribute><key>ejgv_origen</key><value>ORGANISMO_EXTERNO</value></attribute>"
			+ "<attribute><key>acl_name</key><value>ejgv_acl_d_AA83B_001</value></attribute><attribute><key>ejgv_serie</key><value>"+res.getDocumentalSeriesId()+"</value></attribute>"
			+ "<attribute><key>title</key><value>Resolucin</value></attribute>"
			+ "<attribute><key>object_name</key><value>ejgv_d_resolucion</value></attribute></attributeList>";
			tipoDocumento.setNombreEs("Informe de resolucin");
			tipoDocumento.setNombreEu("Ebazpenaren txostena");
		}
		Aa83bPifController.logger.info("documentoGuardar - Aqui 1");

		

		//String nombreDocumentoNuevo = "";
		/*ArrayList<String> partesRuta = new ArrayList<String>(Arrays.asList(idPif.split("/")));

		if (partesRuta != null && partesRuta.size() > 0) {
			nombreDocumentoNuevo = partesRuta.get(partesRuta.size() - 1);
		}
		
		Aa83bPifController.logger.info("documentoGuardar - Aqui 5.1:"+ ficheroNuevoPifT65e.getFilePath() + nombreDocumentoNuevo);

		t65bContentType = "<content><pifId>"+ ficheroNuevoPifT65e.getFilePath()	+ nombreDocumentoNuevo
				+ "</pifId><format><extension>DOC</extension><mimeType>application/msword</mimeType>"+ "</format></content>";

		documentoGuardar.setRutaPif(ficheroNuevoPifT65e.getFilePath()+ nombreDocumentoNuevo);
*/
		
		t65bContentType = "<content><pifId>"
			+ ficheroNuevoPifT65e.getFilePath()
			//+"/aa83b/aa83b_adjuntos/09f424018076d1a71463646227401.doc"
				+ "</pifId><format><extension>DOC</extension><mimeType>application/msword</mimeType>"
				+ "</format></content>";

		 documentoGuardar.setRutaPif(ficheroNuevoPifT65e.getFilePath());
		//documentoGuardar.setRutaPif("/aa83b/aa83b_adjuntos/09f424018076d1a71463646227401.doc");
		 
		

		Aa83bPifController.logger.info("documentoGuardar - Aqui 6:");

		Aa83bDocumentoDokusi respuestaDoc = new Aa83bDocumentoDokusi();
		String oid="";
		try {
			String respuesta = this.t65bService.storeDocument(integrationToken,	auditUser, t65bContentType, tipoDocumental,	t65bAttributeList);

			T65BDocumentIDType obj = (T65BDocumentIDType) new Aa83bMessageParser<T65BDocumentIDType>(T65BDocumentIDType.class.getPackage().getName()).parse(respuesta);
			Aa83bPifController.logger.info("Respuesta:" + respuesta.toString());
			
			if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
				aa83b20t00.setOid020(obj.getId());
				aa83b20t00.setIdPif020("");
				aa83b20t00 = this.aa83b20t00Service.update(aa83b20t00);
				oid=aa83b20t00.getOid020();
			}else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
				aa83b22t00.setOid022(obj.getId());
				aa83b22t00.setIdPif022("");
				aa83b22t00 = this.aa83b22t00Service.update(aa83b22t00);
				oid=aa83b22t00.getOid022();
			}else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
				aa83b24t00.setOid024(obj.getId());
				aa83b24t00.setIdPif024("");
				aa83b24t00 = this.aa83b24t00Service.update(aa83b24t00);
				oid=aa83b24t00.getOid024();
			}
		} catch (Exception e) {

			Aa83bPifController.logger.info("Exception storeDocument: " + e.getMessage());
		}
		Aa83bPifController.logger.info("respuestaDoc: " + respuestaDoc.toString());
		Aa83bPifController.logger.info("oid: " + oid);
		

	
		boolean notifTelematica=false;
		
		// **********cdigo para generar las comunicaciones telemticas
	
		String idProcedimiento = "";
		Aa83b21t00 aa83b21t00 = null;
		Aa83b23t00 aa83b23t00 = null;
		Aa83b25t00 aa83b25t00 = null;
		Aa83bBusquedaComunicaciones aa83bBusquedaComunicaciones = new Aa83bBusquedaComunicaciones();
		aa83bBusquedaComunicaciones.setDescTramiteEs(tipoDocumento.getNombreEs());
		aa83bBusquedaComunicaciones.setDescTramiteEu(tipoDocumento.getNombreEu());
		if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
			idProcedimiento = this.appConfiguration.getProperty("procedure.adecuacion.id");
			aa83b21t00 = new Aa83b21t00();
			aa83b21t00.setId021(idSol);
			aa83b21t00.setIdAno021(Long.valueOf(anyoSol));
			Aa83bPifController.logger.info("anyoSoltoLong : "+ Long.valueOf(anyoSol));
			aa83b21t00 = this.aa83b21t00Service.find(aa83b21t00);
			Aa83bPifController.logger.info("aa83b21t00 para conmunica: "+ aa83b21t00);
			
			if ("T".equals(aa83b21t00.getTipoNotificacion021())){
				notifTelematica=true;
			}
			//para adjunto remito
			aa83bBusquedaComunicaciones.setDomicilio(aa83b21t00.getCalleComunic021() + aa83b21t00.getNumeroComunic021());
			aa83bBusquedaComunicaciones.setCpostal(aa83b21t00.getCpostalComunic021());
			aa83bBusquedaComunicaciones.setLocalidad(aa83b21t00.getMunicipComunic021());
			aa83bBusquedaComunicaciones.setProvincia(aa83b21t00.getProvinciaComunic021());
			aa83bBusquedaComunicaciones.setReferencia(Aa83BConstants.COD_ADE+" "+aa83b21t00.getIdAno021() + " "+aa83b21t00.getId021());
			aa83bBusquedaComunicaciones.setRazon(aa83b21t00.getNombre021()+ " " + aa83b21t00.getApel1021()+ " " +aa83b21t00.getApel2021());
			
			

		} else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
			idProcedimiento = this.appConfiguration.getProperty("procedure.esfuerzo.id");
			aa83b23t00 = new Aa83b23t00();
			aa83b23t00.setId023(idSol);
			aa83b23t00.setIdAno023(Long.valueOf(anyoSol));
			Aa83bPifController.logger.info("anyoSoltoLong : "+ Long.valueOf(anyoSol));
			aa83b23t00 = this.aa83b23t00Service.find(aa83b23t00);
			Aa83bPifController.logger.info("aa83b23t00 para conmunica: "+ aa83b23t00);
			
			if ("T".equals(aa83b23t00.getTipoNotificacion023())){
				notifTelematica=true;
			}
			//para adjunto remito
			aa83bBusquedaComunicaciones.setDomicilio(aa83b23t00.getCalleComunic023() + aa83b23t00.getNumeroComunic023());
			aa83bBusquedaComunicaciones.setCpostal(aa83b23t00.getCpostalComunic023());
			aa83bBusquedaComunicaciones.setLocalidad(aa83b23t00.getMunicipComunic023());
			aa83bBusquedaComunicaciones.setProvincia(aa83b23t00.getProvinciaComunic023());
			aa83bBusquedaComunicaciones.setReferencia(Aa83BConstants.COD_ESF+" "+aa83b23t00.getIdAno023() + " "+aa83b23t00.getId023());
			aa83bBusquedaComunicaciones.setRazon(aa83b23t00.getNombre023()+ " " + aa83b23t00.getApel1023()+ " " +aa83b23t00.getApel2023());

		} else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
			idProcedimiento = this.appConfiguration
					.getProperty("procedure.arraigo.id");
			aa83b25t00 = new Aa83b25t00();
			aa83b25t00.setId025(idSol);
			aa83b25t00.setIdAno025(Long.valueOf(anyoSol));
			Aa83bPifController.logger.info("anyoSoltoLong : "
					+ Long.valueOf(anyoSol));
			aa83b25t00 = this.aa83b25t00Service.find(aa83b25t00);
			Aa83bPifController.logger.info("aa83b25t00 para conmunica: "+ aa83b25t00);
			
			if ("T".equals(aa83b25t00.getTipoNotificacion025())){
				notifTelematica=true;
			}
			
			//para adjunto remito
			aa83bBusquedaComunicaciones.setDomicilio(aa83b25t00.getCalleComunic025() + aa83b25t00.getNumeroComunic025());
			aa83bBusquedaComunicaciones.setCpostal(aa83b25t00.getCpostalComunic025());
			aa83bBusquedaComunicaciones.setLocalidad(aa83b25t00.getMunicipComunic025());
			aa83bBusquedaComunicaciones.setProvincia(aa83b25t00.getProvinciaComunic025());
			aa83bBusquedaComunicaciones.setReferencia(Aa83BConstants.COD_ARR+" "+aa83b25t00.getIdAno025() + " "+aa83b25t00.getId025());
			aa83bBusquedaComunicaciones.setRazon(aa83b25t00.getNombre025()+ " " + aa83b25t00.getApel1025()+ " " +aa83b25t00.getApel2025());
		}
		String notifEnviada="N";
		
		String resultadoPublish="";
		if (notifTelematica)
		{
		
			//////*******///// comienzo de generar adjunto remito para las solicitudes con canal de comunicacin telemtico///////*******/////
		
			Aa83bPifController.logger.info("adjunto remito 0.");
		
			ArrayList<Aa83bBusquedaComunicaciones> listaAdjuntoRemito = new ArrayList<Aa83bBusquedaComunicaciones>();
			listaAdjuntoRemito.add(aa83bBusquedaComunicaciones);
			// Recuperamos la plantilla de la BD
			Aa83b04t00 plantilla = this.aa83b04t00Service.findTemplateByName("ADJUNTOREMITO");
			Aa83bPifController.logger.info("adjunto remito 1. plantilla "+ plantilla);
		
			// obtenemos el fichero guardado en el bean
			Blob fichero = plantilla.getTemplate004();
			String oidRemito = "";
			// SI SE HA SUBIDO PREVIAMENTE UNA PLANTILLA
			if (fichero != null) {
				// System.out.println("generarAcuses fichero != null=");
			
				try {

					// DESARROLLO
					
					String procedureAdecuacion="";
					String procedureEsfuerzo="";
					String procedureArraigo="";
				
					// llamada al getProcedureFac para recuperar los datos del procedimiento

					try {
						procedureAdecuacion = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcAdecuacion);
						procedureEsfuerzo = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcEsfuerzo);
						procedureArraigo = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcArraigo);

						Aa83bPifController.logger.info("procedureAdecuacion-->"+ procedureAdecuacion);
						Aa83bPifController.logger.info("procedureEsfuerzo-->"+ procedureEsfuerzo);
						Aa83bPifController.logger.info("procedureArraigo-->"+ procedureArraigo);
					}catch (Exception e) {
						//	Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: EXCEPCION getProcedureFac: ="+ e.toString());
						Aa83bPifController.logger.error(e.getMessage());
					}
				
					// DESARROLLO
					xmlSesionDocument = builder.parse(new ByteArrayInputStream(sesionToken.getBytes("UTF-8")));

					// INICIO Subimos la plantilla RTF a PIF
					String rutaDoc = Aa83bUtilProperties.PIF_PATH + "Plantilla"+ plantilla.getNomTemplate004() + ".rtf";
			
					InputStream is = new ByteArrayInputStream(plantilla.getPlantilla004());
					Aa83bPifController.logger.info("adjunto remito 2 antes del put "+ rutaDoc);
					Y31AttachmentBean rdoRTF = service.put(xmlSesionDocument, is,rutaDoc, new Long(Aa83BConstants.CIENTOVEINTE));
					Aa83bPifController.logger.info("adjunto remito despus del put "+ rdoRTF.getFilePath());
					String pathPifPlantilla = rdoRTF.getFilePath();

					// FIN Subimos la plantilla RTF a PIF

					// Inicio Libro de registro
					String userNif = Aa83bSesionUtils.getUserNif();
					String userFullName = Aa83bSesionUtils.getUserFullName();

					int pos1=procedureAdecuacion.indexOf("<managingUnitId>");
					int pos2=procedureAdecuacion.indexOf("</managingUnitId>");
					String managingIdHAB=procedureAdecuacion.substring(pos1+16,pos2);
				
					pos1=procedureEsfuerzo.indexOf("<managingUnitId>");
					pos2=procedureEsfuerzo.indexOf("</managingUnitId>");
					String managingIdESF=procedureEsfuerzo.substring(pos1+16,pos2);
					
					pos1=procedureArraigo.indexOf("<managingUnitId>");
					pos2=procedureArraigo.indexOf("</managingUnitId>");
					String managingIdARR=procedureArraigo.substring(pos1+16,pos2);
	
					pos1=procedureAdecuacion.indexOf("<managingUnitName>");
					pos2=procedureAdecuacion.indexOf("</managingUnitName>");
					String managingUnitHAB=procedureAdecuacion.substring(pos1+18,pos2);
					
					pos1=procedureArraigo.indexOf("<managingUnitName>");
					pos2=procedureArraigo.indexOf("</managingUnitName>");
					String managingUnitARR=procedureArraigo.substring(pos1+18,pos2);
					
					pos1=procedureEsfuerzo.indexOf("<managingUnitName>");
					pos2=procedureEsfuerzo.indexOf("</managingUnitName>");
					String managingUnitESF=procedureEsfuerzo.substring(pos1+18,pos2);
					
					
					pos1=procedureAdecuacion.indexOf("<procedureName>");
					pos2=procedureAdecuacion.indexOf("</procedureName>");
					String procedureNameHAB=procedureAdecuacion.substring(pos1+15,pos2);
	
					
					pos1=procedureEsfuerzo.indexOf("<procedureName>");
					pos2=procedureEsfuerzo.indexOf("</procedureName>");
					String procedureNameESF=procedureEsfuerzo.substring(pos1+15,pos2);
					
					pos1=procedureArraigo.indexOf("<procedureName>");
					pos2=procedureArraigo.indexOf("</procedureName>");
					String procedureNameARR=procedureArraigo.substring(pos1+15,pos2);
					
					
					
					Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
					// Recuperar los datos del procedimiento para cada tipo de
					// solicitud
					String sXmlContextRegistryHAB = aa83bXMLGenerator.sXmlExit(idProcAdecuacion, procedureNameHAB, userNif, userFullName, managingIdHAB, managingUnitHAB);
					String sXmlContextRegistryESF = aa83bXMLGenerator.sXmlExit(idProcEsfuerzo, procedureNameESF, userNif, userFullName, managingIdESF,managingUnitESF);
					String sXmlContextRegistryARR = aa83bXMLGenerator.sXmlExit(idProcArraigo, procedureNameARR, userNif, userFullName, managingIdARR,managingUnitARR);
	
					String entryRegistry = "";
					HashMap<String, String> seleccionadosResgistro = new HashMap(); 
					try {
						// Por cada solicitud seleccionada, hay q crear una entrada
						// en el libro, dependiendo del tipo HAB, ARR, ESF
						//String tipo = "";
	
						//for (int i = 0; i < seleccionados.size(); i++) {
							if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
								entryRegistry = this.q99DSRTFacadeWSSoap.createExitRegistry(sesionToken,sXmlContextRegistryHAB);
							} else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
								entryRegistry = this.q99DSRTFacadeWSSoap.createExitRegistry(sesionToken,sXmlContextRegistryESF);
							} else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
								entryRegistry = this.q99DSRTFacadeWSSoap.createExitRegistry(sesionToken,sXmlContextRegistryARR);
							}
	
							// REcupero el registryNumber
							int posicion1 = entryRegistry.indexOf("<registryNumber>");
							int posicion2 = entryRegistry.indexOf("</registryNumber>");
							entryRegistry = entryRegistry.substring(posicion1 + 16,posicion2);
							
							seleccionadosResgistro.put(aa83bBusquedaComunicaciones.getReferencia(), entryRegistry);
						//}
					} catch (Exception e) {
						// TODO Auto-generated catch block
	//					Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: EXCEPCION Inscripcion en el libro de registro: ="+ e.toString());
						Aa83bPifController.logger.error(e.getMessage());
					}
	
					// Fin Libro de registro
	
					// Buscamos los datos para los adjunto remito de los registros
					// seleccionados, vista 4
					
					// GEnerar el xml xon los datos de los acuses seleccionados
					Aa83bPifController.logger.info("adjunto remito 2 antes del generateXMLAdjuntoRemito "+ rutaDoc);
					
					String cadenaXML = aa83bXMLGenerator.generateXMLAdjuntoRemito(listaAdjuntoRemito, seleccionadosResgistro, true);
					
					Aa83bPifController.logger.info("adjunto remito cadenaXML "+ cadenaXML);
					
					// INICIO Subimos el xml a PIF
					String rutaXML = Aa83bUtilProperties.PIF_PATH+ plantilla.getNomTemplate004() + ".xml";
					Aa83bPifController.logger.info("adjunto remito rutaXML "+ rutaDoc);
					InputStream isXML = new ByteArrayInputStream(cadenaXML.getBytes("UTF-8"));// NOPMD
					Aa83bPifController.logger.info("adjunto remito isXML "+ isXML);
					
					Y31AttachmentBean rdoXML = service.put(xmlSesionDocument,isXML, rutaXML, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
					
					Aa83bPifController.logger.info("adjunto remito despus del put del xml "+ rdoXML);
					String pathPifXML = rdoXML.getFilePath();
	
					
					// FIN Subimos el xml a PIF
	
					// Llamamos al metodo create de aa19
					String pathPifDocGenerado = Aa83bUtilProperties.PIF_PATH+ plantilla.getNomTemplate004() + ".rtf";
					String ruta = "";
					try {
						Aa83bPifController.logger.info("\n\nPARAMETROS DEL CREATE");
						Aa83bPifController.logger.info("\n\n  pathPifXML:"+pathPifXML);
						Aa83bPifController.logger.info("\n\n  pathPifPlantilla:"+pathPifPlantilla);
						Aa83bPifController.logger.info("\n\n  pathPifDocGenerado:"+pathPifDocGenerado);
						ruta = this.documentoWebServiceImpl.create(pathPifXML,pathPifPlantilla, pathPifDocGenerado);
					} catch (Exception e) {
						// TODO Auto-generated catch block
						Aa83bPifController.logger.error(e.getMessage());
					}
					Aa83bPifController.logger.info("adjunto remito antes del copy del documento generado"+ pathPifDocGenerado);
					
					ArrayList<String> partesRuta = new ArrayList<String>(Arrays.asList(ruta.split("/")));
	
					String nombreDocumento = "";
					if (partesRuta != null && partesRuta.size() > 0) {
	
						nombreDocumento = partesRuta.get(partesRuta.size() - 1);
	
					}
					
					
					// COMIENZO DE SUBIR A DOKUSI EL ADJUNTO REMITO
					rutaT65e = "/t65e/aa83b/";
					ficheroNuevoPifT65e = service.copy(xmlSesionDocument,	this.appConfiguration.getProperty("RUTA_PIF_APP").concat(nombreDocumento), rutaT65e.concat(nombreDocumento), true);// NOPMD
				//	ficheroNuevoPifT65e = service.copy(xmlSesionDocument,ruta, rutaT65e, true);// NOPMD
					String tipoDocumentalRem = null;
					
					t65bAttributeList="";
					tipoDocumentalRem = "ejgv_d_archivo";
						t65bAttributeList = "<attributeList><attribute><key>ejgv_origen</key><value>ORGANISMO_EXTERNO</value></attribute>"
						+ "<attribute><key>acl_name</key><value>ejgv_acl_d_AA83B_001</value></attribute><attribute><key>ejgv_serie</key><value>"+res.getDocumentalSeriesId()+"</value></attribute>"
						+ "<attribute><key>title</key><value>Adjunto Remito</value></attribute>"
						+ "<attribute><key>object_name</key><value>ejgv_d_archivo</value></attribute></attributeList>";
					
					Aa83bPifController.logger.info("documentoGuardar adjunto remito- Aqui 1");
	
					documentoGuardar = new Aa83bDocumentoDokusi();
					documentoGuardar.setExtension("doc");
					documentoGuardar.setAuditUserDokusi(auditUser);
					documentoGuardar.setContentType("application/msword");
	
			/*	nombreDocumentoNuevo = "";
					partesRuta = new ArrayList<String>(
							Arrays.asList(ruta.split("/")));
	
					if (partesRuta != null && partesRuta.size() > 0) {
						nombreDocumentoNuevo = partesRuta.get(partesRuta.size() - 1);
					}*/
					//Aa83bPifController.logger.info("documentoGuardar - Aqui 5.1:"+ ficheroNuevoPifT65e.getFilePath() + nombreDocumentoNuevo);
	
					t65bContentType = "<content><pifId>"
						+ ficheroNuevoPifT65e.getFilePath()
						//+"/aa83b/aa83b_adjuntos/09f424018076d1a71463646227401.doc"
							+ "</pifId><format><extension>DOC</extension><mimeType>application/msword</mimeType>"
							+ "</format></content>";
	
					 documentoGuardar.setRutaPif(ficheroNuevoPifT65e.getFilePath());
					//documentoGuardar.setRutaPif("/aa83b/aa83b_adjuntos/09f424018076d1a71463646227401.doc");
	
					tipoDocumento = new Aa83bTipoDocumento();
					tipoDocumento.setTipoDocumental("doc");
					documentoGuardar.setTipoDocumento(tipoDocumento);
	
					Aa83bPifController.logger.info("documentoGuardar - Aqui 6 antes del store del adjunto:");
	
					respuestaDoc = new Aa83bDocumentoDokusi();
					
					//oid = "";
					try {
						String respuesta = this.t65bService.storeDocument(integrationToken,
								auditUser, t65bContentType, tipoDocumentalRem,
								t65bAttributeList);
	
						T65BDocumentIDType obj = (T65BDocumentIDType) new Aa83bMessageParser<T65BDocumentIDType>(T65BDocumentIDType.class.getPackage().getName()).parse(respuesta);
						Aa83bPifController.logger.info("Respuesta:" + respuesta.toString());
						oidRemito=obj.getId();
					}catch (Exception e) {
						Aa83bPifController.logger.error(e.getMessage());
					}
						//FIN DE SUBIR A DOKUSI EL ADJUNTO REMMITO
					
					Aa83bPifController.logger.info("despus de subir a dokusi");
	
					
				} catch (Y31JanoServiceGenericException e) {
					Aa83bPifController.logger.error(e.getMessage());
				} catch (Y31JanoServiceFileNameFormatException e) {
					Aa83bPifController.logger.error(e.getMessage());
				} catch (Y31JanoServiceMongoDbGenericException e) {
					Aa83bPifController.logger.error(e.getMessage());
				} catch (Y31JanoServiceEventJmsException e) {
					Aa83bPifController.logger.error(e.getMessage());
				} catch (Y31JanoServiceAccesDeniedException e) {
					Aa83bPifController.logger.error(e.getMessage());
				} catch (SAXException e) {
					Aa83bPifController.logger.error(e.getMessage());
				} catch (IOException e) {
					Aa83bPifController.logger.error(e.getMessage());
				}
		
			}
			//////*******///// fin de generar adjunto remito///////*******/////
		
			procedure = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken,idProcedimiento);
	
			Aa83bPifController.logger.info("procedure" + procedure);
			Aa83bPifController.logger.info("tipoDocumental" + tipoDocumental);
			
			String tareaNotificar = Aa83bUtilNotificacion.generarNotificationCreateTask(idProcedimiento, procedure,tipoSolicitud, aa83b21t00, aa83b23t00, aa83b25t00,tipoDocumental, oid,null, oidRemito);
	
			//String tareaNotificar = Aa83bUtilNotificacion.generarNotificationCreateTask(idProcedimiento, procedure,tipoSolicitud, aa83b21t00, aa83b23t00, aa83b25t00,Integer.toString(tipoDocumentoGenerado), oid);
			Aa83bPifController.logger.info("tareaNotificar" + tareaNotificar);
	
			String resultadoNotif= this.q99mServiceIfzFacadeWS.createNotificationRequest(sesionToken,tareaNotificar);
			
			//String resultadoNotif="";
			Aa83bPifController.logger.info("Resultado createNotificationRequest---->" +resultadoNotif);
			//resultadoNotif="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";
					Aa83bPifController.logger.info("Resultado resultadoNotif---->" +resultadoNotif);
	
			/*char[] arrayChar=resultadoNotif.toCharArray();
			byte[] byteArray=new byte[0];
			for (int i=0;i<arrayChar.length;i++)
			{
				byteArray[i]=(byte)arrayChar[i];	
			}
			
			
			Aa83bPifController.logger.info("Resultado resultadoNotif.getBytes()---->" +byteArray);
			*/
			EjgvDocumentType firma = this.x43fnshf.createAdESSignature("0025", resultadoNotif, "enveloped");
			
			String cadenaFirma = firma.getEjgvDocument().getBody().getSign();
			Aa83bPifController.logger.info("Resultado createAdESSignature---->" +firma.getEjgvDocument().getBody().getSign());
		
	
			resultadoPublish= this.q99mServiceIfzFacadeWS.publishNotification(sesionToken, resultadoNotif,cadenaFirma);
			// ************fin de cdigo para generar las comunicaciones telemticas
			notifEnviada ="S";
		}
		
		//Modifico el Historial de Tramitacion:::
		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		String idProceedings = "";
		Aa83bPifController.logger.info("resolSubsana ---->" +resolSubsana);		
		if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
			if ("R".equals(resolSubsana)){
				;			//Por aqui no debera ir nunca...
			}
			else if ("S".equals(resolSubsana))
			{
				//Se ha generado un REquerimiento de Subsanacion, debera pasar a F1T2
				Aa83b09t00 aa83b09t00 = new Aa83b09t00();
				if (notifEnviada.equals("S")) {
					aa83b09t00 = this.aa83b09t00Service.add(aa83bSolicitudesUtil.guardarHistoADE(aa83b21t00, Aa83BConstants.COD_FASE_1,
									Aa83BConstants.COD_TRAM_3, "N"));
				} else  {
					aa83b09t00 = this.aa83b09t00Service.add(aa83bSolicitudesUtil.guardarHistoADE(aa83b21t00, Aa83BConstants.COD_FASE_1,
								Aa83BConstants.COD_TRAM_2, "N"));
				}
				idProceedings = aa83b09t00.getId009().toString();
			}

		}else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
			Aa83b10t00 aa83b10t00 = new Aa83b10t00();
			if (resolSubsana.equals("R"))
			{			
				//Se ha generado un Informe de Resolucion, debera pasar a F2T2
				if (notifEnviada.equals("S")) {
					aa83b10t00 = this.aa83b10t00Service.add(aa83bSolicitudesUtil.guardarHistoESF(aa83b23t00, Aa83BConstants.COD_FASE_2,
									Aa83BConstants.COD_TRAM_2, "N"));
				} else {
					aa83b10t00 = this.aa83b10t00Service.add(aa83bSolicitudesUtil.guardarHistoESF(aa83b23t00, Aa83BConstants.COD_FASE_2,
								Aa83BConstants.COD_TRAM_1, "N"));
				}
			}
			else if (resolSubsana.equals("S"))
			{
				//Se ha generado un REquerimiento de Subsanacion, debera pasar a F2T2
				if (notifEnviada.equals("S")) {
					aa83b10t00 = this.aa83b10t00Service.add(aa83bSolicitudesUtil.guardarHistoESF(aa83b23t00, Aa83BConstants.COD_FASE_1,
									Aa83BConstants.COD_TRAM_3, "N"));
				} else {
					aa83b10t00 = this.aa83b10t00Service.add(aa83bSolicitudesUtil.guardarHistoESF(aa83b23t00, Aa83BConstants.COD_FASE_1,
								Aa83BConstants.COD_TRAM_2, "N"));
				}
			}
			
			idProceedings = aa83b10t00.getId010().toString();
			
		}else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
			Aa83b11t00 aa83b11t00 = new Aa83b11t00();
			if (resolSubsana.equals("R"))
			{			
				//Se ha generado un Informe de Resolucion, debera pasar a F2T2
				if (notifEnviada.equals("S")) {
					aa83b11t00 = this.aa83b11t00Service.add(aa83bSolicitudesUtil.guardarHistoARR(aa83b25t00, Aa83BConstants.COD_FASE_2,
									Aa83BConstants.COD_TRAM_2, "N"));
				} else {
					aa83b11t00 = this.aa83b11t00Service.add(aa83bSolicitudesUtil.guardarHistoARR(aa83b25t00, Aa83BConstants.COD_FASE_2,
								Aa83BConstants.COD_TRAM_1, "N"));
				}
			}
			else if (resolSubsana.equals("S"))
			{
				//Se ha generado un REquerimiento de Subsanacion, debera pasar a F2T2
				if (notifEnviada.equals("S")) {
					aa83b11t00 = this.aa83b11t00Service.add(aa83bSolicitudesUtil.guardarHistoARR(aa83b25t00, Aa83BConstants.COD_FASE_1,
									Aa83BConstants.COD_TRAM_3, "N"));
				} else {
					aa83b11t00 = this.aa83b11t00Service.add(aa83bSolicitudesUtil.guardarHistoARR(aa83b25t00, Aa83BConstants.COD_FASE_1,
								Aa83BConstants.COD_TRAM_2, "N"));
				}
			}
			idProceedings = aa83b11t00.getId011().toString();
		}

		// Si es un requerimiento de subsanacin hay que mandar dos mensajes. Uno para mostrar el botn de adjuntar la documentacin 
		// y otro mensaje para mostrar en mis gestiones el tramite correspondiente. 
		
		Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
		Aa83bPifController.logger.info("*********** comienzo a generar el expediente Resultado notif --->" + resultadoPublish);
		String expediente= aa83bXMLGenerator.generarXmlSaveUpdateProceedings(aa83b21t00, aa83b23t00, aa83b25t00, res, idProcedimiento, oid, resultadoPublish, tipoDocumental, false, idProceedings);
		Aa83bPifController.logger.info("*********** expediente-->"+ expediente);
		this.q99uSendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken, expediente, "saveOrUpdateProceedingsNT");

		if ("ejgv_d_requsubs".equalsIgnoreCase(tipoDocumental)) {
				idProceedings = "waitingID-1";
				Aa83bPifController.logger.info("*********** comienzo a generar el expediente Resultado notif --->" + resultadoPublish);
				expediente= aa83bXMLGenerator.generarXmlSaveUpdateProceedings(aa83b21t00, aa83b23t00, aa83b25t00, res, idProcedimiento, oid, resultadoPublish, tipoDocumental, false, idProceedings);
				Aa83bPifController.logger.info("*********** expediente-->"+ expediente);
				this.q99uSendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken, expediente, "saveOrUpdateProceedingsNT");
		}
		
		Aa83bPifController.logger.info("oid en el retorno: " + oid);
		retorno.put("oid", oid);
		return retorno;
	}

	

	
//	@RequestMapping(value = "/editarPif", method = RequestMethod.GET)
//	public @ResponseBody
//	HashMap<String, String> editarPif(
//			@RequestParam(value = "rutaPif", required = true) String rutaPif,
//			@RequestParam(value = "idDoc", required = true) String idDoc,
//			@RequestParam(value = "tipoSolicitud", required = true) String tipoSolicitud,
//			HttpServletRequest request, HttpServletResponse response)
//			throws Exception {
//
//		String rutaDestino = "";
//		String rutaDestinoBox = "";
//		String rutaOrigenPif = "";
//		String rutaOrigen2 = "";
//		String rutaNuevaPif ="";
//		HashMap<String, String> retorno = new HashMap<String, String>();
//		String nombreDocumentoNuevo = "";
//		try {
//			// Codigo
//			String sesionToken = Aa83bUtilSeguridad
//					.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);
//
//			DocumentBuilderFactory factory = DocumentBuilderFactory
//					.newInstance();
//			DocumentBuilder builder = factory.newDocumentBuilder();
//			Document xmlSesionDocument = builder
//					.parse(new ByteArrayInputStream(sesionToken
//							.getBytes("UTF-8")));// NOPMD
//			Aa83bPifController.logger.info("Estamos en editarPIF: con la ruta " + rutaPif +" con el iddoc==>"+idDoc);
//			logger.info("Estamos en editarPIF: " + idDoc);
//			Aa83b20t00 aa83b20t00 = new Aa83b20t00();
//			Aa83b22t00 aa83b22t00 = new Aa83b22t00();
//			Aa83b24t00 aa83b24t00 = new Aa83b24t00();
//			if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
//				aa83b20t00 = new Aa83b20t00();
//				aa83b20t00.setId020(Integer.parseInt(idDoc));
//				// Sacamos la info del Doc idDoc
//				aa83b20t00 = this.aa83b20t00Service.find(aa83b20t00);
//				logger.info("Encontradooo : " + aa83b20t00.toString());
//				rutaOrigenPif = aa83b20t00.getIdPif020();
//				logger.info("Copiando DOC: " + rutaOrigenPif);
//			} else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
//				aa83b22t00 = new Aa83b22t00();
//				aa83b22t00.setId022(Integer.parseInt(idDoc));
//				// Sacamos la info del Doc idDoc
//				aa83b22t00 = this.aa83b22t00Service.find(aa83b22t00);
//				logger.info("Encontradooo : " + aa83b22t00.toString());
//				rutaOrigenPif = aa83b22t00.getIdPif022();
//				logger.info("Copiando DOC: " + rutaOrigenPif);
//			} else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
//				aa83b24t00 = new Aa83b24t00();
//				aa83b24t00.setId024(Integer.parseInt(idDoc));
//				// Sacamos la info del Doc idDoc
//				aa83b24t00 = this.aa83b24t00Service.find(aa83b24t00);
//				logger.info("Encontradooo : " + aa83b24t00.toString());
//				rutaOrigenPif = aa83b24t00.getIdPif024();
//				logger.info("Copiando DOC: " + rutaOrigenPif);
//			}
//
//			Y31JanoService service = Y31JanoServiceAbstractFactory
//					.getInstance();
//			 rutaOrigenPif =
//			 this.appConfiguration.getProperty("RUTA_PIF_APP")
//			 .concat(rutaOrigenPif);
//			// copiamos el documento original con otro nombre
//			Y31AttachmentBean FicheroNuevoPif = service.copy(xmlSesionDocument,
//					rutaOrigenPif, rutaOrigenPif, false);// NOPMD
//			 rutaNuevaPif = FicheroNuevoPif.getFilePath();
//			logger.info("Despues de copiar : " + rutaNuevaPif);
//			ArrayList<String> partesRuta = new ArrayList<String>(
//					Arrays.asList(rutaNuevaPif.split("/")));
//			
//			if (partesRuta != null && partesRuta.size() > 0) {
//				nombreDocumentoNuevo = partesRuta.get(partesRuta.size() - 1);
//			}
//			logger.info("Nuevo DOC : " + nombreDocumentoNuevo);
//			logger.info("rutaNuevaPif : " + rutaNuevaPif);
//
//			// Guardamos el nuevo DOC:
//			String idPif = "";
//			if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
//				aa83b20t00.setIdPif020(nombreDocumentoNuevo);
//				aa83b20t00 = this.aa83b20t00Service.update(aa83b20t00);
//				idPif = aa83b20t00.getIdPif020();
//			} else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
//				aa83b22t00.setIdPif022(nombreDocumentoNuevo);
//				aa83b22t00 = this.aa83b22t00Service.update(aa83b22t00);
//				idPif = aa83b22t00.getIdPif022();
//			} else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
//				aa83b24t00.setIdPif024(nombreDocumentoNuevo);
//				aa83b24t00 = this.aa83b24t00Service.update(aa83b24t00);
//				idPif = aa83b24t00.getIdPif024();
//			}
//
//			// Generamos un nuevo DOC y lo copiamos en EJIEBOX
//			rutaDestinoBox = this.appConfiguration
//					.getProperty("RUTA_PIF_USER")
//					.concat(Aa83bUtilSeguridad.getUsername().toLowerCase())
//					.concat(this.appConfiguration
//							.getProperty("RUTA_PIF_EDITA_USER")).concat(idPif);
//
//			Y31AttachmentBean rdoRutaEjieBox = service.copy(xmlSesionDocument,
//					rutaNuevaPif, rutaDestinoBox, true);// NOPMD
//
//			// Fin de Generamos un nuevo DOC y lo copiamos en EJIEBOX
//
//			rutaDestinoBox = rdoRutaEjieBox.getFilePath();
//
//		} catch (Exception e) {
//			Aa83bPifController.logger.error(e.getMessage());
//
//		}
//
//		retorno.put("rutaCompleta",
//				this.appConfiguration.getProperty("RUTA_EDICION_PIF")
//						+ rutaDestinoBox);
//		retorno.put("rutaWebdav", rutaDestinoBox);
//		retorno.put("nuevaRutaPif", rutaNuevaPif);
//		retorno.put("nombreDocumentoNuevo", nombreDocumentoNuevo);
//		return retorno;
//	}

	
	//modificado por Ana para ver si funciona
	@RequestMapping(value = "/editarPif", method = RequestMethod.GET)
	public @ResponseBody
	HashMap<String, String> editarPif(
			@RequestParam(value = "rutaPif", required = true) String rutaPif,
			@RequestParam(value = "idDoc", required = true) String idDoc,
			@RequestParam(value = "tipoSolicitud", required = true) String tipoSolicitud,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String rutaDestino = "";
		String rutaOrigenPif = "";
		String rutaOrigen = "";
		String rutaNuevaPif ="";
		
		HashMap<String, String> retorno = new HashMap<String, String>();
		String nombreDocumentoNuevo = "";
		try {
			// Recuperamos el token de aplicacin y lo parseamos a UTF-8 
			/*String sesionToken = Aa83bUtilSeguridad.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);

			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document xmlSesionDocument = builder.parse(new ByteArrayInputStream(sesionToken.getBytes("UTF-8")));// NOPMD*/
			
			Document xmlSesionDocument = Aa83bUtilSeguridad.getTokenDocumentXLNets(Aa83BConstants.COD_APLICACION);
			
			
			//recuperamos el nombre del documento, ya que desde el jsp slo envamos el iddoc
			Aa83b20t00 aa83b20t00 = new Aa83b20t00();
			Aa83b22t00 aa83b22t00 = new Aa83b22t00();
			Aa83b24t00 aa83b24t00 = new Aa83b24t00();
			if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
				aa83b20t00 = new Aa83b20t00();
				aa83b20t00.setId020(Integer.parseInt(idDoc));
				// Sacamos la info del Doc idDoc
				aa83b20t00 = this.aa83b20t00Service.find(aa83b20t00);
				rutaOrigenPif = aa83b20t00.getIdPif020();
			} else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
				aa83b22t00 = new Aa83b22t00();
				aa83b22t00.setId022(Integer.parseInt(idDoc));
				// Sacamos la info del Doc idDoc
				aa83b22t00 = this.aa83b22t00Service.find(aa83b22t00);
				rutaOrigenPif = aa83b22t00.getIdPif022();
			} else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
				aa83b24t00 = new Aa83b24t00();
				aa83b24t00.setId024(Integer.parseInt(idDoc));
				// Sacamos la info del Doc idDoc
				aa83b24t00 = this.aa83b24t00Service.find(aa83b24t00);
				rutaOrigenPif = aa83b24t00.getIdPif024();
			}

			
			//recuperamos el nombreDelDocumento
			ArrayList<String> partesRuta = new ArrayList<String>(Arrays.asList(rutaOrigenPif.split("/")));
			if (partesRuta != null && partesRuta.size() > 0) {
				nombreDocumentoNuevo = partesRuta.get(partesRuta.size() - 1);
			}
			
			Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
			//ruta de origen completa
			rutaOrigenPif = this.appConfiguration.getProperty("RUTA_PIF_APP").concat(rutaOrigenPif);
			//copiamos el documento en APPBOX con otro nombre
			Y31AttachmentBean FicheroNuevoPif = service.copy(xmlSesionDocument, rutaOrigenPif, rutaOrigenPif, false);// NOPMD
			
			rutaNuevaPif = FicheroNuevoPif.getFilePath();
			
			partesRuta = new ArrayList<String>(Arrays.asList(rutaNuevaPif.split("/")));
			if (partesRuta != null && partesRuta.size() > 0) {
				nombreDocumentoNuevo = partesRuta.get(partesRuta.size() - 1);
			}
			
			rutaDestino= this.appConfiguration.getProperty("RUTA_PIF_USER").concat(Aa83bUtilSeguridad.getUsername().toLowerCase()).concat(this.appConfiguration.getProperty("RUTA_PIF_EDITA_USER")).concat(nombreDocumentoNuevo);
			
			//copiamos el nuevo documento de APPBOX al buzn del usuario 
			Y31AttachmentBean rdoRutaEjieBox = service.copy(xmlSesionDocument,rutaNuevaPif, rutaDestino, true);// NOPMD

			// borramos la ruta original de pif
			service.delete(xmlSesionDocument, rutaOrigenPif);
			
			
			// Guardamos el nombre del nuevo doc en las tablas de la aplicacin:
			if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
				aa83b20t00.setIdPif020(nombreDocumentoNuevo);
				aa83b20t00 = this.aa83b20t00Service.update(aa83b20t00);
			} else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
				aa83b22t00.setIdPif022(nombreDocumentoNuevo);
				aa83b22t00 = this.aa83b22t00Service.update(aa83b22t00);
			} else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
				aa83b24t00.setIdPif024(nombreDocumentoNuevo);
				aa83b24t00 = this.aa83b24t00Service.update(aa83b24t00);
			}


		} catch (Exception e) {
			Aa83bPifController.logger.error(e.getMessage());

		}
		//retornamos la ruta del documento del buzn de usuario para editarlo.
		retorno.put("rutaCompleta",this.appConfiguration.getProperty("RUTA_EDICION_PIF")+ rutaDestino);
		retorno.put("nombreDocumentoNuevo", nombreDocumentoNuevo);
		return retorno;
	}
	
	
	
	
	/**
	 * @param tipoSolicitud String
	 * @param tiponumSol String
	 * @param anoSol String
	 * @param documentacion String
	 * @param firma String
	 * @param request HttpServletRequest
	 * @param response HttpServletResponse
	 * @return HashMap<String, String>
	 * @throws Exception e
	 */
	@RequestMapping(value = "/crearPif", method = RequestMethod.GET)
	public @ResponseBody()
	HashMap<String, String> crearPif(
			@RequestParam(value = "tipoSolicitud", required = true) String tipoSolicitud,
			@RequestParam(value = "tiponumSol", required = true) String tiponumSol,
			@RequestParam(value = "anoSol", required = true) String anoSol,
			@RequestParam(value = "documentacion", required = false) String documentacion,
			@RequestParam(value = "firma", required = false) String firma,
			//@RequestParam(value = "favorable", required = false) String favorable,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String[] docus = documentacion.split(":");
		String rutaDestinoBox = "";
		String rutaDestino = "";
		String rutaOrigen = "";
		String rutaOrigen2 = "";
		String rutaDoc = "";
		String ruta = "";
		String nomTemplate004 = "";
		String nomImagen = "";
		String imagenConPath = "";
		HashMap<String, String> retorno = new HashMap<String, String>();
		String nombreDocumento = "";
		int nuevoId=0;
		try {
			
			
			// Codigo
			Aa83bPifController.logger.info("Estamos en crearPif:" + tipoSolicitud + ":"	+ tiponumSol + ":" + anoSol + ":" + documentacion);

			String sesionToken = Aa83bUtilSeguridad.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);

			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document xmlSesionDocument = builder.parse(new ByteArrayInputStream(sesionToken.getBytes("UTF-8")));// NOPMD

			
			//Mensajes borde
			String literalES=Aa83bUtilProperties.getProperty("LITERALES");
			String literalEU=Aa83bUtilProperties.getProperty("LITERALEU");
			
			Aa83bPifController.logger.info("Antes de llamar a Generar QR-1:");
			String literalPlateaTipo = "";
			String literalTipo = "";
			if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
				literalPlateaTipo = Aa83BConstants.COD_ADE_PLATEA;
				literalTipo = Aa83BConstants.COD_ADE_STR;
				literalES=literalES+" "+ Aa83bUtilProperties.getProperty("HAB_ES");
				literalEU=literalEU+" "+ Aa83bUtilProperties.getProperty("HAB_EU");
			} else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
				literalPlateaTipo = Aa83BConstants.COD_ESF_PLATEA;
				literalTipo = Aa83BConstants.COD_ESF_STR;
				literalES=literalES+" "+ Aa83bUtilProperties.getProperty("ESF_ES");
				literalEU=literalEU+" "+ Aa83bUtilProperties.getProperty("ESF_EU");
			} else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
				literalPlateaTipo = Aa83BConstants.COD_ARR_PLATEA;
				literalTipo = Aa83BConstants.COD_ARR_STR;
				literalES=literalES+" "+ Aa83bUtilProperties.getProperty("ARR_ES");
				literalEU=literalEU+" "+ Aa83bUtilProperties.getProperty("ARR_EU");
			}
			// Saco el hostorial de tramitacion para indicar el tramite actual:
			String literalImg = literalPlateaTipo + "#" + literalTipo + anoSol+ tiponumSol + ":" + "F=1" + ":T=4";
			Aa83bPifController.logger.info("Antes de llamar a Generar QR-2:" + literalImg);
			String auditUser = "";
			if (Aa83bUtilSeguridad.enOficina()) {
				auditUser = "AA83B-1#AA83B-1#AA83B-1";
			} else {
				auditUser = Aa83bUtilSeguridad.getAuditUser();
			}

			//auditUser = "AA83B-1#AA83B-1#AA83B-1";

			Aa83bPifController.logger.info("Antes de llamar a Generar QR-3 Ruta:"+ Aa83bUtilProperties.getProperty("ImgQR.path"));
			byte[] imagen = qrWebService.generarQR(sesionToken, auditUser,literalImg, 500);
			// Con este cdigo se agregan los bytes al archivo.
			nomImagen = "imagenQR" + anoSol + "_" + tiponumSol + ".jpg";
			FileOutputStream fileOuputStream = new FileOutputStream(Aa83bUtilProperties.getProperty("ImgQR.path") + nomImagen);
			fileOuputStream.write(imagen);
			fileOuputStream.close();
			String strImagen = Aa83bUtilidades.encodeBase64(imagen);
			
			imagenConPath = Aa83bUtilProperties.getProperty("ImgQR.path")+ nomImagen;
			// Subimos la imagen a PIF
			
			
			
			final char[] hexArray = "0123456789ABCDEF".toCharArray();
			char[] hexChars = new char[imagen.length * 2];
		    for ( int j = 0; j < imagen.length; j++ ) {
		        int v = imagen[j] & 0xFF;
		        hexChars[j * 2] = hexArray[v >>> 4];
		        hexChars[j * 2 + 1] = hexArray[v & 0x0F];
		    }
		    String hexaImagen="";
		    for (int i = 0; i <hexChars.length; i++) {// bFile.length
		    	hexaImagen=hexaImagen+hexChars[i];
		       	//el bueno
	            }
		    
		    //literalImg = literalTipo + anoSol+ tiponumSol + ":" + "F=1" + ":T=4";
		    
		   // Buscamos la Solicitud
			A83bPais a83bPais = new A83bPais();
			List<Aa83b12t00> aa83b12t00List = new ArrayList<Aa83b12t00>();
			int id = 0;
			Long anyo = new Long(0);
			String numDoc = "";
			String nombre = "";
			String ape1 = "";
			String ape2 = "";
			
			if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
				Aa83b21t00 aa83b21t00 = new Aa83b21t00();
				aa83b21t00.setId021(Integer.parseInt(tiponumSol));
				aa83b21t00.setIdAno021(Long.parseLong(anoSol));
				aa83b21t00 = this.aa83b21t00Service.find(aa83b21t00);
				
				Aa83b12t00 aa83b12t00 = new Aa83b12t00();
				aa83b12t00.setId012(aa83b21t00.getId012TipoDoc());
				aa83b12t00List = aa83b12t00Service.findAllLike(aa83b12t00,null, false);
				a83bPais.setId(aa83b21t00.getNacionalidad021().toString());
				a83bPais = this.a83bNoraService.findPaisesById(a83bPais);
				id = aa83b21t00.getId021();
				anyo = aa83b21t00.getIdAno021();
				numDoc = aa83b21t00.getNumDoc021();
				nombre = aa83b21t00.getNombre021();
				ape1 = aa83b21t00.getApel1021();
				ape2 = aa83b21t00.getApel2021();
			} else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
				Aa83b23t00 aa83b23t00 = new Aa83b23t00();
				aa83b23t00.setId023(Integer.parseInt(tiponumSol));
				aa83b23t00.setIdAno023(Long.parseLong(anoSol));
				aa83b23t00 = this.aa83b23t00Service.find(aa83b23t00);
				
				Aa83b12t00 aa83b12t00 = new Aa83b12t00();
				aa83b12t00.setId012(aa83b23t00.getId012TipoDoc());
				aa83b12t00List = aa83b12t00Service.findAllLike(aa83b12t00,null, false);
				a83bPais.setId(aa83b23t00.getNacionalidad023().toString());
				a83bPais = this.a83bNoraService.findPaisesById(a83bPais);
				id = aa83b23t00.getId023();
				anyo = aa83b23t00.getIdAno023();
				numDoc = aa83b23t00.getNumDoc023();
				nombre = aa83b23t00.getNombre023();
				ape1 = aa83b23t00.getApel1023();
				ape2 = aa83b23t00.getApel2023();
			} else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
				Aa83b25t00 aa83b25t00 = new Aa83b25t00();
				aa83b25t00.setId025(Integer.parseInt(tiponumSol));
				aa83b25t00.setIdAno025(Long.parseLong(anoSol));
				aa83b25t00 = this.aa83b25t00Service.find(aa83b25t00);
				
				Aa83b12t00 aa83b12t00 = new Aa83b12t00();
				aa83b12t00.setId012(aa83b25t00.getId012TipoDoc());
				aa83b12t00List = aa83b12t00Service.findAllLike(aa83b12t00,null, false);
				a83bPais.setId(aa83b25t00.getNacionalidad025().toString());
				a83bPais = this.a83bNoraService.findPaisesById(a83bPais);
				id = aa83b25t00.getId025();
				anyo = aa83b25t00.getIdAno025();
				numDoc = aa83b25t00.getNumDoc025();
				nombre = aa83b25t00.getNombre025();
				ape1 = aa83b25t00.getApel1025();
				ape2 = aa83b25t00.getApel2025();
			}
			//
			Aa83bPifController.logger.info("Despues de buscar la Soli:");

			// Sacamos el literal del TipoDoc:

			// Cogemos la plantilla del Requermineto de Subsanacion: aa83b04t00
			Integer tramite = 2;
			Integer fase = 1;

			Aa83b19t00 aa83b19t00 = new Aa83b19t00();
			aa83b19t00.setId019(Integer.parseInt(firma));

			List<Aa83b19t00> aa83b19t00List = aa83b19t00Service.findAll(aa83b19t00, null);
			
			hexChars = new char[aa83b19t00List.get(0).getFirmaDigital019().length * 2];
		    for ( int j = 0; j < aa83b19t00List.get(0).getFirmaDigital019().length; j++ ) {
		        int v = aa83b19t00List.get(0).getFirmaDigital019()[j] & 0xFF;
		        hexChars[j * 2] = hexArray[v >>> 4];
		        hexChars[j * 2 + 1] = hexArray[v & 0x0F];
		    }
		    String hexaImagenFirma="";
		    for (int i = 0; i <hexChars.length; i++) {// bFile.length
		    	hexaImagenFirma=hexaImagenFirma+hexChars[i];
		       	//el bueno
	            }
		    
			Aa83b04t00 aa83b04t00 = new Aa83b04t00();
			aa83b04t00.setId002Tram(tramite);
			aa83b04t00.setId003TipoSol(Integer.parseInt(tipoSolicitud));
			aa83b04t00.setIdfase(fase);
			List<Aa83b04t00> aa83b04t00List = new ArrayList<Aa83b04t00>();
			aa83b04t00List = aa83b04t00Service.findAllLike(aa83b04t00, null,false);
			Aa83bPifController.logger.info("aa83b04t00:" + aa83b04t00List.size());
			Blob fichero = aa83b04t00List.get(0).getTemplate004();
			//inser5tamos la imagen del qr del requerimiento
			HashMap<String, String> sustituciones=new HashMap<String, String>();
		    StringBuffer buffer=new StringBuffer();
		    sustituciones.put("F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0", hexaImagen);
		    sustituciones.put("F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1", hexaImagenFirma);
		    buffer=sustituirCadenaCaracteresRtf(aa83b04t00List.get(0).getPlantilla004(),sustituciones);
		    
		    
		    
		    
		  //convert array of bytes into file
//		    FileOutputStream fileOuputStream2 =  new FileOutputStream("C:/Users/ldiazcerio/Desktop/esto.rtf"); 
//		    fileOuputStream2.write(buffer.toString().getBytes());
//		    fileOuputStream2.close();
		 // Inicio de subir la plantilla RTF a PIF (la plantilla con el cdigo qr)
		    
			nomTemplate004 = aa83b04t00List.get(0).getNomTemplate004();
			rutaDoc = Aa83bUtilProperties.PIF_PATH + nomTemplate004 + ".rtf";
			InputStream is = new ByteArrayInputStream(buffer.toString().getBytes());// NOPMD//aa83b04t00List.get(0).getTemplateByte()buffer.toString().getBytes()
			Aa83bPifController.logger.info("todo leire:" + buffer.toString().getBytes());
			Aa83bPifController.logger.info("todo leire getTemplateByte:" + aa83b04t00List.get(0).getPlantilla004());
			Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();

			Y31AttachmentBean rdoRTF = service.put(xmlSesionDocument, is,rutaDoc, Long.parseLong(Aa83bUtilProperties.PIF_TTL));// NOPMD
			String pathPifPlantilla = rdoRTF.getFilePath();
			Aa83bPifController.logger.info("pathPifPlantilla:" + pathPifPlantilla);
			//esto sobraria
			//hasta aki sobraria
		    //rutaDestinoBox=guardarPif(nomTemplate004,cadenaXML,service,xmlSesionDocument,pathPifPlantilla);
		    //terminamos de subir la plantilla a pif
		    //fin nuevo
		    //ahora hay que coger esa plantilla y generar el requerimiento correctamente
			

			// Sacamos la documentacion a subsanar
			Aa83b30t00 aa83b30t00 = new Aa83b30t00();
			Aa83b30t00 aa83b30t00Res = new Aa83b30t00();
			List<Aa83b30t00> aa83b30t00List = new ArrayList<Aa83b30t00>();

			aa83b30t00.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_1));
			aa83b30t00.setId002Tram(Integer.parseInt(Aa83BConstants.COD_TRAM_1));
			aa83b30t00.setId003TipoSol(Integer.parseInt(tipoSolicitud));
			String docusInf = "";
			String docusInfEu = "";
			for (int d = 1; d < docus.length; d++) {
				Aa83bPifController.logger.info("docus[d]:" + docus[d]);
				aa83b30t00.setId030(Integer.parseInt(docus[d]));
				Aa83bPifController.logger.info("aa83b30t00:" + aa83b30t00.toString());
				aa83b30t00Res = aa83b30t00Service.find(aa83b30t00);
				Aa83bPifController.logger.info("aa83b30t00Res:" + aa83b30t00Res.toString());
				if (docusInf.equals("")) {
					docusInf = aa83b30t00Res.getDescEs030();
					docusInfEu = aa83b30t00Res.getDescEu030();
				} else {
					docusInf = docusInf + ":" + aa83b30t00Res.getDescEs030();
					docusInfEu = docusInfEu + ":"+ aa83b30t00Res.getDescEu030();
				}
			}
			Aa83bPifController.logger.info("docusInf:" + docusInf);
			Aa83bPifController.logger.info("Propiedad:"+ this.appConfiguration.getProperty("RUTA_EDICION_PIF"));

			// Aa83bPifController.logger.info("Aa83bPifController Solicitante="
			// + aa83b21t00.toString());

			// Generar el xml xon los datos de los acuses seleccionados

		
			imagenConPath="/r02g/pif/09f42401807640841462182458937.png";
			Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator	.getInstance();
			String cadenaXML = aa83bXMLGenerator.generateXMLReqSubsana(id,anyo, numDoc, nombre, ape1, ape2,literalTipo, aa83b12t00List.get(0),
					a83bPais, docusInf, docusInfEu, aa83b19t00List.get(0),strImagen,literalES,literalEU,literalImg);

			Aa83bPifController.logger.info("Despues de generar el XML:");

			Aa83bPifController.logger.info("[Aa83bPifController] generarAdjuntoRemito: cadenaXML="+ cadenaXML);

			// INICIO Subimos el xml a PIF
			String rutaXML = Aa83bUtilProperties.PIF_PATH + nomTemplate004	+ ".xml";
			Aa83bPifController.logger.info("[Aa83bPifController] generarAdjuntoRemito: rutaXML="	+ rutaXML);

			InputStream isXML = new ByteArrayInputStream(cadenaXML.getBytes("UTF-8"));// NOPMD
			Aa83bPifController.logger.info("[Aa83bPifController] : generarAdjuntoRemito isXML:"	+ isXML.toString());

			Y31AttachmentBean rdoXML = service.put(xmlSesionDocument, isXML,rutaXML, new Long(120));// NOPMD
			Aa83bPifController.logger.info("[Aa83bPifController] : generarAdjuntoRemito despues del put");
			String pathPifXML = rdoXML.getFilePath();

			Aa83bPifController.logger.info("[Aa83bPifController] : generarAdjuntoRemito pathPifXML: "+ pathPifXML);
			// FIN Subimos el xml a PIF

			// Llamamos al metodo create de aa19
			Aa83bPifController.logger.info("[Aa83bPifController] generarAdjuntoRemito: Llamamos al metodo create de aa19: ");
			String pathPifDocGenerado = Aa83bUtilProperties.PIF_PATH+ nomTemplate004 + ".doc";
			
			try {

				Aa83bPifController.logger.info("[Aa83bPifController] : Llamo a AA19B con: "	+ pathPifXML + "pathPifPlantilla:"
								+ pathPifPlantilla + " pathPifDocGenerado:"	+ pathPifDocGenerado);

				ruta = this.documentoWebServiceImpl.create(pathPifXML,pathPifPlantilla, pathPifDocGenerado);

				Aa83bPifController.logger.info("[Aa83bPifController] generarAdjuntoRemito: ruta: "+ ruta);
				// Copiamos el fichero en EJIEBOX

				ArrayList<String> partesRuta = new ArrayList<String>(Arrays.asList(ruta.split("/")));

				nombreDocumento = "";
				if (partesRuta != null && partesRuta.size() > 0) {

					nombreDocumento = partesRuta.get(partesRuta.size() - 1);

				}

				rutaDestinoBox = this.appConfiguration.getProperty("RUTA_PIF_USER")
						// .concat(
						// H50bUtilsSeguridad.getUsername().toLowerCase())
						.concat(Aa83bUtilSeguridad.getUsername().toLowerCase()).concat(this.appConfiguration
								.getProperty("RUTA_PIF_EDITA_USER")).concat(nombreDocumento);

				Y31AttachmentBean rdoRutaEjieBox = service.copy(xmlSesionDocument, ruta, rutaDestinoBox, true);// NOPMD

				Aa83bPifController.logger.info("[Aa83bPifController] rutaDestino despues Copy: "+ rdoRutaEjieBox.getFilePath());
				Aa83bPifController.logger.info("[Aa83bPifController] tiposolicitud: "+ tipoSolicitud);
				// Guardo la ruta de PIF en la tabla de DOC Generada
				
				nuevoId = this.getNuevoIdReq(tipoSolicitud, nombreDocumento, tiponumSol, anoSol, aa83b04t00List);

			} catch (Exception e) {
				Aa83bPifController.logger
						.error("[Aa83bPifController] Excepcion: "
								+ e.getMessage());
				
			}

		} catch (Exception e) {
			Aa83bPifController.logger.error(e.getMessage());

		}
		Aa83bPifController.logger
				.info("[Aa83bPifController] : Se ha creado el DOC en la AA19B: "
						+ this.appConfiguration.getProperty("RUTA_EDICION_PIF")
						+ rutaDestinoBox);

		retorno.put("rutaCompleta",
				this.appConfiguration.getProperty("RUTA_EDICION_PIF")
						+ rutaDestinoBox);
		retorno.put("rutaWebdav", rutaDestino);
		retorno.put("nuevaRutaPif", rutaOrigen2);
		retorno.put("nombreDocPif", nombreDocumento);
		retorno.put("idDoc", String.valueOf(nuevoId));
		return retorno;
	}
	@RequestMapping(value = "/bajarPif", method = RequestMethod.GET)
	public @ResponseBody
	InputStream bajarPif(String docPif) {

		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder;
		InputStream is1 = null;
		try {
			builder = factory.newDocumentBuilder();

			String integrationToken = Aa83bUtilSeguridad
					.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);
			Document xmlSesionDocument;
			Y31JanoService service;
			xmlSesionDocument = builder.parse(new ByteArrayInputStream(
					integrationToken.getBytes("UTF-8")));
			service = Y31JanoServiceAbstractFactory.getInstance();
			is1 = service.get(xmlSesionDocument, docPif);

		} catch (Y31JanoServiceGenericException e) {
			// TODO Auto-generated catch block
			Aa83bPifController.logger
			.error("[Aa83bPifController] Excepcion: "
					+ e.getMessage());
		} catch (Y31JanoServiceFileNotFoundException e) {
			// TODO Auto-generated catch block
			Aa83bPifController.logger
			.error("[Aa83bPifController] Excepcion: "
					+ e.getMessage());
		} catch (Y31JanoServiceFileNameFormatException e) {
			// TODO Auto-generated catch block
			Aa83bPifController.logger
			.error("[Aa83bPifController] Excepcion: "
					+ e.getMessage());
		} catch (Y31JanoServiceMongoDbGenericException e) {
			// TODO Auto-generated catch block
			Aa83bPifController.logger
			.error("[Aa83bPifController] Excepcion: "
					+ e.getMessage());
		} catch (Y31JanoServiceOracleGenericException e) {
			// TODO Auto-generated catch block
			Aa83bPifController.logger
			.error("[Aa83bPifController] Excepcion: "
					+ e.getMessage());
		} catch (Y31JanoServiceAccesDeniedException e) {
			// TODO Auto-generated catch block
			Aa83bPifController.logger
			.error("[Aa83bPifController] Excepcion: "
					+ e.getMessage());
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			Aa83bPifController.logger
			.error("[Aa83bPifController] Excepcion: "
					+ e.getMessage());
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			Aa83bPifController.logger
			.error("[Aa83bPifController] Excepcion: "
					+ e.getMessage());
		} catch (IOException e) {
			// TODO Auto-generated catch block
			Aa83bPifController.logger
			.error("[Aa83bPifController] Excepcion: "
					+ e.getMessage());
		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			Aa83bPifController.logger
			.error("[Aa83bPifController] Excepcion: "
					+ e.getMessage());
		}
		return is1;
	}
	
	/**
	 * @param tipoSolicitud String
	 * @param tiponumSol String
	 * @param anoSol String
	 * @param documentacion String
	 * @param firma String
	 * @param documentos String
	 * @param favorable String
	 * @param request HttpServletRequest
	 * @param response HttpServletResponse
	 * @return HashMap<String, String>
	 * @throws Exception e
	 */
	@RequestMapping(value = "/crearPifResolucion", method = RequestMethod.GET)
	public @ResponseBody()
	HashMap<String, String> crearPifResolucion(
			@RequestParam(value = "tipoSolicitud", required = true) String tipoSolicitud,
			@RequestParam(value = "tiponumSol", required = true) String tiponumSol,
			@RequestParam(value = "anoSol", required = true) String anoSol,
			@RequestParam(value = "documentacion", required = false) String documentacion,
			@RequestParam(value = "firma", required = false) String firma,
			@RequestParam(value = "documentos", required = false) String documentos,
			@RequestParam(value = "favorable", required = false) String favorable,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		String rutaDestinoBox = "";
		String rutaDestino = "";
		String rutaOrigen2 = "";
		String rutaDoc = "";
		String ruta = "";
		String nomTemplate004 = "";
		HashMap<String, String> retorno = new HashMap<String, String>();
		String nombreDocumento = "";
		int nuevoId=0;
		
		
		try {
			// Codigo
			Aa83bPifController.logger.info("Estamos en crearPifResolucion:" + tipoSolicitud+ ":" + tiponumSol + ":" + anoSol + ":" + documentacion);
			String sesionToken = Aa83bUtilSeguridad.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document xmlSesionDocument = builder.parse(new ByteArrayInputStream(sesionToken.getBytes("UTF-8")));// NOPMD

			Aa83bPifController.logger.info("Antes de llamar a Generar QR-1:");

			//La plantilla
			Integer tramite = 1;
			Integer fase = 2;
			Aa83b04t00 aa83b04t00 = new Aa83b04t00();
			aa83b04t00.setId002Tram(tramite);
			aa83b04t00.setId003TipoSol(Integer.parseInt(tipoSolicitud));
			aa83b04t00.setIdfase(fase);
			List<Aa83b04t00> aa83b04t00List = new ArrayList<Aa83b04t00>();
			aa83b04t00List = this.aa83b04t00Service.findAllLike(aa83b04t00, null,false);
			
			//HAY QUE PONERLE AKI LA FIRMA DEL DIRECTOR
			Aa83b19t00 aa83b19t00 = new Aa83b19t00();
			String[] lasdos=firma.split(":");
			aa83b19t00.setId019(Integer.parseInt(lasdos[0]));
			List<Aa83b19t00> aa83b19t00ListTecnicos = this.aa83b19t00Service.findAll(aa83b19t00, null);
			aa83b19t00.setId019(Integer.parseInt(lasdos[1]));
			List<Aa83b19t00> aa83b19t00List2Directores = this.aa83b19t00Service.findAll(aa83b19t00, null);
			
			HashMap<String, String> sustituciones=new HashMap<String, String>();
		    StringBuffer buffer=new StringBuffer();
		    final char[] hexArray = "0123456789ABCDEF".toCharArray();
		    byte[] imagen=aa83b19t00List2Directores.get(0).getFirmaDigital019();
		    char[] hexChars = new char[imagen.length * 2];
		    for ( int j = 0; j < imagen.length; j++ ) {
		        int v = imagen[j] & 0xFF;
		        hexChars[j * 2] = hexArray[v >>> 4];
		        hexChars[j * 2 + 1] = hexArray[v & 0x0F];
		    }
		    String hexaImagen="";
		    for (int i = 0; i <hexChars.length; i++) {// bFile.length
		    	hexaImagen=hexaImagen+hexChars[i];
		       	//el bueno
	            }
		    Aa83bPifController.logger.info("LA HEXAIMAGEN:" + hexaImagen.toString());
		    
		    sustituciones.put("F1F1F1F1F1F1", hexaImagen);
		    buffer=Aa83bPifController.sustituirCadenaCaracteresRtf(aa83b04t00List.get(0).getPlantilla004(),sustituciones);
			
		    Aa83bPifController.logger.info("todo leire:" + buffer.toString().getBytes());
			Aa83bPifController.logger.info("todo leire getTemplateByte:" + aa83b04t00List.get(0).getPlantilla004());
			
			Aa83bPifController.logger.info("LA plantilla:" + aa83b04t00List.get(0).getPlantilla004());
			nomTemplate004 = aa83b04t00List.get(0).getNomTemplate004();
			rutaDoc = Aa83bUtilProperties.PIF_PATH + nomTemplate004 + ".rtf";
			InputStream is = new ByteArrayInputStream(buffer.toString().getBytes());//aa83b04t00List.get(0).getPlantilla004());//buffer.toString().getBytes());// aa83b04t00List.get(0).getTemplateByte());//
										// NOPMD
			Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();

			Y31AttachmentBean rdoRTF = service.put(xmlSesionDocument, is,rutaDoc, Long.parseLong(Aa83bUtilProperties.PIF_TTL));// NOPMD
			String pathPifPlantilla = rdoRTF.getFilePath();
			Aa83bPifController.logger.info("pathPifPlantilla:" + pathPifPlantilla);
			
			//Fin de la plantilla
			

			// Buscamos la Solicitud
			A83bPais a83bPais = new A83bPais();
			List<Aa83b12t00> aa83b12t00List = new ArrayList<Aa83b12t00>();
			//ESF
			Aa83b23t00 aa83b23t00 = new Aa83b23t00();
			String motivoSolicitud="";
			String estadoSolicitud="";
			String actividadLaboral="";
			String inclusionSocial="";
			//ARR
			String mediosEconomicos="";
			String identidad="";
			String residencia="";
			String formacion="";
			String participacion="";
			Aa83b25t00 aa83b25t00 = new Aa83b25t00();
			
			if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
				aa83b23t00 = new Aa83b23t00();
				aa83b23t00.setId023(Integer.parseInt(tiponumSol));
				aa83b23t00.setIdAno023(Long.parseLong(anoSol));
				aa83b23t00 = this.aa83b23t00Service.findResolucion(aa83b23t00);
				aa83b23t00.setResolFavorable023(Integer.valueOf(favorable));
				this.aa83b23t00Service.updateResolFavorable(aa83b23t00);
				Aa83b12t00 aa83b12t00 = new Aa83b12t00();
				aa83b12t00.setId012(aa83b23t00.getId012TipoDoc());
				aa83b12t00List = this.aa83b12t00Service.findAllLike(aa83b12t00,
						null, false);
				a83bPais.setId(aa83b23t00.getNacionalidad023().toString());
				a83bPais = this.a83bNoraService.findPaisesById(a83bPais);
				Aa83b26t00 motivo=new Aa83b26t00();
				motivo.setId026(aa83b23t00.getId026Motivos());
				motivo=this.aa83b26t00Service.find(motivo);
				if(null!=motivo){
					motivoSolicitud=motivo.getDescEs026();
				}
				Aa83b27t00 estado=new Aa83b27t00();
				estado.setId027(aa83b23t00.getId027EstadosEsf());
				estado=this.aa83b27t00Service.find(estado);
				if(null!=estado){
					estadoSolicitud=estado.getDescEs027();
				}
				String listaActividadLaboral=this.aa83b30t00Service.buscarDocumentosPorBloque(this.appConfiguration.getProperty("ActividadLaboral"));
				String listaInclusion=this.aa83b30t00Service.buscarDocumentosPorBloque(this.appConfiguration.getProperty("InclusionSocial"));
				String[] tiposDoc=documentos.split("#");
				for(int i=0;i<tiposDoc.length;i++){
					if(listaActividadLaboral.contains("#"+tiposDoc[i]+"-")){
						String dato=listaActividadLaboral.substring(listaActividadLaboral.indexOf("#"+tiposDoc[i]+"-")+1);
						actividadLaboral=actividadLaboral+dato.substring(dato.indexOf("-")+1, dato.indexOf("#")-1)+":";
					}
					if(listaInclusion.contains("#"+tiposDoc[i]+"-")){
						String dato=listaInclusion.substring(listaInclusion.indexOf("#"+tiposDoc[i]+"-")+1);
						inclusionSocial=inclusionSocial+dato.substring(dato.indexOf("-")+1, dato.indexOf("#")-1)+":";
					}
				}
			} else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
				aa83b25t00 = new Aa83b25t00();
				aa83b25t00.setId025(Integer.parseInt(tiponumSol));
				aa83b25t00.setIdAno025(Long.parseLong(anoSol));
				aa83b25t00 = this.aa83b25t00Service.findResolucion(aa83b25t00);
				
				aa83b25t00.setResolFavorable025(Integer.valueOf(favorable));
				this.aa83b25t00Service.updateResolFavorable(aa83b25t00);
				Aa83b12t00 aa83b12t00 = new Aa83b12t00();
				aa83b12t00.setId012(aa83b25t00.getId012TipoDoc());
				aa83b12t00List = this.aa83b12t00Service.findAllLike(aa83b12t00,null, false);
				a83bPais.setId(aa83b25t00.getNacionalidad025().toString());
				a83bPais = this.a83bNoraService.findPaisesById(a83bPais);
				String listaMediosEconomicos=this.aa83b30t00Service.buscarDocumentosPorBloque(this.appConfiguration.getProperty("MediosEconomicos"));
				String listaIdentidad=this.aa83b30t00Service.buscarDocumentosPorBloque(this.appConfiguration.getProperty("Identidad"));
				String listaResidencia=this.aa83b30t00Service.buscarDocumentosPorBloque(this.appConfiguration.getProperty("Residencia"));
				String listaFormacion=this.aa83b30t00Service.buscarDocumentosPorBloque(this.appConfiguration.getProperty("Formacion"));
				String listaFormacionSociolaboral=this.aa83b30t00Service.buscarDocumentosPorBloque(this.appConfiguration.getProperty("FormacionSociolaboral"));
				String listaParticipacion=this.aa83b30t00Service.buscarDocumentosPorBloque(this.appConfiguration.getProperty("Participacion"));
				String[] tiposDoc=documentos.split("#");
				for(int i=0;i<tiposDoc.length;i++){
					if(listaMediosEconomicos.contains("#"+tiposDoc[i]+"-")){
						String dato=listaMediosEconomicos.substring(listaMediosEconomicos.indexOf("#"+tiposDoc[i]+"-")+1);
						mediosEconomicos=mediosEconomicos+dato.substring(dato.indexOf("-")+1, dato.indexOf("#")-1)+":";
					}
					if(listaIdentidad.contains("#"+tiposDoc[i]+"-")){
						String dato=listaIdentidad.substring(listaIdentidad.indexOf("#"+tiposDoc[i]+"-")+1);
						identidad=identidad+dato.substring(dato.indexOf("-")+1, dato.indexOf("#")-1)+":";
					}
					if(listaResidencia.contains("#"+tiposDoc[i]+"-")){
						String dato=listaResidencia.substring(listaResidencia.indexOf("#"+tiposDoc[i]+"-")+1);
						residencia=residencia+dato.substring(dato.indexOf("-")+1, dato.indexOf("#")-1)+":";
					}
					if(listaFormacion.contains("#"+tiposDoc[i]+"-")){
						String dato=listaFormacion.substring(listaFormacion.indexOf("#"+tiposDoc[i]+"-")+1);
						formacion=formacion+dato.substring(dato.indexOf("-")+1, dato.indexOf("#")-1)+":";
					}
					if(listaFormacionSociolaboral.contains("#"+tiposDoc[i]+"-")){
						String dato=listaFormacionSociolaboral.substring(listaFormacionSociolaboral.indexOf("#"+tiposDoc[i]+"-")+1);
						formacion=formacion+dato.substring(dato.indexOf("-")+1, dato.indexOf("#")-1)+":";
					}
					if(listaParticipacion.contains("#"+tiposDoc[i]+"-")){
						String dato=listaParticipacion.substring(listaParticipacion.indexOf("#"+tiposDoc[i]+"-")+1);
						participacion=participacion+dato.substring(dato.indexOf("-")+1, dato.indexOf("#")-1)+":";
					}
				}
			}
			// Sacamos la documentacion a subsanar
			Aa83b30t00 aa83b30t00 = new Aa83b30t00();
			aa83b30t00.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_1));
			aa83b30t00.setId002Tram(Integer.parseInt(Aa83BConstants.COD_TRAM_1));
			aa83b30t00.setId003TipoSol(Integer.parseInt(tipoSolicitud));

			Aa83bPifController.logger.info("Propiedad:"	+ this.appConfiguration.getProperty("RUTA_EDICION_PIF"));
			
			// Aa83bPifController.logger.info("Aa83bPifController Solicitante="
			// + aa83b21t00.toString());

			// Generar el xml xon los datos de los acuses seleccionados
			//
			Aa83bPifController.logger.info("Despues de buscar la Soli:");
			

			
			Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
			Aa83bPifController.logger.info("aa83bXMLGenerator");
			
			String cadenaXML="";
			if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
				cadenaXML = aa83bXMLGenerator.generateXMLInformeEsfuerzo(aa83b23t00, aa83b12t00List.get(0),
					a83bPais, aa83b19t00ListTecnicos.get(0),aa83b19t00List2Directores.get(0),motivoSolicitud,estadoSolicitud,actividadLaboral,inclusionSocial);
			}else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
				cadenaXML = aa83bXMLGenerator.generateXMLInformeArraigo(aa83b25t00, aa83b12t00List.get(0),
						a83bPais, aa83b19t00ListTecnicos.get(0),aa83b19t00List2Directores.get(0),mediosEconomicos,identidad,residencia,formacion,participacion);
			}
			Aa83bPifController.logger.info("Despues de generar el XML:");
			
			Aa83bPifController.logger.info("[Aa83bPifController] generarAdjuntoRemito: cadenaXML="+ cadenaXML);
			
			// INICIO Subimos el xml a PIF
			String rutaXML = Aa83bUtilProperties.PIF_PATH + nomTemplate004+ ".xml";
			Aa83bPifController.logger.info("[Aa83bPifController] generarAdjuntoRemito: rutaXML="+ rutaXML);
			
			InputStream isXML = new ByteArrayInputStream(cadenaXML.getBytes("UTF-8"));// NOPMD
			Aa83bPifController.logger.info("[Aa83bPifController] : generarAdjuntoRemito isXML:"	+ isXML.toString());
			
			Y31AttachmentBean rdoXML = service.put(xmlSesionDocument, isXML,rutaXML, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
			Aa83bPifController.logger.info("[Aa83bPifController] : generarAdjuntoRemito despues del put");
			String pathPifXML = rdoXML.getFilePath();

			Aa83bPifController.logger.info("[Aa83bPifController] : generarAdjuntoRemito pathPifXML: "+ pathPifXML);
			// FIN Subimos el xml a PIF

			// Llamamos al metodo create de aa19
			Aa83bPifController.logger.info("[Aa83bPifController] generarAdjuntoRemito: Llamamos al metodo create de aa19: ");
			String pathPifDocGenerado = Aa83bUtilProperties.PIF_PATH+ nomTemplate004 + ".doc";
			try {

				Aa83bPifController.logger.info("[Aa83bPifController] : Llamo a AA19B con: "	+ pathPifXML + "pathPifPlantilla:"
								+ pathPifPlantilla + " pathPifDocGenerado:"	+ pathPifDocGenerado);
			
				ruta = this.documentoWebServiceImpl.create(pathPifXML,pathPifPlantilla, pathPifDocGenerado);

				Aa83bPifController.logger.info("[Aa83bPifController] generarAdjuntoRemito: ruta: "+ ruta);
				// Copiamos el fichero en EJIEBOX

				ArrayList<String> partesRuta = new ArrayList<String>(
						Arrays.asList(ruta.split("/")));

				
				if (partesRuta != null && partesRuta.size() > 0) {

					nombreDocumento = partesRuta.get(partesRuta.size() - 1);

				}

				rutaDestinoBox = this.appConfiguration.getProperty("RUTA_PIF_USER")
						// .concat(
						// H50bUtilsSeguridad.getUsername().toLowerCase())
						.concat(Aa83bUtilSeguridad.getUsername().toLowerCase())	.concat(this.appConfiguration
								.getProperty("RUTA_PIF_EDITA_USER")).concat(this.appConfiguration.getProperty("RUTA_PIF_APP")).concat(nombreDocumento);

				Y31AttachmentBean rdoRutaEjieBox = service.copy(xmlSesionDocument, ruta, rutaDestinoBox, true);// NOPMD

				Aa83bPifController.logger.info("[Aa83bPifController] rutaDestino despues Copy: "+ rdoRutaEjieBox.getFilePath());
			
				
				nuevoId = this.getNuevoId(tipoSolicitud, nombreDocumento, tiponumSol, anoSol, aa83b04t00List);

			} catch (Exception e) {
				// TODO Auto-generated catch block
				Aa83bPifController.logger.error("[Aa83bPifController] Excepcion: "+ e.getMessage());
				
			}

		} catch (Exception e) {
			Aa83bPifController.logger.error(e.getMessage());

		}
		Aa83bPifController.logger.info("[Aa83bPifController] : Se ha creado el DOC en la AA19B: "
						+ this.appConfiguration.getProperty("RUTA_EDICION_PIF")	+ rutaDestinoBox);
		
		retorno.put("rutaCompleta",	this.appConfiguration.getProperty("RUTA_EDICION_PIF")+ rutaDestinoBox);
		retorno.put("rutaWebdav", rutaDestino);
		retorno.put("nuevaRutaPif", rutaOrigen2);
		retorno.put("nombreDocPif", nombreDocumento);
		retorno.put("idDoc", String.valueOf(nuevoId));
		Aa83bPifController.logger.info("nombreDoc " + nombreDocumento );
		return retorno;
	}
	
	/**
	 * @param idSol String
	 * @param anoSol String
	 * @param request HttpServletRequest
	 * @param response HttpServletResponse
	 * @return HashMap<String, String>
	 * @throws Exception e
	 */
	@RequestMapping(value = "/generarFicha", method = RequestMethod.GET)
	public @ResponseBody() HashMap<String, String> generarFicha(
			@RequestParam(value = "idSol", required = true) String idSol,
			@RequestParam(value = "anoSol", required = true) String anoSol,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		Aa83bPifController.logger.info("\n\n ------------- Aa83bPifController.generarFicha() INI -------- ");
		
		HashMap<String, String> retorno = new HashMap<String, String>();
		String nombreDocumento = "";
		
		//Se buscan los datos de la solicitud
		Aa83b21v00 aa83b21v00 = new Aa83b21v00();
		aa83b21v00.setIdano021(Long.parseLong(anoSol));
		aa83b21v00.setId021(Integer.parseInt(idSol));
		aa83b21v00 = this.aa83b21t00Service.findFicha(aa83b21v00);
		
		//REcoger de BD la plantilla y subirla a PIF
		Aa83b04t00 aa83b04t00 = new Aa83b04t00();
		aa83b04t00.setId002Tram(Integer.parseInt(Aa83BConstants.COD_TRAM_0));
		aa83b04t00.setIdfase(Integer.parseInt(Aa83BConstants.COD_FASE_0));
		aa83b04t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
		aa83b04t00.setNomTemplate004(Aa83BConstants.NOMPLANTILLA_FICHA_ADE);
		List<Aa83b04t00> aa83b04t00List = new ArrayList<Aa83b04t00>();
		aa83b04t00List = this.aa83b04t00Service.findAll(aa83b04t00, null);
		Aa83bPifController.logger.info("aa83b04t00:" + aa83b04t00List.size());
		
		StringBuffer buffer=new StringBuffer();
		buffer=Aa83bPifController.sustituirCadenaCaracteresRtf(aa83b04t00List.get(0).getPlantilla004(),new HashMap<String, String>());
		
		String nomTemplate004 = aa83b04t00List.get(0).getNomTemplate004();
		String rutaDoc = Aa83bUtilProperties.PIF_PATH + nomTemplate004 + ".rtf";
		InputStream is = new ByteArrayInputStream(buffer.toString().getBytes());
		Aa83bPifController.logger.info("Plantilla:" + aa83b04t00List.get(0).getPlantilla004());
		
		Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
		String sesionToken = Aa83bUtilSeguridad.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		
		Document xmlSesionDocument = builder.parse(new ByteArrayInputStream(sesionToken.getBytes("UTF-8")));
		Y31AttachmentBean rdoRTF = service.put(xmlSesionDocument, is,rutaDoc, Long.parseLong(Aa83bUtilProperties.PIF_TTL));
		String pathPifPlantilla = rdoRTF.getFilePath();
		Aa83bPifController.logger.info("pathPifPlantilla:" + pathPifPlantilla);
		
		//Recoger los vinculos de las personas a reagrupar
		
		List<Aa83b18t00> vinculosl = new ArrayList<Aa83b18t00>();
		Aa83b18t00 aa83b18t00 = new Aa83b18t00();
		aa83b18t00.setIdAno021(aa83b21v00.getIdano021());
		aa83b18t00.setId021NumSol(aa83b21v00.getId021());
		vinculosl = this.aa83b18t00Service.findAll(aa83b18t00, null);
		aa83b21v00.setVinculosL(vinculosl);
		
		//recoger la documentacin que ha presentado el solicitante. No se repiten documentos
		List<Aa83b31v01> documentosl = new ArrayList<Aa83b31v01>();
		Aa83b31v01 aa83b31v01 = new Aa83b31v01();
		aa83b31v01.setIdano021(aa83b21v00.getIdano021());
		aa83b31v01.setId021numsol(aa83b21v00.getId021());
		documentosl = this.aa83b31t00Service.findDistinctAll(aa83b31v01);
		aa83b21v00.setDocumentosL(documentosl);
		
		//Generar el XML con los datos y subirlo a PIF		
		Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator	.getInstance();
		
		String cadenaXML = aa83bXMLGenerator.generateXMLFicha(aa83b21v00);
		
		Aa83bPifController.logger.info("\n\n\n[Aa83bPifController] generarFicha: cadenaXML="+ cadenaXML+"\n\n\n");
	
		String rutaXML = Aa83bUtilProperties.PIF_PATH + nomTemplate004	+ ".xml";
		Aa83bPifController.logger.info("[Aa83bPifController] generarFicha: rutaXML="	+ rutaXML);
		InputStream isXML = new ByteArrayInputStream(cadenaXML.getBytes("UTF-8"));// NOPMD
		Aa83bPifController.logger.info("[Aa83bPifController] : generarFicha isXML:"	+ isXML.toString());
		Y31AttachmentBean rdoXML = service.put(xmlSesionDocument, isXML,rutaXML, new Long(Aa83BConstants.CIENTOVEINTE));
		Aa83bPifController.logger.info("[Aa83bPifController] : generarFicha despues del put");
		String pathPifXML = rdoXML.getFilePath();
		Aa83bPifController.logger.info("[Aa83bPifController] : generarFicha pathPifXML: "+ pathPifXML);

		// Llamamos al metodo create de aa19
		Aa83bPifController.logger.info("[Aa83bPifController] generarFicha: Llamamos al metodo create de aa19: ");
		String pathPifDocGenerado = Aa83bUtilProperties.PIF_PATH+ nomTemplate004 + ".doc";
		
		String rutaDestinoBox = "";
		try {
			String ruta = this.documentoWebServiceImpl.create(pathPifXML,pathPifPlantilla, pathPifDocGenerado);
			Aa83bPifController.logger.info("[Aa83bPifController] generarFicha: ruta: "+ ruta);
			
			ArrayList<String> partesRuta = new ArrayList<String>(Arrays.asList(ruta.split("/")));
			if (partesRuta != null && partesRuta.size() > 0) {
				nombreDocumento = partesRuta.get(partesRuta.size() - 1);
			}
			
			rutaDestinoBox = this.appConfiguration.getProperty("RUTA_PIF_USER")
			                        .concat(Aa83bUtilSeguridad.getUsername().toLowerCase())
			                        .concat(this.appConfiguration.getProperty("RUTA_PIF_EDITA_USER"))
			                        .concat(nombreDocumento);
			Y31AttachmentBean rdoRutaEjieBox = service.copy(xmlSesionDocument, ruta, rutaDestinoBox, true);
			Aa83bPifController.logger.info("[Aa83bPifController] rutaDestino despues Copy: "+ rdoRutaEjieBox.getFilePath());
			
		} catch (Exception e){
			Aa83bPifController.logger.error("[Aa83bPifController] Excepcion: " + e.getMessage());	
		}
		
		Aa83bPifController.logger.info("[Aa83bPifController] : Se ha creado el DOC en la AA19B: "
				+ this.appConfiguration.getProperty("RUTA_EDICION_PIF")
				+ rutaDestinoBox);
		
		retorno.put("rutaCompleta",this.appConfiguration.getProperty("RUTA_EDICION_PIF")+ rutaDestinoBox);
		retorno.put("nombreDocPif", nombreDocumento);
		return retorno;
	}	

	public static StringBuffer sustituirCadenaCaracteresRtf(String filename,HashMap mapaPares) throws IOException{
	    StringBuffer contenido = new StringBuffer();
	    contenido.append(leerTodoFichero(filename).toString());
	    String contenidoStr = contenido.toString().replaceAll("\r", "").replaceAll("\n","");
	    contenido = new StringBuffer(contenidoStr);
	    
	    Iterator itmapaPares = mapaPares.keySet().iterator();
	    //En una primera vuelta se sustituyen todas las variables del hashmap tal cual
	    while(itmapaPares.hasNext()){
	    	String key = (String)itmapaPares.next();
	    	contenido = new StringBuffer(contenido.toString().replaceAll(key, (String)mapaPares.get(key)));//NOPMD
	    }

	    
	    return contenido;
  }
	public static CharSequence leerTodoFichero(String filename) throws IOException
	  {
	    CharBuffer cbuf = null;
	      FileInputStream fis = new FileInputStream(filename);
	      FileChannel fc = fis.getChannel();
	      ByteBuffer bbuf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, 
	        (int)fc.size());
	      cbuf = Charset.forName("8859_1").newDecoder()
	        .decode(bbuf);
	    return cbuf;
	  }
	public static StringBuffer sustituirCadenaCaracteresRtf(byte[] file,HashMap mapaPares) throws IOException{
		StringBuffer contenido = new StringBuffer();
		contenido.append(leerTodoFichero(file).toString());
		
		String contenidoStr = contenido.toString().replaceAll("\r", "").replaceAll("\n","");
		contenido = new StringBuffer(contenidoStr);
		
		
		Iterator itmapaPares = mapaPares.keySet().iterator();
		
		//En una primera vuelta se sustituyen todas las variables del hashmap tal cual
		while(itmapaPares.hasNext()){
			String key = (String)itmapaPares.next();
			String value = (String)mapaPares.get(key);
			if(StringUtils.isEmpty(value)){
				value = "";
			}
			Aa83bPifController.logger.info("ANTES DE SUSTITUIR==>"+contenido.toString().length());
			Aa83bPifController.logger.info("ANTES DE SUSTITUIR==>"+contenido.toString().indexOf(key));
			contenido = new StringBuffer(contenido.toString().replaceAll(key, value));//NOPMD
			Aa83bPifController.logger.info("SUSTITUIDO");
		}
		return contenido;
	}
		public static CharSequence leerTodoFichero(byte[] file) throws IOException{
			String fileStr = new String(file);
			
			int posUltLlave = fileStr.lastIndexOf("}");
			
			if(posUltLlave != fileStr.length()-1){
				fileStr = fileStr.substring(0,posUltLlave+1);
			}
			
			return fileStr;
		}

	/**
	 * @return String
	 */
	private String getAuditUser(){
		String auditUser;
		if (Aa83bUtilSeguridad.enOficina()) {
			auditUser = "AA83B-1#AA83B-1#AA83B-1";
		} else {
			auditUser = Aa83bUtilSeguridad.getAuditUser();
		}
		return auditUser;
	}
	
	/**
	 * @param tipoSolicitud String
	 * @param nombreDocumento String
	 * @param tiponumSol String
	 * @param anoSol String
	 * @param aa83b04t00List  ArrayList<Aa83b04t00> 
	 * @return int
	 */
	private int getNuevoId(String tipoSolicitud, String nombreDocumento, String tiponumSol, String anoSol, List<Aa83b04t00> aa83b04t00List){
		int nuevoId = 0;
		if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
			Aa83b22t00 aa83b22t00 = new Aa83b22t00();
			aa83b22t00.setIdPif022(nombreDocumento);
			aa83b22t00.setId023SolEsf(Integer.parseInt(tiponumSol));
			aa83b22t00.setIdAno023(Long.parseLong(anoSol));
			aa83b22t00.setDocDescEs(aa83b04t00List.get(0).getDescEs004());
			aa83b22t00.setDocDescEs(aa83b04t00List.get(0).getDescEu004());
			aa83b22t00.setId004TipoDocG(aa83b04t00List.get(0).getId004());

			Aa83b10t00 aa83b10t00 = new Aa83b10t00();
			aa83b10t00.setIdAno023(Long.parseLong(anoSol));
			aa83b10t00.setId023NumSol(new Long(tiponumSol));
			aa83b10t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));
			List<Aa83b10t00> aa83b10t00List = this.aa83b10t00Service.findAllLike(aa83b10t00, null, false);

			aa83b22t00.setId010HistoTram(aa83b10t00List.get(0).getId010());

			aa83b22t00=this.aa83b22t00Service.add(aa83b22t00);
			nuevoId=aa83b22t00.getId022();
		} else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
			Aa83b24t00 aa83b24t00 = new Aa83b24t00();
			aa83b24t00.setIdPif024(nombreDocumento);
			aa83b24t00.setIdNumSol025(Integer.parseInt(tiponumSol));
			aa83b24t00.setIdAno025(Long.parseLong(anoSol));
			aa83b24t00.setDocDescEs(aa83b04t00List.get(0).getDescEs004());
			aa83b24t00.setDocDescEs(aa83b04t00List.get(0).getDescEu004());
			aa83b24t00.setId004TipoDocG(aa83b04t00List.get(0).getId004());

			Aa83b11t00 aa83b11t00 = new Aa83b11t00();
			aa83b11t00.setIdAnoSol025(Long.parseLong(anoSol));
			aa83b11t00.setId025NumSol(Integer.parseInt(tiponumSol));
			aa83b11t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
			List<Aa83b11t00> aa83b11t00List = this.aa83b11t00Service.findAllLike(aa83b11t00, null, false);

			aa83b24t00.setId011HistoTram(aa83b11t00List.get(0).getId011());

			aa83b24t00=this.aa83b24t00Service.add(aa83b24t00);
			nuevoId=aa83b24t00.getId024();
		}
		return nuevoId;
	}
	
	/**
	 * @param tipoSolicitud String
	 * @param nombreDocumento String
	 * @param tiponumSol String
	 * @param anoSol String
	 * @param aa83b04t00List List<Aa83b04t00>
	 * @return int
	 */
	private int getNuevoIdReq (String tipoSolicitud, String nombreDocumento, String tiponumSol, String anoSol, List<Aa83b04t00> aa83b04t00List){
		//Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		
		int nuevoId = 0;
		
		if (Aa83BConstants.COD_ADE.equals(tipoSolicitud)) {
			Aa83b20t00 aa83b20t00 = new Aa83b20t00();
			aa83b20t00.setIdPif020(nombreDocumento);
			aa83b20t00.setId021SolAde(Integer.parseInt(tiponumSol));
			aa83b20t00.setIdAno021(Long.parseLong(anoSol));
			aa83b20t00.setDocDescEs(aa83b04t00List.get(0).getDescEs004());
			aa83b20t00.setDocDescEs(aa83b04t00List.get(0).getDescEu004());
			aa83b20t00.setId004TipoDocG(aa83b04t00List.get(0).getId004());

			Aa83b09t00 aa83b09t00 = new Aa83b09t00();
			aa83b09t00.setIdAno021(Long.parseLong(anoSol));
			aa83b09t00.setId021NumSol(Integer.parseInt(tiponumSol));
			aa83b09t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
			List<Aa83b09t00> aa83b09t00List = this.aa83b09t00Service.findAllLike(aa83b09t00, null, false);

			aa83b20t00.setId009HistoTram(aa83b09t00List.get(0).getId009());
			
			/*Aa83b21t00 aa83b21t00 = new Aa83b21t00();
			aa83b21t00.setId021(Integer.parseInt(tiponumSol));
			aa83b21t00.setIdAno021(Long.parseLong(anoSol));
			aa83b21t00 = this.aa83b21t00Service.find(aa83b21t00);*/

		/*	aa83b09t00Service.add(aa83bSolicitudesUtil
					.guardarHistoADE(aa83b21t00, Aa83BConstants.COD_FASE_1, Aa83BConstants.COD_TRAM_2, "N"));*/

			aa83b20t00=this.aa83b20t00Service.add(aa83b20t00);
			nuevoId=aa83b20t00.getId020();
		} else if (Aa83BConstants.COD_ESF.equals(tipoSolicitud)) {
			Aa83bPifController.logger.info("[Aa83bPifController] esfuerzo: ");
			Aa83b22t00 aa83b22t00 = new Aa83b22t00();
			aa83b22t00.setIdPif022(nombreDocumento);
			aa83b22t00.setId023SolEsf(Integer.parseInt(tiponumSol));
			aa83b22t00.setIdAno023(Long.parseLong(anoSol));
			aa83b22t00.setDocDescEs(aa83b04t00List.get(0).getDescEs004());
			aa83b22t00.setDocDescEs(aa83b04t00List.get(0).getDescEu004());
			aa83b22t00.setId004TipoDocG(aa83b04t00List.get(0).getId004());

			Aa83b10t00 aa83b10t00 = new Aa83b10t00();
			aa83b10t00.setIdAno023(Long.parseLong(anoSol));
			aa83b10t00.setId023NumSol(new Long(tiponumSol));
			aa83b10t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));
			List<Aa83b10t00> aa83b10t00List = this.aa83b10t00Service.findAllLike(aa83b10t00, null, false);

			aa83b22t00.setId010HistoTram(aa83b10t00List.get(0).getId010());
			
			/*Aa83b23t00 aa83b23t00 = new Aa83b23t00();
			aa83b23t00.setId023(Integer.parseInt(tiponumSol));
			aa83b23t00.setIdAno023(Long.parseLong(anoSol));
			aa83b23t00 = this.aa83b23t00Service.find(aa83b23t00);*/

		/*	aa83b10t00Service.add(aa83bSolicitudesUtil
					.guardarHistoESF(aa83b23t00, Aa83BConstants.COD_FASE_1, Aa83BConstants.COD_TRAM_2, "N"));*/

			aa83b22t00=this.aa83b22t00Service.add(aa83b22t00);
			nuevoId=aa83b22t00.getId022();
			Aa83bPifController.logger.info("[Aa83bPifController] esfuerzo insertado el documento: ");
		} else if (Aa83BConstants.COD_ARR.equals(tipoSolicitud)) {
			Aa83b24t00 aa83b24t00 = new Aa83b24t00();
			aa83b24t00.setIdPif024(nombreDocumento);
			aa83b24t00.setIdNumSol025(Integer.parseInt(tiponumSol));
			aa83b24t00.setIdAno025(Long.parseLong(anoSol));
			aa83b24t00.setDocDescEs(aa83b04t00List.get(0).getDescEs004());
			aa83b24t00.setDocDescEs(aa83b04t00List.get(0).getDescEu004());
			aa83b24t00.setId004TipoDocG(aa83b04t00List.get(0).getId004());

			Aa83b11t00 aa83b11t00 = new Aa83b11t00();
			aa83b11t00.setIdAnoSol025(Long.parseLong(anoSol));
			aa83b11t00.setId025NumSol(Integer.parseInt(tiponumSol));
			aa83b11t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
			List<Aa83b11t00> aa83b11t00List = this.aa83b11t00Service.findAllLike(aa83b11t00, null, false);

			aa83b24t00.setId011HistoTram(aa83b11t00List.get(0).getId011());
			
		/*	Aa83b25t00 aa83b25t00 = new Aa83b25t00();
			aa83b25t00.setId025(Integer.parseInt(tiponumSol));
			aa83b25t00.setIdAno025(Long.parseLong(anoSol));
			aa83b25t00 = this.aa83b25t00Service.find(aa83b25t00);*/

		/*	aa83b11t00Service.add(aa83bSolicitudesUtil
					.guardarHistoARR(aa83b25t00, Aa83BConstants.COD_FASE_1, Aa83BConstants.COD_TRAM_2, "N"));*/

			aa83b24t00=this.aa83b24t00Service.add(aa83b24t00);
			nuevoId=aa83b24t00.getId024();
		}
		return nuevoId;
	}
}
