package com.ejie.aa83b.control;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBElement;

import n38c.exe.N38API;
import n38i.exe.N38Excepcion;
import n38i.exe.N38ParameterException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.w3c.dom.Document;

import com.ejie.aa83b.exception.Aa83bErrorGenericoException;
import com.ejie.aa83b.exception.Aa83bWebserviceException;
import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b10t00;
import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b25t00;

import com.ejie.aa83b.model.Aa83bNotificacionCorreosDatosRemesa;
import com.ejie.aa83b.model.Aa83bNotificacionCorreosDatosUsuario;
import com.ejie.aa83b.service.Aa83b09t00Service;
import com.ejie.aa83b.service.Aa83b10t00Service;
import com.ejie.aa83b.service.Aa83b11t00Service;
import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b23t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83bNotificacionesCorreosService;
import com.ejie.aa83b.service.Aa83bNotificacionesServiceImpl;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSesionUtils;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.aa83b.util.Aa83bUtilXML;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContext;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContextParser;
import com.ejie.aa83b.util.tramita.Aa83bXmlException;
import com.ejie.aa83b.util.xml.Aa83bXMLGenerator;
import com.ejie.aa83b.webservice.client.aa66.DestinatarioWs;
import com.ejie.aa83b.webservice.client.aa66.EnvioWs;
import com.ejie.aa83b.webservice.client.aa66.ObjectFactory;
import com.ejie.aa83b.webservice.client.aa66.RemesaOutWs;
import com.ejie.aa83b.webservice.client.r02.Q99RCPFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.vdc.Q99USendMessageSCPFacadeWSSoap;




/**
 * @author blarreina
 *
 */
@Controller()
@RequestMapping(value = "/notificacionCorreos")
public class Aa83bNotificacionCorreosController {
	@Autowired()
	private Aa83bNotificacionesCorreosService aa83bNotificacionesCorreosService;
	@Autowired()
	private Properties appConfiguration;
	@Autowired()
	private Aa83b09t00Service aa83b09t00Service;
	
	@Autowired()
	private Aa83b10t00Service aa83b10t00Service;
	
	@Autowired()
	private Aa83b11t00Service aa83b11t00Service;
	@Autowired()
	private Aa83b21t00Service aa83b21t00Service;

	@Autowired()
	private Aa83b23t00Service aa83b23t00Service;
	
	@Autowired()
	private Aa83b25t00Service aa83b25t00Service;
	
	@Autowired()
	private Q99RCPFacadeWSSoap q99RCPFacadeWSSoap;
	@Autowired()
	private Q99USendMessageSCPFacadeWSSoap q99uSendMessageSCPFacadeWSSoap;
	
	private static final Logger logger = LoggerFactory.getLogger(Aa83bNotificacionCorreosController.class);
	
	/**
	 * @param tipoRemesa String
	 * @param selectedIds String
	 * @param session HttpSession
	 * @param request HttpServletRequest
	 * @return String
	 * @throws Aa83bWebserviceException e
	 */
	@RequestMapping(value = "/correspondencia/{tipoRemesa}/{selectedIds}", method = RequestMethod.GET)
	public @ResponseBody ()
	String enviarRemesaDiaria(
			@PathVariable() String tipoRemesa,
			@PathVariable() String selectedIds,
			HttpSession session, HttpServletRequest request) throws Aa83bWebserviceException{
		
		String[] expedientes=selectedIds.split(",");
		 int numEnviosMinPorRemesa=Aa83BConstants.TREINTA;//30
		 int numEnviosMaxPorRemesa=Aa83BConstants.CIENTOCINCUENTA;//150
		if("M".equals(tipoRemesa)&& expedientes.length>numEnviosMinPorRemesa){
			//Remesa Masiva
			if(expedientes.length > numEnviosMaxPorRemesa){
				//Calcular numero de remesas que hacen falta 
				double cociente= Math.floor(expedientes.length/numEnviosMaxPorRemesa);
				int resto=expedientes.length%numEnviosMaxPorRemesa;
				int numMaxEnvios= (int)cociente + 1;
				int numEnviosUltimaRemesa=numEnviosMinPorRemesa+resto;
				int numExpediente=0;
				//Si el resto es menor a 30 hay que quitar expedientes de la penultima remesa 
				// para introducirlos en la ultima porque como minimo tiene que haber 30 expedientes en cada remesa.
				if(resto<numEnviosMinPorRemesa){
					//Preparar remesas a enviar menos la ltima
					for(int i=1;i<=numMaxEnvios-1;i++){
						List<EnvioWs> listaEnvios =new ArrayList<EnvioWs>();
						if(i==numMaxEnvios-1){
							int numEnvios=numEnviosMaxPorRemesa-numEnviosMinPorRemesa;
							//Remesa penultima--> a la que hay que descontar
							while(numExpediente<numEnvios){
								String[] parteExpediente= expedientes[numExpediente].split(" ");
								listaEnvios.add(this.crearEnvios(expedientes[numExpediente], parteExpediente,session, request));
								numExpediente++;
							}
						
						}else{
							//Remesas normales--> 30< x <150					
							for(int j=0; j<numEnviosMaxPorRemesa;j++){
								String[] parteExpediente= expedientes[numExpediente].split(" ");
								listaEnvios.add(this.crearEnvios(expedientes[numExpediente], parteExpediente, session, request));
								numExpediente++;
							}

						}
							
//						enviar remesa cada vez que se complete una
						this.enviarRemesa(listaEnvios,expedientes,tipoRemesa, session, request);
					}
					List<EnvioWs> listaEnvios =new ArrayList<EnvioWs>();
					//La ltima remesa incompleta
					for(int j=0; j<numEnviosUltimaRemesa;j++){
						String[] parteExpediente= expedientes[numExpediente].split(" ");
						listaEnvios.add(this.crearEnvios(expedientes[numExpediente], parteExpediente, session, request));
						numExpediente++;
					}
					this.enviarRemesa(listaEnvios,expedientes,tipoRemesa, session, request);
					
				}else{
					for (int i = 0; i < numMaxEnvios; i++) {
						List<EnvioWs> listaEnvios =new ArrayList<EnvioWs>();
						for (int j = numExpediente; j < numEnviosMaxPorRemesa; numExpediente++) {
							String[] parteExpediente = expedientes[j].split(" ");
							listaEnvios.add(this.crearEnvios(expedientes[j], parteExpediente, session, request));
						}
						this.enviarRemesa(listaEnvios,expedientes,tipoRemesa,session, request);
					}
				}
				
			}else{
				//Remesa Masiva-->Si el numero de expedientes a enviar es mayor a 30 y menor a 150, se envia normal, todo en la misma remesa
				List<EnvioWs> listaEnvios =new ArrayList<EnvioWs>();
				for(int i=0; i< expedientes.length; i++){
					String[] parteExpediente= expedientes[i].split(" ");
					listaEnvios.add(this.crearEnvios(expedientes[i], parteExpediente, session, request));
				}
				this.enviarRemesa(listaEnvios,expedientes,tipoRemesa,session, request);
			}
		
		}else{
			//Remesa diaria
			List<EnvioWs> listaEnvios =new ArrayList<EnvioWs>();
			for(int i=0; i< expedientes.length; i++){
				String[] parteExpediente= expedientes[i].split(" ");
				listaEnvios.add(this.crearEnvios(expedientes[i], parteExpediente, session, request));
			}
			return this.enviarRemesa(listaEnvios, expedientes, tipoRemesa, session, request);			
		}
		return "{\"status\": \"ok\"}";
	}
	
	/**
	 * @param expediente String
	 * @param parteExpediente String[]
	 * @param session HttpSession
	 * @param request HttpServletRequest
	 * @return EnvioWs
	 */
	public EnvioWs crearEnvios(String expediente, String[] parteExpediente, HttpSession session, HttpServletRequest request){
		
		//String url= (String) this.appConfiguration.getProperty("webservice.NotificacionesWebServiceImplService.wsdl");
		EnvioWs envio = new EnvioWs();
	
        Document miSesion;
		N38API n38api = new N38API(request);
		Aa83bNotificacionCorreosController.logger.info("n38API:::::::::::::" + n38api);
		miSesion = n38api.n38ItemSesion();
	
	
		// PUESTO
		String filtro = "//parametro[@id='n38puestouid']/valor/text()";
		String[] valoresFiltro;
		try {
			valoresFiltro = Aa83bUtilXML.obtenerValorNodosXPath(miSesion,
					filtro);

		Aa83bNotificacionCorreosDatosUsuario notif= new Aa83bNotificacionCorreosDatosUsuario();	
		notif= this.aa83bNotificacionesCorreosService.findComunicaciones(parteExpediente[2], parteExpediente[1], parteExpediente[0]);
		DestinatarioWs destinatario = new DestinatarioWs();
		destinatario.setCodigoPostal(notif.getCodPostal());
		destinatario.setLocalidad(notif.getMunicipio());// La localidad es el municipio
		destinatario.setMunicipio(notif.getMunicipio());
		destinatario.setProvincia(notif.getProvincia());
		StringBuffer str= new StringBuffer();
		str.append(notif.getNombre());
		str.append(" ");
		str.append(notif.getApellidos());
		ObjectFactory objectFactory = new ObjectFactory();
		JAXBElement<String> jaxbElement = objectFactory.createDestinatarioWsNombreApellidos(str.toString()); 
		destinatario.getInstitucionOrNombreApellidos().add(jaxbElement);
		destinatario.setDireccion(notif.getDireccion());		
		
		envio.setDestinatario(destinatario);
		envio.setExpediente(expediente.replace(" ", "-"));
		envio.setIdInterno(expediente.replace(" ", "-"));
		envio.setUidPuestoSolicitante(valoresFiltro[0]);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return envio;
		
	}
	
	/**
	 * @param listaEnvios List<EnvioWs>
	 * @param expedientes String[]
	 * @param tipoRemesa  tipoRemesa
	 * @param session HttpSession
	 * @param request HttpServletRequest
	 * @return String
	 * @throws Aa83bWebserviceException e
	 */
	public String enviarRemesa(List<EnvioWs> listaEnvios,String[] expedientes, String tipoRemesa, HttpSession session, HttpServletRequest request) throws Aa83bWebserviceException{
		int tipoSol = 0;
		Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		Aa83b21t00 aa83b21t00 = new Aa83b21t00();
		Aa83b23t00 aa83b23t00 = new Aa83b23t00();
		Aa83b25t00 aa83b25t00 = new Aa83b25t00();
		//Enviamos la remesa
		RemesaOutWs remesaOut= new RemesaOutWs();
		remesaOut=this.aa83bNotificacionesCorreosService.enviarRemesas(listaEnvios, tipoRemesa, session, request);
		if (remesaOut.getErrores().size() > 0) {
			String mensajeError = remesaOut.getErrores().get(0).getDescripcionCastellano();
			if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage())) {
				mensajeError = remesaOut.getErrores().get(0).getDescripcionEuskera();
			}
			String response = "{ \"status\": \"error\", \"expediente\": \"" + remesaOut.getErrores().get(0).getIdErroneo() +
			"\", \"mensaje\": \"" + mensajeError + "\"}";
			return response;
		}
		
		String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
		String idProcedimiento = "";
		Aa83bConsultationContextParser resParser = new Aa83bConsultationContextParser();
		Aa83bConsultationContext res;
		Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
		Aa83b09t00 aa83b09t00 = new Aa83b09t00();
		Aa83b10t00 aa83b10t00 = new Aa83b10t00();
		Aa83b11t00 aa83b11t00 = new Aa83b11t00();
		
		for(int i=0; i< expedientes.length; i++){
			String[] parteExpediente= expedientes[i].split(" ");
			Aa83bNotificacionCorreosDatosRemesa datosRemesa= new Aa83bNotificacionCorreosDatosRemesa();
			datosRemesa.setId_sol(Integer.parseInt(parteExpediente[2]));
			datosRemesa.setId_anyo(Integer.parseInt(parteExpediente[1]));
		
			Aa83bNotificacionCorreosDatosUsuario notif= new Aa83bNotificacionCorreosDatosUsuario();	
			notif= this.aa83bNotificacionesCorreosService.findComunicaciones(parteExpediente[2], parteExpediente[1], parteExpediente[0]);
		
			// se ponene a null los objetos porque si no al generar el expediente, se mete por los if y dan errores
			if(Aa83BConstants.COD_ADE_STR.equals(parteExpediente[0])){
				tipoSol=Integer.parseInt(Aa83BConstants.COD_ADE);
				aa83b21t00.setId021(Integer.parseInt(parteExpediente[2]));
				aa83b21t00.setIdAno021(Long.parseLong(parteExpediente[1]));
				aa83b21t00 = this.aa83b21t00Service.find(aa83b21t00);
				idProcedimiento = this.appConfiguration.getProperty("procedure.adecuacion.id");
			}else if(Aa83BConstants.COD_ESF_STR.equals(parteExpediente[0])){
				tipoSol=Integer.parseInt(Aa83BConstants.COD_ESF);
				aa83b23t00.setId023(Integer.parseInt(parteExpediente[2]));
				aa83b23t00.setIdAno023(Long.parseLong(parteExpediente[1]));
				aa83b23t00 = this.aa83b23t00Service.find(aa83b23t00);	
				idProcedimiento = this.appConfiguration.getProperty("procedure.esfuerzo.id");
			}else if(Aa83BConstants.COD_ARR_STR.equals(parteExpediente[0])){
				tipoSol=Integer.parseInt(Aa83BConstants.COD_ARR);
				aa83b25t00.setId025(Integer.parseInt(parteExpediente[2]));
				aa83b25t00.setIdAno025(Long.parseLong(parteExpediente[1]));
				aa83b25t00 = this.aa83b25t00Service.find(aa83b25t00);	
				idProcedimiento = this.appConfiguration.getProperty("procedure.arraigo.id");
			}
			datosRemesa.setTipoSol(tipoSol);
			datosRemesa.setIdRemesa(remesaOut.getIdremesa());
			datosRemesa.setIdColeccion(remesaOut.getIdColeccion());
			datosRemesa.setIdEnvio(remesaOut.getEnvios().get(i).getIdEnvio());
			datosRemesa.setCodigoRemesa(remesaOut.getCodigoRemesa());
			datosRemesa.setCodigoColeccion(remesaOut.getCodigoColeccion());
			datosRemesa.setCodigoEnvio(remesaOut.getEnvios().get(i).getCodEnvio());
			
			//guardar uidPuestoTramitador
			N38API n38api = new N38API(request);
			String[] uidPuestoTramitador;
			try {
				uidPuestoTramitador = n38api.n38ItemSesion(N38API.NOMBRE_N38PUESTOUID);
				datosRemesa.setUidPuestoTramitador(uidPuestoTramitador[0]);
				Aa83bNotificacionCorreosController.logger.info("puestoUser:::::::::::::" + uidPuestoTramitador.toString());
				Aa83bNotificacionCorreosController.logger.info("puestoUser:::::::::::::" + uidPuestoTramitador[0]);
			} catch (N38ParameterException e) {
				e.printStackTrace();
			} catch (N38Excepcion e) {
				e.printStackTrace();
			} 
			
	//        String puestoUser = (String) this.appConfiguration.getProperty("TRAMITADOR_DESYPRU_AA66");
	//        datosRemesa.setUidPuestoTramitador(puestoUser);
	        
			//guardar en bbdd
			this.aa83bNotificacionesCorreosService.add(datosRemesa);
		
			String fase= String.valueOf(notif.getIdFase());
			String tramite=String.valueOf(notif.getIdTramite());
		//modificar estado de tramite
			String tipoArchivo="";
			String notifiedActId = "";
			Integer idhist = 0;
			if (fase.equals(Aa83BConstants.COD_FASE_1) && (tramite.equals(Aa83BConstants.COD_TRAM_2)))
			{
				tipoArchivo="req_sub";
				if (parteExpediente[0].equals(Aa83BConstants.COD_ADE_STR)){
					aa83b09t00 = this.aa83b09t00Service.add(aa83bSolicitudesUtil.guardarHistoADE(aa83b21t00, Aa83BConstants.COD_FASE_1,Aa83BConstants.COD_TRAM_3, "N"));
					idhist = aa83b09t00.getId009();
				} else {
					if (parteExpediente[0].equals(Aa83BConstants.COD_ESF_STR)) {
						aa83b10t00 = this.aa83b10t00Service.add(aa83bSolicitudesUtil.guardarHistoESF(aa83b23t00, Aa83BConstants.COD_FASE_1,Aa83BConstants.COD_TRAM_3, "N"));
						idhist = aa83b10t00.getId010();
					} else {
						if (parteExpediente[0].equals(Aa83BConstants.COD_ARR_STR)) {
							aa83b11t00 = this.aa83b11t00Service.add(aa83bSolicitudesUtil.guardarHistoARR(aa83b25t00, Aa83BConstants.COD_FASE_1,Aa83BConstants.COD_TRAM_3, "N"));
							idhist = aa83b11t00.getId011();
						}
					}
				}
			}else {
				if (fase.equals(Aa83BConstants.COD_FASE_2) && (tramite.equals(Aa83BConstants.COD_TRAM_1)))
				{	
					tipoArchivo="resol";
					if (parteExpediente[0].equals(Aa83BConstants.COD_ADE_STR)) {
						aa83b09t00 = this.aa83b09t00Service.add(aa83bSolicitudesUtil.guardarHistoADE(aa83b21t00, Aa83BConstants.COD_FASE_2,Aa83BConstants.COD_TRAM_2, "N"));
						idhist = aa83b09t00.getId009();
					} else {
						if (parteExpediente[0].equals(Aa83BConstants.COD_ESF_STR)) {
							aa83b10t00 = this.aa83b10t00Service.add(aa83bSolicitudesUtil.guardarHistoESF(aa83b23t00, Aa83BConstants.COD_FASE_2,Aa83BConstants.COD_TRAM_2, "N"));
							idhist = aa83b10t00.getId010();
						}
						else {
							if (parteExpediente[0].equals(Aa83BConstants.COD_ARR_STR)) {
								aa83b11t00 = this.aa83b11t00Service.add(aa83bSolicitudesUtil.guardarHistoARR(aa83b25t00, Aa83BConstants.COD_FASE_2,Aa83BConstants.COD_TRAM_2, "N"));
								idhist = aa83b11t00.getId011();
							}
						}
					}
				}
			}
			
			
			//Enviar notificacion
			String procedure = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken,idProcedimiento);
			try {
				resParser = new Aa83bConsultationContextParser(procedure);
				res = resParser.getProcedureDataAll();
				String expediente = "";
				if (parteExpediente[0].equals(Aa83BConstants.COD_ADE_STR)) {
					expediente= aa83bXMLGenerator.generarXmlSaveUpdateProceedings(aa83b21t00, null, null, res, idProcedimiento, null, null, tipoArchivo, true, idhist.toString());
				} else {
					if (parteExpediente[0].equals(Aa83BConstants.COD_ESF_STR)) {
						expediente= aa83bXMLGenerator.generarXmlSaveUpdateProceedings(null, aa83b23t00, null, res, idProcedimiento, null, null, tipoArchivo, true, idhist.toString());
					}
					else {
						if (parteExpediente[0].equals(Aa83BConstants.COD_ARR_STR)) {
							expediente= aa83bXMLGenerator.generarXmlSaveUpdateProceedings(null, null, aa83b25t00, res, idProcedimiento, null, null, tipoArchivo, true, idhist.toString());
						}
					}
				}
				Aa83bNotificacionCorreosController.logger.info("*********** expediente-->"+ expediente);
				this.q99uSendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken, expediente, "saveOrUpdateProceedingsNT");
			
			} catch (Exception es) {
				Aa83bNotificacionCorreosController.logger.info("EXCEP  enviarRemesa: "+ es.getMessage());
				es.printStackTrace();
			}
		}
		return "{\"status\": \"ok\"}";
	}
}
