package com.ejie.aa83b.control;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa83b.model.A83bComunidad;
import com.ejie.aa83b.model.A83bLocalidad;
import com.ejie.aa83b.model.A83bMunicipio;
import com.ejie.aa83b.model.A83bPais;
import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.service.Aa83bNoraService;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilPIF;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.x38.control.bind.annotation.Json;
import com.ejie.x38.json.JsonMixin;

//TODO: Auto-generated Javadoc
/**
 * * Y6204s01Controller generated by UDA, 23-ene-2012 15:42:12.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/a83bNora")
public class Aa83bNoraController {

	/** The Constant logger. */
	private static final Logger LOGGER = LoggerFactory
			.getLogger(Aa83b03t00Controller.class);

	/** The a83b nora service. */
	@Autowired()
	private Aa83bNoraService a83bNoraService;

	/** The app configuration. */
	@Autowired()
	private Properties appConfiguration;

	/**
	 * COMBO SIMPLE Municipio
	 */
	interface A83bMunicipioaMixIn {
		@JsonProperty("value")
		int getId();

		@JsonProperty("label")
		int getDs_o();
	}

	// Combo Tipos de municipio
	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipio", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipioRemote(@RequestParam(value = "provincia", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}
	
	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipioValidado", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipioRemoteValidado(@RequestParam(value = "provEmpCombo", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}
	
	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipioValidadoExpedido", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipioRemoteValidadoExpedido(@RequestParam(value = "provinciaExpedidoCombo", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}


	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipioComunic021", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipioComunic021(@RequestParam(value = "provinciaComunic021", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}
	
	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipio021", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipio021(@RequestParam(value = "provincia021", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}
	
	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipioEmpad021", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipioEmpad021(@RequestParam(value = "provEmp021", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}
	
	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipio023", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipio023(@RequestParam(value = "provEmp023", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}
	
	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipioComunic023", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipioComunic023(@RequestParam(value = "provinciaComunic023", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}
	
	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipioEmpad023", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipioEmpad023(@RequestParam(value = "provinciaEmpadron023", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}
	
	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipio025", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipio025(@RequestParam(value = "provEmp025", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}

	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipioComunic025", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipioComunic025(@RequestParam(value = "provinciaComunic025", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}

	@Json(mixins = { @JsonMixin(target = A83bMunicipio.class, mixin = A83bMunicipioaMixIn.class) })
	@RequestMapping(value = "comboMunicipioEmpad025", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bMunicipio> getMunicipioEmpad025(@RequestParam(value = "provinciaEmpadron025", required = false) String idProvincia,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		return municipiosPorProvincia(idProvincia);
	}
	
	private List<A83bMunicipio> municipiosPorProvincia(String idProvincia) {
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			Aa83bNoraController.LOGGER.error ("[Aa83bNoraController Exception]"+e.getMessage());
		}
		A83bMunicipio municipio = new A83bMunicipio();
		municipio.setProvincia_id(idProvincia);
		List<A83bMunicipio> lista=this.a83bNoraService.findMunicipios(municipio, null);
		return lista;
	}
	
	/**
	 * COMBO SIMPLE Provincia
	 */
	interface A83bProvinciaMixIn {
		@JsonProperty("value")
		int getId();

		@JsonProperty("label")
		int getDs_o();
	}

	// Combo Tipos de documentos
	@Json(mixins = { @JsonMixin(target = A83bProvincia.class, mixin = A83bProvinciaMixIn.class) })
	@RequestMapping(value = "comboProvincia", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bProvincia> getProvinciaRemote(
			@RequestParam(value = "comunidad", required = false) String idComunidad,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			Aa83bNoraController.LOGGER.error ("[Aa83bNoraController Exception]"+e.getMessage());
		}
		A83bProvincia provincia = new A83bProvincia();
		if (idComunidad == null) {
			provincia.setAutonomia_id(Aa83BConstants.COD_COM_EUS);
		} else {
			provincia.setAutonomia_id(idComunidad);
		}
		return this.a83bNoraService.findProvincias(provincia, null);
	}

	/**
	 * Method that retrieves all the data from the 'comunidades' table.
	 * 
	 * @return List<A83bComunidad>
	 */
	/*
	 * @RequestMapping(value = "/comboComunidad", method = RequestMethod.GET)
	 * public @ResponseBody() List<A83bComunidad> getComunidades() { return
	 * this.a83bNoraService.findComunidades(null, null); }
	 */
	/**
	 * COMBO SIMPLE Comunidades
	 */
	interface A83bComunidadMixIn {
		@JsonProperty("value")
		int getId();

		@JsonProperty("label")
		int getDs_o();
	}

	// Combo Tipos de documentos
	@Json(mixins = { @JsonMixin(target = A83bComunidad.class, mixin = A83bComunidadMixIn.class) })
	@RequestMapping(value = "comboComunidad", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bComunidad> getComboRemote(HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			Aa83bNoraController.LOGGER.error ("[Aa83bNoraController Exception]"+e.getMessage());
		}
		return this.a83bNoraService.findComunidades(null, null);
	}

	/**
	 * COMBO SIMPLE Pais
	 */
	interface A83bPaisMixIn {
		@JsonProperty("value")
		int getId();

		@JsonProperty("label")
		int getDs_o();
	}

	// Combo Tipos de paises
	@Json(mixins = { @JsonMixin(target = A83bPais.class, mixin = A83bPaisMixIn.class) })
	@RequestMapping(value = "comboPais", method = RequestMethod.GET)
	public @ResponseBody
	List<A83bPais> getPaisRemote(
			@RequestParam(value = "pais", required = false) String idPais,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			Aa83bNoraController.LOGGER.error ("[Aa83bNoraController Exception]"+e.getMessage());
		}
		// A83bPais pais = new A83bPais();
		return this.a83bNoraService.findPaises(null, null);
	}

	/**
	 * COMBO SIMPLE Provincia
	 */
	interface Aa83bCalleMixIn {
		@JsonProperty("value")
		int getId();

		@JsonProperty("label")
		int getDs_o();
	}

	@Json(mixins = { @JsonMixin(target = Aa83bCalle.class, mixin = Aa83bCalleMixIn.class) })
	@RequestMapping(value = "comboCalle", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa83bCalle> getcomboCalleRemote(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c,
			@RequestParam(value = "prov", required = true) String prov,
			@RequestParam(value = "mun", required = true) String mun,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			Aa83bNoraController.LOGGER.error ("[Aa83bNoraController Exception]"+e.getMessage());
		}
		Aa83bCalle filterCalle = new Aa83bCalle();
		filterCalle.setDs_o(q);
		filterCalle.setProvincia_id(prov);
		filterCalle.setMunicipio_id(mun);
		List<Aa83bCalle> findAll = a83bNoraService.findCalles(filterCalle, null);
		Aa83bCalle calle = new Aa83bCalle();
		for(int i=0;i<findAll.size();i++){
			calle=findAll.get(i);
			//calle.setDs_o(Aa83bUtilidades.TildesHtml(calle.getDs_o()));
			findAll.set(i, calle);
		}
		return findAll;
	}
	@Json(mixins = { @JsonMixin(target = Aa83bCalle.class, mixin = Aa83bCalleMixIn.class) })
	@RequestMapping(value = "validarCalleCorrectaId", method = RequestMethod.GET)
	public @ResponseBody
	int validarCalleCorrectaId(
			@RequestParam(value = "desc", required = true) String desc,
			@RequestParam(value = "muni", required = true) String muni,
			@RequestParam(value = "prov", required = true) String prov) {
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			Aa83bNoraController.LOGGER.error ("[Aa83bNoraController Exception]"+e.getMessage());
		}
		Aa83bCalle filterCalle = new Aa83bCalle();
		filterCalle.setCalle_cod(desc);
		filterCalle.setProvincia_id(prov);
		filterCalle.setMunicipio_id(muni);
		List<Aa83bCalle> findAll = a83bNoraService.findCallesPorId(filterCalle, null);
		Aa83bNoraController.LOGGER.info ("[Aa83bNoraController validarCalleCorrectaId]"+desc + "---" +prov + "---" + muni + "findAll" + findAll);
		return findAll.size();
	}
	@Json(mixins = { @JsonMixin(target = Aa83bCalle.class, mixin = Aa83bCalleMixIn.class) })
	@RequestMapping(value = "validarCalleCorrectaString", method = RequestMethod.GET)
	public @ResponseBody
	int validarCalleCorrectaString(
			@RequestParam(value = "desc", required = true) String desc,
			@RequestParam(value = "muni", required = true) String muni,
			@RequestParam(value = "prov", required = true) String prov) {
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			Aa83bNoraController.LOGGER.error ("[Aa83bNoraController Exception]"+e.getMessage());
		}
		Aa83bCalle filterCalle = new Aa83bCalle();
		filterCalle.setDs_o(desc);
		filterCalle.setProvincia_id(prov);
		filterCalle.setMunicipio_id(muni);
		List<Aa83bCalle> findAll = a83bNoraService.findCalles(filterCalle, null);
		return findAll.size();
	}
	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(Exception e) {
		LOGGER.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 */
	@RequestMapping(value = "busquedaCallePorId/{codCalle}", method = RequestMethod.GET)
	public @ResponseBody()
	Aa83bCalle getCalle(@PathVariable() String codCalle,
			HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		Aa83bCalle calle = new Aa83bCalle();
		calle.setDs_e(codCalle);
		calle.setDs_o(codCalle);
		if (Aa83bUtilidades.isNumeric(codCalle))
			try {
				calle.setCalle_cod(codCalle);
				calle = a83bNoraService.findCalle(calle, null);	
			} catch (Exception e) {
				Aa83bNoraController.LOGGER.error ("[Aa83bNoraController Exception]"+e.getMessage());
			}
		return calle;
	}
	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 */
	@RequestMapping(value = "/busquedaCodigoPostal", method = RequestMethod.GET)
	public @ResponseBody()
	HashMap<String, String> getCodigoPostal(//@RequestParam(value = "tipoSolicitud", required = true) String tipoSolicitud,
			@RequestParam(value = "codCalle", required = true) String codCalle,
			@RequestParam(value = "numero", required = true) int numero,
			HttpServletRequest request,HttpServletResponse response) {
		response.setContentType("application/json; charset=UTF-8");
		HashMap<String, String> retorno = new HashMap<String, String>();
		String codigo="";
		if (Aa83bUtilidades.isNumeric(codCalle))
			try {
				codigo = a83bNoraService.findCodigoPostal(codCalle,numero);
				for(int i=codigo.length();i<5;i++){
						codigo="0"+codigo;
				}
			} catch (Exception e) {
				Aa83bNoraController.LOGGER.error ("[Aa83bNoraController Exception]"+e.getMessage());
			}
			retorno.put("codigo", codigo);
		return retorno;
	}
	/**
	 * Method 'getProvMun'. Recupera la provincia y el municipio a partir de un
	 * cod postal
	 * 
	 * @param appConfiguration
	 *            Properties
	 */
	@RequestMapping(value = "/busquedaPorCodigoPostal", method = RequestMethod.GET)
	public @ResponseBody()
	A83bLocalidad  getProvMun(
			@RequestParam(value = "codPostal", required = true) String codPostal,
			@RequestParam(value = "calleId", required = true) String calleId,
			@RequestParam(value = "numero", required = true) int numero,
			HttpServletRequest request,HttpServletResponse response) {
		return this.a83bNoraService.findProvMunLocalidadByCodPostal(codPostal, calleId, numero);
	}
}
