package com.ejie.aa83b.control;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.bind.annotation.RequestParam;


import com.ejie.aa83b.model.Aa83bBusqueda;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.reports.ReportData;

import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b23t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83b03t00Service;

@Controller
@RequestMapping(value = "/jqGridUsuario")
public class Aa83bJQGridUsuarioController {

	/** The service. */
	@Autowired()
	private Aa83b21t00Service aa83b21t00Service;

	/** The service. */
	@Autowired()
	private Aa83b23t00Service aa83b23t00Service;

	/** The service. */
	@Autowired()
	private Aa83b25t00Service aa83b25t00Service;

	/** The service. */
	@Autowired()
	private Aa83b03t00Service aa83b03t00Service;

	/**
	 * EXPORTERS
	 */
	@RequestMapping(value = "csvReport", method = RequestMethod.POST)
	protected ModelAndView getCSVReport(
			@ModelAttribute Aa83bBusqueda filterBusqueda,
			@ModelAttribute JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns) {

		// Acceso a BD para recuperar datos
		// jqGridRequestDto.setPage(null);
		// jqGridRequestDto.setRows(null);
		// List<Busqueda> filter = this.jqGridUsuarioService.findAllLike(
		// filterUsuario, jqGridRequestDto, false);

		List<Aa83bBusqueda> responseGrid = new ArrayList<Aa83bBusqueda>();

		// Nombre fichero
		modelMap.put("fileName", "datosCSV");
		// Datos
		ReportData<Aa83bBusqueda> reportData = new ReportData<Aa83bBusqueda>();
		// cabeceras hoja
		reportData.setHeaderNames(ReportData.parseColumns(columns));
		// datos hoja

		reportData.setModelData(responseGrid);
		modelMap.put("reportData", reportData);

		// Generación del CVS
		return new ModelAndView("csvReport", modelMap);
	}
}
