package com.ejie.aa83b.control;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa83b.model.AA83BCuadroMando;
import com.ejie.aa83b.model.Aa83b03t00;

import com.ejie.aa83b.model.Aa83bEstadGrid;
import com.ejie.aa83b.model.Aa83bEstadisticas;
import com.ejie.aa83b.model.Aa83bEstadisticasBusqueda;
import com.ejie.aa83b.model.Aa83bEstadisticasFechas;

import com.ejie.aa83b.service.Aa83bEstadisticasService;

import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.reports.ReportData;

/**
 * PatronesController
 * 
 * @author UDA
 */
@Controller
@RequestMapping(value = "/estadisticas")
public class Aa83bEstadisticasController {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bEstadisticasController.class);

	@RequestMapping(value = "/estadestado", method = RequestMethod.GET)
	public ModelAndView getFormEdit(Model model) {
		Aa83bEstadisticasController.logger
				.info("[GET - View] : BusquedaControler");
		AA83BCuadroMando aa83BCuadroMando = new AA83BCuadroMando();
		aa83BCuadroMando.setPapel0TotalHoy(10);
		aa83BCuadroMando.setPapel0TotalAyer(6);
		aa83BCuadroMando.setPapel0Total3Dias(2);

		// System.out.println("estadestado");

		return new ModelAndView("estadestado", "AA83BCuadroMando",
				aa83BCuadroMando);

	}

	/** The service. */
	@Autowired()
	private Aa83bEstadisticasService a83bEstadisticasService;

	private Integer totalGrid = 0;

	public List<Aa83bEstadGrid> busquedaStandard(
			Aa83bEstadisticas filterBusqueda,
			JQGridRequestDto jqGridRequestDto, Boolean excel)
			throws ParseException {
		// System.out.println("entra" + filterBusqueda.toString());

		Aa83bEstadisticasBusqueda solicitudADE = new Aa83bEstadisticasBusqueda();
		Aa83bEstadisticasBusqueda solicitudESF = new Aa83bEstadisticasBusqueda();
		Aa83bEstadisticasBusqueda solicitudARR = new Aa83bEstadisticasBusqueda();

		String tipoSol = filterBusqueda.getTipoSol();
		String fDesde = filterBusqueda.getfDesde();
		String fHasta = filterBusqueda.getfHasta();

		int conta21 = 0;
		int conta23 = 0;
		int conta25 = 0;

		List<Aa83bEstadisticasBusqueda> aa83bEstadisticasBusquedaADEList = new ArrayList<Aa83bEstadisticasBusqueda>();
		List<Aa83bEstadisticasBusqueda> aa83bEstadisticasBusquedaARRList = new ArrayList<Aa83bEstadisticasBusqueda>();
		List<Aa83bEstadisticasBusqueda> aa83bEstadisticasBusquedaESFList = new ArrayList<Aa83bEstadisticasBusqueda>();
		Aa83bEstadisticasBusqueda estadBusq = new Aa83bEstadisticasBusqueda();

		Locale locale = LocaleContextHolder.getLocale();
		SimpleDateFormat formatoDelTexto = null;
		if (locale.getLanguage() == "es") {
			formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		} else if (locale.getLanguage() == "eu") {
			formatoDelTexto = new SimpleDateFormat(Aa83BConstants.EU_PATTERN);
		}
		Date fechaD2 = new Date();
		if (fDesde != null) {
			fechaD2 = formatoDelTexto.parse(fDesde);
			estadBusq.setfDesde(fechaD2);
		}

		Date fechaH2 = new Date();
		if (fHasta != null) {
			fechaH2 = formatoDelTexto.parse(fHasta);
			estadBusq.setfHasta(fechaH2);
		}
		if (fDesde == null || fHasta == null) {
			Aa83bEstadisticasFechas e = new Aa83bEstadisticasFechas();
			List<Aa83bEstadisticasFechas> eLista = a83bEstadisticasService
					.fMinMax(e, null);

			if (eLista.size() > 0) {
				e = eLista.get(0);

				if (fDesde == null) {
					String fD = e.getMINACC().toString();
					String fechaD[] = fD.split("-");
					String fechaDesde = fechaD[2] + "/" + fechaD[1] + "/"
							+ fechaD[0];
					fechaD2 = formatoDelTexto.parse(fechaDesde);
					estadBusq.setfDesde(fechaD2);
				}

				if (fHasta == null) {
					String fH = e.getMAXACC().toString();
					String fechaH[] = fH.split("-");
					String fechaHasta = fechaH[2] + "/" + fechaH[1] + "/"
							+ fechaH[0];
					fechaH2 = formatoDelTexto.parse(fechaHasta);
					estadBusq.setfHasta(fechaH2);
				}

			}

		}
		// TRAZA
		Aa83bEstadisticasController.logger.error("Patri"
				+ estadBusq.getfDesde());

		if (tipoSol.equals("0")) {
			aa83bEstadisticasBusquedaADEList = this.a83bEstadisticasService
					.estadBusquedaADE(estadBusq, null, false);
			aa83bEstadisticasBusquedaARRList = this.a83bEstadisticasService
					.estadBusquedaARR(estadBusq, null, false);
			aa83bEstadisticasBusquedaESFList = this.a83bEstadisticasService
					.estadBusquedaESF(estadBusq, null, false);

			conta21 = aa83bEstadisticasBusquedaADEList.size();
			conta23 = aa83bEstadisticasBusquedaESFList.size();
			conta25 = aa83bEstadisticasBusquedaARRList.size();

		}
		if (tipoSol.equals(Aa83BConstants.COD_ADE)) {

			aa83bEstadisticasBusquedaADEList = this.a83bEstadisticasService
					.estadBusquedaADE(estadBusq, null, false);
			conta21 = aa83bEstadisticasBusquedaADEList.size();
		}
		if (tipoSol.equals(Aa83BConstants.COD_ESF)) {
			aa83bEstadisticasBusquedaESFList = this.a83bEstadisticasService
					.estadBusquedaESF(estadBusq, null, false);
			conta23 = aa83bEstadisticasBusquedaESFList.size();
		}
		if (tipoSol.equals(Aa83BConstants.COD_ARR)) {

			aa83bEstadisticasBusquedaARRList = this.a83bEstadisticasService
					.estadBusquedaARR(estadBusq, null, false);
			conta25 = aa83bEstadisticasBusquedaARRList.size();
		}

		List<Aa83bEstadisticas> response = new ArrayList<Aa83bEstadisticas>();
		List<Aa83bEstadGrid> responseGrid = new ArrayList<Aa83bEstadGrid>();
		List<Aa83bEstadGrid> responseGridPaginado = new ArrayList<Aa83bEstadGrid>();
		int i = 0;
		Aa83bEstadisticas resultB = new Aa83bEstadisticas();

		resultB.setTipoSol(tipoSol);
		resultB.setfDesde(fDesde);
		resultB.setfHasta(fHasta);

		Aa83b03t00 aa83b03t00 = new Aa83b03t00();
		for (i = 0; i < conta21; i++) {
			solicitudADE = aa83bEstadisticasBusquedaADEList.get(i);
			Aa83bEstadGrid estadMin = new Aa83bEstadGrid();
			estadMin.setId_solicitud(solicitudADE.getId());
			estadMin.setAnyo(solicitudADE.getAnyo());
			aa83b03t00.setId003(Integer.parseInt(tipoSol));
			estadMin.setMes(solicitudADE.getMes());
			estadMin.setGeneroStrEs(solicitudADE.getDesc_es());
			estadMin.setGeneroStrEu(solicitudADE.getDesc_eu());
			estadMin.setFecha(solicitudADE.getF_actu());
			estadMin.setProvinciaStrEs(solicitudADE.getDs_c());
			estadMin.setProvinciaStrEu(solicitudADE.getDs_e());
			estadMin.setNacionalidadStrEs(solicitudADE.getDs_c_nacionalidad());
			estadMin.setNacionalidadStrEu(solicitudADE.getDs_e_nacionalidad());
			estadMin.setTipoSolicitud_STR(solicitudADE.getTipo_Sol());
			estadMin.setSolConcat(solicitudADE.getTipo_Sol() + " "
					+ solicitudADE.getAnyo() + " " + solicitudADE.getId());

			int m = solicitudADE.getMes();

			if (m == 12) {
				m = 0;
			}

			estadMin.setNombreMesES(Aa83BConstants.mesesCastellano[m]
					.toString());

			responseGrid.add(estadMin);
			resultB.setEstadGrid(responseGrid);
			response.add(resultB);

		}
		for (i = 0; i < conta23; i++) {
			solicitudESF = aa83bEstadisticasBusquedaESFList.get(i);
			Aa83bEstadGrid estadMin = new Aa83bEstadGrid();
			estadMin.setId_solicitud(solicitudESF.getId());
			estadMin.setAnyo(solicitudESF.getAnyo());
			aa83b03t00.setId003(Integer.parseInt(tipoSol));
			estadMin.setMes(solicitudESF.getMes());
			estadMin.setGeneroStrEs(solicitudESF.getDesc_es());
			estadMin.setGeneroStrEu(solicitudESF.getDesc_eu());
			estadMin.setFecha(solicitudESF.getF_actu());
			estadMin.setNacionalidadStrEs(solicitudESF.getDs_c_nacionalidad());
			estadMin.setNacionalidadStrEu(solicitudESF.getDs_e_nacionalidad());
			estadMin.setProvinciaStrEs(solicitudESF.getDs_c());
			estadMin.setProvinciaStrEu(solicitudESF.getDs_e());
			estadMin.setTipoSolicitud_STR(solicitudESF.getTipo_Sol());
			estadMin.setSolConcat(solicitudESF.getTipo_Sol() + " "
					+ solicitudESF.getAnyo() + " " + solicitudESF.getId());

			int m = solicitudESF.getMes();

			if (m == 12) {
				m = 0;
			}

			estadMin.setNombreMesES(Aa83BConstants.mesesCastellano[m]
					.toString());

			responseGrid.add(estadMin);
			resultB.setEstadGrid(responseGrid);
			response.add(resultB);

		}
		for (i = 0; i < conta25; i++) {
			solicitudARR = aa83bEstadisticasBusquedaARRList.get(i);
			Aa83bEstadGrid estadMin = new Aa83bEstadGrid();
			estadMin.setId_solicitud(solicitudARR.getId());
			estadMin.setAnyo(solicitudARR.getAnyo());
			aa83b03t00.setId003(Integer.parseInt(tipoSol));
			estadMin.setMes(solicitudARR.getMes());
			estadMin.setGeneroStrEs(solicitudARR.getDesc_es());
			estadMin.setGeneroStrEu(solicitudARR.getDesc_eu());
			estadMin.setFecha(solicitudARR.getF_actu());
			estadMin.setNacionalidadStrEs(solicitudARR.getDs_c_nacionalidad());
			estadMin.setNacionalidadStrEu(solicitudARR.getDs_e_nacionalidad());
			estadMin.setProvinciaStrEs(solicitudARR.getDs_c());
			estadMin.setProvinciaStrEu(solicitudARR.getDs_e());
			estadMin.setTipoSolicitud_STR(solicitudARR.getTipo_Sol());
			estadMin.setSolConcat(solicitudARR.getTipo_Sol() + " "
					+ solicitudARR.getAnyo() + " " + solicitudARR.getId());

			int m = solicitudARR.getMes();

			if (m == 12) {
				m = 0;
			}

			estadMin.setNombreMesES(Aa83BConstants.mesesCastellano[m]
					.toString());

			responseGrid.add(estadMin);
			resultB.setEstadGrid(responseGrid);
			response.add(resultB);

		}

		// Paginamos:

		this.totalGrid = responseGrid.size();
		if (!excel) {
			if (jqGridRequestDto.getPage() != 1) {
				// Paginamos
				int p = (int) ((jqGridRequestDto.getPage() - 1) * jqGridRequestDto
						.getRows());

				for (int pag = p; (pag < responseGrid.size()); pag++) {
					responseGridPaginado.add(responseGrid.get(pag));
				}

				// Miro si es la ultima página:
				if ((responseGrid.size() - (jqGridRequestDto.getPage() * jqGridRequestDto
						.getRows())) <= 0) {

				} else {
					if (jqGridRequestDto.getPage() != 1) {
						for (int pant = 0; pant < p; pant++)
							responseGridPaginado.add(responseGrid.get(pant));
					}
				}

			} else {
				responseGridPaginado = responseGrid;
			}
		} else {
			responseGridPaginado = responseGrid;
		}

		return responseGridPaginado;

	}

	@RequestMapping(value = "/buscarEstado", method = RequestMethod.POST)
	public ModelAndView getFormEdit2(
			@RequestParam(value = "tipoSol", required = false) String tipoSol,
			@RequestParam(value = "fDesde", required = false) String fDesde,
			@RequestParam(value = "fHasta", required = false) String fHasta) {
		Aa83bEstadisticas filterBusqueda = new Aa83bEstadisticas();
		filterBusqueda.setTipoSol(tipoSol);
		filterBusqueda.setfDesde(fDesde);
		filterBusqueda.setfHasta(fHasta);

		Aa83bEstadisticas responseGrid = new Aa83bEstadisticas();

		return new ModelAndView("estadestado", "Estadisticas", responseGrid);

	}

	@RequestMapping(value = "/buscarEstado/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83bEstadGrid> cargaTabla(
			@RequestJsonBody(param = "filter") Aa83bEstadisticas filterBusqueda,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto

	) throws ParseException {

		// System.out.println("entra cargaTabla");

		List<Aa83bEstadGrid> responseGrid = new ArrayList<Aa83bEstadGrid>();
		responseGrid = this.busquedaStandard(filterBusqueda, jqGridRequestDto,
				false);

		return new JQGridResponseDto<Aa83bEstadGrid>(jqGridRequestDto,
				(long) this.totalGrid, responseGrid);

	}

	// INFORME TERRITORIOS
	@RequestMapping(value = "/estadTerritorio", method = RequestMethod.GET)
	public ModelAndView getEstadTerritorios(Model model) {
		// System.out.println("estadTerritorios");
		Aa83bEstadisticasController.logger
				.info("[GET - View] : BusquedaControler");
		/*
		 * AA83BCuadroMando aa83BCuadroMando = new AA83BCuadroMando();
		 * aa83BCuadroMando.setPapel0TotalHoy(10);
		 * aa83BCuadroMando.setPapel0TotalAyer(6);
		 * aa83BCuadroMando.setPapel0Total3Dias(2);
		 */
		return new ModelAndView("estadTerritorios");
	}

	@RequestMapping(value = "/buscarTerritorio", method = RequestMethod.POST)
	public ModelAndView getEstadTerritorios2(
			@RequestParam(value = "tipoSol", required = false) String tipoSol,
			@RequestParam(value = "fDesde", required = false) String fDesde,
			@RequestParam(value = "fHasta", required = false) String fHasta) {
		Aa83bEstadisticas filterBusqueda = new Aa83bEstadisticas();
		filterBusqueda.setTipoSol(tipoSol);
		filterBusqueda.setfDesde(fDesde);
		filterBusqueda.setfHasta(fHasta);
		Aa83bEstadisticas responseGrid = new Aa83bEstadisticas();
		return new ModelAndView("estadTerritorios", "Estadisticas",
				responseGrid);
	}

	@RequestMapping(value = "/buscarTerritorio/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83bEstadGrid> cargaTablaTerritorios(
			@RequestJsonBody(param = "filter") Aa83bEstadisticas filterBusqueda,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto)
			throws ParseException {
		List<Aa83bEstadGrid> responseGrid = new ArrayList<Aa83bEstadGrid>();
		responseGrid = this.busquedaStandard(filterBusqueda, jqGridRequestDto,
				false);
		return new JQGridResponseDto<Aa83bEstadGrid>(jqGridRequestDto,
				(long) this.totalGrid, responseGrid);
	}

	/**
	 * EXPORTERS
	 * 
	 * @throws ParseException
	 */
	@RequestMapping(value = "estcsvReport", method = RequestMethod.POST)
	protected ModelAndView getCSVReport(
			@ModelAttribute Aa83bEstadisticas filterBusqueda,
			@ModelAttribute JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns)
			throws ParseException {

		// Acceso a BD para recuperar datos
		// jqGridRequestDto.setPage(null);
		// jqGridRequestDto.setRows(null);
		// List<Busqueda> filter = this.jqGridUsuarioService.findAllLike(
		// filterUsuario, jqGridRequestDto, false);

		List<Aa83bEstadGrid> responseGrid = new ArrayList<Aa83bEstadGrid>();

		responseGrid = this.busquedaStandard(filterBusqueda, jqGridRequestDto,
				true);

		// Nombre fichero
		modelMap.put("fileName", "datosCSV");
		// Datos
		ReportData<Aa83bEstadGrid> reportData = new ReportData<Aa83bEstadGrid>();
		// cabeceras hoja
		reportData.setHeaderNames(ReportData.parseColumns(columns));
		// datos hoja

		reportData.setModelData(responseGrid);
		modelMap.put("reportData", reportData);

		// Generación del CVS
		return new ModelAndView("csvReport", modelMap);
	}

	@RequestMapping(value = { "estxlsReport", "estxlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getExcelPOI(
			@ModelAttribute Aa83bEstadisticas filterBusqueda,
			@ModelAttribute JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) throws ParseException {

		List<Aa83bEstadGrid> responseGrid = new ArrayList<Aa83bEstadGrid>();

		responseGrid = this.busquedaStandard(filterBusqueda, jqGridRequestDto,
				true);

		// Nombre fichero
		modelMap.put("fileName", "datosExcel");

		// Datos
		List<Object> reportData = new ArrayList<Object>();
		// Hoja 1
		ReportData<Aa83bEstadGrid> usuarioExcelDataAll = new ReportData<Aa83bEstadGrid>();
		// nombre hoja
		usuarioExcelDataAll.setSheetName("Todos los datos");
		// cabeceras hoja
		usuarioExcelDataAll.setHeaderNames(ReportData.parseColumns(columns));
		// datos hoja
		usuarioExcelDataAll.setModelData(responseGrid);
		reportData.add(usuarioExcelDataAll);
		// Hoja 2
		ReportData<Aa83bEstadGrid> usuarioExcelDataPage = new ReportData<Aa83bEstadGrid>();
		// nombre hoja
		usuarioExcelDataPage.setSheetName("Datos");
		// cabeceras hoja
		usuarioExcelDataPage.setHeaderNames(ReportData.parseColumns(columns));
		// datos hoja
		usuarioExcelDataPage.setModelData(responseGrid);
		reportData.add(usuarioExcelDataPage);
		modelMap.put("reportData", reportData);

		// Generación del XLS o XLSX
		// String reportView = request.getServletPath().substring(9);
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
		// return new ModelAndView(reportView, modelMap);

	}

}
