package com.ejie.aa83b.control;

import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;

import org.apache.poi.ss.usermodel.DataFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejie.aa83b.model.Aa83b03t00;

import com.ejie.aa83b.model.Aa83bContadorGraficos;
import com.ejie.aa83b.model.Aa83bContadorNacionalidad;
import com.ejie.aa83b.model.Aa83bEstadGrid;
import com.ejie.aa83b.model.Aa83bEstadisticas;
import com.ejie.aa83b.model.Aa83bEstadisticasBusqueda;
import com.ejie.aa83b.model.Aa83bEstadisticasFechas;

import com.ejie.aa83b.service.Aa83bEstadisticasService;
import com.ejie.aa83b.service.Aa83b03t00Service;

import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83BUtilidadesExcel;
import com.ejie.x38.dto.JQGridRequestDto;
import java.util.Properties;

/**
 * PatronesController
 * 
 * @author UDA
 */
@Controller
@RequestMapping(value = "/estadexcel")
public class Aa83bEstadExcelController {

	/** The service. */
	@Autowired()
	private Aa83bEstadisticasService a83bEstadisticasService;
	/** The service. */
	@Autowired()
	private Aa83b03t00Service aa83b03t00Service;

	@Autowired
	private Properties appConfiguration;

	private Integer totalGrid = 0;
	@Autowired
	private Properties langEsProperties;

	public List<Aa83bEstadGrid> busquedaStandard(
			Aa83bEstadisticas filterBusqueda,
			JQGridRequestDto jqGridRequestDto, Boolean excel)
			throws ParseException {

		Aa83bEstadisticasBusqueda solicitudADE = new Aa83bEstadisticasBusqueda();
		Aa83bEstadisticasBusqueda solicitudESF = new Aa83bEstadisticasBusqueda();
		Aa83bEstadisticasBusqueda solicitudARR = new Aa83bEstadisticasBusqueda();

		String tipoSol = filterBusqueda.getTipoSol();
		String fDesde = filterBusqueda.getfDesde();
		String fHasta = filterBusqueda.getfHasta();

		int conta21 = 0;
		int conta23 = 0;
		int conta25 = 0;

		List<Aa83bEstadisticasBusqueda> aa83bEstadisticasBusquedaADEList = new ArrayList<Aa83bEstadisticasBusqueda>();
		List<Aa83bEstadisticasBusqueda> aa83bEstadisticasBusquedaARRList = new ArrayList<Aa83bEstadisticasBusqueda>();
		List<Aa83bEstadisticasBusqueda> aa83bEstadisticasBusquedaESFList = new ArrayList<Aa83bEstadisticasBusqueda>();
		Aa83bEstadisticasBusqueda estadBusq = new Aa83bEstadisticasBusqueda();
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		Date fechaD2 = new Date();
		if (fDesde != null) {
			fechaD2 = formatoDelTexto.parse(fDesde);
			estadBusq.setfDesde(fechaD2);
		} else {
			fDesde = null;
		}

		Date fechaH2 = new Date();
		if (fHasta != null) {
			fechaH2 = formatoDelTexto.parse(fHasta);
			estadBusq.setfHasta(fechaH2);
		} else {
			fHasta = null;
		}

		if (tipoSol.equals("0")) {

			aa83bEstadisticasBusquedaADEList = this.a83bEstadisticasService
					.estadBusquedaADE(estadBusq, null, false);
			aa83bEstadisticasBusquedaARRList = this.a83bEstadisticasService
					.estadBusquedaARR(estadBusq, null, false);
			aa83bEstadisticasBusquedaESFList = this.a83bEstadisticasService
					.estadBusquedaESF(estadBusq, null, false);

			conta21 = aa83bEstadisticasBusquedaADEList.size();
			conta23 = aa83bEstadisticasBusquedaESFList.size();
			conta25 = aa83bEstadisticasBusquedaARRList.size();

		}

		if (tipoSol.equals(Aa83BConstants.COD_ADE)) {
			aa83bEstadisticasBusquedaADEList = this.a83bEstadisticasService
					.estadBusquedaADE(estadBusq, null, false);
			conta21 = aa83bEstadisticasBusquedaADEList.size();
		}
		if (tipoSol.equals(Aa83BConstants.COD_ESF)) {
			aa83bEstadisticasBusquedaESFList = this.a83bEstadisticasService
					.estadBusquedaESF(estadBusq, null, false);
			conta23 = aa83bEstadisticasBusquedaESFList.size();
		}
		if (tipoSol.equals(Aa83BConstants.COD_ARR)) {

			aa83bEstadisticasBusquedaARRList = this.a83bEstadisticasService
					.estadBusquedaARR(estadBusq, null, false);
			conta25 = aa83bEstadisticasBusquedaARRList.size();
		}

		List<Aa83bEstadisticas> response = new ArrayList<Aa83bEstadisticas>();
		List<Aa83bEstadGrid> responseGrid = new ArrayList<Aa83bEstadGrid>();
		List<Aa83bEstadGrid> responseGridPaginado = new ArrayList<Aa83bEstadGrid>();
		int i = 0;
		Aa83bEstadisticas resultB = new Aa83bEstadisticas();

		resultB.setTipoSol(tipoSol);
		resultB.setfDesde(fDesde);
		resultB.setfHasta(fHasta);

		Aa83b03t00 aa83b03t00 = new Aa83b03t00();

		for (i = 0; i < conta21; i++) {
			solicitudADE = aa83bEstadisticasBusquedaADEList.get(i);
			Aa83bEstadGrid estadMin = new Aa83bEstadGrid();
			estadMin.setId_solicitud(solicitudADE.getId());
			estadMin.setAnyo(solicitudADE.getAnyo());
			aa83b03t00.setId003(Integer.parseInt(tipoSol));
			estadMin.setMes(solicitudADE.getMes());
			estadMin.setGeneroStrEs(solicitudADE.getDesc_es());
			estadMin.setGeneroStrEu(solicitudADE.getDesc_eu());
			estadMin.setFecha(solicitudADE.getF_actu());
			estadMin.setProvinciaStrEs(solicitudADE.getDs_c());
			estadMin.setProvinciaStrEu(solicitudADE.getDs_e());
			estadMin.setNacionalidadStrEs(solicitudADE.getDs_c_nacionalidad());
			estadMin.setNacionalidadStrEu(solicitudADE.getDs_e_nacionalidad());
			estadMin.setTipoSolicitud_STR(solicitudADE.getTipo_Sol());
			estadMin.setSolConcat(solicitudADE.getTipo_Sol() + " "
					+ solicitudADE.getAnyo() + " " + solicitudADE.getId());

			int m = solicitudADE.getMes();

			if (m == 12) {
				m = 0;
			}

			estadMin.setNombreMesES(Aa83BConstants.mesesCastellano[m]
					.toString());

			responseGrid.add(estadMin);
			resultB.setEstadGrid(responseGrid);
			response.add(resultB);
		}
		for (i = 0; i < conta23; i++) {
			solicitudESF = aa83bEstadisticasBusquedaESFList.get(i);
			Aa83bEstadGrid estadMin = new Aa83bEstadGrid();
			estadMin.setId_solicitud(solicitudESF.getId());
			estadMin.setAnyo(solicitudESF.getAnyo());
			aa83b03t00.setId003(Integer.parseInt(tipoSol));
			estadMin.setMes(solicitudESF.getMes());
			estadMin.setGeneroStrEs(solicitudESF.getDesc_es());
			estadMin.setGeneroStrEu(solicitudESF.getDesc_eu());
			estadMin.setFecha(solicitudESF.getF_actu());
			estadMin.setNacionalidadStrEs(solicitudESF.getDs_c_nacionalidad());
			estadMin.setNacionalidadStrEu(solicitudESF.getDs_e_nacionalidad());
			estadMin.setProvinciaStrEs(solicitudESF.getDs_c());
			estadMin.setProvinciaStrEu(solicitudESF.getDs_e());
			estadMin.setTipoSolicitud_STR(solicitudESF.getTipo_Sol());
			estadMin.setSolConcat(solicitudESF.getTipo_Sol() + " "
					+ solicitudESF.getAnyo() + " " + solicitudESF.getId());

			int m = solicitudESF.getMes();

			if (m == 12) {
				m = 0;
			}

			estadMin.setNombreMesES(Aa83BConstants.mesesCastellano[m]
					.toString());

			responseGrid.add(estadMin);
			resultB.setEstadGrid(responseGrid);
			response.add(resultB);

		}
		for (i = 0; i < conta25; i++) {
			solicitudARR = aa83bEstadisticasBusquedaARRList.get(i);
			Aa83bEstadGrid estadMin = new Aa83bEstadGrid();
			estadMin.setId_solicitud(solicitudARR.getId());
			estadMin.setAnyo(solicitudARR.getAnyo());
			aa83b03t00.setId003(Integer.parseInt(tipoSol));
			estadMin.setMes(solicitudARR.getMes());
			estadMin.setGeneroStrEs(solicitudARR.getDesc_es());
			estadMin.setGeneroStrEu(solicitudARR.getDesc_eu());
			estadMin.setFecha(solicitudARR.getF_actu());
			estadMin.setNacionalidadStrEs(solicitudARR.getDs_c_nacionalidad());
			estadMin.setNacionalidadStrEu(solicitudARR.getDs_e_nacionalidad());
			estadMin.setProvinciaStrEs(solicitudARR.getDs_c());
			estadMin.setProvinciaStrEu(solicitudARR.getDs_e());
			estadMin.setTipoSolicitud_STR(solicitudARR.getTipo_Sol());
			estadMin.setSolConcat(solicitudARR.getTipo_Sol() + " "
					+ solicitudARR.getAnyo() + " " + solicitudARR.getId());

			int m = solicitudARR.getMes();

			if (m == 12) {
				m = 0;
			}

			estadMin.setNombreMesES(Aa83BConstants.mesesCastellano[m]
					.toString());

			responseGrid.add(estadMin);
			resultB.setEstadGrid(responseGrid);
			response.add(resultB);

		}

		// Paginamos:

		this.totalGrid = responseGrid.size();
		if (totalGrid == 0) {
			if (!excel) {
				if (jqGridRequestDto.getPage() != 1) {
					// Paginamos
					int p = (int) ((jqGridRequestDto.getPage() - 1) * jqGridRequestDto
							.getRows());

					for (int pag = p; (pag < responseGrid.size()); pag++) {
						responseGridPaginado.add(responseGrid.get(pag));
					}

					// Miro si es la ultima página:
					if ((responseGrid.size() - (jqGridRequestDto.getPage() * jqGridRequestDto
							.getRows())) <= 0) {

					} else {
						if (jqGridRequestDto.getPage() != 1) {
							for (int pant = 0; pant < p; pant++)
								responseGridPaginado
										.add(responseGrid.get(pant));
						}
					}

				} else {
					responseGridPaginado = responseGrid;
				}
			} else {
				responseGridPaginado = responseGrid;
			}

			return responseGridPaginado;
		}
		return responseGrid;

	}

	@RequestMapping(value = "/nacionalidad", method = RequestMethod.POST)
	protected void processForward(
			Aa83bEstadisticas contexto,
			@RequestParam(value = "tipoSol2", required = false) String tipoSol2,
			@RequestParam(value = "fDesde2", required = false) String fDesde2,
			@RequestParam(value = "fHasta2", required = false) String fHasta2,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		Aa83bEstadisticas filterBusqueda = new Aa83bEstadisticas();
		if (fDesde2.isEmpty())
			fDesde2 = null;

		if (fHasta2.isEmpty())
			fHasta2 = null;

		filterBusqueda.setTipoSol(tipoSol2);
		filterBusqueda.setfDesde(fDesde2);
		filterBusqueda.setfHasta(fHasta2);

		String strRutaExcel = this.appConfiguration
				.getProperty("tempPlantillasEstad.path")
				+ "PlantillaNacionalidad.xls";

		InputStream inputStream = new FileInputStream(strRutaExcel);

		HSSFWorkbook wb = new HSSFWorkbook(inputStream);// Creacion del libro de
														// trabajo
		wb.setSheetName(0, "Hoja1"); // Creaci�n de la hoja
		HSSFFont hSSFFont = wb.createFont();
		hSSFFont.setFontHeightInPoints((short) 6);
		HSSFSheet sheet = wb.getSheetAt(0); // Creaci�n de la hoja
		CellStyle cellStyle2 = wb.createCellStyle();
		cellStyle2.setWrapText(true);
		cellStyle2.setFont(hSSFFont);

		// Escribir departamento
		HSSFRow rowDep = sheet.getRow((short) 4);

		HSSFCell cellDep = rowDep.createCell(6);
		cellDep.setCellValue(this.langEsProperties.getProperty("DEPT_ES_1")
				+ "\n " + this.langEsProperties.getProperty("DEPT_ES_2")
				+ "\n " + this.langEsProperties.getProperty("DEPT_ES_3")
				+ "\n " + this.langEsProperties.getProperty("DEPT_ES_4")
				+ "\n " + this.langEsProperties.getProperty("DEPT_ES_5"));
		rowDep.getCell(6).setCellStyle(cellStyle2);
		HSSFCell cellDep2 = rowDep.createCell(9);
		cellDep2.setCellValue(this.langEsProperties.getProperty("DEPT_EU_1")
				+ "\n " + this.langEsProperties.getProperty("DEPT_EU_2")
				+ "\n " + this.langEsProperties.getProperty("DEPT_EU_3")
				+ "\n " + this.langEsProperties.getProperty("DEPT_EU_4")
				+ "\n " + this.langEsProperties.getProperty("DEPT_EU_5"));
		rowDep.getCell(9).setCellStyle(cellStyle2);

		// Colocar tipo de solicitud y fechas
		HSSFRow row = sheet.getRow((short) 11);// obtener fila
		Aa83b03t00 aa83b03t00 = new Aa83b03t00();
		
		if (fDesde2 == null || fHasta2 == null) {

			DateFormat fechaDesde2 = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
			Aa83bEstadisticasFechas e = new Aa83bEstadisticasFechas();
			List<Aa83bEstadisticasFechas> eLista = a83bEstadisticasService
					.fMinMax(e, null);

			if (eLista.size() > 0) {
				e = eLista.get(0);
				if (fDesde2 == null)
					fDesde2 = fechaDesde2.format(e.getMINACC());
				if (fHasta2 == null)
					fHasta2 = fechaDesde2.format(e.getMAXACC());

			}

		}

		aa83b03t00.setId003(Integer.parseInt(tipoSol2));
		List<Aa83b03t00> aa83b03t00Lista = aa83b03t00Service.findAllLike(
				aa83b03t00, null, false);
		if (aa83b03t00Lista.size() > 0) {
			aa83b03t00 = aa83b03t00Lista.get(0);
			row.getCell(3).setCellValue(aa83b03t00.getDescEs003());

		}
		row.getCell(8).setCellValue(fDesde2);

		row.createCell(14).setCellValue(fHasta2);
		CellStyle cellStyle3 = wb.createCellStyle();
		cellStyle3.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		cellStyle3.setBorderTop(HSSFCellStyle.BORDER_THIN);
		cellStyle3.setBorderRight(HSSFCellStyle.BORDER_THIN);
		row.getCell(13).setCellStyle(cellStyle3);

		String fechaD[] = fDesde2.split("/");
		String fechaH[] = fHasta2.split("/");

		int contMaxFilas[] = new int[3];
		int cont = 1;// contador para columna;
		int cont2 = 0;// contador para introducir datos en el array
		int contFilas = 0;// cuenta las filas que ocupa cada mes
		int numMax = 0;
		float porcentaje = 0;

		int celdaMes = 1;
		int celdaNacionalidad = 1;
		int celdaTotal = 2;
		int celdaPorcentaje = 3;

		int numFilaNacionalidad2 = 17;
		int numFilaNacionalidad3 = 17;
		int mesIni = Integer.parseInt(fechaD[1]);
		int mesFin = Integer.parseInt(fechaH[1]);
		int anyoIni = Integer.parseInt(fechaD[2]);
		int anyoAct = anyoIni;
		int anyoFin = Integer.parseInt(fechaH[2]);
		int m2 = 0;
		int contHoja = 0;
		float suma = 0;

		CellStyle cellStyle = wb.createCellStyle();
		cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
		cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);

		// cellStyle.setBottomBorderColor((short) 8);
		cellStyle.setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index);
		cellStyle.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		cellStyle.setWrapText(true);
		CellStyle style = wb.createCellStyle();// Estilo para la celda
												// porcentaje (2 decimales)
		DataFormat format = wb.createDataFormat();
		style.setDataFormat(format.getFormat("0.00"));

		HSSFFont hSSFFont2 = wb.createFont();
		hSSFFont2.setFontHeightInPoints((short) 10);
		hSSFFont2.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		CellStyle cellStyleMes = wb.createCellStyle();
		cellStyleMes.setBorderRight(HSSFCellStyle.BORDER_THIN);
		cellStyleMes.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		cellStyleMes.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		cellStyleMes.setBorderTop(HSSFCellStyle.BORDER_THIN);
		cellStyleMes.setFont(hSSFFont2);

		HSSFFont hSSFFont3 = wb.createFont();
		hSSFFont2.setFontHeightInPoints((short) 10);
		CellStyle cellStyleNac = wb.createCellStyle();
		cellStyleNac.setFont(hSSFFont3);

		CellStyle cellStyleAnyo = wb.createCellStyle();
		cellStyleAnyo.setFont(hSSFFont3);
		cellStyleAnyo.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
		while (anyoAct < anyoFin) {
			wb.cloneSheet(0);
			anyoAct++;
		}
		anyoAct = anyoIni;
		while (anyoAct <= anyoFin) {
			if (anyoAct != anyoFin) {
				mesFin = Aa83BConstants.mesesCastellano.length;
			} else {
				mesFin = Integer.parseInt(fechaH[1]);
			}
			wb.setSheetName(contHoja, String.valueOf(anyoAct)); // Creacin de
			sheet = wb.getSheetAt(contHoja); // Creacin de la hoja

			HSSFRow rowF = sheet.getRow((short) 13);
			rowF.getCell(2).setCellValue(anyoAct);

			for (int m = mesIni; m <= mesFin; m++) {
				if (numFilaNacionalidad3 % 53 == 0) {// Salto de hoja
					numFilaNacionalidad3 = numFilaNacionalidad3 + 10;
				}

				if (m == 12) {
					m2 = 0;// Diciembre
				} else {
					m2 = m;
				}

				// Escribir nacionalidad y total
				Aa83bContadorNacionalidad c = new Aa83bContadorNacionalidad();

				SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
				Date fechaD2 = new Date();
				if (fDesde2 != null) {
					fechaD2 = formatoDelTexto.parse(fDesde2);
					c.setfDesde(fechaD2);
				}

				Date fechaH2 = new Date();
				if (fHasta2 != null) {
					fechaH2 = formatoDelTexto.parse(fHasta2);
					c.setfHasta(fechaH2);
				}

				List<Aa83bContadorNacionalidad> c2 = new ArrayList<Aa83bContadorNacionalidad>();
				if (Integer.parseInt(tipoSol2) == 3) {
					c2 = a83bEstadisticasService.contarADE(c, jqGridRequestDto, false);
				} else if (Integer.parseInt(tipoSol2) == 1) {
					c2 = a83bEstadisticasService.contarPorArraigo(c, jqGridRequestDto, false);
				} else if (Integer.parseInt(tipoSol2) == 2) {
					c2 = a83bEstadisticasService.contarPorIntegracion(c, jqGridRequestDto, false);
				} else if (Integer.parseInt(tipoSol2) == 0) {
					c2 = a83bEstadisticasService.contarTodas(c, jqGridRequestDto, false);
				}

				if (cont <= 3) {
					HSSFRow rowMes = sheet.getRow((short) 15);
					rowMes.createCell(celdaMes).setCellValue(Aa83BConstants.mesesCastellano[m2]);
					rowMes.getCell(celdaMes).setCellStyle(cellStyleMes);
					for (int i = 0; i < c2.size(); i++) {
						if (c2.get(i).getANYO() == anyoAct) {
							if (c2.get(i).getMES() == m) {
								suma = suma + c2.get(i).getTOTAL();
							}
						}
					}
					for (int i = 0; i < c2.size(); i++) {
						if (c2.get(i).getMES() == 12) {
							c2.get(i).setMES(0);
						}

						if (c2.get(i).getANYO() == anyoAct) {
							if (c2.get(i).getMES() == m) {
								HSSFRow rowNac = sheet.getRow(numFilaNacionalidad2);
								if (rowNac == null) {
									rowNac = sheet.createRow(numFilaNacionalidad2);
								}

								HSSFCell cell = rowNac.createCell(celdaNacionalidad);
								rowNac.getCell(celdaNacionalidad).setCellStyle(cellStyleNac);
								cell.setCellValue(c2.get(i).getDS_C());
								HSSFCell cell2 = rowNac.createCell(celdaTotal);
								rowNac.getCell(celdaTotal).setCellStyle(cellStyleNac);
								cell2.setCellValue(c2.get(i).getTOTAL());
								// Calcular porcentaje
								HSSFCell cell3 = rowNac.createCell(celdaPorcentaje);
								if (c2.get(i).getTOTAL() == 0) {
									porcentaje = 0;
								} else {
									porcentaje = (c2.get(i).getTOTAL() * 100) / suma;
								}
								cell3.setCellValue(porcentaje);
								rowNac.getCell(celdaPorcentaje).setCellStyle(style);
								numFilaNacionalidad2++;
								contFilas++;
							}
						}
					}
					if (cont == 2) {
						celdaTotal = 8;
						celdaPorcentaje = 9;
					}
				} else if (cont >= 4) {
					suma = 0;

					// Obtenermos el mximo para desplazar
					for (int j = 0; j < contMaxFilas.length; j++) {
						if (numMax <= contMaxFilas[j]) {
							numMax = contMaxFilas[j];
						}
					}

					if (cont == 4) {
						numFilaNacionalidad3 = numFilaNacionalidad3 + numMax + 4;
						celdaTotal = 2;
						celdaPorcentaje = 3;
					}
					if (cont2 == 0)
						for (int j = 0; j < contMaxFilas.length; j++) {
							contMaxFilas[j] = 0;
							numMax = 0;
						}
					if (numFilaNacionalidad3 % 53 == 0) {// Salto de hoja
						numFilaNacionalidad3 = numFilaNacionalidad3 + 2;
					}
					for (int i = 0; i < c2.size(); i++) {
						if (c2.get(i).getANYO() == anyoAct) {
							if (c2.get(i).getMES() == m) {
								suma = suma + c2.get(i).getTOTAL();
							}
						}
					}
					HSSFRow rowMes = sheet.getRow(numFilaNacionalidad3);
					int s = numFilaNacionalidad3 + 1;
					if (rowMes == null) {
						rowMes = sheet.createRow(numFilaNacionalidad3);
					}
					rowMes.createCell(celdaMes).setCellValue(
							Aa83BConstants.mesesCastellano[m2]);
					rowMes.getCell(celdaMes).setCellStyle(cellStyleMes);
					HSSFRow rowCabecera = sheet.getRow(s);
					if (rowCabecera == null) {
						rowCabecera = sheet.createRow(s);
					}

					rowCabecera.createCell(celdaMes).setCellValue(
							this.langEsProperties.getProperty("nac"));
					rowCabecera.getCell(celdaMes).setCellStyle(cellStyle);// aplicar
																			// estilo

					rowCabecera.createCell(celdaMes + 1).setCellValue(
							this.langEsProperties.getProperty("tot"));
					rowCabecera.getCell(celdaMes + 1).setCellStyle(cellStyle);
					rowCabecera.createCell(celdaMes + 2).setCellValue(
							this.langEsProperties.getProperty("porcentaje"));
					rowCabecera.getCell(celdaMes + 2).setCellStyle(cellStyle);

					for (int i = 0; i < c2.size(); i++) {
//						if (c2.get(i).getMES() == 12) {
//							c2.get(i).setMES(0);
//						}
						if (c2.get(i).getANYO() == anyoAct) {
							if (c2.get(i).getMES() == m) {

								HSSFRow rowNac = sheet.getRow(s + 1);
								if (rowNac == null) {
									rowNac = sheet.createRow(s + 1);
								}
								HSSFCell cell = rowNac.createCell(celdaNacionalidad);
								rowNac.getCell(celdaNacionalidad).setCellStyle(cellStyleNac);
								cell.setCellValue(c2.get(i).getDS_C());
								HSSFCell cell2 = rowNac.createCell(celdaTotal);
								rowNac.getCell(celdaTotal).setCellStyle(cellStyleNac);
								cell2.setCellValue(c2.get(i).getTOTAL());
								HSSFCell cell3 = rowNac.createCell(celdaPorcentaje);
								if (c2.get(i).getTOTAL() == 0) {
									porcentaje = 0;
								} else {
									porcentaje = (c2.get(i).getTOTAL() * 100) / suma;
								}
								cell3.setCellValue(porcentaje);
								rowNac.getCell(celdaPorcentaje).setCellStyle(style);
								s++;
								contFilas++;
							}
						}
					}
					if (cont == 5) {
						celdaTotal = 8;
						celdaPorcentaje = 9;
					}

				}
				cont++;
				contMaxFilas[cont2] = contFilas;
				cont2++;
				numFilaNacionalidad2 = 17;
				celdaMes = celdaMes + 6;// Desplazar seis posiciones a la derecha
				contFilas = 0;
				celdaNacionalidad = celdaNacionalidad + 6;
				celdaTotal = celdaTotal + 6;
				celdaPorcentaje = celdaPorcentaje + 6;
				if (cont2 == 3) {
					cont2 = 0;
					celdaMes = 1;
					celdaNacionalidad = 1;
				}
				if (cont == 7) {
					cont = 4;// cogemos cuatro para repetir este bucle

				}
				suma = 0;

			}

			anyoAct++;
			mesIni = 1;
			contHoja++;
			cont = 1;
			cont2 = 0;
			celdaMes = 1;
			celdaNacionalidad = 1;
			celdaTotal = 2;
			celdaPorcentaje = 3;
			numFilaNacionalidad3 = 17;
			for (int j = 0; j < contMaxFilas.length; j++) {
				contMaxFilas[j] = 0;
			}

			m2 = 0;

			suma = 0;
		}

		byte[] bytesExcel = Aa83BUtilidadesExcel.fncExcelToBytes(wb);
		response.setContentType("application/vnd.ms-excel");
		response.setContentLength(bytesExcel.length);
		response.setHeader("Content-disposition",
				"attachment;filename=EstadisticasNacionalidad.xls");
		response.getOutputStream().write(bytesExcel);
		response.getOutputStream().flush();

	}

	@RequestMapping(value = "/graficos", method = RequestMethod.GET)
	protected void crearGraficos(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		String strRutaExcel = this.appConfiguration.getProperty("tempPlantillasEstad.path") + "PlantillaNacionalidadGraficos.xls";
		InputStream inputStream = new FileInputStream(strRutaExcel);

		Aa83bEstadisticas filterBusqueda = new Aa83bEstadisticas();
		filterBusqueda.setTipoSol("0");

		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		wb.setSheetName(0, "Hoja1");
		HSSFFont hSSFFont = wb.createFont();

		HSSFSheet sheet = wb.getSheetAt(0);
		// Escribir departamento
		HSSFRow rowDep = sheet.getRow((short) 4);
		hSSFFont.setFontHeightInPoints((short) 6);

		CellStyle cellStyle2 = wb.createCellStyle();
		cellStyle2.setWrapText(true);
		cellStyle2.setFont(hSSFFont);
		// Estilo cabeceras y a�o
		HSSFFont hSSFFont2 = wb.createFont();
		hSSFFont2.setFontHeightInPoints((short) 9);
		hSSFFont2.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		CellStyle cellStyle = wb.createCellStyle();
		cellStyle.setFont(hSSFFont2);
		cellStyle.setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index);
		cellStyle.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		cellStyle.setWrapText(true);

		// Estilo meses
		HSSFFont hSSFFont3 = wb.createFont();
		hSSFFont3.setFontHeightInPoints((short) 8);
		hSSFFont3.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		CellStyle styleMes = wb.createCellStyle();
		styleMes.setFont(hSSFFont3);
		styleMes.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		styleMes.setBorderRight(HSSFCellStyle.BORDER_THIN);
		styleMes.setWrapText(true);

		HSSFCell cellDep = rowDep.createCell(6);
		cellDep.setCellValue(this.langEsProperties.getProperty("DEPT_ES_1")
				+ "\n " + this.langEsProperties.getProperty("DEPT_ES_2")
				+ "\n " + this.langEsProperties.getProperty("DEPT_ES_3")
				+ "\n " + this.langEsProperties.getProperty("DEPT_ES_4")
				+ "\n " + this.langEsProperties.getProperty("DEPT_ES_5"));
		rowDep.getCell(6).setCellStyle(cellStyle2);
		HSSFCell cellDep2 = rowDep.createCell(9);
		cellDep2.setCellValue(this.langEsProperties.getProperty("DEPT_EU_1")
				+ "\n " + this.langEsProperties.getProperty("DEPT_EU_2")
				+ "\n " + this.langEsProperties.getProperty("DEPT_EU_3")
				+ "\n " + this.langEsProperties.getProperty("DEPT_EU_4")
				+ "\n " + this.langEsProperties.getProperty("DEPT_EU_5"));
		rowDep.getCell(9).setCellStyle(cellStyle2);

		Aa83bContadorGraficos c = new Aa83bContadorGraficos();
		List<Aa83bContadorGraficos> c2 = new ArrayList<Aa83bContadorGraficos>();
		c2 = a83bEstadisticasService.contGraficos(c, jqGridRequestDto);

		int filaAnyo = 13;
		int celdaAnyo = 2;
		int celdaCabecera = 1;
		int celdaDatos = 1;
		int filaCabecera = filaAnyo + 1;
		int filaDatos = 15;
		int anyoActual = c2.get(0).getAnyo();
		int contArr = 0;
		int contAde = 0;
		int contEsf = 0;
		HSSFRow rowAnyo = sheet.getRow((filaAnyo));
		HSSFRow rowCabecera = sheet.getRow((filaCabecera));

		int anyo = 0;
		anyo = c2.get(0).getAnyo();
		List<Integer> anyos = new ArrayList<Integer>();
		anyos.add(anyo);
		for (int i = 0; i < c2.size(); i++) {
			if (anyo != c2.get(i).getAnyo()) {
				anyo = c2.get(i).getAnyo();
				anyos.add(anyo);
			}

		}
		for (int a = 0; a < anyos.size(); a++) {
			anyoActual = c2.get(0).getAnyo();
			for (int j = 1; j <= 13; j++) {
				HSSFRow rowDatos = sheet.getRow((filaDatos));
				if (j == 12) {
					rowDatos.createCell(celdaDatos).setCellValue(
							Aa83BConstants.mesesCastellano[0] + " / "
									+ Aa83BConstants.mesesEuskera[0]);

				} else if (j == 13) {
					rowDatos.createCell(celdaDatos).setCellValue(j);

				} else {

					rowDatos.createCell(celdaDatos).setCellValue(
							Aa83BConstants.mesesCastellano[j] + " / "
									+ Aa83BConstants.mesesEuskera[j]);
				}
				rowDatos.getCell(celdaDatos).setCellStyle(styleMes);

				for (int i = 0; i < c2.size(); i++) {

					if (anyos.get(a) == c2.get(i).getAnyo()) {
						anyoActual = c2.get(i).getAnyo();
						rowAnyo.createCell(celdaAnyo).setCellValue(anyoActual);
						rowAnyo.getCell(celdaAnyo).setCellStyle(cellStyle);
						rowCabecera.createCell(celdaCabecera).setCellValue(
								this.langEsProperties.getProperty("mesNac"));
						rowCabecera.createCell(celdaCabecera + 1).setCellValue(
								this.langEsProperties.getProperty("arrNac"));
						rowCabecera.createCell(celdaCabecera + 2).setCellValue(
								this.langEsProperties.getProperty("adeNac"));
						rowCabecera.createCell(celdaCabecera + 3).setCellValue(
								this.langEsProperties.getProperty("esfNac"));
						rowCabecera.getCell(celdaCabecera).setCellStyle(
								cellStyle);
						rowCabecera.getCell(celdaCabecera + 1).setCellStyle(
								cellStyle);
						rowCabecera.getCell(celdaCabecera + 2).setCellStyle(
								cellStyle);
						rowCabecera.getCell(celdaCabecera + 3).setCellStyle(
								cellStyle);
						if (a >= 3) {
							sheet.setColumnWidth(celdaCabecera, 4500);
							sheet.setColumnWidth(celdaCabecera + 1, 3000);
							sheet.setColumnWidth(celdaCabecera + 2, 3000);
							sheet.setColumnWidth(celdaCabecera + 3, 3000);
						}

						if (j == c2.get(i).getMes()) {
							rowDatos.createCell(celdaDatos + 1).setCellValue(
									c2.get(i).getArraigo());
							contArr = contArr + c2.get(i).getArraigo();
							rowDatos.createCell(celdaDatos + 2).setCellValue(
									c2.get(i).getAdecuacion());
							contAde = contAde + c2.get(i).getAdecuacion();
							rowDatos.createCell(celdaDatos + 3).setCellValue(
									c2.get(i).getEsfuerzo());
							contEsf = contEsf + c2.get(i).getEsfuerzo();

						}

					}

				}

				if (j == 13) {
					rowDatos.createCell(celdaDatos).setCellValue(
							this.langEsProperties.getProperty("totalNac"));
					rowDatos.getCell(celdaDatos).setCellStyle(cellStyle);
					rowDatos.createCell(celdaDatos + 1).setCellValue(contArr);
					rowDatos.createCell(celdaDatos + 2).setCellValue(contAde);
					rowDatos.createCell(celdaDatos + 3).setCellValue(contEsf);
					rowDatos.getCell(celdaDatos + 1).setCellStyle(cellStyle);
					rowDatos.getCell(celdaDatos + 2).setCellStyle(cellStyle);
					rowDatos.getCell(celdaDatos + 3).setCellStyle(cellStyle);
				}
				filaDatos = filaDatos + 1;
			}

			filaDatos = 15;
			celdaCabecera = celdaCabecera + 5;
			celdaDatos = celdaDatos + 5;
			celdaAnyo = celdaAnyo + 5;
			contArr = 0;
			contAde = 0;
			contEsf = 0;
		}

		byte[] bytesExcel = Aa83BUtilidadesExcel.fncExcelToBytes(wb);
		response.setContentType("application/vnd.ms-excel");
		response.setContentLength(bytesExcel.length);
		response.setHeader("Content-disposition",
				"attachment;filename=EstadisticasTotales.xls");
		response.getOutputStream().write(bytesExcel);
		response.getOutputStream().flush();

	}
}
