package com.ejie.aa83b.control;

import com.ejie.aa83b.service.Aa83bCierresService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa83b.model.Aa83bCierres;

/**
 * CierresController generated by UDA, 13-mar-2017 13:44:16.
 * @author UDA
 */
 
@Controller
@RequestMapping (value = "/cierres")

public class Aa83bCierresController  {

	private static final Logger logger = LoggerFactory.getLogger(Aa83bCierresController.class);

	@Autowired
	private Aa83bCierresService cierresService;
	
	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */
	
	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
	 * 
	 * @param idHistorial Integer
	 * @param id001fase Integer
	 * @param id002tram Integer
	 * @param id003tiposol Integer
	 * @param idsol BigDecimal
	 * @param idano Long
	 * @param factu Date
	 * @param usua String
	 * @param fregsal Date
	 * @param fnotif Date
	 * @param fexpir Date
	 * @param fmodif Date
	 * @param usumod String
	 * @param ftram Date
	 * @return Cierres 
	 *            Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idHistorial}/{id001fase}/{id002tram}/{id003tiposol}/{idsol}/{idano}/{factu}/{usua}/{fregsal}/{fnotif}/{fexpir}/{fmodif}/{usumod}/{ftram}", method = RequestMethod.GET)
	public @ResponseBody Aa83bCierres get(@PathVariable Integer idHistorial, @PathVariable Integer id001fase, @PathVariable Integer id002tram, @PathVariable Integer id003tiposol, @PathVariable Integer idsol, @PathVariable Long idano, @PathVariable Date factu, @PathVariable String usua, @PathVariable Date fregsal, @PathVariable Date fnotif, @PathVariable Date fexpir, @PathVariable Date fmodif, @PathVariable String usumod, @PathVariable Date ftram) {
        Aa83bCierres cierres = new Aa83bCierres();
		cierres.setIdHistorial(idHistorial);
		cierres.setId001fase(id001fase);
		cierres.setId002tram(id002tram);
		cierres.setId003tiposol(id003tiposol);
		cierres.setIdsol(idsol);
		cierres.setIdano(idano);
		cierres.setFactu(factu);
		cierres.setUsua(usua);
		cierres.setFregsal(fregsal);
		cierres.setFnotif(fnotif);
		cierres.setFexpir(fexpir);
		cierres.setFmodif(fmodif);
		cierres.setUsumod(usumod);
		cierres.setFtram(ftram);
        cierres = this.cierresService.find(cierres);
        Aa83bCierresController.logger.info("[GET - findBy_PK] : Obtener Cierres por PK");
        return cierres;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterCierres Cierres
	 *            Objeto que contiene los parametros de filtrado utilizados en
	 *            la busqueda.
	 * @return List<Cierres> 
	 *            Lista de objetos correspondientes a la busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Aa83bCierres> getAll(@ModelAttribute Aa83bCierres filterCierres) {
		Aa83bCierresController.logger.info("[GET - find_ALL] : Obtener Cierres por filtro");
	    return this.cierresService.findAll(filterCierres, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param cierres Cierres 
	 *            Bean que contiene la informacion a modificar.
	 * @return Cierres 
	 *            Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Aa83bCierres edit(@RequestBody Aa83bCierres cierres) {		
        Aa83bCierres cierresAux = this.cierresService.update(cierres);
		Aa83bCierresController.logger.info("[PUT] : Cierres actualizado correctamente");
        return cierresAux;
    }

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param cierres Cierres 
	 *            Bean que contiene la informacion con la que se va a crear el
	 *            nuevo registro.
	 * @return Cierres
	 *            Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Aa83bCierres add(@RequestBody Aa83bCierres cierres) {		
        Aa83bCierres cierresAux = this.cierresService.add(cierres);
        Aa83bCierresController.logger.info("[POST] : Cierres insertado correctamente");
    	return cierresAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idHistorial Integer
	 * @param id001fase Integer
	 * @param id002tram Integer
	 * @param id003tiposol Integer
	 * @param idsol BigDecimal
	 * @param idano Long
	 * @param factu Date
	 * @param usua String
	 * @param fregsal Date
	 * @param fnotif Date
	 * @param fexpir Date
	 * @param fmodif Date
	 * @param usumod String
	 * @param ftram Date
	 *            Identificador del objeto que se desea eliminar.
	 * @return Cierres
	 *            Bean eliminado.
	 */
	@RequestMapping(value = "/{idHistorial}/{id001fase}/{id002tram}/{id003tiposol}/{idsol}/{idano}/{factu}/{usua}/{fregsal}/{fnotif}/{fexpir}/{fmodif}/{usumod}/{ftram}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Aa83bCierres remove(@PathVariable Integer idHistorial, @PathVariable Integer id001fase, @PathVariable Integer id002tram, @PathVariable Integer id003tiposol, @PathVariable Integer idsol, @PathVariable Long idano, @PathVariable Date factu, @PathVariable String usua, @PathVariable Date fregsal, @PathVariable Date fnotif, @PathVariable Date fexpir, @PathVariable Date fmodif, @PathVariable String usumod, @PathVariable Date ftram) {
        Aa83bCierres cierres = new Aa83bCierres();
        cierres.setIdHistorial(idHistorial);
        cierres.setId001fase(id001fase);
        cierres.setId002tram(id002tram);
        cierres.setId003tiposol(id003tiposol);
        cierres.setIdsol(idsol);
        cierres.setIdano(idano);
        cierres.setFactu(factu);
        cierres.setUsua(usua);
        cierres.setFregsal(fregsal);
        cierres.setFnotif(fnotif);
        cierres.setFexpir(fexpir);
        cierres.setFmodif(fmodif);
        cierres.setUsumod(usumod);
        cierres.setFtram(ftram);
        this.cierresService.remove(cierres);
       	Aa83bCierresController.logger.info("[DELETE] : Cierres borrado correctamente");
       	return cierres;
    }
    
	
	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	 /**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83bCierresController.logger.info("[GET - View] : cierres");
		return "cierres";
	}
	 
	 /**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterCierres Cierres
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Cierres>
	 *            Dto que contiene el resultado del filtrado realizado por el 
	 *            componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa83bCierres> filter(
			@RequestJsonBody(param="filter") Aa83bCierres filterCierres,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83bCierresController.logger.info("[POST - filter] : Obtener Cierress");
		return this.cierresService.filter(filterCierres, jqGridRequestDto, false);
	}
	 
	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterCierres Cierres
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param searchCierres Cierres
	 *            Bean que contiene los parametros de busqueda a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Cierres> 
	 *            Dto que contiene el resultado de la busqueda realizada por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<Aa83bCierres>> search(
			@RequestJsonBody(param="filter") Aa83bCierres filterCierres,
			@RequestJsonBody(param="search") Aa83bCierres searchCierres,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83bCierresController.logger.info("[POST - search] : Buscar Cierress");
		return this.cierresService.search(filterCierres, searchCierres, jqGridRequestDto, false);
	}
	
	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterCierres Cierres
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String>
	 *            Lista de los identificadores de los registros eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param="filter") Aa83bCierres filterCierres,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83bCierresController.logger.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Cierress");
		this.cierresService.removeMultiple(filterCierres, jqGridRequestDto, false);
		Aa83bCierresController.logger.info("All entities correctly deleted!");
		
		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}
	
	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */
	
	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterCierres Cierres
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Cierres>>
	 *            Dto que contiene el resultado del filtrado realizado por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa83bCierres>> jerarquia(
			@RequestJsonBody(param="filter") Aa83bCierres filterCierres,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83bCierresController.logger.info("[POST - jerarquia] : Obtener Cierress jerarquia");
		return this.cierresService.jerarquia(filterCierres, jqGridRequestDto, false);
	}
	
	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion jerarquica.
	 * 
	 * @param filterCierres Cierres
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Cierres>>
	 *            Dto que contiene el resultado del filtrado realizado por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa83bCierres>> jerarquiaChildren(
			@RequestJsonBody(param="filter") Aa83bCierres  filterCierres ,
			@RequestJsonBody JQGridRequestDto  jqGridRequestDto) {
		Aa83bCierresController.logger.info("[POST - jerarquia] : Obtener Cierress jerarquia - Hijos");
		return this.cierresService.jerarquiaChildren(filterCierres, jqGridRequestDto);
	}
	
}	
