package com.ejie.aa83b.control;

import java.io.IOException;
import java.text.ParseException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.jms.Message;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

import com.ejie.aa83b.exception.Aa83bErrorGenericoException;
import com.ejie.aa83b.exception.Aa83bServiceException;
import com.ejie.aa83b.model.Aa83b02t00;
import com.ejie.aa83b.model.Aa83b03t00;
import com.ejie.aa83b.model.Aa83b06t00;
import com.ejie.aa83b.model.Aa83b07t00;
import com.ejie.aa83b.model.Aa83b07v00;
import com.ejie.aa83b.model.Aa83b08t00;
import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b10t00;
import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83bBusqueda;
import com.ejie.aa83b.model.Aa83bCierres;
import com.ejie.aa83b.service.Aa83b02t00Service;
import com.ejie.aa83b.service.Aa83b03t00Service;
import com.ejie.aa83b.service.Aa83b06t00Service;
import com.ejie.aa83b.service.Aa83b07t00Service;
import com.ejie.aa83b.service.Aa83b07v00Service;
import com.ejie.aa83b.service.Aa83b08t00Service;
import com.ejie.aa83b.service.Aa83b09t00Service;
import com.ejie.aa83b.service.Aa83b10t00Service;
import com.ejie.aa83b.service.Aa83b11t00Service;
import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b23t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83bCierresService;
import com.ejie.aa83b.service.Aa83bTramitacionExpedienteService;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSesionUtils;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.aa83b.util.Aa83bUtilSeguridad;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContext;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContextParser;
import com.ejie.aa83b.util.tramita.Aa83bXmlException;
import com.ejie.aa83b.util.xml.Aa83bXMLGenerator;
import com.ejie.aa83b.webservice.client.r02.Q99RCPFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.vdc.Q99USendMessageSCPFacadeWSSoap;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.json.MessageWriter;
import com.ejie.x38.reports.ReportData;

/**
 * PatronesController
 * 
 * @author UDA
 */
@Controller()
@RequestMapping(value = "/busqueda")
public class Aa83bBusquedaController {

	/** The Constant logger. */
	private static final Logger LOGGER = LoggerFactory.getLogger(Aa83bBusquedaController.class);

	/** The service. */
	@Autowired()
	private Aa83b07v00Service aa83b07v00Service;	
	
	/** The service. */
	@Autowired()
	private Aa83b21t00Service aa83b21t00Service;

	/** The service. */
	@Autowired()
	private Aa83b23t00Service aa83b23t00Service;

	/** The service. */
	@Autowired()
	private Aa83b25t00Service aa83b25t00Service;

	/** The service. */
	@Autowired()
	private Aa83b03t00Service aa83b03t00Service;

	/** The service. */
	@Autowired()
	private Aa83b09t00Service aa83b09t00Service;

	/** The service. */
	@Autowired()
	private Aa83b10t00Service aa83b10t00Service;

	/** The service. */
	@Autowired()
	private Aa83b11t00Service aa83b11t00Service;

	/** The service. */
	@Autowired()
	private Aa83b02t00Service aa83b02t00Service;

	/** The service. */
	@Autowired()
	private Aa83b06t00Service aa83b06t00Service;

	/** The service. */
	@Autowired()
	private Aa83b07t00Service aa83b07t00Service;

	/** The service. */
	@Autowired()
	private Aa83b08t00Service aa83b08t00Service;
	
	@Autowired()
	private Aa83bCierresService aa83bCierresService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Q99RCPFacadeWSSoap q99RCPFacadeWSSoap;

	@Autowired()
	private Q99USendMessageSCPFacadeWSSoap q99uSendMessageSCPFacadeWSSoap;

	// Nuevo
	@Autowired()
	private Aa83bTramitacionExpedienteService aa83bTramitacionExpedienteService;

	 /**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model Model
	 * @return String
	 */
	/*@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b07v00Controller.logger.info("[GET - View] : aa83b07v00");
		return "busqueda";
	}*/
	 
	/**
	 * @param filterBusqueda Aa83bBusqueda
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param session HttpSession
	 * @param request HttpServletRequest
	 * @return JQGridResponseDto<Aa83b07v00> 
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<Aa83b07v00> filter(
			@RequestJsonBody(param="filter") Aa83bBusqueda filterBusqueda,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, 
			HttpSession session,
			HttpServletRequest request) {
		Aa83bBusquedaController.LOGGER.info("[POST - filter] : Obtener Aa83b07v00s");
		
		// Calculamos el tipo de b�squeda // comentar para pasar a desarrollo
		
		// Este trozo comentado es para simular en local la cola JMS que recibe las solicitudes y las vuelca en la aplicacion
		
		if ("simula".equals(filterBusqueda.getNumReg())){
			Message msg = null;
			try {
				this.aa83bTramitacionExpedienteService.capturarEventoTelematico(msg);
			} catch (Aa83bServiceException e) {
				e.printStackTrace();
			}
			this.makeFile();
		}

		
		//Hay que coger el objeto Aa83bBusqueda y pasarselo a la vista
		Aa83b07v00 objFiltro  = (Aa83b07v00) this.getObjetoAa83b07v00(filterBusqueda);
		
		// Si es Vivienda, incluyo la Fase a la que pueden acceder:
		//String vivienda = "N";
		//if (Aa83bUtilSeguridad.esVivienda("AA83B", request).equals("S")) {
		//	objFiltro.setIdFase(Aa83BConstants.COD_FASE_2);
		//	objFiltro.setIdTram(Aa83BConstants.COD_TRAM_1);
		//	vivienda = "S";
		//}
		
		// Si se quiere ordenar por Expediente, son varios campos de BD para que el grid no se ordene alfabeticamente se rellena el id
		// a ceros por la izquierda hasta 15 posiciones
		if ("solconcat".equals(jqGridRequestDto.getSidx())){
			jqGridRequestDto.setSidx("tipoSol||idAno||lpad(t1.ID,'15',0)");
		} else {
			if ("fecAlta".equals(jqGridRequestDto.getSidx())){
				jqGridRequestDto.setSidx("fecAltaOrd");
			}
		}
		
		JQGridResponseDto<Aa83b07v00> responseGrid = this.aa83b07v00Service.filter(objFiltro, jqGridRequestDto, false);

		session.setAttribute("FILTRO_BUSQUEDA", filterBusqueda);
		session.setAttribute("PAGINACION_BUSQUEDA", responseGrid);
		
		return responseGrid;
	}	
	
	
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(
			@RequestParam(value = "origen", required = false) String origen,
			Model model, HttpSession session) {
		Aa83bBusquedaController.LOGGER.info("[GET - View] : BusquedaControler");
		// si se viene del menu se borra el filtro de sesion para inicializar los valores
		// si se viene del detalle se mantiene la info en sesion para poder rellenar los campos del filtro
		if ("menu".equalsIgnoreCase(origen)){
			session.removeAttribute("FILTRO_BUSQUEDA");
			Aa83bBusqueda miFiltro = new Aa83bBusqueda();
			Calendar fecha = Calendar.getInstance();
			miFiltro.setAno_sol(String.valueOf(fecha.get(Calendar.YEAR)));
			miFiltro.setTipoDoc("0");
			miFiltro.setIdfase("0");
			miFiltro.setTipoSol("0");
			miFiltro.setListCerradas("S");
			JQGridResponseDto<Aa83b07v00> gridResponseDto = new JQGridResponseDto<Aa83b07v00>();
			session.removeAttribute("PAGINACION_BUSQUEDA");
			if (miFiltro != null && gridResponseDto != null) {
				try {
					model.addAttribute("filtroBusqueda", new ObjectMapper().writeValueAsString(miFiltro));
					model.addAttribute("gridResponseDto",new ObjectMapper().writeValueAsString(gridResponseDto));
				} catch (IOException e) {
					Aa83bBusquedaController.LOGGER.warn("Se ha producido un error al parsear el filtro guardado en sesion",e);
				}
			}

		} else {
			// Se recupera el filtro
			Aa83bBusqueda miFiltro = (Aa83bBusqueda) session.getAttribute("FILTRO_BUSQUEDA");
			session.removeAttribute("FILTRO_BUSQUEDA");
	
			// se recupera la pagina

			JQGridResponseDto<Aa83b07v00> gridResponseDto = (JQGridResponseDto<Aa83b07v00>) session.getAttribute("PAGINACION_BUSQUEDA");
			session.removeAttribute("PAGINACION_BUSQUEDA");
	
			if (miFiltro != null && gridResponseDto != null) {
				try {
					model.addAttribute("filtroBusqueda", new ObjectMapper().writeValueAsString(miFiltro));
					model.addAttribute("gridResponseDto",new ObjectMapper().writeValueAsString(gridResponseDto));
				} catch (IOException e) {
					Aa83bBusquedaController.LOGGER.warn("Se ha producido un error al parsear el filtro guardado en sesion",e);
				}
			}
		}

		return "busqueda";
	}	
	
	// @Autowired
	// private ValidationManager validationManager;
	public List<Aa83b07v00> busquedaStandardOrd(Aa83bBusqueda filterBusqueda,
			JQGridRequestDto jqGridRequestDto, Boolean excel,
			HttpServletRequest request, HttpSession session) {
		
		List<Aa83b07v00> responseGrid = new ArrayList<Aa83b07v00>();
		List<Aa83b07v00> responseGridPaginado = new ArrayList<Aa83b07v00>();
		
		String noListCerradas = "S";

		Aa83b07v00 aa83b07v00 = new Aa83b07v00();
		aa83b07v00.setNombre(filterBusqueda.getNombre_sol());
		aa83b07v00.setApel1(filterBusqueda.getApellido1_sol());
		aa83b07v00.setApel2(filterBusqueda.getApellido2_sol());
		aa83b07v00.setTipoDoc(filterBusqueda.getTipoDoc());
		aa83b07v00.setNumDoc(filterBusqueda.getNumero_dni());
		aa83b07v00.setNumReg(filterBusqueda.getNumReg());
		aa83b07v00.setId(filterBusqueda.getId_sol());
		aa83b07v00.setIdSol(filterBusqueda.getTipoSol());
		aa83b07v00.setIdAno(filterBusqueda.getAno_sol());
		//aa83b07v00.setIdSol(filterBusqueda.getId_sol());
		//si esta chequeado no se muestran las cerradas
		if ("S".equals(filterBusqueda.getListCerradas())){
			aa83b07v00.setSoliCerrada("N");	
		}
		aa83b07v00.setIdFase(filterBusqueda.getIdfase());
		aa83b07v00.setIdTram(filterBusqueda.getIdtramite());		

		// Si es Vivienda, incluyo la Fase a la que pueden acceder:
		String vivienda = "N";
		if (Aa83bUtilSeguridad.esVivienda("AA83B", request).equals("S")) {
			aa83b07v00.setIdFase(Aa83BConstants.COD_FASE_2);
			aa83b07v00.setIdTram(Aa83BConstants.COD_TRAM_1);
			vivienda = "S";
		}		
		
		responseGrid = this.aa83b07v00Service.findAllLike(aa83b07v00,null, false);
/*
		if (jqGridRequestDto.getSidx() != null){
			List< TableRowDto< Aa83b07v00>> reorderSelection = this.aa83b07v00Service.reorderSelection(aa83b07v00, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<Aa83b13t00>(jqGridRequestDto, recordNum, listaAa83b13t00, reorderSelection);		
	*/	
		// Paginamos:
		//this.totalGrid = responseGrid.size();
		if (!excel) {
			if (jqGridRequestDto.getPage() != 1) {
				// Paginamos
				int p = (int) ((jqGridRequestDto.getPage() - 1) * jqGridRequestDto.getRows());

				for (int pag = p; (pag < responseGrid.size()); pag++) {
					responseGridPaginado.add(responseGrid.get(pag));
				}

				// Miro si es la ultima página:
				if ((responseGrid.size() - (jqGridRequestDto.getPage() * jqGridRequestDto.getRows())) <= 0) {

				} else {
					if (jqGridRequestDto.getPage() != 1) {
						for (int pant = 0; pant < p; pant++)
							responseGridPaginado.add(responseGrid.get(pant));
					}
				}

			} else {
				responseGridPaginado = responseGrid;
			}
		} else {
			responseGridPaginado = responseGrid;
		}
		
		
		
		return responseGridPaginado;
	}
	
	// @Autowired
	// private ValidationManager validationManager;
/*
	public List<Aa83bBusqueda> busquedaStandard(Aa83bBusqueda filterBusqueda,
			JQGridRequestDto jqGridRequestDto, Boolean excel,
			HttpServletRequest request, HttpSession session) {
		Aa83b21t00 solicitudADE = new Aa83b21t00();
		Aa83b23t00 solicitudESF = new Aa83b23t00();
		Aa83b25t00 solicitudARR = new Aa83b25t00();
		String nombre_sol = filterBusqueda.getNombre_sol();
		String apellido1_sol = filterBusqueda.getApellido1_sol();
		String apellido2_sol = filterBusqueda.getApellido2_sol();
		String numero_dni = filterBusqueda.getNumero_dni();
		String comboTipoDoc = filterBusqueda.getTipoDoc();
		String numRegistro = filterBusqueda.getNumReg();
		String numSol = filterBusqueda.getId_sol();
		String anoSol = filterBusqueda.getAno_sol();
		String tipoSol = filterBusqueda.getTipoSol();
		String noListCerradas = "S";

		List<Aa83b21t00> aa83b21t00List = new ArrayList<Aa83b21t00>();
		List<Aa83b23t00> aa83b23t00List = new ArrayList<Aa83b23t00>();
		List<Aa83b25t00> aa83b25t00List = new ArrayList<Aa83b25t00>();

		// Calculamos el tipo de b�squeda // comentar para pasar a desarrollo
//		Message msg = null;
//		try {
//			this.aa83bTramitacionExpedienteService.capturarEventoTelematico(msg);
//		} catch (Aa83bServiceException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}

		// System.out.println("Antes de llamar a makeFile();");
		// this.makeFile();
		// System.out.println("Despues de llamar a makeFile();");

		// Si está chequeado solamente se recogen las listas cerradas.
		if ("S".equals(filterBusqueda.getListCerradas())) {
			noListCerradas = "N";
			solicitudADE.setSolicerrada021("N");
			solicitudESF.setSolicerrada023("N");
			solicitudARR.setSolicerrada025("N");
		}

		if ((filterBusqueda.getNombre_sol() != null) // NOPMD
				|| (filterBusqueda.getApellido1_sol() != null) // NOPMD
				|| (filterBusqueda.getApellido2_sol() != null) // NOPMD
				|| (filterBusqueda.getNumero_dni() != null)) { // NOPMD
			if (filterBusqueda.getNombre_sol() != null // NOPMD
					&& !filterBusqueda.getNombre_sol().equals("")) // NOPMD
			{
				solicitudADE.setNombre021(nombre_sol);
				solicitudESF.setNombre023(nombre_sol);
				solicitudARR.setNombre025(nombre_sol);
			}
			if (filterBusqueda.getApellido1_sol() != null // NOPMD
					&& !filterBusqueda.getApellido1_sol().equals("")) // NOPMD
			{
				solicitudADE.setApel1021(apellido1_sol);
				solicitudESF.setApel1023(apellido1_sol);
				solicitudARR.setApel1025(apellido1_sol);
			}

			if (filterBusqueda.getApellido2_sol() != null // NOPMD
					&& !apellido2_sol.equals("")) { // NOPMD
				solicitudADE.setApel2021(apellido2_sol);
				solicitudESF.setApel2023(apellido2_sol);
				solicitudARR.setApel2025(apellido2_sol);
			}

			if (filterBusqueda.getNumero_dni() != null // NOPMD
					&& !filterBusqueda.getNumero_dni().equals("")) // NOPMD
			{
				solicitudADE.setNumDoc021(numero_dni);
				solicitudESF.setNumDoc023(numero_dni);
				solicitudARR.setNumDoc025(numero_dni);

				solicitudADE.setId012TipoDoc(Integer.parseInt(comboTipoDoc));
				solicitudESF.setId012TipoDoc(Integer.parseInt(comboTipoDoc));
				solicitudARR.setId012TipoDoc(Integer.parseInt(comboTipoDoc));
			}
		} else {
			if (filterBusqueda.getId_sol() != null) { // NOPMD
				solicitudADE.setId021(Integer.parseInt(numSol));
				solicitudESF.setId023(Integer.parseInt(numSol));
				solicitudARR.setId025(Integer.parseInt(numSol));
			}
			if (filterBusqueda.getAno_sol() != null) { // NOPMD
				solicitudADE.setIdAno021(Long.parseLong(anoSol));
				solicitudESF.setIdAno023(Long.parseLong(anoSol));
				solicitudARR.setIdAno025(Long.parseLong(anoSol));
			}

		} // End del IF de tipo de Busqueda para ADE 9

		if ((filterBusqueda.getNumReg() != null) && (!numRegistro.equals(""))) // NOPMD
		{
			solicitudADE.setNumReg021(numRegistro);
			solicitudESF.setNumReg023(numRegistro);
			solicitudARR.setNumReg025(numRegistro);

		}
		int conta21 = 0;
		int conta23 = 0;
		int conta25 = 0;

		// Si es Vivienda, incluyo la Fase a la que pueden acceder:
		String vivienda = "N";
		if (Aa83bUtilSeguridad.esVivienda("AA83B", request).equals("S")) {
			filterBusqueda.setIdfase(Aa83BConstants.COD_FASE_2);
			filterBusqueda.setIdtramite(Aa83BConstants.COD_TRAM_1);
			vivienda = "S";
			solicitudADE.setPasarvivienda021("S");
			tipoSol = Aa83BConstants.COD_ADE;
		}

		List<Aa83bBusqueda> responseGrid = new ArrayList<Aa83bBusqueda>();

		List<Aa83bBusqueda> responseGridPaginado = new ArrayList<Aa83bBusqueda>();
		Locale locale = LocaleContextHolder.getLocale();

		int i = 0;

		if (Aa83BConstants.COD_ADE.equals(tipoSol) || "0".equals(tipoSol)) {

			aa83b21t00List = this.aa83b21t00Service.findAllLike(solicitudADE,null, false);
			conta21 = aa83b21t00List.size();

			for (i = 0; i < conta21; i++) {
				Aa83bBusqueda resultB = new Aa83bBusqueda();
				solicitudADE = aa83b21t00List.get(i);
				resultB.setNombre_sol(solicitudADE.getNombre021());
				resultB.setApellido1_sol(solicitudADE.getApel1021());
				resultB.setApellido2_sol(solicitudADE.getApel2021());
				resultB.setAno_sol(solicitudADE.getIdAno021().toString());
				resultB.setId_sol(solicitudADE.getId021().toString());

				Aa83b03t00 aa83b03t00 = new Aa83b03t00();
				resultB.setTipoSol(Aa83BConstants.COD_ADE);
				aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ADE));
				resultB.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
				resultB.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
				resultB.setSolConcat(resultB.getTipoSolStrEs() + " "+ resultB.getAno_sol() + " " + resultB.getId_sol());

				// Calculamos fecha de Alta
				Aa83b06t00 aa83b06t00 = new Aa83b06t00();
				aa83b06t00.setTipoModif038(Aa83BConstants.ACCESOS_ALTA);
				aa83b06t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
				aa83b06t00.setId021NumSol(solicitudADE.getId021());
				aa83b06t00.setIdAno021(solicitudADE.getIdAno021());

				List<Aa83b06t00> aa83b06t00Lista = aa83b06t00Service.findAllLike(aa83b06t00, null, false);

				if (aa83b06t00Lista.size() > 0) {
					aa83b06t00 = aa83b06t00Lista.get(0);
					resultB.setFecha(aa83b06t00.getfActu006().toString());
				}

				// Calculo el Estado
				Aa83b09t00 aa83b09t00 = new Aa83b09t00();
				aa83b09t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
				aa83b09t00.setId021NumSol(solicitudADE.getId021());
				aa83b09t00.setIdAno021(solicitudADE.getIdAno021());

				// List<Aa83b09t00> aa83b09t00Lista =
				// aa83b09t00Service.findAllLike(
				// aa83b09t00, null, null);

				Aa83b09t00 aa83b09t00Lista = aa83b09t00Service.getLastRow(aa83b09t00);

				int esTelematica = 0;
				if (Aa83BConstants.LOCALE_ES.toString().toUpperCase().equals(locale.getLanguage().toUpperCase())) {
					resultB.setEstado(aa83b09t00Lista.getId002TramStrEs());
					resultB.setIdfase(aa83b09t00Lista.getId001Fase().toString());
					resultB.setIdtramite(aa83b09t00Lista.getId002Tram().toString());

				} else {
					resultB.setEstado(aa83b09t00Lista.getId002TramStrEu());
					resultB.setIdfase(aa83b09t00Lista.getId001Fase().toString());
					resultB.setIdtramite(aa83b09t00Lista.getId002Tram().toString());
				}

				if (aa83b09t00Lista.getId002Tram() == 0) {
					esTelematica = 1;
				}
				// Filtro por estado de tramitacion

				int incluir = 1;
				// Miro si la solicutud esta en el fase-tramite requeridos

				if (!vivienda.equals("S"))
					incluir = tratarTramita(resultB, filterBusqueda,noListCerradas);

				if ((incluir == 1) && (esTelematica == 0)){
					responseGrid.add(resultB);
				}
				

			}
		}		

		if (Aa83BConstants.COD_ESF.equals(tipoSol) || "0".equals(tipoSol)) {

			aa83b23t00List = this.aa83b23t00Service.findAllLike(solicitudESF,null, false);
			conta23 = aa83b23t00List.size();

			for (i = 0; i < conta23; i++) {
				Aa83bBusqueda resultB = new Aa83bBusqueda();
				solicitudESF = aa83b23t00List.get(i);
				resultB.setNombre_sol(solicitudESF.getNombre023());
				resultB.setApellido1_sol(solicitudESF.getApel1023());
				resultB.setApellido2_sol(solicitudESF.getApel2023());
				resultB.setAno_sol(solicitudESF.getIdAno023().toString());
				resultB.setId_sol(solicitudESF.getId023().toString());

				// Calculamos fecha de Alta
				Aa83b03t00 aa83b03t00 = new Aa83b03t00();
				resultB.setTipoSol(Aa83BConstants.COD_ESF);
				aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ESF));

				resultB.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
				resultB.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
				resultB.setSolConcat(resultB.getTipoSolStrEs() + " " + resultB.getAno_sol() + " " + resultB.getId_sol());

				// Calculamos fecha de Alta
				Aa83b07t00 aa83b07t00 = new Aa83b07t00();
				aa83b07t00.setTipoModif038(Aa83BConstants.ACCESOS_ALTA);
				aa83b07t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));
				aa83b07t00.setId023NumSol(solicitudESF.getId023());
				aa83b07t00.setIdAno023(solicitudESF.getIdAno023());

				List<Aa83b07t00> aa83b07t00Lista = aa83b07t00Service.findAllLike(aa83b07t00, null, false);

				if (aa83b07t00Lista.size() > 0) {
					aa83b07t00 = aa83b07t00Lista.get(0);
					if (null != aa83b07t00.getfActu007()) {
						resultB.setFecha(aa83b07t00.getfActu007().toString());
					}
				}

				// Calculo el Estado
				Aa83b10t00 aa83b10t00 = new Aa83b10t00();
				aa83b10t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));
				aa83b10t00.setId023NumSol(Long.parseLong(solicitudESF.getId023().toString()));
				aa83b10t00.setIdAno023(solicitudESF.getIdAno023());

				Aa83b10t00 aa83b10t00Lista = aa83b10t00Service.getLastRow(aa83b10t00);

				if (Aa83BConstants.LOCALE_ES.toString().toUpperCase().equals(locale.getLanguage().toUpperCase())) {
					resultB.setEstado(aa83b10t00Lista.getId002TramStrEs());
					resultB.setIdfase(aa83b10t00Lista.getId001Fase().toString());
					resultB.setIdtramite(aa83b10t00Lista.getId002Tram().toString());
				} else {
					resultB.setEstado(aa83b10t00Lista.getId002TramStrEu());
					resultB.setIdfase(aa83b10t00Lista.getId001Fase().toString());
					resultB.setIdtramite(aa83b10t00Lista.getId002Tram().toString());
				}
				int esTelematica = 0;
				if (aa83b10t00Lista.getId002Tram() == 0) {
					esTelematica = 1;
				}
				// Filtro por estado de tramitacion
				int incluir = 1;
				// Miro si la solicutud esta en el fase-tramite requeridos
				incluir = tratarTramita(resultB, filterBusqueda, noListCerradas);

				if (incluir == 1) {
					if (esTelematica == 0){
						responseGrid.add(resultB);
					}
				}

			}
		}

		if (Aa83BConstants.COD_ARR.equals(tipoSol) || "0".equals(tipoSol)) {

			aa83b25t00List = this.aa83b25t00Service.findAllLike(solicitudARR,null, false);
			conta25 = aa83b25t00List.size();

			for (i = 0; i < conta25; i++) {

				Aa83bBusqueda resultB = new Aa83bBusqueda();
				solicitudARR = aa83b25t00List.get(i);
				resultB.setNombre_sol(solicitudARR.getNombre025());
				resultB.setApellido1_sol(solicitudARR.getApel1025());
				resultB.setApellido2_sol(solicitudARR.getApel2025());
				resultB.setAno_sol(solicitudARR.getIdAno025().toString());
				resultB.setId_sol(solicitudARR.getId025().toString());

				// Calculamos fecha de Alta
				Aa83b03t00 aa83b03t00 = new Aa83b03t00();
				resultB.setTipoSol(Aa83BConstants.COD_ARR);
				aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ARR));
				resultB.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
				resultB.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
				resultB.setSolConcat(resultB.getTipoSolStrEs() + " " + resultB.getAno_sol() + " " + resultB.getId_sol());

				// Calculamos fecha de Alta
				Aa83b08t00 aa83b08t00 = new Aa83b08t00();
				aa83b08t00.setTipoModif038(Aa83BConstants.ACCESOS_ALTA);
				aa83b08t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
				aa83b08t00.setId025NumSol(solicitudARR.getId025());
				aa83b08t00.setIdAno025(solicitudARR.getIdAno025());

				List<Aa83b08t00> aa83b08t00Lista = aa83b08t00Service.findAllLike(aa83b08t00, null, false);

				if (!aa83b08t00Lista.isEmpty()) {
					aa83b08t00 = aa83b08t00Lista.get(0);
					resultB.setFecha(aa83b08t00.getfActu008().toString());
				}
				// Calculo el Estado
				Aa83b11t00 aa83b11t00 = new Aa83b11t00();
				aa83b11t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));
				aa83b11t00.setId025NumSol(solicitudARR.getId025());
				aa83b11t00.setIdAnoSol025(solicitudARR.getIdAno025());
				// Para recoger el último estado de una solicitud
				Aa83b11t00 aa83b11t00Lista = aa83b11t00Service
						.getLastRow(aa83b11t00);

				// (aa83b11t00, null, null);
				if (Aa83BConstants.LOCALE_ES.toString().toUpperCase().equals(locale.getLanguage().toUpperCase())) {

					resultB.setEstado(aa83b11t00Lista.getId002TramStrEs());
					resultB.setIdfase(aa83b11t00Lista.getId001Fase().toString());
					resultB.setIdtramite(aa83b11t00Lista.getId002Tram().toString());
				} else {
					resultB.setEstado(aa83b11t00Lista.getId002TramStrEu());
					resultB.setIdfase(aa83b11t00Lista.getId001Fase().toString());
					resultB.setIdtramite(aa83b11t00Lista.getId002Tram().toString());
				}
				int esTelematica = 0;
				if (aa83b11t00Lista.getId002Tram() == 0)
					esTelematica = 1;

				// Miro si la solicutud esta en el fase-tramite requeridos
				int incluir = 1;
				incluir = tratarTramita(resultB, filterBusqueda, noListCerradas);

				if ((incluir == 1) && (esTelematica == 0)){
					responseGrid.add(resultB);
				}

			}
		}

		// Paginamos:
		//this.totalGrid = responseGrid.size();
		if (!excel) {
			if (jqGridRequestDto.getPage() != 1) {
				// Paginamos
				int p = (int) ((jqGridRequestDto.getPage() - 1) * jqGridRequestDto.getRows());

				for (int pag = p; (pag < responseGrid.size()); pag++) {
					responseGridPaginado.add(responseGrid.get(pag));
				}

				// Miro si es la ultima página:
				if ((responseGrid.size() - (jqGridRequestDto.getPage() * jqGridRequestDto.getRows())) <= 0) {

				} else {
					if (jqGridRequestDto.getPage() != 1) {
						for (int pant = 0; pant < p; pant++)
							responseGridPaginado.add(responseGrid.get(pant));
					}
				}

			} else {
				responseGridPaginado = responseGrid;
			}
		} else {
			responseGridPaginado = responseGrid;
		}
		
		
		
		return responseGridPaginado;
	}
*/
	private int tratarTramita(Aa83bBusqueda resultB,
			Aa83bBusqueda filterBusqueda, String noListCerradas) {
		int incluir = 1;
		if (!(filterBusqueda.getIdfase().equals("0"))) {
			incluir = 0;
			if (!(filterBusqueda.getIdtramite().equals("0"))) {
				// Se filtra por Fase y Tramite
				if ((resultB.getIdfase().equals(filterBusqueda.getIdfase()))
						&& (resultB.getIdtramite().equals(filterBusqueda.getIdtramite()))) {
					incluir = 1;
					if (noListCerradas.equals("S")&& (resultB.getIdfase().equals(Aa83BConstants.COD_FASE_3))
							&& (resultB.getIdtramite().equals(Aa83BConstants.COD_TRAM_1)))
						incluir = 0;
				}

			} else {
				// Se filtra solo por Fase
				if ((filterBusqueda.getIdfase().equals(resultB.getIdfase()))) {
					incluir = 1;
					if (noListCerradas.equals("S")&& (resultB.getIdfase().equals(Aa83BConstants.COD_FASE_3))
							&& (resultB.getIdtramite().equals(Aa83BConstants.COD_TRAM_1)))
						incluir = 0;
				}

			}
		} else {
			// noListCerradas
			if (noListCerradas.equals("S"))
				if ((resultB.getIdfase().equals(Aa83BConstants.COD_FASE_3))
						&& (resultB.getIdtramite().equals(Aa83BConstants.COD_TRAM_1)))
					incluir = 0;
				else
					incluir = 1;
		}
		// TODO Auto-generated method stub
		return incluir;
	}

	@RequestMapping(value = "cierre", method = RequestMethod.GET)
	public ModelAndView cierre() {
		return new ModelAndView("listacierre");
	}

	
	
	
	@RequestMapping(value = "cierreExp", method = RequestMethod.GET)
	public @ResponseBody
	HashMap<String, String> cierreExp(
			@RequestParam(value = "idDoc", required = true) String idDoc,
			HttpServletRequest request) throws Aa83bXmlException,
			Aa83bErrorGenericoException, ParseException {
		HashMap<String, String> retorno = new HashMap<String, String>();
		ArrayList<String> solis = new ArrayList<String>(Arrays.asList(idDoc.split(",")));
		Aa83bConsultationContextParser resParser = new Aa83bConsultationContextParser();
		Aa83bConsultationContext res;
		String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
		String idProcedimiento = this.appConfiguration.getProperty("procedure.adecuacion.id");
		String procedure = "";
		Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
		// llamada al getProcedureFac para recuperar los datos del
		// procedimiento

		procedure = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken,idProcedimiento);
		try {
			resParser = new Aa83bConsultationContextParser(procedure);
		} catch (Aa83bXmlException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Aa83bErrorGenericoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		res = resParser.getProcedureDataAll();

		if (solis != null && solis.size() > 0) {
			for (int s = 0; s < solis.size(); s++) {
				String idSolConcat = solis.get(s);
				ArrayList<String> idSolTrozos = new ArrayList<String>(Arrays.asList(idSolConcat.split(" ")));
				String tipoSol = idSolTrozos.get(0);
				String anoSol = idSolTrozos.get(1);
				String idSol = idSolTrozos.get(2);
				Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
				if (tipoSol.equals(Aa83BConstants.COD_ADE_STR)) {
					// Completo los datos de Tramitacon
					Aa83b21t00 solicitudADE = new Aa83b21t00();
					solicitudADE.setId021(Integer.parseInt(idSol));
					solicitudADE.setIdAno021(Long.parseLong(anoSol));
					aa83b21t00Service.cerrarExp(solicitudADE);
					// Grabamos el acceso
					aa83b06t00Service.add(aa83bSolicitudesUtil.guardarAccesoADE(solicitudADE,Aa83BConstants.ACCESOS_MODIF, "N"));
					// Grabamos el HistoTRAM
					aa83b09t00Service.add(aa83bSolicitudesUtil.guardarHistoADE(solicitudADE, Aa83BConstants.COD_FASE_3,
							              Aa83BConstants.COD_TRAM_1, "N"));
					idProcedimiento = this.appConfiguration.getProperty("procedure.adecuacion.id");

					String expediente = aa83bXMLGenerator.generarXmlCloseExpedient(anoSol, idSol, tipoSol,res, idProcedimiento);
					LOGGER.info("cierre expediente ------------>" + expediente);
					q99uSendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken,expediente, "closeExpedientNT");

				} else if (tipoSol.equals(Aa83BConstants.COD_ESF_STR)) {

					// Completo los datos de Tramitacon
					Aa83b23t00 solicitudESF = new Aa83b23t00();
					solicitudESF.setId023(Integer.parseInt(idSol));
					solicitudESF.setIdAno023(Long.parseLong(anoSol));

					aa83b23t00Service.cerrarExp(solicitudESF);

					// Grabamos el acceso
					aa83b07t00Service.add(aa83bSolicitudesUtil.guardarAccesoESF(solicitudESF,Aa83BConstants.ACCESOS_MODIF, "N"));
					// Grabamos el HistoTRAM
					aa83b10t00Service.add(aa83bSolicitudesUtil.guardarHistoESF(solicitudESF, Aa83BConstants.COD_FASE_3,
							                                                   Aa83BConstants.COD_TRAM_1, "N"));
					idProcedimiento = this.appConfiguration.getProperty("procedure.esfuerzo.id");

					String expediente = aa83bXMLGenerator.generarXmlCloseExpedient(anoSol, idSol, tipoSol,res, idProcedimiento);
					LOGGER.info("cierre expediente ------------>" + expediente);
					q99uSendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken,expediente, "closeExpedientNT");

				} else if (tipoSol.equals(Aa83BConstants.COD_ARR_STR)) {
					// Completo los datos de Tramitacon
					Aa83b25t00 solicitudARR = new Aa83b25t00();
					solicitudARR.setId025(Integer.parseInt(idSol));
					solicitudARR.setIdAno025(Long.parseLong(anoSol));
					aa83b25t00Service.cerrarExp(solicitudARR);

					// Grabamos el acceso
					aa83b08t00Service.add(aa83bSolicitudesUtil.guardarAccesoARR(solicitudARR,Aa83BConstants.ACCESOS_MODIF, "N"));
					// Grabamos el HistoTRAM
					aa83b11t00Service.add(aa83bSolicitudesUtil.guardarHistoARR(solicitudARR, Aa83BConstants.COD_FASE_3,
							                                                   Aa83BConstants.COD_TRAM_1, "N"));
					idProcedimiento = this.appConfiguration.getProperty("procedure.arraigo.id");

					String expediente = aa83bXMLGenerator.generarXmlCloseExpedient(anoSol, idSol, tipoSol,res, idProcedimiento);
					LOGGER.info("cierre expediente ------------>" + expediente);
					q99uSendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken,expediente, "closeExpedientNT");
				}
			}

		}
		return retorno;
	}

	
	
	@RequestMapping(value = "cierre/remote/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83bBusqueda> cierreRemote(
			@RequestJsonBody(param = "filter") Aa83bBusqueda filterBusqueda,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {

		Locale locale = LocaleContextHolder.getLocale();
		// Buscamos las solicitudes 21, 23 y 25 que esten en F2, T2
		Aa83b09t00 aa83b09t00 = new Aa83b09t00();
		Aa83b10t00 aa83b10t00 = new Aa83b10t00();
		Aa83b11t00 aa83b11t00 = new Aa83b11t00();
		
		String tipoSol = filterBusqueda.getTipoSol();
		String numExpediente = filterBusqueda.getId_sol();
		String anoSol = filterBusqueda.getAno_sol();
		
		aa83b09t00.setIdAno021(Long.parseLong(anoSol));
		aa83b10t00.setIdAno023(Long.parseLong(anoSol));
		aa83b11t00.setIdAnoSol025(Long.parseLong(anoSol));

		List<Aa83b09t00> aa83b09t00Lista = new ArrayList<Aa83b09t00>();
		List<Aa83b10t00> aa83b10t00Lista = new ArrayList<Aa83b10t00>();
		List<Aa83b11t00> aa83b11t00Lista = new ArrayList<Aa83b11t00>();

		/*int conta09 = 0;
		int conta10 = 0;
		int conta11 = 0;*/

		List<Aa83bBusqueda> responseGrid = new ArrayList<Aa83bBusqueda>();

		if (tipoSol == null){
			tipoSol = "0";
			filterBusqueda.setTipoSol(tipoSol);
		}
		if (numExpediente == null) {
			numExpediente = "0";
		}
		
		if (tipoSol.equals("0")) {
			Aa83bBusquedaController.LOGGER.info("numExpediente::: "+numExpediente);
			if(numExpediente!=null && !numExpediente.equals("0")){
				aa83b09t00.setId021NumSol(Integer.parseInt(numExpediente)); 
				aa83b10t00.setId023NumSol(Long.parseLong(numExpediente)); 
				aa83b11t00.setId025NumSol(Integer.parseInt(numExpediente));
			}
			aa83b09t00Lista = aa83b09t00Service.findEnviadas(aa83b09t00, null);
			aa83b10t00Lista = aa83b10t00Service.findEnviadas(aa83b10t00, null);
			aa83b11t00Lista = aa83b11t00Service.findEnviadas(aa83b11t00, null);
			/*conta09 = aa83b09t00Lista.size();
			conta10 = aa83b10t00Lista.size();
			conta11 = aa83b11t00Lista.size();*/
		}

		if (tipoSol.equals(Aa83BConstants.COD_ADE)) {
			if(numExpediente!=null && !numExpediente.equals("0")){
				aa83b09t00.setId021NumSol(Integer.parseInt(numExpediente));
			}	
			aa83b09t00Lista = aa83b09t00Service.findEnviadas(aa83b09t00, null);
			//conta09 = aa83b09t00Lista.size();
		}
		if (tipoSol.equals(Aa83BConstants.COD_ESF)) {
			if(numExpediente!=null && !numExpediente.equals("0")){
				aa83b10t00.setId023NumSol(Long.parseLong(numExpediente));
			}
			aa83b10t00Lista = this.aa83b10t00Service.findEnviadas(aa83b10t00,null);
			//conta10 = aa83b10t00Lista.size();
		}
		if (tipoSol.equals(Aa83BConstants.COD_ARR)) {
			if(numExpediente!=null && !numExpediente.equals("0")){
				aa83b11t00.setId025NumSol(Integer.parseInt(numExpediente));
			}
			aa83b11t00Lista = aa83b11t00Service.findEnviadas(aa83b11t00, null);
			//conta11 = aa83b11t00Lista.size();
		}
		int total = 0;
		
		Aa83bCierres c = new Aa83bCierres();
		c.setId003tiposol(Integer.parseInt(tipoSol));
		c.setIdano(Long.parseLong(filterBusqueda.getAno_sol()));
		c.setIdsol(Integer.parseInt(numExpediente));
		List<Aa83bCierres> listaCierres = aa83bCierresService.findAllLike(c, null, null);
		
		for (int i = 0; i < listaCierres.size(); i++) {
			Aa83bCierres cierre = listaCierres.get(i);
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();
			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_2));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_2));
			aa83b02t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));

			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);
			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase().equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			if (String.valueOf(cierre.getId003tiposol()).equals(Aa83BConstants.COD_ADE)) {
				Aa83b21t00 aa83b21t00 = new Aa83b21t00();
				aa83b21t00.setId021(cierre.getIdsol());
				aa83b21t00.setIdAno021(cierre.getIdano());
				List<Aa83b21t00> aa83b21t00Lista = aa83b21t00Service.findAllLike(aa83b21t00, null, null);

				aa83b21t00 = aa83b21t00Lista.get(0);

				aa83bBusqueda.setId_sol(aa83b21t00.getId021().toString());
				aa83bBusqueda.setAno_sol(aa83b21t00.getIdAno021().toString());

				aa83bBusqueda.setNombre_sol(aa83b21t00.getNombre021());
				aa83bBusqueda.setApellido1_sol(aa83b21t00.getApel1021());
				aa83bBusqueda.setApellido2_sol(aa83b21t00.getApel1021());

				if (aa83b21t00.getFecha021() != null)
					aa83bBusqueda.setFecha(aa83b21t00.getFecha021());

				aa83bBusqueda.setNumero_dni(aa83b21t00.getNumDoc021());

				Aa83b03t00 aa83b03t00 = new Aa83b03t00();

				aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ADE));
				aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
				aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00).getTipoSol003());

				aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "+ aa83bBusqueda.getAno_sol() + " " + aa83bBusqueda.getId_sol());

				total++;
				responseGrid.add(aa83bBusqueda);
			} else if (String.valueOf(cierre.getId003tiposol()).equals(Aa83BConstants.COD_ESF)) {
				Aa83b23t00 aa83b23t00 = new Aa83b23t00();
				aa83b23t00.setId023(cierre.getIdsol());
				aa83b23t00.setIdAno023(cierre.getIdano());
				List<Aa83b23t00> aa83b23t00Lista = aa83b23t00Service.findAllLike(aa83b23t00, null, null);

				aa83b23t00 = aa83b23t00Lista.get(0);

				aa83bBusqueda.setId_sol(aa83b23t00.getId023().toString());
				aa83bBusqueda.setAno_sol(aa83b23t00.getIdAno023().toString());

				aa83bBusqueda.setNombre_sol(aa83b23t00.getNombre023());
				aa83bBusqueda.setApellido1_sol(aa83b23t00.getApel1023());
				aa83bBusqueda.setApellido2_sol(aa83b23t00.getApel2023());

				if (aa83b23t00.getFecha023() != null)
					aa83bBusqueda.setFecha(aa83b23t00.getFecha023());

				aa83bBusqueda.setNumero_dni(aa83b23t00.getNumDoc023());

				Aa83b03t00 aa83b03t00 = new Aa83b03t00();

				aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ESF));
				aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
				aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00).getTipoSol003());

				aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "+ aa83bBusqueda.getAno_sol() + " " + aa83bBusqueda.getId_sol());

				total++;
				responseGrid.add(aa83bBusqueda);
			} else if (String.valueOf(cierre.getId003tiposol()).equals(Aa83BConstants.COD_ARR)) {
				Aa83b25t00 aa83b25t00 = new Aa83b25t00();
				aa83b25t00.setId025(cierre.getIdsol());
				aa83b25t00.setIdAno025(cierre.getIdano());
				List<Aa83b25t00> aa83b25t00Lista = aa83b25t00Service.findAllLike(aa83b25t00, null, null);

				aa83b25t00 = aa83b25t00Lista.get(0);

				aa83bBusqueda.setId_sol(aa83b25t00.getId025().toString());
				aa83bBusqueda.setAno_sol(aa83b25t00.getIdAno025().toString());

				aa83bBusqueda.setNombre_sol(aa83b25t00.getNombre025());
				aa83bBusqueda.setApellido1_sol(aa83b25t00.getApel1025());
				aa83bBusqueda.setApellido2_sol(aa83b25t00.getApel2025());

				if (aa83b25t00.getFecha025() != null)
					aa83bBusqueda.setFecha(aa83b25t00.getFecha025());

				aa83bBusqueda.setNumero_dni(aa83b25t00.getNumDoc025());

				Aa83b03t00 aa83b03t00 = new Aa83b03t00();

				aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ARR));
				aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
				aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00).getTipoSol003());

				aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " " + aa83bBusqueda.getAno_sol() + " " + aa83bBusqueda.getId_sol());

				total++;
				responseGrid.add(aa83bBusqueda);
			}
		}
				
		/*for (int i = 0; i < aa83b09t00Lista.size(); i++) {
			Aa83b21t00 aa83b21t00 = new Aa83b21t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b21t00.setId021(aa83b09t00Lista.get(i).getId021NumSol());
			aa83b21t00.setIdAno021(aa83b09t00Lista.get(i).getIdAno021());

			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_2));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_2));
			aa83b02t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));

			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);

			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase().equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b21t00> aa83b21t00Lista = aa83b21t00Service.findAllLike(aa83b21t00, null, null);

			aa83b21t00 = aa83b21t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b21t00.getId021().toString());
			aa83bBusqueda.setAno_sol(aa83b21t00.getIdAno021().toString());

			aa83bBusqueda.setNombre_sol(aa83b21t00.getNombre021());
			aa83bBusqueda.setApellido1_sol(aa83b21t00.getApel1021());
			aa83bBusqueda.setApellido2_sol(aa83b21t00.getApel1021());

			if (aa83b21t00.getFecha021() != null)
				aa83bBusqueda.setFecha(aa83b21t00.getFecha021());

			aa83bBusqueda.setNumero_dni(aa83b21t00.getNumDoc021());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ADE));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00).getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "+ aa83bBusqueda.getAno_sol() + " " + aa83bBusqueda.getId_sol());

			total++;
			responseGrid.add(aa83bBusqueda);
		}

		for (int i = 0; i < aa83b10t00Lista.size(); i++) {
			Aa83b23t00 aa83b23t00 = new Aa83b23t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b23t00.setId023(Integer.parseInt(aa83b10t00Lista.get(i).getId023NumSol().toString()));
			aa83b23t00.setIdAno023(aa83b10t00Lista.get(i).getIdAno023());

			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_2));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_2));
			aa83b02t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));

			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);

			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase()
					.equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b23t00> aa83b23t00Lista = aa83b23t00Service.findAllLike(aa83b23t00, null, null);

			aa83b23t00 = aa83b23t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b23t00.getId023().toString());
			aa83bBusqueda.setAno_sol(aa83b23t00.getIdAno023().toString());

			aa83bBusqueda.setNombre_sol(aa83b23t00.getNombre023());
			aa83bBusqueda.setApellido1_sol(aa83b23t00.getApel1023());
			aa83bBusqueda.setApellido2_sol(aa83b23t00.getApel2023());

			if (aa83b23t00.getFecha023() != null)
				aa83bBusqueda.setFecha(aa83b23t00.getFecha023());

			aa83bBusqueda.setNumero_dni(aa83b23t00.getNumDoc023());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ESF));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00).getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "+ aa83bBusqueda.getAno_sol() + " " + aa83bBusqueda.getId_sol());

			total++;
			responseGrid.add(aa83bBusqueda);
		}

		for (int i = 0; i < aa83b11t00Lista.size(); i++) {
			Aa83b25t00 aa83b25t00 = new Aa83b25t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b25t00.setId025(Integer.parseInt(aa83b11t00Lista.get(i).getId025NumSol().toString()));
			aa83b25t00.setIdAno025(aa83b11t00Lista.get(i).getIdAnoSol025());

			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_2));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_2));
			aa83b02t00.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));

			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);

			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase().equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b25t00> aa83b25t00Lista = aa83b25t00Service.findAllLike(aa83b25t00, null, null);

			aa83b25t00 = aa83b25t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b25t00.getId025().toString());
			aa83bBusqueda.setAno_sol(aa83b25t00.getIdAno025().toString());

			aa83bBusqueda.setNombre_sol(aa83b25t00.getNombre025());
			aa83bBusqueda.setApellido1_sol(aa83b25t00.getApel1025());
			aa83bBusqueda.setApellido2_sol(aa83b25t00.getApel2025());

			if (aa83b25t00.getFecha025() != null)
				aa83bBusqueda.setFecha(aa83b25t00.getFecha025());

			aa83bBusqueda.setNumero_dni(aa83b25t00.getNumDoc025());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ARR));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00).getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00).getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " " + aa83bBusqueda.getAno_sol() + " " + aa83bBusqueda.getId_sol());

			total++;
			responseGrid.add(aa83bBusqueda);
		}*/

		// Paginamos:
		// this.totalGrid = responseGrid.size();
		List<Aa83bBusqueda> responseGridPaginado = new ArrayList<Aa83bBusqueda>();

		if (jqGridRequestDto.getPage() != 1) {
			// Paginamos
			int p = (int) ((jqGridRequestDto.getPage() - 1) * jqGridRequestDto.getRows());

			for (int pag = p; (pag < responseGrid.size()); pag++) {
				responseGridPaginado.add(responseGrid.get(pag));
			}

			// Miro si es la ultima página:
			if ((responseGrid.size() - (jqGridRequestDto.getPage() * jqGridRequestDto.getRows())) <= 0) {

			} else {
				if (jqGridRequestDto.getPage() != 1) {
					for (int pant = 0; pant < p; pant++)
						responseGridPaginado.add(responseGrid.get(pant));
				}
			}

		} else {
			responseGridPaginado = responseGrid;
		}

		// return responseGridPaginado;

		return new JQGridResponseDto<Aa83bBusqueda>(jqGridRequestDto,(long) (total), responseGridPaginado);
	}

	
	
	
/*	
	@RequestMapping(value = "solicitante/jgrid/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83b07v00> search(
			@RequestJsonBody(param = "filter") Aa83bBusqueda filterBusqueda,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request, HttpSession session) {

		MessageWriter messageWriter = new MessageWriter();

		messageWriter.startMessageList();

		messageWriter.addMessage("No se han encontrado Solicitudes que coincidan con los criterios de búsqueda");
		messageWriter.endMessageList();

		List<Aa83b07v00> responseGrid = new ArrayList<Aa83b07v00>();

		session.setAttribute("FILTRO_BUSQUEDA", filterBusqueda);

		responseGrid = this.busquedaStandardOrd(filterBusqueda, jqGridRequestDto,false, request, session);

		// Para guardar las claves que se han seleccionado y paginar en el detalle
		if (responseGrid.size()>0){
			List<String> pkList = new ArrayList<String>();
			int tam = responseGrid.size();
			Aa83b07v00 obj = null;
			for (int i = 0; i < tam; i++) {
				obj = (Aa83b07v00) responseGrid.get(i);
				pkList.add(obj.getTipoSol() + ":"+ obj.getIdAno() + ":" + obj.getIdSol());
			}
			// se crea una lista con las PK que se han recuperado
			jqGridRequestDto.getCore().setPkNames(pkList);
		}

		session.setAttribute("PAGINACION_BUSQUEDA", jqGridRequestDto);
		
		int total = this.totalGrid;

		return new JQGridResponseDto<Aa83b07v00>(jqGridRequestDto,(long) (total), responseGrid);
	}
*/
	@RequestMapping(value = "solicitud", method = RequestMethod.POST, produces = "application/json")
	public @ResponseBody
	Object buscaSolicitud(

			@RequestParam(value = "tipoSol", required = false) String comboTipoSol,
			@RequestParam(value = "numero_sol", required = false) String numero_Sol,
			HttpServletResponse response) throws IOException {

		MessageWriter messageWriter = new MessageWriter();

		messageWriter.startMessageList();
		messageWriter.addMessage("Las entidades se han enviado correctamente: " + comboTipoSol + "-" + numero_Sol);
		messageWriter.endMessageList();

		// Buscamos la solicitud

		ServletOutputStream servletOutputStream = response.getOutputStream();

		response.setContentType("text/plain");
		response.setCharacterEncoding("UTF-8");
		servletOutputStream.print(messageWriter.toString());
		response.flushBuffer();

		return null;
	}

	/**
	 * EXPORTERS
	 */
	@RequestMapping(value = "csvReport", method = RequestMethod.POST)
	protected ModelAndView getCSVReport(
			@ModelAttribute Aa83bBusqueda filterBusqueda,
			@ModelAttribute JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request, HttpSession session) {

		// Acceso a BD para recuperar datos
		// jqGridRequestDto.setPage(null);
		// jqGridRequestDto.setRows(null);
		// List<Busqueda> filter = this.jqGridUsuarioService.findAllLike(
		// filterUsuario, jqGridRequestDto, false);

		//List<Aa83bBusqueda> responseGrid = new ArrayList<Aa83bBusqueda>();

		//responseGrid = this.busquedaStandard(filterBusqueda, jqGridRequestDto,true, request, session);
		
		Aa83b07v00 objFiltro  = (Aa83b07v00) this.getObjetoAa83b07v00(filterBusqueda);
		
		// Si es Vivienda, incluyo la Fase a la que pueden acceder:
		String vivienda = "N";
		if (Aa83bUtilSeguridad.esVivienda("AA83B", request).equals("S")) {
			objFiltro.setIdFase(Aa83BConstants.COD_FASE_2);
			objFiltro.setIdTram(Aa83BConstants.COD_TRAM_1);
			vivienda = "S";
		}
		
		List<Aa83b07v00> listaAa83b07v00 =  this.aa83b07v00Service.findAllLike(objFiltro, jqGridRequestDto, false);
		

		// Nombre fichero
		modelMap.put("fileName", "datosCSV");
		// Datos
		ReportData<Aa83b07v00> reportData = new ReportData<Aa83b07v00>();
		// cabeceras hoja
		//Se quitan las tildes
		
		// Se borran las columnas que no se quieren sacar en el informe
		Map<String, String> columnsMatch = new HashMap<String, String>();
		// Eliminar columna
		columnsMatch.put("tipoSol", "");
		columnsMatch.put("idAno", "");
		columnsMatch.put("id", "");
		columnsMatch.put("fecAltaEs", "");
		reportData.setHeaderNames(ReportData.parseColumns(Aa83bUtilidades.tildesSinHtml(columns), columnsMatch));
		
		//reportData.setHeaderNames(ReportData.parseColumns(Aa83bUtilidades.tildesSinHtml(columns)));
		// datos hoja

		reportData.setModelData(listaAa83b07v00);
		modelMap.put("reportData", reportData);

		// Generación del CVS
		return new ModelAndView("csvReport", modelMap);
	}

	@RequestMapping(value="pdfReport")
	public ModelAndView generarPDFJasperReport(
			@ModelAttribute Aa83bBusqueda filterBusqueda,
			@ModelAttribute JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "isInline", required = false) boolean isInline, HttpServletRequest request, HttpSession session){
		
		Aa83b07v00 objFiltro  = (Aa83b07v00) this.getObjetoAa83b07v00(filterBusqueda);
		
		// Si es Vivienda, incluyo la Fase a la que pueden acceder:
		String vivienda = "N";
		if (Aa83bUtilSeguridad.esVivienda("AA83B", request).equals("S")) {
			objFiltro.setIdFase(Aa83BConstants.COD_FASE_2);
			objFiltro.setIdTram(Aa83BConstants.COD_TRAM_1);
			vivienda = "S";
		}
		
		List<Aa83b07v00> listaAa83b07v00 =  this.aa83b07v00Service.findAllLike(objFiltro, jqGridRequestDto, false);
		//Nombre fichero
		modelMap.put("fileName", "datosPDF");
		
		//En l�nea (no descarga fichero) ?
		modelMap.put("isInline", isInline);
		
		//Titulo y cabeceras (parameter)
		modelMap.put("TITULO", "Listado de expedientes");
		modelMap.put("COL_EXPEDIENTE", "Expediente");
		modelMap.put("COL_NOMBRE", "Nombre");
		modelMap.put("COL_APES", "Apellidos");
		modelMap.put("COL_FECHA", "Fecha");
		modelMap.put("COL_TRAMITE_ACTUAL", "Trmite actual");
		
		//Datos (field)
		modelMap.put("busquedas", listaAa83b07v00);
		
		//Generaci�n del PDF
		return new ModelAndView("pdfBusqueda", modelMap);
    }

	@RequestMapping(value = { "xlsReport", "xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getExcelPOI(
			@ModelAttribute Aa83bBusqueda filterBusqueda,
			@ModelAttribute JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request, HttpSession session) {

		Aa83b07v00 objFiltro  = (Aa83b07v00) this.getObjetoAa83b07v00(filterBusqueda);
		
		// Si es Vivienda, incluyo la Fase a la que pueden acceder:
		String vivienda = "N";
		if (Aa83bUtilSeguridad.esVivienda("AA83B", request).equals("S")) {
			objFiltro.setIdFase(Aa83BConstants.COD_FASE_2);
			objFiltro.setIdTram(Aa83BConstants.COD_TRAM_1);
			vivienda = "S";
		}
		
		List<Aa83b07v00> listaAa83b07v00 =  this.aa83b07v00Service.findAllLike(objFiltro, jqGridRequestDto, false);
		
		// Nombre fichero
		modelMap.put("fileName", "datosExcel");

		// Datos
		List<Object> reportData = new ArrayList<Object>();
		// Hoja 1
		ReportData<Aa83b07v00> usuarioExcelDataAll = new ReportData<Aa83b07v00>();
		// nombre hoja
		usuarioExcelDataAll.setSheetName("Todos los datos");
		// cabeceras hoja
		// Se borran las columnas que no se quieren sacar en el informe
		Map<String, String> columnsMatch = new HashMap<String, String>();
		// Eliminar columna
		columnsMatch.put("tipoSol", "");
		columnsMatch.put("idAno", "");
		columnsMatch.put("id", "");
		columnsMatch.put("fecAltaEs", "");
		usuarioExcelDataAll.setHeaderNames(ReportData.parseColumns(Aa83bUtilidades.tildesSinHtml(columns), columnsMatch));
		// datos hoja
		usuarioExcelDataAll.setModelData(listaAa83b07v00);
		reportData.add(usuarioExcelDataAll);
		// Hoja 2
		ReportData<Aa83b07v00> usuarioExcelDataPage = new ReportData<Aa83b07v00>();
		// nombre hoja
		usuarioExcelDataPage.setSheetName("datosExcel");
		// cabeceras hoja
		usuarioExcelDataPage.setHeaderNames(ReportData.parseColumns(Aa83bUtilidades.tildesSinHtml(columns)));
		// datos hoja
		usuarioExcelDataPage.setModelData(listaAa83b07v00);
		reportData.add(usuarioExcelDataPage);
		modelMap.put("reportData", reportData);

		// Generación del XLS o XLSX
		// String reportView = request.getServletPath().substring(9);
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
		// return new ModelAndView(reportView, modelMap);

	}

	Document document;
	DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

	public void makeFile() {
		try {
			DocumentBuilder builder = factory.newDocumentBuilder();
			// DOMImplementation implementation =
			// builder.getDOMImplementation();
			document = builder.newDocument();
			Node item = null;
			Document xmlDoc = document;
			Element root = xmlDoc.createElement("padre");
			// hijo
			item = xmlDoc.createElement("hijo");
			item.appendChild(xmlDoc.createTextNode("datoHijo"));
			// hijo de hijo
			Element elemento;
			Text text;
			elemento = xmlDoc.createElement("nieto");
			text = xmlDoc.createTextNode("dato Nieto");
			elemento.appendChild(text);
			item.appendChild(elemento);
			xmlDoc.appendChild(item);

			root.appendChild(item);
			xmlDoc.appendChild(root);

			System.out.println("el texto==>" + getStringFromDoc(xmlDoc));

			// Source source = new DOMSource(xmlDoc);
			// File xmlFile = new File("yourFile.xml");
			// StreamResult result = new StreamResult(new OutputStreamWriter(new
			// FileOutputStream(xmlFile), "ISO-8859-1"));
			// Transformer xformer =
			// TransformerFactory.newInstance().newTransformer();
			// xformer.transform(source, result);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static String getStringFromDoc(org.w3c.dom.Document doc) {
		try {
			DOMSource domSource = new DOMSource(doc);
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer transformer = tf.newTransformer();
			transformer.transform(domSource, result);
			writer.flush();
			return writer.toString();
		} catch (TransformerException ex)

		{ // ex.printStackTrace();
			return null;

		}

	}
	
	private  Aa83b07v00 getObjetoAa83b07v00 (Aa83bBusqueda filterBusqueda)
	{
		Aa83b07v00 aa83b07v00 = new Aa83b07v00();
		aa83b07v00.setNombre(filterBusqueda.getNombre_sol());
		aa83b07v00.setApel1(filterBusqueda.getApellido1_sol());
		aa83b07v00.setApel2(filterBusqueda.getApellido2_sol());
		aa83b07v00.setTipoDoc(filterBusqueda.getTipoDoc());
		aa83b07v00.setNumDoc(filterBusqueda.getNumero_dni());
		aa83b07v00.setNumReg(filterBusqueda.getNumReg());
		aa83b07v00.setId(filterBusqueda.getId_sol());
		aa83b07v00.setIdSol(filterBusqueda.getTipoSol());
		aa83b07v00.setIdAno(filterBusqueda.getAno_sol());
		//si esta chequeado no se muestran las cerradas
		if ("S".equals(filterBusqueda.getListCerradas())){
			aa83b07v00.setSoliCerrada("N");	
		}
		aa83b07v00.setFecDesde(filterBusqueda.getFecDesde());
		aa83b07v00.setFecHasta(filterBusqueda.getFecHasta());
		aa83b07v00.setIdFase(filterBusqueda.getIdfase());
		aa83b07v00.setIdTram(filterBusqueda.getIdtramite());		

		return aa83b07v00;
	}
}
