package com.ejie.aa83b.control;

import java.io.ByteArrayInputStream;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ejie.aa83b.exception.Aa83bErrorGenericoException;
import com.ejie.aa83b.model.Aa83b02t00;
import com.ejie.aa83b.model.Aa83b03t00;
import com.ejie.aa83b.model.Aa83b04t00;
import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b10t00;
import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83bBusqueda;
import com.ejie.aa83b.model.Aa83bBusquedaComunicaciones;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.model.Aa83bNotificacionCorreosDatosRemesa;

import com.ejie.aa83b.service.Aa83b02t00Service;
import com.ejie.aa83b.service.Aa83b03t00Service;
import com.ejie.aa83b.service.Aa83b04t00Service;
import com.ejie.aa83b.service.Aa83b06t00Service;
import com.ejie.aa83b.service.Aa83b07t00Service;
import com.ejie.aa83b.service.Aa83b08t00Service;
import com.ejie.aa83b.service.Aa83b09t00Service;
import com.ejie.aa83b.service.Aa83b10t00Service;
import com.ejie.aa83b.service.Aa83b11t00Service;
import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b23t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83bBusquedaComunicacionesService;
import com.ejie.aa83b.service.Aa83bNoraService;
import com.ejie.aa83b.service.Aa83bNotificacionesCorreosService;

import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSesionUtils;
import com.ejie.aa83b.util.Aa83bSolicitudesUtil;
import com.ejie.aa83b.util.Aa83bUtilPIF;
import com.ejie.aa83b.util.Aa83bUtilProperties;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContext;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContextParser;
import com.ejie.aa83b.util.tramita.Aa83bXmlException;
import com.ejie.aa83b.util.xml.Aa83bXMLGenerator;
import com.ejie.aa83b.webservice.client.aa19b.DocumentoWebServiceImpl;
import com.ejie.aa83b.webservice.client.r02.Q99RCPFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.vdc.Q99USendMessageSCPFacadeWSSoap;
import com.ejie.aa83b.webservice.client.y59.ArrayOfWSParamPerson;
import com.ejie.aa83b.webservice.client.y59.SistemaRegistroPresencialWSSoap;
import com.ejie.aa83b.webservice.client.y59.WSOutputRegister;
import com.ejie.aa83b.webservice.client.y59.WSParamOutputRegisterEx;
import com.ejie.aa83b.webservice.client.y59.WSParamPerson;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.json.MessageWriter;
import com.ejie.x38.reports.ReportData;
import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;

/**
 * PatronesController
 * 
 * @author UDA
 */
@Controller()
@RequestMapping(value = "/busquedaComunicaciones")
public class Aa83bBusquedaComunicacionesController {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Aa83bBusquedaComunicacionesController.class);

	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83bBusquedaComunicacionesController.logger.info("[GET - View] : Aa83bBusquedaComunicacionesController");
		return "busquedaComunicaciones";
	}

	/** The service. */

	@Autowired()
	private Aa83bBusquedaComunicacionesService aa83bBusquedaComunicacionesService;
	@Autowired()
	private Aa83b04t00Service aa83b04t00Service;

	private Integer totalGrid;

	@Autowired()
	private DocumentoWebServiceImpl documentoWebServiceImpl;

	@Autowired()
	private Q99RCPFacadeWSSoap q99RCPFacadeWSSoap;

	@Autowired()
	private Properties appConfiguration;
	
	/** The a83b nora service. */
	@Autowired()
	private Aa83bNoraService a83bNoraService;
	
	@Autowired()
	private Aa83b21t00Service aa83b21t00Service;

	@Autowired()
	private Aa83b23t00Service aa83b23t00Service;
	
	@Autowired()
	private Aa83b25t00Service aa83b25t00Service;
	
	@Autowired()
	private Aa83b09t00Service aa83b09t00Service;
	
	@Autowired()
	private Aa83b10t00Service aa83b10t00Service;
	
	@Autowired()
	private Aa83b11t00Service aa83b11t00Service;
	
	/** The service. */
	@Autowired()
	private Aa83b06t00Service aa83b06t00Service;

	/** The service. */
	@Autowired()
	private Aa83b07t00Service aa83b07t00Service;

	/** The service. */
	@Autowired()
	private Aa83b08t00Service aa83b08t00Service;
	
	/** The service. */
	@Autowired()
	private Aa83b02t00Service aa83b02t00Service;

	/** The service. */
	@Autowired()
	private Aa83b03t00Service aa83b03t00Service;
	
	
	@Autowired()
	private Q99USendMessageSCPFacadeWSSoap q99uSendMessageSCPFacadeWSSoap;
	
	@Autowired()
	private SistemaRegistroPresencialWSSoap sistemaRegistroPresencialWSSoap;
	
	@Autowired()
	private Aa83bNotificacionesCorreosService aa83bNotificacionesCorreosService;
	
	
	@RequestMapping(value = "jgrid/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<Aa83bBusquedaComunicaciones> search(
			@RequestJsonBody(param = "filter") Aa83bBusquedaComunicaciones filterBusqueda,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {

		MessageWriter messageWriter = new MessageWriter();

		messageWriter.startMessageList();

		messageWriter.addMessage("No se han encontrado comunicaciones que coincidan con los criterios de bsqueda");
		messageWriter.endMessageList();

		Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : search inicio=");

		List<Aa83bBusquedaComunicaciones> responseGrid = new ArrayList<Aa83bBusquedaComunicaciones>();

		Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : search voy a buscar=");

		responseGrid = this.busquedaStandard(filterBusqueda, jqGridRequestDto,false);

		int total = this.totalGrid;

		Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : search total="+ total);

		return new JQGridResponseDto<Aa83bBusquedaComunicaciones>(jqGridRequestDto, (long) (total), responseGrid);
		// resultB);
		// return null;
	}

	public List<Aa83bBusquedaComunicaciones> busquedaStandard(
			Aa83bBusquedaComunicaciones filterBusqueda,
			JQGridRequestDto jqGridRequestDto, Boolean excel) {

		int cont = 0;

		Aa83bBusquedaComunicaciones comunicacion = new Aa83bBusquedaComunicaciones();

		List<Aa83bBusquedaComunicaciones> comunicacionesList = new ArrayList<Aa83bBusquedaComunicaciones>();

		comunicacionesList = this.aa83bBusquedaComunicacionesService.findComunicaciones(filterBusqueda, null);

		cont = comunicacionesList.size();

		List<Aa83bBusquedaComunicaciones> responseGrid = new ArrayList<Aa83bBusquedaComunicaciones>();
		List<Aa83bBusquedaComunicaciones> responseGridPaginado = new ArrayList<Aa83bBusquedaComunicaciones>();

		int i = 0;
		for (i = 0; i < cont; i++) {

			Aa83bBusquedaComunicaciones resultado = new Aa83bBusquedaComunicaciones();
			comunicacion = comunicacionesList.get(i);
			resultado.setIdfase(comunicacion.getIdfase());
			resultado.setIdtramite(comunicacion.getIdtramite());
			resultado.setSolicitud(comunicacion.getSolicitud());
			resultado.setNombre(comunicacion.getNombre());
			resultado.setApellidos(comunicacion.getApellidos());
			resultado.setFecha(comunicacion.getFecha());
			resultado.setDescTramiteEs(comunicacion.getDescTramiteEs());
			resultado.setDescTramiteEu(comunicacion.getDescTramiteEu());
			responseGrid.add(resultado);
		}

		// Paginamos:

		this.totalGrid = responseGrid.size();
		if (!excel) {
			if (jqGridRequestDto.getPage() != 1) {
				// Paginamos
				int p = (int) ((jqGridRequestDto.getPage() - 1) * jqGridRequestDto.getRows());

				for (int pag = p; (pag < responseGrid.size()); pag++) {
					responseGridPaginado.add(responseGrid.get(pag));
				}

				// Miro si es la ultima pgina:
				if ((responseGrid.size() - (jqGridRequestDto.getPage() * jqGridRequestDto.getRows())) <= 0) {
					;
				} else {
					if (jqGridRequestDto.getPage() != 1) {
						for (int pant = 0; pant < p; pant++){
							responseGridPaginado.add(responseGrid.get(pant));
						}
					}
				}

			} else {
				responseGridPaginado = responseGrid;
			}
		} else {
			responseGridPaginado = responseGrid;
		}

		return responseGridPaginado;
	}

	/**
	 * EXPORTERS
	 */
	@RequestMapping(value = "csvReport", method = RequestMethod.POST)
	protected ModelAndView getCSVReport(
			@ModelAttribute() Aa83bBusquedaComunicaciones filterBusqueda,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns) {

		// Acceso a BD para recuperar datos
		// jqGridRequestDto.setPage(null);
		// jqGridRequestDto.setRows(null);
		// List<Busqueda> filter = this.jqGridUsuarioService.findAllLike(
		// filterUsuario, jqGridRequestDto, false);

		List<Aa83bBusquedaComunicaciones> responseGrid = new ArrayList<Aa83bBusquedaComunicaciones>();

		responseGrid = this.busquedaStandard(filterBusqueda, jqGridRequestDto,true);

		// Nombre fichero
		modelMap.put("fileName", "datosCSV");
		// Datos
		ReportData<Aa83bBusquedaComunicaciones> reportData = new ReportData<Aa83bBusquedaComunicaciones>();
		// cabeceras hoja
		reportData.setHeaderNames(ReportData.parseColumns(columns));
		// datos hoja

		reportData.setModelData(responseGrid);
		modelMap.put("reportData", reportData);

		// Generacin del CVS
		return new ModelAndView("csvReport", modelMap);
	}

	@RequestMapping(value = { "xlsReport", "xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getExcelPOI(
			@ModelAttribute() Aa83bBusquedaComunicaciones filterBusqueda,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) {

		List<Aa83bBusquedaComunicaciones> responseGrid = new ArrayList<Aa83bBusquedaComunicaciones>();

		responseGrid = this.busquedaStandard(filterBusqueda, jqGridRequestDto,true);

		// Nombre fichero
		modelMap.put("fileName", "datosExcel");

		// Datos
		List<Object> reportData = new ArrayList<Object>();
		// Hoja 1
		ReportData<Aa83bBusquedaComunicaciones> usuarioExcelDataAll = new ReportData<Aa83bBusquedaComunicaciones>();
		// nombre hoja
		usuarioExcelDataAll.setSheetName("Todos los datos");
		// cabeceras hoja
		usuarioExcelDataAll.setHeaderNames(ReportData.parseColumns(columns));
		// datos hoja
		usuarioExcelDataAll.setModelData(responseGrid);
		reportData.add(usuarioExcelDataAll);
		// Hoja 2
		ReportData<Aa83bBusquedaComunicaciones> usuarioExcelDataPage = new ReportData<Aa83bBusquedaComunicaciones>();
		// nombre hoja
		usuarioExcelDataPage.setSheetName("datosExcel");
		// cabeceras hoja
		usuarioExcelDataPage.setHeaderNames(ReportData.parseColumns(columns));
		// datos hoja
		usuarioExcelDataPage.setModelData(responseGrid);
		reportData.add(usuarioExcelDataPage);
		modelMap.put("reportData", reportData);

		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}

	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = { "acuses" }, method = RequestMethod.GET)
	protected void generarAcuses(ModelMap modelMap,
			@RequestParam(value = "seleccionados") ArrayList seleccionados,
			@RequestParam(value = "tramite") String tramite,
			@RequestParam(value = "fase") String fase,
			HttpServletResponse response) throws ParserConfigurationException, Aa83bXmlException, Aa83bErrorGenericoException, ParseException {

		// System.out.println("generarAcuses seleccionados.size()="+
		// seleccionados.size());
		Aa83bBusquedaComunicacionesController.logger.info("generarAcuses seleccionados.size()="
						+ seleccionados.size());
		
		Aa83bBusquedaComunicacionesController.logger.info("generarAcuses seleccionados="
				+ seleccionados);

		
		// Recuperamos la plantilla de la BD
		Aa83b04t00 plantilla = this.aa83b04t00Service.findTemplateByName("ACUSES");

		// Nombre fichero
		modelMap.put("fileName", plantilla.getNomTemplate004());

		// obtenemos el fichero guardado en el bean
		Blob fichero = plantilla.getTemplate004();

		// SI SE HA SUBIDO PREVIAMENTE UNA PLANTILLA
		if (fichero != null) {
			// System.out.println("generarAcuses fichero != null=");
			Aa83bBusquedaComunicacionesController.logger.info("generarAcuses fichero != null generarAcuses=");

			try {
				// DESARROLLO
				String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAcuses: sesionToken="	+ sesionToken);

				DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
				DocumentBuilder builder = factory.newDocumentBuilder();

				// DESARROLLO
				Document xmlSesionDocument = builder.parse(new ByteArrayInputStream(sesionToken.getBytes("UTF-8")));// NOPMD

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAcuses: xmlSesionDocument="+ xmlSesionDocument.getDocumentURI());
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAcuses: xmlSesionDocument="+ xmlSesionDocument.getInputEncoding());

				// INICIO Subimos la plantilla RTF a PIF
				String rutaDoc = Aa83bUtilProperties.PIF_PATH + "Plantilla"+ plantilla.getNomTemplate004() + ".rtf";
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAcuses gerutaDoc="+ rutaDoc);

				
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAcuses plantilla="+ plantilla.getPlantilla004());
				
				InputStream is = new ByteArrayInputStream(plantilla.getPlantilla004());// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAcuses is:"	+ is.toString());

				Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAcuses despues del service:");
				Y31AttachmentBean rdoRTF = service.put(xmlSesionDocument, is,rutaDoc, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAcuses despues del put");
				String pathPifPlantilla = rdoRTF.getFilePath();
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAcuses rutaRTF: "+ pathPifPlantilla);

				// FIN Subimos la plantilla RTF a PIF

				// seleccionados, vista 4
				ArrayList<Aa83bBusquedaComunicaciones> listaAcuses = new ArrayList<Aa83bBusquedaComunicaciones>();
				listaAcuses = (ArrayList<Aa83bBusquedaComunicaciones>) this.aa83bBusquedaComunicacionesService.findComunicacionesAcuses(seleccionados, fase, tramite);
				Aa83bBusquedaComunicacionesController.logger.info("generarAcuses acusesList=" + listaAcuses.size());

				
					
				for (int i =0;i<listaAcuses.size();i++)
				{
					Aa83bBusquedaComunicaciones aa83bBusquedaComunicaciones= (Aa83bBusquedaComunicaciones)listaAcuses.get(i);
					Aa83bBusquedaComunicacionesController.logger.info("aa83bBusquedaComunicaciones"+ aa83bBusquedaComunicaciones.getId_sol()+ " SDFSD--->"+ aa83bBusquedaComunicaciones.getSolicitud()+ " -_-->" + aa83bBusquedaComunicaciones.getReferencia());
					int espacio= aa83bBusquedaComunicaciones.getDomicilio().indexOf(" ");
					Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : Aa83bUtilidades.isNumeric(aa83bBusquedaComunicaciones.getDomicilio()=" + aa83bBusquedaComunicaciones.getDomicilio().substring(0,espacio)+"--------");
		
					if (Aa83bUtilidades.isNumeric(aa83bBusquedaComunicaciones.getDomicilio().substring(0,espacio)))
					{
						Aa83bCalle filterCalle = new Aa83bCalle();
						filterCalle.setCalle_cod(aa83bBusquedaComunicaciones.getDomicilio().substring(0,espacio));
						filterCalle = this.a83bNoraService.findCalle(filterCalle, null);
						listaAcuses.get(i).setCalle(filterCalle.getDs_o());
						listaAcuses.get(i).setDomicilio(filterCalle.getDs_o().concat(aa83bBusquedaComunicaciones.getDomicilio().substring(espacio)));
					}
					
					
						
					Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : listaAcuses.get(i).getDomicilio" + listaAcuses.get(i).getDomicilio());
					
					// cambio el estado del expediente
					
					
					
					
					
				}
				// GEnerar el xml xon los datos de los acuses seleccionados
				Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
				String cadenaXML = aa83bXMLGenerator.generateXMLAcuses(listaAcuses);
				// String cadenaXML = "/serapp/Vdatos/aa83b/file/ACUSES.xml";

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarRelacionAcuses: cadenaXML="+ cadenaXML);

				// INICIO Subimos el xml a PIF
				String rutaXML = Aa83bUtilProperties.PIF_PATH+ plantilla.getNomTemplate004() + ".xml";
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAcuses: rutaXML="	+ rutaXML);

				InputStream isXML = new ByteArrayInputStream(	cadenaXML.getBytes("UTF-8"));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAcuses isXML:"	+ isXML.toString());

				Y31AttachmentBean rdoXML = service.put(xmlSesionDocument,isXML, rutaXML, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAcuses despues del put");
				String pathPifXML = rdoXML.getFilePath();

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAcuses pathPifXML: "+ pathPifXML);
				// FIN Subimos el xml a PIF

				// Llamamos al metodo create de aa19
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAcuses: Llamamos al metodo create de aa19: ");
				String pathPifDocGenerado = Aa83bUtilProperties.PIF_PATH+ plantilla.getNomTemplate004() + ".doc";
				String ruta = "";
				try {
					ruta = this.documentoWebServiceImpl.create(pathPifXML,pathPifPlantilla, pathPifDocGenerado);
					Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAcuses: ruta: "+ ruta);
				} catch (Exception e) {
					Aa83bBusquedaComunicacionesController.logger
					.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
				}

				// REcuperamos el documento generado en PIF para visualizarlo
				InputStream ficheroDescargado = Aa83bUtilPIF.get(ruta);
				response.setContentType("application/vnd.ms-word");
				// response.setContentLength(ficheroDescargado.
				// documentoDevuelto.getTamanyo());
				response.setHeader("Content-disposition","attachment;filename=ACUSES." + "doc");
				int bytesReaded = 0;
				final int _1024 = 1024;
				ServletOutputStream out = response.getOutputStream();
				byte[] binaryBuffer = new byte[_1024];
				while ((bytesReaded = ficheroDescargado.read(binaryBuffer)) != -1) {
					out.write(binaryBuffer, 0, bytesReaded);
				}
				response.getOutputStream().flush();

			} catch (Y31JanoServiceGenericException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceFileNameFormatException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceMongoDbGenericException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceEventJmsException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceAccesDeniedException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (SAXException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (IOException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			}
		}
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = { "relacionAcuses" }, method = RequestMethod.GET)
	protected void generarRelacionAcuses(ModelMap modelMap,
			@RequestParam(value = "seleccionados") ArrayList seleccionados,
			@RequestParam(value = "tramite") String tramite,
			@RequestParam(value = "fase") String fase,
			HttpServletResponse response) throws ParserConfigurationException {

		// System.out.println("generarRelacionAcuses seleccionados.size()="+
		// seleccionados.size());
		Aa83bBusquedaComunicacionesController.logger.info("generarRelacionAcuses seleccionados.size()="	+ seleccionados.size());

		// Recuperamos la plantilla de la BD
		Aa83b04t00 plantilla = this.aa83b04t00Service.findTemplateByName("RELACUSES");

		// Nombre fichero
		modelMap.put("fileName", plantilla.getNomTemplate004());

		// obtenemos el fichero guardado en el bean
		Blob fichero = plantilla.getTemplate004();

		// SI SE HA SUBIDO PREVIAMENTE UNA PLANTILLA
		if (fichero != null) {
			// System.out.println("generarRelacionAcuses fichero != null=");
			Aa83bBusquedaComunicacionesController.logger.info("generarRelacionAcuses fichero != null=");

			try {
				// DESARROLLO
				String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarRelacionAcuses: sesionToken="	+ sesionToken);

				DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
				DocumentBuilder builder = factory.newDocumentBuilder();

				// DESARROLLO
				Document xmlSesionDocument = builder.parse(new ByteArrayInputStream(sesionToken.getBytes("UTF-8")));// NOPMD

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarRelacionAcuses: xmlSesionDocument="+ xmlSesionDocument.getDocumentURI());

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarRelacionAcuses: xmlSesionDocument="+ xmlSesionDocument.getInputEncoding());

				// INICIO Subimos la plantilla RTF a PIF
				String rutaDoc = Aa83bUtilProperties.PIF_PATH + "Plantilla"	+ plantilla.getNomTemplate004() + ".rtf";
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarRelacionAcuses: gerutaDoc="+ rutaDoc);

				InputStream is = new ByteArrayInputStream(plantilla.getPlantilla004());// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarRelacionAcuses is:"	+ is.toString());

				Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarRelacionAcuses despues del service:");
				Y31AttachmentBean rdoRTF = service.put(xmlSesionDocument, is,rutaDoc, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarRelacionAcuses despues del put");
				String pathPifPlantilla = rdoRTF.getFilePath();

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarRelacionAcuses rutaRTF: "+ pathPifPlantilla);

				// FIN Subimos la plantilla RTF a PIF

				// Buscamos los datos para los acuses de los registros
				// seleccionados, vista 4
				ArrayList<Aa83bBusquedaComunicaciones> listaRelAcuses = new ArrayList<Aa83bBusquedaComunicaciones>();
				listaRelAcuses = (ArrayList<Aa83bBusquedaComunicaciones>) this.aa83bBusquedaComunicacionesService.findComunicacionesAcuses(seleccionados, fase, tramite);
				Aa83bBusquedaComunicacionesController.logger.info("generarRelacionAcuses listaRelAcuses="+ listaRelAcuses.size());

				// GEnerar el xml xon los datos de los acuses seleccionados
				Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator
						.getInstance();
				String cadenaXML = aa83bXMLGenerator
						.generateXMLRelacionAcuses(listaRelAcuses);

				// INICIO Subimos el xml a PIF
				String rutaXML = Aa83bUtilProperties.PIF_PATH+ plantilla.getNomTemplate004() + ".xml";
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarRelacionAcuses: rutaXML="+ rutaXML);

				InputStream isXML = new ByteArrayInputStream(cadenaXML.getBytes("UTF-8"));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarRelacionAcuses isXML:"+ isXML.toString());

				Y31AttachmentBean rdoXML = service.put(xmlSesionDocument,isXML, rutaXML, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarRelacionAcuses despues del put");
				String pathPifXML = rdoXML.getFilePath();

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAcuses pathPifXML: "+ pathPifXML);
				// FIN Subimos el xml a PIF

				// Llamamos al metodo create de aa19
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarRelacionAcuses: Llamamos al metodo create de aa19: ");
				String pathPifDocGenerado = Aa83bUtilProperties.PIF_PATH+ plantilla.getNomTemplate004() + ".rtf";
				String ruta = "";

				try {
					ruta = this.documentoWebServiceImpl.create(pathPifXML,pathPifPlantilla, pathPifDocGenerado);
					Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarRelacionAcuses: ruta: "+ ruta);
				} catch (Exception e) {
					Aa83bBusquedaComunicacionesController.logger
					.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
				}

				// REcuperamos el documento generado en PIF para visualizarlo
				InputStream ficheroDescargado = Aa83bUtilPIF.get(ruta);
				response.setContentType("application/vnd.ms-word");
				// response.setContentLength(ficheroDescargado.
				// documentoDevuelto.getTamanyo());
				response.setHeader("Content-disposition","attachment;filename=RELACUSES." + "doc");
				int bytesReaded = 0;
				final int _1024 = 1024;
				ServletOutputStream out = response.getOutputStream();
				byte[] binaryBuffer = new byte[_1024];
				while ((bytesReaded = ficheroDescargado.read(binaryBuffer)) != -1) {
					out.write(binaryBuffer, 0, bytesReaded);
				}
				response.getOutputStream().flush();

			} catch (Y31JanoServiceGenericException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceFileNameFormatException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceMongoDbGenericException e) {
				Aa83bBusquedaComunicacionesController.logger.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceEventJmsException e) {
				Aa83bBusquedaComunicacionesController.logger.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceAccesDeniedException e) {
			} catch (SAXException e) {
				Aa83bBusquedaComunicacionesController.logger.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (IOException e) {
				Aa83bBusquedaComunicacionesController.logger.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			}

		}
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = { "etiquetas" }, method = RequestMethod.GET)
	protected void generarEtiquetas(ModelMap modelMap,
			@RequestParam(value = "seleccionados") ArrayList seleccionados,
			@RequestParam(value = "tramite") String tramite,
			@RequestParam(value = "fase") String fase,
			HttpServletResponse response) throws ParserConfigurationException {

		// System.out.println("generarAcuses seleccionados.size()="+
		// seleccionados.size());
		Aa83bBusquedaComunicacionesController.logger.info("generarEtiquetas seleccionados.size()="+ seleccionados.size());

		// Recuperamos la plantilla de la BD
		Aa83b04t00 plantilla = this.aa83b04t00Service.findTemplateByName("ETIQUETAS");

		// Nombre fichero
		modelMap.put("fileName", plantilla.getNomTemplate004());

		// obtenemos el fichero guardado en el bean
		Blob fichero = plantilla.getTemplate004();

		// SI SE HA SUBIDO PREVIAMENTE UNA PLANTILLA
		if (fichero != null) {
			// System.out.println("generarAcuses fichero != null=");
			Aa83bBusquedaComunicacionesController.logger.info("generarEtiquetas fichero != null generarEtiquetas=");

			try {

				// DESARROLLO
				String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetas: sesionToken="+ sesionToken);

				DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
				DocumentBuilder builder = factory.newDocumentBuilder();

				// DESARROLLO
				Document xmlSesionDocument = builder.parse(new ByteArrayInputStream(sesionToken.getBytes("UTF-8")));// NOPMD

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetas: xmlSesionDocument="+ xmlSesionDocument.getDocumentURI());
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetas: xmlSesionDocument="+ xmlSesionDocument.getInputEncoding());

				// INICIO Subimos la plantilla RTF a PIF
				String rutaDoc = Aa83bUtilProperties.PIF_PATH + "Plantilla"+ plantilla.getNomTemplate004() + ".rtf";
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetas gerutaDoc="+ rutaDoc);

				InputStream is = new ByteArrayInputStream(plantilla.getPlantilla004());// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetas is:"+ is.toString());

				Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetas despues del service:");
				Y31AttachmentBean rdoRTF = service.put(xmlSesionDocument, is,rutaDoc, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetas despues del put");
				String pathPifPlantilla = rdoRTF.getFilePath();

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetas rutaRTF: "
								+ pathPifPlantilla);

				// FIN Subimos la plantilla RTF a PIF

				// Buscamos los datos para los acuses de los registros
				// seleccionados, vista 4
				ArrayList<Aa83bBusquedaComunicaciones> listaEtiquetas = new ArrayList<Aa83bBusquedaComunicaciones>();
				listaEtiquetas = (ArrayList<Aa83bBusquedaComunicaciones>) this.aa83bBusquedaComunicacionesService.findComunicacionesAcuses(seleccionados, fase, tramite);
				Aa83bBusquedaComunicacionesController.logger.info("generarEtiquetas listaEtiquetas="+ listaEtiquetas.size());

				// GEnerar el xml xon los datos de los acuses seleccionados
				Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
				String cadenaXML = aa83bXMLGenerator.generateXMLEtiquetas(listaEtiquetas);

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetas: cadenaXML="+ cadenaXML);

				// INICIO Subimos el xml a PIF
				String rutaXML = Aa83bUtilProperties.PIF_PATH
						+ plantilla.getNomTemplate004() + ".xml";
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetas: rutaXML="+ rutaXML);

				InputStream isXML = new ByteArrayInputStream(cadenaXML.getBytes("UTF-8"));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetas isXML:"+ isXML.toString());

				Y31AttachmentBean rdoXML = service.put(xmlSesionDocument,isXML, rutaXML, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetas despues del put");
				String pathPifXML = rdoXML.getFilePath();

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetas pathPifXML: "+ pathPifXML);
				// FIN Subimos el xml a PIF

				// Llamamos al metodo create de aa19
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetas: Llamamos al metodo create de aa19: ");
				String pathPifDocGenerado = Aa83bUtilProperties.PIF_PATH+ plantilla.getNomTemplate004() + ".rtf";
				String ruta = "";
				try {

					ruta = this.documentoWebServiceImpl.create(pathPifXML,pathPifPlantilla, pathPifDocGenerado);
					Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetas: ruta: "+ ruta);
				} catch (Exception e) {
					Aa83bBusquedaComunicacionesController.logger
					.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
				}

				// REcuperamos el documento generado en PIF para visualizarlo
				InputStream ficheroDescargado = Aa83bUtilPIF.get(ruta);
				response.setContentType("application/vnd.ms-word");
				// response.setContentLength(ficheroDescargado.
				// documentoDevuelto.getTamanyo());
				response.setHeader("Content-disposition","attachment;filename=ETIQUETAS." + "doc");
				int bytesReaded = 0;
				final int _1024 = 1024;
				ServletOutputStream out = response.getOutputStream();
				byte[] binaryBuffer = new byte[_1024];
				while ((bytesReaded = ficheroDescargado.read(binaryBuffer)) != -1) {
					out.write(binaryBuffer, 0, bytesReaded);
				}
				response.getOutputStream().flush();

			} catch (Y31JanoServiceGenericException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceFileNameFormatException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceMongoDbGenericException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceEventJmsException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceAccesDeniedException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (SAXException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (IOException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			}
		}
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = { "etiquetasCarpetas" }, method = RequestMethod.GET)
	protected void generarEtiquetasCarpetas(ModelMap modelMap,
			@RequestParam(value = "seleccionados") ArrayList seleccionados,
			@RequestParam(value = "tramite") String tramite,
			@RequestParam(value = "fase") String fase,
			HttpServletResponse response) throws ParserConfigurationException {

		// System.out.println("generarAcuses seleccionados.size()="+
		// seleccionados.size());
		Aa83bBusquedaComunicacionesController.logger.info("generarEtiquetasCarpetas seleccionados.size()="+ seleccionados.size());

		// Recuperamos la plantilla de la BD
		Aa83b04t00 plantilla = this.aa83b04t00Service.findTemplateByName("ETIQUETASCARPETAS");

		// Nombre fichero
		modelMap.put("fileName", plantilla.getNomTemplate004());

		// obtenemos el fichero guardado en el bean
		Blob fichero = plantilla.getTemplate004();

		// SI SE HA SUBIDO PREVIAMENTE UNA PLANTILLA
		if (fichero != null) {
			// System.out.println("generarAcuses fichero != null=");
			Aa83bBusquedaComunicacionesController.logger.info("generarEtiquetasCarpetas fichero != null generarEtiquetas=");

			try {

				// DESARROLLO
				String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetasCarpetas: sesionToken="+ sesionToken);

				DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
				DocumentBuilder builder = factory.newDocumentBuilder();

				// DESARROLLO
				Document xmlSesionDocument = builder.parse(new ByteArrayInputStream(sesionToken.getBytes("UTF-8")));// NOPMD

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetasCarpetas: xmlSesionDocument="+ xmlSesionDocument.getDocumentURI());

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetasCarpetas: xmlSesionDocument="+ xmlSesionDocument.getInputEncoding());

				// INICIO Subimos la plantilla RTF a PIF
				String rutaDoc = Aa83bUtilProperties.PIF_PATH + "Plantilla"+ plantilla.getNomTemplate004() + ".rtf";
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetasCarpetas gerutaDoc="+ rutaDoc);

				InputStream is = new ByteArrayInputStream(plantilla.getPlantilla004());// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetasCarpetas is:"+ is.toString());

				Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetasCarpetas despues del service:");
				Y31AttachmentBean rdoRTF = service.put(xmlSesionDocument, is,rutaDoc, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetasCarpetas despues del put");
				String pathPifPlantilla = rdoRTF.getFilePath();

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetasCarpetas rutaRTF: "+ pathPifPlantilla);

				// FIN Subimos la plantilla RTF a PIF

				// Buscamos los datos para los acuses de los registros
				// seleccionados, vista 4
				ArrayList<Aa83bBusquedaComunicaciones> listaEtiquetasCarpetas = new ArrayList<Aa83bBusquedaComunicaciones>();
				listaEtiquetasCarpetas = (ArrayList<Aa83bBusquedaComunicaciones>) this.aa83bBusquedaComunicacionesService.findComunicacionesAcuses(seleccionados, fase, tramite);
				Aa83bBusquedaComunicacionesController.logger.info("generarEtiquetasCarpetas listaEtiquetasCarpetas="+ listaEtiquetasCarpetas.size());

				// GEnerar el xml xon los datos de los acuses seleccionados
				Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
				String cadenaXML = aa83bXMLGenerator.generateXMLEtiquetasCarpetas(listaEtiquetasCarpetas);

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetasCarpetas: cadenaXML="+ cadenaXML);

				// INICIO Subimos el xml a PIF
				String rutaXML = Aa83bUtilProperties.PIF_PATH+ plantilla.getNomTemplate004() + ".xml";
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetasCarpetas: rutaXML="+ rutaXML);

				InputStream isXML = new ByteArrayInputStream(cadenaXML.getBytes("UTF-8"));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetasCarpetas isXML:"+ isXML.toString());

				Y31AttachmentBean rdoXML = service.put(xmlSesionDocument,isXML, rutaXML, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetasCarpetas despues del put");
				String pathPifXML = rdoXML.getFilePath();

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarEtiquetasCarpetas pathPifXML: "+ pathPifXML);
				// FIN Subimos el xml a PIF

				// Llamamos al metodo create de aa19
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetasCarpetas: Llamamos al metodo create de aa19: ");
				String pathPifDocGenerado = Aa83bUtilProperties.PIF_PATH+ plantilla.getNomTemplate004() + ".rtf";
				String ruta = "";
				try {

					ruta = this.documentoWebServiceImpl.create(pathPifXML,pathPifPlantilla, pathPifDocGenerado);
					Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarEtiquetasCarpetas: ruta: "+ ruta);
				} catch (Exception e) {
					Aa83bBusquedaComunicacionesController.logger
					.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
				}

				// REcuperamos el documento generado en PIF para visualizarlo
				InputStream ficheroDescargado = Aa83bUtilPIF.get(ruta);
				response.setContentType("application/vnd.ms-word");
				// response.setContentLength(ficheroDescargado.
				// documentoDevuelto.getTamanyo());
				response.setHeader("Content-disposition","attachment;filename=ETIQUETASCARPETAS." + "doc");
				int bytesReaded = 0;
				final int _1024 = 1024;
				ServletOutputStream out = response.getOutputStream();
				byte[] binaryBuffer = new byte[_1024];
				while ((bytesReaded = ficheroDescargado.read(binaryBuffer)) != -1) {
					out.write(binaryBuffer, 0, bytesReaded);
				}
				response.getOutputStream().flush();

			} catch (Y31JanoServiceGenericException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceFileNameFormatException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceMongoDbGenericException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceEventJmsException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceAccesDeniedException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (SAXException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (IOException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			}
		}
	}

	/**
	 * @param modelMap ModelMap
	 * @param seleccionados ArrayList
	 * @param tramite String
	 * @param fase String
	 * @param response HttpServletResponse
	 * @throws ParserConfigurationException e
	 * @throws Aa83bXmlException e
	 * @throws Aa83bErrorGenericoException e
	 * @throws ParseException e
	 */
	@SuppressWarnings( value={"rawtypes", "unchecked" })
	@RequestMapping(value = { "adjuntoRemito" }, method = RequestMethod.GET)
	protected void generarAdjuntoRemito(ModelMap modelMap,
			@RequestParam(value = "seleccionados") ArrayList seleccionados,
			@RequestParam(value = "tramite") String tramite,
			@RequestParam(value = "fase") String fase,
			HttpServletResponse response) throws ParserConfigurationException, Aa83bXmlException, Aa83bErrorGenericoException, ParseException {

		// System.out.println("generarAcuses seleccionados.size()="+
		// seleccionados.size());
		Aa83bBusquedaComunicacionesController.logger.info("generarAdjuntoRemito seleccionados------>="+ seleccionados);
		Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] tramite= "+ tramite);
		Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] fase= "+ fase);

		// Recuperamos la plantilla de la BD
		Aa83b04t00 plantilla = this.aa83b04t00Service.findTemplateByName("ADJUNTOREMITO");

		// Nombre fichero
		modelMap.put("fileName", plantilla.getNomTemplate004());

		// obtenemos el fichero guardado en el bean
		Blob fichero = plantilla.getTemplate004();

		// SI SE HA SUBIDO PREVIAMENTE UNA PLANTILLA
		if (fichero != null) {
			// System.out.println("generarAcuses fichero != null=");
			Aa83bBusquedaComunicacionesController.logger.info("generarAdjuntoRemito fichero != null generarEtiquetas="+ System.currentTimeMillis());
			try {
				// DESARROLLO
				String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
				// Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: sesionToken="+
				// sesionToken);

				Aa83bBusquedaComunicacionesController.logger.info("sesionToken-->"+ sesionToken);
				Aa83bConsultationContextParser resParser = new Aa83bConsultationContextParser();
				Aa83bConsultationContext res = new Aa83bConsultationContext();
				String idProcedimiento = this.appConfiguration.getProperty("procedure.adecuacion.id");
				Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();

				
				DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
				DocumentBuilder builder = factory.newDocumentBuilder();

				String idProcAdecuacion = this.appConfiguration.getProperty("procedure.adecuacion.id");
				String idProcEsfuerzo = this.appConfiguration.getProperty("procedure.esfuerzo.id");
				String idProcArraigo = this.appConfiguration.getProperty("procedure.arraigo.id");
				
				
				String procedureAdecuacion="";
				String procedureEsfuerzo="";
				String procedureArraigo="";
				

				// llamada al getProcedureFac para recuperar los datos del
				// procedimiento

				try{
					procedureAdecuacion = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcAdecuacion);
					procedureEsfuerzo = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcEsfuerzo);
					procedureArraigo = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcArraigo);

					Aa83bBusquedaComunicacionesController.logger.info("procedureAdecuacion-->"+ procedureAdecuacion);
					Aa83bBusquedaComunicacionesController.logger.info("procedureEsfuerzo-->"+ procedureEsfuerzo);
					Aa83bBusquedaComunicacionesController.logger.info("procedureArraigo-->"+ procedureArraigo);
										
					try {
						//  se utiliza para escribir en el xml el managing_unit_id y el managing_unit_name, que es el mismo para los
						// tres tipo de solicitudes, por eso se recoge solamente con el de adecuacion
						resParser = new Aa83bConsultationContextParser(procedureAdecuacion);
					} catch (Aa83bXmlException e) {
						e.printStackTrace();
					} catch (Aa83bErrorGenericoException e) {
						e.printStackTrace();
					} catch (ParseException e) {
						e.printStackTrace();
					}
					res = resParser.getProcedureDataAll();
					
				}catch (Exception e) {
					Aa83bBusquedaComunicacionesController.logger.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
				}
				
				// DESARROLLO
				ByteArrayInputStream inputStream = new ByteArrayInputStream(sesionToken.getBytes("UTF-8"));
				Aa83bBusquedaComunicacionesController.logger.info("\n\n[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: inputStream="+ inputStream);				
				Document xmlSesionDocument = builder.parse(inputStream);// NOPMD

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: xmlSesionDocument="+ xmlSesionDocument.getDocumentURI()+"-fecha-->" + System.currentTimeMillis());
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] v: xmlSesionDocument="+ xmlSesionDocument.getInputEncoding());

				// INICIO Subimos la plantilla RTF a PIF
				String rutaDoc = Aa83bUtilProperties.PIF_PATH + "Plantilla"+ plantilla.getNomTemplate004() + ".rtf";
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAdjuntoRemito gerutaDoc="+ rutaDoc);

				InputStream is = new ByteArrayInputStream(plantilla.getPlantilla004());// NOPMD
				// Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAdjuntoRemito is:"+
				// is.toString());

				Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();

				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAdjuntoRemito despues del service:");
				Y31AttachmentBean rdoRTF = service.put(xmlSesionDocument, is,rutaDoc, new Long(Aa83BConstants.CIENTOVEINTE));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAdjuntoRemito despues del put  -fecha-->" + System.currentTimeMillis());

				// FIN Subimos la plantilla RTF a PIF

				// Inicio Libro de registro
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: Inscripcion en el libro de registro: ");

				String userNif = Aa83bSesionUtils.getUserNif();
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] userNif= "+ userNif);
				String userFullName = Aa83bSesionUtils.getUserFullName();
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] userFullName= "+ userFullName);

				String managingIdHAB=procedureAdecuacion.substring(procedureAdecuacion.indexOf("<managingUnitId>")+Aa83BConstants.DIECISEIS, procedureAdecuacion.indexOf("</managingUnitId>"));
				
				String managingIdESF=procedureEsfuerzo.substring(procedureEsfuerzo.indexOf("<managingUnitId>")+Aa83BConstants.DIECISEIS, procedureEsfuerzo.indexOf("</managingUnitId>"));
				
				String managingIdARR=procedureArraigo.substring(procedureArraigo.indexOf("<managingUnitId>")+Aa83BConstants.DIECISEIS, procedureArraigo.indexOf("</managingUnitId>"));

/*				pos1=procedureAdecuacion.indexOf("<managingUnitName>");
				pos2=procedureAdecuacion.indexOf("</managingUnitName>");
				String managingUnitHAB=procedureAdecuacion.substring(pos1+Aa83BConstants.DIECIOCHO, pos2);
				
				pos1=procedureArraigo.indexOf("<managingUnitName>");
				pos2=procedureArraigo.indexOf("</managingUnitName>");
				String managingUnitARR=procedureArraigo.substring(pos1+Aa83BConstants.DIECIOCHO, pos2);
				
				pos1=procedureEsfuerzo.indexOf("<managingUnitName>");
				pos2=procedureEsfuerzo.indexOf("</managingUnitName>");
				String managingUnitESF=procedureEsfuerzo.substring(pos1+Aa83BConstants.DIECIOCHO, pos2);
				
				
				pos1=procedureAdecuacion.indexOf("<procedureName>");
				pos2=procedureAdecuacion.indexOf("</procedureName>");
				String procedureNameHAB=procedureAdecuacion.substring(pos1+Aa83BConstants.QUINCE, pos2);

				
				pos1=procedureEsfuerzo.indexOf("<procedureName>");
				pos2=procedureEsfuerzo.indexOf("</procedureName>");
				String procedureNameESF=procedureEsfuerzo.substring(pos1+Aa83BConstants.QUINCE, pos2);
				
				pos1=procedureArraigo.indexOf("<procedureName>");
				pos2=procedureArraigo.indexOf("</procedureName>");
				String procedureNameARR=procedureArraigo.substring(pos1+Aa83BConstants.QUINCE, pos2);*/
				
				
				
				 aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
				// Recuperar los datos del procedimiento para cada tipo de
				// solicitud
				
				/*String sXmlContextRegistryHAB = aa83bXMLGenerator.sXmlContextRegistryHAB(idProcAdecuacion, procedureNameHAB, userNif, userFullName, managingIdHAB, managingUnitHAB);
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] sXmlContextRegistryHAB= "+ sXmlContextRegistryHAB);
				String sXmlContextRegistryESF = aa83bXMLGenerator.sXmlContextRegistryESF(idProcEsfuerzo, procedureNameESF, userNif, userFullName, managingIdESF,managingUnitESF);
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] sXmlContextRegistryESF= "+ sXmlContextRegistryESF);
				String sXmlContextRegistryARR = aa83bXMLGenerator.sXmlContextRegistryARR(idProcArraigo, procedureNameARR, userNif, userFullName, managingIdARR,managingUnitARR);
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] sXmlContextRegistryARR= "+ sXmlContextRegistryARR);
*/
				
				HashMap<String, String> seleccionadosResgistro = new HashMap(); // Cada
																				// uno
																				// de
																				// los
																				// seleccionados
																				// con
																				// sun
																				// NumEntrada
																				// del
																				// registro
				/*try {
					 Por cada solicitud seleccionada, hay q crear una entrada
					 en el libro, dependiendo del tipo HAB, ARR, ESF
					Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] seleccionados.size()= "+ seleccionados.size()+"-fecha-->" + System.currentTimeMillis());

					for (int i = 0; i < seleccionados.size(); i++) {
						tipo = ((String) seleccionados.get(i)).substring(0, 3);
						
						
						
						Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] i: "+ i);
						Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] TIPO: "+ tipo+ "-fecha-->" + System.currentTimeMillis());
						String matter="";
						if (fase.equals(Aa83BConstants.COD_FASE_1) && (tramite.equals(Aa83BConstants.COD_TRAM_2)))
						{
							matter=Aa83bUtilProperties.getProperty(DOC_REQ_SUB_ADE_TITULO);
						}else
							matter=Aa83bUtilProperties.getProperty(DOC_INF_RESOL_TITULO);
						}
						if ("HAB".equals(tipo)) {
							
								
							entryRegistry = this.q99DSRTFacadeWSSoap.createExitRegistry(sesionToken,sXmlContextRegistryHAB);
							sistemaRegistroPresencialWSSoap.wsNewOutputRegister(datas);
						} else if ("ESF".equals(tipo)) {
							entryRegistry = this.q99DSRTFacadeWSSoap.createExitRegistry(sesionToken,sXmlContextRegistryESF);
						} else if ("ARR".equals(tipo)) {
							entryRegistry = this.q99DSRTFacadeWSSoap.createExitRegistry(sesionToken,sXmlContextRegistryARR);
						}
						Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: entryRegistry="+ entryRegistry+ "-fecha-->" + System.currentTimeMillis());

						// REcupero el registryNumber
						Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] REcupero el registryNumber: ");
						int posicion1 = entryRegistry.indexOf("<registryNumber>");
						int posicion2 = entryRegistry.indexOf("</registryNumber>");
						entryRegistry = entryRegistry.substring(posicion1 + 16,posicion2);
						Aa83bBusquedaComunicacionesController.logger.info("******entryRegistry: " + entryRegistry);
						Aa83bBusquedaComunicacionesController.logger.info("******(String)seleccionados.get(i): "+ (String) seleccionados.get(i));
						String ref = ((String) seleccionados.get(i)).replace(" ", "/");
						seleccionadosResgistro.put(ref, entryRegistry);
						
						
					}
				} catch (Exception e) {
					Aa83bBusquedaComunicacionesController.logger.error("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: EXCEPCION Inscripcion en el libro de registro: ="+ e.toString());
					
				}*/
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] seleccionadosResgistro()= "+ seleccionadosResgistro.size()+ "-fecha-->" + System.currentTimeMillis());

				// Fin Libro de registro

				// Buscamos los datos para los adjunto remito de los registros
				// seleccionados, vista 4
				ArrayList<Aa83bBusquedaComunicaciones> listaAdjuntoRemito = new ArrayList<Aa83bBusquedaComunicaciones>();
				listaAdjuntoRemito = (ArrayList<Aa83bBusquedaComunicaciones>) this.aa83bBusquedaComunicacionesService.findComunicacionesAcuses(seleccionados, fase, tramite);
				Aa83bBusquedaComunicacionesController.logger.info("generarEtiquetasCarpetas generarAdjuntoRemito="+ listaAdjuntoRemito.size());
				
				String matter = this.getMatter(fase, tramite);
			
				// GEnerar el xml xon los datos de los acuses seleccionados
				for (int i = 0; i < listaAdjuntoRemito.size(); i++) {
					Aa83bBusquedaComunicaciones aa83bBusquedaComunicaciones = ((Aa83bBusquedaComunicaciones) listaAdjuntoRemito.get(i));
				
					Aa83b21t00 aa83b21t00 = new Aa83b21t00();
					Aa83b23t00 aa83b23t00 = new Aa83b23t00();
					Aa83b25t00 aa83b25t00 = new Aa83b25t00();
					if (aa83bBusquedaComunicaciones.getSolicitud().substring(0, Aa83BConstants.TRES).equals(Aa83BConstants.COD_ADE_STR))
					{
						if (aa83bBusquedaComunicaciones.getSolicitud().length()== Aa83BConstants.DIEZ) {
							aa83b21t00.setId021(Integer.valueOf(aa83bBusquedaComunicaciones.getSolicitud().substring(Aa83BConstants.NUEVE, Aa83BConstants.DIEZ)));
						} else { 
							aa83b21t00.setId021(Integer.valueOf(aa83bBusquedaComunicaciones.getSolicitud().substring(Aa83BConstants.NUEVE, Aa83BConstants.ONCE)));
						}
						aa83b21t00.setIdAno021(Long.valueOf(aa83bBusquedaComunicaciones.getSolicitud().substring(Aa83BConstants.CUATRO, Aa83BConstants.OCHO)));
						aa83b21t00 = this.aa83b21t00Service.find(aa83b21t00);
						Aa83bBusquedaComunicacionesController.logger.info("aa83b21t00 listaAdjuntoRemito -------->"+ aa83b21t00);
						idProcedimiento = this.appConfiguration.getProperty("procedure.adecuacion.id");
						WSParamOutputRegisterEx wsParamOutputRegisterEx = new WSParamOutputRegisterEx();
						wsParamOutputRegisterEx.setUnitCode(managingIdHAB);
						wsParamOutputRegisterEx.setSender(managingIdHAB);
						wsParamOutputRegisterEx.setMatter(matter);
						Aa83bBusquedaComunicacionesController.logger.info("wsParamOutputRegisterEx matter; -------->"+ matter);
						WSParamPerson wsperson= new WSParamPerson();
						wsperson.setPersonName(aa83b21t00.getNombre021()+ ""+aa83b21t00.getApel1021() +"" + aa83b21t00.getApel2021());
						ArrayOfWSParamPerson array = new ArrayOfWSParamPerson();
						array.getWSParamPerson();
						array.add(wsperson);
						wsParamOutputRegisterEx.setPersons(array);
						Aa83bBusquedaComunicacionesController.logger.info("wsParamOutputRegisterEx.toString(); -------->"+ wsParamOutputRegisterEx);
						Aa83bBusquedaComunicacionesController.logger.info("wsParamOutputRegisterEx.toString(); ------->"+ wsParamOutputRegisterEx.getMatter());
						WSOutputRegister registro= this.sistemaRegistroPresencialWSSoap.wsNewOutputRegister(wsParamOutputRegisterEx);
						Aa83bBusquedaComunicacionesController.logger.info("registro -------->"+ registro.getNumber());
						aa83b23t00=null;
						aa83b25t00=null;
						seleccionadosResgistro.put(Aa83BConstants.COD_ADE_STR+"/"+aa83b21t00.getIdAno021()+ "/"+ aa83b21t00.getId021(), registro.getNumber());
							
					}
					else if (aa83bBusquedaComunicaciones.getSolicitud().substring(0, Aa83BConstants.TRES).equals(Aa83BConstants.COD_ESF_STR))
					{
						if (aa83bBusquedaComunicaciones.getSolicitud().length()== Aa83BConstants.DIEZ) {
							aa83b23t00.setId023(Integer.valueOf(aa83bBusquedaComunicaciones.getSolicitud().substring(Aa83BConstants.NUEVE, Aa83BConstants.DIEZ)));
						} else {
							aa83b23t00.setId023(Integer.valueOf(aa83bBusquedaComunicaciones.getSolicitud().substring(Aa83BConstants.NUEVE, Aa83BConstants.ONCE)));
						}
						aa83b23t00.setIdAno023(Long.valueOf(aa83bBusquedaComunicaciones.getSolicitud().substring(Aa83BConstants.CUATRO, Aa83BConstants.OCHO)));
						aa83b23t00 = this.aa83b23t00Service.find(aa83b23t00);
						Aa83bBusquedaComunicacionesController.logger.info("aa83b23t00 listaAdjuntoRemito -------->"+ aa83b23t00);
						idProcedimiento = this.appConfiguration.getProperty("procedure.esfuerzo.id");
						WSParamOutputRegisterEx wsParamOutputRegisterEx = new WSParamOutputRegisterEx();
						wsParamOutputRegisterEx.setUnitCode(managingIdESF);
						wsParamOutputRegisterEx.setSender(managingIdESF);
						wsParamOutputRegisterEx.setMatter(matter);
						Aa83bBusquedaComunicacionesController.logger.info("wsParamOutputRegisterEx matter); -------->"+ matter);
						WSParamPerson wsperson= new WSParamPerson();
						wsperson.setPersonName(aa83b23t00.getNombre023()+ ""+aa83b23t00.getApel1023() +"" + aa83b23t00.getApel2023());
						ArrayOfWSParamPerson array = new ArrayOfWSParamPerson();
						array.getWSParamPerson();
						array.add(wsperson);
						wsParamOutputRegisterEx.setPersons(array);
						Aa83bBusquedaComunicacionesController.logger.info("wsParamOutputRegisterEx.toString(); -------->"+ wsParamOutputRegisterEx);
						Aa83bBusquedaComunicacionesController.logger.info("wsParamOutputRegisterEx.toString(); -------->"+ wsParamOutputRegisterEx.getMatter());
						WSOutputRegister registro=this.sistemaRegistroPresencialWSSoap.wsNewOutputRegister(wsParamOutputRegisterEx);
						Aa83bBusquedaComunicacionesController.logger.info("registro -------->"+ registro.getNumber());
						aa83b21t00=null;
						aa83b25t00=null;
						seleccionadosResgistro.put(Aa83BConstants.COD_ESF_STR+"/"+aa83b23t00.getIdAno023()+ "/"+ aa83b23t00.getId023(), registro.getNumber());
							
					}
					else if (aa83bBusquedaComunicaciones.getSolicitud().substring(0, Aa83BConstants.TRES).equals(Aa83BConstants.COD_ARR_STR))
					{
						if (aa83bBusquedaComunicaciones.getSolicitud().length()==Aa83BConstants.DIEZ){
							aa83b25t00.setId025(Integer.valueOf(aa83bBusquedaComunicaciones.getSolicitud().substring(Aa83BConstants.NUEVE, Aa83BConstants.DIEZ)));
						} else {
							aa83b25t00.setId025(Integer.valueOf(aa83bBusquedaComunicaciones.getSolicitud().substring(Aa83BConstants.NUEVE, Aa83BConstants.ONCE)));
						}
						aa83b25t00.setIdAno025(Long.valueOf(aa83bBusquedaComunicaciones.getSolicitud().substring(Aa83BConstants.CUATRO, Aa83BConstants.OCHO)));
						aa83b25t00 = this.aa83b25t00Service.find(aa83b25t00);
						Aa83bBusquedaComunicacionesController.logger.info("aa83b25t00 listaAdjuntoRemito -------->"+ aa83b25t00);
						idProcedimiento = this.appConfiguration.getProperty("procedure.arraigo.id");
						WSParamOutputRegisterEx wsParamOutputRegisterEx = new WSParamOutputRegisterEx();
						wsParamOutputRegisterEx.setUnitCode(managingIdARR);
						wsParamOutputRegisterEx.setSender(managingIdARR);
						wsParamOutputRegisterEx.setMatter(matter);
						Aa83bBusquedaComunicacionesController.logger.info("wsParamOutputRegisterEx matter; -------->"+ matter);
						WSParamPerson wsperson= new WSParamPerson();
						wsperson.setPersonName(aa83b23t00.getNombre023()+ ""+aa83b23t00.getApel1023() +"" + aa83b23t00.getApel2023());
						ArrayOfWSParamPerson array = new ArrayOfWSParamPerson();
						array.getWSParamPerson();
						array.add(wsperson);
						wsParamOutputRegisterEx.setPersons(array);
						Aa83bBusquedaComunicacionesController.logger.info("wsParamOutputRegisterEx.toString(); -------->"+ wsParamOutputRegisterEx);
						Aa83bBusquedaComunicacionesController.logger.info("wsParamOutputRegisterEx.toString(); -------->"+ wsParamOutputRegisterEx.getMatter());
						WSOutputRegister registro= this.sistemaRegistroPresencialWSSoap.wsNewOutputRegister(wsParamOutputRegisterEx);
						Aa83bBusquedaComunicacionesController.logger.info("registro -------->"+ registro.getNumber());
						aa83b21t00=null;
						aa83b23t00=null;
						seleccionadosResgistro.put(Aa83BConstants.COD_ARR_STR+"/"+aa83b25t00.getIdAno025()+ "/"+ aa83b25t00.getId025(), registro.getNumber());
					}
					Aa83bBusquedaComunicacionesController.logger.info("aa83b21t00 listaAdjuntoRemito 2-------->"+ aa83b21t00);
					Aa83bBusquedaComunicacionesController.logger.info("aa83b23t00 listaAdjuntoRemito 2-------->"+ aa83b23t00);
					Aa83bBusquedaComunicacionesController.logger.info("aa83b25t00 listaAdjuntoRemito 2-------->"+ aa83b25t00);
					Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] tramite= "+ tramite);
					String tipoArchivo = this.escribeHistorico(fase, tramite, aa83bBusquedaComunicaciones.getSolicitud(), aa83b21t00, aa83b23t00, aa83b25t00);
					
					String expediente= aa83bXMLGenerator.generarXmlSaveUpdateProceedings(aa83b21t00, aa83b23t00, aa83b25t00, res, idProcedimiento,null, null, tipoArchivo, false, "");
					Aa83bBusquedaComunicacionesController.logger.info("*********** expediente-->"+ expediente);
					this.q99uSendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken, expediente, "saveOrUpdateProceedingsNT");
					
					
					//Modifico el Historial de Tramitacion:::
					
					
				}
				

				Aa83bBusquedaComunicacionesController.logger.info("\n\n[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: listaAdjuntoRemito="+listaAdjuntoRemito);
				Aa83bBusquedaComunicacionesController.logger.info("\n\n[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: seleccionadosResgistro="+seleccionadosResgistro);
				String cadenaXML = aa83bXMLGenerator.generateXMLAdjuntoRemito(listaAdjuntoRemito, seleccionadosResgistro, false);

				 Aa83bBusquedaComunicacionesController.logger.info("\n\n[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: cadenaXML="+cadenaXML);

				// INICIO Subimos el xml a PIF
				 String rutaXML = Aa83bUtilProperties.PIF_PATH+ plantilla.getNomTemplate004() + ".xml";
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: rutaXML="+ rutaXML);

				InputStream isXML = new ByteArrayInputStream(cadenaXML.getBytes("UTF-8"));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAdjuntoRemito isXML:"+ isXML.toString());

				Y31AttachmentBean rdoXML = service.put(xmlSesionDocument,isXML, rutaXML, new Long(120));// NOPMD
				Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAdjuntoRemito despues del put-fecha-->" + System.currentTimeMillis());
				String pathPifXML = rdoXML.getFilePath();
				// FIN Subimos el xml a PIF

				// Llamamos al metodo create de aa19
				String ruta = this.getRuta(pathPifXML, plantilla.getNomTemplate004(), rdoRTF);

				// REcuperamos el documento generado en PIF para visualizarlo

				InputStream ficheroDescargado = Aa83bUtilPIF.get(ruta);
				response.setContentType("application/vnd.ms-word");
				// response.setContentLength(ficheroDescargado.
				// documentoDevuelto.getTamanyo());
				response.setHeader("Content-disposition","attachment;filename=ADJUNTOREMITO." + "doc");
				int bytesReaded = 0;
				final int _1024 = 1024;
				ServletOutputStream out = response.getOutputStream();
				byte[] binaryBuffer = new byte[_1024];
				while ((bytesReaded = ficheroDescargado.read(binaryBuffer)) != -1) {
					out.write(binaryBuffer, 0, bytesReaded);
				}
				response.getOutputStream().flush();

			} catch (Y31JanoServiceGenericException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceFileNameFormatException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceMongoDbGenericException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceEventJmsException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (Y31JanoServiceAccesDeniedException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (SAXException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			} catch (IOException e) {
				Aa83bBusquedaComunicacionesController.logger
				.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
			}
		}
	}
	
	/**
	 * @param pathPifXML String 
	 * @param plantilla String 
	 * @param rdoRTF Y31AttachmentBea 
	 * @return String 
	 */
	private String getRuta(String pathPifXML, String plantilla, Y31AttachmentBean rdoRTF) {
		String ruta = ""; 
		
		String pathPifPlantilla = rdoRTF.getFilePath();
		Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAdjuntoRemito rutaRTF: "+ pathPifPlantilla);
		
		Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: Llamamos al metodo create de aa19: ");
		String pathPifDocGenerado = Aa83bUtilProperties.PIF_PATH+ plantilla + ".rtf";

		
		try {
			Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAdjuntoRemito pathPifXML: "	+ pathPifXML);
			Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAdjuntoRemito pathPifPlantilla: "	+ pathPifPlantilla);
			Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : generarAdjuntoRemito pathPifDocGenerado: "	+ pathPifDocGenerado);
			
			ruta = this.documentoWebServiceImpl.create(pathPifXML,pathPifPlantilla, pathPifDocGenerado);
			Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: ruta: "+ ruta+ "-fecha-->" + System.currentTimeMillis());
		} catch (Exception e) {
			Aa83bBusquedaComunicacionesController.logger.error("[Aa83bBusquedaComunicacionesController] : "+e.getMessage());
		}
		return ruta;
	}
	
	/**
	 * @param fase String
	 * @param tramite String
	 * @return String
	 */
	private String getMatter(String fase, String tramite){
		String matter = "";
		if (fase.equals(Aa83BConstants.COD_FASE_1) && (tramite.equals(Aa83BConstants.COD_TRAM_2)))
		{
			Aa83bBusquedaComunicacionesController.logger.info("matter 1 -------->"+ matter);
			matter=Aa83bUtilProperties.DOC_REQ_SUB_TITULO;
			Aa83bBusquedaComunicacionesController.logger.info("matter 2 -------->"+ matter);
			
		}
		else
		{
			Aa83bBusquedaComunicacionesController.logger.info("matter 1 -------->"+ matter);
			matter=Aa83bUtilProperties.DOC_INF_RESOL_TITULO;
			Aa83bBusquedaComunicacionesController.logger.info("matter 2 -------->"+ matter);
		}
		
		return matter;
	}

	
	/**
	 * @param fase String
	 * @param tramite String
	 * @param solicitud String
	 * @param aa83b21t00 Aa83b21t00
	 * @param aa83b23t00 Aa83b23t00
	 * @param aa83b25t00 Aa83b25t00
	 * @return String
	 */
	private String escribeHistorico(String fase, String tramite, String solicitud, Aa83b21t00 aa83b21t00, 
			Aa83b23t00 aa83b23t00, Aa83b25t00 aa83b25t00 ){
		String tipoArchivo = "";
		//Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();
		
		if (fase.equals(Aa83BConstants.COD_FASE_1) && (tramite.equals(Aa83BConstants.COD_TRAM_2)))
		{
			tipoArchivo="req_sub";
			/*
			if (solicitud.substring(0, Aa83BConstants.TRES).equals(Aa83BConstants.COD_ADE_STR)) {
				this.aa83b09t00Service.add(aa83bSolicitudesUtil.guardarHistoADE(aa83b21t00, Aa83BConstants.COD_FASE_1,Aa83BConstants.COD_TRAM_3, "N"));
			}
			else {
				if (solicitud.substring(0, Aa83BConstants.TRES).equals(Aa83BConstants.COD_ESF_STR)){
					this.aa83b10t00Service.add(aa83bSolicitudesUtil.guardarHistoESF(aa83b23t00, Aa83BConstants.COD_FASE_1,Aa83BConstants.COD_TRAM_3, "N"));
				} else { 
					if (solicitud.substring(0, Aa83BConstants.TRES).equals(Aa83BConstants.COD_ARR_STR)) {
						this.aa83b11t00Service.add(aa83bSolicitudesUtil.guardarHistoARR(aa83b25t00, Aa83BConstants.COD_FASE_1,Aa83BConstants.COD_TRAM_3, "N"));
					}
				}
			}*/
		}else if (fase.equals(Aa83BConstants.COD_FASE_2) && (tramite.equals(Aa83BConstants.COD_TRAM_1)))
		{	
			tipoArchivo="resol";
			/*if (solicitud.substring(0, Aa83BConstants.TRES).equals(Aa83BConstants.COD_ADE_STR)) {
				this.aa83b09t00Service.add(aa83bSolicitudesUtil.guardarHistoADE(aa83b21t00, Aa83BConstants.COD_FASE_2,Aa83BConstants.COD_TRAM_2, "N"));
			} else {
				if (solicitud.substring(0, Aa83BConstants.TRES).equals(Aa83BConstants.COD_ESF_STR)) {
					this.aa83b10t00Service.add(aa83bSolicitudesUtil.guardarHistoESF(aa83b23t00, Aa83BConstants.COD_FASE_2,Aa83BConstants.COD_TRAM_2, "N"));
				} else {
					if (solicitud.substring(0, Aa83BConstants.TRES).equals(Aa83BConstants.COD_ARR_STR)) {
						this.aa83b11t00Service.add(aa83bSolicitudesUtil.guardarHistoARR(aa83b25t00, Aa83BConstants.COD_FASE_2,Aa83BConstants.COD_TRAM_2, "N"));
					}
				}
			}*/
		}
		
		return tipoArchivo;
	}
	
	
	@RequestMapping(value = "notificaciones", method = RequestMethod.GET)
	public ModelAndView notificacionesCorreos() {
		return new ModelAndView("listanotificacionesCorreos");
	}
	
	@RequestMapping(value = "requerimientos", method = RequestMethod.GET)
	public ModelAndView requerimientos() {
		return new ModelAndView("requerimientos");
	}
	
	@RequestMapping(value = "reenvios", method = RequestMethod.GET)
	public ModelAndView reenviosNotificaciones() {
		return new ModelAndView("reenviosnotificaciones");
	}
	
	
	
	@RequestMapping(value = "marcarParaReenvios", method = RequestMethod.GET)
	public @ResponseBody
	HashMap<String, String> marcarParaReenvios(
			@RequestParam(value = "idDoc", required = true) String idDoc,
			HttpServletRequest request) {
		HashMap<String, String> retorno = new HashMap<String, String>();

		ArrayList<String> solis = new ArrayList<String>(Arrays.asList(idDoc
				.split(",")));
		if (solis != null && solis.size() > 0) {
			for (int s = 0; s < solis.size(); s++) {
				String idSolConcat = solis.get(s);
				ArrayList<String> idSolTrozos = new ArrayList<String>(
						Arrays.asList(idSolConcat.split(" ")));
				String tipoSol = idSolTrozos.get(0);
				String anoSol = idSolTrozos.get(1);
				String idSol = idSolTrozos.get(2);
				Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();

				if (tipoSol.equals(Aa83BConstants.COD_ADE_STR)) {
					// Completo los datos de Tramitacon
					Aa83b21t00 solicitudADE = new Aa83b21t00();
					solicitudADE.setId021(Integer.parseInt(idSol));
					solicitudADE.setIdAno021(Long.parseLong(anoSol));
					
					
					//Grabamos el acceso
					aa83b06t00Service.add(aa83bSolicitudesUtil.guardarAccesoADE(
							solicitudADE, Aa83BConstants.ACCESOS_MODIF, "N"));
					//Grabamos el HistoTRAM
					aa83b09t00Service.add(aa83bSolicitudesUtil
							.guardarHistoADE(solicitudADE, Aa83BConstants.COD_FASE_2,
									Aa83BConstants.COD_TRAM_1, "N"));

				} else if (tipoSol.equals(Aa83BConstants.COD_ESF_STR)) {
					
					// Completo los datos de Tramitacon
					Aa83b23t00 solicitudESF = new Aa83b23t00();
					solicitudESF.setId023(Integer.parseInt(idSol));
					solicitudESF.setIdAno023(Long.parseLong(anoSol));
					
					
					
					//Grabamos el acceso
					aa83b07t00Service.add(aa83bSolicitudesUtil.guardarAccesoESF(
							solicitudESF, Aa83BConstants.ACCESOS_MODIF, "N"));
					//Grabamos el HistoTRAM
					aa83b10t00Service.add(aa83bSolicitudesUtil
							.guardarHistoESF(solicitudESF, Aa83BConstants.COD_FASE_2,
									Aa83BConstants.COD_TRAM_1, "N"));

				} else if (tipoSol.equals(Aa83BConstants.COD_ARR_STR)) {
					// Completo los datos de Tramitacon
					Aa83b25t00 solicitudARR = new Aa83b25t00();
					solicitudARR.setId025(Integer.parseInt(idSol));
					solicitudARR.setIdAno025(Long.parseLong(anoSol));
					
					
					
					//Grabamos el acceso
					aa83b08t00Service.add(aa83bSolicitudesUtil.guardarAccesoARR(
							solicitudARR, Aa83BConstants.ACCESOS_MODIF, "N"));
					//Grabamos el HistoTRAM
					aa83b11t00Service.add(aa83bSolicitudesUtil
							.guardarHistoARR(solicitudARR, Aa83BConstants.COD_FASE_2,
									Aa83BConstants.COD_TRAM_1, "N"));
					
				}
			}
		}
		return retorno;
	}
	
	@RequestMapping(value = "cerrarReq", method = RequestMethod.GET)
	public @ResponseBody
	HashMap<String, String> cerrarReq(
			@RequestParam(value = "idDoc", required = true) String idDoc,
			HttpServletRequest request) {
		HashMap<String, String> retorno = new HashMap<String, String>();

		ArrayList<String> solis = new ArrayList<String>(Arrays.asList(idDoc
				.split(",")));
		if (solis != null && solis.size() > 0) {
			for (int s = 0; s < solis.size(); s++) {
				String idSolConcat = solis.get(s);
				ArrayList<String> idSolTrozos = new ArrayList<String>(
						Arrays.asList(idSolConcat.split(" ")));
				String tipoSol = idSolTrozos.get(0);
				String anoSol = idSolTrozos.get(1);
				String idSol = idSolTrozos.get(2);
				Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();

				if (tipoSol.equals(Aa83BConstants.COD_ADE_STR)) {
					// Completo los datos de Tramitacon
					Aa83b21t00 solicitudADE = new Aa83b21t00();
					solicitudADE.setId021(Integer.parseInt(idSol));
					solicitudADE.setIdAno021(Long.parseLong(anoSol));
					//Grabamos el acceso
					aa83b06t00Service.add(aa83bSolicitudesUtil.guardarAccesoADE(
							solicitudADE, Aa83BConstants.ACCESOS_MODIF, "N"));
					//Grabamos el HistoTRAM
					aa83b09t00Service.add(aa83bSolicitudesUtil
							.guardarHistoADE(solicitudADE, Aa83BConstants.COD_FASE_3,
									Aa83BConstants.COD_TRAM_1, "N"));

					aa83b21t00Service.cerrarExpReq (solicitudADE);
					
				} else if (tipoSol.equals(Aa83BConstants.COD_ESF_STR)) {
					// Completo los datos de Tramitacon
					Aa83b23t00 solicitudESF = new Aa83b23t00();
					solicitudESF.setId023(Integer.parseInt(idSol));
					solicitudESF.setIdAno023(Long.parseLong(anoSol));
					//Grabamos el acceso
					aa83b07t00Service.add(aa83bSolicitudesUtil.guardarAccesoESF(
							solicitudESF, Aa83BConstants.ACCESOS_MODIF, "N"));
					//Grabamos el HistoTRAM
					aa83b10t00Service.add(aa83bSolicitudesUtil
							.guardarHistoESF(solicitudESF, Aa83BConstants.COD_FASE_3,
									Aa83BConstants.COD_TRAM_1, "N"));
					aa83b23t00Service.cerrarExpReq (solicitudESF);
					
				} else if (tipoSol.equals(Aa83BConstants.COD_ARR_STR)) {
					// Completo los datos de Tramitacon
					Aa83b25t00 solicitudARR = new Aa83b25t00();
					solicitudARR.setId025(Integer.parseInt(idSol));
					solicitudARR.setIdAno025(Long.parseLong(anoSol));
					//Grabamos el acceso
					aa83b08t00Service.add(aa83bSolicitudesUtil.guardarAccesoARR(
							solicitudARR, Aa83BConstants.ACCESOS_MODIF, "N"));
					//Grabamos el HistoTRAM
					aa83b11t00Service.add(aa83bSolicitudesUtil
							.guardarHistoARR(solicitudARR, Aa83BConstants.COD_FASE_3,
									Aa83BConstants.COD_TRAM_1, "N"));
					aa83b25t00Service.cerrarExpReq (solicitudARR);
					
				}
			}
		}
		return retorno;
	}
	@RequestMapping(value = "acusesRecibidos", method = RequestMethod.GET)
	public @ResponseBody
	HashMap<String, String> acusesRecibidos(
			@RequestParam(value = "idDoc", required = true) String idDoc,
			HttpServletRequest request) {
		HashMap<String, String> retorno = new HashMap<String, String>();

		ArrayList<String> solis = new ArrayList<String>(Arrays.asList(idDoc
				.split(",")));
		if (solis != null && solis.size() > 0) {
			for (int s = 0; s < solis.size(); s++) {
				String idSolConcat = solis.get(s);
				ArrayList<String> idSolTrozos = new ArrayList<String>(
						Arrays.asList(idSolConcat.split(" ")));
				String tipoSol = idSolTrozos.get(0);
				String anoSol = idSolTrozos.get(1);
				String idSol = idSolTrozos.get(2);
				Aa83bSolicitudesUtil aa83bSolicitudesUtil = new Aa83bSolicitudesUtil();

				if (tipoSol.equals(Aa83BConstants.COD_ADE_STR)) {
					// Completo los datos de Tramitacon
					Aa83b21t00 solicitudADE = new Aa83b21t00();
					solicitudADE.setId021(Integer.parseInt(idSol));
					solicitudADE.setIdAno021(Long.parseLong(anoSol));
					solicitudADE = aa83b21t00Service.marcarNotifLeida(solicitudADE);
					
					//Grabamos el acceso
					aa83b06t00Service.add(aa83bSolicitudesUtil.guardarAccesoADE(
							solicitudADE, Aa83BConstants.ACCESOS_MODIF, "N"));
					//Grabamos el HistoTRAM
//					aa83b09t00Service.add(aa83bSolicitudesUtil
//							.guardarHistoADE(solicitudADE, Aa83BConstants.COD_FASE_3,
//									Aa83BConstants.COD_TRAM_1, "N"));
				} else if (tipoSol.equals(Aa83BConstants.COD_ESF_STR)) {		
					// Completo los datos de Tramitacon
					Aa83b23t00 solicitudESF = new Aa83b23t00();
					solicitudESF.setId023(Integer.parseInt(idSol));
					solicitudESF.setIdAno023(Long.parseLong(anoSol));
					
					aa83b23t00Service.marcarNotifLeida (solicitudESF);
					
					//Grabamos el acceso
					aa83b07t00Service.add(aa83bSolicitudesUtil.guardarAccesoESF(
							solicitudESF, Aa83BConstants.ACCESOS_MODIF, "N"));
					//Grabamos el HistoTRAM
//					aa83b10t00Service.add(aa83bSolicitudesUtil
//							.guardarHistoESF(solicitudESF, Aa83BConstants.COD_FASE_3,
//									Aa83BConstants.COD_TRAM_1, "N"));

				} else if (tipoSol.equals(Aa83BConstants.COD_ARR_STR)) {
					// Completo los datos de Tramitacon
					Aa83b25t00 solicitudARR = new Aa83b25t00();
					solicitudARR.setId025(Integer.parseInt(idSol));
					solicitudARR.setIdAno025(Long.parseLong(anoSol));
					
					aa83b25t00Service.marcarNotifLeida (solicitudARR);
					
					//Grabamos el acceso
					aa83b08t00Service.add(aa83bSolicitudesUtil.guardarAccesoARR(
							solicitudARR, Aa83BConstants.ACCESOS_MODIF, "N"));
					//Grabamos el HistoTRAM
//					aa83b11t00Service.add(aa83bSolicitudesUtil
//							.guardarHistoARR(solicitudARR, Aa83BConstants.COD_FASE_3,
//									Aa83BConstants.COD_TRAM_1, "N"));
					
				}
			}
		}
		return retorno;
	}
	
	@RequestMapping(value = "notificaciones/remote/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83bBusqueda> notificacionesRemote(
			@RequestJsonBody(param = "filter") Aa83bBusqueda filterBusqueda,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Locale locale = LocaleContextHolder.getLocale();
		// Buscamos las solicitudes 21, 23 y 25 que esten en F2, T2
		Aa83b09t00 aa83b09t00 = new Aa83b09t00();
		Aa83b10t00 aa83b10t00 = new Aa83b10t00();
		Aa83b11t00 aa83b11t00 = new Aa83b11t00();


		String tipoSol = filterBusqueda.getTipoSol();

		List<Aa83b09t00> aa83b09t00Lista = new ArrayList<Aa83b09t00>();
		List<Aa83b10t00> aa83b10t00Lista = new ArrayList<Aa83b10t00>();
		List<Aa83b11t00> aa83b11t00Lista = new ArrayList<Aa83b11t00>();

/*		int conta09 = 0;
		int conta10 = 0;
		int conta11 = 0;
		*/

		List<Aa83bBusqueda> responseGrid = new ArrayList<Aa83bBusqueda>();

		if (tipoSol == null)
			tipoSol = "0";

		if ("0".equals(tipoSol)) {
			
			aa83b09t00Lista = aa83b09t00Service.findEnviadasNotificacion(aa83b09t00, null);
			
			aa83b10t00Lista = aa83b10t00Service.findAllLikeNotificacion(aa83b10t00, null);
			
			aa83b11t00Lista = aa83b11t00Service.findAllLikeNotificacion(aa83b11t00, null);
			
			
			
/*			conta09 = aa83b09t00Lista.size();
			conta10 = aa83b10t00Lista.size();
			conta11 = aa83b11t00Lista.size();*/
		}

		if (tipoSol.equals(Aa83BConstants.COD_ADE)) {

			aa83b09t00Lista = aa83b09t00Service.findEnviadasNotificacion(aa83b09t00, null);
			//conta09 = aa83b09t00Lista.size();
		}
		if (tipoSol.equals(Aa83BConstants.COD_ESF)) {

			aa83b10t00Lista = this.aa83b10t00Service.findAllLikeNotificacion(aa83b10t00,
					null);
			//conta10 = aa83b10t00Lista.size();
		}
		if (tipoSol.equals(Aa83BConstants.COD_ARR)) {

			aa83b11t00Lista = aa83b11t00Service.findAllLikeNotificacion(aa83b11t00, null);
			//conta11 = aa83b11t00Lista.size();
		}
		//System.out.println ("Antes del FOR");
		for (int i = 0; i < aa83b09t00Lista.size(); i++) {
			//System.out.println ("Entro en el notificaciones/remote/filter-5");
			Aa83b21t00 aa83b21t00 = new Aa83b21t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b21t00.setId021(aa83b09t00Lista.get(i).getId021NumSol());
			aa83b21t00.setIdAno021(aa83b09t00Lista.get(i).getIdAno021());

			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00
					.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_2));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_2));
			aa83b02t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));
			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);
			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase()
					.equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b21t00> aa83b21t00Lista = aa83b21t00Service.findAllLike(
					aa83b21t00, null, null);

			aa83b21t00 = aa83b21t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b21t00.getId021().toString());
			aa83bBusqueda.setAno_sol(aa83b21t00.getIdAno021().toString());

			aa83bBusqueda.setNombre_sol(aa83b21t00.getNombre021());
			aa83bBusqueda.setApellido1_sol(aa83b21t00.getApel1021());
			aa83bBusqueda.setApellido2_sol(aa83b21t00.getApel1021());

			if (aa83b21t00.getFecha021() != null)
				aa83bBusqueda.setFecha(aa83b21t00.getFecha021());

			aa83bBusqueda.setNumero_dni(aa83b21t00.getNumDoc021());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ADE));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "
					+ aa83bBusqueda.getAno_sol() + " "
					+ aa83bBusqueda.getId_sol());

			responseGrid.add(aa83bBusqueda);
		}
		for (int i = 0; i < aa83b10t00Lista.size(); i++) {
			//System.out.println ("Entro en el reenvios/remote/filter-5");
			Aa83b23t00 aa83b23t00 = new Aa83b23t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b23t00.setId023(Integer.parseInt(aa83b10t00Lista.get(i).getId023NumSol().toString()));
			aa83b23t00.setIdAno023(aa83b10t00Lista.get(i).getIdAno023());

			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00
					.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_2));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_2));
			aa83b02t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));

			//System.out.println ("Entro en el reenvios/remote/filter-6");
			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);
			//System.out.println ("Entro en el reenvios/remote/filter-7");

			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase()
					.equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b23t00> aa83b23t00Lista = aa83b23t00Service.findAllLike(
					aa83b23t00, null, null);

			aa83b23t00 = aa83b23t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b23t00.getId023().toString());
			aa83bBusqueda.setAno_sol(aa83b23t00.getIdAno023().toString());

			aa83bBusqueda.setNombre_sol(aa83b23t00.getNombre023());
			aa83bBusqueda.setApellido1_sol(aa83b23t00.getApel1023());
			aa83bBusqueda.setApellido2_sol(aa83b23t00.getApel1023());

			if (aa83b23t00.getFecha023() != null)
				aa83bBusqueda.setFecha(aa83b23t00.getFecha023());

			aa83bBusqueda.setNumero_dni(aa83b23t00.getNumDoc023());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ESF));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "
					+ aa83bBusqueda.getAno_sol() + " "
					+ aa83bBusqueda.getId_sol());

			responseGrid.add(aa83bBusqueda);
		}
		
		for (int i = 0; i < aa83b11t00Lista.size(); i++) {
			//System.out.println ("Entro en el reenvios/remote/filter-5");
			Aa83b25t00 aa83b25t00 = new Aa83b25t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b25t00.setId025(Integer.parseInt(aa83b11t00Lista.get(i).getId025NumSol().toString()));
			aa83b25t00.setIdAno025(aa83b11t00Lista.get(i).getIdAnoSol025());

			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00
					.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_2));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_2));
			aa83b02t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));

			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);

			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase()
					.equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b25t00> aa83b25t00Lista = aa83b25t00Service.findAllLike(
					aa83b25t00, null, null);

			aa83b25t00 = aa83b25t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b25t00.getId025().toString());
			aa83bBusqueda.setAno_sol(aa83b25t00.getIdAno025().toString());

			aa83bBusqueda.setNombre_sol(aa83b25t00.getNombre025());
			aa83bBusqueda.setApellido1_sol(aa83b25t00.getApel1025());
			aa83bBusqueda.setApellido2_sol(aa83b25t00.getApel1025());

			if (aa83b25t00.getFecha025() != null)
				aa83bBusqueda.setFecha(aa83b25t00.getFecha025());

			aa83bBusqueda.setNumero_dni(aa83b25t00.getNumDoc025());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ARR));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "
					+ aa83bBusqueda.getAno_sol() + " "
					+ aa83bBusqueda.getId_sol());

			responseGrid.add(aa83bBusqueda);
		}
		int total = 1;

		return new JQGridResponseDto<Aa83bBusqueda>(jqGridRequestDto,
				(long) (total), responseGrid);
	}
	
	
	@RequestMapping(value = "reenvios/remote/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83bBusqueda> reenviosRemote(
			@RequestJsonBody(param = "filter") Aa83bBusqueda filterBusqueda,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {

		//System.out.println ("Entro en el reenvios/remote/filter");
		Locale locale = LocaleContextHolder.getLocale();
		// Buscamos las solicitudes 21, 23 y 25 que esten en F2, T2
		Aa83b09t00 aa83b09t00 = new Aa83b09t00();
		Aa83b10t00 aa83b10t00 = new Aa83b10t00();
		Aa83b11t00 aa83b11t00 = new Aa83b11t00();


		String tipoSol = filterBusqueda.getTipoSol();
		String diasEnvio = filterBusqueda.getDiasEnviada();
		String idColeccion = filterBusqueda.getId_coleccion();
		String numExpediente = filterBusqueda.getId_sol();
		//System.out.println ("Entro en el reenvios/remote/filter::" + diasEnvio + "::");
		java.util.Date fechaDesde = new java.util.Date();
		java.util.Date fechaHasta = new java.util.Date();
		
		Calendar desde = Calendar.getInstance();
		Calendar hasta = Calendar.getInstance();
		
		if ("1".equals(diasEnvio))
		{
			desde.add(Calendar.DATE, +1);
			hasta.add(Calendar.DATE, -10);
		} else if ("2".equals(diasEnvio))
		{
			desde.add(Calendar.DATE, -9);
			hasta.add(Calendar.DATE, -20);
		} else if ("3".equals(diasEnvio))
		{
			desde.add(Calendar.DATE, -19);
			hasta.add(Calendar.DATE, -1000);
		}
		
			
		fechaDesde.setTime(desde.getTimeInMillis());
		fechaHasta.setTime(hasta.getTimeInMillis());
		//System.out.println ("Enviadas entre fechas:::"+fechaDesde+"::" + fechaHasta);
		List<Aa83b09t00> aa83b09t00Lista = new ArrayList<Aa83b09t00>();
		List<Aa83b10t00> aa83b10t00Lista = new ArrayList<Aa83b10t00>();
		List<Aa83b11t00> aa83b11t00Lista = new ArrayList<Aa83b11t00>();

/*		int conta09 = 0;
		int conta10 = 0;
		int conta11 = 0;*/

		List<Aa83bBusqueda> responseGrid = new ArrayList<Aa83bBusqueda>();

		if (tipoSol == null)
			tipoSol = "0";
		if(numExpediente!=null){
			aa83b09t00.setId021NumSol(Integer.parseInt(numExpediente));
			aa83b10t00.setId023NumSol(Long.parseLong(numExpediente));
			aa83b11t00.setId025NumSol(Integer.parseInt(numExpediente));
		}
		if ("0".equals(tipoSol)) {
			if(idColeccion==null || idColeccion==""){
				aa83b09t00Lista = aa83b09t00Service.findEnviadasNotificacionFechas(aa83b09t00, null, fechaDesde, fechaHasta);
				aa83b10t00Lista = aa83b10t00Service.findAllLikeNotificacionFechas(aa83b10t00, null, fechaDesde, fechaHasta);
				aa83b11t00Lista = aa83b11t00Service.findAllLikeNotificacionFechas(aa83b11t00, null, fechaDesde, fechaHasta);

				/*conta09 = aa83b09t00Lista.size();
				conta10 = aa83b10t00Lista.size();
				conta11 = aa83b11t00Lista.size();*/
				//System.out.println ("Tamaos reenvios:"+conta09+":"+conta10+":"+conta11);
			}else{
				aa83b09t00Lista = aa83b09t00Service.findEnviadasNotificacionFechasIdColeccion(aa83b09t00, null, fechaDesde, fechaHasta, idColeccion);
				aa83b10t00Lista = aa83b10t00Service.findAllLikeNotificacionFechasIdColeccion(aa83b10t00, null, fechaDesde, fechaHasta, idColeccion);
				aa83b11t00Lista = aa83b11t00Service.findAllLikeNotificacionFechasIdColeccion(aa83b11t00, null, fechaDesde, fechaHasta, idColeccion);
				/*conta09 = aa83b09t00Lista.size();
				conta10 = aa83b10t00Lista.size();
				conta11 = aa83b11t00Lista.size();*/
			}
			
		}

		if (tipoSol.equals(Aa83BConstants.COD_ADE)) {
			if(idColeccion==null || idColeccion==""){
				aa83b09t00Lista = aa83b09t00Service.findEnviadasNotificacion(aa83b09t00, null);
				//conta09 = aa83b09t00Lista.size();
			}else{
				aa83b09t00Lista = aa83b09t00Service.findEnviadasNotificacionIdColeccion(aa83b09t00, null, idColeccion);
				//conta09 = aa83b09t00Lista.size();
			}
			
		}
		if (tipoSol.equals(Aa83BConstants.COD_ESF)) {
			if(idColeccion==null || idColeccion==""){
				aa83b10t00Lista = this.aa83b10t00Service.findAllLikeNotificacion(aa83b10t00, null);
				//conta10 = aa83b10t00Lista.size();
			}else{
				aa83b10t00Lista = this.aa83b10t00Service.findAllLikeNotificacionIdColeccion(aa83b10t00,null, idColeccion);
				//conta10 = aa83b10t00Lista.size();
			}
			
		}
		if (tipoSol.equals(Aa83BConstants.COD_ARR)) {
			if (idColeccion == null || idColeccion == "") {
				aa83b11t00Lista = aa83b11t00Service.findAllLikeNotificacion(
						aa83b11t00, null);
				//conta11 = aa83b11t00Lista.size();
			} else {
				aa83b11t00Lista = aa83b11t00Service
						.findAllLikeNotificacionIdColeccion(aa83b11t00, null,
								idColeccion);
				//conta11 = aa83b11t00Lista.size();
			}
		}
		//System.out.println ("Antes del FOR");
		for (int i = 0; i < aa83b09t00Lista.size(); i++) {
			//System.out.println ("Entro en el reenvios/remote/filter-5");
			Aa83b21t00 aa83b21t00 = new Aa83b21t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b21t00.setId021(aa83b09t00Lista.get(i).getId021NumSol());
			aa83b21t00.setIdAno021(aa83b09t00Lista.get(i).getIdAno021());

			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00
					.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_2));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_2));
			aa83b02t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));

			//System.out.println ("Entro en el reenvios/remote/filter-6");
			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);
			//System.out.println ("Entro en el reenvios/remote/filter-7");

			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase()
					.equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b21t00> aa83b21t00Lista = aa83b21t00Service.findAllLike(
					aa83b21t00, null, null);

			aa83b21t00 = aa83b21t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b21t00.getId021().toString());
			aa83bBusqueda.setAno_sol(aa83b21t00.getIdAno021().toString());

			aa83bBusqueda.setNombre_sol(aa83b21t00.getNombre021());
			aa83bBusqueda.setApellido1_sol(aa83b21t00.getApel1021());
			aa83bBusqueda.setApellido2_sol(aa83b21t00.getApel2021());
			aa83bBusqueda.setTipoNotificacion(aa83b21t00.getTipoNotificacion021());

			if (aa83b21t00.getFecha021() != null)
				aa83bBusqueda.setFecha(aa83b21t00.getFecha021());

			aa83bBusqueda.setNumero_dni(aa83b21t00.getNumDoc021());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ADE));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "
					+ aa83bBusqueda.getAno_sol() + " "
					+ aa83bBusqueda.getId_sol());
			//Buscar estado del envio correos, remesa y coleccion
			aa83bBusqueda = buscarSituacionRemesas(aa83bBusqueda, Aa83BConstants.COD_ADE);
			responseGrid.add(aa83bBusqueda);
		}
		
		for (int i = 0; i < aa83b10t00Lista.size(); i++) {
			//System.out.println ("Entro en el reenvios/remote/filter-5");
			Aa83b23t00 aa83b23t00 = new Aa83b23t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b23t00.setId023(Integer.parseInt(aa83b10t00Lista.get(i).getId023NumSol().toString()));
			aa83b23t00.setIdAno023(aa83b10t00Lista.get(i).getIdAno023());

			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00
					.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_2));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_2));
			aa83b02t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));

			//System.out.println ("Entro en el reenvios/remote/filter-6");
			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);
			//System.out.println ("Entro en el reenvios/remote/filter-7");

			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase()
					.equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b23t00> aa83b23t00Lista = aa83b23t00Service.findAllLike(
					aa83b23t00, null, null);

			aa83b23t00 = aa83b23t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b23t00.getId023().toString());
			aa83bBusqueda.setAno_sol(aa83b23t00.getIdAno023().toString());

			aa83bBusqueda.setNombre_sol(aa83b23t00.getNombre023());
			aa83bBusqueda.setApellido1_sol(aa83b23t00.getApel1023());
			aa83bBusqueda.setApellido2_sol(aa83b23t00.getApel2023());
			aa83bBusqueda.setTipoNotificacion(aa83b23t00.getTipoNotificacion023());

			if (aa83b23t00.getFecha023() != null)
				aa83bBusqueda.setFecha(aa83b23t00.getFecha023());

			aa83bBusqueda.setNumero_dni(aa83b23t00.getNumDoc023());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ESF));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "
					+ aa83bBusqueda.getAno_sol() + " "
					+ aa83bBusqueda.getId_sol());
			//Buscar estado del envio correos, remesa y coleccion
			aa83bBusqueda = buscarSituacionRemesas(aa83bBusqueda, Aa83BConstants.COD_ESF);

			responseGrid.add(aa83bBusqueda);
		}
		
		for (int i = 0; i < aa83b11t00Lista.size(); i++) {
			//System.out.println ("Entro en el reenvios/remote/filter-5");
			Aa83b25t00 aa83b25t00 = new Aa83b25t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b25t00.setId025(Integer.parseInt(aa83b11t00Lista.get(i).getId025NumSol().toString()));
			aa83b25t00.setIdAno025(aa83b11t00Lista.get(i).getIdAnoSol025());

			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00
					.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_2));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_2));
			aa83b02t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));

			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);

			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase()
					.equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b25t00> aa83b25t00Lista = aa83b25t00Service.findAllLike(
					aa83b25t00, null, null);

			aa83b25t00 = aa83b25t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b25t00.getId025().toString());
			aa83bBusqueda.setAno_sol(aa83b25t00.getIdAno025().toString());

			aa83bBusqueda.setNombre_sol(aa83b25t00.getNombre025());
			aa83bBusqueda.setApellido1_sol(aa83b25t00.getApel1025());
			aa83bBusqueda.setApellido2_sol(aa83b25t00.getApel2025());
			aa83bBusqueda.setTipoNotificacion(aa83b25t00.getTipoNotificacion025());

			if (aa83b25t00.getFecha025() != null)
				aa83bBusqueda.setFecha(aa83b25t00.getFecha025());

			aa83bBusqueda.setNumero_dni(aa83b25t00.getNumDoc025());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ARR));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "
					+ aa83bBusqueda.getAno_sol() + " "
					+ aa83bBusqueda.getId_sol());
			//Buscar estado del envio correos, remesa y coleccion
			aa83bBusqueda = buscarSituacionRemesas(aa83bBusqueda, Aa83BConstants.COD_ARR);

			responseGrid.add(aa83bBusqueda);
		}
		
		
		int total = 1;

		return new JQGridResponseDto<Aa83bBusqueda>(jqGridRequestDto,
				(long) (total), responseGrid);
	}
	
	
	
	@RequestMapping(value = "requerimientos/remote/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa83bBusqueda> requerimietosRemote (
			@RequestJsonBody(param = "filter") Aa83bBusqueda filterBusqueda,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {

		Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] : Entro en el requerimietos/remote/filter");
		
		Locale locale = LocaleContextHolder.getLocale();
		// Buscamos las solicitudes 21, 23 y 25 que esten en F1, T3
		Aa83b09t00 aa83b09t00 = new Aa83b09t00();
		Aa83b10t00 aa83b10t00 = new Aa83b10t00();
		Aa83b11t00 aa83b11t00 = new Aa83b11t00();


		String tipoSol = filterBusqueda.getTipoSol();
		String diasEnvio = filterBusqueda.getDiasEnviada();
		String idColeccion = filterBusqueda.getId_coleccion();
		java.util.Date fechaDesde = new java.util.Date();
		java.util.Date fechaHasta = new java.util.Date();
		String numExpediente = filterBusqueda.getId_sol();
		Calendar desde = Calendar.getInstance();
		Calendar hasta = Calendar.getInstance();
		
		
		if ("1".equals(diasEnvio))
		{
			desde.add(Calendar.DATE, +1);
			hasta.add(Calendar.DATE, -10);
			
		} else if ("2".equals(diasEnvio))
		{
			desde.add(Calendar.DATE, -9);
			hasta.add(Calendar.DATE, -20);
			
		} else if ("3".equals(diasEnvio))
		{
			desde.add(Calendar.DATE, -19);
			hasta.add(Calendar.DATE, -1000);
		}
		
		fechaDesde.setTime(desde.getTimeInMillis());
		fechaHasta.setTime(hasta.getTimeInMillis());
		//System.out.println ("Enviadas entre fechas:::"+fechaDesde+"::" + fechaHasta);
		List<Aa83b09t00> aa83b09t00Lista = new ArrayList<Aa83b09t00>();
		List<Aa83b10t00> aa83b10t00Lista = new ArrayList<Aa83b10t00>();
		List<Aa83b11t00> aa83b11t00Lista = new ArrayList<Aa83b11t00>();

		/*int conta09 = 0;
		int conta10 = 0;
		int conta11 = 0;*/

		List<Aa83bBusqueda> responseGrid = new ArrayList<Aa83bBusqueda>();

		if (tipoSol == null)
			tipoSol = "0";
		if(numExpediente!=null){
			aa83b09t00.setId021NumSol(Integer.parseInt(numExpediente));
			aa83b10t00.setId023NumSol(Long.parseLong(numExpediente));
			aa83b11t00.setId025NumSol(Integer.parseInt(numExpediente));
		}
		if ("0".equals(tipoSol)) {
			if(idColeccion==null || idColeccion==""){
				aa83b09t00Lista = aa83b09t00Service.findEnviadosRequerimientosFechas(aa83b09t00, null,fechaDesde, fechaHasta);
				aa83b10t00Lista = aa83b10t00Service.findEnviadosRequerimientosFechas(aa83b10t00, null,fechaDesde, fechaHasta);
				aa83b11t00Lista = aa83b11t00Service.findEnviadosRequerimientosFechas(aa83b11t00, null,fechaDesde, fechaHasta);
				/*conta09 = aa83b09t00Lista.size();
				conta10 = aa83b10t00Lista.size();
				conta11 = aa83b11t00Lista.size();*/
			}else{
				//buscar por idColeccion
				aa83b09t00Lista= aa83b09t00Service.findEnviadosRequerimientosFechasIdColeccion(aa83b09t00, null, fechaDesde, fechaHasta, idColeccion);
				aa83b10t00Lista = aa83b10t00Service.findEnviadosRequerimientosFechasIdColeccion(aa83b10t00, null,fechaDesde, fechaHasta, idColeccion);
				aa83b11t00Lista = aa83b11t00Service.findEnviadosRequerimientosFechasIdColeccion(aa83b11t00, null,fechaDesde, fechaHasta, idColeccion);
				/*conta09 = aa83b09t00Lista.size();
				conta10 = aa83b10t00Lista.size();
				conta11 = aa83b11t00Lista.size();*/
			}
			
		}

		if (tipoSol.equals(Aa83BConstants.COD_ADE)) {
			if(idColeccion==null || idColeccion==""){
			aa83b09t00Lista = aa83b09t00Service.findEnviadasNotificacion(aa83b09t00, null);
			//conta09 = aa83b09t00Lista.size();
			}else{
				//buscar por idColeccion
				aa83b09t00Lista= aa83b09t00Service.findEnviadasNotificacionIdColeccion(aa83b09t00, null, idColeccion);
//				conta09 = aa83b09t00Lista.size();
			}
			
		}
		if (tipoSol.equals(Aa83BConstants.COD_ESF)) {
			if(idColeccion== null|| idColeccion==""){
				aa83b10t00Lista = this.aa83b10t00Service.findAllLikeNotificacion(aa83b10t00,null);
//				conta10 = aa83b10t00Lista.size();
			}else{
				aa83b10t00Lista = this.aa83b10t00Service.findAllLikeNotificacionIdColeccion(aa83b10t00,null, idColeccion);
//				conta10 = aa83b10t00Lista.size();
			}	
		}
		if (tipoSol.equals(Aa83BConstants.COD_ARR)) {
			if(idColeccion== null|| idColeccion==""){
				aa83b11t00Lista = aa83b11t00Service.findAllLikeNotificacion(aa83b11t00, null);
//				conta11 = aa83b11t00Lista.size();
			}else{
				aa83b11t00Lista = aa83b11t00Service.findAllLikeNotificacionIdColeccion(aa83b11t00, null, idColeccion);
//				conta11 = aa83b11t00Lista.size();
			}
		}
		for (int i = 0; i < aa83b09t00Lista.size(); i++) {
			Aa83b21t00 aa83b21t00 = new Aa83b21t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b21t00.setId021(aa83b09t00Lista.get(i).getId021NumSol());
			aa83b21t00.setIdAno021(aa83b09t00Lista.get(i).getIdAno021());

			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00
					.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_1));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_3));
			aa83b02t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ADE));

			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);

			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase()
					.equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b21t00> aa83b21t00Lista = aa83b21t00Service.findAllLike(
					aa83b21t00, null, null);

			aa83b21t00 = aa83b21t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b21t00.getId021().toString());
			aa83bBusqueda.setAno_sol(aa83b21t00.getIdAno021().toString());

			aa83bBusqueda.setNombre_sol(aa83b21t00.getNombre021());
			aa83bBusqueda.setApellido1_sol(aa83b21t00.getApel1021());
			aa83bBusqueda.setApellido2_sol(aa83b21t00.getApel2021());
			aa83bBusqueda.setTipoNotificacion(aa83b21t00.getTipoNotificacion021());

			if (aa83b21t00.getFecha021() != null)
				aa83bBusqueda.setFecha(aa83b21t00.getFecha021());

			aa83bBusqueda.setNumero_dni(aa83b21t00.getNumDoc021());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ADE));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "
					+ aa83bBusqueda.getAno_sol() + " "
					+ aa83bBusqueda.getId_sol());

			aa83bBusqueda.setFechaEnvReq(aa83b09t00Lista.get(i).getfActu009().toString());
			
			//Buscar estado del envio correos, remesa y coleccion
			aa83bBusqueda = buscarSituacionRemesas(aa83bBusqueda, Aa83BConstants.COD_ADE);
			
			responseGrid.add(aa83bBusqueda);
		}
		
		for (int i = 0; i < aa83b10t00Lista.size(); i++) {

			Aa83b23t00 aa83b23t00 = new Aa83b23t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b23t00.setId023(Integer.parseInt(aa83b10t00Lista.get(i).getId023NumSol().toString()));
			aa83b23t00.setIdAno023(aa83b10t00Lista.get(i).getIdAno023());
			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00
					.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_1));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_3));
			aa83b02t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ESF));

			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);
			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase()
					.equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b23t00> aa83b23t00Lista = aa83b23t00Service.findAllLike(
					aa83b23t00, null, null);

			aa83b23t00 = aa83b23t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b23t00.getId023().toString());
			aa83bBusqueda.setAno_sol(aa83b23t00.getIdAno023().toString());
			aa83bBusqueda.setTipoNotificacion(aa83b23t00.getTipoNotificacion023());
			
			aa83bBusqueda.setNombre_sol(aa83b23t00.getNombre023());
			aa83bBusqueda.setApellido1_sol(aa83b23t00.getApel1023());
			aa83bBusqueda.setApellido2_sol(aa83b23t00.getApel1023());

			if (aa83b23t00.getFecha023() != null)
				aa83bBusqueda.setFecha(aa83b23t00.getFecha023());

			aa83bBusqueda.setNumero_dni(aa83b23t00.getNumDoc023());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ESF));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "
					+ aa83bBusqueda.getAno_sol() + " "
					+ aa83bBusqueda.getId_sol());

			aa83bBusqueda.setFechaEnvReq(aa83b10t00Lista.get(i).getfActu010().toString());
			
			//Buscar estado del envio correos, remesa y coleccion
			aa83bBusqueda = buscarSituacionRemesas(aa83bBusqueda, Aa83BConstants.COD_ESF);
			responseGrid.add(aa83bBusqueda);
		}
		
		for (int i = 0; i < aa83b11t00Lista.size(); i++) {
			Aa83b25t00 aa83b25t00 = new Aa83b25t00();
			Aa83bBusqueda aa83bBusqueda = new Aa83bBusqueda();

			aa83b25t00.setId025(Integer.parseInt(aa83b11t00Lista.get(i).getId025NumSol().toString()));
			aa83b25t00.setIdAno025(aa83b11t00Lista.get(i).getIdAnoSol025());

			Aa83b02t00 aa83b02t00 = new Aa83b02t00();
			aa83b02t00
					.setId001Fase(Integer.parseInt(Aa83BConstants.COD_FASE_1));
			aa83b02t00.setId002(Integer.parseInt(Aa83BConstants.COD_TRAM_3));
			aa83b02t00
					.setId003TipoSol(Integer.parseInt(Aa83BConstants.COD_ARR));

			aa83b02t00 = aa83b02t00Service.find(aa83b02t00);

			// Calculo el Estado
			if (Aa83BConstants.LOCALE_ES.toString().toUpperCase()
					.equals(locale.getLanguage().toUpperCase())) {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEs002());
			} else {
				aa83bBusqueda.setEstado(aa83b02t00.getDescEu002());
			}
			List<Aa83b25t00> aa83b25t00Lista = aa83b25t00Service.findAllLike(
					aa83b25t00, null, null);

			aa83b25t00 = aa83b25t00Lista.get(0);

			aa83bBusqueda.setId_sol(aa83b25t00.getId025().toString());
			aa83bBusqueda.setAno_sol(aa83b25t00.getIdAno025().toString());

			aa83bBusqueda.setNombre_sol(aa83b25t00.getNombre025());
			aa83bBusqueda.setApellido1_sol(aa83b25t00.getApel1025());
			aa83bBusqueda.setApellido2_sol(aa83b25t00.getApel1025());
			aa83bBusqueda.setTipoNotificacion(aa83b25t00.getTipoNotificacion025());
			
			if (aa83b25t00.getFecha025() != null)
				aa83bBusqueda.setFecha(aa83b25t00.getFecha025());

			aa83bBusqueda.setNumero_dni(aa83b25t00.getNumDoc025());

			Aa83b03t00 aa83b03t00 = new Aa83b03t00();

			aa83b03t00.setId003(Integer.parseInt(Aa83BConstants.COD_ARR));
			aa83bBusqueda.setTipoSolStrEs(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());
			aa83bBusqueda.setTipoSolStrEu(aa83b03t00Service.find(aa83b03t00)
					.getTipoSol003());

			aa83bBusqueda.setSolConcat(aa83bBusqueda.getTipoSolStrEs() + " "
					+ aa83bBusqueda.getAno_sol() + " "
					+ aa83bBusqueda.getId_sol());

			aa83bBusqueda.setFechaEnvReq(aa83b11t00Lista.get(i).getfActu011().toString());
			
			//Buscar estado del envio correos, remesa y coleccion
			aa83bBusqueda = buscarSituacionRemesas(aa83bBusqueda, Aa83BConstants.COD_ARR);
			responseGrid.add(aa83bBusqueda);
		}
		
		
		int total = 1;

		return new JQGridResponseDto<Aa83bBusqueda>(jqGridRequestDto,
				(long) (total), responseGrid);
	}
	
	public Aa83bBusqueda buscarSituacionRemesas(Aa83bBusqueda aa83bBusqueda, String tipoSol){
		List<Aa83bNotificacionCorreosDatosRemesa> situacion = aa83bNotificacionesCorreosService.buscarSituacionRemesa(aa83bBusqueda.getId_sol(), aa83bBusqueda.getAno_sol(), tipoSol);
		if(situacion.isEmpty()){
			aa83bBusqueda.setEstadoEnvio("");
			aa83bBusqueda.setEstadoEnvio_Es("");
			aa83bBusqueda.setEstadoEnvio_Eu("");
			aa83bBusqueda.setRemesaColeccion("");
		}else{
		
			StringBuffer str= new StringBuffer();//Recoge el idRemesa, codigo_remesa y codigo_coleccion
			str.append(situacion.get(0).getIdRemesa());
			str.append("-");
			str.append(situacion.get(0).getCodigoRemesa());
			str.append(" - ");
			str.append(situacion.get(0).getIdColeccion());
			aa83bBusqueda.setEstadoEnvio(situacion.get(0).getDescripcionES());
			aa83bBusqueda.setEstadoEnvio_Es(situacion.get(0).getDescripcionES());
			aa83bBusqueda.setEstadoEnvio_Eu(situacion.get(0).getDescripcionEU());
			aa83bBusqueda.setRemesaColeccion(str.toString());
		
		}
		return aa83bBusqueda;
		
	}
	

}