package com.ejie.aa83b.control;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa83b.exception.Aa83bErrorGenericoException;
import com.ejie.aa83b.model.A83bMunicipio;
import com.ejie.aa83b.model.A83bPais;
import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83b12t00;
import com.ejie.aa83b.model.Aa83b17t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83b30t00;
import com.ejie.aa83b.model.Aa83b33t00;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.model.Aa83b35t00;
import com.ejie.aa83b.model.Aa83b39t00;
import com.ejie.aa83b.service.Aa83b12t00Service;
import com.ejie.aa83b.service.Aa83b17t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83b30t00Service;
import com.ejie.aa83b.service.Aa83b33t00Service;
import com.ejie.aa83b.service.Aa83b34t00Service;
import com.ejie.aa83b.service.Aa83b35t00Service;
import com.ejie.aa83b.service.Aa83b39t00Service;
import com.ejie.aa83b.service.Aa83bARRService;
import com.ejie.aa83b.service.Aa83bNoraService;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bSesionUtils;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContext;
import com.ejie.aa83b.util.tramita.Aa83bConsultationContextParser;
import com.ejie.aa83b.util.tramita.Aa83bXmlException;
import com.ejie.aa83b.util.xml.Aa83bXMLGenerator;
import com.ejie.aa83b.webservice.client.r02.Q99RCPFacadeWSSoap;
import com.ejie.aa83b.webservice.client.r02.vdc.Q99USendMessageSCPFacadeWSSoap;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * @author blarreina
 *
 */
@Controller()
@RequestMapping(value = "/altaARR")
public class Aa83bAltaSolicitudARRController {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bAltaSolicitudADEController.class);
	
	/** The service. */
	@Autowired()
	private Aa83b25t00Service aa83b25t00Service;

	@Autowired()
	private Aa83b35t00Service aa83b35t00Service;

	@Autowired()
	private Aa83b30t00Service aa83b30t00Service;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Aa83b34t00Service aa83b34t00Service;
	
	@Autowired
	private Aa83b33t00Service aa83b33t00Service;
	
	@Autowired
	private Aa83bARRService aa83bARRService;
	
	/** The service. */
	@Autowired()
	private Aa83bNoraService aa83bNoraService;
	
	@Autowired()
	private Aa83b12t00Service aa83b12t00Service;
	
	@Autowired()
	private Aa83b39t00Service aa83b39t00Service;
	
	@Autowired()
	private Aa83b17t00Service aa83b17t00Service;
	
	@Autowired()
	private Q99USendMessageSCPFacadeWSSoap q99uSendMessageSCPFacadeWSSoap;

	@Autowired()
	private Q99RCPFacadeWSSoap q99RCPFacadeWSSoap;
	
	/** The Constant logger. */
	// private static final Logger logger = LoggerFactory
	// .getLogger(Aa83b03t00Controller.class);

	@RequestMapping(value = "/edit/{id025}", method = RequestMethod.GET)
	public @ResponseBody
	String searchID(Model model)
	// (@RequestJsonBody(param = "filter") Busqueda filterBusqueda)
	// @RequestJsonBody JQGridRequestDto jqGridRequestDto)
	{

		return "altaSolARR";
	}

	/*
	 * @RequestMapping(value = "solicitud", method = RequestMethod.POST,
	 * produces = "application/json") public @ResponseBody Object
	 * buscaSolicitud(
	 * 
	 * @RequestParam(value = "tipoSol", required = false) String comboTipoSol,
	 * 
	 * @RequestParam(value = "numero_sol", required = false) String numero_sol,
	 * HttpServletResponse response) throws IOException {
	 * 
	 * }
	 */

	/*
	 * @RequestMapping(method = RequestMethod.POST) public @ResponseBody
	 * Aa83b21t00 add(@RequestBody Aa83b21t00 aa83b21t00) { Aa83b21t00
	 * aa83b21t00Aux = this.aa83b21t00Service.add(aa83b21t00);
	 * Aa83b21t00Controller
	 * .logger.info("[POST] : Aa83b21t00 insertado correctamente"); return
	 * aa83b21t00Aux; }
	 */

	@RequestMapping(value = "/alta", method = RequestMethod.POST)
	public @ResponseBody
	Aa83b25t00 altaARR(@ModelAttribute Aa83b25t00 aa83b25t00,
			HttpServletResponse response, HttpServletRequest request,
			ModelMap model) throws IOException, Aa83bXmlException, Aa83bErrorGenericoException, ParseException {
		Aa83b25t00 aa83b25t00New = new Aa83b25t00();
		
		String procedure = "";
		String sesionToken = Aa83bSesionUtils.getTokenXLNets("aa83b");
		String idProcedimiento = this.appConfiguration.getProperty("procedure.arraigo.id");
		Aa83bConsultationContextParser resParser = new Aa83bConsultationContextParser();
		Aa83bConsultationContext res;
		
		// llamada al getProcedureFac para recuperar los datos del
		// procedimiento

		try{
			procedure = this.q99RCPFacadeWSSoap.getProcedureFac(sesionToken, idProcedimiento);
			resParser = new Aa83bConsultationContextParser(procedure);
								
			
		}catch (Exception e) {
			// TODO Auto-generated catch block
		//	Aa83bBusquedaComunicacionesController.logger.info("[Aa83bBusquedaComunicacionesController] generarAdjuntoRemito: EXCEPCION getProcedureFac: ="+ e.toString());
			logger.error(e.getMessage());
		}
		res = resParser.getProcedureDataAll();
		
		aa83b25t00New=aa83bARRService.add(aa83b25t00,res.getDocumentalSeriesId());
		
		Aa83b33t00 adjunto = new Aa83b33t00();
		List<Aa83b33t00> listaAdjuntos=aa83b25t00New.getAa83b33t00s();
		adjunto.setId025NumSol(aa83b25t00New.getId025().intValue());
		adjunto.setIdAno025(aa83b25t00New.getIdAno025().longValue());
		List<Aa83b33t00> aa83b33t00List = new ArrayList<Aa83b33t00>();
		aa83b33t00List = aa83b33t00Service.findAllLike(adjunto, null, false);
		logger.info("listaAdjuntos-->"+ aa83b33t00List);
		adjunto = new Aa83b33t00();
		for (int i=0; i <aa83b33t00List.size();i++)
		{
			 adjunto= aa83b33t00List.get(i);
			 logger.info("adjunto-->"+ adjunto);
			 
			if (adjunto.getId030TipDocSol().equals(Integer.getInteger("38")))
			{
				break;
			}
		}
		
		Aa83bXMLGenerator aa83bXMLGenerator = Aa83bXMLGenerator.getInstance();
		aa83b25t00New=aa83b25t00Service.findIdsNora(aa83b25t00New);
		
		String expediente= aa83bXMLGenerator.generarXmlInitExpedient(null, null, aa83b25t00New, res, idProcedimiento, null, null,adjunto);
		
		logger.info("*********** expediente-->"+ expediente);
		q99uSendMessageSCPFacadeWSSoap.sendMessageSC(sesionToken, expediente, "initExpedientNT");
		
		
		return aa83b25t00New;
	}

	/**
	 * @param aa83b25t00 Aa83b25t00
	 * @param response HttpServletResponse
	 * @param request HttpServletRequest
	 * @return Aa83b25t00
	 * @throws IOException e
	 */
	@RequestMapping(value = "/modif", method = RequestMethod.POST)
	public @ResponseBody()
	Aa83b25t00 modifARR(@ModelAttribute() Aa83b25t00 aa83b25t00,
			HttpServletResponse response, HttpServletRequest request)
			throws IOException { 
		String valorResolucion = (String) request.getParameter("valorResolucion");
		aa83b25t00.setResolFavorable025(Integer.parseInt(valorResolucion));
		
		aa83b25t00=this.aa83bARRService.update(aa83b25t00);
		return aa83b25t00;
	}

	@RequestMapping(value = "/paginaARREOK", method = RequestMethod.GET)
	public String getFormEdit2(Model model) {

		return "paginaARROK";
	}

	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		return "altaSolARR";
	}

	@RequestMapping(value = "/nuevaPapel0", method = RequestMethod.GET)
	public ModelAndView nuevaPapel0(Model model,
			@RequestParam(value = "id", required = false) String idSol,
			HttpServletResponse response) {
		
		Aa83b25t00 solicitud = new Aa83b25t00();
		solicitud.setCodSolicitud034(new Long(idSol));
		Aa83b34t00 papel0 = new Aa83b34t00();
		papel0.setCodsolic034(new Long(idSol));
		papel0 = aa83b34t00Service.find(papel0);
		
		Aa83b35t00 documentos = new Aa83b35t00();
		documentos.setAa83b34t00(papel0);
		List<Aa83b35t00> listaDocs = aa83b35t00Service
				.findAll(documentos, null);// aki tenemos los oids
		List<Aa83b33t00> lista = solicitud.getAa83b33t00s();
		for (int i = 0; i < listaDocs.size(); i++) {
			Aa83b33t00 documento = new Aa83b33t00();
			documento.setOid033Papel0(((Aa83b35t00) listaDocs.get(i))
					.getOid035());
			documento.setId030TipDocSol(-1);// xa saber que son nuevos
			lista.add(documento);
		}
		solicitud.setIdAno025(papel0.getNumano034());
		solicitud.setNumReg025(papel0.getNumreg034());

		String fecha = papel0.getFregistro034().toString();

		String fecha4[] = fecha.split("-");
		String fecha2 = fecha4[2] + "/" + fecha4[1] + "/" + fecha4[0];
		solicitud.setFecha025(fecha2);
		solicitud.setEstado_desc_es(papel0.getTramite034Es());

		solicitud.setAa83b33t00s(lista);
		solicitud.setRuta(this.appConfiguration
				.getProperty("tempFicheros.path") + "/");
		Aa83b30t00 documento = new Aa83b30t00();
		String tipoSol = Aa83BConstants.COD_ARR;
		documento.setId003TipoSol(new Integer(tipoSol));
		List<Aa83b30t00> listaTiposDoc = aa83b30t00Service.findAllLike(
				documento, null, true);
		int posicionMaxima = (listaTiposDoc.get(listaTiposDoc.size() - 1))
				.getId030();
		String[] listaTodos = new String[posicionMaxima + 1];
		// recorremos el nuevo y vamos metiendo el de los tipos
		listaTodos = Aa83bUtilidades.cargarTiposSolicitud(listaTodos,
				listaTiposDoc);
		solicitud.setAa83b30t00s(listaTiposDoc);
		solicitud.setTiposOrdenados(listaTodos);
		solicitud.setAccion(Aa83BConstants.ACC_SOL_ALTA);
		solicitud.setPapel0 ("1");
		
		Locale locale = LocaleContextHolder.getLocale();
		String localeCapitalized = WordUtils.capitalize(locale.getLanguage());
		model.addAttribute("labelTipoDocumentos", "desc" + localeCapitalized + "012");
		List<Aa83b12t00> tipoDocumentos = aa83b12t00Service.findAllActive(null, null);
		model.addAttribute("tipoDocumentos", tipoDocumentos);
		
		model.addAttribute("labelTipoNotificacion", "desc" + localeCapitalized + "039");
		List<Aa83b39t00> tipoNotificaciones = aa83b39t00Service.findAll(null, null);
		model.addAttribute("tipoNotificaciones", tipoNotificaciones);
		
		model.addAttribute("labelGenero", "desc" + localeCapitalized + "017");
		List<Aa83b17t00> generos = aa83b17t00Service.findAll(null, null);
		model.addAttribute("generos", generos);
						
		List<A83bPais> paises = aa83bNoraService.findPaises(null, null);
		model.addAttribute("paises", paises);
		
		A83bProvincia provincia = new A83bProvincia();
		provincia.setAutonomia_id(Aa83BConstants.COD_COM_EUS);
		List<A83bProvincia> provincias = aa83bNoraService.findProvincias(provincia, null);
		model.addAttribute("provincias", provincias);
				
		A83bMunicipio municipioComunic = new A83bMunicipio();
		municipioComunic.setDs_o("");
		municipioComunic.setId(solicitud.getMunicipComunic025());
		String provComunicSolicitud = solicitud.getProvinciaComunic025();
		if (provComunicSolicitud == null || provComunicSolicitud.equals("0")) {
			provComunicSolicitud = ((A83bProvincia)provincias.get(0)).getId();
		}
		municipioComunic.setProvincia_id(provComunicSolicitud);
		List<A83bMunicipio> municipiosComunic = aa83bNoraService.findMunicipios(municipioComunic, null);
		model.addAttribute("municipiosComunic", municipiosComunic);
		
		A83bMunicipio localidadEmpad = new A83bMunicipio();
		localidadEmpad.setDs_o("");
		localidadEmpad.setId(solicitud.getLocalidadEmp025());
		String provEmpSolicitud = solicitud.getProvEmp025();
		if (provEmpSolicitud == null || provEmpSolicitud.equals("0")) {
			provEmpSolicitud = ((A83bProvincia)provincias.get(0)).getId();
		}
		localidadEmpad.setProvincia_id(provEmpSolicitud);
		List<A83bMunicipio> localidadesEmpad = aa83bNoraService.findMunicipios(localidadEmpad, null);
		model.addAttribute("localidadesEmpad", localidadesEmpad);
		
		A83bMunicipio localidadExped = new A83bMunicipio();
		localidadExped.setDs_o("");
		localidadExped.setId(solicitud.getMunicipioEmpadron025());
		String provExpedSolicitud = solicitud.getProvinciaEmpadron025();
		if (provExpedSolicitud == null || provExpedSolicitud.equals("0")) {
			provExpedSolicitud = ((A83bProvincia)provincias.get(0)).getId();
		}
		localidadExped.setProvincia_id(provExpedSolicitud);
		List<A83bMunicipio> localidadesExped = aa83bNoraService.findMunicipios(localidadExped, null);
		model.addAttribute("localidadesExped", localidadesExped);
		
		return new ModelAndView("altaSolARR", "Aa83b25t00", solicitud);
		// return "altaSolADE";
	}

	@RequestMapping(value = "/accederAlta", method = RequestMethod.GET)
	public ModelAndView accederAlta(Model model, HttpServletResponse response) {
		Aa83b25t00 solicitud = new Aa83b25t00();
		Aa83b30t00 documento = new Aa83b30t00();
		String tipoSol = Aa83BConstants.COD_ARR;
		documento.setId003TipoSol(new Integer(tipoSol));
		List<Aa83b30t00> listaTiposDoc = aa83b30t00Service.findAllLike(
				documento, null, true);
		int posicionMaxima = (listaTiposDoc.get(listaTiposDoc.size() - 1))
				.getId030();
		String[] listaTodos = new String[posicionMaxima + 1];
		// recorremos el nuevo y vamos metiendo el de los tipos
		listaTodos = Aa83bUtilidades.cargarTiposSolicitud(listaTodos,
				listaTiposDoc);
		solicitud.setAa83b30t00s(listaTiposDoc);
		solicitud.setTiposOrdenados(listaTodos);
		return new ModelAndView("altaSolARR", "Aa83b25t00", solicitud);
		// return "altaSolADE";
	}

	/**
	 * @param q String
	 * @param c Boolean
	 * @return Aa83b25t00
	 */
	@RequestMapping(value = "autocomplete/remote", produces = "application/json", method = RequestMethod.GET)
	public @ResponseBody()
	Aa83b25t00 buscarPorDni(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {
		Aa83b25t00 aa83b25t00 = new Aa83b25t00();
		aa83b25t00.setNumDoc025(q);
		List<Aa83b25t00> prueba = this.aa83b25t00Service.findAllLike(aa83b25t00,
				null, c);
		if (prueba.size() == 0) {
			aa83b25t00.setNombre025("No existe");
			prueba.add(aa83b25t00);
		}
		return prueba.get(0);
	}

	/**
	 * @param q String
	 * @return JQGridResponseDto<Aa83b25t00>
	 */
	@RequestMapping(value = "tablaDNI/remote", produces = "application/json", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<Aa83b25t00> buscarPorDniTabla(
			@RequestParam(value = "q", required = true) String q
	// ,@RequestJsonBody JQGridRequestDto jqGridRequestDto
	) {

		int maxRows = Aa83BConstants.NUEVE;
		Long contaRows = new Long(0);
		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		String dni = q.replace("/filter", "");
		Aa83b25t00 aa83b25t00 = new Aa83b25t00();
		aa83b25t00.setNumDoc025(dni);
		JQGridResponseDto<Aa83b25t00> prueba = this.aa83b25t00Service.filter(aa83b25t00, jqGridRequestDto, false);
		JQGridResponseDto<Aa83b25t00> filterInt = new JQGridResponseDto<Aa83b25t00>();

		Aa83b25t00 aa83b25t00End = new Aa83b25t00();
		List<Aa83b25t00> aa83b25t00List = new ArrayList<Aa83b25t00>();
		for (int i = 0; ((i < prueba.getRows().size()) && (i < maxRows)); i++) {
			aa83b25t00End = (Aa83b25t00) prueba.getRows().get(i);
			aa83b25t00List.add(aa83b25t00End);
			contaRows++;
		}
		filterInt.setRows(aa83b25t00List);
		Long total = new Long(1);
		Long rows = new Long(1);
		filterInt.setPage("1");
		// filterInt.setRecords(aa83b21t00List.size());
		filterInt.setTotal(total, rows);
		return filterInt;
	}
}
