package com.ejie.aa83b.control;

import com.ejie.aa83b.service.Aa83b41t00Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa83b.model.Aa83b41t00;

/**
 * Aa83b41t00Controller generated by UDA, 02-may-2016 17:06:26.
 * @author UDA
 */
 
@Controller
@RequestMapping (value = "/aa83b41t00")

public class Aa83b41t00Controller  {

	private static final Logger logger = LoggerFactory.getLogger(Aa83b41t00Controller.class);

	@Autowired
	private Aa83b41t00Service aa83b41t00Service;
	
	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */
	
	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
	 * 
	 * @param idCodOid041 String
	 * @param descEs041 String
	 * @param descEu041 String
	 * @param idCod037 Integer
	 * @param metaInf041 String
	 * @return Aa83b41t00 
	 *            Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idCodOid041}/{descEs041}/{descEu041}/{idCod037}/{metaInf041}", method = RequestMethod.GET)
	public @ResponseBody Aa83b41t00 get(@PathVariable String idCodOid041, @PathVariable String descEs041, @PathVariable String descEu041, @PathVariable Integer idCod037, @PathVariable String metaInf041) {
        Aa83b41t00 aa83b41t00 = new Aa83b41t00();
		aa83b41t00.setIdCodOid041(idCodOid041);
		aa83b41t00.setDescEs041(descEs041);
		aa83b41t00.setDescEu041(descEu041);
		aa83b41t00.setIdCod037(idCod037);
		aa83b41t00.setMetaInf041(metaInf041);
        aa83b41t00 = this.aa83b41t00Service.find(aa83b41t00);
        Aa83b41t00Controller.logger.info("[GET - findBy_PK] : Obtener Aa83b41t00 por PK");
        return aa83b41t00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterAa83b41t00 Aa83b41t00
	 *            Objeto que contiene los parametros de filtrado utilizados en
	 *            la busqueda.
	 * @return List<Aa83b41t00> 
	 *            Lista de objetos correspondientes a la busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Aa83b41t00> getAll(@ModelAttribute Aa83b41t00 filterAa83b41t00) {
		Aa83b41t00Controller.logger.info("[GET - find_ALL] : Obtener Aa83b41t00 por filtro");
	    return this.aa83b41t00Service.findAll(filterAa83b41t00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param aa83b41t00 Aa83b41t00 
	 *            Bean que contiene la informacion a modificar.
	 * @return Aa83b41t00 
	 *            Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Aa83b41t00 edit(@RequestBody Aa83b41t00 aa83b41t00) {		
        Aa83b41t00 aa83b41t00Aux = this.aa83b41t00Service.update(aa83b41t00);
		Aa83b41t00Controller.logger.info("[PUT] : Aa83b41t00 actualizado correctamente");
        return aa83b41t00Aux;
    }

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param aa83b41t00 Aa83b41t00 
	 *            Bean que contiene la informacion con la que se va a crear el
	 *            nuevo registro.
	 * @return Aa83b41t00
	 *            Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Aa83b41t00 add(@RequestBody Aa83b41t00 aa83b41t00) {		
        Aa83b41t00 aa83b41t00Aux = this.aa83b41t00Service.add(aa83b41t00);
        Aa83b41t00Controller.logger.info("[POST] : Aa83b41t00 insertado correctamente");
    	return aa83b41t00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idCodOid041 String
	 * @param descEs041 String
	 * @param descEu041 String
	 * @param idCod037 Integer
	 * @param metaInf041 String
	 *            Identificador del objeto que se desea eliminar.
	 * @return Aa83b41t00
	 *            Bean eliminado.
	 */
	@RequestMapping(value = "/{idCodOid041}/{descEs041}/{descEu041}/{idCod037}/{metaInf041}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Aa83b41t00 remove(@PathVariable String idCodOid041, @PathVariable String descEs041, @PathVariable String descEu041, @PathVariable Integer idCod037, @PathVariable String metaInf041) {
        Aa83b41t00 aa83b41t00 = new Aa83b41t00();
        aa83b41t00.setIdCodOid041(idCodOid041);
        aa83b41t00.setDescEs041(descEs041);
        aa83b41t00.setDescEu041(descEu041);
        aa83b41t00.setIdCod037(idCod037);
        aa83b41t00.setMetaInf041(metaInf041);
        this.aa83b41t00Service.remove(aa83b41t00);
       	Aa83b41t00Controller.logger.info("[DELETE] : Aa83b41t00 borrado correctamente");
       	return aa83b41t00;
    }
    
	
	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	 /**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b41t00Controller.logger.info("[GET - View] : aa83b41t00");
		return "aa83b41t00";
	}
	 
	 /**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b41t00 Aa83b41t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b41t00>
	 *            Dto que contiene el resultado del filtrado realizado por el 
	 *            componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa83b41t00> filter(
			@RequestJsonBody(param="filter") Aa83b41t00 filterAa83b41t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b41t00Controller.logger.info("[POST - filter] : Obtener Aa83b41t00s");
		return this.aa83b41t00Service.filter(filterAa83b41t00, jqGridRequestDto, false);
	}
	 
	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa83b41t00 Aa83b41t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param searchAa83b41t00 Aa83b41t00
	 *            Bean que contiene los parametros de busqueda a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa83b41t00> 
	 *            Dto que contiene el resultado de la busqueda realizada por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<Aa83b41t00>> search(
			@RequestJsonBody(param="filter") Aa83b41t00 filterAa83b41t00,
			@RequestJsonBody(param="search") Aa83b41t00 searchAa83b41t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b41t00Controller.logger.info("[POST - search] : Buscar Aa83b41t00s");
		return this.aa83b41t00Service.search(filterAa83b41t00, searchAa83b41t00, jqGridRequestDto, false);
	}
	
	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa83b41t00 Aa83b41t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String>
	 *            Lista de los identificadores de los registros eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param="filter") Aa83b41t00 filterAa83b41t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b41t00Controller.logger.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa83b41t00s");
		this.aa83b41t00Service.removeMultiple(filterAa83b41t00, jqGridRequestDto, false);
		Aa83b41t00Controller.logger.info("All entities correctly deleted!");
		
		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}
	
	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */
	
	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa83b41t00 Aa83b41t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b41t00>>
	 *            Dto que contiene el resultado del filtrado realizado por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa83b41t00>> jerarquia(
			@RequestJsonBody(param="filter") Aa83b41t00 filterAa83b41t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b41t00Controller.logger.info("[POST - jerarquia] : Obtener Aa83b41t00s jerarquia");
		return this.aa83b41t00Service.jerarquia(filterAa83b41t00, jqGridRequestDto, false);
	}
	
	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion jerarquica.
	 * 
	 * @param filterAa83b41t00 Aa83b41t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b41t00>>
	 *            Dto que contiene el resultado del filtrado realizado por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa83b41t00>> jerarquiaChildren(
			@RequestJsonBody(param="filter") Aa83b41t00  filterAa83b41t00 ,
			@RequestJsonBody JQGridRequestDto  jqGridRequestDto) {
		Aa83b41t00Controller.logger.info("[POST - jerarquia] : Obtener Aa83b41t00s jerarquia - Hijos");
		return this.aa83b41t00Service.jerarquiaChildren(filterAa83b41t00, jqGridRequestDto);
	}
	
}	
