package com.ejie.aa83b.control;

import com.ejie.aa83b.service.Aa83b37t00Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa83b.model.Aa83b37t00;

/**
 * Aa83b37t00Controller generated by UDA, 05-may-2016 17:50:09.
 * @author UDA
 */
 
@Controller
@RequestMapping (value = "/aa83b37t00")

public class Aa83b37t00Controller  {

	private static final Logger logger = LoggerFactory.getLogger(Aa83b37t00Controller.class);

	@Autowired
	private Aa83b37t00Service aa83b37t00Service;
	
	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */
	
	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
	 * 
	 * @param id037 Integer
	 * @param tipoSol037 String
	 * @param numano037 Long
	 * @param flectura037 Date
	 * @param jmsid037 String
	 * @param numreg037 String
	 * @param fregistro037 Date
	 * @param codfase037 String
	 * @param codtra037 String
	 * @param remitenteNom037 String
	 * @param situacion037 String
	 * @param remitenteId037 String
	 * @param solRelac String
	 * @return Aa83b37t00 
	 *            Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{id037}/{tipoSol037}/{numano037}/{flectura037}/{jmsid037}/{numreg037}/{fregistro037}/{codfase037}/{codtra037}/{remitenteNom037}/{situacion037}/{remitenteId037}/{solRelac}", method = RequestMethod.GET)
	public @ResponseBody Aa83b37t00 get(@PathVariable Integer id037, @PathVariable String tipoSol037, @PathVariable Long numano037, @PathVariable Date flectura037, @PathVariable String jmsid037, @PathVariable String numreg037, @PathVariable Date fregistro037, @PathVariable String codfase037, @PathVariable String codtra037, @PathVariable String remitenteNom037, @PathVariable String situacion037, @PathVariable String remitenteId037, @PathVariable String solRelac) {
        Aa83b37t00 aa83b37t00 = new Aa83b37t00();
		aa83b37t00.setId037(id037);
		aa83b37t00.setTipoSol037(tipoSol037);
		aa83b37t00.setNumano037(numano037);
		aa83b37t00.setFlectura037(flectura037);
		aa83b37t00.setJmsid037(jmsid037);
		aa83b37t00.setNumreg037(numreg037);
		aa83b37t00.setFregistro037(fregistro037);
		aa83b37t00.setCodfase037(codfase037);
		aa83b37t00.setCodtra037(codtra037);
		aa83b37t00.setRemitenteNom037(remitenteNom037);
		aa83b37t00.setSituacion037(situacion037);
		aa83b37t00.setRemitenteId037(remitenteId037);
		aa83b37t00.setSolRelac(solRelac);
        aa83b37t00 = this.aa83b37t00Service.find(aa83b37t00);
        Aa83b37t00Controller.logger.info("[GET - findBy_PK] : Obtener Aa83b37t00 por PK");
        return aa83b37t00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterAa83b37t00 Aa83b37t00
	 *            Objeto que contiene los parametros de filtrado utilizados en
	 *            la busqueda.
	 * @return List<Aa83b37t00> 
	 *            Lista de objetos correspondientes a la busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Aa83b37t00> getAll(@ModelAttribute Aa83b37t00 filterAa83b37t00) {
		Aa83b37t00Controller.logger.info("[GET - find_ALL] : Obtener Aa83b37t00 por filtro");
	    return this.aa83b37t00Service.findAll(filterAa83b37t00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param aa83b37t00 Aa83b37t00 
	 *            Bean que contiene la informacion a modificar.
	 * @return Aa83b37t00 
	 *            Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Aa83b37t00 edit(@RequestBody Aa83b37t00 aa83b37t00) {		
        Aa83b37t00 aa83b37t00Aux = this.aa83b37t00Service.update(aa83b37t00);
		Aa83b37t00Controller.logger.info("[PUT] : Aa83b37t00 actualizado correctamente");
        return aa83b37t00Aux;
    }

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param aa83b37t00 Aa83b37t00 
	 *            Bean que contiene la informacion con la que se va a crear el
	 *            nuevo registro.
	 * @return Aa83b37t00
	 *            Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Aa83b37t00 add(@RequestBody Aa83b37t00 aa83b37t00) {		
        Aa83b37t00 aa83b37t00Aux = this.aa83b37t00Service.add(aa83b37t00);
        Aa83b37t00Controller.logger.info("[POST] : Aa83b37t00 insertado correctamente");
    	return aa83b37t00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param id037 Integer
	 * @param tipoSol037 String
	 * @param numano037 Long
	 * @param flectura037 Date
	 * @param jmsid037 String
	 * @param numreg037 String
	 * @param fregistro037 Date
	 * @param codfase037 String
	 * @param codtra037 String
	 * @param remitenteNom037 String
	 * @param situacion037 String
	 * @param remitenteId037 String
	 * @param solRelac String
	 *            Identificador del objeto que se desea eliminar.
	 * @return Aa83b37t00
	 *            Bean eliminado.
	 */
	@RequestMapping(value = "/{id037}/{tipoSol037}/{numano037}/{flectura037}/{jmsid037}/{numreg037}/{fregistro037}/{codfase037}/{codtra037}/{remitenteNom037}/{situacion037}/{remitenteId037}/{solRelac}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Aa83b37t00 remove(@PathVariable Integer id037, @PathVariable String tipoSol037, @PathVariable Long numano037, @PathVariable Date flectura037, @PathVariable String jmsid037, @PathVariable String numreg037, @PathVariable Date fregistro037, @PathVariable String codfase037, @PathVariable String codtra037, @PathVariable String remitenteNom037, @PathVariable String situacion037, @PathVariable String remitenteId037, @PathVariable String solRelac) {
        Aa83b37t00 aa83b37t00 = new Aa83b37t00();
        aa83b37t00.setId037(id037);
        aa83b37t00.setTipoSol037(tipoSol037);
        aa83b37t00.setNumano037(numano037);
        aa83b37t00.setFlectura037(flectura037);
        aa83b37t00.setJmsid037(jmsid037);
        aa83b37t00.setNumreg037(numreg037);
        aa83b37t00.setFregistro037(fregistro037);
        aa83b37t00.setCodfase037(codfase037);
        aa83b37t00.setCodtra037(codtra037);
        aa83b37t00.setRemitenteNom037(remitenteNom037);
        aa83b37t00.setSituacion037(situacion037);
        aa83b37t00.setRemitenteId037(remitenteId037);
        aa83b37t00.setSolRelac(solRelac);
        this.aa83b37t00Service.remove(aa83b37t00);
       	Aa83b37t00Controller.logger.info("[DELETE] : Aa83b37t00 borrado correctamente");
       	return aa83b37t00;
    }
    
	
	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	 /**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa83b37t00Controller.logger.info("[GET - View] : aa83b37t00");
		return "aa83b37t00";
	}
	 
	 /**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa83b37t00 Aa83b37t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa83b37t00>
	 *            Dto que contiene el resultado del filtrado realizado por el 
	 *            componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa83b37t00> filter(
			@RequestJsonBody(param="filter") Aa83b37t00 filterAa83b37t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b37t00Controller.logger.info("[POST - filter] : Obtener Aa83b37t00s");
		return this.aa83b37t00Service.filter(filterAa83b37t00, jqGridRequestDto, false);
	}
	 
	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa83b37t00 Aa83b37t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param searchAa83b37t00 Aa83b37t00
	 *            Bean que contiene los parametros de busqueda a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa83b37t00> 
	 *            Dto que contiene el resultado de la busqueda realizada por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<Aa83b37t00>> search(
			@RequestJsonBody(param="filter") Aa83b37t00 filterAa83b37t00,
			@RequestJsonBody(param="search") Aa83b37t00 searchAa83b37t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b37t00Controller.logger.info("[POST - search] : Buscar Aa83b37t00s");
		return this.aa83b37t00Service.search(filterAa83b37t00, searchAa83b37t00, jqGridRequestDto, false);
	}
	
	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa83b37t00 Aa83b37t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String>
	 *            Lista de los identificadores de los registros eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param="filter") Aa83b37t00 filterAa83b37t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b37t00Controller.logger.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa83b37t00s");
		this.aa83b37t00Service.removeMultiple(filterAa83b37t00, jqGridRequestDto, false);
		Aa83b37t00Controller.logger.info("All entities correctly deleted!");
		
		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}
	
	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */
	
	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa83b37t00 Aa83b37t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b37t00>>
	 *            Dto que contiene el resultado del filtrado realizado por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa83b37t00>> jerarquia(
			@RequestJsonBody(param="filter") Aa83b37t00 filterAa83b37t00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa83b37t00Controller.logger.info("[POST - jerarquia] : Obtener Aa83b37t00s jerarquia");
		return this.aa83b37t00Service.jerarquia(filterAa83b37t00, jqGridRequestDto, false);
	}
	
	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion jerarquica.
	 * 
	 * @param filterAa83b37t00 Aa83b37t00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa83b37t00>>
	 *            Dto que contiene el resultado del filtrado realizado por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa83b37t00>> jerarquiaChildren(
			@RequestJsonBody(param="filter") Aa83b37t00  filterAa83b37t00 ,
			@RequestJsonBody JQGridRequestDto  jqGridRequestDto) {
		Aa83b37t00Controller.logger.info("[POST - jerarquia] : Obtener Aa83b37t00s jerarquia - Hijos");
		return this.aa83b37t00Service.jerarquiaChildren(filterAa83b37t00, jqGridRequestDto);
	}
	
}	
